/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-08-29 03:41:00 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wpge_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=2906 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=90030 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=604 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=156 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_datalist` (
  `url` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `content` longtext NOT NULL,
  `full_content` smallint NOT NULL,
  PRIMARY KEY (`url`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wpge_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=182746 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=2398 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=2719 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_revslider_css` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `hover` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `params` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `advanced` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=MyISAM AUTO_INCREMENT=110 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_revslider_css_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `hover` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `params` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `advanced` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=MyISAM AUTO_INCREMENT=110 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_revslider_layer_animations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_revslider_layer_animations_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_revslider_navigations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `handle` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `css` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `markup` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_revslider_navigations_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `handle` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `css` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `markup` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_revslider_sliders` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `params` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_revslider_sliders_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `params` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_revslider_slides` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `slide_order` int NOT NULL,
  `params` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `layers` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_revslider_slides_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `slide_order` int NOT NULL,
  `params` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `layers` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_revslider_static_slides` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `params` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `layers` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_revslider_static_slides_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `params` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `layers` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=141 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=114 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=141 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_wc_admin_note_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT '0',
  `actioned_text` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonce_action` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `nonce_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=88578 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_admin_notes` (
  `note_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'info',
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=177 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_category_lookup` (
  `category_tree_id` bigint unsigned NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_customer_lookup` (
  `customer_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `username` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_download_log` (
  `download_log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_wc_order_coupon_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `coupon_id` bigint NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_order_product_lookup` (
  `order_item_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_order_stats` (
  `order_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_order_tax_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_product_attributes_lookup` (
  `product_id` bigint NOT NULL,
  `product_or_parent_id` bigint NOT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `term_id` bigint NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  KEY `product_or_parent_id_term_id` (`product_or_parent_id`,`term_id`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_product_meta_lookup` (
  `product_id` bigint NOT NULL,
  `sku` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint DEFAULT '0',
  `tax_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_rate_limits` (
  `rate_limit_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `rate_limit_expiry` bigint unsigned NOT NULL,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_reserved_stock` (
  `order_id` bigint NOT NULL,
  `product_id` bigint NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_webhooks` (
  `webhook_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `delivery_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `topic` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint NOT NULL,
  `failure_count` smallint NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_woocommerce_api_keys` (
  `key_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `description` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `permissions` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `consumer_key` char(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `consumer_secret` char(43) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nonces` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `truncated_key` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_label` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attribute_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_orderby` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_public` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_email` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_woocommerce_log` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint NOT NULL,
  `source` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `context` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_woocommerce_order_itemmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_woocommerce_order_items` (
  `order_item_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `order_item_type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `order_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_woocommerce_payment_tokenmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_woocommerce_payment_tokens` (
  `token_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_woocommerce_sessions` (
  `session_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_expiry` bigint unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_woocommerce_shipping_zone_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint unsigned NOT NULL,
  `location_code` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `location_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_woocommerce_shipping_zone_methods` (
  `zone_id` bigint unsigned NOT NULL,
  `instance_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `method_order` bigint unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_woocommerce_shipping_zones` (
  `zone_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `zone_order` bigint unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_woocommerce_tax_rate_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `location_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_woocommerce_tax_rates` (
  `tax_rate_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint unsigned NOT NULL,
  `tax_rate_compound` int NOT NULL DEFAULT '0',
  `tax_rate_shipping` int NOT NULL DEFAULT '1',
  `tax_rate_order` bigint unsigned NOT NULL,
  `tax_rate_class` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wpge_actionscheduler_actions */
INSERT INTO `wpge_actionscheduler_actions` VALUES("2905", "wc-admin_import_customers", "complete", "2025-08-29 03:39:03", "2025-08-29 03:39:03", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756438743;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756438743;}", "4", "1", "2025-08-29 03:40:15", "2025-08-29 03:40:15", "0", NULL);

/* INSERT TABLE DATA: wpge_actionscheduler_groups */
INSERT INTO `wpge_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wpge_actionscheduler_groups` VALUES("2", "woocommerce-db-updates");
INSERT INTO `wpge_actionscheduler_groups` VALUES("3", "wc_update_product_lookup_tables");
INSERT INTO `wpge_actionscheduler_groups` VALUES("4", "wc-admin-data");

/* INSERT TABLE DATA: wpge_actionscheduler_logs */
INSERT INTO `wpge_actionscheduler_logs` VALUES("601", "2905", "acción creada", "2025-08-29 03:38:58", "2025-08-29 03:38:58");
INSERT INTO `wpge_actionscheduler_logs` VALUES("602", "2905", "acción empezada vía WP Cron", "2025-08-29 03:40:15", "2025-08-29 03:40:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("603", "2905", "acción completa vía WP Cron", "2025-08-29 03:40:15", "2025-08-29 03:40:15");

/* INSERT TABLE DATA: wpge_commentmeta */
INSERT INTO `wpge_commentmeta` VALUES("155", "47", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("154", "47", "rating", "3");
INSERT INTO `wpge_commentmeta` VALUES("153", "46", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("152", "46", "rating", "1");
INSERT INTO `wpge_commentmeta` VALUES("151", "45", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("150", "45", "rating", "1");
INSERT INTO `wpge_commentmeta` VALUES("149", "44", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("148", "44", "rating", "4");
INSERT INTO `wpge_commentmeta` VALUES("147", "43", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("146", "43", "rating", "2");
INSERT INTO `wpge_commentmeta` VALUES("145", "42", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("144", "42", "rating", "4");

/* INSERT TABLE DATA: wpge_comments */
INSERT INTO `wpge_comments` VALUES("46", "2635", "* * * Apple iPhone 15 Free: https://www.personalportnoy.com/upload/169kg5.php * * * hs=ef42d1c37602849486c5689ad8a22cb5*", "okebepu@merepost.com", "", "185.220.101.54", "2024-08-02 14:22:40", "2024-08-02 14:22:40", "3wdy60", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36", "review", "0", "0");
INSERT INTO `wpge_comments` VALUES("47", "2646", "apesiat", "BruiliGal@mailport.lat", "", "37.139.53.191", "2024-08-07 22:31:17", "2024-08-07 22:31:17", "Complete occlusion of the aortopulmonary septal defect with an Amplatzer Duct Occluder <a href=\"https://cialis.lat/discover-the-best-prices-for-cialis\" rel=\"nofollow ugc\">buy generic cialis online cheap</a> Among these SERMs, raloxifene may be the most attractive agent based on the evidence from five recent large trials Multiple Outcomes of Raloxifene Evaluation MORE, Continuing Outcomes Relevant to Evista CORE, Raloxifene Use for the Heart RUTH, Study of Tamoxifen and Raloxifene STAR, and Evista Versus Alendronate EVA", "0", "0", "Mozilla/5.0 (Windows NT 10.0.0; Win64; x64; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.6367.78 Chrome/124.0.6367.78 Not-A.Brand/99  Safari/537.36", "review", "0", "0");
INSERT INTO `wpge_comments` VALUES("45", "2648", "* * * Apple iPhone 15 Free: https://www.bonjourlesenfants.net/upload/04oytb.php * * * hs=b8222f75fa06958802ec8b01e874e7c1*", "okebepu@merepost.com", "", "87.118.116.90", "2024-08-02 14:22:23", "2024-08-02 14:22:23", "kdb2fl", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36", "review", "0", "0");
INSERT INTO `wpge_comments` VALUES("43", "2642", "PreelaLat", "BeareeFuh@newonlinemail.xyz", "", "46.161.11.4", "2022-05-18 10:21:10", "2022-05-18 10:21:10", "Buy Diflucan Without No Perscription Sywhrh https://newfasttadalafil.com/ - generic cialis 20mg Cytotec Vaginal <a href=\"https://newfasttadalafil.com/\" / rel=\"nofollow ugc\">canadian pharmacy cialis</a> Ompiet Cialis Sicuro Online Amoxicillin Mexico https://newfasttadalafil.com/ - cialis prescription online", "0", "0", "Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36", "review", "0", "0");
INSERT INTO `wpge_comments` VALUES("44", "2646", "Leasiabig", "Leasiabig@maill1.xyz", "", "46.161.11.144", "2022-06-02 22:46:22", "2022-06-02 22:46:22", "https://newfasttadalafil.com/ - Cialis cialis canadian generic <a href=\"https://newfasttadalafil.com/\" / rel=\"nofollow ugc\">cialis on sale in usa</a> Doxycycline Malaria Buy Online how long after cialis exercise https://newfasttadalafil.com/ - generic cialis no prescription", "0", "0", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36 Edg/90.0.818.42", "review", "0", "0");
INSERT INTO `wpge_comments` VALUES("42", "2635", "PreelaLat", "BeareeFuh@newonlinemail.xyz", "", "46.161.11.4", "2022-05-17 13:59:46", "2022-05-17 13:59:46", "https://newfasttadalafil.com/ - discount cialis Priligy 30 Mg Presentacion Lzjsuv <a href=\"https://newfasttadalafil.com/\" / rel=\"nofollow ugc\">Cialis</a> Amoxicillin Dosage For Dog Viplgr Viagra 100mg Filmtabletten Gunstig https://newfasttadalafil.com/ - Cialis Comprar Cialis Online Opiniones", "0", "0", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36", "review", "0", "0");

/* INSERT TABLE DATA: wpge_duplicator_packages */
INSERT INTO `wpge_duplicator_packages` VALUES("1", "20250829_imertec", "32879aa11d1b12916489_20250829034052", "21", "2025-08-29 03:41:00", "admin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-08-29 03:40:52\";s:7:\"Version\";s:8:\"1.5.13.1\";s:9:\"VersionWP\";s:6:\"5.8.11\";s:9:\"VersionDB\";s:5:\"8.4.6\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:16:\"20250829_imertec\";s:4:\"Hash\";s:35:\"32879aa11d1b12916489_20250829034052\";s:8:\"NameHash\";s:52:\"20250829_imertec_32879aa11d1b12916489_20250829034052\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:62:\"20250829_imertec_32879aa11d1b12916489_20250829034052_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.4\";s:6:\"WPUser\";s:5:\"admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:1;s:4:\"File\";s:64:\"20250829_imertec_32879aa11d1b12916489_20250829034052_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:26:\"/home/imertecc/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:0;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:0;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-08-29 03:40:52\";s:7:\"Version\";s:8:\"1.5.13.1\";s:9:\"VersionWP\";s:6:\"5.8.11\";s:9:\"VersionDB\";s:5:\"8.4.6\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:16:\"20250829_imertec\";s:4:\"Hash\";s:35:\"32879aa11d1b12916489_20250829034052\";s:8:\"NameHash\";s:52:\"20250829_imertec_32879aa11d1b12916489_20250829034052\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:70:\"20250829_imertec_32879aa11d1b12916489_20250829034052_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:40:\"/home/imertecc/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:65:\"20250829_imertec_32879aa11d1b12916489_20250829034052_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:124:\"/home/imertecc/public_html/wp-content/backups-dup-lite/tmp/20250829_imertec_32879aa11d1b12916489_20250829034052_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:35:\"/home/imertecc/public_html/wp-admin\";i:1;s:38:\"/home/imertecc/public_html/wp-includes\";i:2;s:47:\"/home/imertecc/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:26:\"/home/imertecc/public_html\";i:1;s:26:\"/home/imertecc/public_html\";i:2;s:37:\"/home/imertecc/public_html/wp-content\";i:3;s:45:\"/home/imertecc/public_html/wp-content/uploads\";i:4;s:45:\"/home/imertecc/public_html/wp-content/plugins\";i:5;s:48:\"/home/imertecc/public_html/wp-content/mu-plugins\";i:6;s:44:\"/home/imertecc/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:58:\"/home/imertecc/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wpge_options */
INSERT INTO `wpge_options` VALUES("1", "siteurl", "https://imertec.com.ec", "yes");
INSERT INTO `wpge_options` VALUES("2", "home", "https://imertec.com.ec", "yes");
INSERT INTO `wpge_options` VALUES("3", "blogname", "IMERTEC", "yes");
INSERT INTO `wpge_options` VALUES("4", "blogdescription", "Repuestos para equipo pesado. CATERPILLAR - KOMATSU - KODIAK - CUMMINS - HYUNDAI", "yes");
INSERT INTO `wpge_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wpge_options` VALUES("6", "admin_email", "admin@imertec.com.ec", "yes");
INSERT INTO `wpge_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wpge_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wpge_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wpge_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wpge_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wpge_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wpge_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wpge_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wpge_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wpge_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wpge_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wpge_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wpge_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wpge_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wpge_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wpge_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wpge_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wpge_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wpge_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wpge_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wpge_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wpge_options` VALUES("28", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO `wpge_options` VALUES("29", "rewrite_rules", "a:304:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:12:\"productos/?$\";s:27:\"index.php?post_type=product\";s:42:\"productos/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:37:\"productos/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:29:\"productos/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:57:\"categoria-producto/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:52:\"categoria-producto/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:33:\"categoria-producto/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:45:\"categoria-producto/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:27:\"categoria-producto/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:58:\"etiqueta-producto/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:53:\"etiqueta-producto/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:34:\"etiqueta-producto/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:46:\"etiqueta-producto/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:28:\"etiqueta-producto/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:36:\"producto/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"producto/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"producto/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"producto/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"producto/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"producto/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:25:\"producto/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:29:\"producto/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:49:\"producto/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:44:\"producto/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:37:\"producto/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:44:\"producto/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:34:\"producto/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:40:\"producto/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:51:\"producto/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:33:\"producto/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:25:\"producto/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"producto/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"producto/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"producto/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"producto/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"producto/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"portfolio/([^/]+)/embed/?$\";s:45:\"index.php?st_portfolio=$matches[1]&embed=true\";s:30:\"portfolio/([^/]+)/trackback/?$\";s:39:\"index.php?st_portfolio=$matches[1]&tb=1\";s:38:\"portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?st_portfolio=$matches[1]&paged=$matches[2]\";s:45:\"portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?st_portfolio=$matches[1]&cpage=$matches[2]\";s:35:\"portfolio/([^/]+)/wc-api(/(.*))?/?$\";s:53:\"index.php?st_portfolio=$matches[1]&wc-api=$matches[3]\";s:41:\"portfolio/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:52:\"portfolio/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:34:\"portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?st_portfolio=$matches[1]&page=$matches[2]\";s:26:\"portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"portfolio-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?taxonomy=st_portfolio_cat&term=$matches[1]&feed=$matches[2]\";s:54:\"portfolio-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?taxonomy=st_portfolio_cat&term=$matches[1]&feed=$matches[2]\";s:35:\"portfolio-category/([^/]+)/embed/?$\";s:63:\"index.php?taxonomy=st_portfolio_cat&term=$matches[1]&embed=true\";s:47:\"portfolio-category/([^/]+)/page/?([0-9]{1,})/?$\";s:70:\"index.php?taxonomy=st_portfolio_cat&term=$matches[1]&paged=$matches[2]\";s:29:\"portfolio-category/([^/]+)/?$\";s:52:\"index.php?taxonomy=st_portfolio_cat&term=$matches[1]\";s:35:\"service/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"service/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"service/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"service/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"service/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"service/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"service/([^/]+)/embed/?$\";s:43:\"index.php?st_service=$matches[1]&embed=true\";s:28:\"service/([^/]+)/trackback/?$\";s:37:\"index.php?st_service=$matches[1]&tb=1\";s:36:\"service/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?st_service=$matches[1]&paged=$matches[2]\";s:43:\"service/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?st_service=$matches[1]&cpage=$matches[2]\";s:33:\"service/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?st_service=$matches[1]&wc-api=$matches[3]\";s:39:\"service/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"service/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"service/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?st_service=$matches[1]&page=$matches[2]\";s:24:\"service/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"service/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"service/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"service/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"service/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"service/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:57:\"service-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?taxonomy=st_service_cat&term=$matches[1]&feed=$matches[2]\";s:52:\"service-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?taxonomy=st_service_cat&term=$matches[1]&feed=$matches[2]\";s:33:\"service-category/([^/]+)/embed/?$\";s:61:\"index.php?taxonomy=st_service_cat&term=$matches[1]&embed=true\";s:45:\"service-category/([^/]+)/page/?([0-9]{1,})/?$\";s:68:\"index.php?taxonomy=st_service_cat&term=$matches[1]&paged=$matches[2]\";s:27:\"service-category/([^/]+)/?$\";s:50:\"index.php?taxonomy=st_service_cat&term=$matches[1]\";s:32:\"team/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"team/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"team/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"team/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"team/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"team/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"team/([^/]+)/embed/?$\";s:40:\"index.php?st_team=$matches[1]&embed=true\";s:25:\"team/([^/]+)/trackback/?$\";s:34:\"index.php?st_team=$matches[1]&tb=1\";s:33:\"team/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?st_team=$matches[1]&paged=$matches[2]\";s:40:\"team/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?st_team=$matches[1]&cpage=$matches[2]\";s:30:\"team/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?st_team=$matches[1]&wc-api=$matches[3]\";s:36:\"team/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:47:\"team/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:29:\"team/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?st_team=$matches[1]&page=$matches[2]\";s:21:\"team/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:31:\"team/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:51:\"team/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"team/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"team/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:27:\"team/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:54:\"team-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?taxonomy=st_team_cat&term=$matches[1]&feed=$matches[2]\";s:49:\"team-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?taxonomy=st_team_cat&term=$matches[1]&feed=$matches[2]\";s:30:\"team-category/([^/]+)/embed/?$\";s:58:\"index.php?taxonomy=st_team_cat&term=$matches[1]&embed=true\";s:42:\"team-category/([^/]+)/page/?([0-9]{1,})/?$\";s:65:\"index.php?taxonomy=st_team_cat&term=$matches[1]&paged=$matches[2]\";s:24:\"team-category/([^/]+)/?$\";s:47:\"index.php?taxonomy=st_team_cat&term=$matches[1]\";s:39:\"testimonial/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"testimonial/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"testimonial/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"testimonial/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"testimonial/([^/]+)/embed/?$\";s:47:\"index.php?st_testimonial=$matches[1]&embed=true\";s:32:\"testimonial/([^/]+)/trackback/?$\";s:41:\"index.php?st_testimonial=$matches[1]&tb=1\";s:40:\"testimonial/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?st_testimonial=$matches[1]&paged=$matches[2]\";s:47:\"testimonial/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?st_testimonial=$matches[1]&cpage=$matches[2]\";s:37:\"testimonial/([^/]+)/wc-api(/(.*))?/?$\";s:55:\"index.php?st_testimonial=$matches[1]&wc-api=$matches[3]\";s:43:\"testimonial/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:54:\"testimonial/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:36:\"testimonial/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?st_testimonial=$matches[1]&page=$matches[2]\";s:28:\"testimonial/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"testimonial/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"testimonial/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"testimonial/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:61:\"testimonial-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:71:\"index.php?taxonomy=st_testimonial_cat&term=$matches[1]&feed=$matches[2]\";s:56:\"testimonial-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:71:\"index.php?taxonomy=st_testimonial_cat&term=$matches[1]&feed=$matches[2]\";s:37:\"testimonial-category/([^/]+)/embed/?$\";s:65:\"index.php?taxonomy=st_testimonial_cat&term=$matches[1]&embed=true\";s:49:\"testimonial-category/([^/]+)/page/?([0-9]{1,})/?$\";s:72:\"index.php?taxonomy=st_testimonial_cat&term=$matches[1]&paged=$matches[2]\";s:31:\"testimonial-category/([^/]+)/?$\";s:54:\"index.php?taxonomy=st_testimonial_cat&term=$matches[1]\";s:34:\"client/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"client/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"client/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"client/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"client/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"client/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"client/([^/]+)/embed/?$\";s:42:\"index.php?st_client=$matches[1]&embed=true\";s:27:\"client/([^/]+)/trackback/?$\";s:36:\"index.php?st_client=$matches[1]&tb=1\";s:35:\"client/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?st_client=$matches[1]&paged=$matches[2]\";s:42:\"client/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?st_client=$matches[1]&cpage=$matches[2]\";s:32:\"client/([^/]+)/wc-api(/(.*))?/?$\";s:50:\"index.php?st_client=$matches[1]&wc-api=$matches[3]\";s:38:\"client/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:49:\"client/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:31:\"client/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?st_client=$matches[1]&page=$matches[2]\";s:23:\"client/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"client/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"client/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"client/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"client/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"client/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"mc4wp-form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"mc4wp-form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"mc4wp-form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"mc4wp-form/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"mc4wp-form/([^/]+)/embed/?$\";s:43:\"index.php?mc4wp-form=$matches[1]&embed=true\";s:31:\"mc4wp-form/([^/]+)/trackback/?$\";s:37:\"index.php?mc4wp-form=$matches[1]&tb=1\";s:39:\"mc4wp-form/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&paged=$matches[2]\";s:46:\"mc4wp-form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&cpage=$matches[2]\";s:36:\"mc4wp-form/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?mc4wp-form=$matches[1]&wc-api=$matches[3]\";s:42:\"mc4wp-form/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:53:\"mc4wp-form/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:35:\"mc4wp-form/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?mc4wp-form=$matches[1]&page=$matches[2]\";s:27:\"mc4wp-form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"mc4wp-form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"mc4wp-form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"mc4wp-form/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:40:\"index.php?&page_id=991&cpage=$matches[1]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:62:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/wc-api(/(.*))?/?$\";s:99:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&wc-api=$matches[6]\";s:62:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:73:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "yes");
INSERT INTO `wpge_options` VALUES("54555", "woocommerce_clear_ces_tracks_queue_for_page", "", "yes");
INSERT INTO `wpge_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wpge_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wpge_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wpge_options` VALUES("33", "active_plugins", "a:12:{i:0;s:35:\"redux-framework/redux-framework.php\";i:1;s:33:\"classic-editor/classic-editor.php\";i:2;s:50:\"contact-form-7-image-captcha/cf7-image-captcha.php\";i:3;s:36:\"contact-form-7/wp-contact-form-7.php\";i:4;s:31:\"creame-whatsapp-me/joinchat.php\";i:5;s:25:\"duplicator/duplicator.php\";i:6;s:27:\"js_composer/js_composer.php\";i:7;s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";i:8;s:23:\"revslider/revslider.php\";i:9;s:31:\"st_builtpress/st_builtpress.php\";i:10;s:34:\"woo-product-images-slider/wpis.php\";i:11;s:27:\"woocommerce/woocommerce.php\";}", "yes");
INSERT INTO `wpge_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wpge_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wpge_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wpge_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `wpge_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wpge_options` VALUES("39", "recently_edited", "a:2:{i:0;s:65:\"/home/imertecc/public_html/wp-content/themes/builtpress/style.css\";i:1;s:0:\"\";}", "no");
INSERT INTO `wpge_options` VALUES("40", "template", "builtpress", "yes");
INSERT INTO `wpge_options` VALUES("41", "stylesheet", "builtpress", "yes");
INSERT INTO `wpge_options` VALUES("38104", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wpge_options` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `wpge_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wpge_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wpge_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `wpge_options` VALUES("48", "db_version", "49752", "yes");
INSERT INTO `wpge_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wpge_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wpge_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `wpge_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `wpge_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `wpge_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `wpge_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `wpge_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wpge_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wpge_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wpge_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wpge_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wpge_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wpge_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wpge_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `wpge_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wpge_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wpge_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `wpge_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wpge_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wpge_options` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wpge_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wpge_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wpge_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wpge_options` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `wpge_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wpge_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wpge_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wpge_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wpge_options` VALUES("78", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("79", "widget_text", "a:2:{i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:261:\"<img class=\"alignnone size-medium wp-image-2596\" src=\"https://imertec.com.ec/wp-content/uploads/2018/01/logowhite-300x64.png\" alt=\"\" width=\"300\" height=\"64\" />\r\n\r\nSuscríbase a nuestro boletín y reciba información actualizada de nuestros productos y servicios\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("81", "uninstall_plugins", "a:0:{}", "no");
INSERT INTO `wpge_options` VALUES("82", "timezone_string", "", "yes");
INSERT INTO `wpge_options` VALUES("83", "page_for_posts", "2557", "yes");
INSERT INTO `wpge_options` VALUES("84", "page_on_front", "991", "yes");
INSERT INTO `wpge_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wpge_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wpge_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wpge_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `wpge_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wpge_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wpge_options` VALUES("91", "initial_db_version", "38590", "yes");
INSERT INTO `wpge_options` VALUES("92", "wpge_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:131:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"edit_shop_webhook\";b:1;s:17:\"read_shop_webhook\";b:1;s:19:\"delete_shop_webhook\";b:1;s:18:\"edit_shop_webhooks\";b:1;s:25:\"edit_others_shop_webhooks\";b:1;s:21:\"publish_shop_webhooks\";b:1;s:26:\"read_private_shop_webhooks\";b:1;s:20:\"delete_shop_webhooks\";b:1;s:28:\"delete_private_shop_webhooks\";b:1;s:30:\"delete_published_shop_webhooks\";b:1;s:27:\"delete_others_shop_webhooks\";b:1;s:26:\"edit_private_shop_webhooks\";b:1;s:28:\"edit_published_shop_webhooks\";b:1;s:25:\"manage_shop_webhook_terms\";b:1;s:23:\"edit_shop_webhook_terms\";b:1;s:25:\"delete_shop_webhook_terms\";b:1;s:25:\"assign_shop_webhook_terms\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}}", "yes");
INSERT INTO `wpge_options` VALUES("38378", "revslider_server_refresh", "1756032117", "yes");
INSERT INTO `wpge_options` VALUES("38379", "revslider-update-hash", "5f9042577cd17027ef5f7c3ddce71d60", "yes");
INSERT INTO `wpge_options` VALUES("93", "fresh_site", "0", "yes");
INSERT INTO `wpge_options` VALUES("94", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("95", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("96", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("97", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("98", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("99", "sidebars_widgets", "a:10:{s:19:\"wp_inactive_widgets\";a:0:{}s:7:\"sidebar\";a:5:{i:0;s:13:\"st-blog-wgt-2\";i:1;s:12:\"categories-2\";i:2;s:10:\"archives-2\";i:3;s:8:\"search-2\";i:4;s:11:\"tag_cloud-2\";}s:12:\"page_sidebar\";a:1:{i:0;s:7:\"pages-2\";}s:12:\"shop_sidebar\";a:5:{i:0;s:28:\"woocommerce_product_search-2\";i:1;s:26:\"woocommerce_price_filter-2\";i:2;s:32:\"woocommerce_product_categories-2\";i:3;s:22:\"woocommerce_products-2\";i:4;s:32:\"woocommerce_top_rated_products-2\";}s:15:\"footer_column_1\";a:3:{i:0;s:6:\"text-3\";i:1;s:19:\"mc4wp_form_widget-2\";i:2;s:15:\"st-social-wgt-3\";}s:15:\"footer_column_2\";a:1:{i:0;s:10:\"nav_menu-2\";}s:15:\"footer_column_3\";a:1:{i:0;s:17:\"st-services-wgt-3\";}s:15:\"footer_column_4\";a:1:{i:0;s:16:\"st-contact-wgt-2\";}s:11:\"st_services\";a:2:{i:0;s:17:\"st-services-wgt-5\";i:1;s:16:\"st-contact-wgt-3\";}s:13:\"array_version\";i:2;}", "yes");
INSERT INTO `wpge_options` VALUES("100", "widget_pages", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:6:\"sortby\";s:10:\"post_title\";s:7:\"exclude\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("101", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("102", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("103", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("104", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("105", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("106", "widget_tag_cloud", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:8:\"taxonomy\";s:8:\"post_tag\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("107", "widget_nav_menu", "a:2:{i:2;a:2:{s:5:\"title\";s:16:\"Explore Our Site\";s:8:\"nav_menu\";i:82;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("108", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("109", "cron", "a:22:{i:1756438917;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1756439592;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1756439834;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1756440313;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1756445040;a:1:{s:29:\"mc4wp_refresh_mailchimp_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1756447377;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1756448551;a:1:{s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1756457379;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1756470277;a:2:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1756478984;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1756478989;a:1:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1756479039;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}i:1756489779;a:2:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"woocommerce_cleanup_rate_limits\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1756491751;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1756492412;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1756512000;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1756513496;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1756518216;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1756525131;a:1:{s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1756643166;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1756735200;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wpge_options` VALUES("114", "theme_mods_twentyseventeen", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1517189662;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}", "yes");
INSERT INTO `wpge_options` VALUES("116", "WPLANG", "es_ES", "yes");
INSERT INTO `wpge_options` VALUES("176", "woocommerce_store_address", "Av. Galo Plaza n55-22 y Urquiola", "yes");
INSERT INTO `wpge_options` VALUES("177", "woocommerce_store_address_2", "", "yes");
INSERT INTO `wpge_options` VALUES("178", "woocommerce_store_city", "Quito", "yes");
INSERT INTO `wpge_options` VALUES("179", "woocommerce_default_country", "EC:EC-P", "yes");
INSERT INTO `wpge_options` VALUES("180", "woocommerce_store_postcode", "ec000000", "yes");
INSERT INTO `wpge_options` VALUES("181", "woocommerce_allowed_countries", "all", "yes");
INSERT INTO `wpge_options` VALUES("182", "woocommerce_all_except_countries", "a:0:{}", "yes");
INSERT INTO `wpge_options` VALUES("183", "woocommerce_specific_allowed_countries", "a:0:{}", "yes");
INSERT INTO `wpge_options` VALUES("184", "woocommerce_ship_to_countries", "", "yes");
INSERT INTO `wpge_options` VALUES("185", "woocommerce_specific_ship_to_countries", "a:0:{}", "yes");
INSERT INTO `wpge_options` VALUES("186", "woocommerce_default_customer_address", "base", "yes");
INSERT INTO `wpge_options` VALUES("187", "woocommerce_calc_taxes", "no", "yes");
INSERT INTO `wpge_options` VALUES("188", "woocommerce_demo_store", "no", "yes");
INSERT INTO `wpge_options` VALUES("189", "woocommerce_demo_store_notice", "Esta es una tienda de demostración para realizar pruebas &mdash; no se completará ningún pedido.", "no");
INSERT INTO `wpge_options` VALUES("190", "woocommerce_currency", "USD", "yes");
INSERT INTO `wpge_options` VALUES("191", "woocommerce_currency_pos", "left", "yes");
INSERT INTO `wpge_options` VALUES("192", "woocommerce_price_thousand_sep", ",", "yes");
INSERT INTO `wpge_options` VALUES("193", "woocommerce_price_decimal_sep", ".", "yes");
INSERT INTO `wpge_options` VALUES("194", "woocommerce_price_num_decimals", "2", "yes");
INSERT INTO `wpge_options` VALUES("195", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `wpge_options` VALUES("498", "revslider-connection", "1", "yes");
INSERT INTO `wpge_options` VALUES("499", "revslider-latest-version", "6.7.37", "yes");
INSERT INTO `wpge_options` VALUES("500", "revslider-stable-version", "4.2.0", "yes");
INSERT INTO `wpge_options` VALUES("501", "revslider-notices", "a:2:{i:0;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:964:\"<div style=\"display: block; background: #1b0e41;text-align: center; height:300px;\"><noscript><img src=\"//updates.themepunch-ext-c.tools//banners/rs60/cyberweek.jpg\" usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\"></noscript><img usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\" src=\"//updates.themepunch-ext-c.tools//banners/rs60/cyberweek.jpg\"></div>\n<map name=\"srbannermap\">\n    <area target=\"_blank\" alt=\"Slider Revolution\" title=\"Slider Revolution\" href=\"https://www.sliderrevolution.com/black-friday-and-cyber-monday-sale/?utm_source=admin&amp;utm_medium=banner&amp;utm_campaign=srusers&amp;utm_content=cyberweeks22\" coords=\"569,135,890,196\" shape=\"rect\">\n    <area target=\"_blank\" alt=\"Essential Grid\" title=\"Essential Grid\" href=\"https://www.essential-grid.com/?utm_source=admin&utm_medium=banner&utm_campaign=esgusers&utm_content=cyberweeks22\" coords=\"570,200,889,260\" shape=\"rect\">\n</map>\";s:4:\"code\";s:9:\"TPSRCW111\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:1;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:956:\"<div style=\"display: block; background: #1c0950;text-align: center; height:300px;\"><noscript><img src=\"//updates.themepunch-ext-c.tools//banners/blackfriday2024-admin2.jpg\" usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\"></noscript><img usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\" src=\"//updates.themepunch-ext-c.tools//banners/blackfriday2024-admin2.jpg\"></div><map name=\"srbannermap\"><area target=\"_blank\" alt=\"Slider Revolution\" title=\"Slider Revolution\" href=\"https://www.sliderrevolution.com/black-friday-and-cyber-monday-sale/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=cyberweeks24\" coords=\"569,135,890,196\" shape=\"rect\"><area target=\"_blank\" alt=\"Essential Grid\" title=\"Essential Grid\" href=\"https://www.essential-grid.com/?utm_source=admin&utm_medium=banner&utm_campaign=esgusers&utm_content=cyberweeks24\" coords=\"570,200,889,260\" shape=\"rect\"></map>\";s:4:\"code\";s:8:\"TPSRBF24\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}}", "yes");
INSERT INTO `wpge_options` VALUES("502", "revslider-dashboard", "a:0:{}", "yes");
INSERT INTO `wpge_options` VALUES("503", "revslider-addons", "O:8:\"stdClass\":32:{s:25:\"revslider-particles-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"424\";s:9:\"releaseid\";s:1:\"7\";s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"3.3.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:2:\"10\";s:11:\"last_update\";s:10:\"2023-07-28\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_particles.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_particles.jpg\";s:7:\"img_md5\";s:32:\"b668a4015ddc6a532b43bb558967a062\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"405\";s:9:\"releaseid\";s:2:\"20\";s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"20\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_bubblemorph.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_bubblemorph.jpg\";s:7:\"img_md5\";s:32:\"22d03d5de3034069c6db1fdeafd467cd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-transitionpack-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"369\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:30:\"revslider-transitionpack-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Advanced Transitions\";s:6:\"line_1\";s:43:\"Add never-before-seen slide transitions to \";s:6:\"line_2\";s:42:\"Slider Revolution with the power of WEBGL.\";s:9:\"available\";s:5:\"1.0.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"30\";s:11:\"last_update\";s:10:\"2023-02-23\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_transition.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_transition.jpg\";s:7:\"img_md5\";s:32:\"fe0f1c539053620039a0ad96c4ac27e6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"AT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"404\";s:9:\"releaseid\";s:2:\"15\";s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"3.1.0\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"40\";s:11:\"last_update\";s:10:\"2023-05-20\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_beforeafter.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_beforeafter.jpg\";s:7:\"img_md5\";s:32:\"5a34f20417a7874e1b95693ef37a0758\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"418\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:2:\"50\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_typewriter.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_typewriter.jpg\";s:7:\"img_md5\";s:32:\"727b604f6fd3fc55894ba50eb566efed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-mousetrap-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"410\";s:9:\"releaseid\";s:2:\"24\";s:4:\"slug\";s:25:\"revslider-mousetrap-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Mousetrap\";s:6:\"line_1\";s:31:\"Create all kinds of interesting\";s:6:\"line_2\";s:19:\" mouse interactions\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"60\";s:11:\"last_update\";s:10:\"2021-10-20\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_mousetrap.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_mousetrap.jpg\";s:7:\"img_md5\";s:32:\"2329053c3b1d19bdaee131c3dc258d3a\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"409\";s:9:\"releaseid\";s:2:\"21\";s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"70\";s:11:\"last_update\";s:10:\"2021-10-20\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_distortion.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_distortion.jpg\";s:7:\"img_md5\";s:32:\"c26c52a563008b7dc907a288c1e4bb8e\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-lottie-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"420\";s:9:\"releaseid\";s:2:\"25\";s:4:\"slug\";s:22:\"revslider-lottie-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Lottie\";s:6:\"line_1\";s:53:\"Adds support for the popular Lottie Animation format,\";s:6:\"line_2\";s:70:\" including animation control, style customization and a local library.\";s:9:\"available\";s:5:\"3.1.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"80\";s:11:\"last_update\";s:10:\"2023-06-26\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_lottie.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_lottie.jpg\";s:7:\"img_md5\";s:32:\"4aa677a45bb13732e4f10bcb632afcce\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"411\";s:9:\"releaseid\";s:2:\"23\";s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"90\";s:11:\"last_update\";s:10:\"2023-08-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_paintbrush.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_paintbrush.jpg\";s:7:\"img_md5\";s:32:\"308a56289b9a29d1916c2acfc141b699\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-charts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"383\";s:9:\"releaseid\";s:2:\"27\";s:4:\"slug\";s:22:\"revslider-charts-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Charts\";s:6:\"line_1\";s:93:\"The Charts addon allows you to create visually impressive line or bar graphs from .csv data, \";s:6:\"line_2\";s:56:\"with tons of options to take full control of the design.\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:3:\"100\";s:11:\"last_update\";s:10:\"2021-07-08\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_charts.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_charts.jpg\";s:7:\"img_md5\";s:32:\"d2c184371a575faade425c0377c1fdbd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"CH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"417\";s:9:\"releaseid\";s:2:\"13\";s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"110\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_slicey.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_slicey.jpg\";s:7:\"img_md5\";s:32:\"28afd29b7738a452194f0a0bc1d21cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"422\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"125\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_filmstrip.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_filmstrip.jpg\";s:7:\"img_md5\";s:32:\"dac40ee57d2be9aaf01faacf51ccb412\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"421\";s:9:\"releaseid\";s:1:\"4\";s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"3.0.0\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"127\";s:11:\"last_update\";s:10:\"2023-07-17\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:84:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_underconstruction.jpg\";s:8:\"img_file\";s:51:\"revslider/addons/images/addon_underconstruction.jpg\";s:7:\"img_md5\";s:32:\"17f8cba84931541c065cfb1943edafb2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"416\";s:9:\"releaseid\";s:2:\"19\";s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"130\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_reveal.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reveal.jpg\";s:7:\"img_md5\";s:32:\"a7ce4bf5eb6fdc1497ed6276ca623046\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"423\";s:9:\"releaseid\";s:2:\"17\";s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:28:\"Display images in 360 degree\";s:9:\"available\";s:5:\"3.0.9\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"135\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_panorama.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_panorama.jpg\";s:7:\"img_md5\";s:32:\"210953d59903bed91688138cb60777d2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-scrollvideo-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"396\";s:9:\"releaseid\";s:2:\"26\";s:4:\"slug\";s:27:\"revslider-scrollvideo-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Scroll Video\";s:6:\"line_1\";s:114:\"This addon allows you to generate a sequence of images from any html5 video and play them with scroll interaction.\";s:6:\"line_2\";s:49:\"Quality options are included for optimal results!\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:15:\"background_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:14:\"background_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"140\";s:11:\"last_update\";s:10:\"2021-12-23\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:7:\"img_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"407\";s:9:\"releaseid\";s:2:\"22\";s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"150\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_exploding.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_exploding.jpg\";s:7:\"img_md5\";s:32:\"44d60b83cdf5b29033d41feb516b47e1\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"397\";s:9:\"releaseid\";s:1:\"5\";s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"165\";s:11:\"last_update\";s:10:\"2023-07-08\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:80:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_socialsharing.jpg\";s:8:\"img_file\";s:47:\"revslider/addons/images/addon_socialsharing.jpg\";s:7:\"img_md5\";s:32:\"6b074630853c4f95d5337bc85e496cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"419\";s:9:\"releaseid\";s:1:\"1\";s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:81:\"//updates.themepunch-ext-c.tools/revslider/addons/images/whiteboard_widget_bg.jpg\";s:15:\"background_file\";s:48:\"revslider/addons/images/whiteboard_widget_bg.jpg\";s:14:\"background_md5\";s:32:\"cc69160eb95469dc033e0cc094a24847\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"170\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_whiteboard.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_whiteboard.jpg\";s:7:\"img_md5\";s:32:\"b0bb636fb30ffc3d112ba4c563395ee6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"414\";s:9:\"releaseid\";s:2:\"14\";s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"180\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_polyfold.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_polyfold.jpg\";s:7:\"img_md5\";s:32:\"02c6af89e4208f0da5920c6c3e6bb744\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:29:\"revslider-domain-switch-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"78\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:29:\"revslider-domain-switch-addon\";s:12:\"version_from\";s:5:\"6.0.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Domain Switch\";s:6:\"line_1\";s:17:\"Switch Image URLs\";s:6:\"line_2\";s:37:\"in sliders from one domain to another\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"300\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:79:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_domainswitch.jpg\";s:8:\"img_file\";s:46:\"revslider/addons/images/addon_domainswitch.jpg\";s:7:\"img_md5\";s:32:\"f2036924e7993f94bd5c9876fa0bf09b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"DS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"415\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"330\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_reload.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reload.jpg\";s:7:\"img_md5\";s:32:\"d1d34d204e627168f4cc4e7422a6d40c\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"55\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"340\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wprelated.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wprelated.jpg\";s:7:\"img_md5\";s:32:\"e2e7d6c3a428a55442ba90131556c930\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"399\";s:9:\"releaseid\";s:1:\"6\";s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"380\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:71:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_snow.jpg\";s:8:\"img_file\";s:38:\"revslider/addons/images/addon_snow.jpg\";s:7:\"img_md5\";s:32:\"d6bac718866b0070198a4340041bc60b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"378\";s:9:\"releaseid\";s:1:\"2\";s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"2.0.7\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"430\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wpgallery.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wpgallery.jpg\";s:7:\"img_md5\";s:32:\"74392a04b741d83c51e55059dbb388ef\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-backup-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"53\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"2.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"500\";s:11:\"last_update\";s:10:\"2024-11-20\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_backup.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_backup.jpg\";s:7:\"img_md5\";s:32:\"104797323a0293cd3f200b0172db1186\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"62\";s:9:\"releaseid\";s:1:\"8\";s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"620\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:70:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_404.jpg\";s:8:\"img_file\";s:37:\"revslider/addons/images/addon_404.jpg\";s:7:\"img_md5\";s:32:\"217b0d118a107dc50979740dd61228df\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"63\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"630\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wpadjacent.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpadjacent.jpg\";s:7:\"img_md5\";s:32:\"cb1feb1257e55d0f42c29dfde2d809ed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"388\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"650\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:72:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_login.jpg\";s:8:\"img_file\";s:39:\"revslider/addons/images/addon_login.jpg\";s:7:\"img_md5\";s:32:\"f0f2edffb4e155acf67799692428644d\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"379\";s:9:\"releaseid\";s:2:\"12\";s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"2.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"660\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wpfeatured.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpfeatured.jpg\";s:7:\"img_md5\";s:32:\"bcc840e68194f3eb05795e1353954bda\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"402\";s:9:\"releaseid\";s:2:\"16\";s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"690\";s:11:\"last_update\";s:10:\"2023-05-31\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_weather.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_weather.jpg\";s:7:\"img_md5\";s:32:\"c69d1c9a69c2dec43ca0578ac35792bd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"406\";s:9:\"releaseid\";s:2:\"18\";s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"710\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_duotone.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_duotone.jpg\";s:7:\"img_md5\";s:32:\"fb666e487e7ac28e6a2a157eed1fb682\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}}", "yes");
INSERT INTO `wpge_options` VALUES("532", "_transient_product-transient-version", "1723069877", "yes");
INSERT INTO `wpge_options` VALUES("765", "xoo-qv-button-text", "Vista rápida", "yes");
INSERT INTO `wpge_options` VALUES("766", "xoo-qv-button-fsize", "14", "yes");
INSERT INTO `wpge_options` VALUES("767", "xoo-qv-button-position", "woocommerce_before_shop_loop_item_title", "yes");
INSERT INTO `wpge_options` VALUES("768", "xoo-qv-btn-bgc", "inherit", "yes");
INSERT INTO `wpge_options` VALUES("769", "xoo-qv-button-color", "inherit", "yes");
INSERT INTO `wpge_options` VALUES("770", "xoo-qv-btn-ps", "6px 8px", "yes");
INSERT INTO `wpge_options` VALUES("771", "xoo-qv-btn-bs", "1", "yes");
INSERT INTO `wpge_options` VALUES("772", "xoo-qv-btn-bc", "#000000", "yes");
INSERT INTO `wpge_options` VALUES("773", "xoo-qv-btn-icon", "true", "yes");
INSERT INTO `wpge_options` VALUES("774", "xoo-qv-btn-iconc", "#000000", "yes");
INSERT INTO `wpge_options` VALUES("775", "xoo-qv-gl-mobile", "true", "yes");
INSERT INTO `wpge_options` VALUES("776", "xoo-qv-gl-anim", "linear", "yes");
INSERT INTO `wpge_options` VALUES("777", "xoo-qv-gl-pbutton", "true", "yes");
INSERT INTO `wpge_options` VALUES("778", "xoo-qv-gl-pbutton-text", "Detalles del producto", "yes");
INSERT INTO `wpge_options` VALUES("779", "xoo-qv-lb-img-area", "40", "yes");
INSERT INTO `wpge_options` VALUES("780", "xoo-qv-lb-img-width", "100", "yes");
INSERT INTO `wpge_options` VALUES("781", "xoo-qv-lb-en-gallery", "true", "yes");
INSERT INTO `wpge_options` VALUES("782", "xoo-qv-lb-enable", "true", "yes");
INSERT INTO `wpge_options` VALUES("783", "xoo-qv-lb-title", "true", "yes");
INSERT INTO `wpge_options` VALUES("801", "wpis_options", "a:5:{s:5:\"arrow\";s:4:\"true\";s:6:\"carrow\";s:5:\"false\";s:4:\"zoom\";s:4:\"true\";s:5:\"popup\";s:4:\"true\";s:8:\"autoplay\";s:4:\"true\";}", "yes");
INSERT INTO `wpge_options` VALUES("792", "fs_active_plugins", "O:8:\"stdClass\":3:{s:7:\"plugins\";a:1:{s:30:\"foobox-image-lightbox/freemius\";O:8:\"stdClass\":4:{s:7:\"version\";s:8:\"1.2.2.10\";s:4:\"type\";s:6:\"plugin\";s:9:\"timestamp\";i:1519421315;s:11:\"plugin_path\";s:37:\"foobox-image-lightbox/foobox-free.php\";}}s:7:\"abspath\";s:27:\"/home/imertecc/public_html/\";s:6:\"newest\";O:8:\"stdClass\":5:{s:11:\"plugin_path\";s:37:\"foobox-image-lightbox/foobox-free.php\";s:8:\"sdk_path\";s:30:\"foobox-image-lightbox/freemius\";s:7:\"version\";s:8:\"1.2.2.10\";s:13:\"in_activation\";b:1;s:9:\"timestamp\";i:1519421315;}}", "yes");
INSERT INTO `wpge_options` VALUES("793", "fs_debug_mode", "", "yes");
INSERT INTO `wpge_options` VALUES("794", "fs_accounts", "a:6:{s:21:\"id_slug_type_path_map\";a:1:{i:374;a:3:{s:4:\"slug\";s:21:\"foobox-image-lightbox\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:83:\"/home/imertecc/public_html/wp-content/plugins/foobox-image-lightbox/foobox-free.php\";}}s:11:\"plugin_data\";a:1:{s:21:\"foobox-image-lightbox\";a:15:{s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:83:\"/home/imertecc/public_html/wp-content/plugins/foobox-image-lightbox/foobox-free.php\";}s:17:\"install_timestamp\";i:1519421212;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:0;s:16:\"sdk_last_version\";N;s:11:\"sdk_version\";s:8:\"1.2.2.10\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";N;s:14:\"plugin_version\";s:5:\"2.5.1\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";b:1;s:4:\"host\";s:18:\"www.imertec.com.ec\";s:9:\"server_ip\";s:15:\"190.152.177.154\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1519421212;s:7:\"version\";s:5:\"2.5.1\";}s:15:\"prev_is_premium\";b:0;s:12:\"is_anonymous\";a:3:{s:2:\"is\";b:1;s:9:\"timestamp\";i:1519421224;s:7:\"version\";s:5:\"2.5.1\";}}}s:13:\"file_slug_map\";a:1:{s:37:\"foobox-image-lightbox/foobox-free.php\";s:21:\"foobox-image-lightbox\";}s:7:\"plugins\";a:1:{s:21:\"foobox-image-lightbox\";O:9:\"FS_Plugin\":17:{s:16:\"parent_plugin_id\";N;s:5:\"title\";s:21:\"FooBox Image Lightbox\";s:4:\"slug\";s:21:\"foobox-image-lightbox\";s:4:\"type\";s:6:\"plugin\";s:4:\"file\";s:37:\"foobox-image-lightbox/foobox-free.php\";s:7:\"version\";s:5:\"2.5.1\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:7:\"is_live\";b:1;s:20:\"affiliate_moderation\";b:0;s:10:\"public_key\";s:32:\"pk_7a17ec700c89fe71a25605589e0b9\";s:10:\"secret_key\";N;s:2:\"id\";s:3:\"374\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:0;}}s:9:\"unique_id\";s:32:\"0eee88df144c8e2e19d7c20cf3b10244\";s:13:\"admin_notices\";a:1:{s:21:\"foobox-image-lightbox\";a:0:{}}}", "yes");
INSERT INTO `wpge_options` VALUES("795", "fs_api_cache", "a:0:{}", "yes");
INSERT INTO `wpge_options` VALUES("144", "current_theme", "BuiltPress", "yes");
INSERT INTO `wpge_options` VALUES("145", "theme_mods_builtpress", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:7:\"primary\";i:50;s:6:\"footer\";i:49;}s:18:\"custom_css_post_id\";i:-1;s:16:\"theme_st_options\";a:7:{s:9:\"site_logo\";a:5:{s:3:\"url\";s:58:\"https://imertec.com.ec/wp-content/uploads/2018/01/logo.png\";s:2:\"id\";s:4:\"2560\";s:6:\"height\";s:3:\"100\";s:5:\"width\";s:3:\"475\";s:9:\"thumbnail\";s:0:\"\";}s:18:\"header_transparent\";s:1:\"1\";s:21:\"site_logo_transparent\";a:5:{s:3:\"url\";s:58:\"https://imertec.com.ec/wp-content/uploads/2018/01/logo.png\";s:2:\"id\";s:4:\"2560\";s:6:\"height\";s:3:\"100\";s:5:\"width\";s:3:\"475\";s:9:\"thumbnail\";s:0:\"\";}s:11:\"topbar_info\";a:4:{s:7:\"label_1\";s:27:\"<i class=\"fa  fa-home\"></i>\";s:7:\"value_1\";s:56:\"Av. 6 de Diciembre N56-151 y Fresnos Local 3 Planta baja\";s:7:\"label_2\";s:30:\"<i class=\"fa  fa-clock-o\"></i>\";s:7:\"value_2\";s:29:\"Lunes - Sábado: 9:00 - 18:00\";}s:11:\"header_info\";a:4:{s:7:\"label_1\";s:27:\"<i class=\"fa fa-phone\"></i>\";s:7:\"value_1\";s:41:\"(02) 3283298 ; (02) 3289079; 099 910 1680\";s:7:\"label_2\";s:32:\"<i class=\"fa fa-envelope-o\"></i>\";s:7:\"value_2\";s:22:\"ventas1@imertec.com.ec\";}s:10:\"social_url\";a:13:{s:8:\"facebook\";s:32:\"https://www.facebook.com/IMERTEC\";s:6:\"google\";s:1:\"#\";s:7:\"twitter\";s:1:\"#\";s:8:\"linkedin\";s:1:\"#\";s:8:\"dribbble\";s:1:\"#\";s:9:\"instagram\";s:1:\"#\";s:9:\"pinterest\";s:1:\"#\";s:10:\"foursquare\";s:1:\"#\";s:6:\"tumblr\";s:1:\"#\";s:7:\"youtube\";s:1:\"#\";s:5:\"vimeo\";s:1:\"#\";s:6:\"flickr\";s:1:\"#\";s:3:\"rss\";s:1:\"#\";}s:18:\"topbar_social_show\";a:13:{s:8:\"facebook\";s:1:\"1\";s:6:\"google\";s:0:\"\";s:7:\"twitter\";s:1:\"0\";s:8:\"linkedin\";s:1:\"1\";s:8:\"dribbble\";s:0:\"\";s:9:\"instagram\";s:0:\"\";s:9:\"pinterest\";s:0:\"\";s:10:\"foursquare\";s:0:\"\";s:6:\"tumblr\";s:0:\"\";s:7:\"youtube\";s:0:\"\";s:5:\"vimeo\";s:0:\"\";s:6:\"flickr\";s:0:\"\";s:3:\"rss\";s:0:\"\";}}}", "yes");
INSERT INTO `wpge_options` VALUES("146", "theme_switched", "", "yes");
INSERT INTO `wpge_options` VALUES("147", "widget_st-blog-wgt", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:1:\"0\";s:5:\"count\";s:1:\"5\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("148", "widget_st-social-wgt", "a:2:{i:3;a:2:{s:5:\"title\";s:0:\"\";s:11:\"social_show\";a:13:{s:8:\"facebook\";i:1;s:8:\"linkedin\";i:1;s:9:\"instagram\";i:1;s:6:\"google\";i:0;s:7:\"twitter\";i:0;s:8:\"dribbble\";i:0;s:9:\"pinterest\";i:0;s:10:\"foursquare\";i:0;s:6:\"tumblr\";i:0;s:7:\"youtube\";i:0;s:5:\"vimeo\";i:0;s:6:\"flickr\";i:0;s:3:\"rss\";i:0;}}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("149", "widget_st-contact-wgt", "a:3:{i:2;a:5:{s:5:\"title\";s:14:\"Office Address\";s:7:\"address\";s:52:\"5001 E. Colorado Blvd. Suite 820, Pasadena, CA 91106\";s:5:\"phone\";s:14:\"(626) 935-8115\";s:3:\"fax\";s:14:\"(626) 935-3026\";s:5:\"email\";s:19:\"info@builtpress.com\";}i:3;a:5:{s:5:\"title\";s:14:\"Office Address\";s:7:\"address\";s:51:\"705 Eglinton Ave. W- Suite 969, Toronto, ON M7N 3D3\";s:5:\"phone\";s:14:\"(614) 395-2455\";s:3:\"fax\";s:14:\"(614) 395-7696\";s:5:\"email\";s:18:\"info@builtpress.ca\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("150", "widget_st-services-wgt", "a:3:{i:3;a:2:{s:5:\"title\";s:12:\"Our Services\";s:8:\"category\";s:2:\"28\";}i:5;a:2:{s:5:\"title\";s:12:\"Our Services\";s:8:\"category\";s:1:\"0\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("163", "mc4wp_version", "4.8.7", "yes");
INSERT INTO `wpge_options` VALUES("164", "theme_st_options", "a:67:{s:8:\"last_tab\";s:0:\"\";s:12:\"site_favicon\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:9:\"site_logo\";a:5:{s:3:\"url\";s:59:\"https://imertec.com.ec/wp-content/uploads/2018/02/logo1.png\";s:2:\"id\";s:4:\"2651\";s:6:\"height\";s:2:\"85\";s:5:\"width\";s:3:\"470\";s:9:\"thumbnail\";s:66:\"https://imertec.com.ec/wp-content/uploads/2018/02/logo1-150x85.png\";}s:21:\"site_logo_transparent\";a:5:{s:3:\"url\";s:59:\"https://imertec.com.ec/wp-content/uploads/2018/02/logo1.png\";s:2:\"id\";s:4:\"2651\";s:6:\"height\";s:2:\"85\";s:5:\"width\";s:3:\"470\";s:9:\"thumbnail\";s:66:\"https://imertec.com.ec/wp-content/uploads/2018/02/logo1-150x85.png\";}s:11:\"site_layout\";s:4:\"wide\";s:12:\"header_style\";s:2:\"v1\";s:18:\"header_transparent\";s:1:\"1\";s:13:\"header_sticky\";s:1:\"1\";s:11:\"header_info\";a:4:{s:7:\"label_1\";s:27:\"<i class=\"fa fa-phone\"></i>\";s:7:\"value_1\";s:41:\"(02) 3283298 ; (02) 3289079; 099 910 1680\";s:7:\"label_2\";s:32:\"<i class=\"fa fa-envelope-o\"></i>\";s:7:\"value_2\";s:22:\"ventas1@imertec.com.ec\";}s:18:\"header_button_link\";s:4:\"2272\";s:19:\"header_button_value\";s:7:\"Cotizar\";s:13:\"header_search\";s:1:\"1\";s:13:\"topbar_enable\";s:1:\"1\";s:11:\"topbar_info\";a:4:{s:7:\"label_1\";s:27:\"<i class=\"fa  fa-home\"></i>\";s:7:\"value_1\";s:56:\"Av. 6 de Diciembre N56-151 y Fresnos Local 3 Planta baja\";s:7:\"label_2\";s:30:\"<i class=\"fa  fa-clock-o\"></i>\";s:7:\"value_2\";s:29:\"Lunes - Sábado: 9:00 - 18:00\";}s:13:\"topbar_social\";s:1:\"1\";s:18:\"topbar_social_show\";a:13:{s:8:\"facebook\";s:1:\"1\";s:6:\"google\";s:0:\"\";s:7:\"twitter\";s:1:\"0\";s:8:\"linkedin\";s:1:\"1\";s:8:\"dribbble\";s:0:\"\";s:9:\"instagram\";s:0:\"\";s:9:\"pinterest\";s:0:\"\";s:10:\"foursquare\";s:0:\"\";s:6:\"tumblr\";s:0:\"\";s:7:\"youtube\";s:0:\"\";s:5:\"vimeo\";s:0:\"\";s:6:\"flickr\";s:0:\"\";s:3:\"rss\";s:0:\"\";}s:17:\"title_padding_top\";s:2:\"80\";s:20:\"title_padding_bottom\";s:2:\"80\";s:11:\"title_align\";s:6:\"center\";s:16:\"title_breadcrumb\";s:1:\"0\";s:13:\"footer_widget\";s:1:\"1\";s:20:\"footer_widget_column\";s:1:\"1\";s:19:\"footer_widget_class\";a:4:{s:7:\"class_1\";s:21:\"col-md-12 text-center\";s:7:\"class_2\";s:0:\"\";s:7:\"class_3\";s:0:\"\";s:7:\"class_4\";s:0:\"\";}s:16:\"footer_copyright\";s:1:\"1\";s:21:\"footer_copyright_menu\";s:1:\"1\";s:21:\"footer_copyright_text\";s:80:\"Diseñado por: Ing. Alvaro Salguero - HIPERCOM 2018. Derechos reservados IMERTEC\";s:18:\"style_skin_primary\";s:7:\"#ffb300\";s:13:\"style_bg_body\";a:7:{s:16:\"background-color\";s:0:\"\";s:17:\"background-repeat\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:19:\"background-position\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:5:\"media\";a:4:{s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:13:\"style_bg_page\";s:0:\"\";s:15:\"style_bg_header\";s:0:\"\";s:19:\"color_header_border\";s:0:\"\";s:17:\"color_header_text\";s:0:\"\";s:15:\"style_bg_topbar\";s:0:\"\";s:19:\"color_topbar_border\";s:0:\"\";s:17:\"color_topbar_text\";s:0:\"\";s:17:\"color_topbar_link\";s:0:\"\";s:23:\"color_topbar_link_hover\";s:0:\"\";s:14:\"style_bg_title\";a:7:{s:16:\"background-color\";s:0:\"\";s:17:\"background-repeat\";s:9:\"no-repeat\";s:15:\"background-size\";s:5:\"cover\";s:21:\"background-attachment\";s:6:\"scroll\";s:19:\"background-position\";s:13:\"center center\";s:16:\"background-image\";s:60:\"https://imertec.com.ec/wp-content/uploads/2018/01/titulo.jpg\";s:5:\"media\";a:4:{s:2:\"id\";s:4:\"2570\";s:6:\"height\";s:3:\"654\";s:5:\"width\";s:4:\"1920\";s:9:\"thumbnail\";s:68:\"https://imertec.com.ec/wp-content/uploads/2018/01/titulo-150x150.jpg\";}}s:23:\"style_bg_title_parallax\";s:1:\"0\";s:11:\"color_title\";s:0:\"\";s:14:\"color_subtitle\";s:0:\"\";s:16:\"color_breadcrumb\";s:0:\"\";s:15:\"style_bg_footer\";a:7:{s:16:\"background-color\";s:0:\"\";s:17:\"background-repeat\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:19:\"background-position\";s:13:\"center center\";s:16:\"background-image\";s:72:\"https://imertec.com.ec/wp-content/uploads/2016/01/demo-builtpress-05.jpg\";s:5:\"media\";a:4:{s:2:\"id\";s:4:\"2546\";s:6:\"height\";s:4:\"1080\";s:5:\"width\";s:4:\"1920\";s:9:\"thumbnail\";s:80:\"https://imertec.com.ec/wp-content/uploads/2016/01/demo-builtpress-05-150x150.jpg\";}}s:20:\"color_footer_heading\";s:0:\"\";s:17:\"color_footer_text\";s:0:\"\";s:17:\"color_footer_link\";s:0:\"\";s:23:\"color_footer_link_hover\";s:0:\"\";s:18:\"style_bg_copyright\";s:0:\"\";s:20:\"color_copyright_text\";s:0:\"\";s:26:\"color_copyright_link_hover\";s:0:\"\";s:9:\"font_body\";a:7:{s:11:\"font-family\";s:6:\"Roboto\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:7:\"subsets\";s:5:\"latin\";s:10:\"text-align\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:5:\"color\";s:0:\"\";}s:9:\"font_menu\";a:8:{s:11:\"font-family\";s:10:\"Montserrat\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:5:\"latin\";s:10:\"text-align\";s:0:\"\";s:5:\"color\";s:0:\"\";}s:12:\"font_heading\";a:6:{s:11:\"font-family\";s:10:\"Montserrat\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:7:\"subsets\";s:5:\"latin\";s:10:\"text-align\";s:0:\"\";s:5:\"color\";s:0:\"\";}s:11:\"post_layout\";s:2:\"rb\";s:15:\"post_page_title\";s:15:\"Blog Page Title\";s:9:\"post_tags\";s:1:\"1\";s:11:\"post_author\";s:1:\"1\";s:14:\"page_portfolio\";s:4:\"2337\";s:12:\"page_service\";s:2:\"74\";s:10:\"woo_layout\";s:2:\"rb\";s:9:\"woo_count\";s:1:\"9\";s:10:\"social_url\";a:13:{s:8:\"facebook\";s:32:\"https://www.facebook.com/IMERTEC\";s:6:\"google\";s:1:\"#\";s:7:\"twitter\";s:1:\"#\";s:8:\"linkedin\";s:1:\"#\";s:8:\"dribbble\";s:1:\"#\";s:9:\"instagram\";s:1:\"#\";s:9:\"pinterest\";s:1:\"#\";s:10:\"foursquare\";s:1:\"#\";s:6:\"tumblr\";s:1:\"#\";s:7:\"youtube\";s:1:\"#\";s:5:\"vimeo\";s:1:\"#\";s:6:\"flickr\";s:1:\"#\";s:3:\"rss\";s:1:\"#\";}s:9:\"custom_js\";s:0:\"\";s:10:\"custom_css\";s:0:\"\";s:14:\"sidebar_widget\";a:1:{i:0;s:8:\"Services\";}s:15:\"envato_username\";s:0:\"\";s:10:\"envato_api\";s:0:\"\";}", "yes");
INSERT INTO `wpge_options` VALUES("156", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wpge_options` VALUES("157", "redux_version_upgraded_from", "3.6.7.7", "yes");
INSERT INTO `wpge_options` VALUES("160", "widget_mc4wp_form_widget", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("161", "vc_version", "4.12", "yes");
INSERT INTO `wpge_options` VALUES("196", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `wpge_options` VALUES("197", "woocommerce_enable_reviews", "yes", "yes");
INSERT INTO `wpge_options` VALUES("198", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `wpge_options` VALUES("199", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `wpge_options` VALUES("200", "woocommerce_enable_review_rating", "yes", "yes");
INSERT INTO `wpge_options` VALUES("201", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `wpge_options` VALUES("202", "woocommerce_shop_page_id", "6", "yes");
INSERT INTO `wpge_options` VALUES("203", "woocommerce_shop_page_display", "", "yes");
INSERT INTO `wpge_options` VALUES("204", "woocommerce_category_archive_display", "", "yes");
INSERT INTO `wpge_options` VALUES("205", "woocommerce_default_catalog_orderby", "menu_order", "yes");
INSERT INTO `wpge_options` VALUES("206", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `wpge_options` VALUES("207", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `wpge_options` VALUES("208", "shop_catalog_image_size", "a:3:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"300\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("209", "shop_single_image_size", "a:3:{s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("210", "shop_thumbnail_image_size", "a:3:{s:5:\"width\";s:3:\"180\";s:6:\"height\";s:3:\"180\";s:4:\"crop\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("211", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `wpge_options` VALUES("212", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `wpge_options` VALUES("213", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `wpge_options` VALUES("214", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `wpge_options` VALUES("215", "woocommerce_stock_email_recipient", "admin@imertec.com.ec", "no");
INSERT INTO `wpge_options` VALUES("216", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `wpge_options` VALUES("217", "woocommerce_notify_no_stock_amount", "0", "yes");
INSERT INTO `wpge_options` VALUES("218", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `wpge_options` VALUES("219", "woocommerce_stock_format", "", "yes");
INSERT INTO `wpge_options` VALUES("220", "woocommerce_file_download_method", "force", "no");
INSERT INTO `wpge_options` VALUES("221", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `wpge_options` VALUES("222", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `wpge_options` VALUES("223", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `wpge_options` VALUES("224", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `wpge_options` VALUES("225", "woocommerce_shipping_tax_class", "inherit", "yes");
INSERT INTO `wpge_options` VALUES("226", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `wpge_options` VALUES("38354", "woocommerce_refund_returns_page_id", "2705", "yes");
INSERT INTO `wpge_options` VALUES("228", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `wpge_options` VALUES("229", "woocommerce_tax_display_cart", "excl", "no");
INSERT INTO `wpge_options` VALUES("230", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `wpge_options` VALUES("152", "wpcf7", "a:2:{s:7:\"version\";s:5:\"5.5.6\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1639526860;s:7:\"version\";s:5:\"5.5.3\";s:11:\"count_valid\";i:3;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO `wpge_options` VALUES("153", "ReduxFrameworkPlugin_ACTIVATED_NOTICES", "a:1:{i:0;s:138:\"Redux Framework has an embedded demo. <a href=\"./plugins.php?ReduxFrameworkPlugin=demo\">Click here to activate the sample config file.</a>\";}", "yes");
INSERT INTO `wpge_options` VALUES("231", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `wpge_options` VALUES("232", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `wpge_options` VALUES("233", "woocommerce_shipping_cost_requires_address", "no", "no");
INSERT INTO `wpge_options` VALUES("234", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `wpge_options` VALUES("235", "woocommerce_shipping_debug_mode", "no", "no");
INSERT INTO `wpge_options` VALUES("236", "woocommerce_enable_coupons", "yes", "yes");
INSERT INTO `wpge_options` VALUES("237", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `wpge_options` VALUES("238", "woocommerce_enable_guest_checkout", "yes", "no");
INSERT INTO `wpge_options` VALUES("239", "woocommerce_force_ssl_checkout", "no", "yes");
INSERT INTO `wpge_options` VALUES("240", "woocommerce_unforce_ssl_checkout", "no", "yes");
INSERT INTO `wpge_options` VALUES("241", "woocommerce_cart_page_id", "7", "yes");
INSERT INTO `wpge_options` VALUES("242", "woocommerce_checkout_page_id", "8", "yes");
INSERT INTO `wpge_options` VALUES("243", "woocommerce_terms_page_id", "", "no");
INSERT INTO `wpge_options` VALUES("244", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `wpge_options` VALUES("245", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `wpge_options` VALUES("246", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `wpge_options` VALUES("165", "theme_st_options-transients", "a:3:{s:14:\"changed_values\";a:1:{s:11:\"header_info\";a:4:{s:7:\"label_1\";s:27:\"<i class=\"fa fa-phone\"></i>\";s:7:\"value_1\";s:41:\"(02) 2408184 ; (02) 2815012; 099 910 1680\";s:7:\"label_2\";s:32:\"<i class=\"fa fa-envelope-o\"></i>\";s:7:\"value_2\";s:21:\"ventas@imertec.com.ec\";}}s:9:\"last_save\";i:1556983292;s:13:\"last_compiler\";i:1517194699;}", "yes");
INSERT INTO `wpge_options` VALUES("166", "wpb_js_composer_license_activation_notified", "yes", "yes");
INSERT INTO `wpge_options` VALUES("167", "mc4wp_flash_messages", "a:0:{}", "no");
INSERT INTO `wpge_options` VALUES("743", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:8:\"producto\";s:13:\"category_base\";s:18:\"categoria-producto\";s:8:\"tag_base\";s:17:\"etiqueta-producto\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "yes");
INSERT INTO `wpge_options` VALUES("744", "current_theme_supports_woocommerce", "yes", "yes");
INSERT INTO `wpge_options` VALUES("745", "woocommerce_queue_flush_rewrite_rules", "no", "yes");
INSERT INTO `wpge_options` VALUES("749", "default_product_cat", "95", "yes");
INSERT INTO `wpge_options` VALUES("247", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `wpge_options` VALUES("248", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `wpge_options` VALUES("249", "woocommerce_myaccount_page_id", "9", "yes");
INSERT INTO `wpge_options` VALUES("250", "woocommerce_enable_signup_and_login_from_checkout", "yes", "no");
INSERT INTO `wpge_options` VALUES("251", "woocommerce_enable_myaccount_registration", "no", "no");
INSERT INTO `wpge_options` VALUES("252", "woocommerce_enable_checkout_login_reminder", "yes", "no");
INSERT INTO `wpge_options` VALUES("253", "woocommerce_registration_generate_username", "yes", "no");
INSERT INTO `wpge_options` VALUES("254", "woocommerce_registration_generate_password", "no", "no");
INSERT INTO `wpge_options` VALUES("255", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `wpge_options` VALUES("256", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `wpge_options` VALUES("257", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `wpge_options` VALUES("258", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `wpge_options` VALUES("259", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `wpge_options` VALUES("260", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `wpge_options` VALUES("261", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `wpge_options` VALUES("262", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `wpge_options` VALUES("263", "woocommerce_email_from_name", "IMERTEC", "no");
INSERT INTO `wpge_options` VALUES("264", "woocommerce_email_from_address", "admin@imertec.com.ec", "no");
INSERT INTO `wpge_options` VALUES("265", "woocommerce_email_header_image", "", "no");
INSERT INTO `wpge_options` VALUES("266", "woocommerce_email_footer_text", "IMERTEC", "no");
INSERT INTO `wpge_options` VALUES("267", "woocommerce_email_base_color", "#96588a", "no");
INSERT INTO `wpge_options` VALUES("268", "woocommerce_email_background_color", "#f7f7f7", "no");
INSERT INTO `wpge_options` VALUES("269", "woocommerce_email_body_background_color", "#ffffff", "no");
INSERT INTO `wpge_options` VALUES("270", "woocommerce_email_text_color", "#3c3c3c", "no");
INSERT INTO `wpge_options` VALUES("271", "woocommerce_api_enabled", "yes", "yes");
INSERT INTO `wpge_options` VALUES("38198", "woocommerce_schema_version", "430", "yes");
INSERT INTO `wpge_options` VALUES("293", "woocommerce_meta_box_errors", "a:0:{}", "yes");
INSERT INTO `wpge_options` VALUES("33787", "woocommerce_version", "6.3.1", "yes");
INSERT INTO `wpge_options` VALUES("38165", "woocommerce_db_version", "5.9.1", "yes");
INSERT INTO `wpge_options` VALUES("277", "woocommerce_admin_notices", "a:2:{i:0;s:6:\"update\";i:1;s:14:\"template_files\";}", "yes");
INSERT INTO `wpge_options` VALUES("278", "_transient_woocommerce_webhook_ids", "a:0:{}", "yes");
INSERT INTO `wpge_options` VALUES("279", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("280", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("281", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("282", "widget_woocommerce_price_filter", "a:2:{i:2;a:1:{s:5:\"title\";s:15:\"Filter by price\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("283", "widget_woocommerce_product_categories", "a:2:{i:2;a:6:{s:5:\"title\";s:18:\"Product Categories\";s:7:\"orderby\";s:4:\"name\";s:8:\"dropdown\";i:0;s:5:\"count\";i:0;s:12:\"hierarchical\";s:1:\"1\";s:18:\"show_children_only\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("284", "widget_woocommerce_product_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("285", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("286", "widget_woocommerce_products", "a:2:{i:2;a:7:{s:5:\"title\";s:8:\"Products\";s:6:\"number\";s:1:\"3\";s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("287", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("288", "widget_woocommerce_top_rated_products", "a:2:{i:2;a:2:{s:5:\"title\";s:18:\"Top Rated Products\";s:6:\"number\";s:1:\"3\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("289", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("290", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("318", "category_children", "a:0:{}", "yes");
INSERT INTO `wpge_options` VALUES("748", "product_cat_children", "a:0:{}", "yes");
INSERT INTO `wpge_options` VALUES("294", "woocommerce_product_type", "both", "yes");
INSERT INTO `wpge_options` VALUES("295", "woocommerce_allow_tracking", "yes", "yes");
INSERT INTO `wpge_options` VALUES("296", "woocommerce_tracker_last_send", "1710947182", "yes");
INSERT INTO `wpge_options` VALUES("297", "woocommerce_ppec_paypal_settings", "a:1:{s:7:\"enabled\";s:2:\"no\";}", "yes");
INSERT INTO `wpge_options` VALUES("298", "woocommerce_paypal_settings", "a:9:{s:7:\"enabled\";s:2:\"no\";s:5:\"email\";b:0;s:5:\"title\";s:6:\"PayPal\";s:11:\"description\";s:100:\"Paga a través de PayPal; puedes pagar con tu tarjeta de crédito si no tienes una cuenta de PayPal.\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:14:\"receiver_email\";b:0;s:14:\"identity_token\";s:0:\"\";s:12:\"_should_load\";s:3:\"yes\";}", "yes");
INSERT INTO `wpge_options` VALUES("299", "_transient_shipping-transient-version", "1517190160", "yes");
INSERT INTO `wpge_options` VALUES("300", "woocommerce_flat_rate_1_settings", "a:3:{s:5:\"title\";s:11:\"Precio fijo\";s:10:\"tax_status\";s:7:\"taxable\";s:4:\"cost\";s:2:\"20\";}", "yes");
INSERT INTO `wpge_options` VALUES("301", "woocommerce_flat_rate_2_settings", "a:3:{s:5:\"title\";s:11:\"Precio fijo\";s:10:\"tax_status\";s:7:\"taxable\";s:4:\"cost\";s:2:\"20\";}", "yes");
INSERT INTO `wpge_options` VALUES("302", "_transient_product_query-transient-version", "1756438735", "yes");
INSERT INTO `wpge_options` VALUES("413", "_transient_orders-transient-version", "1517238531", "yes");
INSERT INTO `wpge_options` VALUES("326", "revslider-update-check-short", "1756392863", "yes");
INSERT INTO `wpge_options` VALUES("327", "revslider-templates-check", "1756221133", "yes");
INSERT INTO `wpge_options` VALUES("334", "revslider-global-settings", "{\"version\":\"6.2.0\",\"permission\":\"admin\",\"includeids\":\"\",\"script\":{\"footer\":true,\"defer\":true,\"full\":false},\"fonturl\":\"\",\"size\":{\"desktop\":1240,\"notebook\":1024,\"tablet\":778,\"mobile\":480}}", "yes");
INSERT INTO `wpge_options` VALUES("335", "revslider_update_version", "6.4.10", "yes");
INSERT INTO `wpge_options` VALUES("336", "widget_rev-slider-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("402", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wpge_options` VALUES("422", "woocommerce_tracker_ua", "a:12:{i:0;s:129:\"mozilla/5.0 (windows nt 10.0; win64; x64) applewebkit/537.36 (khtml, like gecko) chrome/58.0.3029.110 safari/537.36 edge/16.16299\";i:1;s:128:\"mozilla/5.0 (windows nt 10.0; win64; x64) applewebkit/537.36 (khtml, like gecko) chrome/51.0.2704.79 safari/537.36 edge/14.14393\";i:2;s:76:\"mozilla/5.0 (windows nt 10.0; wow64; trident/7.0; touch; rv:11.0) like gecko\";i:3;s:69:\"mozilla/5.0 (windows nt 10.0; wow64; trident/7.0; rv:11.0) like gecko\";i:4;s:129:\"mozilla/5.0 (windows nt 10.0; win64; x64) applewebkit/537.36 (khtml, like gecko) chrome/64.0.3282.140 safari/537.36 edge/18.17763\";i:5;s:115:\"mozilla/5.0 (windows nt 10.0; win64; x64) applewebkit/537.36 (khtml, like gecko) chrome/74.0.3729.108 safari/537.36\";i:6;s:117:\"mozilla/5.0 (macintosh; intel mac os x 10_10_5) applewebkit/603.3.8 (khtml, like gecko) version/10.1.2 safari/603.3.8\";i:7;s:113:\"Mozilla/5.0 (Linux; Android 10; SM-T295) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/96.0.4664.92 Safari/537.36\";i:8;s:131:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/96.0.4664.93 Safari/537.36 Edg/96.0.1054.53\";i:9;s:131:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36 Edg/97.0.1072.62\";i:10;s:131:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.99 Safari/537.36 Edg/97.0.1072.76\";i:11;s:131:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36 Edg/99.0.1150.39\";}", "yes");
INSERT INTO `wpge_options` VALUES("582", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:20:\"admin@imertec.com.ec\";s:7:\"version\";s:6:\"5.8.11\";s:9:\"timestamp\";i:1754461018;}", "no");
INSERT INTO `wpge_options` VALUES("38161", "woocommerce_thumbnail_image_width", "300", "yes");
INSERT INTO `wpge_options` VALUES("38162", "woocommerce_thumbnail_cropping", "1:1", "yes");
INSERT INTO `wpge_options` VALUES("38163", "woocommerce_single_image_width", "600", "yes");
INSERT INTO `wpge_options` VALUES("38105", "db_upgraded", "", "yes");
INSERT INTO `wpge_options` VALUES("9804", "woocommerce_maybe_regenerate_images_hash", "991b1ca641921cf0f5baf7a2fe85861b", "yes");
INSERT INTO `wpge_options` VALUES("13999", "mc4wp", "a:4:{s:7:\"api_key\";s:0:\"\";s:20:\"allow_usage_tracking\";i:0;s:15:\"debug_log_level\";s:7:\"warning\";s:18:\"first_activated_on\";i:1567440363;}", "yes");
INSERT INTO `wpge_options` VALUES("21015", "rs-templates-new", "", "no");
INSERT INTO `wpge_options` VALUES("21016", "rs-templates", "a:2:{s:6:\"slider\";a:800:{i:0;a:24:{s:2:\"id\";s:1:\"1\";s:5:\"title\";s:16:\"Classic Carousel\";s:5:\"alias\";s:16:\"classic-carousel\";s:3:\"zip\";s:20:\"classic-carousel.zip\";s:3:\"uid\";s:32:\"146a01dd380c0cdee85c4456ee68cd84\";s:3:\"img\";s:27:\"classic-carousel/slider.jpg\";s:7:\"preview\";s:147:\"http://revolution.themepunch.com/carousel-slider-plugin/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=carousel-slider-plugin\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:141:\"<span class=\"ttm_content\">Our classic, full-width carousel example. Drag, swipe or click to navigate!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-22 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:1;a:24:{s:2:\"id\";s:1:\"2\";s:5:\"title\";s:14:\"Classic Slider\";s:5:\"alias\";s:13:\"classicslider\";s:3:\"zip\";s:17:\"classicslider.zip\";s:3:\"uid\";s:32:\"a0d6a9248c9066b404ba0f1cdadc5cf2\";s:3:\"img\";s:24:\"classicslider/slider.jpg\";s:7:\"preview\";s:157:\"http://revolution.themepunch.com/wordpress-slideshow-gallery/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-slideshow-gallery\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:136:\" <span class=\"ttm_content\">A classic slideshow example with timer, bullets and arrow navigation.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:2;a:24:{s:2:\"id\";s:1:\"3\";s:5:\"title\";s:12:\"Content Tabs\";s:5:\"alias\";s:11:\"contenttabs\";s:3:\"zip\";s:15:\"contenttabs.zip\";s:3:\"uid\";s:32:\"e02e91604b690123a3d07a65582c4fd0\";s:3:\"img\";s:22:\"contenttabs/slider.jpg\";s:7:\"preview\";s:161:\"http://revolution.themepunch.com/wordpress-content-tabs-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-content-tabs-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:170:\" <span class=\"ttm_content\">An auto-size slider with a cool split-text animation effect. Navigate with vertical bullets and thumbs.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:3;a:25:{s:2:\"id\";s:1:\"4\";s:5:\"title\";s:13:\"Facebook Feed\";s:5:\"alias\";s:13:\"facebook-feed\";s:3:\"zip\";s:17:\"facebook-feed.zip\";s:3:\"uid\";s:32:\"5506431d5b1babcb25dcf52c508d42e3\";s:3:\"img\";s:24:\"facebook-feed/slider.jpg\";s:7:\"preview\";s:149:\"http://revolution.themepunch.com/wordpress-facebook-feed/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-facebook-feed\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:174:\"<span class=\"ttm_content\"> This slider is automatically populated by a Facebook stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Facebook Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:4;a:24:{s:2:\"id\";s:1:\"5\";s:5:\"title\";s:7:\"Fashion\";s:5:\"alias\";s:7:\"fashion\";s:3:\"zip\";s:11:\"fashion.zip\";s:3:\"uid\";s:32:\"4f4b914d6db35e19101ff003c4e7ea3a\";s:3:\"img\";s:18:\"fashion/slider.jpg\";s:7:\"preview\";s:165:\"http://revolution.themepunch.com/wordpress-one-page-slider-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-one-page-slider-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:183:\"  <span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:5;a:24:{s:2:\"id\";s:1:\"6\";s:5:\"title\";s:14:\"Flickr Gallery\";s:5:\"alias\";s:14:\"flickr-gallery\";s:3:\"zip\";s:18:\"flickr-gallery.zip\";s:3:\"uid\";s:32:\"ad85cfac7acfa678e6a1b8febfee51ed\";s:3:\"img\";s:25:\"flickr-gallery/slider.jpg\";s:7:\"preview\";s:149:\"http://revolution.themepunch.com/wordpress-flickr-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-flickr-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:173:\" <span class=\"ttm_content\"> This slider is automatically populated by a Flickr stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:6;a:26:{s:2:\"id\";s:1:\"7\";s:5:\"title\";s:3:\"Gym\";s:5:\"alias\";s:3:\"gym\";s:3:\"zip\";s:7:\"gym.zip\";s:3:\"uid\";s:32:\"e4d81f13f96fb9bc905f4ad89615032b\";s:3:\"img\";s:14:\"gym/slider.jpg\";s:7:\"preview\";s:153:\"http://revolution.themepunch.com/one-page-wordpress-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=one-page-wordpress-slider\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:189:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the slider menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:7;a:24:{s:2:\"id\";s:1:\"8\";s:5:\"title\";s:18:\"Highlight Carousel\";s:5:\"alias\";s:18:\"highlight-carousel\";s:3:\"zip\";s:22:\"highlight-carousel.zip\";s:3:\"uid\";s:32:\"ada52163f723a942f782351fa0396b3d\";s:3:\"img\";s:29:\"highlight-carousel/slider.jpg\";s:7:\"preview\";s:147:\"http://revolution.themepunch.com/wordpress-swipe-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-swipe-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:138:\"  <span class=\"ttm_content\">A swipe-controlled carousel with an additional tab-based navigation.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:8;a:24:{s:2:\"id\";s:1:\"9\";s:5:\"title\";s:18:\"Highlight Showcase\";s:5:\"alias\";s:18:\"highlight-showcase\";s:3:\"zip\";s:22:\"highlight-showcase.zip\";s:3:\"uid\";s:32:\"2bfe0bd410fb48fec9d942eab1e21530\";s:3:\"img\";s:29:\"highlight-showcase/slider.jpg\";s:7:\"preview\";s:159:\"http://revolution.themepunch.com/wordpress-parallax-slideshow/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-slideshow\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">A tab-based navigation, a slideshow timer and cool animations make this slider interesting!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:9;a:24:{s:2:\"id\";s:2:\"10\";s:5:\"title\";s:10:\"Image Hero\";s:5:\"alias\";s:10:\"image-hero\";s:3:\"zip\";s:13:\"imagehero.zip\";s:3:\"uid\";s:32:\"7db18781d44f2adc28c962440894aac1\";s:3:\"img\";s:20:\"imagehero/slider.jpg\";s:7:\"preview\";s:143:\"http://revolution.themepunch.com/wordpress-hero-image/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-hero-image\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:121:\"<span class=\"ttm_content\">A commonly used full-width image hero block with texts.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:10;a:26:{s:2:\"id\";s:2:\"11\";s:5:\"title\";s:17:\"Instagram Gallery\";s:5:\"alias\";s:13:\"insta-gallery\";s:3:\"zip\";s:17:\"insta-gallery.zip\";s:3:\"uid\";s:32:\"711732b0d42ec2b57818a2b9b1d86cba\";s:3:\"img\";s:24:\"insta-gallery/slider.jpg\";s:7:\"preview\";s:157:\"http://revolution.themepunch.com/wordpress-instagram-gallery/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-instagram-gallery\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"640\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:174:\"<span class=\"ttm_content\">This slider is automatically populated by a Instagram stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:416:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Instagram Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:11;a:26:{s:2:\"id\";s:2:\"12\";s:5:\"title\";s:21:\"Levano Restaurant Bar\";s:5:\"alias\";s:19:\"levanorestaurantbar\";s:3:\"zip\";s:23:\"levanorestaurantbar.zip\";s:3:\"uid\";s:32:\"4178f837db67d1b2eb6cb5840bbd0b42\";s:3:\"img\";s:30:\"levanorestaurantbar/slider.jpg\";s:7:\"preview\";s:161:\"http://revolution.themepunch.com/wordpress-front-page-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-front-page-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:181:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:12;a:25:{s:2:\"id\";s:2:\"13\";s:5:\"title\";s:19:\"Main Feature Slider\";s:5:\"alias\";s:11:\"mainfeature\";s:3:\"zip\";s:15:\"mainfeature.zip\";s:3:\"uid\";s:32:\"1e002a3230ab00095bedc6f60393ee7f\";s:3:\"img\";s:22:\"mainfeature/slider.jpg\";s:7:\"preview\";s:127:\"http://revolution.themepunch.com/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=revolution.themepunch.com\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"750\";s:11:\"description\";s:127:\" <span class=\"ttm_content\">A slightly stripped down version of the main preview slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:13;a:26:{s:2:\"id\";s:2:\"14\";s:5:\"title\";s:17:\"Media Gallery Two\";s:5:\"alias\";s:17:\"media-gallery-two\";s:3:\"zip\";s:21:\"media-gallery-two.zip\";s:3:\"uid\";s:32:\"d002f1b1b55805f9322c264c5504ba5a\";s:3:\"img\";s:28:\"media-gallery-two/slider.jpg\";s:7:\"preview\";s:163:\"http://revolution.themepunch.com/wordpress-media-gallery-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-media-gallery-slider\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:6:\"6.2.22\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"692\";s:11:\"description\";s:127:\"<span class=\"ttm_content\">A media gallery example with Vimeo, HTML5 and Youtube videos.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change media and titles.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:14;a:25:{s:2:\"id\";s:2:\"15\";s:5:\"title\";s:23:\"Media Carousel Autoplay\";s:5:\"alias\";s:23:\"media-carousel-autoplay\";s:3:\"zip\";s:27:\"media-carousel-autoplay.zip\";s:3:\"uid\";s:32:\"393d7875b1cc9d933378b35e4f645d76\";s:3:\"img\";s:34:\"media-carousel-autoplay/slider.jpg\";s:7:\"preview\";s:149:\"http://revolution.themepunch.com/wordpress-media-gallery/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-media-gallery\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"720\";s:6:\"height\";s:3:\"405\";s:11:\"description\";s:153:\"<span class=\"ttm_content\">A media carousel with \"autoplay\" activated. Swipe or click tabs to navigate the slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change media and caption texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:15;a:25:{s:2:\"id\";s:2:\"16\";s:5:\"title\";s:21:\"News Background Video\";s:5:\"alias\";s:21:\"news-background-video\";s:3:\"zip\";s:17:\"news-bg-video.zip\";s:3:\"uid\";s:32:\"a0efe44ac3af0f958b3f84c816a08272\";s:3:\"img\";s:24:\"news-bg-video/slider.jpg\";s:7:\"preview\";s:151:\"http://revolution.themepunch.com/wordpress-content-blocks/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-content-blocks\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A hero block with HTML5 background video that plays when entering the screen.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:16;a:25:{s:2:\"id\";s:2:\"17\";s:5:\"title\";s:12:\"News Gallery\";s:5:\"alias\";s:12:\"news-gallery\";s:3:\"zip\";s:16:\"news-gallery.zip\";s:3:\"uid\";s:32:\"3a069c3b286dbb9ee435563f747e3300\";s:3:\"img\";s:23:\"news-gallery/slider.jpg\";s:7:\"preview\";s:147:\"http://revolution.themepunch.com/wordpress-news-rotator/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-news-rotator\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:131:\"<span class=\"ttm_content\">A news gallery slideshow with tab navigation. Great for any blog!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:17;a:25:{s:2:\"id\";s:2:\"18\";s:5:\"title\";s:23:\"News Gallery Post Based\";s:5:\"alias\";s:23:\"news-gallery-post-based\";s:3:\"zip\";s:27:\"news-gallery-post-based.zip\";s:3:\"uid\";s:32:\"32fe05b1039c29ab9420bfd15aec5488\";s:3:\"img\";s:34:\"news-gallery-post-based/slider.jpg\";s:7:\"preview\";s:145:\"http://revolution.themepunch.com/wordpress-post-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-post-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:125:\"<span class=\"ttm_content\"> This slider is automatically populated by WordPress posts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:423:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Post-Based Slider\"</a>. Make sure to select the post type you want to display in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:18;a:25:{s:2:\"id\";s:2:\"19\";s:5:\"title\";s:9:\"News Hero\";s:5:\"alias\";s:9:\"news-hero\";s:3:\"zip\";s:13:\"news-hero.zip\";s:3:\"uid\";s:32:\"96a0385538a17c8c81ed8175740f70ea\";s:3:\"img\";s:20:\"news-hero/slider.jpg\";s:7:\"preview\";s:151:\"http://revolution.themepunch.com/wordpress-content-blocks/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-content-blocks\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:107:\"<span class=\"ttm_content\">A image hero block with ken burns effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:19;a:25:{s:2:\"id\";s:2:\"20\";s:5:\"title\";s:10:\"News Video\";s:5:\"alias\";s:10:\"news-video\";s:3:\"zip\";s:14:\"news-video.zip\";s:3:\"uid\";s:32:\"f901e9e16e0363248156c2209eb584e9\";s:3:\"img\";s:21:\"news-video/slider.jpg\";s:7:\"preview\";s:151:\"http://revolution.themepunch.com/wordpress-content-blocks/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-content-blocks\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:128:\"<span class=\"ttm_content\">A Vimeo background video hero block with play / pause buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the video and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:20;a:26:{s:2:\"id\";s:2:\"21\";s:5:\"title\";s:15:\"Newsletter Hero\";s:5:\"alias\";s:15:\"newsletter-hero\";s:3:\"zip\";s:19:\"newsletter-hero.zip\";s:3:\"uid\";s:32:\"6290a9864d8c4c6311784586ed1cc5fe\";s:3:\"img\";s:26:\"newsletter-hero/slider.jpg\";s:7:\"preview\";s:157:\"http://revolution.themepunch.com/wordpress-newsletter-signup/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-newsletter-signup\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:137:\"<span class=\"ttm_content\">This hero block uses a custom styled Mailchimp newsletter signup field.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:435:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image, texts, and <a href=\"https://www.themepunch.com/faq/how-to-setup-mailchimp-for-the-newsletter-hero-template/\" target=\"_blank\">Mailchimp code</a>.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:21;a:25:{s:2:\"id\";s:2:\"22\";s:5:\"title\";s:11:\"Not Generic\";s:5:\"alias\";s:10:\"notgeneric\";s:3:\"zip\";s:14:\"notgeneric.zip\";s:3:\"uid\";s:32:\"9d87ba95e02210a9f82387add2ceadf9\";s:3:\"img\";s:21:\"notgeneric/slider.jpg\";s:7:\"preview\";s:157:\"http://revolution.themepunch.com/wordpress-fullscreen-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-fullscreen-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">A full-screen slider with a layer based navigation and sleek content elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:22;a:26:{s:2:\"id\";s:2:\"23\";s:5:\"title\";s:11:\"Photography\";s:5:\"alias\";s:11:\"photography\";s:3:\"zip\";s:15:\"photography.zip\";s:3:\"uid\";s:32:\"1b2072547afb75e49f33b016751ed360\";s:3:\"img\";s:22:\"photography/slider.jpg\";s:7:\"preview\";s:159:\"http://revolution.themepunch.com/wordpress-photography-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-photography-slider\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:23;a:25:{s:2:\"id\";s:2:\"24\";s:5:\"title\";s:20:\"Photography Carousel\";s:5:\"alias\";s:20:\"photography-carousel\";s:3:\"zip\";s:24:\"photography-carousel.zip\";s:3:\"uid\";s:32:\"9a84b859ba23dc49ba8784e3a86545fa\";s:3:\"img\";s:31:\"photography-carousel/slider.jpg\";s:7:\"preview\";s:149:\"http://revolution.themepunch.com/wordpress-photo-gallery/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-photo-gallery\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">A front-page carousel that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:24;a:26:{s:2:\"id\";s:2:\"25\";s:5:\"title\";s:16:\"Search Form Hero\";s:5:\"alias\";s:16:\"search-form-hero\";s:3:\"zip\";s:20:\"search-form-hero.zip\";s:3:\"uid\";s:32:\"e09eb1bd0f22b3a2b02a1aa251dd1f3e\";s:3:\"img\";s:27:\"search-form-hero/slider.jpg\";s:7:\"preview\";s:155:\"http://revolution.themepunch.com/wordpress-search-form-hero/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-search-form-hero\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This hero block uses a custom styled input field to show search results on a WordPress site.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:320:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image, texts, and search field code.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:25;a:25:{s:2:\"id\";s:2:\"26\";s:5:\"title\";s:17:\"Showcase Carousel\";s:5:\"alias\";s:16:\"showcasecarousel\";s:3:\"zip\";s:20:\"showcasecarousel.zip\";s:3:\"uid\";s:32:\"c5ca218398331bd2c064efc2f62eae56\";s:3:\"img\";s:27:\"showcasecarousel/slider.jpg\";s:7:\"preview\";s:159:\"http://revolution.themepunch.com/wordpress-cover-flow-gallery/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-cover-flow-gallery\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:129:\"<span class=\"ttm_content\">A fancy carousel that rotates, fades and scales slider items.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:284:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:26;a:25:{s:2:\"id\";s:2:\"27\";s:5:\"title\";s:11:\"Sports Hero\";s:5:\"alias\";s:11:\"sports-hero\";s:3:\"zip\";s:14:\"sportshero.zip\";s:3:\"uid\";s:32:\"8de7a145f32a362d618d2595ffa2f724\";s:3:\"img\";s:21:\"sportshero/slider.jpg\";s:7:\"preview\";s:143:\"http://revolution.themepunch.com/wordpress-image-hero/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-image-hero\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:113:\"<span class=\"ttm_content\">An sports themed image hero block with buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:28;a:25:{s:2:\"id\";s:2:\"29\";s:5:\"title\";s:13:\"Vimeo Gallery\";s:5:\"alias\";s:13:\"vimeo-gallery\";s:3:\"zip\";s:17:\"vimeo-gallery.zip\";s:3:\"uid\";s:32:\"fa824ce1ff3942ec268fc9eda60df539\";s:3:\"img\";s:24:\"vimeo-gallery/slider.jpg\";s:7:\"preview\";s:149:\"http://revolution.themepunch.com/wordpress-vimeo-gallery/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-vimeo-gallery\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"692\";s:11:\"description\";s:170:\"<span class=\"ttm_content\">This slider is automatically populated by a Vimeo stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:412:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Vimeo Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:29;a:25:{s:2:\"id\";s:2:\"30\";s:5:\"title\";s:10:\"Vimeo Hero\";s:5:\"alias\";s:9:\"vimeohero\";s:3:\"zip\";s:13:\"vimeohero.zip\";s:3:\"uid\";s:32:\"c575575f96173d88589cddcb06120b77\";s:3:\"img\";s:20:\"vimeohero/slider.jpg\";s:7:\"preview\";s:143:\"http://revolution.themepunch.com/wordpress-hero-vimeo/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-hero-vimeo\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:116:\"<span class=\"ttm_content\">A commonly used Vimeo video background hero block.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:30;a:25:{s:2:\"id\";s:2:\"31\";s:5:\"title\";s:16:\"Web Product Dark\";s:5:\"alias\";s:16:\"web-product-dark\";s:3:\"zip\";s:20:\"web-product-dark.zip\";s:3:\"uid\";s:32:\"39b872cf0608e63c3a503e58374dc30a\";s:3:\"img\";s:27:\"web-product-dark/slider.jpg\";s:7:\"preview\";s:155:\"http://revolution.themepunch.com/wordpress-frontpage-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-frontpage-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:31;a:25:{s:2:\"id\";s:2:\"32\";s:5:\"title\";s:21:\"Web Product Dark Hero\";s:5:\"alias\";s:21:\"web-product-dark-hero\";s:3:\"zip\";s:25:\"web-product-dark-hero.zip\";s:3:\"uid\";s:32:\"b6784e8925221f36677217979d26e6f0\";s:3:\"img\";s:32:\"web-product-dark-hero/slider.jpg\";s:7:\"preview\";s:147:\"http://revolution.themepunch.com/wordpress-header-image/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-header-image\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:162:\"<span class=\"ttm_content\">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:32;a:25:{s:2:\"id\";s:2:\"33\";s:5:\"title\";s:22:\"Web Product Light Hero\";s:5:\"alias\";s:22:\"web-product-light-hero\";s:3:\"zip\";s:26:\"web-product-light-hero.zip\";s:3:\"uid\";s:32:\"428e65d6aaa6ef775429989d50516492\";s:3:\"img\";s:33:\"web-product-light-hero/slider.jpg\";s:7:\"preview\";s:143:\"http://revolution.themepunch.com/hero-image-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=hero-image-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:162:\"<span class=\"ttm_content\">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:33;a:25:{s:2:\"id\";s:2:\"34\";s:5:\"title\";s:17:\"Web Product Light\";s:5:\"alias\";s:15:\"webproductlight\";s:3:\"zip\";s:19:\"webproductlight.zip\";s:3:\"uid\";s:32:\"fa23dab5bf1139c6393828647a9de4e0\";s:3:\"img\";s:26:\"webproductlight/slider.jpg\";s:7:\"preview\";s:143:\"http://revolution.themepunch.com/wordpress-cover-page/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-cover-page\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:34;a:25:{s:2:\"id\";s:2:\"35\";s:5:\"title\";s:15:\"Youtube Gallery\";s:5:\"alias\";s:15:\"youtube-gallery\";s:3:\"zip\";s:19:\"youtube-gallery.zip\";s:3:\"uid\";s:32:\"ee9e4928ac74f5f0c0b697ce708f5aa7\";s:3:\"img\";s:26:\"youtube-gallery/slider.jpg\";s:7:\"preview\";s:153:\"http://revolution.themepunch.com/wordpress-youtube-gallery/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-youtube-gallery\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:173:\"<span class=\"ttm_content\"> This slider is automatically populated by a YouTube stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:414:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"YouTube Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:35;a:26:{s:2:\"id\";s:2:\"36\";s:5:\"title\";s:12:\"Youtube Hero\";s:5:\"alias\";s:11:\"youtubehero\";s:3:\"zip\";s:15:\"youtubehero.zip\";s:3:\"uid\";s:32:\"e0b2c12a45841bdf21cb96305f2c85bf\";s:3:\"img\";s:22:\"youtubehero/slider.jpg\";s:7:\"preview\";s:151:\"http://revolution.themepunch.com/wordpress-youtube-header/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-youtube-header\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:104:\"<span class=\"ttm_content\">A YouTube video background hero block.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:633:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/enable-sound-for-the-youtube-hero-template/\" target=\"_blank\">enable sound for the background video</a><br /><br />\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:36;a:25:{s:2:\"id\";s:2:\"37\";s:5:\"title\";s:13:\"Scroll Effect\";s:5:\"alias\";s:13:\"scroll-effect\";s:3:\"zip\";s:17:\"scroll-effect.zip\";s:3:\"uid\";s:32:\"417f59e9db87aa7e47c8509eb88d4af6\";s:3:\"img\";s:23:\"scrolleffect/slide1.jpg\";s:7:\"preview\";s:155:\"http://revolution.themepunch.com/big-bold-fullscreen-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=big-bold-fullscreen-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:134:\"<span class=\"ttm_content\">A full-screen slider with a unique scroll effect and big, bold text.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:485:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:37;a:25:{s:2:\"id\";s:2:\"38\";s:5:\"title\";s:12:\"Content Zoom\";s:5:\"alias\";s:12:\"content-zoom\";s:3:\"zip\";s:16:\"content-zoom.zip\";s:3:\"uid\";s:32:\"42ef8cdb70d42ec6ff6fa3b69a027b5f\";s:3:\"img\";s:22:\"contentzoom/slide1.jpg\";s:7:\"preview\";s:141:\"http://revolution.themepunch.com/content-zoom-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=content-zoom-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:243:\"<span class=\"ttm_content\">A very unique full-width slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:38;a:25:{s:2:\"id\";s:2:\"39\";s:5:\"title\";s:13:\"Food Carousel\";s:5:\"alias\";s:13:\"food-carousel\";s:3:\"zip\";s:17:\"food-carousel.zip\";s:3:\"uid\";s:32:\"a7bf54527b6658a0a308c70c729779fe\";s:3:\"img\";s:29:\"foodcarousel/slider_cover.jpg\";s:7:\"preview\";s:143:\"http://revolution.themepunch.com/food-carousel-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=food-carousel-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:267:\"<span class=\"ttm_content\">A fancy carousel with detail content on each slide. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to show and hide layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:40;a:25:{s:2:\"id\";s:2:\"41\";s:5:\"title\";s:22:\"Travel Static Captions\";s:5:\"alias\";s:22:\"travel-static-captions\";s:3:\"zip\";s:26:\"travel-static-captions.zip\";s:3:\"uid\";s:32:\"bbe7d61c7c741ebc7aa1ce1082b0cb71\";s:3:\"img\";s:33:\"travel-static-captions/slide1.jpg\";s:7:\"preview\";s:135:\"http://revolution.themepunch.com/travel-slideshow/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=travel-slideshow\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:148:\"<span class=\"ttm_content\">A slideshow example with static captions layers above a rotating image background.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:41;a:25:{s:2:\"id\";s:2:\"42\";s:5:\"title\";s:7:\"Concept\";s:5:\"alias\";s:7:\"concept\";s:3:\"zip\";s:11:\"concept.zip\";s:3:\"uid\";s:32:\"47cb06083e87503762f6746725117a3c\";s:3:\"img\";s:18:\"concept/slide1.jpg\";s:7:\"preview\";s:157:\"http://revolution.themepunch.com/fullscreen-wordpress-plugin/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=fullscreen-wordpress-plugin\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">A full-screen slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:42;a:25:{s:2:\"id\";s:2:\"43\";s:5:\"title\";s:15:\"True Fullscreen\";s:5:\"alias\";s:17:\"fullscreen-button\";s:3:\"zip\";s:21:\"fullscreen-button.zip\";s:3:\"uid\";s:32:\"618a43bdf89333b555531f6d6ecde359\";s:3:\"img\";s:28:\"fullscreen-button/slide1.jpg\";s:7:\"preview\";s:157:\"http://revolution.themepunch.com/wordpress-sidebar-slideshow/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-sidebar-slideshow\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:246:\"<span class=\"ttm_content\">A slider with a full-screen button that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:297:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change the background images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:43;a:25:{s:2:\"id\";s:2:\"44\";s:5:\"title\";s:16:\"Creative Freedom\";s:5:\"alias\";s:15:\"creativefreedom\";s:3:\"zip\";s:19:\"creativefreedom.zip\";s:3:\"uid\";s:32:\"8902bf6c93126c2c6323626b9e872621\";s:3:\"img\";s:26:\"creativefreedom/slide1.jpg\";s:7:\"preview\";s:147:\"http://revolution.themepunch.com/wordpress-touch-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-touch-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A full-screen slider with a unique vertical navigation and 3D-parallax effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:290:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images, videos and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:44;a:25:{s:2:\"id\";s:2:\"45\";s:5:\"title\";s:17:\"3D Parallax Scene\";s:5:\"alias\";s:13:\"parallaxscene\";s:3:\"zip\";s:17:\"parallaxscene.zip\";s:3:\"uid\";s:32:\"51566f1ce649708e97a0f5dfaf05ea19\";s:3:\"img\";s:24:\"parallaxscene/slide1.jpg\";s:7:\"preview\";s:145:\"http://revolution.themepunch.com/wordpress-3d-parallax/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-3d-parallax\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:328:\"<span class=\"ttm_content\">A 3D-parallax hero scene with mouse-controlled effects. Smart image arrangement creates a convincing 3D effect. Tooltips are shown using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:45;a:25:{s:2:\"id\";s:2:\"46\";s:5:\"title\";s:10:\"Wow Factor\";s:5:\"alias\";s:15:\"slidingoverlays\";s:3:\"zip\";s:19:\"slidingoverlays.zip\";s:3:\"uid\";s:32:\"18002d17e8bc7ca61b0951f5305a759e\";s:3:\"img\";s:26:\"slidingoverlays/slide1.jpg\";s:7:\"preview\";s:157:\"http://revolution.themepunch.com/responsive-wordpress-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=responsive-wordpress-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:106:\"<span class=\"ttm_content\">A 3D-parallax effect full-screen slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:46;a:25:{s:2:\"id\";s:2:\"47\";s:5:\"title\";s:14:\"3D Web Product\";s:5:\"alias\";s:25:\"web-product-light-hero-3d\";s:3:\"zip\";s:29:\"web-product-light-hero-3d.zip\";s:3:\"uid\";s:32:\"efd345c5da805414093e46066cefd751\";s:3:\"img\";s:36:\"web-product-light-hero-3d/slide1.jpg\";s:7:\"preview\";s:139:\"http://revolution.themepunch.com/wordpress-3d-scene/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-3d-scene\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"668\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">A 3D-parallax hero scene slider with a convincing depth-effect and animated clouds.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:47;a:25:{s:2:\"id\";s:2:\"48\";s:5:\"title\";s:15:\"WooCommerce Big\";s:5:\"alias\";s:6:\"woobig\";s:3:\"zip\";s:10:\"woobig.zip\";s:3:\"uid\";s:32:\"bfb09a39656c7c80e86b468fc5b3403c\";s:3:\"img\";s:17:\"woobig/slide1.jpg\";s:7:\"preview\";s:139:\"http://revolution.themepunch.com/woocommerce-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=woocommerce-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:173:\"<span class=\"ttm_content\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"WooCommerce Slider\"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";i:2;s:11:\"woocommerce\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:48;a:25:{s:2:\"id\";s:2:\"49\";s:5:\"title\";s:17:\"WooCommerce Small\";s:5:\"alias\";s:16:\"woocommercesmall\";s:3:\"zip\";s:20:\"woocommercesmall.zip\";s:3:\"uid\";s:32:\"b17c2adcc5c4c4b68a7ac6fee32fa030\";s:3:\"img\";s:27:\"woocommercesmall/slide1.jpg\";s:7:\"preview\";s:139:\"http://revolution.themepunch.com/woocommerce-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=woocommerce-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:3:\"400\";s:6:\"height\";s:3:\"266\";s:11:\"description\";s:174:\" <span class=\"ttm_content\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"WooCommerce Slider\"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";i:2;s:11:\"woocommerce\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:49;a:25:{s:2:\"id\";s:2:\"50\";s:5:\"title\";s:17:\"Restaurant Header\";s:5:\"alias\";s:10:\"finedining\";s:3:\"zip\";s:14:\"finedining.zip\";s:3:\"uid\";s:32:\"03481a9e258501fbe3888b48830ea845\";s:3:\"img\";s:21:\"finedining/slide1.jpg\";s:7:\"preview\";s:147:\"http://revolution.themepunch.com/restaurant-hero-header/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=restaurant-hero-header\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:275:\"<span class=\"ttm_content\">A full-screen hero block slider that shows different background layers on button hover using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:50;a:25:{s:2:\"id\";s:2:\"51\";s:5:\"title\";s:21:\"Agency Website Header\";s:5:\"alias\";s:12:\"agency-intro\";s:3:\"zip\";s:16:\"agency-intro.zip\";s:3:\"uid\";s:32:\"e9be2afdd55a0c8d0d8d0cc12ba4c82f\";s:3:\"img\";s:23:\"agency-intro/slide1.jpg\";s:7:\"preview\";s:155:\"http://revolution.themepunch.com/agency-website-hero-header/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=agency-website-hero-header\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:302:\" <span class=\"ttm_content\">A full-screen hero block slider with ken burns effect and video modal on button click. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:51;a:25:{s:2:\"id\";s:2:\"52\";s:5:\"title\";s:11:\"Team Slider\";s:5:\"alias\";s:7:\"ourteam\";s:3:\"zip\";s:11:\"ourteam.zip\";s:3:\"uid\";s:32:\"d8eb1fec07a79202d1118bb17f70c233\";s:3:\"img\";s:18:\"ourteam/slide1.jpg\";s:7:\"preview\";s:183:\"http://revolution.themepunch.com/thumbnail-hover-slider-revolution-plugin/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=thumbnail-hover-slider-revolution-plugin\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:303:\"<span class=\"ttm_content\">A team slider that changes slides and displays additional information on thumbnail hover. It uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:657:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/\" target=\"_blank\">modify the thumbnails</a><br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:52;a:25:{s:2:\"id\";s:2:\"53\";s:5:\"title\";s:13:\"Team Carousel\";s:5:\"alias\";s:17:\"our-team-carousel\";s:3:\"zip\";s:21:\"our-team-carousel.zip\";s:3:\"uid\";s:32:\"37656d5dcab1f265c025cb2a3d669809\";s:3:\"img\";s:26:\"ourteamcarousel/slide1.jpg\";s:7:\"preview\";s:201:\"http://revolution.themepunch.com/thumbnail-hover-carousel-slider-revolution-plugin/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=thumbnail-hover-carousel-slider-revolution-plugin\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:306:\" <span class=\"ttm_content\">A team carousel that changes slides and displays additional information on thumbnail hover. It uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:659:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/\" target=\"_blank\">modify the thumbnails</a><br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:53;a:26:{s:2:\"id\";s:2:\"54\";s:5:\"title\";s:17:\"4K Youtube Slider\";s:5:\"alias\";s:13:\"betteryoutube\";s:3:\"zip\";s:17:\"betteryoutube.zip\";s:3:\"uid\";s:32:\"d7c5fef9f257037d7a148038aa2a1857\";s:3:\"img\";s:24:\"betteryoutube/slide1.jpg\";s:7:\"preview\";s:223:\"http://revolution.themepunch.com/fullscreen-4k-youtube-video-gallery-slider-revolution-plugin/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=fullscreen-4k-youtube-video-gallery-slider-revolution-plugin\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"675\";s:11:\"description\";s:293:\" <span class=\"ttm_content\">A full-screen youtube gallery with 4K videos as an example. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to breathe life into navigation elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:535:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change videos and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:54;a:25:{s:2:\"id\";s:2:\"55\";s:5:\"title\";s:21:\"Agency Website Header\";s:5:\"alias\";s:19:\"agencywebsiteheader\";s:3:\"zip\";s:23:\"agencywebsiteheader.zip\";s:3:\"uid\";s:32:\"c11d272c87277a7a38d9e7fd13e27947\";s:3:\"img\";s:30:\"agencywebsiteheader/slide1.jpg\";s:7:\"preview\";s:147:\"http://revolution.themepunch.com/fullscreen-hero-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=fullscreen-hero-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:245:\" <span class=\"ttm_content\">A very unique full-screen slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:509:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:55;a:25:{s:2:\"id\";s:2:\"56\";s:5:\"title\";s:11:\"Coming Soon\";s:5:\"alias\";s:10:\"comingsoon\";s:3:\"zip\";s:14:\"comingsoon.zip\";s:3:\"uid\";s:32:\"0f89edf995512e6d6e864a2ee7221829\";s:3:\"img\";s:21:\"comingsoon/slide1.jpg\";s:7:\"preview\";s:193:\"http://revolution.themepunch.com/coming-soon-wordpress-under-construction-site/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coming-soon-wordpress-under-construction-site\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:299:\"<span class=\"ttm_content\">A full-screen slider that can be used as a \"Coming Soon\" page. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to achieve various interaction possibilities.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:638:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\nInstructions for <a href=\"https://www.themepunch.com/faq/change-date-for-coming-soon-template/\" target=\"_blank\">how to change the date.</a><br /><br />\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:56;a:25:{s:2:\"id\";s:2:\"57\";s:5:\"title\";s:20:\"Christmas Snow Scene\";s:5:\"alias\";s:9:\"snowscene\";s:3:\"zip\";s:13:\"snowscene.zip\";s:3:\"uid\";s:32:\"a747bf0837caff86c62419a746690209\";s:3:\"img\";s:20:\"snowscene/slide1.jpg\";s:7:\"preview\";s:143:\"http://revolution.themepunch.com/christmas-snow-scene/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=christmas-snow-scene\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:141:\"<span class=\"ttm_content\">A slider with multiple christmas themed slides and a neat snow fall effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:485:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:153:\"[{\"path\":\"revslider-snow-addon\\/revslider-snow-addon.php\",\"name\":\"Snow AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:57;a:25:{s:2:\"id\";s:2:\"58\";s:5:\"title\";s:15:\"Rock Band Music\";s:5:\"alias\";s:8:\"rockband\";s:3:\"zip\";s:12:\"rockband.zip\";s:3:\"uid\";s:32:\"5f557a5fad2fd6ca982a6ae6e9619637\";s:3:\"img\";s:19:\"rockband/slide1.jpg\";s:7:\"preview\";s:195:\"http://revolution.themepunch.com/rock-band-music-theme-slider-revolution-plugin/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=rock-band-music-theme-slider-revolution-plugin\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:140:\" <span class=\"ttm_content\">A rock band themed hero block slider with an embedded SoundCloud element.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:58;a:25:{s:2:\"id\";s:2:\"59\";s:5:\"title\";s:18:\"Sleek Landing Page\";s:5:\"alias\";s:16:\"sleeklandingpage\";s:3:\"zip\";s:20:\"sleeklandingpage.zip\";s:3:\"uid\";s:32:\"07f7f2608936a8ae226213b7d99eee3f\";s:3:\"img\";s:27:\"sleeklandingpage/slide1.jpg\";s:7:\"preview\";s:175:\"http://revolution.themepunch.com/landing-page-free-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=landing-page-free-wordpress-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:191:\"<span class=\"ttm_content\">A full-screen slider that can be used as an App-Landing-Page. The object layers and custom animations create a unique effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-22 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:59;a:25:{s:2:\"id\";s:2:\"60\";s:5:\"title\";s:16:\"App Landing Page\";s:5:\"alias\";s:14:\"applandingpage\";s:3:\"zip\";s:18:\"applandingpage.zip\";s:3:\"uid\";s:32:\"38eb600893c1484ab8fd2a3dce3678d7\";s:3:\"img\";s:25:\"applandingpage/slide1.jpg\";s:7:\"preview\";s:163:\"http://revolution.themepunch.com/app-landing-page-free-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=app-landing-page-free-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:263:\"<span class=\"ttm_content\">A full-screen hero block that can be used as an app landing page. The detail view is build using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:60;a:25:{s:2:\"id\";s:2:\"61\";s:5:\"title\";s:10:\"Desk Scene\";s:5:\"alias\";s:9:\"deskscene\";s:3:\"zip\";s:13:\"deskscene.zip\";s:3:\"uid\";s:32:\"172a1a89a3e3b333cb4dbeb238f534c5\";s:3:\"img\";s:20:\"deskscene/slide1.jpg\";s:7:\"preview\";s:133:\"http://revolution.themepunch.com/hero-desk-scene/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=hero-desk-scene\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:135:\"<span class=\"ttm_content\">A beautiful desk scene with a cool reveal effect when scrolling down.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:61;a:25:{s:2:\"id\";s:2:\"62\";s:5:\"title\";s:17:\"Clean News Slider\";s:5:\"alias\";s:15:\"cleannewsslider\";s:3:\"zip\";s:19:\"cleannewsslider.zip\";s:3:\"uid\";s:32:\"82c3f521fe31b80984be0f19e1a9899e\";s:3:\"img\";s:26:\"cleannewsslider/slide1.jpg\";s:7:\"preview\";s:145:\"http://revolution.themepunch.com/wordpress-news-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-news-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:132:\"<span class=\"ttm_content\">A slideshow example with clean content and thumbnail navigation.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:62;a:25:{s:2:\"id\";s:2:\"63\";s:5:\"title\";s:13:\"Image Gallery\";s:5:\"alias\";s:12:\"imagegallery\";s:3:\"zip\";s:16:\"imagegallery.zip\";s:3:\"uid\";s:32:\"cef1d75357df2cb53b990c74a214813e\";s:3:\"img\";s:23:\"imagegallery/slide1.jpg\";s:7:\"preview\";s:163:\"http://revolution.themepunch.com/wordpress-photo-gallery-plugin/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-photo-gallery-plugin\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"667\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">A photo gallery suitable to display your images using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:63;a:25:{s:2:\"id\";s:2:\"64\";s:5:\"title\";s:19:\"Standard WP Gallery\";s:5:\"alias\";s:19:\"standard-wp-gallery\";s:3:\"zip\";s:23:\"standard-wp-gallery.zip\";s:3:\"uid\";s:32:\"632035b8a27652d8081dbdfa343dc93d\";s:3:\"img\";s:30:\"standard-wp-gallery/slide1.jpg\";s:7:\"preview\";s:163:\"http://revolution.themepunch.com/wordpress-photo-gallery-plugin/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-photo-gallery-plugin\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"667\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A photo gallery that uses the \"Standard WP Gallery\" add-on to display images.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:407:\"<span class=\"ttm_content\">Please follow the setup guide on the \"Standard WP Gallery\" add-on page.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";s:166:\"[{\"path\":\"revslider-gallery-addon\\/revslider-gallery-addon.php\",\"name\":\"WP Gallery AddOn\",\"url\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-photo-gallery-plugin\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:64;a:25:{s:2:\"id\";s:2:\"65\";s:5:\"title\";s:21:\"Clean News Post Based\";s:5:\"alias\";s:21:\"clean-news-post-based\";s:3:\"zip\";s:25:\"clean-news-post-based.zip\";s:3:\"uid\";s:32:\"f4cf5bbe51afa5a361754bb081cbabf2\";s:3:\"img\";s:32:\"clean-news-post-based/slide1.jpg\";s:7:\"preview\";s:145:\"http://revolution.themepunch.com/wordpress-news-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-news-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:125:\"<span class=\"ttm_content\"> This slider is automatically populated by WordPress posts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:423:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Post-Based Slider\"</a>. Make sure to select the post type you want to display in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:65;a:25:{s:2:\"id\";s:2:\"66\";s:5:\"title\";s:22:\"Interactive Whiteboard\";s:5:\"alias\";s:21:\"interactivewhiteboard\";s:3:\"zip\";s:25:\"interactivewhiteboard.zip\";s:3:\"uid\";s:32:\"058b4af535d6c6c7bcec5225845e3eb4\";s:3:\"img\";s:32:\"interactivewhiteboard/slide1.jpg\";s:7:\"preview\";s:189:\"http://revolution.themepunch.com/interactive-whiteboard-animation-free-addon/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=interactive-whiteboard-animation-free-addon\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:269:\"<span class=\"ttm_content\">This is the example slider from the Whiteboard add-on preview.<br/><a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used to achieve certain effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:541:\"<span class=\"ttm_content\">This slider template requires the <a href=\"https://www.themepunch.com/slider-revolution/whiteboard-addon/\" target=\"_blank\">Whiteboard add-on</a> to be installed. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:185:\"[{\"path\":\"revslider-whiteboard-addon\\/revslider-whiteboard-addon.php\",\"name\":\"Whiteboard AddOn\",\"url\":\"http:\\/\\/revolution.themepunch.com\\/interactive-whiteboard-animation-free-addon\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:66;a:25:{s:2:\"id\";s:2:\"68\";s:5:\"title\";s:17:\"Innovation Slider\";s:5:\"alias\";s:10:\"innovation\";s:3:\"zip\";s:14:\"innovation.zip\";s:3:\"uid\";s:32:\"d3440b69126d9c186fddc713b18b0002\";s:3:\"img\";s:21:\"innovation/slide1.jpg\";s:7:\"preview\";s:170:\"https://revolution.themepunch.com/best-wordpress-slider-plugin-2016/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=best-wordpress-slider-plugin-2016\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:7:\"5.2.3.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:258:\"<span class=\"ttm_content\">A full-screen slider with an elegant fade-out parallax effect. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:493:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images, videos and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-03-29 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:67;a:28:{s:2:\"id\";s:2:\"69\";s:5:\"title\";s:25:\"Dark Content Block - Menu\";s:5:\"alias\";s:24:\"dark-fullsite-block-menu\";s:3:\"zip\";s:34:\"packs/dark-fullsite-block-menu.zip\";s:3:\"uid\";s:32:\"bf4bd226719d3c3d3146592976e31ca1\";s:3:\"img\";s:35:\"dark-fullsite-block-menu/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:68;a:28:{s:2:\"id\";s:2:\"70\";s:5:\"title\";s:25:\"Dark Content Block - Hero\";s:5:\"alias\";s:21:\"dark-fullsite-block-1\";s:3:\"zip\";s:31:\"packs/dark-fullsite-block-1.zip\";s:3:\"uid\";s:32:\"d8859245fe600288ca932dc29aca751f\";s:3:\"img\";s:32:\"dark-fullsite-block-1/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:69;a:28:{s:2:\"id\";s:2:\"71\";s:5:\"title\";s:26:\"Dark Content Block - About\";s:5:\"alias\";s:27:\"dark-fullsite-block-2-about\";s:3:\"zip\";s:37:\"packs/dark-fullsite-block-2-about.zip\";s:3:\"uid\";s:32:\"298401901521a197a8294c1b4f73df3e\";s:3:\"img\";s:38:\"dark-fullsite-block-2-about/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:70;a:28:{s:2:\"id\";s:2:\"72\";s:5:\"title\";s:29:\"Dark Content Block - Services\";s:5:\"alias\";s:30:\"dark-fullsite-block-3-services\";s:3:\"zip\";s:40:\"packs/dark-fullsite-block-3-services.zip\";s:3:\"uid\";s:32:\"8da3ed605472ed6a26c745fb52f85f82\";s:3:\"img\";s:41:\"dark-fullsite-block-3-services/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:71;a:28:{s:2:\"id\";s:2:\"73\";s:5:\"title\";s:29:\"Dark Content Block - Products\";s:5:\"alias\";s:30:\"dark-fullsite-block-4-products\";s:3:\"zip\";s:40:\"packs/dark-fullsite-block-4-products.zip\";s:3:\"uid\";s:32:\"99e4f40399d20261a6131043d0e50b0c\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:422:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\r\n\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:72;a:28:{s:2:\"id\";s:2:\"74\";s:5:\"title\";s:33:\"Dark Content Block - Testimonials\";s:5:\"alias\";s:34:\"dark-fullsite-block-5-testimonials\";s:3:\"zip\";s:44:\"packs/dark-fullsite-block-5-testimonials.zip\";s:3:\"uid\";s:32:\"2f9121e0eedd51afe85e233d0743acab\";s:3:\"img\";s:45:\"dark-fullsite-block-5-testimonials/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:73;a:28:{s:2:\"id\";s:2:\"75\";s:5:\"title\";s:28:\"Dark Content Block - Callout\";s:5:\"alias\";s:29:\"dark-fullsite-block-6-callout\";s:3:\"zip\";s:39:\"packs/dark-fullsite-block-6-callout.zip\";s:3:\"uid\";s:32:\"55fbecb113ff21f050be7adc08637329\";s:3:\"img\";s:40:\"dark-fullsite-block-6-callout/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:74;a:28:{s:2:\"id\";s:2:\"76\";s:5:\"title\";s:27:\"Dark Content Block - Footer\";s:5:\"alias\";s:28:\"dark-fullsite-block-7-footer\";s:3:\"zip\";s:38:\"packs/dark-fullsite-block-7-footer.zip\";s:3:\"uid\";s:32:\"2ff517f5c7c54e3e0c2dd733cfd3400e\";s:3:\"img\";s:39:\"dark-fullsite-block-7-footer/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:75;a:28:{s:2:\"id\";s:2:\"77\";s:5:\"title\";s:26:\"Light Content Block - Menu\";s:5:\"alias\";s:19:\"fullsite-block-menu\";s:3:\"zip\";s:29:\"packs/fullsite-block-menu.zip\";s:3:\"uid\";s:32:\"8010971f34387d5f94a1f4e577ef382a\";s:3:\"img\";s:30:\"fullsite-block-menu/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:76;a:28:{s:2:\"id\";s:2:\"78\";s:5:\"title\";s:26:\"Light Content Block - Hero\";s:5:\"alias\";s:15:\"fullsite-block1\";s:3:\"zip\";s:25:\"packs/fullsite-block1.zip\";s:3:\"uid\";s:32:\"45bf7179843e01ce112e8ec754b0455c\";s:3:\"img\";s:26:\"fullsite-block1/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:77;a:28:{s:2:\"id\";s:2:\"79\";s:5:\"title\";s:27:\"Light Content Block - About\";s:5:\"alias\";s:22:\"fullsite-block-2-about\";s:3:\"zip\";s:32:\"packs/fullsite-block-2-about.zip\";s:3:\"uid\";s:32:\"8402b460638a746d36433cb161440b7d\";s:3:\"img\";s:33:\"fullsite-block-2-about/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:78;a:28:{s:2:\"id\";s:2:\"80\";s:5:\"title\";s:30:\"Light Content Block - Services\";s:5:\"alias\";s:25:\"fullsite-block-3-services\";s:3:\"zip\";s:35:\"packs/fullsite-block-3-services.zip\";s:3:\"uid\";s:32:\"7b8cea27f4d6ae17c5e1eae12457bd06\";s:3:\"img\";s:36:\"fullsite-block-3-services/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:79;a:28:{s:2:\"id\";s:2:\"81\";s:5:\"title\";s:30:\"Light Content Block - Products\";s:5:\"alias\";s:25:\"fullsite-block-4-products\";s:3:\"zip\";s:35:\"packs/fullsite-block-4-products.zip\";s:3:\"uid\";s:32:\"d148935362d7122636cda0635eae4be7\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:80;a:28:{s:2:\"id\";s:2:\"82\";s:5:\"title\";s:34:\"Light Content Block - Testimonials\";s:5:\"alias\";s:29:\"fullsite-block-5-testimonials\";s:3:\"zip\";s:39:\"packs/fullsite-block-5-testimonials.zip\";s:3:\"uid\";s:32:\"06255bfd421e40f71fa8197b839dbf03\";s:3:\"img\";s:40:\"fullsite-block-5-testimonials/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:81;a:28:{s:2:\"id\";s:2:\"83\";s:5:\"title\";s:29:\"Light Content Block - Callout\";s:5:\"alias\";s:24:\"fullsite-block-6-callout\";s:3:\"zip\";s:34:\"packs/fullsite-block-6-callout.zip\";s:3:\"uid\";s:32:\"8a88c3447676b613ec5db2fe5d63315c\";s:3:\"img\";s:35:\"fullsite-block-6-callout/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:82;a:28:{s:2:\"id\";s:2:\"84\";s:5:\"title\";s:28:\"Light Content Block - Footer\";s:5:\"alias\";s:23:\"fullsite-block-7-footer\";s:3:\"zip\";s:33:\"packs/fullsite-block-7-footer.zip\";s:3:\"uid\";s:32:\"34300b4407a2093eb2e1e08868fa8319\";s:3:\"img\";s:34:\"fullsite-block-7-footer/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:83;a:25:{s:2:\"id\";s:2:\"85\";s:5:\"title\";s:12:\"Tech Journal\";s:5:\"alias\";s:11:\"techjournal\";s:3:\"zip\";s:15:\"techjournal.zip\";s:3:\"uid\";s:32:\"7f92d70d1c108378f915b18c2ceb71d6\";s:3:\"img\";s:22:\"techjournal/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.1\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:130:\"<span class=\"ttm_content\">A full-width slider with navigation direction-based transitions.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:84;a:25:{s:2:\"id\";s:2:\"86\";s:5:\"title\";s:14:\"Car Dealership\";s:5:\"alias\";s:13:\"cardealership\";s:3:\"zip\";s:17:\"cardealership.zip\";s:3:\"uid\";s:32:\"bb010838855a8ae4d1dd68e139bf169e\";s:3:\"img\";s:24:\"cardealership/slide1.jpg\";s:7:\"preview\";s:146:\"https://revolution.themepunch.com/car-dealership-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=car-dealership-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"650\";s:11:\"description\";s:130:\"<span class=\"ttm_content\">A full-width slider with navigation direction-based transitions.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:85;a:25:{s:2:\"id\";s:2:\"87\";s:5:\"title\";s:22:\"FullScreen Menu Slider\";s:5:\"alias\";s:14:\"fullscreenmenu\";s:3:\"zip\";s:18:\"fullscreenmenu.zip\";s:3:\"uid\";s:32:\"6de81d74c4bf193e2e274d43038adc85\";s:3:\"img\";s:25:\"fullscreenmenu/slide1.jpg\";s:7:\"preview\";s:154:\"https://revolution.themepunch.com/wordpress-fullscreen-menu/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-fullscreen-menu\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:131:\"<span class=\"ttm_content\">A full-screen slider that contains a menu with slide blur effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:86;a:25:{s:2:\"id\";s:2:\"88\";s:5:\"title\";s:18:\"Creative Frontpage\";s:5:\"alias\";s:17:\"creativefrontpage\";s:3:\"zip\";s:21:\"creativefrontpage.zip\";s:3:\"uid\";s:32:\"0636cb368af3bcaa2f68eb0ebefe6439\";s:3:\"img\";s:28:\"creativefrontpage/slide1.jpg\";s:7:\"preview\";s:146:\"https://revolution.themepunch.com/best-wordpress-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=best-wordpress-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:246:\"<span class=\"ttm_content\">A full-screen slider with hidden slides that are triggered via  <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:95;a:25:{s:2:\"id\";s:2:\"97\";s:5:\"title\";s:21:\"Focus Parallax Effect\";s:5:\"alias\";s:13:\"focusparallax\";s:3:\"zip\";s:17:\"focusparallax.zip\";s:3:\"uid\";s:32:\"13bd15fb3ddf8b9841cb55b89389cc73\";s:3:\"img\";s:24:\"focusparallax/slide1.jpg\";s:7:\"preview\";s:169:\" https://revolution.themepunch.com/parallax-effect-wordpress-plugin/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=parallax-effect-wordpress-plugin\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:256:\"<span class=\"ttm_content\">A full-screen slider with mouse controlled parallax effects. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:96;a:25:{s:2:\"id\";s:2:\"98\";s:5:\"title\";s:14:\"Duotone Slider\";s:5:\"alias\";s:7:\"duotone\";s:3:\"zip\";s:11:\"duotone.zip\";s:3:\"uid\";s:32:\"494862ceb6cb7c6658ad7cd36848cccd\";s:3:\"img\";s:18:\"duotone/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/wordpress-header-image-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-header-image-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.4\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:252:\"<span class=\"ttm_content\">A full-screen slider with unique parallax scroll effect. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:97;a:28:{s:2:\"id\";s:2:\"99\";s:5:\"title\";s:12:\"Minimal Menu\";s:5:\"alias\";s:6:\"r_menu\";s:3:\"zip\";s:16:\"packs/r_menu.zip\";s:3:\"uid\";s:32:\"30d6a6895db1a5f29b1679061551c9f0\";s:3:\"img\";s:17:\"r_menu/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/minimal-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"110\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:98;a:28:{s:2:\"id\";s:3:\"100\";s:5:\"title\";s:12:\"Minimal Hero\";s:5:\"alias\";s:5:\"rhero\";s:3:\"zip\";s:16:\"packs/r_hero.zip\";s:3:\"uid\";s:32:\"b8b46186956f6e66ad0c08e4532bbbde\";s:3:\"img\";s:17:\"r_hero/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/minimal-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:99;a:28:{s:2:\"id\";s:3:\"101\";s:5:\"title\";s:13:\"Minimal About\";s:5:\"alias\";s:7:\"r_about\";s:3:\"zip\";s:17:\"packs/r_about.zip\";s:3:\"uid\";s:32:\"343010c4b4c03f92888c3e9e95bc2bb1\";s:3:\"img\";s:18:\"r_about/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/minimal-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:100;a:28:{s:2:\"id\";s:3:\"102\";s:5:\"title\";s:16:\"Minimal Products\";s:5:\"alias\";s:10:\"r_products\";s:3:\"zip\";s:20:\"packs/r_products.zip\";s:3:\"uid\";s:32:\"dda93e85c6a4456d132040147f087f39\";s:3:\"img\";s:21:\"r_products/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/minimal-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1100\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:101;a:28:{s:2:\"id\";s:3:\"103\";s:5:\"title\";s:12:\"Minimal Info\";s:5:\"alias\";s:6:\"r_info\";s:3:\"zip\";s:16:\"packs/r_info.zip\";s:3:\"uid\";s:32:\"d6e368e8fd4862174af6c980389ae530\";s:3:\"img\";s:17:\"r_info/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/minimal-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:102;a:25:{s:2:\"id\";s:3:\"104\";s:5:\"title\";s:18:\"Inspiration Header\";s:5:\"alias\";s:17:\"inspirationheader\";s:3:\"zip\";s:21:\"inspirationheader.zip\";s:3:\"uid\";s:32:\"69f04b2be0b618fa7e184af83b86b7e7\";s:3:\"img\";s:28:\"inspirationheader/slide1.jpg\";s:7:\"preview\";s:148:\"https://revolution.themepunch.com/wordpress-theme-header/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme-header\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:159:\"<span class=\"ttm_content\">This full-screen hero slider features sequentially animated texts and cool parallax elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:103;a:25:{s:2:\"id\";s:3:\"105\";s:5:\"title\";s:15:\"Magazine Slider\";s:5:\"alias\";s:13:\"magazineposts\";s:3:\"zip\";s:17:\"magazineposts.zip\";s:3:\"uid\";s:32:\"c562f3457e4edbd030959f7c5e6e0f7c\";s:3:\"img\";s:24:\"magazineposts/slide1.jpg\";s:7:\"preview\";s:154:\"https://revolution.themepunch.com/wordpress-magazine-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-magazine-slider\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">A full-width slider with a mouse-controlled 3D-Parallax effect. Enjoy! <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:104;a:25:{s:2:\"id\";s:3:\"106\";s:5:\"title\";s:11:\"News Header\";s:5:\"alias\";s:17:\"explorationheader\";s:3:\"zip\";s:21:\"explorationheader.zip\";s:3:\"uid\";s:32:\"8f20d5a868c90ded08b835fb9e8307d7\";s:3:\"img\";s:28:\"explorationheader/slide1.jpg\";s:7:\"preview\";s:146:\"https://revolution.themepunch.com/wordpress-news-header/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-news-header\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:288:\"<span class=\"ttm_content\">A full-screen slider that is a perfect fit for displaying news on your websites header! Check out <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> to add links to buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:109;a:25:{s:2:\"id\";s:3:\"111\";s:5:\"title\";s:17:\"Typewriter Effect\";s:5:\"alias\";s:16:\"typewritereffect\";s:3:\"zip\";s:20:\"typewritereffect.zip\";s:3:\"uid\";s:32:\"d6f8bae06cc4a7b158d680c01e59ddc2\";s:3:\"img\";s:27:\"typewritereffect/slide1.jpg\";s:7:\"preview\";s:158:\"https://revolution.themepunch.com/wordpress-typewriter-effect/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-typewriter-effect\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:263:\"<span class=\"ttm_content\">This is the example slider from the Typewriter add-on preview.<br/><a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:403:\"<span class=\"ttm_content\">This slider template requires the <a href=\"https://www.themepunch.com/slider-revolution/typewriter-addon/\" target=\"_blank\">Typewriter add-on</a> to be installed. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:173:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:110;a:26:{s:2:\"id\";s:3:\"112\";s:5:\"title\";s:17:\"Blend Mode Header\";s:5:\"alias\";s:15:\"blendmodeheader\";s:3:\"zip\";s:19:\"blendmodeheader.zip\";s:3:\"uid\";s:32:\"2e44e976596d757aab40ffa28086dcf9\";s:3:\"img\";s:26:\"blendmodeheader/slide1.jpg\";s:7:\"preview\";s:148:\"https://revolution.themepunch.com/blend-mode-hero-header/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=blend-mode-hero-header\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:6:\"6.7.34\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">This full-screen hero header with HMTL5 background video, utilizes the new 5.3 blend mode effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:111;a:29:{s:2:\"id\";s:3:\"113\";s:5:\"title\";s:17:\"Themeplicity Menu\";s:5:\"alias\";s:17:\"themeplicity_menu\";s:3:\"zip\";s:27:\"packs/themeplicity_menu.zip\";s:3:\"uid\";s:32:\"7d5c1e75eaafa63683895a32a62f4ce0\";s:3:\"img\";s:28:\"themeplicity_menu/slide1.jpg\";s:7:\"preview\";s:134:\"https://revolution.themepunch.com/wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"90\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:112;a:29:{s:2:\"id\";s:3:\"114\";s:5:\"title\";s:19:\"Themeplicity Header\";s:5:\"alias\";s:19:\"themeplicity_header\";s:3:\"zip\";s:29:\"packs/themeplicity_header.zip\";s:3:\"uid\";s:32:\"907091e4d58acc7d12f802de2f280b7d\";s:3:\"img\";s:30:\"themeplicity_header/slide1.jpg\";s:7:\"preview\";s:134:\"https://revolution.themepunch.com/wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:113;a:29:{s:2:\"id\";s:3:\"115\";s:5:\"title\";s:18:\"Themeplicity Offer\";s:5:\"alias\";s:18:\"themeplicity_offer\";s:3:\"zip\";s:28:\"packs/themeplicity_offer.zip\";s:3:\"uid\";s:32:\"1bd8f9aa2f3e340449664c65ba17fb51\";s:3:\"img\";s:29:\"themeplicity_offer/slide1.jpg\";s:7:\"preview\";s:134:\"https://revolution.themepunch.com/wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"330\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:114;a:29:{s:2:\"id\";s:3:\"116\";s:5:\"title\";s:23:\"Themeplicity What We Do\";s:5:\"alias\";s:21:\"themeplicity_whatwedo\";s:3:\"zip\";s:31:\"packs/themeplicity_whatwedo.zip\";s:3:\"uid\";s:32:\"aa800a44b5a3eab30414dde1f32bfed7\";s:3:\"img\";s:32:\"themeplicity_whatwedo/slide1.jpg\";s:7:\"preview\";s:134:\"https://revolution.themepunch.com/wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"813\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:115;a:29:{s:2:\"id\";s:3:\"117\";s:5:\"title\";s:21:\"Themeplicity Projects\";s:5:\"alias\";s:21:\"themeplicity_projects\";s:3:\"zip\";s:31:\"packs/themeplicity_projects.zip\";s:3:\"uid\";s:32:\"5f61b3a13033ba6a51a18270163e0a50\";s:3:\"img\";s:32:\"themeplicity_projects/slide1.jpg\";s:7:\"preview\";s:134:\"https://revolution.themepunch.com/wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"813\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:116;a:29:{s:2:\"id\";s:3:\"118\";s:5:\"title\";s:24:\"Themeplicity Whats Great\";s:5:\"alias\";s:23:\"themeplicity_whatsgreat\";s:3:\"zip\";s:33:\"packs/themeplicity_whatsgreat.zip\";s:3:\"uid\";s:32:\"ce9faf8c55ed2e33e091b23667e7173b\";s:3:\"img\";s:34:\"themeplicity_whatsgreat/slide1.jpg\";s:7:\"preview\";s:134:\"https://revolution.themepunch.com/wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:117;a:29:{s:2:\"id\";s:3:\"119\";s:5:\"title\";s:19:\"Themeplicity Tables\";s:5:\"alias\";s:19:\"themeplicity_tables\";s:3:\"zip\";s:29:\"packs/themeplicity_tables.zip\";s:3:\"uid\";s:32:\"f28bb4cd20ec1f29a1de7da5ad09c293\";s:3:\"img\";s:30:\"themeplicity_tables/slide1.jpg\";s:7:\"preview\";s:134:\"https://revolution.themepunch.com/wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1059\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:118;a:29:{s:2:\"id\";s:3:\"120\";s:5:\"title\";s:24:\"Themeplicity Contactform\";s:5:\"alias\";s:24:\"themeplicity_contactform\";s:3:\"zip\";s:34:\"packs/themeplicity_contactform.zip\";s:3:\"uid\";s:32:\"3e59da970f534490774fa8e053f5b5ed\";s:3:\"img\";s:35:\"themeplicity_contactform/slide1.jpg\";s:7:\"preview\";s:134:\"https://revolution.themepunch.com/wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1067\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:119;a:29:{s:2:\"id\";s:3:\"121\";s:5:\"title\";s:19:\"Themeplicity Footer\";s:5:\"alias\";s:19:\"themeplicity_footer\";s:3:\"zip\";s:29:\"packs/themeplicity_footer.zip\";s:3:\"uid\";s:32:\"89eeb0b4b852c5f743e1bd76e3e8f2ef\";s:3:\"img\";s:30:\"themeplicity_footer/slide1.jpg\";s:7:\"preview\";s:134:\"https://revolution.themepunch.com/wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"780\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:121;a:29:{s:2:\"id\";s:3:\"123\";s:5:\"title\";s:19:\"Nice And Clean Menu\";s:5:\"alias\";s:17:\"NiceAndClean_Menu\";s:3:\"zip\";s:27:\"packs/NiceAndClean_Menu.zip\";s:3:\"uid\";s:32:\"3f8c01e26c7446428e045c4b1180776d\";s:3:\"img\";s:28:\"NiceAndClean_Menu/slide1.jpg\";s:7:\"preview\";s:178:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"90\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:122;a:29:{s:2:\"id\";s:3:\"124\";s:5:\"title\";s:21:\"Nice And Clean Header\";s:5:\"alias\";s:19:\"NiceAndClean_Header\";s:3:\"zip\";s:29:\"packs/NiceAndClean_Header.zip\";s:3:\"uid\";s:32:\"76931033addb20a62557c2845a4d6a11\";s:3:\"img\";s:30:\"NiceAndClean_Header/slide1.jpg\";s:7:\"preview\";s:178:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:123;a:29:{s:2:\"id\";s:3:\"125\";s:5:\"title\";s:23:\"Nice And Clean Services\";s:5:\"alias\";s:21:\"NiceAndClean_Services\";s:3:\"zip\";s:31:\"packs/NiceAndClean_Services.zip\";s:3:\"uid\";s:32:\"02f72ec606800c8215bcadea09624e87\";s:3:\"img\";s:32:\"NiceAndClean_Services/slide1.jpg\";s:7:\"preview\";s:178:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"360\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:124;a:29:{s:2:\"id\";s:3:\"126\";s:5:\"title\";s:20:\"Nice And Clean About\";s:5:\"alias\";s:18:\"NiceAndClean_About\";s:3:\"zip\";s:28:\"packs/NiceAndClean_About.zip\";s:3:\"uid\";s:32:\"9510f6fdbb8e9473e8c22f692a6bc89f\";s:3:\"img\";s:29:\"NiceAndClean_About/slide1.jpg\";s:7:\"preview\";s:178:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:125;a:29:{s:2:\"id\";s:3:\"127\";s:5:\"title\";s:20:\"Nice And Clean Video\";s:5:\"alias\";s:18:\"niceandclean_video\";s:3:\"zip\";s:28:\"packs/niceandclean_video.zip\";s:3:\"uid\";s:32:\"2bb9e1ad329435cc500542d0c7025e15\";s:3:\"img\";s:29:\"niceandclean_video/slide1.jpg\";s:7:\"preview\";s:178:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:126;a:29:{s:2:\"id\";s:3:\"128\";s:5:\"title\";s:25:\"Nice And Clean Highlights\";s:5:\"alias\";s:23:\"niceandclean_highlights\";s:3:\"zip\";s:33:\"packs/niceandclean_highlights.zip\";s:3:\"uid\";s:32:\"ff396af163a79d2d5b35db17c1ea7aa6\";s:3:\"img\";s:34:\"niceandclean_highlights/slide1.jpg\";s:7:\"preview\";s:178:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:127;a:29:{s:2:\"id\";s:3:\"129\";s:5:\"title\";s:23:\"Nice And Clean Projects\";s:5:\"alias\";s:21:\"NiceAndClean_Projects\";s:3:\"zip\";s:31:\"packs/NiceAndClean_Projects.zip\";s:3:\"uid\";s:32:\"1e6695959ef83f8975b52289c08a4d44\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide1.jpg\";s:7:\"preview\";s:178:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:128;a:29:{s:2:\"id\";s:3:\"130\";s:5:\"title\";s:25:\"Nice And Clean TextBlocks\";s:5:\"alias\";s:23:\"niceandclean_textblocks\";s:3:\"zip\";s:33:\"packs/niceandclean_textblocks.zip\";s:3:\"uid\";s:32:\"1f33eb839c96ea3225faff1c8d382b05\";s:3:\"img\";s:34:\"niceandclean_textblocks/slide1.jpg\";s:7:\"preview\";s:178:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:129;a:29:{s:2:\"id\";s:3:\"131\";s:5:\"title\";s:22:\"Nice And Clean CallOut\";s:5:\"alias\";s:20:\"niceandclean_callout\";s:3:\"zip\";s:30:\"packs/niceandclean_callout.zip\";s:3:\"uid\";s:32:\"54d4d9bcf79d357de0e614700e909863\";s:3:\"img\";s:31:\"niceandclean_callout/slide1.jpg\";s:7:\"preview\";s:178:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:130;a:29:{s:2:\"id\";s:3:\"132\";s:5:\"title\";s:21:\"Nice And Clean Footer\";s:5:\"alias\";s:19:\"niceandclean_footer\";s:3:\"zip\";s:29:\"packs/niceandclean_footer.zip\";s:3:\"uid\";s:32:\"5492d7f72b3771a4e754f91bda063b15\";s:3:\"img\";s:30:\"niceandclean_footer/slide1.jpg\";s:7:\"preview\";s:178:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"400\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:542:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">For using the social sharing buttons, please install the social sharing add-on.<br><br></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:131;a:25:{s:2:\"id\";s:3:\"134\";s:5:\"title\";s:15:\"80s Style Intro\";s:5:\"alias\";s:3:\"80s\";s:3:\"zip\";s:7:\"80s.zip\";s:3:\"uid\";s:32:\"98881ab51f71b2fbdb220752d321b15a\";s:3:\"img\";s:14:\"80s/slide1.jpg\";s:7:\"preview\";s:134:\"https://revolution.themepunch.com/80s-style-intro/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=80s-style-intro\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:139:\"<span class=\"ttm_content\">This intro hero block takes you back to the 80\'s with some funky effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:317:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and text.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:132;a:25:{s:2:\"id\";s:3:\"135\";s:5:\"title\";s:18:\"Blur Effect Slider\";s:5:\"alias\";s:10:\"blurslider\";s:3:\"zip\";s:14:\"blurslider.zip\";s:3:\"uid\";s:32:\"83bd6e1ccef83f03c944fa05b0a2d879\";s:3:\"img\";s:21:\"blurslider/slide1.jpg\";s:7:\"preview\";s:140:\"https://revolution.themepunch.com/blur-effect-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=blur-effect-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:147:\"<span class=\"ttm_content\">This slider makes use of the brand new blur effects available with version 5.3.1.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:315:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change the background images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:133;a:24:{s:2:\"id\";s:3:\"136\";s:5:\"title\";s:18:\"Coming Soon Add-On\";s:5:\"alias\";s:15:\"ComingSoonAddon\";s:3:\"zip\";s:19:\"ComingSoonAddon.zip\";s:3:\"uid\";s:32:\"51258492055b940099eb96ba52901fa9\";s:3:\"img\";s:26:\"ComingSoonAddon/slide1.jpg\";s:7:\"preview\";s:140:\"https://revolution.themepunch.com/coming-soon-add-on/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coming-soon-add-on\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:133:\"<span class=\"ttm_content\">This slider template makes use of the brand new Coming Soon Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:197:\"[{\"path\":\"revslider-maintenance-addon\\/revslider-maintenance-addon.php\",\"name\":\"Coming Soon & Maintenance AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/add-coming-soon-maintenance\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:135;a:24:{s:2:\"id\";s:3:\"138\";s:5:\"title\";s:18:\"Snow Effect Add-On\";s:5:\"alias\";s:9:\"snowaddon\";s:3:\"zip\";s:13:\"snowaddon.zip\";s:3:\"uid\";s:32:\"7408d8567b8af5716eaabd390422e51b\";s:3:\"img\";s:20:\"snowaddon/slide1.jpg\";s:7:\"preview\";s:140:\"https://revolution.themepunch.com/snow-effect-add-on/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=snow-effect-add-on\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:183:\"<span class=\"ttm_content\">Add a pleasant Snow Effect to your website with this slider template. Make sure to install the \"Holiday Snow\" Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:153:\"[{\"path\":\"revslider-snow-addon\\/revslider-snow-addon.php\",\"name\":\"Snow AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:136;a:25:{s:2:\"id\";s:3:\"139\";s:5:\"title\";s:19:\"Particle Effect One\";s:5:\"alias\";s:19:\"particle-effect-one\";s:3:\"zip\";s:23:\"particle-effect-one.zip\";s:3:\"uid\";s:32:\"a4611c906e35ca60f617da86217b5299\";s:3:\"img\";s:30:\"particle-effect-one/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/particle-effect-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=particle-effect-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:442:\"<span class=\"ttm_content\">The blend mode effect is achieved through a layer image with CSS blend mode. If you want to customize this effect, select the \"BLEND MODE IMAGE\" layer and go to \"advanced style -> filters -> blend mode\".</span>\r\n<span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:74:\"How to Increase Engagement with Particle Effects and Blend Mode [Tutorial]\";s:9:\"guide_url\";s:107:\"https://www.sliderrevolution.com/tutorials/how-to-increase-engagement-with-particle-effects-and-blend-mode/\";s:9:\"guide_img\";s:32:\"tutorial/particle-effect-one.png\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:137;a:24:{s:2:\"id\";s:3:\"140\";s:5:\"title\";s:19:\"Particle Effect Two\";s:5:\"alias\";s:19:\"particle-effect-two\";s:3:\"zip\";s:23:\"particle-effect-two.zip\";s:3:\"uid\";s:32:\"b8ecbf43374a69e4ab329ea834862ef8\";s:3:\"img\";s:30:\"particle-effect-two/slide1.jpg\";s:7:\"preview\";s:146:\"https://revolution.themepunch.com/particle-effect-intro/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=particle-effect-intro\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:138;a:25:{s:2:\"id\";s:3:\"141\";s:5:\"title\";s:21:\"Particle Effect Three\";s:5:\"alias\";s:21:\"particle-effect-three\";s:3:\"zip\";s:25:\"particle-effect-three.zip\";s:3:\"uid\";s:32:\"b33bc2c5655d8d51cd17c3740f72e748\";s:3:\"img\";s:32:\"particle-effect-three/slide1.jpg\";s:7:\"preview\";s:156:\"https://revolution.themepunch.com/particle-background-effect/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=particle-background-effect\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:437:\"<span class=\"ttm_content\">The blend mode effect is achieved through a layer image with CSS blend mode. If you want to customize this effect, select the \"BLEND IMAGE\" layer and go to \"advanced style -> filters -> blend mode\".</span>\r\n<span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:139;a:26:{s:2:\"id\";s:3:\"142\";s:5:\"title\";s:16:\"Portfolio Viewer\";s:5:\"alias\";s:15:\"portfolioviewer\";s:3:\"zip\";s:19:\"portfolioviewer.zip\";s:3:\"uid\";s:32:\"9ac7230ff5b880fb6c8f28fbbc123b3b\";s:3:\"img\";s:26:\"portfolioviewer/slide1.jpg\";s:7:\"preview\";s:156:\"https://revolution.themepunch.com/wordpress-portfolio-plugin/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-portfolio-plugin\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:207:\"<span class=\"ttm_content\">This slider template can be used to display your portfolio highlights in a stunning way, utilising out free particles add-on and blend modes.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:387:\"<span class=\"ttm_content\">The navigation for the slides is found in the <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">Static Layers</a>.</span><span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:140;a:24:{s:2:\"id\";s:3:\"143\";s:5:\"title\";s:12:\"App Showcase\";s:5:\"alias\";s:11:\"appshowcase\";s:3:\"zip\";s:15:\"appshowcase.zip\";s:3:\"uid\";s:32:\"082aef931b0369080bc30c3a2a0c331f\";s:3:\"img\";s:22:\"appshowcase/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/app-showcase-wordpress-plugin/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=app-showcase-wordpress-plugin\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">This template shows off our new \"Polyfold Effects\" Add-On in form of an App product showcase module. Get started now and illustrate your Apps key features in a striking way!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:179:\"[{\"path\":\"revslider-polyfold-addon\\/revslider-polyfold-addon.php\",\"name\":\"Polyfold Scroll Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:141;a:25:{s:2:\"id\";s:3:\"144\";s:5:\"title\";s:19:\"Gravity Design Hero\";s:5:\"alias\";s:13:\"gravitydesign\";s:3:\"zip\";s:17:\"gravitydesign.zip\";s:3:\"uid\";s:32:\"7bdbe73a6e5bf290cb4412708ac4134d\";s:3:\"img\";s:24:\"gravitydesign/slide1.jpg\";s:7:\"preview\";s:170:\"https://revolution.themepunch.com/best-wordpress-slider-plugin-2017/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=best-wordpress-slider-plugin-2017\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:205:\"<span class=\"ttm_content\">This hero template shows a striking mouse-parallax scene and cool particle effects. Requires our \"Particle Effects\" Add-on to be installed.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:68:\"How to Create an Exciting Action Shot for Your Hero Image [Tutorial]\";s:9:\"guide_url\";s:101:\"https://www.sliderrevolution.com/tutorials/how-to-create-an-exciting-action-shot-for-your-hero-image/\";s:9:\"guide_img\";s:26:\"tutorial/gravitydesign.png\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:142;a:25:{s:2:\"id\";s:3:\"145\";s:5:\"title\";s:14:\"404 Error Page\";s:5:\"alias\";s:12:\"404errorpage\";s:3:\"zip\";s:16:\"404errorpage.zip\";s:3:\"uid\";s:32:\"2dc62d802b42b73088651cac17d0c486\";s:3:\"img\";s:23:\"404errorpage/slide1.jpg\";s:7:\"preview\";s:150:\"https://revolution.themepunch.com/404-error-page-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=404-error-page-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:227:\"<span class=\"ttm_content\">This template can be used as a custom error page on your website with our new 404 page Add-On. Of course you can also use this template as a regular hero header.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:179:\"{\"1\":{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}}\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:143;a:24:{s:2:\"id\";s:3:\"146\";s:5:\"title\";s:16:\"Carousel Gallery\";s:5:\"alias\";s:15:\"carouselgallery\";s:3:\"zip\";s:19:\"carouselgallery.zip\";s:3:\"uid\";s:32:\"041838fd32923c40e15c998f0ea19526\";s:3:\"img\";s:26:\"carouselgallery/slide1.jpg\";s:7:\"preview\";s:156:\"https://revolution.themepunch.com/wordpress-carousel-gallery/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-carousel-gallery\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:159:\"<span class=\"ttm_content\">This carousel gallery features a subtle parallax effect, html5 video and a fullscreen button.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:144;a:25:{s:2:\"id\";s:3:\"147\";s:5:\"title\";s:16:\"Filmstrip Effect\";s:5:\"alias\";s:9:\"filmstrip\";s:3:\"zip\";s:13:\"filmstrip.zip\";s:3:\"uid\";s:32:\"7bd142f272cc15d86998a79520e9e581\";s:3:\"img\";s:20:\"filmstrip/slide1.jpg\";s:7:\"preview\";s:129:\"https://revolution.themepunch.com/filmstrip-add-on-slider/ ?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content= \";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">This template uses our Filmstrip Add-On to display a continuous scrolling set of images per slide.\r\n There is lots of customization options like animation speed and direction.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:179:\"[{\"path\":\"revslider-filmstrip-addon\\/revslider-filmstrip-addon.php\",\"name\":\"Background FilmStrip AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:145;a:24:{s:2:\"id\";s:3:\"148\";s:5:\"title\";s:11:\"Space Opera\";s:5:\"alias\";s:10:\"spaceopera\";s:3:\"zip\";s:14:\"spaceopera.zip\";s:3:\"uid\";s:32:\"a2c8bffcb138a86c0f373adebb6de046\";s:3:\"img\";s:21:\"spaceopera/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/space-opera-presentation/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=space-opera-presentation\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:201:\"<span class=\"ttm_content\">The Space Opera template can be enjoyed as a slow paced, full-screen slider experience and is great to show your most prominent photos.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:146;a:24:{s:2:\"id\";s:3:\"149\";s:5:\"title\";s:13:\"Website Intro\";s:5:\"alias\";s:12:\"websiteintro\";s:3:\"zip\";s:16:\"websiteintro.zip\";s:3:\"uid\";s:32:\"348df76d999456aa19be58c9df56ae20\";s:3:\"img\";s:23:\"websiteintro/slide1.jpg\";s:7:\"preview\";s:164:\"https://revolution.themepunch.com/website-intro-wordpress-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=website-intro-wordpress-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:274:\"<span class=\"ttm_content\">Making use of our new Slicey Add-On, this slider show a really cool effect you just have to experience yourself! Just change the slides background images and the existing slices will automatically be applied.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:170:\"[{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:79:\"How to Create a Slider Animation Effect Your Visitors Won’t Forget [Tutorial]\";s:9:\"guide_url\";s:83:\"https://www.sliderrevolution.com/tutorials/how-to-create-a-slider-animation-effect/\";s:9:\"guide_img\";s:25:\"tutorial/websiteintro.png\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:147;a:24:{s:2:\"id\";s:3:\"150\";s:5:\"title\";s:13:\"Mask Showcase\";s:5:\"alias\";s:12:\"maskshowcase\";s:3:\"zip\";s:16:\"maskshowcase.zip\";s:3:\"uid\";s:32:\"fc943c31e2da9c63b252aeabf554d128\";s:3:\"img\";s:23:\"maskshowcase/slide1.jpg\";s:7:\"preview\";s:146:\"https://revolution.themepunch.com/minimal-mask-showcase/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-mask-showcase\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Mask Showcase template uses gradients and the amazing block layer animations. A minimal slider treat for any website!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:148;a:24:{s:2:\"id\";s:3:\"151\";s:5:\"title\";s:20:\"Parallax Zoom Slices\";s:5:\"alias\";s:18:\"parallaxzoomslices\";s:3:\"zip\";s:22:\"parallaxzoomslices.zip\";s:3:\"uid\";s:32:\"83537cae05709ddb9bcb7375470a5894\";s:3:\"img\";s:29:\"parallaxzoomslices/slide1.jpg\";s:7:\"preview\";s:178:\"https://revolution.themepunch.com/parallax-zoom-slices-wordpress-plugin/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=parallax-zoom-slices-wordpress-plugin\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:249:\"<span class=\"ttm_content\">This template uses the Slicey Add-On to add a unique effect to slide background images. You can simple change the background images and the slice effect will automatically be applied.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:170:\"[{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:149;a:25:{s:2:\"id\";s:3:\"152\";s:5:\"title\";s:22:\"Double Exposure Effect\";s:5:\"alias\";s:20:\"doubleexposureeffect\";s:3:\"zip\";s:24:\"doubleexposureeffect.zip\";s:3:\"uid\";s:32:\"8d9229b5cbcf5bda5fbdc6a8e01a2b8c\";s:3:\"img\";s:31:\"doubleexposureeffect/slide1.jpg\";s:7:\"preview\";s:168:\"https://revolution.themepunch.com/wordpress-double-exposure-effect/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-double-exposure-effect\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.4.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">Make any website special with the double exposure effect slider. Use as a header module or anywhere you want!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:150;a:24:{s:2:\"id\";s:3:\"153\";s:5:\"title\";s:24:\"Mountain Parallax Header\";s:5:\"alias\";s:22:\"mountainparallaxheader\";s:3:\"zip\";s:26:\"mountainparallaxheader.zip\";s:3:\"uid\";s:32:\"8dc64663f317a2abdf179bbe341d016e\";s:3:\"img\";s:33:\"mountainparallaxheader/slide1.jpg\";s:7:\"preview\";s:172:\"https://revolution.themepunch.com/mountain-wordpress-parallax-header/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=mountain-wordpress-parallax-header\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:192:\"<span class=\"ttm_content\">This template is a cool intro for any page, featuring a striking parallax effect. Just change texts and links and you\'re done!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:62:\"How to Place Text Behind Objects in Your Hero Image [Tutorial]\";s:9:\"guide_url\";s:69:\"https://www.sliderrevolution.com/tutorials/place-text-behind-objects/\";s:9:\"guide_img\";s:35:\"tutorial/mountainparallaxheader.png\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:152;a:29:{s:2:\"id\";s:3:\"155\";s:5:\"title\";s:13:\"GoodNews Menu\";s:5:\"alias\";s:12:\"goodnewsmenu\";s:3:\"zip\";s:22:\"packs/goodnewsmenu.zip\";s:3:\"uid\";s:32:\"4cbc82501ff340fcdc0acf7eb3ba2640\";s:3:\"img\";s:23:\"goodnewsmenu/slide1.jpg\";s:7:\"preview\";s:174:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:153;a:29:{s:2:\"id\";s:3:\"156\";s:5:\"title\";s:15:\"GoodNews Header\";s:5:\"alias\";s:14:\"goodnewsheader\";s:3:\"zip\";s:24:\"packs/goodnewsheader.zip\";s:3:\"uid\";s:32:\"c6660b6bdbf596f38466f569596f5259\";s:3:\"img\";s:25:\"goodnewsheader/slide1.jpg\";s:7:\"preview\";s:174:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:154;a:29:{s:2:\"id\";s:3:\"157\";s:5:\"title\";s:18:\"GoodNews Whats Hot\";s:5:\"alias\";s:16:\"goodnewswhatshot\";s:3:\"zip\";s:26:\"packs/goodnewswhatshot.zip\";s:3:\"uid\";s:32:\"cb841ce64a99a6644adab049cf5405cd\";s:3:\"img\";s:27:\"goodnewswhatshot/slide1.jpg\";s:7:\"preview\";s:174:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:155;a:29:{s:2:\"id\";s:3:\"158\";s:5:\"title\";s:17:\"GoodNews Featured\";s:5:\"alias\";s:16:\"goodnewsfeatured\";s:3:\"zip\";s:26:\"packs/goodnewsfeatured.zip\";s:3:\"uid\";s:32:\"00bde4b09e3700da7183999eaf137ccc\";s:3:\"img\";s:27:\"goodnewsfeatured/slide1.jpg\";s:7:\"preview\";s:174:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"6.4.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:156;a:29:{s:2:\"id\";s:3:\"159\";s:5:\"title\";s:18:\"GoodNews Spotlight\";s:5:\"alias\";s:17:\"goodnewsspotlight\";s:3:\"zip\";s:27:\"packs/goodnewsspotlight.zip\";s:3:\"uid\";s:32:\"138076241a828e1c5764379944755f2b\";s:3:\"img\";s:28:\"goodnewsspotlight/slide1.jpg\";s:7:\"preview\";s:174:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.4\";s:8:\"required\";s:5:\"6.4.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:157;a:29:{s:2:\"id\";s:3:\"160\";s:5:\"title\";s:17:\"GoodNews Carousel\";s:5:\"alias\";s:16:\"goodnewscarousel\";s:3:\"zip\";s:26:\"packs/goodnewscarousel.zip\";s:3:\"uid\";s:32:\"d29d4460a6015e30d08d2714232d3768\";s:3:\"img\";s:27:\"goodnewscarousel/slide1.jpg\";s:7:\"preview\";s:174:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:8:\"carousel\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:158;a:29:{s:2:\"id\";s:3:\"161\";s:5:\"title\";s:16:\"GoodNews Callout\";s:5:\"alias\";s:15:\"goodnewscallout\";s:3:\"zip\";s:25:\"packs/goodnewscallout.zip\";s:3:\"uid\";s:32:\"d9568b3193e96577fae630b3a6728785\";s:3:\"img\";s:26:\"goodnewscallout/slide1.jpg\";s:7:\"preview\";s:174:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:159;a:29:{s:2:\"id\";s:3:\"162\";s:5:\"title\";s:15:\"GoodNews Footer\";s:5:\"alias\";s:14:\"goodnewsfooter\";s:3:\"zip\";s:24:\"packs/goodnewsfooter.zip\";s:3:\"uid\";s:32:\"34f43f891cb8d55375149dc4bbc38298\";s:3:\"img\";s:25:\"goodnewsfooter/slide1.jpg\";s:7:\"preview\";s:174:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:161;a:29:{s:2:\"id\";s:3:\"164\";s:5:\"title\";s:18:\"GoodNews Menu Back\";s:5:\"alias\";s:16:\"goodnewsmenuback\";s:3:\"zip\";s:26:\"packs/goodnewsmenuback.zip\";s:3:\"uid\";s:32:\"1340d1aeefba497a7d404d12a1fceed4\";s:3:\"img\";s:27:\"goodnewsmenuback/slide1.jpg\";s:7:\"preview\";s:190:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme-content\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:162;a:29:{s:2:\"id\";s:3:\"165\";s:5:\"title\";s:20:\"GoodNews Blog Header\";s:5:\"alias\";s:18:\"goodnewsblogheader\";s:3:\"zip\";s:28:\"packs/goodnewsblogheader.zip\";s:3:\"uid\";s:32:\"abc4d7c1e48475c6def05f1f6d8bf564\";s:3:\"img\";s:29:\"goodnewsblogheader/slide1.jpg\";s:7:\"preview\";s:190:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme-content\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:163;a:29:{s:2:\"id\";s:3:\"166\";s:5:\"title\";s:21:\"GoodNews Blog Content\";s:5:\"alias\";s:19:\"goodnewsblogcontent\";s:3:\"zip\";s:29:\"packs/goodnewsblogcontent.zip\";s:3:\"uid\";s:32:\"bbf34563da6db2779c29599b503b07e9\";s:3:\"img\";s:30:\"goodnewsblogcontent/slide1.jpg\";s:7:\"preview\";s:190:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme-content\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:164;a:29:{s:2:\"id\";s:3:\"167\";s:5:\"title\";s:21:\"GoodNews Testimonials\";s:5:\"alias\";s:20:\"goodnewstestimonials\";s:3:\"zip\";s:30:\"packs/goodnewstestimonials.zip\";s:3:\"uid\";s:32:\"606b7336e86f69c567542d3f43712b56\";s:3:\"img\";s:31:\"goodnewstestimonials/slide1.jpg\";s:7:\"preview\";s:190:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme-content\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:165;a:29:{s:2:\"id\";s:3:\"168\";s:5:\"title\";s:20:\"GoodNews Blog Footer\";s:5:\"alias\";s:18:\"goodnewsblogfooter\";s:3:\"zip\";s:28:\"packs/goodnewsblogfooter.zip\";s:3:\"uid\";s:32:\"1fb88aecfb116fde67ce8d52bd3b5f05\";s:3:\"img\";s:29:\"goodnewsblogfooter/slide1.jpg\";s:7:\"preview\";s:190:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme-content\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:166;a:26:{s:2:\"id\";s:3:\"169\";s:5:\"title\";s:19:\"Before After Slider\";s:5:\"alias\";s:17:\"beforeafterslider\";s:3:\"zip\";s:21:\"beforeafterslider.zip\";s:3:\"uid\";s:32:\"6e615091a1fc3037c24b985ce5136fb2\";s:3:\"img\";s:28:\"beforeafterslider/slide1.jpg\";s:7:\"preview\";s:142:\"https://revolution.themepunch.com/before-after-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=before-after-slider\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.4.3.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:201:\"<span class=\"ttm_content\">This is the example slider for our Before / After Add-On that allows you to create unique presentations with a comparing functionality.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:320:\"<span class=\"ttm_content\">How to install <a href=\"https://www.themepunch.com/slider-revolution/install-addons/\" target=\"_blank\">Add-Ons</a>.</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-beforeafter-addon\\/revslider-beforeafter-addon.php\",\"name\":\"Before After AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:167;a:24:{s:2:\"id\";s:3:\"170\";s:5:\"title\";s:16:\"Product Showcase\";s:5:\"alias\";s:15:\"productshowcase\";s:3:\"zip\";s:19:\"productshowcase.zip\";s:3:\"uid\";s:32:\"a43447670260aaa7e8ff66cedfddb57a\";s:3:\"img\";s:26:\"productshowcase/slide1.jpg\";s:7:\"preview\";s:170:\"https://revolution.themepunch.com/wordpress-product-showcase-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-product-showcase-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:165:\"<span class=\"ttm_content\">Looking to sell products effectively? Our product showcase slider is just what you are looking for!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:168;a:25:{s:2:\"id\";s:3:\"171\";s:5:\"title\";s:23:\"Overexposure Transition\";s:5:\"alias\";s:22:\"overexposuretransition\";s:3:\"zip\";s:26:\"overexposuretransition.zip\";s:3:\"uid\";s:32:\"13f16bbe6c6d646c7d0cb817a0d3d181\";s:3:\"img\";s:33:\"overexposuretransition/slide1.jpg\";s:7:\"preview\";s:164:\"https://revolution.themepunch.com/overexposure-transition-effect/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=overexposure-transition-effect\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:155:\"<span class=\"ttm_content\">Subtle overexposure transitions and smooth color fade effects make this slider stand out.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:320:\"<span class=\"ttm_content\">How to install <a href=\"https://www.themepunch.com/slider-revolution/install-addons/\" target=\"_blank\">Add-Ons</a>.</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:169;a:24:{s:2:\"id\";s:3:\"172\";s:5:\"title\";s:15:\"Parallax Scroll\";s:5:\"alias\";s:14:\"parallaxscroll\";s:3:\"zip\";s:18:\"parallaxscroll.zip\";s:3:\"uid\";s:32:\"82546ee2f6af6c6682852f495109b3c3\";s:3:\"img\";s:25:\"parallaxscroll/slide1.jpg\";s:7:\"preview\";s:134:\"https://revolution.themepunch.com/parallax-scroll/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=parallax-scroll\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:148:\"<span class=\"ttm_content\">A strikingly colourful header for your website with super smooth parallax effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:171;a:29:{s:2:\"id\";s:3:\"174\";s:5:\"title\";s:11:\"TechCo Menu\";s:5:\"alias\";s:11:\"techco-menu\";s:3:\"zip\";s:21:\"packs/techco-menu.zip\";s:3:\"uid\";s:32:\"55e5efee828cdf1ff7e2d3b90a301ea9\";s:3:\"img\";s:22:\"techco-menu/slide1.jpg\";s:7:\"preview\";s:166:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:172;a:29:{s:2:\"id\";s:3:\"175\";s:5:\"title\";s:13:\"TechCo Header\";s:5:\"alias\";s:13:\"techco-header\";s:3:\"zip\";s:23:\"packs/techco-header.zip\";s:3:\"uid\";s:32:\"fb574d1376de9b1e408c91f51e6497d7\";s:3:\"img\";s:24:\"techco-header/slide1.jpg\";s:7:\"preview\";s:166:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:173;a:29:{s:2:\"id\";s:3:\"176\";s:5:\"title\";s:12:\"TechCo About\";s:5:\"alias\";s:12:\"techco-about\";s:3:\"zip\";s:22:\"packs/techco-about.zip\";s:3:\"uid\";s:32:\"ba216da8231e55118d87e37d2358812c\";s:3:\"img\";s:23:\"techco-about/slide1.jpg\";s:7:\"preview\";s:166:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:174;a:29:{s:2:\"id\";s:3:\"177\";s:5:\"title\";s:15:\"TechCo Services\";s:5:\"alias\";s:15:\"techco-services\";s:3:\"zip\";s:25:\"packs/techco-services.zip\";s:3:\"uid\";s:32:\"ef4a8ddbb5e1136133f7bc1227248e22\";s:3:\"img\";s:26:\"techco-services/slide1.jpg\";s:7:\"preview\";s:166:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:175;a:29:{s:2:\"id\";s:3:\"178\";s:5:\"title\";s:12:\"TechCo Video\";s:5:\"alias\";s:12:\"techco-video\";s:3:\"zip\";s:22:\"packs/techco-video.zip\";s:3:\"uid\";s:32:\"d7bb92281d05f39f9bc9eca71f90e402\";s:3:\"img\";s:23:\"techco-video/slide1.jpg\";s:7:\"preview\";s:166:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:176;a:29:{s:2:\"id\";s:3:\"179\";s:5:\"title\";s:13:\"TechCo Prices\";s:5:\"alias\";s:13:\"techco-prices\";s:3:\"zip\";s:23:\"packs/techco-prices.zip\";s:3:\"uid\";s:32:\"6291f404efbea12bb181352aba71ef11\";s:3:\"img\";s:24:\"techco-prices/slide1.jpg\";s:7:\"preview\";s:166:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:177;a:29:{s:2:\"id\";s:3:\"180\";s:5:\"title\";s:19:\"TechCo Testimonials\";s:5:\"alias\";s:19:\"techco-testimonials\";s:3:\"zip\";s:29:\"packs/techco-testimonials.zip\";s:3:\"uid\";s:32:\"3460bd51f6b80599266fecb7fbb918be\";s:3:\"img\";s:30:\"techco-testimonials/slide1.jpg\";s:7:\"preview\";s:166:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:178;a:29:{s:2:\"id\";s:3:\"181\";s:5:\"title\";s:13:\"TechCo Footer\";s:5:\"alias\";s:13:\"techco-footer\";s:3:\"zip\";s:23:\"packs/techco-footer.zip\";s:3:\"uid\";s:32:\"640abcd549137520461a4a71ff758a3b\";s:3:\"img\";s:24:\"techco-footer/slide1.jpg\";s:7:\"preview\";s:166:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:179;a:24:{s:2:\"id\";s:3:\"182\";s:5:\"title\";s:12:\"Live Weather\";s:5:\"alias\";s:7:\"weather\";s:3:\"zip\";s:11:\"weather.zip\";s:3:\"uid\";s:32:\"aab92e69374e4c7b8c6741fe02e574b9\";s:3:\"img\";s:18:\"weather/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/wordpress-live-weather-add-on/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-live-weather-add-on\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:173:\"<span class=\"ttm_content\">Showcasing our weather add-on, this slider show a different cities temperatures and forecast on each slide.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:167:\"[{\"path\":\"revslider-weather-addon\\/revslider-weather-addon.php\",\"name\":\"Live Weather AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:180;a:24:{s:2:\"id\";s:3:\"183\";s:5:\"title\";s:17:\"360 Panorama Tour\";s:5:\"alias\";s:11:\"360panorama\";s:3:\"zip\";s:15:\"360panorama.zip\";s:3:\"uid\";s:32:\"332720fdacdbb38f65e8327a2a96c52d\";s:3:\"img\";s:22:\"360panorama/slide1.jpg\";s:7:\"preview\";s:174:\"https://revolution.themepunch.com/360-degree-real-estate-virtual-tour/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=360-degree-real-estate-virtual-tour\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:155:\"<span class=\"ttm_content\">An example template for our Panorama 360 tour add-on, created for the real estate market.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:165:\"[{\"path\":\"revslider-panorama-addon\\/revslider-panorama-addon.php\",\"name\":\"Panorama AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:181;a:24:{s:2:\"id\";s:3:\"184\";s:5:\"title\";s:14:\"Duotone Add-on\";s:5:\"alias\";s:14:\"duotone-add-on\";s:3:\"zip\";s:18:\"duotone-add-on.zip\";s:3:\"uid\";s:32:\"a428c6f363b3146e96d20a6f44958922\";s:3:\"img\";s:25:\"duotone-add-on/slide1.jpg\";s:7:\"preview\";s:166:\"https://revolution.themepunch.com/wordpress-duotone-effect-add-on/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-duotone-effect-add-on\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:168:\"<span class=\"ttm_content\">This example template showcases 3 of the 30 Duotone filters available in our brand new Duotone Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:350:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"},{\"path\":\"revslider-duotonefilters-addon\\/revslider-duotonefilters-addon.php\",\"name\":\"Duotone AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:182;a:24:{s:2:\"id\";s:3:\"185\";s:5:\"title\";s:13:\"Reveal Add-on\";s:5:\"alias\";s:13:\"reveal-add-on\";s:3:\"zip\";s:17:\"reveal-add-on.zip\";s:3:\"uid\";s:32:\"7fa7525d8ff7fa7365cb98a437e88e32\";s:3:\"img\";s:24:\"reveal-add-on/slide1.jpg\";s:7:\"preview\";s:166:\"https://revolution.themepunch.com/wordpress-content-reveal-effect/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-content-reveal-effect\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:204:\"<span class=\"ttm_content\">An example template that uses our Reveal Add-On, which adds 14 new preloaders combined with reveal loading effects for any slider or hero.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:337:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"},{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:203;a:28:{s:2:\"id\";s:3:\"212\";s:5:\"title\";s:16:\"Immersion Header\";s:5:\"alias\";s:16:\"immersion_header\";s:3:\"zip\";s:26:\"packs/immersion_header.zip\";s:3:\"uid\";s:32:\"853da51256308b341ecd030bd4883229\";s:3:\"img\";s:27:\"immersion_header/slide1.jpg\";s:7:\"preview\";s:182:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=immersion-wordpress-one-page-theme-2018\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:173:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:204;a:28:{s:2:\"id\";s:3:\"213\";s:5:\"title\";s:19:\"Immersion Mountains\";s:5:\"alias\";s:19:\"immersion-mountains\";s:3:\"zip\";s:29:\"packs/immersion-mountains.zip\";s:3:\"uid\";s:32:\"817167eb3fe22b7e065ba210cbe6d53c\";s:3:\"img\";s:30:\"immersion-mountains/slide1.jpg\";s:7:\"preview\";s:182:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=immersion-wordpress-one-page-theme-2018\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:170:\"[{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:205;a:28:{s:2:\"id\";s:3:\"214\";s:5:\"title\";s:17:\"Immersion Product\";s:5:\"alias\";s:17:\"immersion-product\";s:3:\"zip\";s:27:\"packs/immersion-product.zip\";s:3:\"uid\";s:32:\"64134f263484d2bbcd7ef088ffbbfb4b\";s:3:\"img\";s:28:\"immersion-product/slide1.jpg\";s:7:\"preview\";s:182:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=immersion-wordpress-one-page-theme-2018\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:206;a:28:{s:2:\"id\";s:3:\"215\";s:5:\"title\";s:16:\"Immersion Design\";s:5:\"alias\";s:16:\"immersion-design\";s:3:\"zip\";s:26:\"packs/immersion-design.zip\";s:3:\"uid\";s:32:\"91e1d77c1a2826438763804f4d02bc26\";s:3:\"img\";s:27:\"immersion-design/slide1.jpg\";s:7:\"preview\";s:182:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=immersion-wordpress-one-page-theme-2018\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:207;a:28:{s:2:\"id\";s:3:\"216\";s:5:\"title\";s:22:\"Immersion Phototgraphy\";s:5:\"alias\";s:21:\"immersion-photography\";s:3:\"zip\";s:31:\"packs/immersion-photography.zip\";s:3:\"uid\";s:32:\"e3ddf0c577b09740f5cbf2e38ffd684d\";s:3:\"img\";s:32:\"immersion-photography/slide1.jpg\";s:7:\"preview\";s:182:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=immersion-wordpress-one-page-theme-2018\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:208;a:28:{s:2:\"id\";s:3:\"217\";s:5:\"title\";s:14:\"Immersion Grid\";s:5:\"alias\";s:14:\"immersion-grid\";s:3:\"zip\";s:24:\"packs/immersion-grid.zip\";s:3:\"uid\";s:32:\"b6903868189bb83b2c7a852fde3a7dc3\";s:3:\"img\";s:25:\"immersion-grid/slide1.jpg\";s:7:\"preview\";s:182:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=immersion-wordpress-one-page-theme-2018\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:209;a:26:{s:2:\"id\";s:3:\"218\";s:5:\"title\";s:18:\"Funky Intro Slider\";s:5:\"alias\";s:11:\"funkyslider\";s:3:\"zip\";s:15:\"funkyslider.zip\";s:3:\"uid\";s:32:\"2d4187e3fdad19b976be335253c8925d\";s:3:\"img\";s:22:\"funkyslider/slide1.jpg\";s:7:\"preview\";s:174:\"https://revolution.themepunch.com/funky-intro-slider-wordpress-plugin/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=funky-intro-slider-wordpress-plugin\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:200:\"<span class=\"ttm_content\">This funky intro slider fits just right if you need a striking introduction to your website! Sleek, beautiful and easily customizable!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:335:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"},{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:211;a:29:{s:2:\"id\";s:3:\"220\";s:5:\"title\";s:15:\"Clear View Menu\";s:5:\"alias\";s:14:\"clearview_menu\";s:3:\"zip\";s:24:\"packs/clearview_menu.zip\";s:3:\"uid\";s:32:\"eaecee5fa5f3c3a7f4d2a96c4616a353\";s:3:\"img\";s:25:\"clearview_menu/slide1.jpg\";s:7:\"preview\";s:196:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:212;a:29:{s:2:\"id\";s:3:\"221\";s:5:\"title\";s:17:\"Clear View Header\";s:5:\"alias\";s:16:\"clearview_header\";s:3:\"zip\";s:26:\"packs/clearview_header.zip\";s:3:\"uid\";s:32:\"25e3dd80ad130875d7438a07952cb0cd\";s:3:\"img\";s:27:\"clearview_header/slide1.jpg\";s:7:\"preview\";s:196:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:213;a:29:{s:2:\"id\";s:3:\"222\";s:5:\"title\";s:18:\"Clear View Mission\";s:5:\"alias\";s:17:\"clearview_mission\";s:3:\"zip\";s:27:\"packs/clearview_mission.zip\";s:3:\"uid\";s:32:\"35b2092a49fd2beb549342e69097eb5b\";s:3:\"img\";s:28:\"clearview_mission/slide1.jpg\";s:7:\"preview\";s:196:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:214;a:29:{s:2:\"id\";s:3:\"223\";s:5:\"title\";s:17:\"Clear View Slider\";s:5:\"alias\";s:17:\"clear-view-slider\";s:3:\"zip\";s:27:\"packs/clear-view-slider.zip\";s:3:\"uid\";s:32:\"d2e17edffce16ed78c54b0ef23fd7e05\";s:3:\"img\";s:28:\"clear-view-slider/slide1.jpg\";s:7:\"preview\";s:196:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:215;a:29:{s:2:\"id\";s:3:\"224\";s:5:\"title\";s:15:\"Clear View News\";s:5:\"alias\";s:15:\"clear-view-news\";s:3:\"zip\";s:25:\"packs/clear-view-news.zip\";s:3:\"uid\";s:32:\"5698d3131ba141e9afcfd2906739dd00\";s:3:\"img\";s:26:\"clear-view-news/slide1.jpg\";s:7:\"preview\";s:196:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:216;a:29:{s:2:\"id\";s:3:\"225\";s:5:\"title\";s:18:\"Clear View Clients\";s:5:\"alias\";s:18:\"clear-view-clients\";s:3:\"zip\";s:28:\"packs/clear-view-clients.zip\";s:3:\"uid\";s:32:\"b95616a94832e22bdfac5ce60232be1b\";s:3:\"img\";s:29:\"clear-view-clients/slide1.jpg\";s:7:\"preview\";s:196:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:217;a:29:{s:2:\"id\";s:3:\"226\";s:5:\"title\";s:18:\"Clear View Contact\";s:5:\"alias\";s:18:\"clear-view-contact\";s:3:\"zip\";s:28:\"packs/clear-view-contact.zip\";s:3:\"uid\";s:32:\"0e0cc1d8f6f6500e5f8a2b091fa3b4cb\";s:3:\"img\";s:29:\"clear-view-contact/slide1.jpg\";s:7:\"preview\";s:196:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:219;a:29:{s:2:\"id\";s:3:\"228\";s:5:\"title\";s:22:\"Clear View Single Menu\";s:5:\"alias\";s:22:\"clear-view-single-menu\";s:3:\"zip\";s:32:\"packs/clear-view-single-menu.zip\";s:3:\"uid\";s:32:\"1e80f81982f8a4ea763482d4fa99d321\";s:3:\"img\";s:33:\"clear-view-single-menu/slide1.jpg\";s:7:\"preview\";s:196:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-single-post-page-wordpress-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:220;a:29:{s:2:\"id\";s:3:\"229\";s:5:\"title\";s:24:\"Clear View Single Header\";s:5:\"alias\";s:24:\"clear-view-single-header\";s:3:\"zip\";s:34:\"packs/clear-view-single-header.zip\";s:3:\"uid\";s:32:\"c8d717627be6cd5e70922ab609694dbf\";s:3:\"img\";s:35:\"clear-view-single-header/slide1.jpg\";s:7:\"preview\";s:196:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-single-post-page-wordpress-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:221;a:29:{s:2:\"id\";s:3:\"230\";s:5:\"title\";s:23:\"Clear View Single Media\";s:5:\"alias\";s:23:\"clear-view-single-media\";s:3:\"zip\";s:33:\"packs/clear-view-single-media.zip\";s:3:\"uid\";s:32:\"c480368ded2a64f0cdd44f1674213814\";s:3:\"img\";s:34:\"clear-view-single-media/slide1.jpg\";s:7:\"preview\";s:196:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-single-post-page-wordpress-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:222;a:29:{s:2:\"id\";s:3:\"231\";s:5:\"title\";s:22:\"Clear View Single More\";s:5:\"alias\";s:22:\"clear-view-single-more\";s:3:\"zip\";s:32:\"packs/clear-view-single-more.zip\";s:3:\"uid\";s:32:\"9c693190df26218366d1f77e10cf550a\";s:3:\"img\";s:33:\"clear-view-single-more/slide1.jpg\";s:7:\"preview\";s:196:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-single-post-page-wordpress-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:223;a:29:{s:2:\"id\";s:3:\"232\";s:5:\"title\";s:25:\"Clear View Single Contact\";s:5:\"alias\";s:25:\"clear-view-single-contact\";s:3:\"zip\";s:35:\"packs/clear-view-single-contact.zip\";s:3:\"uid\";s:32:\"73c0a889f2b654a87b5aba1ff76fbc5c\";s:3:\"img\";s:36:\"clear-view-single-contact/slide1.jpg\";s:7:\"preview\";s:196:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-single-post-page-wordpress-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:224;a:25:{s:2:\"id\";s:3:\"233\";s:5:\"title\";s:18:\"Clean Landing Page\";s:5:\"alias\";s:16:\"cleanlandingpage\";s:3:\"zip\";s:20:\"cleanlandingpage.zip\";s:3:\"uid\";s:32:\"727a3680d312f22c6a5998ebdb9afe52\";s:3:\"img\";s:27:\"cleanlandingpage/slide1.jpg\";s:7:\"preview\";s:168:\"https://revolution.themepunch.com/clean-landing-page-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clean-landing-page-for-wordpress\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:203:\"<span class=\"ttm_content\">The Clean Landing Page is a fullscreen Intro Module that is a striking introduction to any minimal website, with no unnecessary elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:173:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:225;a:25:{s:2:\"id\";s:3:\"234\";s:5:\"title\";s:9:\"Clear Cut\";s:5:\"alias\";s:8:\"clearcut\";s:3:\"zip\";s:12:\"clearcut.zip\";s:3:\"uid\";s:32:\"07f43c00e9b4d3057a03cdb3385ad2b7\";s:3:\"img\";s:19:\"clearcut/slide1.jpg\";s:7:\"preview\";s:186:\"https://revolution.themepunch.com/clear-cut-portfolio-website-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-cut-portfolio-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:240:\"<span class=\"ttm_content\">The Clear Cut Template is an All-In-One Portfolio Website solution that works best for smaller portfolios. Highlight your best work in a striking and mobile friendly fashion!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:227;a:28:{s:2:\"id\";s:3:\"236\";s:5:\"title\";s:17:\"Wonderstruck Menu\";s:5:\"alias\";s:17:\"wonderstruck_menu\";s:3:\"zip\";s:27:\"packs/wonderstruck_menu.zip\";s:3:\"uid\";s:32:\"0a976e9aaae59c4f795b38f59f5a08d8\";s:3:\"img\";s:28:\"wonderstruck_menu/slide1.jpg\";s:7:\"preview\";s:189:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:228;a:28:{s:2:\"id\";s:3:\"237\";s:5:\"title\";s:19:\"Wonderstruck Header\";s:5:\"alias\";s:19:\"wonderstruck_header\";s:3:\"zip\";s:29:\"packs/wonderstruck_header.zip\";s:3:\"uid\";s:32:\"e1379f77a902960a0ce12d44d85a9e0a\";s:3:\"img\";s:30:\"wonderstruck_header/slide1.jpg\";s:7:\"preview\";s:189:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:229;a:28:{s:2:\"id\";s:3:\"238\";s:5:\"title\";s:18:\"Wonderstruck About\";s:5:\"alias\";s:18:\"wonderstruck_about\";s:3:\"zip\";s:28:\"packs/wonderstruck_about.zip\";s:3:\"uid\";s:32:\"d207fb140fd328acc3038300ea52082a\";s:3:\"img\";s:29:\"wonderstruck_about/slide1.jpg\";s:7:\"preview\";s:189:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:230;a:28:{s:2:\"id\";s:3:\"239\";s:5:\"title\";s:18:\"Wonderstruck Works\";s:5:\"alias\";s:18:\"wonderstruck-works\";s:3:\"zip\";s:28:\"packs/wonderstruck-works.zip\";s:3:\"uid\";s:32:\"4476935097e27d92454b0011b7700c1d\";s:3:\"img\";s:29:\"wonderstruck-works/slide1.jpg\";s:7:\"preview\";s:189:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:231;a:28:{s:2:\"id\";s:3:\"240\";s:5:\"title\";s:20:\"Wonderstruck Contact\";s:5:\"alias\";s:20:\"wonderstruck-contact\";s:3:\"zip\";s:30:\"packs/wonderstruck-contact.zip\";s:3:\"uid\";s:32:\"9e4911521f77bce2b8efa40f4c2adc22\";s:3:\"img\";s:31:\"wonderstruck-contact/slide1.jpg\";s:7:\"preview\";s:189:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:232;a:24:{s:2:\"id\";s:3:\"241\";s:5:\"title\";s:12:\"Bubble Morph\";s:5:\"alias\";s:11:\"bubblemorph\";s:3:\"zip\";s:15:\"bubblemorph.zip\";s:3:\"uid\";s:32:\"1102d6f5460ab82cb612cbe9f1d9514b\";s:3:\"img\";s:22:\"bubblemorph/slide1.jpg\";s:7:\"preview\";s:184:\"https://revolution.themepunch.com/bubble-morph-effect-add-on-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=bubble-morph-effect-add-on-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:188:\"<span class=\"ttm_content\">The Bubble Morph Add-On allows you to create interesting Lava-Lamp style effects on any of your Slider Revolution content.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:233;a:24:{s:2:\"id\";s:3:\"242\";s:5:\"title\";s:16:\"Distortion AddOn\";s:5:\"alias\";s:15:\"distortionaddon\";s:3:\"zip\";s:19:\"distortionaddon.zip\";s:3:\"uid\";s:32:\"0ad46c9929bb2fa6316f1e6ced301aaf\";s:3:\"img\";s:26:\"distortionaddon/slide1.jpg\";s:7:\"preview\";s:180:\"https://revolution.themepunch.com/distortion-effect-add-on-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=distortion-effect-add-on-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Distortion Add-On allows you to create interesting Distortion style effects on any of your Slider Revolution content.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:182:\"[{\"path\":\"revslider-liquideffect-addon\\/revslider-liquideffect-addon.php\",\"name\":\"Distortion Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:234;a:24:{s:2:\"id\";s:3:\"243\";s:5:\"title\";s:10:\"Club Flyer\";s:5:\"alias\";s:9:\"clubflyer\";s:3:\"zip\";s:13:\"clubflyer.zip\";s:3:\"uid\";s:32:\"dab73b9904d0e643a35b0475980998bd\";s:3:\"img\";s:20:\"clubflyer/slide1.jpg\";s:7:\"preview\";s:196:\"https://revolution.themepunch.com/club-flyer-landing-page-template-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=club-flyer-landing-page-template-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:227:\"<span class=\"ttm_content\">This Club Fyler Template for Slider Revolution uses the brand new Exploding Layers Add-On to create a captivating effect. Tap into unlimited creative potential. </span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:187:\"[{\"path\":\"revslider-explodinglayers-addon\\/revslider-explodinglayers-addon.php\",\"name\":\"Exploding Layers AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:235;a:25:{s:2:\"id\";s:3:\"244\";s:5:\"title\";s:16:\"Paintbrush AddOn\";s:5:\"alias\";s:15:\"paintbrushaddon\";s:3:\"zip\";s:19:\"paintbrushaddon.zip\";s:3:\"uid\";s:32:\"c85c48a6742b4bf72a2590cc1b50f6a0\";s:3:\"img\";s:26:\"paintbrushaddon/slide1.jpg\";s:7:\"preview\";s:180:\"https://revolution.themepunch.com/paintbrush-effect-add-on-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=paintbrush-effect-add-on-for-wordpress\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">The Paintbrush Add-On for WordPress allows you to add cool mouse interaction effects to your Slider Revolution content. Examples: Blur Reveal, Color Reveal, Scratch Me Free.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:171:\"[{\"path\":\"revslider-paintbrush-addon\\/revslider-paintbrush-addon.php\",\"name\":\"Paintbrush AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:87:\"How to Add a Unique Paintbrush Effect to Your Website with Slider Revolution [Tutorial]\";s:9:\"guide_url\";s:68:\"https://www.sliderrevolution.com/tutorials/unique-paintbrush-effect/\";s:9:\"guide_img\";s:28:\"tutorial/paintbrushaddon.png\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:237;a:28:{s:2:\"id\";s:3:\"246\";s:5:\"title\";s:15:\"Parallax Header\";s:5:\"alias\";s:15:\"parallax_header\";s:3:\"zip\";s:25:\"packs/parallax_header.zip\";s:3:\"uid\";s:32:\"32bf4a0f5136853bd6bd366275a7a60b\";s:3:\"img\";s:26:\"parallax_header/slide1.jpg\";s:7:\"preview\";s:176:\"https://revolution.themepunch.com/parallax-one-page-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=parallax-one-page-wordpress-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:230:\"<span class=\"ttm_content\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Parallax One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"14\";s:9:\"installed\";b:0;}i:238;a:28:{s:2:\"id\";s:3:\"247\";s:5:\"title\";s:16:\"Parallax Content\";s:5:\"alias\";s:16:\"parallax_content\";s:3:\"zip\";s:26:\"packs/parallax_content.zip\";s:3:\"uid\";s:32:\"a25c5fb8f74757476ab4dc038e56f90d\";s:3:\"img\";s:27:\"parallax_content/slide1.jpg\";s:7:\"preview\";s:176:\"https://revolution.themepunch.com/parallax-one-page-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=parallax-one-page-wordpress-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:230:\"<span class=\"ttm_content\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Parallax One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"14\";s:9:\"installed\";b:0;}i:239;a:28:{s:2:\"id\";s:3:\"248\";s:5:\"title\";s:15:\"Parallax Footer\";s:5:\"alias\";s:15:\"parallax_footer\";s:3:\"zip\";s:25:\"packs/parallax_footer.zip\";s:3:\"uid\";s:32:\"665dff9ea6eaf162a2a1f160f51a9ddb\";s:3:\"img\";s:26:\"parallax_footer/slide1.jpg\";s:7:\"preview\";s:176:\"https://revolution.themepunch.com/parallax-one-page-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=parallax-one-page-wordpress-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:230:\"<span class=\"ttm_content\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Parallax One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"14\";s:9:\"installed\";b:0;}i:241;a:28:{s:2:\"id\";s:3:\"250\";s:5:\"title\";s:12:\"Le Chef Menu\";s:5:\"alias\";s:12:\"le-chef-menu\";s:3:\"zip\";s:22:\"packs/le-chef-menu.zip\";s:3:\"uid\";s:32:\"2f2a6a333431fefe4a7b3b6a982b2ff5\";s:3:\"img\";s:23:\"le-chef-menu/slide1.jpg\";s:7:\"preview\";s:194:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=le-chef-restaurant-website-wordpress-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:242;a:28:{s:2:\"id\";s:3:\"251\";s:5:\"title\";s:14:\"Le Chef Header\";s:5:\"alias\";s:14:\"le-chef-header\";s:3:\"zip\";s:24:\"packs/le-chef-header.zip\";s:3:\"uid\";s:32:\"06450ca3be5a4a8959f3752ab974e574\";s:3:\"img\";s:25:\"le-chef-header/slide1.jpg\";s:7:\"preview\";s:194:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=le-chef-restaurant-website-wordpress-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:243;a:28:{s:2:\"id\";s:3:\"252\";s:5:\"title\";s:18:\"Le Chef Philosophy\";s:5:\"alias\";s:18:\"le-chef-philosophy\";s:3:\"zip\";s:28:\"packs/le-chef-philosophy.zip\";s:3:\"uid\";s:32:\"a532fd029addeb18106e751409b8e20a\";s:3:\"img\";s:29:\"le-chef-philosophy/slide1.jpg\";s:7:\"preview\";s:194:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=le-chef-restaurant-website-wordpress-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:244;a:28:{s:2:\"id\";s:3:\"253\";s:5:\"title\";s:12:\"Le Chef Food\";s:5:\"alias\";s:12:\"le-chef-food\";s:3:\"zip\";s:22:\"packs/le-chef-food.zip\";s:3:\"uid\";s:32:\"cd4b6a2cb5de2dd20a0e8ba0c35451df\";s:3:\"img\";s:23:\"le-chef-food/slide1.jpg\";s:7:\"preview\";s:194:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=le-chef-restaurant-website-wordpress-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:245;a:28:{s:2:\"id\";s:3:\"254\";s:5:\"title\";s:16:\"Le Chef La Carte\";s:5:\"alias\";s:16:\"le-chef-la-carte\";s:3:\"zip\";s:26:\"packs/le-chef-la-carte.zip\";s:3:\"uid\";s:32:\"6f312749679c3ba52c41189a6b8bf729\";s:3:\"img\";s:27:\"le-chef-la-carte/slide1.jpg\";s:7:\"preview\";s:194:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=le-chef-restaurant-website-wordpress-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:246;a:28:{s:2:\"id\";s:3:\"255\";s:5:\"title\";s:14:\"Le Chef Footer\";s:5:\"alias\";s:14:\"le-chef-footer\";s:3:\"zip\";s:24:\"packs/le-chef-footer.zip\";s:3:\"uid\";s:32:\"12fc241e8e5b9e5df9758c43448e2907\";s:3:\"img\";s:25:\"le-chef-footer/slide1.jpg\";s:7:\"preview\";s:194:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=le-chef-restaurant-website-wordpress-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:247;a:25:{s:2:\"id\";s:3:\"256\";s:5:\"title\";s:20:\"News Magazine Slider\";s:5:\"alias\";s:20:\"news-magazine-slider\";s:3:\"zip\";s:24:\"news-magazine-slider.zip\";s:3:\"uid\";s:32:\"31f2c1506babb1fef459401f051d2d52\";s:3:\"img\";s:31:\"news-magazine-slider/slide1.jpg\";s:7:\"preview\";s:172:\"https://revolution.themepunch.com/news-magazine-slider-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=news-magazine-slider-for-wordpress\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:205:\"<span class=\"ttm_content\">The Magazine Slider offers various layouts that support static content images, HTML5 and Youtube video. Great for any blog or news website!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:248;a:24:{s:2:\"id\";s:3:\"257\";s:5:\"title\";s:18:\"Real Estate Slider\";s:5:\"alias\";s:18:\"real-estate-slider\";s:3:\"zip\";s:22:\"real-estate-slider.zip\";s:3:\"uid\";s:32:\"739ce6336e46815094387c9448e6c804\";s:3:\"img\";s:29:\"real-estate-slider/slide1.jpg\";s:7:\"preview\";s:168:\"https://revolution.themepunch.com/real-estate-slider-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=real-estate-slider-for-wordpress\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:204:\"<span class=\"ttm_content\">The Real Estate Slider allows to display real estate offers with a large ken burns background image and additional thumbnail hover images.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:249;a:24:{s:2:\"id\";s:3:\"258\";s:5:\"title\";s:14:\"Fashion Header\";s:5:\"alias\";s:14:\"fashion-header\";s:3:\"zip\";s:18:\"fashion-header.zip\";s:3:\"uid\";s:32:\"24ece4e7f4d31cd90377c62abbd9e25a\";s:3:\"img\";s:25:\"fashion-header/slide1.jpg\";s:7:\"preview\";s:184:\"https://revolution.themepunch.com/fashion-shop-header-slider-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=fashion-shop-header-slider-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:254:\"<span class=\"ttm_content\">The Fashion Shop Header ist the ideal Slider to display as an intro to your shop website or as a separator in between content. Our unique \"Bubble Morph\" effect makes this module stand out!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:250;a:24:{s:2:\"id\";s:3:\"259\";s:5:\"title\";s:14:\"Seasonal Offer\";s:5:\"alias\";s:13:\"seasonaloffer\";s:3:\"zip\";s:17:\"seasonaloffer.zip\";s:3:\"uid\";s:32:\"caf2f17f8fd64f2f89dcb3c8dd238457\";s:3:\"img\";s:24:\"seasonaloffer/slide1.jpg\";s:7:\"preview\";s:194:\"https://revolution.themepunch.com/seasonal-offer-christmas-header-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=seasonal-offer-christmas-header-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.8.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:204:\"<span class=\"ttm_content\">Use the Seasonal Offer Header to promote special offers in the holiday season, or just to add some snowy christmas spirit to your website!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:153:\"[{\"path\":\"revslider-snow-addon\\/revslider-snow-addon.php\",\"name\":\"Snow AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:252;a:29:{s:2:\"id\";s:3:\"261\";s:5:\"title\";s:18:\"Barber Shop Header\";s:5:\"alias\";s:18:\"barber-shop-header\";s:3:\"zip\";s:28:\"packs/barber-shop-header.zip\";s:3:\"uid\";s:32:\"71c995d36d39a0e8a04cffdf753f2ba2\";s:3:\"img\";s:29:\"barber-shop-header/slide1.jpg\";s:7:\"preview\";s:172:\"https://revolution.themepunch.com/barber-shop-template-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=barber-shop-template-for-wordpress\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Barber Shop\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"16\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:253;a:29:{s:2:\"id\";s:3:\"262\";s:5:\"title\";s:23:\"Barber Shop Mobile Menu\";s:5:\"alias\";s:23:\"barber-shop-mobile-menu\";s:3:\"zip\";s:33:\"packs/barber-shop-mobile-menu.zip\";s:3:\"uid\";s:32:\"762c6fb5c6306f37becb1e55773c2592\";s:3:\"img\";s:34:\"barber-shop-mobile-menu/slide1.jpg\";s:7:\"preview\";s:172:\"https://revolution.themepunch.com/barber-shop-template-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=barber-shop-template-for-wordpress\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Barber Shop\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"16\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:254;a:29:{s:2:\"id\";s:3:\"263\";s:5:\"title\";s:24:\"Barber Shop First Screen\";s:5:\"alias\";s:24:\"barber-shop-first-screen\";s:3:\"zip\";s:34:\"packs/barber-shop-first-screen.zip\";s:3:\"uid\";s:32:\"acf70bfd64cff2c3c2ea5585223575da\";s:3:\"img\";s:35:\"barber-shop-first-screen/slide1.jpg\";s:7:\"preview\";s:172:\"https://revolution.themepunch.com/barber-shop-template-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=barber-shop-template-for-wordpress\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Barber Shop\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"16\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:255;a:29:{s:2:\"id\";s:3:\"264\";s:5:\"title\";s:17:\"Barber Shop About\";s:5:\"alias\";s:17:\"barber-shop-about\";s:3:\"zip\";s:27:\"packs/barber-shop-about.zip\";s:3:\"uid\";s:32:\"bc8b63cfc7f8c34173b4fd5b082fc05a\";s:3:\"img\";s:28:\"barber-shop-about/slide1.jpg\";s:7:\"preview\";s:172:\"https://revolution.themepunch.com/barber-shop-template-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=barber-shop-template-for-wordpress\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Barber Shop\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"16\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:256;a:29:{s:2:\"id\";s:3:\"265\";s:5:\"title\";s:20:\"Barber Shop Services\";s:5:\"alias\";s:20:\"barber-shop-services\";s:3:\"zip\";s:30:\"packs/barber-shop-services.zip\";s:3:\"uid\";s:32:\"d65121d6f84fabd812a2b621b768e10e\";s:3:\"img\";s:31:\"barber-shop-services/slide1.jpg\";s:7:\"preview\";s:172:\"https://revolution.themepunch.com/barber-shop-template-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=barber-shop-template-for-wordpress\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Barber Shop\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"16\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:257;a:29:{s:2:\"id\";s:3:\"266\";s:5:\"title\";s:19:\"Barber Shop Barbers\";s:5:\"alias\";s:19:\"barber-shop-barbers\";s:3:\"zip\";s:29:\"packs/barber-shop-barbers.zip\";s:3:\"uid\";s:32:\"003e9fec9693072119c8f8d8b6690c4d\";s:3:\"img\";s:30:\"barber-shop-barbers/slide1.jpg\";s:7:\"preview\";s:172:\"https://revolution.themepunch.com/barber-shop-template-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=barber-shop-template-for-wordpress\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Barber Shop\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"16\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:258;a:29:{s:2:\"id\";s:3:\"267\";s:5:\"title\";s:20:\"Barber Shop Contacts\";s:5:\"alias\";s:20:\"barber-shop-contacts\";s:3:\"zip\";s:30:\"packs/barber-shop-contacts.zip\";s:3:\"uid\";s:32:\"cdcc08f5d6c90dbcfd0502bda2401643\";s:3:\"img\";s:31:\"barber-shop-contacts/slide1.jpg\";s:7:\"preview\";s:172:\"https://revolution.themepunch.com/barber-shop-template-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=barber-shop-template-for-wordpress\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Barber Shop\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"16\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:259;a:29:{s:2:\"id\";s:3:\"268\";s:5:\"title\";s:18:\"Barber Shop Footer\";s:5:\"alias\";s:18:\"barber-shop-footer\";s:3:\"zip\";s:28:\"packs/barber-shop-footer.zip\";s:3:\"uid\";s:32:\"26ca5ae0de7cdbb2ca19348b6e01eda0\";s:3:\"img\";s:29:\"barber-shop-footer/slide1.jpg\";s:7:\"preview\";s:172:\"https://revolution.themepunch.com/barber-shop-template-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=barber-shop-template-for-wordpress\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Barber Shop\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"16\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:260;a:24:{s:2:\"id\";s:3:\"269\";s:5:\"title\";s:12:\"Fitness Club\";s:5:\"alias\";s:21:\"fitness-club-template\";s:3:\"zip\";s:25:\"fitness-club-template.zip\";s:3:\"uid\";s:32:\"14ea10d68d6aad1df62b3becf71df754\";s:3:\"img\";s:32:\"fitness-club-template/slide1.jpg\";s:7:\"preview\";s:170:\"https://revolution.themepunch.com/fitness-club-header-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=fitness-club-header-for-wordpress\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:223:\"<span class=\"ttm_content\">The Fitness Club Header is the perfect introduction to your fitness themed website. Showcase your current offers or service portfolio with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:261;a:24:{s:2:\"id\";s:3:\"270\";s:5:\"title\";s:13:\"Soccer School\";s:5:\"alias\";s:13:\"soccer-school\";s:3:\"zip\";s:17:\"soccer-school.zip\";s:3:\"uid\";s:32:\"9906b48812aff67097f990eeee42dd41\";s:3:\"img\";s:24:\"soccer-school/slide1.jpg\";s:7:\"preview\";s:168:\"https://revolution.themepunch.com/soccer-club-slider-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=soccer-club-slider-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:228:\"<span class=\"ttm_content\">The Soccer Club Header is the perfect introduction to your Soccer School themed website. Showcase your current offers or service portfolio with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:262;a:24:{s:2:\"id\";s:3:\"271\";s:5:\"title\";s:10:\"Music Band\";s:5:\"alias\";s:19:\"music-band-template\";s:3:\"zip\";s:23:\"music-band-template.zip\";s:3:\"uid\";s:32:\"91e79657bf1b1812f8114a00ab8e0eb4\";s:3:\"img\";s:30:\"music-band-template/slide1.jpg\";s:7:\"preview\";s:170:\"https://revolution.themepunch.com/music-band-template-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=music-band-template-for-wordpress\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.4.8.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:221:\"<span class=\"ttm_content\">The Music Band Header is the perfect introduction to your Music Band themed website. Showcase your current songs, albums and videos with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:263;a:24:{s:2:\"id\";s:3:\"272\";s:5:\"title\";s:15:\"Restaurant Menu\";s:5:\"alias\";s:15:\"restaurant-menu\";s:3:\"zip\";s:19:\"restaurant-menu.zip\";s:3:\"uid\";s:32:\"078809cffb21b6c4d3f5aaa2daeb193d\";s:3:\"img\";s:26:\"restaurant-menu/slide1.jpg\";s:7:\"preview\";s:176:\"https://revolution.themepunch.com/restaurant-menu-slider-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=restaurant-menu-slider-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.8.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:208:\"<span class=\"ttm_content\">The Restaurant Menu Header is the perfect introduction to your Restaurant themed website. Showcase your current dishes with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:70:\"How to Create a Digital Menu Teaser for Your Foodie Website [Tutorial]\";s:9:\"guide_url\";s:103:\"https://www.sliderrevolution.com/tutorials/how-to-create-a-digital-menu-teaser-for-your-foodie-website/\";s:9:\"guide_img\";s:28:\"tutorial/restaurant-menu.png\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:264;a:24:{s:2:\"id\";s:3:\"273\";s:5:\"title\";s:16:\"Cinematic Slider\";s:5:\"alias\";s:16:\"cinematic-slider\";s:3:\"zip\";s:20:\"cinematic-slider.zip\";s:3:\"uid\";s:32:\"c53e7dcbb6b656ae7b4c91d333589838\";s:3:\"img\";s:27:\"cinematic-slider/slide1.jpg\";s:7:\"preview\";s:154:\"https://revolution.themepunch.com/cinematic-slider-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=cinematic-slider-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:138:\"<span class=\"ttm_content\">Bold texts and a cinematic transition effect make this slider stand out!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:265;a:24:{s:2:\"id\";s:3:\"274\";s:5:\"title\";s:17:\"3D Parallax Cubes\";s:5:\"alias\";s:17:\"3d-parallax-cubes\";s:3:\"zip\";s:21:\"3d-parallax-cubes.zip\";s:3:\"uid\";s:32:\"c5b809a1829f8f809c9a768cd3d6b3cb\";s:3:\"img\";s:28:\"3d-parallax-cubes/slide1.jpg\";s:7:\"preview\";s:170:\"https://revolution.themepunch.com/3d-parallax-cubes-slider-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=3d-parallax-cubes-slider-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">This amazing 3D cubes parallax effect can be an eye-opening intro for your website!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:267;a:28:{s:2:\"id\";s:3:\"276\";s:5:\"title\";s:13:\"Medicare Menu\";s:5:\"alias\";s:13:\"medicare-menu\";s:3:\"zip\";s:23:\"packs/medicare-menu.zip\";s:3:\"uid\";s:32:\"0e4ca8fc281e20251b3fffa19d470fed\";s:3:\"img\";s:24:\"medicare-menu/slide1.jpg\";s:7:\"preview\";s:170:\"https://revolution.themepunch.com/medicare-medical-services-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:268;a:28:{s:2:\"id\";s:3:\"277\";s:5:\"title\";s:15:\"Medicare Header\";s:5:\"alias\";s:15:\"medicare-header\";s:3:\"zip\";s:25:\"packs/medicare-header.zip\";s:3:\"uid\";s:32:\"03e8ade247d8c96f548bc0515f34043f\";s:3:\"img\";s:26:\"medicare-header/slide1.jpg\";s:7:\"preview\";s:170:\"https://revolution.themepunch.com/medicare-medical-services-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:269;a:28:{s:2:\"id\";s:3:\"278\";s:5:\"title\";s:14:\"Medicare About\";s:5:\"alias\";s:14:\"medicare-about\";s:3:\"zip\";s:24:\"packs/medicare-about.zip\";s:3:\"uid\";s:32:\"a3ab9e89155ef2542820343f30b29f72\";s:3:\"img\";s:25:\"medicare-about/slide1.jpg\";s:7:\"preview\";s:170:\"https://revolution.themepunch.com/medicare-medical-services-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:270;a:28:{s:2:\"id\";s:3:\"279\";s:5:\"title\";s:18:\"Medicare Highlight\";s:5:\"alias\";s:18:\"medicare-highlight\";s:3:\"zip\";s:28:\"packs/medicare-highlight.zip\";s:3:\"uid\";s:32:\"c3c8a74e5402489f1a85a0c83890ef1f\";s:3:\"img\";s:29:\"medicare-highlight/slide1.jpg\";s:7:\"preview\";s:170:\"https://revolution.themepunch.com/medicare-medical-services-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:271;a:28:{s:2:\"id\";s:3:\"280\";s:5:\"title\";s:17:\"Medicare Services\";s:5:\"alias\";s:17:\"medicare-services\";s:3:\"zip\";s:27:\"packs/medicare-services.zip\";s:3:\"uid\";s:32:\"8869b0834d4649dcc3221bed65980806\";s:3:\"img\";s:28:\"medicare-services/slide1.jpg\";s:7:\"preview\";s:170:\"https://revolution.themepunch.com/medicare-medical-services-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:272;a:28:{s:2:\"id\";s:3:\"281\";s:5:\"title\";s:16:\"Medicare Doctors\";s:5:\"alias\";s:16:\"medicare-doctors\";s:3:\"zip\";s:26:\"packs/medicare-doctors.zip\";s:3:\"uid\";s:32:\"2c9d57afd64244b5f7e30b0d87c842f9\";s:3:\"img\";s:27:\"medicare-doctors/slide1.jpg\";s:7:\"preview\";s:170:\"https://revolution.themepunch.com/medicare-medical-services-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:273;a:28:{s:2:\"id\";s:3:\"282\";s:5:\"title\";s:17:\"Medicare Research\";s:5:\"alias\";s:17:\"medicare-research\";s:3:\"zip\";s:27:\"packs/medicare-research.zip\";s:3:\"uid\";s:32:\"31e84a91fc8b8d5296e715e539a076d0\";s:3:\"img\";s:28:\"medicare-research/slide1.jpg\";s:7:\"preview\";s:170:\"https://revolution.themepunch.com/medicare-medical-services-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:274;a:28:{s:2:\"id\";s:3:\"283\";s:5:\"title\";s:19:\"Medicare Why Choose\";s:5:\"alias\";s:18:\"medicare-whychoose\";s:3:\"zip\";s:28:\"packs/medicare-whychoose.zip\";s:3:\"uid\";s:32:\"6dad61c672127de9e35884caa45d49a0\";s:3:\"img\";s:29:\"medicare-whychoose/slide1.jpg\";s:7:\"preview\";s:170:\"https://revolution.themepunch.com/medicare-medical-services-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:275;a:28:{s:2:\"id\";s:3:\"284\";s:5:\"title\";s:16:\"Medicare Contact\";s:5:\"alias\";s:16:\"medicare-contact\";s:3:\"zip\";s:26:\"packs/medicare-contact.zip\";s:3:\"uid\";s:32:\"89bc35ad8beb62a149c42262ae49a270\";s:3:\"img\";s:27:\"medicare-contact/slide1.jpg\";s:7:\"preview\";s:170:\"https://revolution.themepunch.com/medicare-medical-services-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:276;a:28:{s:2:\"id\";s:3:\"285\";s:5:\"title\";s:15:\"Medicare Footer\";s:5:\"alias\";s:15:\"medicare-footer\";s:3:\"zip\";s:25:\"packs/medicare-footer.zip\";s:3:\"uid\";s:32:\"ccf63e5233b3d63009e5ee90db51b37b\";s:3:\"img\";s:26:\"medicare-footer/slide1.jpg\";s:7:\"preview\";s:170:\"https://revolution.themepunch.com/medicare-medical-services-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:2:\"10\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:278;a:28:{s:2:\"id\";s:3:\"287\";s:5:\"title\";s:11:\"Coffee Menu\";s:5:\"alias\";s:11:\"coffee-menu\";s:3:\"zip\";s:21:\"packs/coffee-menu.zip\";s:3:\"uid\";s:32:\"81195cad7be3f5180a267b34ce8cf966\";s:3:\"img\";s:22:\"coffee-menu/slide1.jpg\";s:7:\"preview\";s:186:\"https://revolution.themepunch.com/coffee-joint-coffee-shop-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coffee-joint-coffee-shop-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">The Coffee Joint website template is a great solution for your cafe or bistro.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Coffee Joint\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"18\";s:9:\"installed\";b:0;}i:279;a:28:{s:2:\"id\";s:3:\"288\";s:5:\"title\";s:13:\"Coffee Header\";s:5:\"alias\";s:13:\"coffee-header\";s:3:\"zip\";s:23:\"packs/coffee-header.zip\";s:3:\"uid\";s:32:\"5eed8adb9d3ae12168ad4735ac63eb20\";s:3:\"img\";s:24:\"coffee-header/slide1.jpg\";s:7:\"preview\";s:186:\"https://revolution.themepunch.com/coffee-joint-coffee-shop-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coffee-joint-coffee-shop-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">The Coffee Joint website template is a great solution for your cafe or bistro.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Coffee Joint\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"18\";s:9:\"installed\";b:0;}i:280;a:28:{s:2:\"id\";s:3:\"289\";s:5:\"title\";s:17:\"Coffee Philosophy\";s:5:\"alias\";s:17:\"coffee-philosophy\";s:3:\"zip\";s:27:\"packs/coffee-philosophy.zip\";s:3:\"uid\";s:32:\"76b5ccae3fa87fd0f991b87e7ae71c27\";s:3:\"img\";s:28:\"coffee-philosophy/slide1.jpg\";s:7:\"preview\";s:186:\"https://revolution.themepunch.com/coffee-joint-coffee-shop-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coffee-joint-coffee-shop-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">The Coffee Joint website template is a great solution for your cafe or bistro.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Coffee Joint\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"18\";s:9:\"installed\";b:0;}i:281;a:28:{s:2:\"id\";s:3:\"290\";s:5:\"title\";s:12:\"Coffee Carte\";s:5:\"alias\";s:12:\"coffee-carte\";s:3:\"zip\";s:22:\"packs/coffee-carte.zip\";s:3:\"uid\";s:32:\"470214ddd2cec585629fb79a0fd908d6\";s:3:\"img\";s:23:\"coffee-carte/slide1.jpg\";s:7:\"preview\";s:186:\"https://revolution.themepunch.com/coffee-joint-coffee-shop-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coffee-joint-coffee-shop-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">The Coffee Joint website template is a great solution for your cafe or bistro.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Coffee Joint\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"18\";s:9:\"installed\";b:0;}i:282;a:28:{s:2:\"id\";s:3:\"291\";s:5:\"title\";s:13:\"Coffee Teaser\";s:5:\"alias\";s:13:\"coffee-teaser\";s:3:\"zip\";s:23:\"packs/coffee-teaser.zip\";s:3:\"uid\";s:32:\"2ed868896c92a7bfb6431803c79e8486\";s:3:\"img\";s:24:\"coffee-teaser/slide1.jpg\";s:7:\"preview\";s:186:\"https://revolution.themepunch.com/coffee-joint-coffee-shop-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coffee-joint-coffee-shop-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">The Coffee Joint website template is a great solution for your cafe or bistro.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Coffee Joint\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"18\";s:9:\"installed\";b:0;}i:283;a:28:{s:2:\"id\";s:3:\"292\";s:5:\"title\";s:14:\"Coffee Find Us\";s:5:\"alias\";s:13:\"coffee-findus\";s:3:\"zip\";s:23:\"packs/coffee-findus.zip\";s:3:\"uid\";s:32:\"96d3784473dfa64bce9e1e4101919927\";s:3:\"img\";s:24:\"coffee-findus/slide1.jpg\";s:7:\"preview\";s:186:\"https://revolution.themepunch.com/coffee-joint-coffee-shop-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coffee-joint-coffee-shop-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">The Coffee Joint website template is a great solution for your cafe or bistro.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Coffee Joint\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"18\";s:9:\"installed\";b:0;}i:284;a:28:{s:2:\"id\";s:3:\"293\";s:5:\"title\";s:13:\"Coffee Footer\";s:5:\"alias\";s:13:\"coffee-footer\";s:3:\"zip\";s:23:\"packs/coffee-footer.zip\";s:3:\"uid\";s:32:\"6027c25e87a5fe7fd8727a51c0967915\";s:3:\"img\";s:24:\"coffee-footer/slide1.jpg\";s:7:\"preview\";s:186:\"https://revolution.themepunch.com/coffee-joint-coffee-shop-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coffee-joint-coffee-shop-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">The Coffee Joint website template is a great solution for your cafe or bistro.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Coffee Joint\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"18\";s:9:\"installed\";b:0;}i:286;a:29:{s:2:\"id\";s:3:\"295\";s:5:\"title\";s:17:\"Minimal Portfolio\";s:5:\"alias\";s:17:\"minimal-portfolio\";s:3:\"zip\";s:27:\"packs/minimal-portfolio.zip\";s:3:\"uid\";s:32:\"183b97b301d5ff0b171c067a87c8a3f5\";s:3:\"img\";s:28:\"minimal-portfolio/slide1.jpg\";s:7:\"preview\";s:172:\"https://revolution.themepunch.com/minimal-portfolio-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-portfolio-website-template\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">The Minimal Portfolio template is a slide based website with additional modal detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Minimal Portfolio\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"19\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:287;a:29:{s:2:\"id\";s:3:\"296\";s:5:\"title\";s:23:\"Minimal Portfolio Modal\";s:5:\"alias\";s:23:\"minimal-portfolio-modal\";s:3:\"zip\";s:33:\"packs/minimal-portfolio-modal.zip\";s:3:\"uid\";s:32:\"6874e6cec3663670f209a8d8a4f26b16\";s:3:\"img\";s:34:\"minimal-portfolio-modal/slide1.jpg\";s:7:\"preview\";s:172:\"https://revolution.themepunch.com/minimal-portfolio-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-portfolio-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">The Minimal Portfolio template is a slide based website with additional modal detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Minimal Portfolio\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"1\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"19\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:289;a:28:{s:2:\"id\";s:3:\"298\";s:5:\"title\";s:11:\"Angled Menu\";s:5:\"alias\";s:11:\"angled-menu\";s:3:\"zip\";s:21:\"packs/angled-menu.zip\";s:3:\"uid\";s:32:\"2fe0c4682d1231ee3918be9e4fcb1837\";s:3:\"img\";s:22:\"angled-menu/slide1.jpg\";s:7:\"preview\";s:168:\"https://revolution.themepunch.com/angled-business-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=angled-business-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Angled Business\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"20\";s:9:\"installed\";b:0;}i:290;a:28:{s:2:\"id\";s:3:\"299\";s:5:\"title\";s:13:\"Angled Header\";s:5:\"alias\";s:13:\"angled-header\";s:3:\"zip\";s:23:\"packs/angled-header.zip\";s:3:\"uid\";s:32:\"09462601d4edca8dff899de6f666dc47\";s:3:\"img\";s:24:\"angled-header/slide1.jpg\";s:7:\"preview\";s:168:\"https://revolution.themepunch.com/angled-business-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=angled-business-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Angled Business\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"20\";s:9:\"installed\";b:0;}i:291;a:28:{s:2:\"id\";s:3:\"300\";s:5:\"title\";s:11:\"Angled News\";s:5:\"alias\";s:11:\"angled-news\";s:3:\"zip\";s:21:\"packs/angled-news.zip\";s:3:\"uid\";s:32:\"b315105763ed91214cb2f0ac12615729\";s:3:\"img\";s:22:\"angled-news/slide1.jpg\";s:7:\"preview\";s:168:\"https://revolution.themepunch.com/angled-business-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=angled-business-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Angled Business\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"20\";s:9:\"installed\";b:0;}i:292;a:28:{s:2:\"id\";s:3:\"301\";s:5:\"title\";s:15:\"Angled Services\";s:5:\"alias\";s:15:\"angled-services\";s:3:\"zip\";s:25:\"packs/angled-services.zip\";s:3:\"uid\";s:32:\"7605651c1487e1a6c32edc70017be8ad\";s:3:\"img\";s:26:\"angled-services/slide1.jpg\";s:7:\"preview\";s:168:\"https://revolution.themepunch.com/angled-business-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=angled-business-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Angled Business\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"20\";s:9:\"installed\";b:0;}i:293;a:28:{s:2:\"id\";s:3:\"302\";s:5:\"title\";s:14:\"Angled Success\";s:5:\"alias\";s:14:\"angled-success\";s:3:\"zip\";s:24:\"packs/angled-success.zip\";s:3:\"uid\";s:32:\"9e3fa974a42ecf80e1ec6ff991fca430\";s:3:\"img\";s:25:\"angled-success/slide1.jpg\";s:7:\"preview\";s:168:\"https://revolution.themepunch.com/angled-business-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=angled-business-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Angled Business\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"20\";s:9:\"installed\";b:0;}i:294;a:28:{s:2:\"id\";s:3:\"303\";s:5:\"title\";s:13:\"Angled Footer\";s:5:\"alias\";s:13:\"angled-footer\";s:3:\"zip\";s:23:\"packs/angled-footer.zip\";s:3:\"uid\";s:32:\"aed4eaa2f7883351ba9c9947feef153e\";s:3:\"img\";s:24:\"angled-footer/slide1.jpg\";s:7:\"preview\";s:168:\"https://revolution.themepunch.com/angled-business-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=angled-business-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Angled Business\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"20\";s:9:\"installed\";b:0;}i:295;a:28:{s:2:\"id\";s:3:\"304\";s:5:\"title\";s:20:\"Angled Content Modal\";s:5:\"alias\";s:20:\"angled-content-modal\";s:3:\"zip\";s:30:\"packs/angled-content-modal.zip\";s:3:\"uid\";s:32:\"4ddc74515fdf84f974217e4ed47a7c66\";s:3:\"img\";s:31:\"angled-content-modal/slide1.jpg\";s:7:\"preview\";s:168:\"https://revolution.themepunch.com/angled-business-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=angled-business-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Angled Business\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"1\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"20\";s:9:\"installed\";b:0;}i:296;a:24:{s:2:\"id\";s:3:\"312\";s:5:\"title\";s:24:\"Retouch Before and After\";s:5:\"alias\";s:7:\"Retouch\";s:3:\"zip\";s:11:\"Retouch.zip\";s:3:\"uid\";s:32:\"58894991f1abd8b448c8d353b1b5fe76\";s:3:\"img\";s:18:\"Retouch/slide1.jpg\";s:7:\"preview\";s:157:\"http://revolution.themepunch.com/retouch-before-after-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=retouch-before-after-slider\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:155:\"<span class=\"ttm_content\">The Retouch Slider is the perfect way to compare your photos before and after retouching.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-beforeafter-addon\\/revslider-beforeafter-addon.php\",\"name\":\"Before After AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:297;a:24:{s:2:\"id\";s:3:\"313\";s:5:\"title\";s:11:\"Tech Slider\";s:5:\"alias\";s:11:\"tech-slider\";s:3:\"zip\";s:15:\"tech-slider.zip\";s:3:\"uid\";s:32:\"a98e2b264f00a1116d21808c6a543162\";s:3:\"img\";s:22:\"tech-slider/slide1.jpg\";s:7:\"preview\";s:161:\"http://revolution.themepunch.com/tech-showcase-slider-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=tech-showcase-slider-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:153:\"<span class=\"ttm_content\">This classic slider module with sleek device mockups features a smooth parallax effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:299;a:28:{s:2:\"id\";s:3:\"315\";s:5:\"title\";s:11:\"Peak Header\";s:5:\"alias\";s:11:\"peak-header\";s:3:\"zip\";s:21:\"packs/peak-header.zip\";s:3:\"uid\";s:32:\"b721bd612e9fbc5182418ad3fd7d0808\";s:3:\"img\";s:22:\"peak-header/slide1.jpg\";s:7:\"preview\";s:160:\"https://revolution.themepunch.com/peak-agency-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=peak-agency-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:129:\"<span class=\"ttm_content\">The Peak Agency Website template is a minimal, light one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Peak Agency\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"22\";s:9:\"installed\";b:0;}i:300;a:28:{s:2:\"id\";s:3:\"316\";s:5:\"title\";s:10:\"Peak About\";s:5:\"alias\";s:10:\"peak-about\";s:3:\"zip\";s:20:\"packs/peak-about.zip\";s:3:\"uid\";s:32:\"7e68b1012fb03490d45c7f79e8cb1b19\";s:3:\"img\";s:21:\"peak-about/slide1.jpg\";s:7:\"preview\";s:160:\"https://revolution.themepunch.com/peak-agency-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=peak-agency-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:129:\"<span class=\"ttm_content\">The Peak Agency Website template is a minimal, light one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Peak Agency\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"22\";s:9:\"installed\";b:0;}i:301;a:28:{s:2:\"id\";s:3:\"317\";s:5:\"title\";s:14:\"Peak Portfolio\";s:5:\"alias\";s:14:\"peak-portfolio\";s:3:\"zip\";s:24:\"packs/peak-portfolio.zip\";s:3:\"uid\";s:32:\"6198d1885ba9e95221c33e404f21bdbc\";s:3:\"img\";s:25:\"peak-portfolio/slide1.jpg\";s:7:\"preview\";s:160:\"https://revolution.themepunch.com/peak-agency-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=peak-agency-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:129:\"<span class=\"ttm_content\">The Peak Agency Website template is a minimal, light one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Peak Agency\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"22\";s:9:\"installed\";b:0;}i:302;a:28:{s:2:\"id\";s:3:\"318\";s:5:\"title\";s:11:\"Peak Footer\";s:5:\"alias\";s:11:\"peak-footer\";s:3:\"zip\";s:21:\"packs/peak-footer.zip\";s:3:\"uid\";s:32:\"2dead6897ad3b3a709b380d81242f76b\";s:3:\"img\";s:22:\"peak-footer/slide1.jpg\";s:7:\"preview\";s:160:\"https://revolution.themepunch.com/peak-agency-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=peak-agency-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:129:\"<span class=\"ttm_content\">The Peak Agency Website template is a minimal, light one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Peak Agency\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"22\";s:9:\"installed\";b:0;}i:304;a:28:{s:2:\"id\";s:3:\"320\";s:5:\"title\";s:17:\"Portfolio Welcome\";s:5:\"alias\";s:17:\"portfolio-welcome\";s:3:\"zip\";s:27:\"packs/portfolio-welcome.zip\";s:3:\"uid\";s:32:\"97336b8785e4a7b27facaf1547e0464d\";s:3:\"img\";s:28:\"portfolio-welcome/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/modern-portfolio-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=modern-portfolio-website\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A modern portfolio template with fancy scroll animations and a colorful design.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"Modern Portfolio\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:80:\"How to Add a Dramatic Pop of Color to Your Site with a Duotone Effect [Tutorial]\";s:9:\"guide_url\";s:113:\"https://www.sliderrevolution.com/tutorials/how-to-add-a-dramatic-pop-of-color-to-your-site-with-a-duotone-effect/\";s:9:\"guide_img\";s:37:\"tutorial/Modern-Portfolio-Website.png\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"23\";s:9:\"installed\";b:0;}i:305;a:28:{s:2:\"id\";s:3:\"321\";s:5:\"title\";s:15:\"Portfolio About\";s:5:\"alias\";s:15:\"portfolio-about\";s:3:\"zip\";s:25:\"packs/portfolio-about.zip\";s:3:\"uid\";s:32:\"5d3a4724fd453de5313ceb6696c1db62\";s:3:\"img\";s:26:\"portfolio-about/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/modern-portfolio-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=modern-portfolio-website\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A modern portfolio template with fancy scroll animations and a colorful design.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"Modern Portfolio\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:80:\"How to Add a Dramatic Pop of Color to Your Site with a Duotone Effect [Tutorial]\";s:9:\"guide_url\";s:113:\"https://www.sliderrevolution.com/tutorials/how-to-add-a-dramatic-pop-of-color-to-your-site-with-a-duotone-effect/\";s:9:\"guide_img\";s:37:\"tutorial/Modern-Portfolio-Website.png\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"23\";s:9:\"installed\";b:0;}i:306;a:28:{s:2:\"id\";s:3:\"322\";s:5:\"title\";s:21:\"Portfolio Works Title\";s:5:\"alias\";s:21:\"portfolio-works-title\";s:3:\"zip\";s:31:\"packs/portfolio-works-title.zip\";s:3:\"uid\";s:32:\"cbb5c6e875cc1f25b463fdf89cabef28\";s:3:\"img\";s:32:\"portfolio-works-title/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/modern-portfolio-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=modern-portfolio-website\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A modern portfolio template with fancy scroll animations and a colorful design.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"Modern Portfolio\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:80:\"How to Add a Dramatic Pop of Color to Your Site with a Duotone Effect [Tutorial]\";s:9:\"guide_url\";s:113:\"https://www.sliderrevolution.com/tutorials/how-to-add-a-dramatic-pop-of-color-to-your-site-with-a-duotone-effect/\";s:9:\"guide_img\";s:37:\"tutorial/Modern-Portfolio-Website.png\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"23\";s:9:\"installed\";b:0;}i:307;a:28:{s:2:\"id\";s:3:\"323\";s:5:\"title\";s:23:\"Portfolio Works Content\";s:5:\"alias\";s:23:\"portfolio-works-content\";s:3:\"zip\";s:33:\"packs/portfolio-works-content.zip\";s:3:\"uid\";s:32:\"5c87311128c7794ffa6ee07ea0648082\";s:3:\"img\";s:34:\"portfolio-works-content/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/modern-portfolio-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=modern-portfolio-website\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A modern portfolio template with fancy scroll animations and a colorful design.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"Modern Portfolio\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:80:\"How to Add a Dramatic Pop of Color to Your Site with a Duotone Effect [Tutorial]\";s:9:\"guide_url\";s:113:\"https://www.sliderrevolution.com/tutorials/how-to-add-a-dramatic-pop-of-color-to-your-site-with-a-duotone-effect/\";s:9:\"guide_img\";s:37:\"tutorial/Modern-Portfolio-Website.png\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"23\";s:9:\"installed\";b:0;}i:308;a:28:{s:2:\"id\";s:3:\"324\";s:5:\"title\";s:18:\"Portfolio Contacts\";s:5:\"alias\";s:18:\"portfolio-contacts\";s:3:\"zip\";s:28:\"packs/portfolio-contacts.zip\";s:3:\"uid\";s:32:\"bd81feffad83b69218f7e837478038e5\";s:3:\"img\";s:29:\"portfolio-contacts/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/modern-portfolio-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=modern-portfolio-website\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A modern portfolio template with fancy scroll animations and a colorful design.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"Modern Portfolio\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:80:\"How to Add a Dramatic Pop of Color to Your Site with a Duotone Effect [Tutorial]\";s:9:\"guide_url\";s:113:\"https://www.sliderrevolution.com/tutorials/how-to-add-a-dramatic-pop-of-color-to-your-site-with-a-duotone-effect/\";s:9:\"guide_img\";s:37:\"tutorial/Modern-Portfolio-Website.png\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"23\";s:9:\"installed\";b:0;}i:310;a:29:{s:2:\"id\";s:3:\"326\";s:5:\"title\";s:18:\"App Studio Welcome\";s:5:\"alias\";s:18:\"App-Studio-Welcome\";s:3:\"zip\";s:28:\"packs/App-Studio-Welcome.zip\";s:3:\"uid\";s:32:\"2ce0f3c54214b04e6c3a9becfd59730c\";s:3:\"img\";s:29:\"App-Studio-Welcome/slide1.jpg\";s:7:\"preview\";s:140:\"https://revolution.themepunch.com/app-studio-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=app-studio-website\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">A modern one-page presentation website to present your mobile app development team.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:10:\"App Studio\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"24\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:311;a:29:{s:2:\"id\";s:3:\"327\";s:5:\"title\";s:19:\"App Studio Services\";s:5:\"alias\";s:19:\"App-Studio-Services\";s:3:\"zip\";s:29:\"packs/App-Studio-Services.zip\";s:3:\"uid\";s:32:\"5df7776271ec69d2f9edaa6b842715a9\";s:3:\"img\";s:30:\"App-Studio-Services/slide1.jpg\";s:7:\"preview\";s:140:\"https://revolution.themepunch.com/app-studio-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=app-studio-website\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">A modern one-page presentation website to present your mobile app development team.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:10:\"App Studio\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"24\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:312;a:29:{s:2:\"id\";s:3:\"328\";s:5:\"title\";s:16:\"App Studio About\";s:5:\"alias\";s:16:\"App-Studio-About\";s:3:\"zip\";s:26:\"packs/App-Studio-About.zip\";s:3:\"uid\";s:32:\"af8b84dc116c629df7bd89fc69271a2e\";s:3:\"img\";s:27:\"App-Studio-About/slide1.jpg\";s:7:\"preview\";s:140:\"https://revolution.themepunch.com/app-studio-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=app-studio-website\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">A modern one-page presentation website to present your mobile app development team.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:10:\"App Studio\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"24\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:313;a:29:{s:2:\"id\";s:3:\"329\";s:5:\"title\";s:19:\"App Studio Contacts\";s:5:\"alias\";s:19:\"App-Studio-Contacts\";s:3:\"zip\";s:29:\"packs/App-Studio-Contacts.zip\";s:3:\"uid\";s:32:\"afbbd2214c983d314f3215a00db9198d\";s:3:\"img\";s:30:\"App-Studio-Contacts/slide1.jpg\";s:7:\"preview\";s:140:\"https://revolution.themepunch.com/app-studio-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=app-studio-website\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">A modern one-page presentation website to present your mobile app development team.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:10:\"App Studio\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"24\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:314;a:24:{s:2:\"id\";s:3:\"330\";s:5:\"title\";s:14:\"Cube Animation\";s:5:\"alias\";s:14:\"cube-animation\";s:3:\"zip\";s:18:\"cube-animation.zip\";s:3:\"uid\";s:32:\"c03dd3cfc60479dfc6d79ddb64fa0ec5\";s:3:\"img\";s:25:\"cube-animation/slide1.jpg\";s:7:\"preview\";s:164:\"https://revolution.themepunch.com/cube-animation-slider-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=cube-animation-slider-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:155:\"<span class=\"ttm_content\">A modern slider with text elements, cube animations and a striking call to action button.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:316;a:29:{s:2:\"id\";s:3:\"332\";s:5:\"title\";s:10:\"Basic Menu\";s:5:\"alias\";s:10:\"basic-menu\";s:3:\"zip\";s:20:\"packs/basic-menu.zip\";s:3:\"uid\";s:32:\"39277f53b2cb5ac644a1649b47c37270\";s:3:\"img\";s:21:\"basic-menu/slide1.jpg\";s:7:\"preview\";s:130:\"https://revolution.themepunch.com/basic-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=basic-website\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:317;a:29:{s:2:\"id\";s:3:\"333\";s:5:\"title\";s:12:\"Basic Header\";s:5:\"alias\";s:12:\"basic-header\";s:3:\"zip\";s:22:\"packs/basic-header.zip\";s:3:\"uid\";s:32:\"ad7a32dbccb0bdf9de64cf2adfa950a2\";s:3:\"img\";s:23:\"basic-header/slide1.jpg\";s:7:\"preview\";s:130:\"https://revolution.themepunch.com/basic-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=basic-website\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:318;a:29:{s:2:\"id\";s:3:\"334\";s:5:\"title\";s:13:\"Basic Content\";s:5:\"alias\";s:13:\"basic-content\";s:3:\"zip\";s:23:\"packs/basic-content.zip\";s:3:\"uid\";s:32:\"0b12f3b183a3c8206e3a7b28d2d93108\";s:3:\"img\";s:24:\"basic-content/slide1.jpg\";s:7:\"preview\";s:130:\"https://revolution.themepunch.com/basic-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=basic-website\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:319;a:29:{s:2:\"id\";s:3:\"335\";s:5:\"title\";s:14:\"Basic Carousel\";s:5:\"alias\";s:14:\"basic-carousel\";s:3:\"zip\";s:24:\"packs/basic-carousel.zip\";s:3:\"uid\";s:32:\"e4abb5c6d5cf914530575a982d3dfc14\";s:3:\"img\";s:25:\"basic-carousel/slide1.jpg\";s:7:\"preview\";s:130:\"https://revolution.themepunch.com/basic-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=basic-website\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:8:\"carousel\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:320;a:29:{s:2:\"id\";s:3:\"336\";s:5:\"title\";s:13:\"Basic Callout\";s:5:\"alias\";s:13:\"basic-callout\";s:3:\"zip\";s:23:\"packs/basic-callout.zip\";s:3:\"uid\";s:32:\"2ccc208b9322f5435d0f4ff64c6d9dab\";s:3:\"img\";s:24:\"basic-callout/slide1.jpg\";s:7:\"preview\";s:130:\"https://revolution.themepunch.com/basic-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=basic-website\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:321;a:29:{s:2:\"id\";s:3:\"337\";s:5:\"title\";s:10:\"Basic Grid\";s:5:\"alias\";s:10:\"basic-grid\";s:3:\"zip\";s:20:\"packs/basic-grid.zip\";s:3:\"uid\";s:32:\"3cb4b41d2992eba012921b8fb7c96daa\";s:3:\"img\";s:21:\"basic-grid/slide1.jpg\";s:7:\"preview\";s:130:\"https://revolution.themepunch.com/basic-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=basic-website\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:322;a:29:{s:2:\"id\";s:3:\"338\";s:5:\"title\";s:17:\"Basic Video Block\";s:5:\"alias\";s:17:\"basic-video-block\";s:3:\"zip\";s:27:\"packs/basic-video-block.zip\";s:3:\"uid\";s:32:\"e7c1d42b21819741f3e72c1325dae5ed\";s:3:\"img\";s:28:\"basic-video-block/slide1.jpg\";s:7:\"preview\";s:130:\"https://revolution.themepunch.com/basic-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=basic-website\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:323;a:29:{s:2:\"id\";s:3:\"339\";s:5:\"title\";s:12:\"Basic Footer\";s:5:\"alias\";s:12:\"basic-footer\";s:3:\"zip\";s:22:\"packs/basic-footer.zip\";s:3:\"uid\";s:32:\"ed8f6a554775ebace558af2f4f2dcbac\";s:3:\"img\";s:23:\"basic-footer/slide1.jpg\";s:7:\"preview\";s:130:\"https://revolution.themepunch.com/basic-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=basic-website\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:324;a:29:{s:2:\"id\";s:3:\"340\";s:5:\"title\";s:14:\"Basic Lightbox\";s:5:\"alias\";s:14:\"basic-lightbox\";s:3:\"zip\";s:24:\"packs/basic-lightbox.zip\";s:3:\"uid\";s:32:\"e4b025b300b1a8f417d04eb80113fac2\";s:3:\"img\";s:25:\"basic-lightbox/slide1.jpg\";s:7:\"preview\";s:130:\"https://revolution.themepunch.com/basic-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=basic-website\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"1\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:325;a:24:{s:2:\"id\";s:3:\"341\";s:5:\"title\";s:13:\"Nature Slider\";s:5:\"alias\";s:13:\"nature-slider\";s:3:\"zip\";s:17:\"nature-slider.zip\";s:3:\"uid\";s:32:\"eef1a4584ec1c3b8c26c305cca44e805\";s:3:\"img\";s:24:\"nature-slider/slide1.jpg\";s:7:\"preview\";s:147:\"http://revolution.themepunch.com/nature-explorer-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nature-explorer-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:151:\"<span class=\"ttm_content\">The Nature Explorer Slider Template uses the Distortion and Particle Effects Add-Ons.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:356:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"},{\"path\":\"revslider-liquideffect-addon\\/revslider-liquideffect-addon.php\",\"name\":\"Distortion Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:70:\"How to Design a Featured Post Slider That Impresses Readers [Tutorial]\";s:9:\"guide_url\";s:64:\"https://www.sliderrevolution.com/tutorials/featured-post-slider/\";s:9:\"guide_img\";s:26:\"tutorial/nature-slider.png\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:326;a:25:{s:2:\"id\";s:3:\"342\";s:5:\"title\";s:11:\"Art Gallery\";s:5:\"alias\";s:11:\"art-gallery\";s:3:\"zip\";s:15:\"art-gallery.zip\";s:3:\"uid\";s:32:\"b8c5095ae3407337e6e5b2a8515e7d6e\";s:3:\"img\";s:22:\"art-gallery/slide1.jpg\";s:7:\"preview\";s:158:\"https://revolution.themepunch.com/art-gallery-slider-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=art-gallery-slider-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:6:\"6.2.22\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A modern slider with large, geometric elements and interesting mask animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:71:\"Promote Your Most Recent Content with a Colorful Hero Design [Tutorial]\";s:9:\"guide_url\";s:104:\"https://www.sliderrevolution.com/tutorials/promote-your-most-recent-content-with-a-colorful-hero-design/\";s:9:\"guide_img\";s:31:\"tutorial/Art-Gallery-Slider.png\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:328;a:28:{s:2:\"id\";s:3:\"344\";s:5:\"title\";s:19:\"Construction Header\";s:5:\"alias\";s:19:\"Construction-Header\";s:3:\"zip\";s:29:\"packs/Construction-Header.zip\";s:3:\"uid\";s:32:\"5c77de774b8f5487c1276c4a7b3dc80c\";s:3:\"img\";s:30:\"Construction-Header/slide1.jpg\";s:7:\"preview\";s:160:\"https://revolution.themepunch.com/construction-company-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=construction-company-website\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:244:\"<span class=\"ttm_content\">The Construction Company is the perfect introduction to your Construction themed website. Showcase your current projects, services and contact information with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Construction Company\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"26\";s:9:\"installed\";b:0;}i:329;a:28:{s:2:\"id\";s:3:\"345\";s:5:\"title\";s:17:\"Construction Home\";s:5:\"alias\";s:17:\"Construction-Home\";s:3:\"zip\";s:27:\"packs/Construction-Home.zip\";s:3:\"uid\";s:32:\"fcb277f0c07dad270d2a7cef4431bef8\";s:3:\"img\";s:28:\"Construction-Home/slide1.jpg\";s:7:\"preview\";s:160:\"https://revolution.themepunch.com/construction-company-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=construction-company-website\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:244:\"<span class=\"ttm_content\">The Construction Company is the perfect introduction to your Construction themed website. Showcase your current projects, services and contact information with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Construction Company\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"26\";s:9:\"installed\";b:0;}i:330;a:28:{s:2:\"id\";s:3:\"346\";s:5:\"title\";s:21:\"Construction Projects\";s:5:\"alias\";s:21:\"Construction-Projects\";s:3:\"zip\";s:31:\"packs/Construction-Projects.zip\";s:3:\"uid\";s:32:\"0c847173c3739f79778dc2c0fc9704e4\";s:3:\"img\";s:32:\"Construction-Projects/slide1.jpg\";s:7:\"preview\";s:160:\"https://revolution.themepunch.com/construction-company-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=construction-company-website\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:244:\"<span class=\"ttm_content\">The Construction Company is the perfect introduction to your Construction themed website. Showcase your current projects, services and contact information with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Construction Company\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"26\";s:9:\"installed\";b:0;}i:331;a:28:{s:2:\"id\";s:3:\"347\";s:5:\"title\";s:20:\"Construction History\";s:5:\"alias\";s:20:\"Construction-History\";s:3:\"zip\";s:30:\"packs/Construction-History.zip\";s:3:\"uid\";s:32:\"758da120c4b6c5606692faf0aa43aac6\";s:3:\"img\";s:31:\"Construction-History/slide1.jpg\";s:7:\"preview\";s:160:\"https://revolution.themepunch.com/construction-company-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=construction-company-website\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:244:\"<span class=\"ttm_content\">The Construction Company is the perfect introduction to your Construction themed website. Showcase your current projects, services and contact information with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Construction Company\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"26\";s:9:\"installed\";b:0;}i:332;a:28:{s:2:\"id\";s:3:\"348\";s:5:\"title\";s:21:\"Construction Services\";s:5:\"alias\";s:21:\"Construction-Services\";s:3:\"zip\";s:31:\"packs/Construction-Services.zip\";s:3:\"uid\";s:32:\"5ad5b841c1d89e97ddbf972c8b11abd4\";s:3:\"img\";s:32:\"Construction-Services/slide1.jpg\";s:7:\"preview\";s:160:\"https://revolution.themepunch.com/construction-company-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=construction-company-website\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:244:\"<span class=\"ttm_content\">The Construction Company is the perfect introduction to your Construction themed website. Showcase your current projects, services and contact information with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Construction Company\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:11:\"zindex=\"10\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"26\";s:9:\"installed\";b:0;}i:333;a:28:{s:2:\"id\";s:3:\"349\";s:5:\"title\";s:21:\"Construction Contacts\";s:5:\"alias\";s:21:\"Construction-Contacts\";s:3:\"zip\";s:31:\"packs/Construction-Contacts.zip\";s:3:\"uid\";s:32:\"b8c3c34046bb91ebb243e4da64745d37\";s:3:\"img\";s:32:\"Construction-Contacts/slide1.jpg\";s:7:\"preview\";s:160:\"https://revolution.themepunch.com/construction-company-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=construction-company-website\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:244:\"<span class=\"ttm_content\">The Construction Company is the perfect introduction to your Construction themed website. Showcase your current projects, services and contact information with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Construction Company\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"26\";s:9:\"installed\";b:0;}i:334;a:25:{s:2:\"id\";s:3:\"350\";s:5:\"title\";s:22:\"Classic Cars Evolution\";s:5:\"alias\";s:22:\"Classic-Cars-Evolution\";s:3:\"zip\";s:26:\"Classic-Cars-Evolution.zip\";s:3:\"uid\";s:32:\"7061757f128fd624b0227715dab73b74\";s:3:\"img\";s:33:\"Classic-Cars-Evolution/slide1.jpg\";s:7:\"preview\";s:164:\"https://revolution.themepunch.com/classic-cars-before-after-hero/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=classic-cars-before-after-hero\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:156:\"<span class=\"ttm_content\">The Classic Cars Evolution Slider is a great example of our popular before & after Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-beforeafter-addon\\/revslider-beforeafter-addon.php\",\"name\":\"Before After AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:69:\"How to Create an Interactive Before-and-After Image Slider [Tutorial]\";s:9:\"guide_url\";s:102:\"https://www.sliderrevolution.com/tutorials/how-to-create-an-interactive-before-and-after-image-slider/\";s:9:\"guide_img\";s:35:\"tutorial/Classic-Cars-Evolution.jpg\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:335;a:24:{s:2:\"id\";s:3:\"351\";s:5:\"title\";s:21:\"404 Error Space Theme\";s:5:\"alias\";s:21:\"404-Error-Space-Theme\";s:3:\"zip\";s:25:\"404-Error-Space-Theme.zip\";s:3:\"uid\";s:32:\"6412adc7ec025826328e40e552a14e1e\";s:3:\"img\";s:32:\"404-Error-Space-Theme/slide1.jpg\";s:7:\"preview\";s:132:\"https://revolution.themepunch.com/404-error-page/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=404-error-page\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">The Classic Cars Evolution Slider is the perfect way to make your error page more beautiful.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:82:\"How to Create a 404 Page That Will Convert Instead of Cost You Visitors [Tutorial]\";s:9:\"guide_url\";s:68:\"https://www.sliderrevolution.com/tutorials/how-to-create-a-404-page/\";s:9:\"guide_img\";s:34:\"tutorial/404-Error-Space-Theme.png\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:337;a:28:{s:2:\"id\";s:3:\"353\";s:5:\"title\";s:17:\"Landing Page Hero\";s:5:\"alias\";s:17:\"landing-page-hero\";s:3:\"zip\";s:27:\"packs/landing-page-hero.zip\";s:3:\"uid\";s:32:\"d328635caa20da7ee8a3ab687f8656ff\";s:3:\"img\";s:28:\"landing-page-hero/slide1.jpg\";s:7:\"preview\";s:144:\"https://revolution.themepunch.com/landing-page-builder/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=landing-page-builder\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:193:\"<span class=\"ttm_content\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business/product.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:624:\"<span class=\"ttm_content\">After installing this template package, please remove the \"price modal\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \"Landing Page Hero\", \"Landing page Call to Action\" and \"Landing Page Footer\". Click the buttons in these template and then go to \"layer -> actions\" and set the target of the \"Open Slider Modal\" action to the \"Landing Page Price Modal\".</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Landing Page\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"27\";s:9:\"installed\";b:0;}i:338;a:28:{s:2:\"id\";s:3:\"354\";s:5:\"title\";s:21:\"Landing Page Features\";s:5:\"alias\";s:21:\"landing-page-features\";s:3:\"zip\";s:31:\"packs/landing-page-features.zip\";s:3:\"uid\";s:32:\"6552bc72abace10918a64866d9bb79c1\";s:3:\"img\";s:32:\"landing-page-features/slide1.jpg\";s:7:\"preview\";s:144:\"https://revolution.themepunch.com/landing-page-builder/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=landing-page-builder\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:193:\"<span class=\"ttm_content\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business/product.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:624:\"<span class=\"ttm_content\">After installing this template package, please remove the \"price modal\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \"Landing Page Hero\", \"Landing page Call to Action\" and \"Landing Page Footer\". Click the buttons in these template and then go to \"layer -> actions\" and set the target of the \"Open Slider Modal\" action to the \"Landing Page Price Modal\".</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Landing Page\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"27\";s:9:\"installed\";b:0;}i:339;a:28:{s:2:\"id\";s:3:\"355\";s:5:\"title\";s:20:\"Landing Page Callout\";s:5:\"alias\";s:20:\"landing-page-callout\";s:3:\"zip\";s:30:\"packs/landing-page-callout.zip\";s:3:\"uid\";s:32:\"c5b101ea5471e7409ae7effa8d45fbcf\";s:3:\"img\";s:31:\"landing-page-callout/slide1.jpg\";s:7:\"preview\";s:144:\"https://revolution.themepunch.com/landing-page-builder/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=landing-page-builder\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:193:\"<span class=\"ttm_content\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business/product.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:624:\"<span class=\"ttm_content\">After installing this template package, please remove the \"price modal\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \"Landing Page Hero\", \"Landing page Call to Action\" and \"Landing Page Footer\". Click the buttons in these template and then go to \"layer -> actions\" and set the target of the \"Open Slider Modal\" action to the \"Landing Page Price Modal\".</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Landing Page\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"27\";s:9:\"installed\";b:0;}i:340;a:28:{s:2:\"id\";s:3:\"356\";s:5:\"title\";s:20:\"Landing Page Content\";s:5:\"alias\";s:20:\"landing-page-content\";s:3:\"zip\";s:30:\"packs/landing-page-content.zip\";s:3:\"uid\";s:32:\"34da8057a6bb3677c9adf9f18ffc6cf0\";s:3:\"img\";s:31:\"landing-page-content/slide1.jpg\";s:7:\"preview\";s:144:\"https://revolution.themepunch.com/landing-page-builder/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=landing-page-builder\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:193:\"<span class=\"ttm_content\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business/product.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:624:\"<span class=\"ttm_content\">After installing this template package, please remove the \"price modal\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \"Landing Page Hero\", \"Landing page Call to Action\" and \"Landing Page Footer\". Click the buttons in these template and then go to \"layer -> actions\" and set the target of the \"Open Slider Modal\" action to the \"Landing Page Price Modal\".</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Landing Page\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"27\";s:9:\"installed\";b:0;}i:341;a:28:{s:2:\"id\";s:3:\"357\";s:5:\"title\";s:25:\"Landing Page Testimonials\";s:5:\"alias\";s:25:\"landing-page-testimonials\";s:3:\"zip\";s:35:\"packs/landing-page-testimonials.zip\";s:3:\"uid\";s:32:\"a83606e311cd5115422d86f04890cbf1\";s:3:\"img\";s:36:\"landing-page-testimonials/slide1.jpg\";s:7:\"preview\";s:144:\"https://revolution.themepunch.com/landing-page-builder/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=landing-page-builder\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:193:\"<span class=\"ttm_content\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business/product.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:624:\"<span class=\"ttm_content\">After installing this template package, please remove the \"price modal\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \"Landing Page Hero\", \"Landing page Call to Action\" and \"Landing Page Footer\". Click the buttons in these template and then go to \"layer -> actions\" and set the target of the \"Open Slider Modal\" action to the \"Landing Page Price Modal\".</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Landing Page\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"27\";s:9:\"installed\";b:0;}i:342;a:28:{s:2:\"id\";s:3:\"358\";s:5:\"title\";s:27:\"Landing Page Call to Action\";s:5:\"alias\";s:27:\"landing-page-call-to-action\";s:3:\"zip\";s:37:\"packs/landing-page-call-to-action.zip\";s:3:\"uid\";s:32:\"adfb456b27fa7eb6b1415d8f80836f05\";s:3:\"img\";s:38:\"landing-page-call-to-action/slide1.jpg\";s:7:\"preview\";s:144:\"https://revolution.themepunch.com/landing-page-builder/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=landing-page-builder\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:193:\"<span class=\"ttm_content\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business/product.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:624:\"<span class=\"ttm_content\">After installing this template package, please remove the \"price modal\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \"Landing Page Hero\", \"Landing page Call to Action\" and \"Landing Page Footer\". Click the buttons in these template and then go to \"layer -> actions\" and set the target of the \"Open Slider Modal\" action to the \"Landing Page Price Modal\".</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Landing Page\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"27\";s:9:\"installed\";b:0;}i:343;a:28:{s:2:\"id\";s:3:\"359\";s:5:\"title\";s:17:\"Landing Page Help\";s:5:\"alias\";s:17:\"landing-page-help\";s:3:\"zip\";s:27:\"packs/landing-page-help.zip\";s:3:\"uid\";s:32:\"ca502431f9b7f6249d99b02464de2dd7\";s:3:\"img\";s:28:\"landing-page-help/slide1.jpg\";s:7:\"preview\";s:144:\"https://revolution.themepunch.com/landing-page-builder/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=landing-page-builder\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:193:\"<span class=\"ttm_content\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business/product.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:624:\"<span class=\"ttm_content\">After installing this template package, please remove the \"price modal\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \"Landing Page Hero\", \"Landing page Call to Action\" and \"Landing Page Footer\". Click the buttons in these template and then go to \"layer -> actions\" and set the target of the \"Open Slider Modal\" action to the \"Landing Page Price Modal\".</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Landing Page\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"27\";s:9:\"installed\";b:0;}i:344;a:28:{s:2:\"id\";s:3:\"360\";s:5:\"title\";s:19:\"Landing Page Footer\";s:5:\"alias\";s:19:\"landing-page-footer\";s:3:\"zip\";s:29:\"packs/landing-page-footer.zip\";s:3:\"uid\";s:32:\"2a6afc371dbd60cb117f8a0f5d09eac9\";s:3:\"img\";s:30:\"landing-page-footer/slide1.jpg\";s:7:\"preview\";s:144:\"https://revolution.themepunch.com/landing-page-builder/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=landing-page-builder\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:193:\"<span class=\"ttm_content\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business/product.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:624:\"<span class=\"ttm_content\">After installing this template package, please remove the \"price modal\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \"Landing Page Hero\", \"Landing page Call to Action\" and \"Landing Page Footer\". Click the buttons in these template and then go to \"layer -> actions\" and set the target of the \"Open Slider Modal\" action to the \"Landing Page Price Modal\".</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Landing Page\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"27\";s:9:\"installed\";b:0;}i:345;a:28:{s:2:\"id\";s:3:\"361\";s:5:\"title\";s:24:\"Landing Page Price Modal\";s:5:\"alias\";s:24:\"landing-page-price-modal\";s:3:\"zip\";s:34:\"packs/landing-page-price-modal.zip\";s:3:\"uid\";s:32:\"a6c5c0430b46dd4e6e68416964a8c54d\";s:3:\"img\";s:35:\"landing-page-price-modal/slide1.jpg\";s:7:\"preview\";s:144:\"https://revolution.themepunch.com/landing-page-builder/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=landing-page-builder\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:193:\"<span class=\"ttm_content\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business/product.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:624:\"<span class=\"ttm_content\">After installing this template package, please remove the \"price modal\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \"Landing Page Hero\", \"Landing page Call to Action\" and \"Landing Page Footer\". Click the buttons in these template and then go to \"layer -> actions\" and set the target of the \"Open Slider Modal\" action to the \"Landing Page Price Modal\".</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Landing Page\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"1\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"27\";s:9:\"installed\";b:0;}i:347;a:27:{s:2:\"id\";s:3:\"372\";s:5:\"title\";s:16:\"Corporate Header\";s:5:\"alias\";s:16:\"Corporate-Header\";s:3:\"zip\";s:26:\"packs/Corporate-Header.zip\";s:3:\"uid\";s:32:\"04f868e3812a1681f00ab89580e5d1f8\";s:3:\"img\";s:27:\"Corporate-Header/slide1.jpg\";s:7:\"preview\";s:156:\"https://revolution.themepunch.com/corporate-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:348;a:27:{s:2:\"id\";s:3:\"373\";s:5:\"title\";s:24:\"Corporate Welcome Screen\";s:5:\"alias\";s:24:\"Corporate-Welcome-Screen\";s:3:\"zip\";s:34:\"packs/Corporate-Welcome-Screen.zip\";s:3:\"uid\";s:32:\"052afe98ef819f7ace041dbbdb749639\";s:3:\"img\";s:35:\"Corporate-Welcome-Screen/slide1.jpg\";s:7:\"preview\";s:156:\"https://revolution.themepunch.com/corporate-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:173:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:349;a:27:{s:2:\"id\";s:3:\"374\";s:5:\"title\";s:15:\"Corporate About\";s:5:\"alias\";s:15:\"Corporate-About\";s:3:\"zip\";s:25:\"packs/Corporate-About.zip\";s:3:\"uid\";s:32:\"7bf5f8f6d4cc3016cea86289cb46e5b6\";s:3:\"img\";s:26:\"Corporate-About/slide1.jpg\";s:7:\"preview\";s:156:\"https://revolution.themepunch.com/corporate-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:350;a:27:{s:2:\"id\";s:3:\"375\";s:5:\"title\";s:19:\"Corporate Portfolio\";s:5:\"alias\";s:19:\"Corporate-Portfolio\";s:3:\"zip\";s:29:\"packs/Corporate-Portfolio.zip\";s:3:\"uid\";s:32:\"612c2bd784fea81392dda1644a3c3cf3\";s:3:\"img\";s:30:\"Corporate-Portfolio/slide1.jpg\";s:7:\"preview\";s:156:\"https://revolution.themepunch.com/corporate-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:351;a:27:{s:2:\"id\";s:3:\"376\";s:5:\"title\";s:15:\"Corporate Chart\";s:5:\"alias\";s:15:\"Corporate-Chart\";s:3:\"zip\";s:25:\"packs/Corporate-Chart.zip\";s:3:\"uid\";s:32:\"4d27d9b3b2cfcce750e526aafb322a9f\";s:3:\"img\";s:26:\"Corporate-Chart/slide1.jpg\";s:7:\"preview\";s:156:\"https://revolution.themepunch.com/corporate-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:352;a:27:{s:2:\"id\";s:3:\"377\";s:5:\"title\";s:14:\"Corporate News\";s:5:\"alias\";s:14:\"Corporate-News\";s:3:\"zip\";s:24:\"packs/Corporate-News.zip\";s:3:\"uid\";s:32:\"bb65ed57a0d4db795d8b738f0a92f2d7\";s:3:\"img\";s:25:\"Corporate-News/slide1.jpg\";s:7:\"preview\";s:156:\"https://revolution.themepunch.com/corporate-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:353;a:27:{s:2:\"id\";s:3:\"378\";s:5:\"title\";s:16:\"Corporate Hiring\";s:5:\"alias\";s:16:\"Corporate-Hiring\";s:3:\"zip\";s:26:\"packs/Corporate-Hiring.zip\";s:3:\"uid\";s:32:\"136cf1a91604e819089eb3573a6e100a\";s:3:\"img\";s:27:\"Corporate-Hiring/slide1.jpg\";s:7:\"preview\";s:156:\"https://revolution.themepunch.com/corporate-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:354;a:27:{s:2:\"id\";s:3:\"379\";s:5:\"title\";s:22:\"Corporate Testimonials\";s:5:\"alias\";s:22:\"Corporate-Testimonials\";s:3:\"zip\";s:32:\"packs/Corporate-Testimonials.zip\";s:3:\"uid\";s:32:\"b17aec0afdc31e37359cfa406164463c\";s:3:\"img\";s:33:\"Corporate-Testimonials/slide1.jpg\";s:7:\"preview\";s:156:\"https://revolution.themepunch.com/corporate-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:355;a:27:{s:2:\"id\";s:3:\"380\";s:5:\"title\";s:15:\"Corporate Store\";s:5:\"alias\";s:15:\"Corporate-Store\";s:3:\"zip\";s:25:\"packs/Corporate-Store.zip\";s:3:\"uid\";s:32:\"6240b14620ddc634736716e0cdfdeb31\";s:3:\"img\";s:26:\"Corporate-Store/slide1.jpg\";s:7:\"preview\";s:156:\"https://revolution.themepunch.com/corporate-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:356;a:27:{s:2:\"id\";s:3:\"381\";s:5:\"title\";s:17:\"Corporate Support\";s:5:\"alias\";s:17:\"Corporate-Support\";s:3:\"zip\";s:27:\"packs/Corporate-Support.zip\";s:3:\"uid\";s:32:\"9424292a78076ce68c2faf587b26cdad\";s:3:\"img\";s:28:\"Corporate-Support/slide1.jpg\";s:7:\"preview\";s:156:\"https://revolution.themepunch.com/corporate-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:2:\"10\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:357;a:27:{s:2:\"id\";s:3:\"382\";s:5:\"title\";s:14:\"Corporate Team\";s:5:\"alias\";s:14:\"Corporate-Team\";s:3:\"zip\";s:24:\"packs/Corporate-Team.zip\";s:3:\"uid\";s:32:\"4fafe469b5a0a2545625c3f6d7ff3b9e\";s:3:\"img\";s:25:\"Corporate-Team/slide1.jpg\";s:7:\"preview\";s:156:\"https://revolution.themepunch.com/corporate-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:2:\"11\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:358;a:27:{s:2:\"id\";s:3:\"383\";s:5:\"title\";s:33:\"Corporate Selected Projects Title\";s:5:\"alias\";s:33:\"Corporate-Selected-Projects-Title\";s:3:\"zip\";s:43:\"packs/Corporate-Selected-Projects-Title.zip\";s:3:\"uid\";s:32:\"0ed3c41f51e6bf404c2fe179fa8d8ceb\";s:3:\"img\";s:44:\"Corporate-Selected-Projects-Title/slide1.jpg\";s:7:\"preview\";s:156:\"https://revolution.themepunch.com/corporate-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:2:\"12\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:359;a:27:{s:2:\"id\";s:3:\"384\";s:5:\"title\";s:27:\"Corporate Selected Projects\";s:5:\"alias\";s:27:\"Corporate-Selected-Projects\";s:3:\"zip\";s:37:\"packs/Corporate-Selected-Projects.zip\";s:3:\"uid\";s:32:\"1096c78d5f007f3900228a4092515e2e\";s:3:\"img\";s:38:\"Corporate-Selected-Projects/slide1.jpg\";s:7:\"preview\";s:156:\"https://revolution.themepunch.com/corporate-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:2:\"13\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:360;a:27:{s:2:\"id\";s:3:\"385\";s:5:\"title\";s:17:\"Corporate Clients\";s:5:\"alias\";s:17:\"Corporate-Clients\";s:3:\"zip\";s:27:\"packs/Corporate-Clients.zip\";s:3:\"uid\";s:32:\"60fe3a311195bf4dba3e50bd1ab98574\";s:3:\"img\";s:28:\"Corporate-Clients/slide1.jpg\";s:7:\"preview\";s:156:\"https://revolution.themepunch.com/corporate-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:2:\"14\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:361;a:27:{s:2:\"id\";s:3:\"386\";s:5:\"title\";s:20:\"Corporate Text Block\";s:5:\"alias\";s:20:\"Corporate-Text-Block\";s:3:\"zip\";s:30:\"packs/Corporate-Text-Block.zip\";s:3:\"uid\";s:32:\"93b68bb23d65fd1028b6b5f6d19b85b5\";s:3:\"img\";s:31:\"Corporate-Text-Block/slide1.jpg\";s:7:\"preview\";s:156:\"https://revolution.themepunch.com/corporate-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:2:\"15\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:362;a:27:{s:2:\"id\";s:3:\"387\";s:5:\"title\";s:20:\"Corporate Mobile App\";s:5:\"alias\";s:20:\"Corporate-Mobile-App\";s:3:\"zip\";s:30:\"packs/Corporate-Mobile-App.zip\";s:3:\"uid\";s:32:\"e592369d233bea673403daa15c6e498a\";s:3:\"img\";s:31:\"Corporate-Mobile-App/slide1.jpg\";s:7:\"preview\";s:156:\"https://revolution.themepunch.com/corporate-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:2:\"16\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:363;a:27:{s:2:\"id\";s:3:\"388\";s:5:\"title\";s:18:\"Corporate Contacts\";s:5:\"alias\";s:18:\"Corporate-Contacts\";s:3:\"zip\";s:28:\"packs/Corporate-Contacts.zip\";s:3:\"uid\";s:32:\"91ae9488b54b7020f8ae9dfbfd6c563a\";s:3:\"img\";s:29:\"Corporate-Contacts/slide1.jpg\";s:7:\"preview\";s:156:\"https://revolution.themepunch.com/corporate-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:2:\"17\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:364;a:27:{s:2:\"id\";s:3:\"389\";s:5:\"title\";s:16:\"Corporate Footer\";s:5:\"alias\";s:16:\"Corporate-Footer\";s:3:\"zip\";s:26:\"packs/Corporate-Footer.zip\";s:3:\"uid\";s:32:\"a01df90af203f06194c1a18745d79861\";s:3:\"img\";s:27:\"Corporate-Footer/slide1.jpg\";s:7:\"preview\";s:156:\"https://revolution.themepunch.com/corporate-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:2:\"18\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:365;a:27:{s:2:\"id\";s:3:\"390\";s:5:\"title\";s:23:\"Corporate Scroll To Top\";s:5:\"alias\";s:23:\"Corporate-Scroll-To-Top\";s:3:\"zip\";s:33:\"packs/Corporate-Scroll-To-Top.zip\";s:3:\"uid\";s:32:\"2d68f6e4590a9a445e6eb055dfee88ba\";s:3:\"img\";s:34:\"Corporate-Scroll-To-Top/slide1.jpg\";s:7:\"preview\";s:156:\"https://revolution.themepunch.com/corporate-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:2:\"19\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:367;a:28:{s:2:\"id\";s:3:\"403\";s:5:\"title\";s:11:\"Brutal Menu\";s:5:\"alias\";s:11:\"brutal-menu\";s:3:\"zip\";s:21:\"packs/brutal-menu.zip\";s:3:\"uid\";s:32:\"04b21c7aee2479793336e964230d6e3f\";s:3:\"img\";s:22:\"brutal-menu/slide1.jpg\";s:7:\"preview\";s:150:\"https://revolution.themepunch.com/brutal-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=brutal-website-template\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">The Brutal template is a one-pager with a unique design that sticks out. The project & services sliders with direction based transitions are particularly interesting.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Brutal Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:78:\"How to Create a Scroll-Triggered About Me Section for the Home Page [Tutorial]\";s:9:\"guide_url\";s:111:\"https://www.sliderrevolution.com/tutorials/how-to-create-a-scroll-triggered-about-me-section-for-the-home-page/\";s:9:\"guide_img\";s:27:\"tutorial/Brutal-Website.png\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"31\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:368;a:28:{s:2:\"id\";s:3:\"404\";s:5:\"title\";s:11:\"Brutal Hero\";s:5:\"alias\";s:11:\"brutal-hero\";s:3:\"zip\";s:21:\"packs/brutal-hero.zip\";s:3:\"uid\";s:32:\"a342ad01054b97bac7980fdf9e275b34\";s:3:\"img\";s:22:\"brutal-hero/slide1.jpg\";s:7:\"preview\";s:150:\"https://revolution.themepunch.com/brutal-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=brutal-website-template\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">The Brutal template is a one-pager with a unique design that sticks out. The project & services sliders with direction based transitions are particularly interesting.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Brutal Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:78:\"How to Create a Scroll-Triggered About Me Section for the Home Page [Tutorial]\";s:9:\"guide_url\";s:111:\"https://www.sliderrevolution.com/tutorials/how-to-create-a-scroll-triggered-about-me-section-for-the-home-page/\";s:9:\"guide_img\";s:27:\"tutorial/Brutal-Website.png\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"31\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:369;a:28:{s:2:\"id\";s:3:\"405\";s:5:\"title\";s:12:\"Brutal About\";s:5:\"alias\";s:12:\"brutal-about\";s:3:\"zip\";s:22:\"packs/brutal-about.zip\";s:3:\"uid\";s:32:\"a3e1cd2e36c9a783c1932fdafe2e4434\";s:3:\"img\";s:23:\"brutal-about/slide1.jpg\";s:7:\"preview\";s:150:\"https://revolution.themepunch.com/brutal-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=brutal-website-template\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">The Brutal template is a one-pager with a unique design that sticks out. The project & services sliders with direction based transitions are particularly interesting.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Brutal Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:78:\"How to Create a Scroll-Triggered About Me Section for the Home Page [Tutorial]\";s:9:\"guide_url\";s:111:\"https://www.sliderrevolution.com/tutorials/how-to-create-a-scroll-triggered-about-me-section-for-the-home-page/\";s:9:\"guide_img\";s:27:\"tutorial/Brutal-Website.png\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"31\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:370;a:28:{s:2:\"id\";s:3:\"406\";s:5:\"title\";s:16:\"Brutal Highlight\";s:5:\"alias\";s:16:\"brutal-highlight\";s:3:\"zip\";s:26:\"packs/brutal-highlight.zip\";s:3:\"uid\";s:32:\"b7f8522dcb4636467633bd3b14f4e3e9\";s:3:\"img\";s:27:\"brutal-highlight/slide1.jpg\";s:7:\"preview\";s:150:\"https://revolution.themepunch.com/brutal-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=brutal-website-template\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">The Brutal template is a one-pager with a unique design that sticks out. The project & services sliders with direction based transitions are particularly interesting.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Brutal Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:78:\"How to Create a Scroll-Triggered About Me Section for the Home Page [Tutorial]\";s:9:\"guide_url\";s:111:\"https://www.sliderrevolution.com/tutorials/how-to-create-a-scroll-triggered-about-me-section-for-the-home-page/\";s:9:\"guide_img\";s:27:\"tutorial/Brutal-Website.png\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"31\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:371;a:28:{s:2:\"id\";s:3:\"407\";s:5:\"title\";s:15:\"Brutal Projects\";s:5:\"alias\";s:15:\"brutal-projects\";s:3:\"zip\";s:25:\"packs/brutal-projects.zip\";s:3:\"uid\";s:32:\"1a462e91373042193ca5d623dd8e8a47\";s:3:\"img\";s:26:\"brutal-projects/slide1.jpg\";s:7:\"preview\";s:150:\"https://revolution.themepunch.com/brutal-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=brutal-website-template\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">The Brutal template is a one-pager with a unique design that sticks out. The project & services sliders with direction based transitions are particularly interesting.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Brutal Website Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:78:\"How to Create a Scroll-Triggered About Me Section for the Home Page [Tutorial]\";s:9:\"guide_url\";s:111:\"https://www.sliderrevolution.com/tutorials/how-to-create-a-scroll-triggered-about-me-section-for-the-home-page/\";s:9:\"guide_img\";s:27:\"tutorial/Brutal-Website.png\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"31\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:372;a:28:{s:2:\"id\";s:3:\"408\";s:5:\"title\";s:15:\"Brutal Services\";s:5:\"alias\";s:15:\"brutal-services\";s:3:\"zip\";s:25:\"packs/brutal-services.zip\";s:3:\"uid\";s:32:\"cbeeb1e7a5c2842b155fe13acb7c165d\";s:3:\"img\";s:26:\"brutal-services/slide1.jpg\";s:7:\"preview\";s:150:\"https://revolution.themepunch.com/brutal-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=brutal-website-template\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">The Brutal template is a one-pager with a unique design that sticks out. The project & services sliders with direction based transitions are particularly interesting.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Brutal Website Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:78:\"How to Create a Scroll-Triggered About Me Section for the Home Page [Tutorial]\";s:9:\"guide_url\";s:111:\"https://www.sliderrevolution.com/tutorials/how-to-create-a-scroll-triggered-about-me-section-for-the-home-page/\";s:9:\"guide_img\";s:27:\"tutorial/Brutal-Website.png\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"31\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:373;a:28:{s:2:\"id\";s:3:\"409\";s:5:\"title\";s:14:\"Brutal Callout\";s:5:\"alias\";s:14:\"brutal-callout\";s:3:\"zip\";s:24:\"packs/brutal-callout.zip\";s:3:\"uid\";s:32:\"31b6dafdb2dfb548152653e60df5a3bc\";s:3:\"img\";s:25:\"brutal-callout/slide1.jpg\";s:7:\"preview\";s:150:\"https://revolution.themepunch.com/brutal-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=brutal-website-template\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">The Brutal template is a one-pager with a unique design that sticks out. The project & services sliders with direction based transitions are particularly interesting.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Brutal Website Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:78:\"How to Create a Scroll-Triggered About Me Section for the Home Page [Tutorial]\";s:9:\"guide_url\";s:111:\"https://www.sliderrevolution.com/tutorials/how-to-create-a-scroll-triggered-about-me-section-for-the-home-page/\";s:9:\"guide_img\";s:27:\"tutorial/Brutal-Website.png\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"31\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:374;a:28:{s:2:\"id\";s:3:\"410\";s:5:\"title\";s:13:\"Brutal Footer\";s:5:\"alias\";s:13:\"brutal-footer\";s:3:\"zip\";s:23:\"packs/brutal-footer.zip\";s:3:\"uid\";s:32:\"07559f0c574e3dd95b2d40d72cbb01bc\";s:3:\"img\";s:24:\"brutal-footer/slide1.jpg\";s:7:\"preview\";s:150:\"https://revolution.themepunch.com/brutal-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=brutal-website-template\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">The Brutal template is a one-pager with a unique design that sticks out. The project & services sliders with direction based transitions are particularly interesting.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Brutal Website Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:78:\"How to Create a Scroll-Triggered About Me Section for the Home Page [Tutorial]\";s:9:\"guide_url\";s:111:\"https://www.sliderrevolution.com/tutorials/how-to-create-a-scroll-triggered-about-me-section-for-the-home-page/\";s:9:\"guide_img\";s:27:\"tutorial/Brutal-Website.png\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"31\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:376;a:27:{s:2:\"id\";s:3:\"412\";s:5:\"title\";s:13:\"Church Header\";s:5:\"alias\";s:13:\"Church-Header\";s:3:\"zip\";s:23:\"packs/Church-Header.zip\";s:3:\"uid\";s:32:\"c14289117e1e2b9ee716fb99146b2e03\";s:3:\"img\";s:24:\"Church-Header/slide1.jpg\";s:7:\"preview\";s:160:\"https://revolution.themepunch.com/church-website-template-dark/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=church-website-template-dark\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Church Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"32\";s:9:\"installed\";b:0;}i:377;a:28:{s:2:\"id\";s:3:\"413\";s:5:\"title\";s:22:\"Church Upcoming Events\";s:5:\"alias\";s:22:\"Church-Upcoming-Events\";s:3:\"zip\";s:32:\"packs/Church-Upcoming-Events.zip\";s:3:\"uid\";s:32:\"056a26efddae92973fee4ee5cfa75f10\";s:3:\"img\";s:33:\"Church-Upcoming-Events/slide1.jpg\";s:7:\"preview\";s:160:\"https://revolution.themepunch.com/church-website-template-dark/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=church-website-template-dark\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Church Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"32\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:378;a:27:{s:2:\"id\";s:3:\"414\";s:5:\"title\";s:12:\"Church About\";s:5:\"alias\";s:12:\"Church-About\";s:3:\"zip\";s:22:\"packs/Church-About.zip\";s:3:\"uid\";s:32:\"8ef133f3f669f06380334a83e27eedbb\";s:3:\"img\";s:23:\"Church-About/slide1.jpg\";s:7:\"preview\";s:160:\"https://revolution.themepunch.com/church-website-template-dark/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=church-website-template-dark\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Church Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"32\";s:9:\"installed\";b:0;}i:379;a:27:{s:2:\"id\";s:3:\"415\";s:5:\"title\";s:14:\"Church Pastors\";s:5:\"alias\";s:14:\"Church-Pastors\";s:3:\"zip\";s:24:\"packs/Church-Pastors.zip\";s:3:\"uid\";s:32:\"715edc0833a753b72350b8c974f86f94\";s:3:\"img\";s:25:\"Church-Pastors/slide1.jpg\";s:7:\"preview\";s:160:\"https://revolution.themepunch.com/church-website-template-dark/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=church-website-template-dark\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Church Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"32\";s:9:\"installed\";b:0;}i:380;a:27:{s:2:\"id\";s:3:\"416\";s:5:\"title\";s:20:\"Church Photo Gallery\";s:5:\"alias\";s:20:\"Church-Photo-Gallery\";s:3:\"zip\";s:30:\"packs/Church-Photo-Gallery.zip\";s:3:\"uid\";s:32:\"d94808a97149cd5d3b3354a28409ffd7\";s:3:\"img\";s:31:\"Church-Photo-Gallery/slide1.jpg\";s:7:\"preview\";s:160:\"https://revolution.themepunch.com/church-website-template-dark/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=church-website-template-dark\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Church Website Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"32\";s:9:\"installed\";b:0;}i:381;a:27:{s:2:\"id\";s:3:\"417\";s:5:\"title\";s:16:\"Church Community\";s:5:\"alias\";s:16:\"Church-Community\";s:3:\"zip\";s:26:\"packs/Church-Community.zip\";s:3:\"uid\";s:32:\"2244e6a6d7a691653eae2d70765130a7\";s:3:\"img\";s:27:\"Church-Community/slide1.jpg\";s:7:\"preview\";s:160:\"https://revolution.themepunch.com/church-website-template-dark/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=church-website-template-dark\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Church Website Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"32\";s:9:\"installed\";b:0;}i:382;a:27:{s:2:\"id\";s:3:\"418\";s:5:\"title\";s:13:\"Church Sermon\";s:5:\"alias\";s:13:\"Church-Sermon\";s:3:\"zip\";s:23:\"packs/Church-Sermon.zip\";s:3:\"uid\";s:32:\"8fedf983bd55fff0f7a16d9f0a7e5408\";s:3:\"img\";s:24:\"Church-Sermon/slide1.jpg\";s:7:\"preview\";s:160:\"https://revolution.themepunch.com/church-website-template-dark/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=church-website-template-dark\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Church Website Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"32\";s:9:\"installed\";b:0;}i:383;a:27:{s:2:\"id\";s:3:\"419\";s:5:\"title\";s:15:\"Church Contacts\";s:5:\"alias\";s:15:\"Church-Contacts\";s:3:\"zip\";s:25:\"packs/Church-Contacts.zip\";s:3:\"uid\";s:32:\"0b1a6968e75868548fd98e435625c090\";s:3:\"img\";s:26:\"Church-Contacts/slide1.jpg\";s:7:\"preview\";s:160:\"https://revolution.themepunch.com/church-website-template-dark/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=church-website-template-dark\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Church Website Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"32\";s:9:\"installed\";b:0;}i:384;a:27:{s:2:\"id\";s:3:\"420\";s:5:\"title\";s:13:\"Church Footer\";s:5:\"alias\";s:13:\"Church-Footer\";s:3:\"zip\";s:23:\"packs/Church-Footer.zip\";s:3:\"uid\";s:32:\"29756685d3dc49e42edada43e6393b7b\";s:3:\"img\";s:24:\"Church-Footer/slide1.jpg\";s:7:\"preview\";s:160:\"https://revolution.themepunch.com/church-website-template-dark/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=church-website-template-dark\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Church Website Template\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"32\";s:9:\"installed\";b:0;}i:386;a:27:{s:2:\"id\";s:3:\"422\";s:5:\"title\";s:19:\"Church Light Header\";s:5:\"alias\";s:19:\"Church-Light-Header\";s:3:\"zip\";s:29:\"packs/Church-Light-Header.zip\";s:3:\"uid\";s:32:\"81c00f4b52cf55214de919e3f13121fc\";s:3:\"img\";s:30:\"Church-Light-Header/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/church-website-template-light/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=church-website-template-light\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Church Light Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"33\";s:9:\"installed\";b:0;}i:387;a:28:{s:2:\"id\";s:3:\"423\";s:5:\"title\";s:28:\"Church Light Upcoming Events\";s:5:\"alias\";s:28:\"Church-Light-Upcoming-Events\";s:3:\"zip\";s:38:\"packs/Church-Light-Upcoming-Events.zip\";s:3:\"uid\";s:32:\"963a49f4be0557ac5f3ee61d256f5bda\";s:3:\"img\";s:39:\"Church-Light-Upcoming-Events/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/church-website-template-light/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=church-website-template-light\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Church Light Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"33\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:388;a:27:{s:2:\"id\";s:3:\"424\";s:5:\"title\";s:18:\"Church Light About\";s:5:\"alias\";s:18:\"Church-Light-About\";s:3:\"zip\";s:28:\"packs/Church-Light-About.zip\";s:3:\"uid\";s:32:\"d46c8e8e6f80e6bfedb54f1cdc49e7e6\";s:3:\"img\";s:29:\"Church-Light-About/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/church-website-template-light/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=church-website-template-light\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Church Light Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"33\";s:9:\"installed\";b:0;}i:389;a:27:{s:2:\"id\";s:3:\"425\";s:5:\"title\";s:20:\"Church Light Pastors\";s:5:\"alias\";s:20:\"Church-Light-Pastors\";s:3:\"zip\";s:30:\"packs/Church-Light-Pastors.zip\";s:3:\"uid\";s:32:\"7cc3dec61556e2291d6f38c1ea5e983f\";s:3:\"img\";s:31:\"Church-Light-Pastors/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/church-website-template-light/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=church-website-template-light\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Church Light Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"33\";s:9:\"installed\";b:0;}i:390;a:27:{s:2:\"id\";s:3:\"426\";s:5:\"title\";s:26:\"Church Light Photo Gallery\";s:5:\"alias\";s:26:\"Church-Light-Photo-Gallery\";s:3:\"zip\";s:36:\"packs/Church-Light-Photo-Gallery.zip\";s:3:\"uid\";s:32:\"9e13100179b9b700b005693eeca57902\";s:3:\"img\";s:37:\"Church-Light-Photo-Gallery/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/church-website-template-light/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=church-website-template-light\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Church Light Website Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"33\";s:9:\"installed\";b:0;}i:391;a:27:{s:2:\"id\";s:3:\"427\";s:5:\"title\";s:22:\"Church Light Community\";s:5:\"alias\";s:22:\"Church-Light-Community\";s:3:\"zip\";s:32:\"packs/Church-Light-Community.zip\";s:3:\"uid\";s:32:\"14fcc0d43d899fd96116bdbc57c7c5ea\";s:3:\"img\";s:33:\"Church-Light-Community/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/church-website-template-light/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=church-website-template-light\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Church Light Website Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"33\";s:9:\"installed\";b:0;}i:392;a:27:{s:2:\"id\";s:3:\"428\";s:5:\"title\";s:19:\"Church Light Sermon\";s:5:\"alias\";s:19:\"Church-Light-Sermon\";s:3:\"zip\";s:29:\"packs/Church-Light-Sermon.zip\";s:3:\"uid\";s:32:\"fc30be7e703bc7b235665c36baa80e4e\";s:3:\"img\";s:30:\"Church-Light-Sermon/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/church-website-template-light/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=church-website-template-light\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Church Light Website Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"33\";s:9:\"installed\";b:0;}i:393;a:27:{s:2:\"id\";s:3:\"429\";s:5:\"title\";s:21:\"Church Light Contacts\";s:5:\"alias\";s:21:\"Church-Light-Contacts\";s:3:\"zip\";s:31:\"packs/Church-Light-Contacts.zip\";s:3:\"uid\";s:32:\"ed83d8fa63ecb59cf42656068ecf8d25\";s:3:\"img\";s:32:\"Church-Light-Contacts/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/church-website-template-light/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=church-website-template-light\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Church Light Website Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"33\";s:9:\"installed\";b:0;}i:394;a:27:{s:2:\"id\";s:3:\"430\";s:5:\"title\";s:19:\"Church Light Footer\";s:5:\"alias\";s:19:\"Church-Light-Footer\";s:3:\"zip\";s:29:\"packs/Church-Light-Footer.zip\";s:3:\"uid\";s:32:\"a168772865fd5dcf6229c9c6a49dff73\";s:3:\"img\";s:30:\"Church-Light-Footer/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/church-website-template-light/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=church-website-template-light\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Church Light Website Template\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"33\";s:9:\"installed\";b:0;}i:396;a:28:{s:2:\"id\";s:3:\"432\";s:5:\"title\";s:13:\"Rockable Menu\";s:5:\"alias\";s:13:\"rockable-menu\";s:3:\"zip\";s:23:\"packs/rockable-menu.zip\";s:3:\"uid\";s:32:\"92d18f7ff38f22ff411a4ef4d9f54934\";s:3:\"img\";s:24:\"rockable-menu/slide1.jpg\";s:7:\"preview\";s:154:\"https://revolution.themepunch.com/rockable-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=rockable-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:172:\"<span class=\"ttm_content\">The Rockable Website Template can present your Festival or Concert oriented website in a unique one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Rockable Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"34\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:397;a:28:{s:2:\"id\";s:3:\"433\";s:5:\"title\";s:13:\"Rockable Hero\";s:5:\"alias\";s:13:\"rockable-hero\";s:3:\"zip\";s:23:\"packs/rockable-hero.zip\";s:3:\"uid\";s:32:\"ba16b28d6bde95910cbce572bb251208\";s:3:\"img\";s:24:\"rockable-hero/slide1.jpg\";s:7:\"preview\";s:154:\"https://revolution.themepunch.com/rockable-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=rockable-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:172:\"<span class=\"ttm_content\">The Rockable Website Template can present your Festival or Concert oriented website in a unique one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Rockable Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"34\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:398;a:28:{s:2:\"id\";s:3:\"434\";s:5:\"title\";s:15:\"Rockable Lineup\";s:5:\"alias\";s:15:\"rockable-lineup\";s:3:\"zip\";s:25:\"packs/rockable-lineup.zip\";s:3:\"uid\";s:32:\"6631980112805533a0d328c37e56adbd\";s:3:\"img\";s:26:\"rockable-lineup/slide1.jpg\";s:7:\"preview\";s:154:\"https://revolution.themepunch.com/rockable-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=rockable-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:172:\"<span class=\"ttm_content\">The Rockable Website Template can present your Festival or Concert oriented website in a unique one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Rockable Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"34\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:399;a:28:{s:2:\"id\";s:3:\"435\";s:5:\"title\";s:17:\"Rockable Lineup 2\";s:5:\"alias\";s:17:\"rockable-lineup-2\";s:3:\"zip\";s:27:\"packs/rockable-lineup-2.zip\";s:3:\"uid\";s:32:\"98bc41d982dc478edabff4aa99461dbc\";s:3:\"img\";s:28:\"rockable-lineup-2/slide1.jpg\";s:7:\"preview\";s:154:\"https://revolution.themepunch.com/rockable-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=rockable-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:172:\"<span class=\"ttm_content\">The Rockable Website Template can present your Festival or Concert oriented website in a unique one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Rockable Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"34\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:400;a:28:{s:2:\"id\";s:3:\"436\";s:5:\"title\";s:22:\"Rockable Gallery Title\";s:5:\"alias\";s:22:\"rockable-gallery-title\";s:3:\"zip\";s:32:\"packs/rockable-gallery-title.zip\";s:3:\"uid\";s:32:\"da43a76f5bc77aa6efe158b00ab7cf0d\";s:3:\"img\";s:33:\"rockable-gallery-title/slide1.jpg\";s:7:\"preview\";s:154:\"https://revolution.themepunch.com/rockable-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=rockable-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:172:\"<span class=\"ttm_content\">The Rockable Website Template can present your Festival or Concert oriented website in a unique one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Rockable Website Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"34\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:401;a:28:{s:2:\"id\";s:3:\"437\";s:5:\"title\";s:16:\"Rockable Gallery\";s:5:\"alias\";s:16:\"rockable-gallery\";s:3:\"zip\";s:26:\"packs/rockable-gallery.zip\";s:3:\"uid\";s:32:\"c12a144d6860bcf24e91d5b980ac22f1\";s:3:\"img\";s:27:\"rockable-gallery/slide1.jpg\";s:7:\"preview\";s:154:\"https://revolution.themepunch.com/rockable-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=rockable-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:172:\"<span class=\"ttm_content\">The Rockable Website Template can present your Festival or Concert oriented website in a unique one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:8:\"carousel\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Rockable Website Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"34\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:402;a:28:{s:2:\"id\";s:3:\"438\";s:5:\"title\";s:17:\"Rockable Sponsors\";s:5:\"alias\";s:17:\"rockable-sponsors\";s:3:\"zip\";s:27:\"packs/rockable-sponsors.zip\";s:3:\"uid\";s:32:\"1e40d4a810c23f8d5fe5cd5ca31ee20d\";s:3:\"img\";s:28:\"rockable-sponsors/slide1.jpg\";s:7:\"preview\";s:154:\"https://revolution.themepunch.com/rockable-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=rockable-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:172:\"<span class=\"ttm_content\">The Rockable Website Template can present your Festival or Concert oriented website in a unique one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Rockable Website Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"34\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:403;a:28:{s:2:\"id\";s:3:\"439\";s:5:\"title\";s:15:\"Rockable Footer\";s:5:\"alias\";s:15:\"rockable-footer\";s:3:\"zip\";s:25:\"packs/rockable-footer.zip\";s:3:\"uid\";s:32:\"a4a9952d5e56fc14366155e8ebfa432a\";s:3:\"img\";s:26:\"rockable-footer/slide1.jpg\";s:7:\"preview\";s:154:\"https://revolution.themepunch.com/rockable-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=rockable-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:172:\"<span class=\"ttm_content\">The Rockable Website Template can present your Festival or Concert oriented website in a unique one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Rockable Website Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"34\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:404;a:28:{s:2:\"id\";s:3:\"440\";s:5:\"title\";s:21:\"Rockable Detail Modal\";s:5:\"alias\";s:21:\"rockable-detail-modal\";s:3:\"zip\";s:31:\"packs/rockable-detail-modal.zip\";s:3:\"uid\";s:32:\"b51d918203ff7975a144a9f1be09f31b\";s:3:\"img\";s:32:\"rockable-detail-modal/slide1.jpg\";s:7:\"preview\";s:154:\"https://revolution.themepunch.com/rockable-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=rockable-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:172:\"<span class=\"ttm_content\">The Rockable Website Template can present your Festival or Concert oriented website in a unique one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Rockable Website Template\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"1\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"34\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:405;a:28:{s:2:\"id\";s:3:\"441\";s:5:\"title\";s:23:\"Rockable Detail Modal 2\";s:5:\"alias\";s:23:\"rockable-detail-modal-2\";s:3:\"zip\";s:33:\"packs/rockable-detail-modal-2.zip\";s:3:\"uid\";s:32:\"dcf51ebb3d4a1dec94748a1e016c5ef7\";s:3:\"img\";s:34:\"rockable-detail-modal-2/slide1.jpg\";s:7:\"preview\";s:154:\"https://revolution.themepunch.com/rockable-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=rockable-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:172:\"<span class=\"ttm_content\">The Rockable Website Template can present your Festival or Concert oriented website in a unique one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Rockable Website Template\";s:13:\"package_order\";s:2:\"10\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"1\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"34\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:407;a:25:{s:2:\"id\";s:3:\"443\";s:5:\"title\";s:16:\"Isometric Slider\";s:5:\"alias\";s:16:\"isometric-slider\";s:3:\"zip\";s:20:\"isometric-slider.zip\";s:3:\"uid\";s:32:\"fb06051fcf6649a44f2292044e414a36\";s:3:\"img\";s:27:\"isometric-slider/slide1.jpg\";s:7:\"preview\";s:136:\"https://revolution.themepunch.com/isometric-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=isometric-slider\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:154:\"<span class=\"ttm_content\">A colorful, isometric slider template with fully customizable colors and screen content.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:409;a:27:{s:2:\"id\";s:3:\"445\";s:5:\"title\";s:17:\"E-Commerce Slider\";s:5:\"alias\";s:17:\"E-Commerce-Slider\";s:3:\"zip\";s:27:\"packs/E-Commerce-Slider.zip\";s:3:\"uid\";s:32:\"1533cfd83c2ae122f23074e1ed77f256\";s:3:\"img\";s:28:\"E-Commerce-Slider/slide1.jpg\";s:7:\"preview\";s:142:\"https://revolution.themepunch.com/woo-commerce-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=woo-commerce-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:178:\"<span class=\"ttm_content\">A uniquely animated Woo Commerce Slider template - this is the static version that doesn\'t use Woo Commerce data</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:4:\"hero\";i:1;s:7:\"website\";i:2;s:11:\"woocommerce\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:26:\"Woo Commerce Slider Static\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"35\";s:9:\"installed\";b:0;}i:410;a:27:{s:2:\"id\";s:3:\"446\";s:5:\"title\";s:23:\"E-Commerce Slider Modal\";s:5:\"alias\";s:23:\"E-Commerce-Slider-Modal\";s:3:\"zip\";s:33:\"packs/E-Commerce-Slider-Modal.zip\";s:3:\"uid\";s:32:\"825e05c3967515b92a75da017c68a863\";s:3:\"img\";s:34:\"E-Commerce-Slider-Modal/slide1.jpg\";s:7:\"preview\";s:142:\"https://revolution.themepunch.com/woo-commerce-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=woo-commerce-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:178:\"<span class=\"ttm_content\">A uniquely animated Woo Commerce Slider template - this is the static version that doesn\'t use Woo Commerce data</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:4:\"hero\";i:1;s:7:\"website\";i:2;s:11:\"woocommerce\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:26:\"Woo Commerce Slider Static\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"1\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"35\";s:9:\"installed\";b:0;}i:411;a:24:{s:2:\"id\";s:3:\"447\";s:5:\"title\";s:27:\"Woo Commerce Slider Dynamic\";s:5:\"alias\";s:27:\"Woo-Commerce-Slider-Dynamic\";s:3:\"zip\";s:31:\"Woo-Commerce-Slider-Dynamic.zip\";s:3:\"uid\";s:32:\"b8e2c64f3739e552c563c48c59f20fe7\";s:3:\"img\";s:38:\"Woo-Commerce-Slider-Dynamic/slide1.jpg\";s:7:\"preview\";s:151:\"https://www.sliderrevolution.com/templates/woo-commerce-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=woo-commerce-slider\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:172:\"<span class=\"ttm_content\">A uniquely animated Woo Commerce Slider template - this is the dynamic version that uses Woo Commerce data</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"woocommerce\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:413;a:28:{s:2:\"id\";s:3:\"449\";s:5:\"title\";s:15:\"Blooming Header\";s:5:\"alias\";s:15:\"blooming-header\";s:3:\"zip\";s:25:\"packs/blooming-header.zip\";s:3:\"uid\";s:32:\"aa2ee34fd8ed018945ba64e6913810e4\";s:3:\"img\";s:26:\"blooming-header/slide1.jpg\";s:7:\"preview\";s:148:\"https://revolution.themepunch.com/event-florist-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=event-florist-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.4.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Blooming Event Florist Template is a complete one-page website solution with beautiful floral animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Blooming Event Florist Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"36\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:414;a:27:{s:2:\"id\";s:3:\"450\";s:5:\"title\";s:14:\"Blooming About\";s:5:\"alias\";s:14:\"blooming-about\";s:3:\"zip\";s:24:\"packs/blooming-about.zip\";s:3:\"uid\";s:32:\"dd7095e46fab2eb475d00480fd17a6ec\";s:3:\"img\";s:25:\"blooming-about/slide1.jpg\";s:7:\"preview\";s:148:\"https://revolution.themepunch.com/event-florist-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=event-florist-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Blooming Event Florist Template is a complete one-page website solution with beautiful floral animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Blooming Event Florist Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"36\";s:9:\"installed\";b:0;}i:415;a:27:{s:2:\"id\";s:3:\"451\";s:5:\"title\";s:18:\"Blooming Portfolio\";s:5:\"alias\";s:18:\"blooming-portfolio\";s:3:\"zip\";s:28:\"packs/blooming-portfolio.zip\";s:3:\"uid\";s:32:\"c72ddcbb07b62982b8c21328a6383e22\";s:3:\"img\";s:29:\"blooming-portfolio/slide1.jpg\";s:7:\"preview\";s:148:\"https://revolution.themepunch.com/event-florist-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=event-florist-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Blooming Event Florist Template is a complete one-page website solution with beautiful floral animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Blooming Event Florist Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"36\";s:9:\"installed\";b:0;}i:416;a:27:{s:2:\"id\";s:3:\"452\";s:5:\"title\";s:22:\"Blooming Wedding Title\";s:5:\"alias\";s:22:\"blooming-wedding-title\";s:3:\"zip\";s:32:\"packs/blooming-wedding-title.zip\";s:3:\"uid\";s:32:\"4fcfb0b99289c12d014c67306bb7687b\";s:3:\"img\";s:33:\"blooming-wedding-title/slide1.jpg\";s:7:\"preview\";s:148:\"https://revolution.themepunch.com/event-florist-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=event-florist-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Blooming Event Florist Template is a complete one-page website solution with beautiful floral animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Blooming Event Florist Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"36\";s:9:\"installed\";b:0;}i:417;a:27:{s:2:\"id\";s:3:\"453\";s:5:\"title\";s:25:\"Blooming Wedding Carousel\";s:5:\"alias\";s:25:\"blooming-wedding-carousel\";s:3:\"zip\";s:35:\"packs/blooming-wedding-carousel.zip\";s:3:\"uid\";s:32:\"1d1bb979dbfca8ba9d43da1c0f665339\";s:3:\"img\";s:36:\"blooming-wedding-carousel/slide1.jpg\";s:7:\"preview\";s:148:\"https://revolution.themepunch.com/event-florist-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=event-florist-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Blooming Event Florist Template is a complete one-page website solution with beautiful floral animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:8:\"carousel\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Blooming Event Florist Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"36\";s:9:\"installed\";b:0;}i:418;a:27:{s:2:\"id\";s:3:\"454\";s:5:\"title\";s:21:\"Blooming Wedding Text\";s:5:\"alias\";s:21:\"blooming-wedding-text\";s:3:\"zip\";s:31:\"packs/blooming-wedding-text.zip\";s:3:\"uid\";s:32:\"326f2793294a739dd3aac3cc45332df8\";s:3:\"img\";s:32:\"blooming-wedding-text/slide1.jpg\";s:7:\"preview\";s:148:\"https://revolution.themepunch.com/event-florist-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=event-florist-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Blooming Event Florist Template is a complete one-page website solution with beautiful floral animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Blooming Event Florist Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"36\";s:9:\"installed\";b:0;}i:419;a:27:{s:2:\"id\";s:3:\"455\";s:5:\"title\";s:22:\"Blooming Parties Title\";s:5:\"alias\";s:22:\"blooming-parties-title\";s:3:\"zip\";s:32:\"packs/blooming-parties-title.zip\";s:3:\"uid\";s:32:\"b47aae1b368d3c3d9017f260e6c6a547\";s:3:\"img\";s:33:\"blooming-parties-title/slide1.jpg\";s:7:\"preview\";s:148:\"https://revolution.themepunch.com/event-florist-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=event-florist-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Blooming Event Florist Template is a complete one-page website solution with beautiful floral animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Blooming Event Florist Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"36\";s:9:\"installed\";b:0;}i:420;a:27:{s:2:\"id\";s:3:\"456\";s:5:\"title\";s:25:\"Blooming Parties Carousel\";s:5:\"alias\";s:25:\"blooming-parties-carousel\";s:3:\"zip\";s:35:\"packs/blooming-parties-carousel.zip\";s:3:\"uid\";s:32:\"9f90a9da7b017aeee7f3b608cda066e6\";s:3:\"img\";s:36:\"blooming-parties-carousel/slide1.jpg\";s:7:\"preview\";s:148:\"https://revolution.themepunch.com/event-florist-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=event-florist-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Blooming Event Florist Template is a complete one-page website solution with beautiful floral animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:8:\"carousel\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Blooming Event Florist Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"36\";s:9:\"installed\";b:0;}i:421;a:27:{s:2:\"id\";s:3:\"457\";s:5:\"title\";s:21:\"Blooming Parties Text\";s:5:\"alias\";s:21:\"blooming-parties-text\";s:3:\"zip\";s:31:\"packs/blooming-parties-text.zip\";s:3:\"uid\";s:32:\"66a47346cc639b8b9b9b5dfa1521b6ef\";s:3:\"img\";s:32:\"blooming-parties-text/slide1.jpg\";s:7:\"preview\";s:148:\"https://revolution.themepunch.com/event-florist-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=event-florist-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Blooming Event Florist Template is a complete one-page website solution with beautiful floral animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Blooming Event Florist Template\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"36\";s:9:\"installed\";b:0;}i:422;a:27:{s:2:\"id\";s:3:\"458\";s:5:\"title\";s:22:\"Blooming Funeral Title\";s:5:\"alias\";s:22:\"blooming-funeral-title\";s:3:\"zip\";s:32:\"packs/blooming-funeral-title.zip\";s:3:\"uid\";s:32:\"e9e77134472c33c56be442073f29d1fd\";s:3:\"img\";s:33:\"blooming-funeral-title/slide1.jpg\";s:7:\"preview\";s:148:\"https://revolution.themepunch.com/event-florist-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=event-florist-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Blooming Event Florist Template is a complete one-page website solution with beautiful floral animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Blooming Event Florist Template\";s:13:\"package_order\";s:2:\"10\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"36\";s:9:\"installed\";b:0;}i:423;a:27:{s:2:\"id\";s:3:\"459\";s:5:\"title\";s:23:\"Blooming Funeral Slider\";s:5:\"alias\";s:23:\"blooming-funeral-slider\";s:3:\"zip\";s:33:\"packs/blooming-funeral-slider.zip\";s:3:\"uid\";s:32:\"d15090841c25c7c8f0e1b0987c0c0887\";s:3:\"img\";s:34:\"blooming-funeral-slider/slide1.jpg\";s:7:\"preview\";s:148:\"https://revolution.themepunch.com/event-florist-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=event-florist-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Blooming Event Florist Template is a complete one-page website solution with beautiful floral animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Blooming Event Florist Template\";s:13:\"package_order\";s:2:\"11\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"36\";s:9:\"installed\";b:0;}i:424;a:27:{s:2:\"id\";s:3:\"460\";s:5:\"title\";s:21:\"Blooming Funeral Text\";s:5:\"alias\";s:21:\"blooming-funeral-text\";s:3:\"zip\";s:31:\"packs/blooming-funeral-text.zip\";s:3:\"uid\";s:32:\"d7c80e246f31e3d2f4e5dc1656f133cc\";s:3:\"img\";s:32:\"blooming-funeral-text/slide1.jpg\";s:7:\"preview\";s:148:\"https://revolution.themepunch.com/event-florist-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=event-florist-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Blooming Event Florist Template is a complete one-page website solution with beautiful floral animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Blooming Event Florist Template\";s:13:\"package_order\";s:2:\"12\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"36\";s:9:\"installed\";b:0;}i:425;a:27:{s:2:\"id\";s:3:\"461\";s:5:\"title\";s:16:\"Blooming Contact\";s:5:\"alias\";s:16:\"blooming-contact\";s:3:\"zip\";s:26:\"packs/blooming-contact.zip\";s:3:\"uid\";s:32:\"54280182bca86443e2648b3146f41e47\";s:3:\"img\";s:27:\"blooming-contact/slide1.jpg\";s:7:\"preview\";s:148:\"https://revolution.themepunch.com/event-florist-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=event-florist-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Blooming Event Florist Template is a complete one-page website solution with beautiful floral animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Blooming Event Florist Template\";s:13:\"package_order\";s:2:\"13\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"36\";s:9:\"installed\";b:0;}i:426;a:24:{s:2:\"id\";s:3:\"462\";s:5:\"title\";s:13:\"Particle Hero\";s:5:\"alias\";s:13:\"particle-hero\";s:3:\"zip\";s:17:\"particle-hero.zip\";s:3:\"uid\";s:32:\"3f422f4807bf9ef4cb15dade515dad00\";s:3:\"img\";s:24:\"particle-hero/slide1.jpg\";s:7:\"preview\";s:145:\"https://revolution.themepunch.com/wordpress-hero-image-header/#slide6?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=#slide6\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:120:\"<span class=\"ttm_content\">A Hero header module using the Particle Effect Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:427;a:24:{s:2:\"id\";s:3:\"463\";s:5:\"title\";s:17:\"Bubble Morph Hero\";s:5:\"alias\";s:17:\"bubble-morph-hero\";s:3:\"zip\";s:21:\"bubble-morph-hero.zip\";s:3:\"uid\";s:32:\"b47e6bcc1ae80393ff3f7388ed3b9f8f\";s:3:\"img\";s:28:\"bubble-morph-hero/slide1.jpg\";s:7:\"preview\";s:145:\"https://revolution.themepunch.com/wordpress-hero-image-header/#slide5?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=#slide5\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:117:\"<span class=\"ttm_content\">A Hero header module using the Bubble Morph Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:428;a:24:{s:2:\"id\";s:3:\"464\";s:5:\"title\";s:13:\"Parallax Hero\";s:5:\"alias\";s:13:\"parallax-hero\";s:3:\"zip\";s:17:\"parallax-hero.zip\";s:3:\"uid\";s:32:\"290e86534326ee118e96ae7ce0538fa2\";s:3:\"img\";s:24:\"parallax-hero/slide1.jpg\";s:7:\"preview\";s:145:\"https://revolution.themepunch.com/wordpress-hero-image-header/#slide4?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=#slide4\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:117:\"<span class=\"ttm_content\">A parallax hero module with mouse move interaction.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:429;a:24:{s:2:\"id\";s:3:\"465\";s:5:\"title\";s:10:\"Video Hero\";s:5:\"alias\";s:10:\"video-hero\";s:3:\"zip\";s:14:\"video-hero.zip\";s:3:\"uid\";s:32:\"f9e280015d3408bb0482e13fe753da8f\";s:3:\"img\";s:21:\"video-hero/slide1.jpg\";s:7:\"preview\";s:145:\"https://revolution.themepunch.com/wordpress-hero-image-header/#slide3?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=#slide3\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:111:\"<span class=\"ttm_content\">A simple Hero header module with HTML5 video.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:430;a:24:{s:2:\"id\";s:3:\"466\";s:5:\"title\";s:14:\"Ken Burns Hero\";s:5:\"alias\";s:14:\"ken-burns-hero\";s:3:\"zip\";s:18:\"ken-burns-hero.zip\";s:3:\"uid\";s:32:\"d5f89e5f5b3991b995e2bfeb50cfe9f8\";s:3:\"img\";s:25:\"ken-burns-hero/slide1.jpg\";s:7:\"preview\";s:145:\"https://revolution.themepunch.com/wordpress-hero-image-header/#slide2?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=#slide2\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:142:\"<span class=\"ttm_content\">A simple image background hero header module with a subtle Ken Burns effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:431;a:24:{s:2:\"id\";s:3:\"467\";s:5:\"title\";s:21:\"Basic Hero Collection\";s:5:\"alias\";s:21:\"basic-hero-collection\";s:3:\"zip\";s:25:\"basic-hero-collection.zip\";s:3:\"uid\";s:32:\"ff625c65e8aab4689fa56d5652279d51\";s:3:\"img\";s:32:\"basic-hero-collection/slide1.jpg\";s:7:\"preview\";s:158:\"https://revolution.themepunch.com/wordpress-hero-image-header/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-hero-image-header\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:153:\"<span class=\"ttm_content\">A collection of WordPress Hero Headers with image, video, particles, parallax and more!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:348:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"},{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:432;a:24:{s:2:\"id\";s:3:\"468\";s:5:\"title\";s:19:\"Launching Very Soon\";s:5:\"alias\";s:19:\"launching-very-soon\";s:3:\"zip\";s:23:\"launching-very-soon.zip\";s:3:\"uid\";s:32:\"2da45cf2d9bec07e7183b3f7777986b9\";s:3:\"img\";s:30:\"launching-very-soon/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/launching-soon-countdown/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=launching-soon-countdown\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:166:\"<span class=\"ttm_content\">Rocket BOOST! A beautifully animated launching soon countdown module using our \"Coming Soon\" Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:197:\"[{\"path\":\"revslider-maintenance-addon\\/revslider-maintenance-addon.php\",\"name\":\"Coming Soon & Maintenance AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/add-coming-soon-maintenance\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:433;a:24:{s:2:\"id\";s:3:\"469\";s:5:\"title\";s:18:\"Under Construction\";s:5:\"alias\";s:18:\"Under-Construction\";s:3:\"zip\";s:22:\"Under-Construction.zip\";s:3:\"uid\";s:32:\"4b12f9a82a5b48d45a707df93406eb5b\";s:3:\"img\";s:29:\"Under-Construction/slide1.jpg\";s:7:\"preview\";s:140:\"https://revolution.themepunch.com/under-construction/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=under-construction\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You will love this animated under construction landing page using our \"Coming Soon\" Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:197:\"[{\"path\":\"revslider-maintenance-addon\\/revslider-maintenance-addon.php\",\"name\":\"Coming Soon & Maintenance AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/add-coming-soon-maintenance\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:88:\"Create an Under Construction Page That’ll Entertain Visitors While You Work [Tutorial]\";s:9:\"guide_url\";s:121:\"https://www.sliderrevolution.com/tutorials/create-an-under-construction-page-that-will-entertain-visitors-while-you-work/\";s:9:\"guide_img\";s:31:\"tutorial/Under-Construction.jpg\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:434;a:24:{s:2:\"id\";s:3:\"470\";s:5:\"title\";s:15:\"Particle Effect\";s:5:\"alias\";s:15:\"Particle-Effect\";s:3:\"zip\";s:19:\"Particle-Effect.zip\";s:3:\"uid\";s:32:\"66cf4e514e83a6984903694fd587edb6\";s:3:\"img\";s:26:\"Particle-Effect/slide1.jpg\";s:7:\"preview\";s:142:\"https://revolution.themepunch.com/snow-particle-scene/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=snow-particle-scene\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:140:\"<span class=\"ttm_content\">Get into a winter mood with our Snow Particle Scene for Slider Revolution!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:435;a:24:{s:2:\"id\";s:3:\"471\";s:5:\"title\";s:17:\"Particle Effect 2\";s:5:\"alias\";s:17:\"Particle-Effect-2\";s:3:\"zip\";s:21:\"Particle-Effect-2.zip\";s:3:\"uid\";s:32:\"303337c29a97a816ccecca7e5f0b5e20\";s:3:\"img\";s:28:\"Particle-Effect-2/slide1.jpg\";s:7:\"preview\";s:146:\"https://revolution.themepunch.com/cyber-particle-effect/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=cyber-particle-effect\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:147:\"<span class=\"ttm_content\">Amaze your website visitors with the cyber particle effect for Slider Revolution!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:69:\"How to Create a Retro-Inspired Design for the Hero Section [Tutorial]\";s:9:\"guide_url\";s:102:\"https://www.sliderrevolution.com/tutorials/how-to-create-a-retro-inspired-design-for-the-hero-section/\";s:9:\"guide_img\";s:30:\"tutorial/Particle-Effect-2.png\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:437;a:27:{s:2:\"id\";s:3:\"473\";s:5:\"title\";s:10:\"Stark Menu\";s:5:\"alias\";s:10:\"stark-menu\";s:3:\"zip\";s:20:\"packs/stark-menu.zip\";s:3:\"uid\";s:32:\"bb31150df180e784d76a1f5ea306bf05\";s:3:\"img\";s:21:\"stark-menu/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/stark-agency-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=stark-agency-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:221:\"<span class=\"ttm_content\">The Stark Agency website template is a collection of modules using our new Gutenberg Block \"margin & padding\" feature. Create unique, customizable layouts!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Stark Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:87:\"offset=\"t:0px,0px,0px,0px;b:0px,0px,0px,0px;l:140px,70px,0px,0px;r:140px,70px,0px,0px;\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"37\";s:9:\"installed\";b:0;}i:438;a:27:{s:2:\"id\";s:3:\"474\";s:5:\"title\";s:12:\"Stark Header\";s:5:\"alias\";s:12:\"stark-header\";s:3:\"zip\";s:22:\"packs/stark-header.zip\";s:3:\"uid\";s:32:\"62bfca01bf6e33cfad81d8df06498299\";s:3:\"img\";s:23:\"stark-header/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/stark-agency-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=stark-agency-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:221:\"<span class=\"ttm_content\">The Stark Agency website template is a collection of modules using our new Gutenberg Block \"margin & padding\" feature. Create unique, customizable layouts!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Stark Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:93:\"offset=\"t:40px,30px,20px,10px;b:0px,0px,0px,0px;l:40px,30px,20px,10px;r:40px,30px,20px,10px;\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"37\";s:9:\"installed\";b:0;}i:439;a:28:{s:2:\"id\";s:3:\"475\";s:5:\"title\";s:13:\"Stark Content\";s:5:\"alias\";s:13:\"stark-content\";s:3:\"zip\";s:23:\"packs/stark-content.zip\";s:3:\"uid\";s:32:\"4577ca760133eb5d894c46f212f6eefb\";s:3:\"img\";s:24:\"stark-content/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/stark-agency-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=stark-agency-website-template\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:6:\"6.2.22\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:221:\"<span class=\"ttm_content\">The Stark Agency website template is a collection of modules using our new Gutenberg Block \"margin & padding\" feature. Create unique, customizable layouts!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Stark Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:110:\"offset=\"t:-50px,-30px,-30px,-20px;b:0px,0px,0px,0px;l:140px,70px,50px,30px;r:140px,70px,50px,30px;\" zindex=\"6\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"37\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:440;a:27:{s:2:\"id\";s:3:\"476\";s:5:\"title\";s:14:\"Stark Carousel\";s:5:\"alias\";s:14:\"stark-carousel\";s:3:\"zip\";s:24:\"packs/stark-carousel.zip\";s:3:\"uid\";s:32:\"de63336d333eeff10eccfd5d9741e6c9\";s:3:\"img\";s:25:\"stark-carousel/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/stark-agency-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=stark-agency-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:221:\"<span class=\"ttm_content\">The Stark Agency website template is a collection of modules using our new Gutenberg Block \"margin & padding\" feature. Create unique, customizable layouts!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Stark Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:108:\"offset=\"t:-50px,-30px,-30px,-20px;b:0px,0px,0px,0px;l:40px,30px,20px,10px;r:40px,30px,20px,10px;\" zindex=\"1\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"37\";s:9:\"installed\";b:0;}i:441;a:28:{s:2:\"id\";s:3:\"477\";s:5:\"title\";s:15:\"Stark Portfolio\";s:5:\"alias\";s:15:\"stark-portfolio\";s:3:\"zip\";s:25:\"packs/stark-portfolio.zip\";s:3:\"uid\";s:32:\"99fcf3df65f8471fe30bec1bf0c2350d\";s:3:\"img\";s:26:\"stark-portfolio/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/stark-agency-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=stark-agency-website-template\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:6:\"6.2.22\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:221:\"<span class=\"ttm_content\">The Stark Agency website template is a collection of modules using our new Gutenberg Block \"margin & padding\" feature. Create unique, customizable layouts!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Stark Website Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:110:\"offset=\"t:-50px,-30px,-30px,-20px;b:0px,0px,0px,0px;l:140px,70px,50px,30px;r:140px,70px,50px,30px;\" zindex=\"5\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"37\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:442;a:27:{s:2:\"id\";s:3:\"478\";s:5:\"title\";s:22:\"Stark Portfolio Detail\";s:5:\"alias\";s:22:\"stark-portfolio-detail\";s:3:\"zip\";s:32:\"packs/stark-portfolio-detail.zip\";s:3:\"uid\";s:32:\"7484fc54f81daec07c93e992216310ce\";s:3:\"img\";s:33:\"stark-portfolio-detail/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/stark-agency-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=stark-agency-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:221:\"<span class=\"ttm_content\">The Stark Agency website template is a collection of modules using our new Gutenberg Block \"margin & padding\" feature. Create unique, customizable layouts!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Stark Website Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"1\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"37\";s:9:\"installed\";b:0;}i:443;a:27:{s:2:\"id\";s:3:\"479\";s:5:\"title\";s:13:\"Stark Contact\";s:5:\"alias\";s:13:\"stark-contact\";s:3:\"zip\";s:23:\"packs/stark-contact.zip\";s:3:\"uid\";s:32:\"8d704226b7093123a9d9faf424da6c35\";s:3:\"img\";s:24:\"stark-contact/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/stark-agency-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=stark-agency-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:221:\"<span class=\"ttm_content\">The Stark Agency website template is a collection of modules using our new Gutenberg Block \"margin & padding\" feature. Create unique, customizable layouts!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Stark Website Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:108:\"offset=\"t:-50px,-30px,-30px,-20px;b:0px,0px,0px,0px;l:40px,30px,20px,10px;r:40px,30px,20px,10px;\" zindex=\"2\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"37\";s:9:\"installed\";b:0;}i:444;a:28:{s:2:\"id\";s:3:\"480\";s:5:\"title\";s:12:\"Stark Footer\";s:5:\"alias\";s:12:\"stark-footer\";s:3:\"zip\";s:22:\"packs/stark-footer.zip\";s:3:\"uid\";s:32:\"e7132dc158e7dcdb4ef5b3a1aa00208a\";s:3:\"img\";s:23:\"stark-footer/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/stark-agency-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=stark-agency-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:6:\"6.2.22\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:221:\"<span class=\"ttm_content\">The Stark Agency website template is a collection of modules using our new Gutenberg Block \"margin & padding\" feature. Create unique, customizable layouts!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Stark Website Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:114:\"offset=\"t:-50px,-30px,-30px,-20px;b:40px,30px,20px,20px;l:140px,70px,50px,30px;r:140px,70px,50px,30px;\" zindex=\"3\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"37\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:445;a:27:{s:2:\"id\";s:3:\"481\";s:5:\"title\";s:16:\"Stark Newsletter\";s:5:\"alias\";s:16:\"stark-newsletter\";s:3:\"zip\";s:26:\"packs/stark-newsletter.zip\";s:3:\"uid\";s:32:\"bb76ddd68dbe6bda5ece7e4227a51413\";s:3:\"img\";s:27:\"stark-newsletter/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/stark-agency-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=stark-agency-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:221:\"<span class=\"ttm_content\">The Stark Agency website template is a collection of modules using our new Gutenberg Block \"margin & padding\" feature. Create unique, customizable layouts!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Stark Website Template\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"1\";s:9:\"additions\";s:33:\"usage=\"modal\" modal=\"s:#contact;\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"37\";s:9:\"installed\";b:0;}i:446;a:24:{s:2:\"id\";s:3:\"482\";s:5:\"title\";s:15:\"Big Summer Sale\";s:5:\"alias\";s:15:\"big-summer-sale\";s:3:\"zip\";s:19:\"big-summer-sale.zip\";s:3:\"uid\";s:32:\"a6779fa7109763209d234f9cf2e766c6\";s:3:\"img\";s:26:\"big-summer-sale/slide1.jpg\";s:7:\"preview\";s:158:\"https://revolution.themepunch.com/big-summer-sale-shop-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=big-summer-sale-shop-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:153:\"<span class=\"ttm_content\">The Big Summer Sale Shop Slider is a beautiful eye catcher for your e-commerce website!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:60:\"How to Add an Animated Headline to Your Home Page [Tutorial]\";s:9:\"guide_url\";s:102:\"https://www.sliderrevolution.com/tutorials/how-to-add-an-animated-headline-to-your-home-page-tutorial/\";s:9:\"guide_img\";s:28:\"tutorial/big-summer-sale.jpg\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:447;a:26:{s:2:\"id\";s:3:\"483\";s:5:\"title\";s:18:\"Traveller Carousel\";s:5:\"alias\";s:18:\"traveller-carousel\";s:3:\"zip\";s:22:\"traveller-carousel.zip\";s:3:\"uid\";s:32:\"185344ed6236bea2906a79035d1d5702\";s:3:\"img\";s:29:\"traveller-carousel/slide1.jpg\";s:7:\"preview\";s:144:\"https://revolution.themepunch.com/travel-blog-carousel/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=travel-blog-carousel\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.4.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:137:\"<span class=\"ttm_content\">A travel blog carousel with interesting parallax and ken burns effects!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:263:\"<span class=\"ttm_content\">Note that the content visible on all slides can be edited on the \"global layers\" slide.<br/>Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:74:\"How to Create an Engaging Product Carousel for Your Online Shop [Tutorial]\";s:9:\"guide_url\";s:107:\"https://www.sliderrevolution.com/tutorials/how-to-create-an-engaging-product-carousel-for-your-online-shop/\";s:9:\"guide_img\";s:31:\"tutorial/traveller-carousel.png\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:448;a:24:{s:2:\"id\";s:3:\"484\";s:5:\"title\";s:16:\"Project Carousel\";s:5:\"alias\";s:16:\"project-carousel\";s:3:\"zip\";s:20:\"project-carousel.zip\";s:3:\"uid\";s:32:\"49c85ad406da943bdd25f08fd6496748\";s:3:\"img\";s:27:\"project-carousel/slide1.jpg\";s:7:\"preview\";s:136:\"https://revolution.themepunch.com/project-carousel/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=project-carousel\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:137:\"<span class=\"ttm_content\">A project carousel with images and texts that can be customized easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:449;a:24:{s:2:\"id\";s:3:\"485\";s:5:\"title\";s:13:\"News Carousel\";s:5:\"alias\";s:13:\"news-carousel\";s:3:\"zip\";s:17:\"news-carousel.zip\";s:3:\"uid\";s:32:\"76f5b939150092a30038f161084140ae\";s:3:\"img\";s:24:\"news-carousel/slide1.jpg\";s:7:\"preview\";s:130:\"https://revolution.themepunch.com/news-carousel/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=news-carousel\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:134:\"<span class=\"ttm_content\">A news carousel with images and texts that can be customized easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:451;a:28:{s:2:\"id\";s:3:\"487\";s:5:\"title\";s:10:\"Story Menu\";s:5:\"alias\";s:10:\"story-menu\";s:3:\"zip\";s:20:\"packs/story-menu.zip\";s:3:\"uid\";s:32:\"1f2f7cd91480f15cff8e7100f788c650\";s:3:\"img\";s:21:\"story-menu/slide1.jpg\";s:7:\"preview\";s:128:\"https://revolution.themepunch.com/story-blocks/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=story-blocks\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:229:\"<span class=\"ttm_content\">The Story Blocks for Slider Revolution can be used to create scroll-based stories on your WordPress site. Mix and match the individual blocks to create YOUR story!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Story Blocks Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"38\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:452;a:28:{s:2:\"id\";s:3:\"488\";s:5:\"title\";s:12:\"Story Header\";s:5:\"alias\";s:12:\"story-header\";s:3:\"zip\";s:22:\"packs/story-header.zip\";s:3:\"uid\";s:32:\"e1a5ad5018a24ccdc71c2863edfe775e\";s:3:\"img\";s:23:\"story-header/slide1.jpg\";s:7:\"preview\";s:128:\"https://revolution.themepunch.com/story-blocks/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=story-blocks\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:229:\"<span class=\"ttm_content\">The Story Blocks for Slider Revolution can be used to create scroll-based stories on your WordPress site. Mix and match the individual blocks to create YOUR story!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Story Blocks Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"38\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:453;a:28:{s:2:\"id\";s:3:\"489\";s:5:\"title\";s:13:\"Story Block 1\";s:5:\"alias\";s:13:\"story-block-1\";s:3:\"zip\";s:23:\"packs/story-block-1.zip\";s:3:\"uid\";s:32:\"2a9fee97dcf477e36d048af8a902f47a\";s:3:\"img\";s:24:\"story-block-1/slide1.jpg\";s:7:\"preview\";s:128:\"https://revolution.themepunch.com/story-blocks/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=story-blocks\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:229:\"<span class=\"ttm_content\">The Story Blocks for Slider Revolution can be used to create scroll-based stories on your WordPress site. Mix and match the individual blocks to create YOUR story!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Story Blocks Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"38\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:454;a:28:{s:2:\"id\";s:3:\"490\";s:5:\"title\";s:15:\"Story Content 1\";s:5:\"alias\";s:15:\"story-content-1\";s:3:\"zip\";s:25:\"packs/story-content-1.zip\";s:3:\"uid\";s:32:\"6773614bbce543b83a0d2b2ad8facc96\";s:3:\"img\";s:26:\"story-content-1/slide1.jpg\";s:7:\"preview\";s:128:\"https://revolution.themepunch.com/story-blocks/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=story-blocks\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:229:\"<span class=\"ttm_content\">The Story Blocks for Slider Revolution can be used to create scroll-based stories on your WordPress site. Mix and match the individual blocks to create YOUR story!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Story Blocks Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"38\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:455;a:28:{s:2:\"id\";s:3:\"491\";s:5:\"title\";s:13:\"Story Block 2\";s:5:\"alias\";s:13:\"story-block-2\";s:3:\"zip\";s:23:\"packs/story-block-2.zip\";s:3:\"uid\";s:32:\"2e708e3cebab57ca20b228ffba426ce7\";s:3:\"img\";s:24:\"story-block-2/slide1.jpg\";s:7:\"preview\";s:128:\"https://revolution.themepunch.com/story-blocks/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=story-blocks\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:229:\"<span class=\"ttm_content\">The Story Blocks for Slider Revolution can be used to create scroll-based stories on your WordPress site. Mix and match the individual blocks to create YOUR story!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Story Blocks Website Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"38\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:456;a:28:{s:2:\"id\";s:3:\"492\";s:5:\"title\";s:13:\"Story Block 3\";s:5:\"alias\";s:13:\"story-block-3\";s:3:\"zip\";s:23:\"packs/story-block-3.zip\";s:3:\"uid\";s:32:\"7156cf069f65644faf90122dab451231\";s:3:\"img\";s:24:\"story-block-3/slide1.jpg\";s:7:\"preview\";s:128:\"https://revolution.themepunch.com/story-blocks/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=story-blocks\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:229:\"<span class=\"ttm_content\">The Story Blocks for Slider Revolution can be used to create scroll-based stories on your WordPress site. Mix and match the individual blocks to create YOUR story!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Story Blocks Website Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"38\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:457;a:28:{s:2:\"id\";s:3:\"493\";s:5:\"title\";s:15:\"Story Content 2\";s:5:\"alias\";s:15:\"story-content-2\";s:3:\"zip\";s:25:\"packs/story-content-2.zip\";s:3:\"uid\";s:32:\"1223cd77d1f36d69e69ce50223e16ea7\";s:3:\"img\";s:26:\"story-content-2/slide1.jpg\";s:7:\"preview\";s:128:\"https://revolution.themepunch.com/story-blocks/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=story-blocks\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:229:\"<span class=\"ttm_content\">The Story Blocks for Slider Revolution can be used to create scroll-based stories on your WordPress site. Mix and match the individual blocks to create YOUR story!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Story Blocks Website Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"38\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:458;a:28:{s:2:\"id\";s:3:\"494\";s:5:\"title\";s:13:\"Story Block 4\";s:5:\"alias\";s:13:\"story-block-4\";s:3:\"zip\";s:23:\"packs/story-block-4.zip\";s:3:\"uid\";s:32:\"85ac48e8e8231d2c38206cba4e7ebb68\";s:3:\"img\";s:24:\"story-block-4/slide1.jpg\";s:7:\"preview\";s:128:\"https://revolution.themepunch.com/story-blocks/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=story-blocks\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:229:\"<span class=\"ttm_content\">The Story Blocks for Slider Revolution can be used to create scroll-based stories on your WordPress site. Mix and match the individual blocks to create YOUR story!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Story Blocks Website Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"38\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:459;a:28:{s:2:\"id\";s:3:\"495\";s:5:\"title\";s:15:\"Story Content 3\";s:5:\"alias\";s:15:\"story-content-3\";s:3:\"zip\";s:25:\"packs/story-content-3.zip\";s:3:\"uid\";s:32:\"82cac52f3ba79c0559fe0ad0cdf9d3b2\";s:3:\"img\";s:26:\"story-content-3/slide1.jpg\";s:7:\"preview\";s:128:\"https://revolution.themepunch.com/story-blocks/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=story-blocks\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:229:\"<span class=\"ttm_content\">The Story Blocks for Slider Revolution can be used to create scroll-based stories on your WordPress site. Mix and match the individual blocks to create YOUR story!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Story Blocks Website Template\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"38\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:460;a:28:{s:2:\"id\";s:3:\"107\";s:5:\"title\";s:23:\"Minimal Website Package\";s:5:\"alias\";s:23:\"minimal-website-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:23:\"minimal-website-package\";s:3:\"img\";s:31:\"packages/template_group_1_1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/minimal-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"110\";s:11:\"description\";s:181:\"<span class=\"ttm_content\">The Minimal Website Template is a one-pager website with a unique background color change effect on scrolling down.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:462;a:28:{s:2:\"id\";s:3:\"109\";s:5:\"title\";s:26:\"Dark Content Block Package\";s:5:\"alias\";s:27:\"dark-fullsite-block-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:27:\"dark-fullsite-block-package\";s:3:\"img\";s:29:\"packages/template_group_4.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This Minimal Website Template has some sleek parallax effects and on-demand loading modules.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:463;a:28:{s:2:\"id\";s:3:\"110\";s:5:\"title\";s:27:\"Light Content Block Package\";s:5:\"alias\";s:22:\"fullsite-block-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"fullsite-block-package\";s:3:\"img\";s:29:\"packages/template_group_3.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This Minimal Website Template has some sleek parallax effects and on-demand loading modules.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:464;a:28:{s:2:\"id\";s:3:\"122\";s:5:\"title\";s:20:\"Themeplicity Package\";s:5:\"alias\";s:20:\"themeplicity-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:20:\"themeplicity-package\";s:3:\"img\";s:38:\"packages/templatepack_themeplicity.jpg\";s:7:\"preview\";s:134:\"https://revolution.themepunch.com/wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Themeplicity Website Template uses the new groups & rows feature introduced in 5.3 to its full potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:465;a:28:{s:2:\"id\";s:3:\"137\";s:5:\"title\";s:22:\"Nice And Clean Package\";s:5:\"alias\";s:22:\"nice-and-clean-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"nice-and-clean-package\";s:3:\"img\";s:38:\"packages/templatepack_niceandclean.jpg\";s:7:\"preview\";s:178:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:242:\"<span class=\"ttm_content\">The Nice & Clean Website Template uses groups & rows for a fully responsive website experience. Elegant blur effects available since version 5.3.1 make this template stand out!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:466;a:28:{s:2:\"id\";s:3:\"154\";s:5:\"title\";s:26:\"GoodNews One-Pager Package\";s:5:\"alias\";s:26:\"goodnews-one-pager-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"goodnews-one-pager-package\";s:3:\"img\";s:44:\"packages/templatepack_goodnews_one_pager.jpg\";s:7:\"preview\";s:174:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.4.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:4:{i:0;s:8:\"carousel\";i:1;s:6:\"slider\";i:2;s:4:\"hero\";i:3;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:467;a:28:{s:2:\"id\";s:3:\"163\";s:5:\"title\";s:29:\"GoodNews Content Page Package\";s:5:\"alias\";s:29:\"goodnews-content-page-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:29:\"goodnews-content-page-package\";s:3:\"img\";s:55:\"packages/templatepack_goodnews_content_page_package.jpg\";s:7:\"preview\";s:190:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme-content\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:4:\"hero\";i:2;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:468;a:28:{s:2:\"id\";s:3:\"173\";s:5:\"title\";s:24:\"TechCo One-Pager Package\";s:5:\"alias\";s:24:\"techco-one-pager-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:24:\"techco-one-pager-package\";s:3:\"img\";s:28:\"packages/techco_overview.jpg\";s:7:\"preview\";s:166:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:4:\"hero\";i:2;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:469;a:28:{s:2:\"id\";s:3:\"211\";s:5:\"title\";s:18:\"Immersion One Page\";s:5:\"alias\";s:26:\"immersion-one-page-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"immersion-one-page-package\";s:3:\"img\";s:31:\"packages/immersion_overview.jpg\";s:7:\"preview\";s:182:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=immersion-wordpress-one-page-theme-2018\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:4:\"hero\";i:2;s:7:\"website\";}s:14:\"plugin_require\";s:342:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"},{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:470;a:28:{s:2:\"id\";s:3:\"219\";s:5:\"title\";s:19:\"Clear View Magazine\";s:5:\"alias\";s:27:\"clear-view-magazine-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:27:\"clear-view-magazine-package\";s:3:\"img\";s:41:\"packages/clear_view_magazine_overview.jpg\";s:7:\"preview\";s:196:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:471;a:28:{s:2:\"id\";s:3:\"227\";s:5:\"title\";s:20:\"Clear View Post Page\";s:5:\"alias\";s:28:\"clear-view-post-page-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:28:\"clear-view-post-page-package\";s:3:\"img\";s:42:\"packages/clear_view_post_page_overview.jpg\";s:7:\"preview\";s:196:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-single-post-page-wordpress-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:472;a:28:{s:2:\"id\";s:3:\"235\";s:5:\"title\";s:22:\"Wonderstruck One-Pager\";s:5:\"alias\";s:30:\"wonderstruck-one-pager-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:30:\"wonderstruck-one-pager-package\";s:3:\"img\";s:44:\"packages/wonderstruck-one-pager-overview.jpg\";s:7:\"preview\";s:189:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:473;a:28:{s:2:\"id\";s:3:\"245\";s:5:\"title\";s:18:\"Parallax One-Pager\";s:5:\"alias\";s:26:\"parallax-one-pager-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"parallax-one-pager-package\";s:3:\"img\";s:39:\"packages/parallax-one-pager-package.jpg\";s:7:\"preview\";s:176:\"https://revolution.themepunch.com/parallax-one-page-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=parallax-one-page-wordpress-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:230:\"<span class=\"ttm_content\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Parallax One-Pager\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"14\";s:9:\"installed\";b:0;}i:474;a:28:{s:2:\"id\";s:3:\"249\";s:5:\"title\";s:18:\"Le Chef Restaurant\";s:5:\"alias\";s:18:\"le-chef-restaurant\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"le-chef-restaurant-package\";s:3:\"img\";s:39:\"packages/le-chef-restaurant-package.jpg\";s:7:\"preview\";s:194:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=le-chef-restaurant-website-wordpress-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:475;a:28:{s:2:\"id\";s:3:\"260\";s:5:\"title\";s:11:\"Barber Shop\";s:5:\"alias\";s:11:\"barber-shop\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:19:\"barber-shop-package\";s:3:\"img\";s:32:\"packages/barber-shop-package.jpg\";s:7:\"preview\";s:172:\"https://revolution.themepunch.com/barber-shop-template-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=barber-shop-template-for-wordpress\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Barber Shop\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"16\";s:9:\"installed\";b:0;}i:476;a:28:{s:2:\"id\";s:3:\"275\";s:5:\"title\";s:33:\"Medicare Medical Services Website\";s:5:\"alias\";s:33:\"medicare-medical-services-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:41:\"medicare-medical-services-website-package\";s:3:\"img\";s:29:\"packages/medicare_package.jpg\";s:7:\"preview\";s:170:\"https://revolution.themepunch.com/medicare-medical-services-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=medicare-medical-services-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:477;a:28:{s:2:\"id\";s:3:\"286\";s:5:\"title\";s:20:\"Coffee Joint Website\";s:5:\"alias\";s:20:\"coffee-joint-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:28:\"coffee-joint-website-package\";s:3:\"img\";s:27:\"packages/coffee_package.jpg\";s:7:\"preview\";s:186:\"https://revolution.themepunch.com/coffee-joint-coffee-shop-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coffee-joint-coffee-shop-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">The Coffee Joint website template is a great solution for your cafe or bistro.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Coffee Joint\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"18\";s:9:\"installed\";b:0;}i:479;a:28:{s:2:\"id\";s:3:\"297\";s:5:\"title\";s:23:\"Angled Business Website\";s:5:\"alias\";s:23:\"angled-business-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:31:\"angled-business-website-package\";s:3:\"img\";s:27:\"packages/angled_package.jpg\";s:7:\"preview\";s:168:\"https://revolution.themepunch.com/angled-business-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=angled-business-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Angled Business\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"20\";s:9:\"installed\";b:0;}i:480;a:28:{s:2:\"id\";s:3:\"314\";s:5:\"title\";s:19:\"Peak Agency Website\";s:5:\"alias\";s:19:\"peak-agency-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:27:\"peak-agency-website-package\";s:3:\"img\";s:25:\"packages/peak_package.jpg\";s:7:\"preview\";s:160:\"https://revolution.themepunch.com/peak-agency-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=peak-agency-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:129:\"<span class=\"ttm_content\">The Peak Agency Website template is a minimal, light one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Peak Agency\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"22\";s:9:\"installed\";b:0;}i:482;a:28:{s:2:\"id\";s:3:\"325\";s:5:\"title\";s:18:\"App Studio Website\";s:5:\"alias\";s:18:\"app-studio-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"app-studio-website-package\";s:3:\"img\";s:31:\"packages/App_Studio_package.jpg\";s:7:\"preview\";s:140:\"https://revolution.themepunch.com/app-studio-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=app-studio-website\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">A modern one-page presentation website to present your mobile app development team.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:10:\"App Studio\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"24\";s:9:\"installed\";b:0;}i:483;a:28:{s:2:\"id\";s:3:\"331\";s:5:\"title\";s:13:\"Basic Website\";s:5:\"alias\";s:13:\"basic-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:21:\"basic-website-package\";s:3:\"img\";s:26:\"packages/basic_package.jpg\";s:7:\"preview\";s:130:\"https://revolution.themepunch.com/basic-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=basic-website\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;}i:484;a:28:{s:2:\"id\";s:3:\"343\";s:5:\"title\";s:20:\"Construction Company\";s:5:\"alias\";s:28:\"construction-company-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:36:\"construction-company-website-package\";s:3:\"img\";s:33:\"packages/construction_package.jpg\";s:7:\"preview\";s:160:\"https://revolution.themepunch.com/construction-company-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=construction-company-website\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:244:\"<span class=\"ttm_content\">The Construction Company is the perfect introduction to your Construction themed website. Showcase your current projects, services and contact information with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Construction Company\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"26\";s:9:\"installed\";b:0;}i:485;a:28:{s:2:\"id\";s:3:\"352\";s:5:\"title\";s:12:\"Landing Page\";s:5:\"alias\";s:20:\"landing-page-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:28:\"landing-page-website-package\";s:3:\"img\";s:23:\"packages/lp_package.jpg\";s:7:\"preview\";s:144:\"https://revolution.themepunch.com/landing-page-builder/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=landing-page-builder\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.8\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:193:\"<span class=\"ttm_content\">Landing Page is a one-page website template with standard modules to build an effective landing page for your business/product.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:624:\"<span class=\"ttm_content\">After installing this template package, please remove the \"price modal\" module shortcode from the automatically created page. Also, a small modification is needed in these templates: \"Landing Page Hero\", \"Landing page Call to Action\" and \"Landing Page Footer\". Click the buttons in these template and then go to \"layer -> actions\" and set the target of the \"Open Slider Modal\" action to the \"Landing Page Price Modal\".</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Landing Page\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"27\";s:9:\"installed\";b:0;}i:486;a:27:{s:2:\"id\";s:3:\"371\";s:5:\"title\";s:17:\"Corporate Website\";s:5:\"alias\";s:17:\"corporate-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:25:\"corporate-website-package\";s:3:\"img\";s:30:\"packages/corporate-website.jpg\";s:7:\"preview\";s:156:\"https://revolution.themepunch.com/corporate-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.1\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:248:\"<span class=\"ttm_content\">The Corporate Template is a collection of useful modules to construct your website. Portfolio, news, clients, team, contact, basic content, etc. There is something for everyone here!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";s:173:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Corporate Website\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"29\";s:9:\"installed\";b:0;}i:488;a:27:{s:2:\"id\";s:3:\"411\";s:5:\"title\";s:23:\"Church Website Template\";s:5:\"alias\";s:23:\"church-website-template\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:31:\"church-website-template-package\";s:3:\"img\";s:36:\"packages/church-website-template.jpg\";s:7:\"preview\";s:160:\"https://revolution.themepunch.com/church-website-template-dark/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=church-website-template-dark\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:23:\"Church Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"32\";s:9:\"installed\";b:0;}i:489;a:27:{s:2:\"id\";s:3:\"421\";s:5:\"title\";s:29:\"Church Light Website Template\";s:5:\"alias\";s:29:\"church-light-website-template\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:37:\"church-light-website-template-package\";s:3:\"img\";s:42:\"packages/church-light-website-template.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/church-website-template-light/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=church-website-template-light\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.2\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The Church Website Template is a complete solution for the holy internet presence of your church. Available as a light and dark version.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Church Light Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"33\";s:9:\"installed\";b:0;}i:490;a:27:{s:2:\"id\";s:3:\"431\";s:5:\"title\";s:25:\"Rockable Website Template\";s:5:\"alias\";s:25:\"rockable-website-template\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:33:\"rockable-website-template-package\";s:3:\"img\";s:38:\"packages/rockable-website-template.jpg\";s:7:\"preview\";s:154:\"https://revolution.themepunch.com/rockable-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=rockable-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.3\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:172:\"<span class=\"ttm_content\">The Rockable Website Template can present your Festival or Concert oriented website in a unique one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Rockable Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"34\";s:9:\"installed\";b:0;}i:491;a:24:{s:2:\"id\";s:3:\"442\";s:5:\"title\";s:27:\"Real Estate Showcase Slider\";s:5:\"alias\";s:27:\"real-estate-showcase-slider\";s:3:\"zip\";s:31:\"real-estate-showcase-slider.zip\";s:3:\"uid\";s:32:\"486b2bbe296722e70421731e3c05711b\";s:3:\"img\";s:38:\"Real-Estate-Showcase-Slider/slide1.jpg\";s:7:\"preview\";s:158:\"https://revolution.themepunch.com/real-estate-showcase-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=real-estate-showcase-slider\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:152:\"<span class=\"ttm_content\">An elegant showcase for your real estate & realtor website. Flexible and customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:492;a:27:{s:2:\"id\";s:3:\"444\";s:5:\"title\";s:26:\"Woo Commerce Slider Static\";s:5:\"alias\";s:26:\"woo-commerce-slider-static\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"woo-commerce-slider-static\";s:3:\"img\";s:39:\"packages/woo-commerce-slider-static.jpg\";s:7:\"preview\";s:142:\"https://revolution.themepunch.com/woo-commerce-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=woo-commerce-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:178:\"<span class=\"ttm_content\">A uniquely animated Woo Commerce Slider template - this is the static version that doesn\'t use Woo Commerce data</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:7:\"website\";i:1;s:11:\"woocommerce\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:26:\"Woo Commerce Slider Static\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"35\";s:9:\"installed\";b:0;}i:493;a:27:{s:2:\"id\";s:3:\"448\";s:5:\"title\";s:31:\"Blooming Event Florist Template\";s:5:\"alias\";s:31:\"blooming-event-florist-template\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:39:\"blooming-event-florist-template-package\";s:3:\"img\";s:52:\"packages/blooming-event-florist-template-package.jpg\";s:7:\"preview\";s:148:\"https://revolution.themepunch.com/event-florist-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=event-florist-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Blooming Event Florist Template is a complete one-page website solution with beautiful floral animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Blooming Event Florist Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"36\";s:9:\"installed\";b:0;}i:494;a:27:{s:2:\"id\";s:3:\"472\";s:5:\"title\";s:22:\"Stark Website Template\";s:5:\"alias\";s:22:\"stark-website-template\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:30:\"stark-website-template-package\";s:3:\"img\";s:43:\"packages/stark-website-template-package.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/stark-agency-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=stark-agency-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:221:\"<span class=\"ttm_content\">The Stark Agency website template is a collection of modules using our new Gutenberg Block \"margin & padding\" feature. Create unique, customizable layouts!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Stark Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"37\";s:9:\"installed\";b:0;}i:495;a:27:{s:2:\"id\";s:3:\"486\";s:5:\"title\";s:29:\"Story Blocks Website Template\";s:5:\"alias\";s:29:\"story-blocks-website-template\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:37:\"story-blocks-website-template-package\";s:3:\"img\";s:50:\"packages/story-blocks-website-template-package.jpg\";s:7:\"preview\";s:128:\"https://revolution.themepunch.com/story-blocks/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=story-blocks\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:229:\"<span class=\"ttm_content\">The Story Blocks for Slider Revolution can be used to create scroll-based stories on your WordPress site. Mix and match the individual blocks to create YOUR story!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Story Blocks Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"38\";s:9:\"installed\";b:0;}i:496;a:24:{s:2:\"id\";s:3:\"496\";s:5:\"title\";s:21:\"Animated Mini Website\";s:5:\"alias\";s:12:\"mini-website\";s:3:\"zip\";s:16:\"mini-website.zip\";s:3:\"uid\";s:32:\"cc6c0a3b0f933a88c43e2be0fa397c1c\";s:3:\"img\";s:23:\"mini-website/slide1.jpg\";s:7:\"preview\";s:137:\"https://www.sliderrevolution.com/templates/mini-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=mini-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:6:\"6.2.23\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:209:\"<span class=\"ttm_content\">The animated mini website template has a modern, vibrant design and can be customized easily! Get the #1 WordPress Builder with 200+ templates.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:497;a:25:{s:2:\"id\";s:3:\"497\";s:5:\"title\";s:18:\"Food Delivery Hero\";s:5:\"alias\";s:13:\"food-delivery\";s:3:\"zip\";s:17:\"food-delivery.zip\";s:3:\"uid\";s:32:\"992e9b22ff43227a655eea341835d04c\";s:3:\"img\";s:24:\"food-delivery/slide1.jpg\";s:7:\"preview\";s:149:\"https://www.sliderrevolution.com/templates/food-delivery-hero/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=food-delivery-hero\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:6:\"6.2.23\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:207:\"<span class=\"ttm_content\">Yummy! This hero template convinces with a changing color background, a particle effect, vibrant illustrations and smooth mouse over effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:342:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"},{\"path\":\"revslider-mousetrap-addon\\/revslider-mousetrap-addon.php\",\"name\":\"Mousetrap AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:498;a:24:{s:2:\"id\";s:3:\"498\";s:5:\"title\";s:25:\"Slider With Illustrations\";s:5:\"alias\";s:25:\"slider-with-illustrations\";s:3:\"zip\";s:29:\"slider-with-illustrations.zip\";s:3:\"uid\";s:32:\"ebc24280b669f26734c7fdd8b5683e9f\";s:3:\"img\";s:36:\"slider-with-illustrations/slide1.jpg\";s:7:\"preview\";s:163:\"https://www.sliderrevolution.com/templates/slider-with-illustrations/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=slider-with-illustrations\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:6:\"6.2.23\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">A basic slider template with easy to customize content, colorful illustrations and pleasant parallax effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:499;a:27:{s:2:\"id\";s:3:\"499\";s:5:\"title\";s:31:\"Zen Technology Website Template\";s:5:\"alias\";s:31:\"zen-technology-website-template\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:39:\"zen-technology-website-template-package\";s:3:\"img\";s:52:\"packages/zen-technology-website-template-package.jpg\";s:7:\"preview\";s:157:\"https://www.sliderrevolution.com/templates/zen-technology-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=zen-technology-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:6:\"6.2.23\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:200:\"<span class=\"ttm_content\">The Zen Technology Website Template is a modern, striking one-pager for your technology focused project. Easy to edit and get started!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Zen Technology Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"39\";s:9:\"installed\";b:0;}i:500;a:27:{s:2:\"id\";s:3:\"500\";s:5:\"title\";s:8:\"Zen Menu\";s:5:\"alias\";s:8:\"zen-menu\";s:3:\"zip\";s:18:\"packs/zen-menu.zip\";s:3:\"uid\";s:32:\"3b53d755058b75fa6172510dcca2f2bb\";s:3:\"img\";s:19:\"zen-menu/slide1.jpg\";s:7:\"preview\";s:157:\"https://www.sliderrevolution.com/templates/zen-technology-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=zen-technology-website\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:6:\"6.2.23\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:200:\"<span class=\"ttm_content\">The Zen Technology Website Template is a modern, striking one-pager for your technology focused project. Easy to edit and get started!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Zen Technology Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"39\";s:9:\"installed\";b:0;}i:501;a:27:{s:2:\"id\";s:3:\"501\";s:5:\"title\";s:10:\"Zen Header\";s:5:\"alias\";s:10:\"zen-header\";s:3:\"zip\";s:20:\"packs/zen-header.zip\";s:3:\"uid\";s:32:\"13d3cdde05308616fda7e2920a29e006\";s:3:\"img\";s:21:\"zen-header/slide1.jpg\";s:7:\"preview\";s:157:\"https://www.sliderrevolution.com/templates/zen-technology-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=zen-technology-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:6:\"6.2.23\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:200:\"<span class=\"ttm_content\">The Zen Technology Website Template is a modern, striking one-pager for your technology focused project. Easy to edit and get started!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Zen Technology Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"39\";s:9:\"installed\";b:0;}i:502;a:27:{s:2:\"id\";s:3:\"502\";s:5:\"title\";s:9:\"Zen About\";s:5:\"alias\";s:9:\"zen-about\";s:3:\"zip\";s:19:\"packs/zen-about.zip\";s:3:\"uid\";s:32:\"d50d4f9b43e025fa99503b9a4eec6551\";s:3:\"img\";s:20:\"zen-about/slide1.jpg\";s:7:\"preview\";s:157:\"https://www.sliderrevolution.com/templates/zen-technology-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=zen-technology-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:6:\"6.2.23\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:200:\"<span class=\"ttm_content\">The Zen Technology Website Template is a modern, striking one-pager for your technology focused project. Easy to edit and get started!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Zen Technology Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"39\";s:9:\"installed\";b:0;}i:503;a:27:{s:2:\"id\";s:3:\"503\";s:5:\"title\";s:12:\"Zen Features\";s:5:\"alias\";s:12:\"zen-features\";s:3:\"zip\";s:22:\"packs/zen-features.zip\";s:3:\"uid\";s:32:\"f4f7f500fae57b1b55adace13f030778\";s:3:\"img\";s:23:\"zen-features/slide1.jpg\";s:7:\"preview\";s:157:\"https://www.sliderrevolution.com/templates/zen-technology-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=zen-technology-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:6:\"6.2.23\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:200:\"<span class=\"ttm_content\">The Zen Technology Website Template is a modern, striking one-pager for your technology focused project. Easy to edit and get started!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Zen Technology Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"39\";s:9:\"installed\";b:0;}i:504;a:27:{s:2:\"id\";s:3:\"504\";s:5:\"title\";s:9:\"Zen Video\";s:5:\"alias\";s:9:\"zen-video\";s:3:\"zip\";s:19:\"packs/zen-video.zip\";s:3:\"uid\";s:32:\"fa83df1b45b795174770b1b0155e89f3\";s:3:\"img\";s:20:\"zen-video/slide1.jpg\";s:7:\"preview\";s:157:\"https://www.sliderrevolution.com/templates/zen-technology-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=zen-technology-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:6:\"6.2.23\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:200:\"<span class=\"ttm_content\">The Zen Technology Website Template is a modern, striking one-pager for your technology focused project. Easy to edit and get started!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Zen Technology Website Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"39\";s:9:\"installed\";b:0;}i:505;a:27:{s:2:\"id\";s:3:\"505\";s:5:\"title\";s:11:\"Zen Pricing\";s:5:\"alias\";s:11:\"zen-pricing\";s:3:\"zip\";s:21:\"packs/zen-pricing.zip\";s:3:\"uid\";s:32:\"921f8e5c156d9027f6ae8f1c5e426251\";s:3:\"img\";s:22:\"zen-pricing/slide1.jpg\";s:7:\"preview\";s:157:\"https://www.sliderrevolution.com/templates/zen-technology-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=zen-technology-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:6:\"6.2.23\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:200:\"<span class=\"ttm_content\">The Zen Technology Website Template is a modern, striking one-pager for your technology focused project. Easy to edit and get started!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Zen Technology Website Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"39\";s:9:\"installed\";b:0;}i:506;a:27:{s:2:\"id\";s:3:\"506\";s:5:\"title\";s:22:\"Zen Testimonials Title\";s:5:\"alias\";s:22:\"zen-testimonials-title\";s:3:\"zip\";s:32:\"packs/zen-testimonials-title.zip\";s:3:\"uid\";s:32:\"d9aeeb596c0455ddd564a60a2d449b17\";s:3:\"img\";s:33:\"zen-testimonials-title/slide1.jpg\";s:7:\"preview\";s:157:\"https://www.sliderrevolution.com/templates/zen-technology-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=zen-technology-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:6:\"6.2.23\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:200:\"<span class=\"ttm_content\">The Zen Technology Website Template is a modern, striking one-pager for your technology focused project. Easy to edit and get started!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Zen Technology Website Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"39\";s:9:\"installed\";b:0;}i:507;a:27:{s:2:\"id\";s:3:\"507\";s:5:\"title\";s:16:\"Zen Testimonials\";s:5:\"alias\";s:16:\"zen-testimonials\";s:3:\"zip\";s:26:\"packs/zen-testimonials.zip\";s:3:\"uid\";s:32:\"5a0e0141599c63828e4b99e3bc863366\";s:3:\"img\";s:27:\"zen-testimonials/slide1.jpg\";s:7:\"preview\";s:157:\"https://www.sliderrevolution.com/templates/zen-technology-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=zen-technology-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:6:\"6.2.23\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:200:\"<span class=\"ttm_content\">The Zen Technology Website Template is a modern, striking one-pager for your technology focused project. Easy to edit and get started!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Zen Technology Website Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"39\";s:9:\"installed\";b:0;}i:508;a:27:{s:2:\"id\";s:3:\"508\";s:5:\"title\";s:10:\"Zen Footer\";s:5:\"alias\";s:10:\"zen-footer\";s:3:\"zip\";s:20:\"packs/zen-footer.zip\";s:3:\"uid\";s:32:\"47fb8604e2aafa8cfc97f5af75fda911\";s:3:\"img\";s:21:\"zen-footer/slide1.jpg\";s:7:\"preview\";s:157:\"https://www.sliderrevolution.com/templates/zen-technology-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=zen-technology-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:6:\"6.2.23\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:200:\"<span class=\"ttm_content\">The Zen Technology Website Template is a modern, striking one-pager for your technology focused project. Easy to edit and get started!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:31:\"Zen Technology Website Template\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"39\";s:9:\"installed\";b:0;}i:509;a:24:{s:2:\"id\";s:3:\"509\";s:5:\"title\";s:24:\"Paintbrush Effect Add-on\";s:5:\"alias\";s:17:\"Paintbrush-Effect\";s:3:\"zip\";s:21:\"Paintbrush-Effect.zip\";s:3:\"uid\";s:32:\"b934d1376df026f0ff45447de17b5ee9\";s:3:\"img\";s:28:\"Paintbrush-Effect/slide1.jpg\";s:7:\"preview\";s:169:\"https://www.sliderrevolution.com/templates/paintbrush-effect-collection/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=paintbrush-effect-collection\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:6:\"6.2.23\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:179:\"<span class=\"ttm_content\">The Paintbrush Effect Add-on is the perfect way to add some interactivity to your website with Slider Revolution.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:338:\"[{\"path\":\"revslider-paintbrush-addon\\/revslider-paintbrush-addon.php\",\"name\":\"Paintbrush AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"},{\"path\":\"revslider-mousetrap-addon\\/revslider-mousetrap-addon.php\",\"name\":\"Mousetrap AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:518;a:24:{s:2:\"id\";s:3:\"518\";s:5:\"title\";s:25:\"Black Friday Scroll Video\";s:5:\"alias\";s:25:\"black-friday-scroll-video\";s:3:\"zip\";s:29:\"black-friday-scroll-video.zip\";s:3:\"uid\";s:32:\"a6a4ab2e2f703aaee0a1e6121881bdd8\";s:3:\"img\";s:36:\"black-friday-scroll-video/slide1.jpg\";s:7:\"preview\";s:163:\"https://www.sliderrevolution.com/templates/black-friday-scroll-video/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=black-friday-scroll-video\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.4.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:169:\"<span class=\"ttm_content\">Blackfriday offers are coming towards you from the depths of space, with this scroll-based hero module.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:369:\"[{\"path\":\"revslider-lottie-addon\\/revslider-lottie-addon.php\",\"name\":\"Slider Revolution Lottie AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"},{\"path\":\"revslider-scrollvideo-addon\\/revslider-scrollvideo-addon.php\",\"name\":\"Slider Revolution Scroll Video AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:71:\"Spice Up Your Sales Promotions with a Video Scroll Animation [Tutorial]\";s:9:\"guide_url\";s:104:\"https://www.sliderrevolution.com/tutorials/spice-up-your-sales-promotions-with-a-video-scroll-animation/\";s:9:\"guide_img\";s:38:\"tutorial/black-friday-scroll-video.png\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:519;a:27:{s:2:\"id\";s:3:\"519\";s:5:\"title\";s:26:\"Charity Non-Profit-Website\";s:5:\"alias\";s:26:\"charity-non-profit-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"charity-non-profit-website\";s:3:\"img\";s:47:\"packages/charity-non-profit-website-package.jpg\";s:7:\"preview\";s:165:\"https://www.sliderrevolution.com/templates/charity-non-profit-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=charity-non-profit-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The \"Charity Non-Profit Website\" is a useful one-page website template with simple & smooth animation effects and animated lottie icons.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";s:177:\"[{\"path\":\"revslider-lottie-addon\\/revslider-lottie-addon.php\",\"name\":\"Slider Revolution Lottie AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:26:\"Charity Non-Profit-Website\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"41\";s:9:\"installed\";b:0;}i:520;a:27:{s:2:\"id\";s:3:\"520\";s:5:\"title\";s:12:\"Charity Menu\";s:5:\"alias\";s:12:\"charity-menu\";s:3:\"zip\";s:22:\"packs/charity-menu.zip\";s:3:\"uid\";s:32:\"77794a39041c7f128de3b5ad9b8e7d0d\";s:3:\"img\";s:23:\"charity-menu/slide1.jpg\";s:7:\"preview\";s:165:\"https://www.sliderrevolution.com/templates/charity-non-profit-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=charity-non-profit-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The \"Charity Non-Profit Website\" is a useful one-page website template with simple & smooth animation effects and animated lottie icons.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:26:\"Charity Non-Profit-Website\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"41\";s:9:\"installed\";b:0;}i:521;a:27:{s:2:\"id\";s:3:\"521\";s:5:\"title\";s:14:\"Charity Header\";s:5:\"alias\";s:14:\"charity-header\";s:3:\"zip\";s:24:\"packs/charity-header.zip\";s:3:\"uid\";s:32:\"36096787d4ed62942cbd48f6a57e9d4f\";s:3:\"img\";s:25:\"charity-header/slide1.jpg\";s:7:\"preview\";s:165:\"https://www.sliderrevolution.com/templates/charity-non-profit-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=charity-non-profit-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The \"Charity Non-Profit Website\" is a useful one-page website template with simple & smooth animation effects and animated lottie icons.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:26:\"Charity Non-Profit-Website\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:86:\" offset=\"t:90px,80px,70px,70px;b:0px,0px,0px,0px;l:0px,0px,0px,0px;r:0px,0px,0px,0px;\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"41\";s:9:\"installed\";b:0;}i:522;a:27:{s:2:\"id\";s:3:\"522\";s:5:\"title\";s:15:\"Charity Mission\";s:5:\"alias\";s:15:\"charity-mission\";s:3:\"zip\";s:25:\"packs/charity-mission.zip\";s:3:\"uid\";s:32:\"8c5cd67e3eb51c0ca3e571408ac8e97b\";s:3:\"img\";s:26:\"charity-mission/slide1.jpg\";s:7:\"preview\";s:165:\"https://www.sliderrevolution.com/templates/charity-non-profit-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=charity-non-profit-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The \"Charity Non-Profit Website\" is a useful one-page website template with simple & smooth animation effects and animated lottie icons.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:177:\"[{\"path\":\"revslider-lottie-addon\\/revslider-lottie-addon.php\",\"name\":\"Slider Revolution Lottie AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:26:\"Charity Non-Profit-Website\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"41\";s:9:\"installed\";b:0;}i:523;a:27:{s:2:\"id\";s:3:\"523\";s:5:\"title\";s:13:\"Charity Funds\";s:5:\"alias\";s:13:\"charity-funds\";s:3:\"zip\";s:23:\"packs/charity-funds.zip\";s:3:\"uid\";s:32:\"10da554c7529ef91965e1618a04b410b\";s:3:\"img\";s:24:\"charity-funds/slide1.jpg\";s:7:\"preview\";s:165:\"https://www.sliderrevolution.com/templates/charity-non-profit-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=charity-non-profit-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The \"Charity Non-Profit Website\" is a useful one-page website template with simple & smooth animation effects and animated lottie icons.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:177:\"[{\"path\":\"revslider-lottie-addon\\/revslider-lottie-addon.php\",\"name\":\"Slider Revolution Lottie AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:26:\"Charity Non-Profit-Website\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"41\";s:9:\"installed\";b:0;}i:524;a:27:{s:2:\"id\";s:3:\"524\";s:5:\"title\";s:15:\"Charity Success\";s:5:\"alias\";s:15:\"charity-success\";s:3:\"zip\";s:25:\"packs/charity-success.zip\";s:3:\"uid\";s:32:\"0c35448c1905272606e87447886a348e\";s:3:\"img\";s:26:\"charity-success/slide1.jpg\";s:7:\"preview\";s:165:\"https://www.sliderrevolution.com/templates/charity-non-profit-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=charity-non-profit-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The \"Charity Non-Profit Website\" is a useful one-page website template with simple & smooth animation effects and animated lottie icons.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:177:\"[{\"path\":\"revslider-lottie-addon\\/revslider-lottie-addon.php\",\"name\":\"Slider Revolution Lottie AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:26:\"Charity Non-Profit-Website\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"41\";s:9:\"installed\";b:0;}i:525;a:27:{s:2:\"id\";s:3:\"525\";s:5:\"title\";s:15:\"Charity Stories\";s:5:\"alias\";s:15:\"charity-stories\";s:3:\"zip\";s:25:\"packs/charity-stories.zip\";s:3:\"uid\";s:32:\"f277f145d9f9c3f0033bb8ceffeb4c9f\";s:3:\"img\";s:26:\"charity-stories/slide1.jpg\";s:7:\"preview\";s:165:\"https://www.sliderrevolution.com/templates/charity-non-profit-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=charity-non-profit-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The \"Charity Non-Profit Website\" is a useful one-page website template with simple & smooth animation effects and animated lottie icons.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:26:\"Charity Non-Profit-Website\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"41\";s:9:\"installed\";b:0;}i:526;a:27:{s:2:\"id\";s:3:\"526\";s:5:\"title\";s:16:\"Charity Worldmap\";s:5:\"alias\";s:16:\"charity-worldmap\";s:3:\"zip\";s:26:\"packs/charity-worldmap.zip\";s:3:\"uid\";s:32:\"9e00cbac269b92cb24fd3230297f4685\";s:3:\"img\";s:27:\"charity-worldmap/slide1.jpg\";s:7:\"preview\";s:165:\"https://www.sliderrevolution.com/templates/charity-non-profit-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=charity-non-profit-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The \"Charity Non-Profit Website\" is a useful one-page website template with simple & smooth animation effects and animated lottie icons.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:26:\"Charity Non-Profit-Website\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"41\";s:9:\"installed\";b:0;}i:527;a:27:{s:2:\"id\";s:3:\"527\";s:5:\"title\";s:19:\"Charity Large Image\";s:5:\"alias\";s:19:\"charity-large-image\";s:3:\"zip\";s:29:\"packs/charity-large-image.zip\";s:3:\"uid\";s:32:\"fa927036c2b14622832106fa987bc8e7\";s:3:\"img\";s:30:\"charity-large-image/slide1.jpg\";s:7:\"preview\";s:165:\"https://www.sliderrevolution.com/templates/charity-non-profit-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=charity-non-profit-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The \"Charity Non-Profit Website\" is a useful one-page website template with simple & smooth animation effects and animated lottie icons.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:26:\"Charity Non-Profit-Website\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"41\";s:9:\"installed\";b:0;}i:528;a:27:{s:2:\"id\";s:3:\"528\";s:5:\"title\";s:16:\"Charity Sponsors\";s:5:\"alias\";s:16:\"charity-sponsors\";s:3:\"zip\";s:26:\"packs/charity-sponsors.zip\";s:3:\"uid\";s:32:\"efd087bc3fa3915139af9e93d47ee295\";s:3:\"img\";s:27:\"charity-sponsors/slide1.jpg\";s:7:\"preview\";s:165:\"https://www.sliderrevolution.com/templates/charity-non-profit-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=charity-non-profit-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The \"Charity Non-Profit Website\" is a useful one-page website template with simple & smooth animation effects and animated lottie icons.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:26:\"Charity Non-Profit-Website\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"41\";s:9:\"installed\";b:0;}i:529;a:27:{s:2:\"id\";s:3:\"529\";s:5:\"title\";s:12:\"Charity Help\";s:5:\"alias\";s:12:\"charity-help\";s:3:\"zip\";s:22:\"packs/charity-help.zip\";s:3:\"uid\";s:32:\"4f3571c0b27f061648c9ff95b1a3f718\";s:3:\"img\";s:23:\"charity-help/slide1.jpg\";s:7:\"preview\";s:165:\"https://www.sliderrevolution.com/templates/charity-non-profit-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=charity-non-profit-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The \"Charity Non-Profit Website\" is a useful one-page website template with simple & smooth animation effects and animated lottie icons.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:26:\"Charity Non-Profit-Website\";s:13:\"package_order\";s:2:\"10\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"41\";s:9:\"installed\";b:0;}i:530;a:27:{s:2:\"id\";s:3:\"530\";s:5:\"title\";s:14:\"Charity Footer\";s:5:\"alias\";s:14:\"charity-footer\";s:3:\"zip\";s:24:\"packs/charity-footer.zip\";s:3:\"uid\";s:32:\"9340fa48c56635a8a781cc37c4bf538c\";s:3:\"img\";s:25:\"charity-footer/slide1.jpg\";s:7:\"preview\";s:165:\"https://www.sliderrevolution.com/templates/charity-non-profit-website/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=charity-non-profit-website\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The \"Charity Non-Profit Website\" is a useful one-page website template with simple & smooth animation effects and animated lottie icons.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:26:\"Charity Non-Profit-Website\";s:13:\"package_order\";s:2:\"11\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"41\";s:9:\"installed\";b:0;}i:531;a:24:{s:2:\"id\";s:3:\"531\";s:5:\"title\";s:21:\"Cinematic Hero Titles\";s:5:\"alias\";s:21:\"cinematic-hero-titles\";s:3:\"zip\";s:25:\"cinematic-hero-titles.zip\";s:3:\"uid\";s:32:\"51a59c54bb97c274092d22dbf4f6085e\";s:3:\"img\";s:32:\"cinematic-hero-titles/slide1.jpg\";s:7:\"preview\";s:155:\"https://www.sliderrevolution.com/templates/cinematic-hero-titles/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=cinematic-hero-titles\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:199:\"<span class=\"ttm_content\">The \"Cinematic Hero Titles\" template is a collection of fullscreen hero blocks that use a cinematic, animated letter-spacing effect..</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:177:\"[{\"path\":\"revslider-lottie-addon\\/revslider-lottie-addon.php\",\"name\":\"Slider Revolution Lottie AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:70:\"https://www.sliderrevolution.com/tutorials/how-to-design-a-hero-image/\";s:9:\"guide_url\";s:70:\"https://www.sliderrevolution.com/tutorials/how-to-design-a-hero-image/\";s:9:\"guide_img\";s:34:\"tutorial/cinematic-hero-titles.png\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:532;a:24:{s:2:\"id\";s:3:\"532\";s:5:\"title\";s:23:\"Design DNA Scroll Video\";s:5:\"alias\";s:23:\"design-dna-scroll-video\";s:3:\"zip\";s:27:\"design-dna-scroll-video.zip\";s:3:\"uid\";s:32:\"39180fc9f7a07e50832fc1a68fb4eba2\";s:3:\"img\";s:34:\"design-dna-scroll-video/slide1.jpg\";s:7:\"preview\";s:159:\"https://www.sliderrevolution.com/templates/design-dna-scroll-video/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=design-dna-scroll-video\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.4.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:185:\"<span class=\"ttm_content\">The \"Design DNA Scroll Video\" template is a striking, fullscreen hero module that is using our new Scroll Video addon.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:543:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"},{\"path\":\"revslider-lottie-addon\\/revslider-lottie-addon.php\",\"name\":\"Slider Revolution Lottie AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"},{\"path\":\"revslider-scrollvideo-addon\\/revslider-scrollvideo-addon.php\",\"name\":\"Slider Revolution Scroll Video AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:533;a:24:{s:2:\"id\";s:3:\"533\";s:5:\"title\";s:27:\"Food Delivery Lottie Scroll\";s:5:\"alias\";s:27:\"food-delivery-lottie-scroll\";s:3:\"zip\";s:31:\"food-delivery-lottie-scroll.zip\";s:3:\"uid\";s:32:\"5dfbfac45c5df7702238ba1b43afe8f6\";s:3:\"img\";s:38:\"food-delivery-lottie-scroll/slide1.jpg\";s:7:\"preview\";s:167:\"https://www.sliderrevolution.com/templates/food-delivery-lottie-scroll/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=food-delivery-lottie-scroll\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:185:\"<span class=\"ttm_content\">The \"Design DNA Scroll Video\" template is a striking, fullscreen hero module that is using our new Scroll Video addon.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:177:\"[{\"path\":\"revslider-lottie-addon\\/revslider-lottie-addon.php\",\"name\":\"Slider Revolution Lottie AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:68:\"How to Design a Scroll Animation on Your Own Using Lottie [Tutorial]\";s:9:\"guide_url\";s:110:\"https://www.sliderrevolution.com/tutorials/how-to-design-a-scroll-animation-on-your-own-using-lottie-tutorial/\";s:9:\"guide_img\";s:40:\"tutorial/food-delivery-lottie-scroll.png\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:534;a:27:{s:2:\"id\";s:3:\"534\";s:5:\"title\";s:29:\"Food Recipe Carousel Template\";s:5:\"alias\";s:29:\"food-recipe-carousel-template\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:29:\"food-recipe-carousel-template\";s:3:\"img\";s:50:\"packages/food-recipe-carousel-template-package.jpg\";s:7:\"preview\";s:153:\"https://www.sliderrevolution.com/templates/food-recipe-carousel/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=food-recipe-carousel\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:193:\"<span class=\"ttm_content\">Showcase your cooking recipes with the easy to use \"Food Recipe Carousel\" template. Clicking the titles opens up a detail view!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Food Recipe Carousel Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"42\";s:9:\"installed\";b:0;}i:535;a:27:{s:2:\"id\";s:3:\"535\";s:5:\"title\";s:20:\"Food Recipe Carousel\";s:5:\"alias\";s:20:\"food-recipe-carousel\";s:3:\"zip\";s:30:\"packs/food-recipe-carousel.zip\";s:3:\"uid\";s:32:\"6ba9695ba1a22a6e99f96431d8fb01e8\";s:3:\"img\";s:31:\"food-recipe-carousel/slide1.jpg\";s:7:\"preview\";s:153:\"https://www.sliderrevolution.com/templates/food-recipe-carousel/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=food-recipe-carousel\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The \"Charity Non-Profit Website\" is a useful one-page website template with simple & smooth animation effects and animated lottie icons.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Food Recipe Carousel Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"42\";s:9:\"installed\";b:0;}i:536;a:27:{s:2:\"id\";s:3:\"536\";s:5:\"title\";s:17:\"Food Recipe Modal\";s:5:\"alias\";s:17:\"food-recipe-modal\";s:3:\"zip\";s:27:\"packs/food-recipe-modal.zip\";s:3:\"uid\";s:32:\"1c5b2e959cd973efc5c1887a3a4279f3\";s:3:\"img\";s:28:\"food-recipe-modal/slide1.jpg\";s:7:\"preview\";s:153:\"https://www.sliderrevolution.com/templates/food-recipe-carousel/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=food-recipe-carousel\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:202:\"<span class=\"ttm_content\">The \"Charity Non-Profit Website\" is a useful one-page website template with simple & smooth animation effects and animated lottie icons.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Food Recipe Carousel Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"1\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"42\";s:9:\"installed\";b:0;}i:537;a:27:{s:2:\"id\";s:3:\"537\";s:5:\"title\";s:27:\"Corporate Carousel Template\";s:5:\"alias\";s:27:\"corporate-carousel-template\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:27:\"corporate-carousel-template\";s:3:\"img\";s:38:\"packages/corporate_carousel_bundle.jpg\";s:7:\"preview\";s:176:\"https://www.sliderrevolution.com/templates/corporate-carousel-with-lightbox?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=corporate-carousel-with-lightbox\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Corporate Carousel is a basic, easy to use carousel with tab navigation. The lightbox modal can show any additonal content, independant of the carousel.</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-01-19 15:14:10\";s:7:\"package\";s:27:\"Corporate Carousel Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"43\";s:9:\"installed\";b:0;}i:538;a:27:{s:2:\"id\";s:3:\"538\";s:5:\"title\";s:18:\"Corporate Carousel\";s:5:\"alias\";s:18:\"corporate-carousel\";s:3:\"zip\";s:28:\"packs/corporate-carousel.zip\";s:3:\"uid\";s:32:\"30dea0e333913cb5ebbf8dded8c3a839\";s:3:\"img\";s:29:\"corporate-carousel/slide1.jpg\";s:7:\"preview\";s:128:\"https://revolution.themepunch.com/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=revolution.themepunch.com\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.3.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Corporate Carousel is a basic, easy to use carousel with tab navigation. The lightbox modal can show any additonal content, independant of the carousel.</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-01-19 15:26:51\";s:7:\"package\";s:27:\"Corporate Carousel Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"43\";s:9:\"installed\";b:0;}i:539;a:27:{s:2:\"id\";s:3:\"539\";s:5:\"title\";s:18:\"Corporate Lightbox\";s:5:\"alias\";s:18:\"corporate-lightbox\";s:3:\"zip\";s:28:\"packs/corporate-lightbox.zip\";s:3:\"uid\";s:32:\"832c277bfc5a288c0dffd784e4041265\";s:3:\"img\";s:29:\"corporate-lightbox/slide1.jpg\";s:7:\"preview\";s:128:\"https://revolution.themepunch.com/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=revolution.themepunch.com\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Corporate Carousel is a basic, easy to use carousel with tab navigation. The lightbox modal can show any additonal content, independant of the carousel.</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-01-19 15:34:36\";s:7:\"package\";s:27:\"Corporate Carousel Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"1\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"43\";s:9:\"installed\";b:0;}i:540;a:27:{s:2:\"id\";s:3:\"540\";s:5:\"title\";s:23:\"Cyber Carousel Template\";s:5:\"alias\";s:23:\"cyber-carousel-template\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:23:\"cyber-carousel-template\";s:3:\"img\";s:33:\"packages/cybercarousel_bundle.jpg\";s:7:\"preview\";s:168:\"https://www.sliderrevolution.com/templates/cyber-carousel-with-lightbox?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=cyber-carousel-with-lightbox\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:218:\"<span class=\"ttm_content\">This fullscreen carousel has easy to edit content and vertical navigation tabs. The highlight color can be changed with one click upon opening the editor.</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:8:\"carousel\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-01-19 15:40:25\";s:7:\"package\";s:23:\"Cyber Carousel Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:91:\"How to Create a Featured Content Section That Convinces Visitors to Keep Reading [Tutorial]\";s:9:\"guide_url\";s:124:\"https://www.sliderrevolution.com/tutorials/how-to-create-a-featured-content-section-that-convinces-visitors-to-keep-reading/\";s:9:\"guide_img\";s:41:\"tutorial/Cyber-Carousel-With-Lightbox.png\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"44\";s:9:\"installed\";b:0;}i:541;a:27:{s:2:\"id\";s:3:\"541\";s:5:\"title\";s:14:\"Cyber Carousel\";s:5:\"alias\";s:14:\"cyber-carousel\";s:3:\"zip\";s:24:\"packs/cyber-carousel.zip\";s:3:\"uid\";s:32:\"b5ef41c7f498bd1dccf8224bfbade718\";s:3:\"img\";s:25:\"cyber-carousel/slide1.jpg\";s:7:\"preview\";s:168:\"https://www.sliderrevolution.com/templates/cyber-carousel-with-lightbox?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=cyber-carousel-with-lightbox\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.4.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:218:\"<span class=\"ttm_content\">This fullscreen carousel has easy to edit content and vertical navigation tabs. The highlight color can be changed with one click upon opening the editor.</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-01-19 15:42:44\";s:7:\"package\";s:23:\"Cyber Carousel Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:91:\"How to Create a Featured Content Section That Convinces Visitors to Keep Reading [Tutorial]\";s:9:\"guide_url\";s:124:\"https://www.sliderrevolution.com/tutorials/how-to-create-a-featured-content-section-that-convinces-visitors-to-keep-reading/\";s:9:\"guide_img\";s:41:\"tutorial/Cyber-Carousel-With-Lightbox.png\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"44\";s:9:\"installed\";b:0;}i:542;a:27:{s:2:\"id\";s:3:\"542\";s:5:\"title\";s:23:\"Cyber Carousel Lightbox\";s:5:\"alias\";s:23:\"cyber-carousel-lightbox\";s:3:\"zip\";s:33:\"packs/cyber-carousel-lightbox.zip\";s:3:\"uid\";s:32:\"cb91abeed0555dfcafe849c37e7c9c32\";s:3:\"img\";s:34:\"cyber-carousel-lightbox/slide1.jpg\";s:7:\"preview\";s:168:\"https://www.sliderrevolution.com/templates/cyber-carousel-with-lightbox?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=cyber-carousel-with-lightbox\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:218:\"<span class=\"ttm_content\">This fullscreen carousel has easy to edit content and vertical navigation tabs. The highlight color can be changed with one click upon opening the editor.</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-01-19 15:50:15\";s:7:\"package\";s:23:\"Cyber Carousel Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"1\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:91:\"How to Create a Featured Content Section That Convinces Visitors to Keep Reading [Tutorial]\";s:9:\"guide_url\";s:124:\"https://www.sliderrevolution.com/tutorials/how-to-create-a-featured-content-section-that-convinces-visitors-to-keep-reading/\";s:9:\"guide_img\";s:41:\"tutorial/Cyber-Carousel-With-Lightbox.png\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"44\";s:9:\"installed\";b:0;}i:543;a:27:{s:2:\"id\";s:3:\"543\";s:5:\"title\";s:16:\"Woo Carousel One\";s:5:\"alias\";s:24:\"woocommerce-carousel-one\";s:3:\"zip\";s:28:\"woocommerce-carousel-one.zip\";s:3:\"uid\";s:32:\"df0a99cef3981ecb608dff4ed573a493\";s:3:\"img\";s:35:\"woocommerce-carousel-one/slide1.jpg\";s:7:\"preview\";s:159:\"https://www.sliderrevolution.com/templates/woocommerce-slider-pack/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=woocommerce-slider-pack\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:185:\"<span class=\"ttm_content\">A basic WooCommerce carousel. Just set your categories and the carousel will be populated with your WooCommerce products.</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:8:\"carousel\";i:1;s:11:\"woocommerce\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-01-19 16:02:45\";s:7:\"package\";s:15:\"Woo Slider Pack\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"45\";s:9:\"installed\";b:0;}i:544;a:27:{s:2:\"id\";s:3:\"544\";s:5:\"title\";s:23:\"Woo Carousel One Static\";s:5:\"alias\";s:31:\"woocommerce-carousel-one-static\";s:3:\"zip\";s:35:\"woocommerce-carousel-one-static.zip\";s:3:\"uid\";s:32:\"5c955a3850369e79b1e18921306ac1df\";s:3:\"img\";s:42:\"woocommerce-carousel-one-static/slide1.jpg\";s:7:\"preview\";s:155:\"https://sliderrevolution.com/templates/woocommerce-slider-pack/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=woocommerce-slider-pack\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A static content carousel. Please use the \"non-static\" version for WooCommerce.</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:8:\"carousel\";i:1;s:11:\"woocommerce\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-01-19 16:05:02\";s:7:\"package\";s:22:\"Woo Slider Pack Static\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"46\";s:9:\"installed\";b:0;}i:545;a:27:{s:2:\"id\";s:3:\"545\";s:5:\"title\";s:16:\"Woo Carousel Two\";s:5:\"alias\";s:24:\"woocommerce-carousel-two\";s:3:\"zip\";s:28:\"woocommerce-carousel-two.zip\";s:3:\"uid\";s:32:\"fdd797d8e98a9138f5563b68b95ebe1c\";s:3:\"img\";s:35:\"woocommerce-carousel-two/slide1.jpg\";s:7:\"preview\";s:159:\"https://www.sliderrevolution.com/templates/woocommerce-slider-pack/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=woocommerce-slider-pack\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:185:\"<span class=\"ttm_content\">A basic WooCommerce carousel. Just set your categories and the carousel will be populated with your WooCommerce products.</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:8:\"carousel\";i:1;s:11:\"woocommerce\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-01-19 16:06:57\";s:7:\"package\";s:15:\"Woo Slider Pack\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"45\";s:9:\"installed\";b:0;}i:546;a:27:{s:2:\"id\";s:3:\"546\";s:5:\"title\";s:23:\"Woo Carousel Two Static\";s:5:\"alias\";s:31:\"woocommerce-carousel-two-static\";s:3:\"zip\";s:35:\"woocommerce-carousel-two-static.zip\";s:3:\"uid\";s:32:\"2f3bfb1dfa99647426ce906f10dfc480\";s:3:\"img\";s:42:\"woocommerce-carousel-two-static/slide1.jpg\";s:7:\"preview\";s:155:\"https://sliderrevolution.com/templates/woocommerce-slider-pack/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=woocommerce-slider-pack\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A static content carousel. Please use the \"non-static\" version for WooCommerce.</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:8:\"carousel\";i:1;s:11:\"woocommerce\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-01-19 16:16:15\";s:7:\"package\";s:22:\"Woo Slider Pack Static\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"46\";s:9:\"installed\";b:0;}i:547;a:27:{s:2:\"id\";s:3:\"547\";s:5:\"title\";s:18:\"Woo Feature Slider\";s:5:\"alias\";s:26:\"woocommerce-feature-slider\";s:3:\"zip\";s:30:\"woocommerce-feature-slider.zip\";s:3:\"uid\";s:32:\"c8aa1f551065eeffc752f2d8daef6db1\";s:3:\"img\";s:37:\"woocommerce-feature-slider/slide1.jpg\";s:7:\"preview\";s:159:\"https://www.sliderrevolution.com/templates/woocommerce-slider-pack/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=woocommerce-slider-pack\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:181:\"<span class=\"ttm_content\">A basic WooCommerce slider. Just set your categories and the slider will be populated with your WooCommerce products.</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"woocommerce\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-01-19 16:19:13\";s:7:\"package\";s:15:\"Woo Slider Pack\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"45\";s:9:\"installed\";b:0;}i:548;a:27:{s:2:\"id\";s:3:\"548\";s:5:\"title\";s:25:\"Woo Feature Slider Static\";s:5:\"alias\";s:33:\"woocommerce-feature-slider-static\";s:3:\"zip\";s:37:\"woocommerce-feature-slider-static.zip\";s:3:\"uid\";s:32:\"2f29e8fd101c799480152a7911b33ca6\";s:3:\"img\";s:44:\"woocommerce-feature-slider-static/slide1.jpg\";s:7:\"preview\";s:155:\"https://sliderrevolution.com/templates/woocommerce-slider-pack/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=woocommerce-slider-pack\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:140:\"<span class=\"ttm_content\">A static content slider Please use the \"non-static\" version for WooCommerce.</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"woocommerce\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-01-19 16:20:57\";s:7:\"package\";s:22:\"Woo Slider Pack Static\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"46\";s:9:\"installed\";b:0;}i:549;a:24:{s:2:\"id\";s:3:\"549\";s:5:\"title\";s:17:\"Woo Liquid Slider\";s:5:\"alias\";s:17:\"woo-liquid-slider\";s:3:\"zip\";s:21:\"woo-liquid-slider.zip\";s:3:\"uid\";s:32:\"9f455f73675a73dbefe820288e994f27\";s:3:\"img\";s:28:\"woo-liquid-slider/slide1.jpg\";s:7:\"preview\";s:162:\"https://www.sliderrevolution.com/templates/woocommerce-liquid-slider?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=woocommerce-liquid-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:236:\"<span class=\"ttm_content\">A WooCommerce slider using the BubbleMorph addon for an interesting liquid effect. Just set your categories and the slider will be populated with your WooCommerce products.</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";i:2;s:11:\"woocommerce\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"2021-01-19 16:23:03\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:80:\"How to Draw Attention to Your eCommerce Products with a Liquid Effect [Tutorial]\";s:9:\"guide_url\";s:92:\"https://www.sliderrevolution.com/tutorials/how-to-draw-attention-to-your-ecommerce-products/\";s:9:\"guide_img\";s:30:\"tutorial/woo-liquid-slider.png\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:550;a:24:{s:2:\"id\";s:3:\"550\";s:5:\"title\";s:24:\"Woo Liquid Slider Static\";s:5:\"alias\";s:32:\"woocommerce-liquid-slider-static\";s:3:\"zip\";s:36:\"woocommerce-liquid-slider-static.zip\";s:3:\"uid\";s:32:\"5848192fea46ffee95a91aa531848e19\";s:3:\"img\";s:43:\"woocommerce-liquid-slider-static/slide1.jpg\";s:7:\"preview\";s:162:\"https://www.sliderrevolution.com/templates/woocommerce-liquid-slider?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=woocommerce-liquid-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:203:\"<span class=\"ttm_content\">A static content slider using the BubbleMorph addon for an interesting liquid effect. For WooCommerce, please use the \"non-static\" version.</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"woocommerce\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"2021-01-19 16:24:35\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:80:\"How to Draw Attention to Your eCommerce Products with a Liquid Effect [Tutorial]\";s:9:\"guide_url\";s:92:\"https://www.sliderrevolution.com/tutorials/how-to-draw-attention-to-your-ecommerce-products/\";s:9:\"guide_img\";s:30:\"tutorial/woo-liquid-slider.png\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:551;a:27:{s:2:\"id\";s:3:\"551\";s:5:\"title\";s:15:\"Woo Slider Pack\";s:5:\"alias\";s:15:\"woo-slider-pack\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:15:\"woo-slider-pack\";s:3:\"img\";s:34:\"packages/woosliderpack_dynamic.jpg\";s:7:\"preview\";s:159:\"https://www.sliderrevolution.com/templates/woocommerce-slider-pack/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=woocommerce-slider-pack\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:181:\"<span class=\"ttm_content\">A basic WooCommerce slider. Just set your categories and the slider will be populated with your WooCommerce products.</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:4:{i:0;s:8:\"carousel\";i:1;s:6:\"slider\";i:2;s:9:\"postbased\";i:3;s:11:\"woocommerce\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-01-20 09:34:45\";s:7:\"package\";s:15:\"Woo Slider Pack\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"45\";s:9:\"installed\";b:0;}i:552;a:27:{s:2:\"id\";s:3:\"552\";s:5:\"title\";s:22:\"Woo Slider Pack Static\";s:5:\"alias\";s:22:\"woo-slider-pack-static\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"woo-slider-pack-static\";s:3:\"img\";s:33:\"packages/woosliderpack_static.jpg\";s:7:\"preview\";s:159:\"https://www.sliderrevolution.com/templates/woocommerce-slider-pack/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=woocommerce-slider-pack\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.3.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:181:\"<span class=\"ttm_content\">A basic WooCommerce slider. Just set your categories and the slider will be populated with your WooCommerce products.</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:2:{i:0;s:8:\"carousel\";i:1;s:11:\"woocommerce\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-01-20 09:39:21\";s:7:\"package\";s:22:\"Woo Slider Pack Static\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"46\";s:9:\"installed\";b:0;}i:553;a:24:{s:2:\"id\";s:3:\"553\";s:5:\"title\";s:24:\"Creative Hero Collection\";s:5:\"alias\";s:24:\"creative-hero-collection\";s:3:\"zip\";s:28:\"creative-hero-collection.zip\";s:3:\"uid\";s:32:\"e20126d93d081055e5ff3f6981b971fa\";s:3:\"img\";s:35:\"creative-hero-collection/slide1.jpg\";s:7:\"preview\";s:161:\"https://www.sliderrevolution.com/templates/creative-hero-collection/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=creative-hero-collection\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.4.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:245:\"<span class=\"ttm_content\">A fantastic intro presentation for almost any website. If you want to use a single slide as a hero, simply drag it to the first position and set the layout of the module to \"scene\".</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:348:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"},{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"2021-02-23 10:22:47\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:78:\"How to Create an Engaging Hero Section Without Any Photos or Videos [Tutorial]\";s:9:\"guide_url\";s:111:\"https://www.sliderrevolution.com/tutorials/how-to-create-an-engaging-hero-section-without-any-photos-or-videos/\";s:9:\"guide_img\";s:37:\"tutorial/Creative-Hero-Collection.png\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:554;a:24:{s:2:\"id\";s:3:\"554\";s:5:\"title\";s:12:\"Photo Slider\";s:5:\"alias\";s:19:\"photographer-slider\";s:3:\"zip\";s:23:\"photographer-slider.zip\";s:3:\"uid\";s:32:\"e00104cff231e2aaeb149b3c63e78a5e\";s:3:\"img\";s:30:\"photographer-slider/slide1.jpg\";s:7:\"preview\";s:185:\"https://www.sliderrevolution.com/templates/photographer-and-videographer-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=photographer-and-videographer-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.4.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:169:\"<span class=\"ttm_content\">A great module for any photographer/videographer who wants to display their portfolio in an engaging way.</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"2021-02-23 10:25:31\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:77:\"How to Create a Customized Transition Effect for Your Hero Section [Tutorial]\";s:9:\"guide_url\";s:110:\"https://www.sliderrevolution.com/tutorials/how-to-create-a-customized-transition-effect-for-your-hero-section/\";s:9:\"guide_img\";s:32:\"tutorial/photographer-slider.png\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:555;a:24:{s:2:\"id\";s:3:\"555\";s:5:\"title\";s:18:\"Real Estate Slider\";s:5:\"alias\";s:17:\"realestate-slider\";s:3:\"zip\";s:21:\"realestate-slider.zip\";s:3:\"uid\";s:32:\"596effabfef768f0371cba2b1fdd0c1d\";s:3:\"img\";s:28:\"realestate-slider/slide1.jpg\";s:7:\"preview\";s:167:\"https://www.sliderrevolution.com/templates/real-estate-showcase-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=real-estate-showcase-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.4.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:152:\"<span class=\"ttm_content\">Showcase your clients real estate offerings with this clean and convincing presentation.</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-02-23 10:45:36\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:76:\"How to Create a Stunning Hero Slider for Your Real Estate Website [Tutorial]\";s:9:\"guide_url\";s:109:\"https://www.sliderrevolution.com/tutorials/how-to-create-a-stunning-hero-slider-for-your-real-estate-website/\";s:9:\"guide_img\";s:30:\"tutorial/realestate-slider.png\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:556;a:24:{s:2:\"id\";s:3:\"556\";s:5:\"title\";s:19:\"Saas Product Slider\";s:5:\"alias\";s:19:\"saas-product-slider\";s:3:\"zip\";s:23:\"saas-product-slider.zip\";s:3:\"uid\";s:32:\"3cf7809058f383425c5409aa1204335f\";s:3:\"img\";s:30:\"saas-product-slider/slide1.jpg\";s:7:\"preview\";s:151:\"https://www.sliderrevolution.com/templates/saas-product-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=saas-product-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.4.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">Present your digital SaaS product with a modern design and stunning animations.</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:349:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"},{\"path\":\"revslider-lottie-addon\\/revslider-lottie-addon.php\",\"name\":\"Slider Revolution Lottie AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"2021-02-23 10:49:44\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:557;a:27:{s:2:\"id\";s:3:\"557\";s:5:\"title\";s:27:\"Cinematic Wildlife Template\";s:5:\"alias\";s:27:\"cinematic-wildlife-template\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:27:\"cinematic-wildlife-template\";s:3:\"img\";s:39:\"packages/cinematic-wildlife-package.jpg\";s:7:\"preview\";s:163:\"https://www.sliderrevolution.com/templates/cinematic-wildlife-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=cinematic-wildlife-slider\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:185:\"<span class=\"ttm_content\">Easily create cinematic presentations with this photography-based slider, that features a convenient YouTube video popup.</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-04-16 10:45:38\";s:7:\"package\";s:27:\"Cinematic Wildlife Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:79:\"How to Create a Beautiful Content Showcase for an Online Publication [Tutorial]\";s:9:\"guide_url\";s:112:\"https://www.sliderrevolution.com/tutorials/how-to-create-a-beautiful-content-showcase-for-an-online-publication/\";s:9:\"guide_img\";s:31:\"tutorial/Cinematic-Wildlife.png\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"47\";s:9:\"installed\";b:0;}i:558;a:27:{s:2:\"id\";s:3:\"558\";s:5:\"title\";s:25:\"Cinematic Wildlife Slider\";s:5:\"alias\";s:25:\"cinematic-wildlife-slider\";s:3:\"zip\";s:35:\"packs/cinematic-wildlife-slider.zip\";s:3:\"uid\";s:32:\"a37b04e221a845d6d446f4d70e815b87\";s:3:\"img\";s:36:\"cinematic-wildlife-slider/slide1.jpg\";s:7:\"preview\";s:163:\"https://www.sliderrevolution.com/templates/cinematic-wildlife-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=cinematic-wildlife-slider\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:185:\"<span class=\"ttm_content\">Easily create cinematic presentations with this photography-based slider, that features a convenient YouTube video popup.</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-04-16 10:47:01\";s:7:\"package\";s:27:\"Cinematic Wildlife Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:79:\"How to Create a Beautiful Content Showcase for an Online Publication [Tutorial]\";s:9:\"guide_url\";s:112:\"https://www.sliderrevolution.com/tutorials/how-to-create-a-beautiful-content-showcase-for-an-online-publication/\";s:9:\"guide_img\";s:31:\"tutorial/Cinematic-Wildlife.png\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"47\";s:9:\"installed\";b:0;}i:559;a:27:{s:2:\"id\";s:3:\"559\";s:5:\"title\";s:24:\"Cinematic Wildlife Modal\";s:5:\"alias\";s:24:\"cinematic-wildlife-modal\";s:3:\"zip\";s:34:\"packs/cinematic-wildlife-modal.zip\";s:3:\"uid\";s:32:\"636a6885199f684ad743167ceea70dc4\";s:3:\"img\";s:35:\"cinematic-wildlife-modal/slide1.jpg\";s:7:\"preview\";s:163:\"https://www.sliderrevolution.com/templates/cinematic-wildlife-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=cinematic-wildlife-slider\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:185:\"<span class=\"ttm_content\">Easily create cinematic presentations with this photography-based slider, that features a convenient YouTube video popup.</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-04-16 10:50:56\";s:7:\"package\";s:27:\"Cinematic Wildlife Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"1\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:79:\"How to Create a Beautiful Content Showcase for an Online Publication [Tutorial]\";s:9:\"guide_url\";s:112:\"https://www.sliderrevolution.com/tutorials/how-to-create-a-beautiful-content-showcase-for-an-online-publication/\";s:9:\"guide_img\";s:31:\"tutorial/Cinematic-Wildlife.png\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"47\";s:9:\"installed\";b:0;}i:560;a:24:{s:2:\"id\";s:3:\"560\";s:5:\"title\";s:32:\"Gaming Stats Presentation Slider\";s:5:\"alias\";s:32:\"gaming-stats-presentation-slider\";s:3:\"zip\";s:36:\"gaming-stats-presentation-slider.zip\";s:3:\"uid\";s:32:\"988df5050f2a45a108ef32518a725bf8\";s:3:\"img\";s:43:\"gaming-stats-presentation-slider/slide1.jpg\";s:7:\"preview\";s:177:\"https://www.sliderrevolution.com/templates/charts-addon-presentation-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=charts-addon-presentation-slider\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:6:\"6.4.11\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:156:\"<span class=\"ttm_content\">Create interactive presentations and showcase statistics with unique and customizable charts</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:159:\"[{\"path\":\"revslider-charts-addon\\/revslider-charts-addon.php\",\"name\":\"Charts AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"2021-04-29 09:50:58\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:71:\"How to Create a Digital Report Teaser with Slider Revolution [Tutorial]\";s:9:\"guide_url\";s:104:\"https://www.sliderrevolution.com/tutorials/how-to-create-a-digital-report-teaser-with-slider-revolution/\";s:9:\"guide_img\";s:45:\"tutorial/gaming-stats-presentation-slider.png\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:561;a:24:{s:2:\"id\";s:3:\"561\";s:5:\"title\";s:31:\"Coffee Shop Split Screen Slider\";s:5:\"alias\";s:15:\"coffee-flavours\";s:3:\"zip\";s:19:\"coffee-flavours.zip\";s:3:\"uid\";s:32:\"63726447a6a614d8f53fbf6024fd3033\";s:3:\"img\";s:25:\"coffee-flavors/slide1.jpg\";s:7:\"preview\";s:175:\"https://www.sliderrevolution.com/templates/coffee-shop-split-screen-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coffee-shop-split-screen-slider\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.5.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:249:\"<span class=\"ttm_content\">The animated elements and clean layout make this slider an eye-catcher for your coffee shop. With it\'s easy customizability, this template is perfect for showcasing any type of product!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-06-11 09:09:52\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:562;a:24:{s:2:\"id\";s:3:\"562\";s:5:\"title\";s:32:\"Modern Portfolio Showreel Slider\";s:5:\"alias\";s:15:\"showreel-slider\";s:3:\"zip\";s:19:\"showreel-slider.zip\";s:3:\"uid\";s:32:\"bced29a585e67153a1ed7608ddcdb69d\";s:3:\"img\";s:26:\"showreel-slider/slide1.jpg\";s:7:\"preview\";s:177:\"https://www.sliderrevolution.com/templates/modern-portfolio-showreel-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=modern-portfolio-showreel-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:216:\"<span class=\"ttm_content\">Showcase beautiful videos and photography with this clean looking slider with modern UI and effective typography. Perfect for any creative professional.</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-06-11 09:14:43\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:66:\"How to Add a Beautiful Video Background to Your Website [Tutorial]\";s:9:\"guide_url\";s:108:\"https://www.sliderrevolution.com/tutorials/how-to-add-a-beautiful-video-background-to-your-website-tutorial/\";s:9:\"guide_img\";s:28:\"tutorial/showreel-slider.jpg\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:563;a:24:{s:2:\"id\";s:3:\"563\";s:5:\"title\";s:23:\"Visual Art Forms Slider\";s:5:\"alias\";s:16:\"visual-art-forms\";s:3:\"zip\";s:20:\"visual-art-forms.zip\";s:3:\"uid\";s:32:\"4d57a5abf20bc4a615fe30837ac3ce1a\";s:3:\"img\";s:27:\"visual-art-forms/slide1.jpg\";s:7:\"preview\";s:159:\"https://www.sliderrevolution.com/templates/visual-art-forms-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=visual-art-forms-slider\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.5.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:180:\"<span class=\"ttm_content\">Present just about anything with this highly flexible and modern looking slider, no matter what industry you are in.</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-06-11 09:18:19\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:564;a:24:{s:2:\"id\";s:3:\"564\";s:5:\"title\";s:22:\"Background Effect Hero\";s:5:\"alias\";s:14:\"bg-effect-hero\";s:3:\"zip\";s:18:\"bg-effect-hero.zip\";s:3:\"uid\";s:32:\"55bb0fa5ac66ad84423fa704b701e1df\";s:3:\"img\";s:25:\"bg-effect-hero/slide1.jpg\";s:7:\"preview\";s:179:\"https://www.sliderrevolution.com/templates/background-effect-hero-collection/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=background-effect-hero-collection\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:224:\"<span class=\"ttm_content\">If you really want to stun your visitors with gorgeous gradients and dreamy transitions, <br />\r\nthis slider / hero module is exactly what you were looking for.</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:4:\"hero\";}s:14:\"plugin_require\";s:703:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"},{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"},{\"path\":\"revslider-mousetrap-addon\\/revslider-mousetrap-addon.php\",\"name\":\"Mousetrap AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"},{\"path\":\"revslider-transitionpack-addon\\/revslider-transitionpack-addon.php\",\"name\":\"Advanced Transitions AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"2021-08-09 10:45:50\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:60:\"How to Create a Unique Gradient Background Design [Tutorial]\";s:9:\"guide_url\";s:63:\"https://www.sliderrevolution.com/tutorials/gradient-background/\";s:9:\"guide_img\";s:27:\"tutorial/bg-effect-hero.png\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:565;a:24:{s:2:\"id\";s:3:\"565\";s:5:\"title\";s:26:\"Cyber Glitch Effect Slider\";s:5:\"alias\";s:9:\"cyberfunk\";s:3:\"zip\";s:13:\"cyberfunk.zip\";s:3:\"uid\";s:32:\"44fdc7e13074bdc46500972cd708c739\";s:3:\"img\";s:20:\"cyberfunk/slide1.jpg\";s:7:\"preview\";s:165:\"https://www.sliderrevolution.com/templates/cyber-glitch-effect-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=cyber-glitch-effect-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">Dive into a futuristic, neon, cyber world with this amazing slider template featuring <br />\r\nglitch effect transitions and a typewriter effect.<br />\r\nThe custom navigation skin can be customized easily!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:4:\"hero\";}s:14:\"plugin_require\";s:361:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"},{\"path\":\"revslider-transitionpack-addon\\/revslider-transitionpack-addon.php\",\"name\":\"Advanced Transitions AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"2021-08-09 10:51:54\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:72:\"How to Create a Futuristic-looking Website for a Tech Company [Tutorial]\";s:9:\"guide_url\";s:105:\"https://www.sliderrevolution.com/tutorials/how-to-create-a-futuristic-looking-website-for-a-tech-company/\";s:9:\"guide_img\";s:22:\"tutorial/cyberfunk.jpg\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:566;a:24:{s:2:\"id\";s:3:\"566\";s:5:\"title\";s:30:\"Motion Blur Portfolio Showcase\";s:5:\"alias\";s:21:\"motion-blur-portfolio\";s:3:\"zip\";s:25:\"motion-blur-portfolio.zip\";s:3:\"uid\";s:32:\"28086bed49cfb241c7d40f91cd64e970\";s:3:\"img\";s:32:\"motion-blur-portfolio/slide1.jpg\";s:7:\"preview\";s:173:\"https://www.sliderrevolution.com/templates/motion-blur-portfolio-showcase/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=motion-blur-portfolio-showcase\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.5.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:238:\"<span class=\"ttm_content\">This clean showcase slider with an optional video popup is using a fancy motion blur transition!<br />\r\nPacked with a logo and menu its ready to visualize your wildest ideas.</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:4:\"hero\";}s:14:\"plugin_require\";s:356:\"[{\"path\":\"revslider-mousetrap-addon\\/revslider-mousetrap-addon.php\",\"name\":\"Mousetrap AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"},{\"path\":\"revslider-transitionpack-addon\\/revslider-transitionpack-addon.php\",\"name\":\"Advanced Transitions AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"2021-08-09 10:56:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:75:\"A Different Way to Wow Shoppers with an eCommerce Product Slider [Tutorial]\";s:9:\"guide_url\";s:108:\"https://www.sliderrevolution.com/tutorials/a-different-way-to-wow-shoppers-with-an-ecommerce-product-slider/\";s:9:\"guide_img\";s:34:\"tutorial/motion-blur-portfolio.jpg\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:567;a:24:{s:2:\"id\";s:3:\"567\";s:5:\"title\";s:25:\"Portal Effect Hero Slider\";s:5:\"alias\";s:18:\"portal-effect-hero\";s:3:\"zip\";s:22:\"portal-effect-hero.zip\";s:3:\"uid\";s:32:\"87f5b64e44dc5b75bc1c7adbeb287ee9\";s:3:\"img\";s:29:\"portal-effect-hero/slide1.jpg\";s:7:\"preview\";s:163:\"https://www.sliderrevolution.com/templates/portal-effect-hero-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=portal-effect-hero-slider\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.5.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:282:\"<span class=\"ttm_content\">This slider module can function as an impressive landing page or a striking product presentation anywhere on your WordPress website.<br />\r\nThe design already includes elements like a logo, menu and social media icons.</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:4:\"hero\";}s:14:\"plugin_require\";s:189:\"[{\"path\":\"revslider-transitionpack-addon\\/revslider-transitionpack-addon.php\",\"name\":\"Advanced Transitions AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"2021-08-09 11:08:18\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:67:\"Demystifying the Slider Revolution Builder and Templates [Tutorial]\";s:9:\"guide_url\";s:109:\"https://www.sliderrevolution.com/tutorials/demystifying-the-slider-revolution-builder-and-templates-tutorial/\";s:9:\"guide_img\";s:31:\"tutorial/portal-effect-hero.jpg\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:568;a:24:{s:2:\"id\";s:3:\"568\";s:5:\"title\";s:22:\"Winery Timeline Slider\";s:5:\"alias\";s:15:\"winery-timeline\";s:3:\"zip\";s:19:\"winery-timeline.zip\";s:3:\"uid\";s:32:\"d2ccdaf0a5c73db21e8e8a3f6712e8bd\";s:3:\"img\";s:26:\"winery-timeline/slide1.jpg\";s:7:\"preview\";s:157:\"https://www.sliderrevolution.com/templates/winery-timeline-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=winery-timeline-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:247:\"<span class=\"ttm_content\">Tell your own story with this fabulous timeline slider.<br />\r\nLogo and social icon design elements are already included if you want to use this template as a standalone landing page!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:4:\"hero\";}s:14:\"plugin_require\";s:356:\"[{\"path\":\"revslider-mousetrap-addon\\/revslider-mousetrap-addon.php\",\"name\":\"Mousetrap AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"},{\"path\":\"revslider-transitionpack-addon\\/revslider-transitionpack-addon.php\",\"name\":\"Advanced Transitions AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"2021-08-09 11:13:39\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:79:\"How to Create a Vertical Slider Timeline That Tells Your Brand Story [Tutorial]\";s:9:\"guide_url\";s:112:\"https://www.sliderrevolution.com/tutorials/how-to-create-a-vertical-slider-timeline-that-tells-your-brand-story/\";s:9:\"guide_img\";s:28:\"tutorial/winery-timeline.png\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:569;a:27:{s:2:\"id\";s:3:\"569\";s:5:\"title\";s:25:\"Smart Living One Pager V1\";s:5:\"alias\";s:25:\"smart-living-one-pager-v1\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:25:\"smart-living-one-pager-v1\";s:3:\"img\";s:38:\"packages/Smart-Living-One-Pager-V1.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v1/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v1\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";s:189:\"[{\"path\":\"revslider-transitionpack-addon\\/revslider-transitionpack-addon.php\",\"name\":\"Advanced Transitions AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"2021-09-07 14:33:48\";s:7:\"package\";s:25:\"Smart Living One Pager V1\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"48\";s:9:\"installed\";b:0;}i:570;a:27:{s:2:\"id\";s:3:\"570\";s:5:\"title\";s:25:\"Smart Living One Pager V2\";s:5:\"alias\";s:25:\"smart-living-one-pager-v2\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:25:\"smart-living-one-pager-v2\";s:3:\"img\";s:38:\"packages/Smart-Living-One-Pager-V2.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v2/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v2\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";s:189:\"[{\"path\":\"revslider-transitionpack-addon\\/revslider-transitionpack-addon.php\",\"name\":\"Advanced Transitions AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"2021-09-07 14:38:21\";s:7:\"package\";s:25:\"Smart Living One Pager V2\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"49\";s:9:\"installed\";b:0;}i:571;a:27:{s:2:\"id\";s:3:\"571\";s:5:\"title\";s:25:\"Smart Living One Pager V3\";s:5:\"alias\";s:25:\"smart-living-one-pager-v3\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:25:\"smart-living-one-pager-v3\";s:3:\"img\";s:38:\"packages/Smart-Living-One-Pager-V3.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v3/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v3\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";s:189:\"[{\"path\":\"revslider-transitionpack-addon\\/revslider-transitionpack-addon.php\",\"name\":\"Advanced Transitions AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"2021-09-07 14:39:44\";s:7:\"package\";s:25:\"Smart Living One Pager V3\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"50\";s:9:\"installed\";b:0;}i:572;a:27:{s:2:\"id\";s:3:\"572\";s:5:\"title\";s:6:\"Menu 1\";s:5:\"alias\";s:6:\"menu-1\";s:3:\"zip\";s:16:\"packs/menu-1.zip\";s:3:\"uid\";s:32:\"6e5038d711f2ee8326c79c3a9e06ded4\";s:3:\"img\";s:17:\"menu-1/slide1.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v1/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v1\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-09-07 14:41:12\";s:7:\"package\";s:25:\"Smart Living One Pager V1\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"48\";s:9:\"installed\";b:0;}i:573;a:27:{s:2:\"id\";s:3:\"573\";s:5:\"title\";s:6:\"Hero 1\";s:5:\"alias\";s:14:\"onepage-hero-1\";s:3:\"zip\";s:24:\"packs/onepage-hero-1.zip\";s:3:\"uid\";s:32:\"9f5fec6956bd2e1e1ecc553a8b7471b0\";s:3:\"img\";s:25:\"onepage-hero-1/slide1.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v1/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v1\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:189:\"[{\"path\":\"revslider-transitionpack-addon\\/revslider-transitionpack-addon.php\",\"name\":\"Advanced Transitions AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"2021-09-07 14:48:41\";s:7:\"package\";s:25:\"Smart Living One Pager V1\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"48\";s:9:\"installed\";b:0;}i:574;a:27:{s:2:\"id\";s:3:\"574\";s:5:\"title\";s:7:\"About 1\";s:5:\"alias\";s:6:\"about1\";s:3:\"zip\";s:16:\"packs/about1.zip\";s:3:\"uid\";s:32:\"fc4962093f61124101c05ceb506fa5d2\";s:3:\"img\";s:17:\"about1/slide1.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v1/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v1\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-09-07 14:50:54\";s:7:\"package\";s:25:\"Smart Living One Pager V1\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"48\";s:9:\"installed\";b:0;}i:575;a:27:{s:2:\"id\";s:3:\"575\";s:5:\"title\";s:10:\"Services 1\";s:5:\"alias\";s:9:\"services1\";s:3:\"zip\";s:19:\"packs/services1.zip\";s:3:\"uid\";s:32:\"08f72a81aeb9afdaa57f544e4331a6da\";s:3:\"img\";s:20:\"services1/slide1.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v1/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v1\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-09-07 14:52:41\";s:7:\"package\";s:25:\"Smart Living One Pager V1\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"48\";s:9:\"installed\";b:0;}i:576;a:27:{s:2:\"id\";s:3:\"576\";s:5:\"title\";s:10:\"Projects 1\";s:5:\"alias\";s:9:\"projects1\";s:3:\"zip\";s:19:\"packs/projects1.zip\";s:3:\"uid\";s:32:\"11ff60e82fcf47a6a2c6bdce3cc1d8f2\";s:3:\"img\";s:20:\"projects1/slide1.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v1/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v1\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-09-07 15:01:48\";s:7:\"package\";s:25:\"Smart Living One Pager V1\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"48\";s:9:\"installed\";b:0;}i:577;a:27:{s:2:\"id\";s:3:\"577\";s:5:\"title\";s:8:\"Footer 1\";s:5:\"alias\";s:8:\"footer-1\";s:3:\"zip\";s:18:\"packs/footer-1.zip\";s:3:\"uid\";s:32:\"947fac99689a985c7f0f7dfec4311f6b\";s:3:\"img\";s:19:\"footer-1/slide1.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v1/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v1\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-09-07 15:05:00\";s:7:\"package\";s:25:\"Smart Living One Pager V1\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"48\";s:9:\"installed\";b:0;}i:578;a:28:{s:2:\"id\";s:3:\"578\";s:5:\"title\";s:24:\"Explainer Block 1 Part 1\";s:5:\"alias\";s:23:\"explainer-block-1-part1\";s:3:\"zip\";s:33:\"packs/explainer-block-1-part1.zip\";s:3:\"uid\";s:32:\"731980bef0ea06263d05b286b5a75dfe\";s:3:\"img\";s:34:\"explainer-block-1-part1/slide1.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v1/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v1\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:126:\"<span class=\"ttm_content\">An elegant slider for your website. Flexible and customizable.</span><span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-09-07 15:06:07\";s:7:\"package\";s:25:\"Smart Living One Pager V1\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"48\";s:9:\"installed\";b:0;}i:579;a:28:{s:2:\"id\";s:3:\"579\";s:5:\"title\";s:24:\"Explainer Block 1 Part 2\";s:5:\"alias\";s:23:\"explainer-block-1-part2\";s:3:\"zip\";s:33:\"packs/explainer-block-1-part2.zip\";s:3:\"uid\";s:32:\"ded730f13551f78b9a87b159b72d8ce8\";s:3:\"img\";s:34:\"explainer-block-1-part2/slide1.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v1/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v1\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:126:\"<span class=\"ttm_content\">An elegant slider for your website. Flexible and customizable.</span><span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-09-07 15:07:26\";s:7:\"package\";s:25:\"Smart Living One Pager V1\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"48\";s:9:\"installed\";b:0;}i:580;a:27:{s:2:\"id\";s:3:\"580\";s:5:\"title\";s:16:\"Projects Modal 1\";s:5:\"alias\";s:16:\"projects-modal-1\";s:3:\"zip\";s:26:\"packs/projects-modal-1.zip\";s:3:\"uid\";s:32:\"b17af2f4e21786711a2ce4ac0c4436ad\";s:3:\"img\";s:27:\"projects-modal-1/slide1.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v1/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v1\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-09-07 15:08:26\";s:7:\"package\";s:25:\"Smart Living One Pager V1\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"1\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"48\";s:9:\"installed\";b:0;}i:581;a:27:{s:2:\"id\";s:3:\"581\";s:5:\"title\";s:6:\"Menu 2\";s:5:\"alias\";s:6:\"menu-2\";s:3:\"zip\";s:16:\"packs/menu-2.zip\";s:3:\"uid\";s:32:\"a8d103f753ee50d4f81aa4100df8b7f9\";s:3:\"img\";s:17:\"menu-2/slide1.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v2/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v2\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-09-07 15:20:20\";s:7:\"package\";s:25:\"Smart Living One Pager V2\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"49\";s:9:\"installed\";b:0;}i:582;a:27:{s:2:\"id\";s:3:\"582\";s:5:\"title\";s:6:\"Hero 2\";s:5:\"alias\";s:6:\"hero-2\";s:3:\"zip\";s:16:\"packs/hero-2.zip\";s:3:\"uid\";s:32:\"7e56900f8c4b6e12435b70e141accaa8\";s:3:\"img\";s:17:\"hero-2/slide1.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v2/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v2\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:189:\"[{\"path\":\"revslider-transitionpack-addon\\/revslider-transitionpack-addon.php\",\"name\":\"Advanced Transitions AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"2021-09-07 15:27:59\";s:7:\"package\";s:25:\"Smart Living One Pager V2\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"49\";s:9:\"installed\";b:0;}i:583;a:27:{s:2:\"id\";s:3:\"583\";s:5:\"title\";s:10:\"Services 2\";s:5:\"alias\";s:10:\"services-2\";s:3:\"zip\";s:20:\"packs/services-2.zip\";s:3:\"uid\";s:32:\"da2d588b291a7754096ac77746ba1da5\";s:3:\"img\";s:34:\"services-2/services2-thumbnail.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v2/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v2\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-09-07 15:29:09\";s:7:\"package\";s:25:\"Smart Living One Pager V2\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"49\";s:9:\"installed\";b:0;}i:584;a:27:{s:2:\"id\";s:3:\"584\";s:5:\"title\";s:7:\"About 2\";s:5:\"alias\";s:7:\"about-2\";s:3:\"zip\";s:17:\"packs/about-2.zip\";s:3:\"uid\";s:32:\"8e9e84d1aec08de6e099473683bf0e57\";s:3:\"img\";s:18:\"about-2/slide1.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v2/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v2\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-09-07 15:30:15\";s:7:\"package\";s:25:\"Smart Living One Pager V2\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"49\";s:9:\"installed\";b:0;}i:585;a:27:{s:2:\"id\";s:3:\"585\";s:5:\"title\";s:10:\"Projects 2\";s:5:\"alias\";s:10:\"projects-2\";s:3:\"zip\";s:20:\"packs/projects-2.zip\";s:3:\"uid\";s:32:\"99bc6ca75f6d5e018701aef5f5b22b27\";s:3:\"img\";s:21:\"projects-2/slide1.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v2/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v2\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-09-07 15:32:06\";s:7:\"package\";s:25:\"Smart Living One Pager V2\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"49\";s:9:\"installed\";b:0;}i:586;a:27:{s:2:\"id\";s:3:\"586\";s:5:\"title\";s:8:\"Footer 2\";s:5:\"alias\";s:7:\"footer2\";s:3:\"zip\";s:17:\"packs/footer2.zip\";s:3:\"uid\";s:32:\"99df496d2fd9e897a2debb66958cb610\";s:3:\"img\";s:18:\"footer2/slide1.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v2/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v2\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-09-07 15:34:09\";s:7:\"package\";s:25:\"Smart Living One Pager V2\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"49\";s:9:\"installed\";b:0;}i:587;a:29:{s:2:\"id\";s:3:\"587\";s:5:\"title\";s:24:\"Explainer Block 2 Part 1\";s:5:\"alias\";s:23:\"explainer-block-2-part1\";s:3:\"zip\";s:33:\"packs/explainer-block-2-part1.zip\";s:3:\"uid\";s:32:\"aee4d41e9cf5f91ad69bfbe96d1dc1b8\";s:3:\"img\";s:34:\"explainer-block-2-part1/slide1.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v2/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v2\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:0:\"\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-09-07 15:35:48\";s:7:\"package\";s:25:\"Smart Living One Pager V2\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"49\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:588;a:27:{s:2:\"id\";s:3:\"588\";s:5:\"title\";s:24:\"Explainer Block 2 Part 2\";s:5:\"alias\";s:23:\"explainer-block-2-part2\";s:3:\"zip\";s:33:\"packs/explainer-block-2-part2.zip\";s:3:\"uid\";s:32:\"b12ac82484c5d2609994978f95026057\";s:3:\"img\";s:34:\"explainer-block-2-part2/slide1.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v2/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v2\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-09-07 15:37:05\";s:7:\"package\";s:25:\"Smart Living One Pager V2\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"49\";s:9:\"installed\";b:0;}i:589;a:27:{s:2:\"id\";s:3:\"589\";s:5:\"title\";s:16:\"Projects Modal 2\";s:5:\"alias\";s:16:\"projects-modal-2\";s:3:\"zip\";s:26:\"packs/projects-modal-2.zip\";s:3:\"uid\";s:32:\"ac164d7043a8958ae2931e4be54bf56e\";s:3:\"img\";s:27:\"projects-modal-2/slide1.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v2/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v2\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-09-07 15:38:22\";s:7:\"package\";s:25:\"Smart Living One Pager V2\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"1\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"49\";s:9:\"installed\";b:0;}i:590;a:27:{s:2:\"id\";s:3:\"590\";s:5:\"title\";s:6:\"Menu 3\";s:5:\"alias\";s:6:\"menu-3\";s:3:\"zip\";s:16:\"packs/menu-3.zip\";s:3:\"uid\";s:32:\"7300529d564642c76e61890cf0ef57cf\";s:3:\"img\";s:17:\"menu-3/slide1.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v3/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v3\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-09-07 15:42:03\";s:7:\"package\";s:25:\"Smart Living One Pager V3\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"50\";s:9:\"installed\";b:0;}i:591;a:27:{s:2:\"id\";s:3:\"591\";s:5:\"title\";s:6:\"Hero 3\";s:5:\"alias\";s:6:\"hero-3\";s:3:\"zip\";s:16:\"packs/hero-3.zip\";s:3:\"uid\";s:32:\"08db05794abf4e6c10788cbd423f92b2\";s:3:\"img\";s:17:\"hero-3/slide1.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v3/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v3\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-09-07 15:46:06\";s:7:\"package\";s:25:\"Smart Living One Pager V3\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"50\";s:9:\"installed\";b:0;}i:592;a:27:{s:2:\"id\";s:3:\"592\";s:5:\"title\";s:7:\"About 3\";s:5:\"alias\";s:7:\"about-3\";s:3:\"zip\";s:17:\"packs/about-3.zip\";s:3:\"uid\";s:32:\"dac01fc9b9d664f271e1ea6a1bbb850c\";s:3:\"img\";s:18:\"about-3/slide1.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v3/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v3\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-09-07 15:47:44\";s:7:\"package\";s:25:\"Smart Living One Pager V3\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"50\";s:9:\"installed\";b:0;}i:593;a:27:{s:2:\"id\";s:3:\"593\";s:5:\"title\";s:10:\"Services 3\";s:5:\"alias\";s:10:\"services-3\";s:3:\"zip\";s:20:\"packs/services-3.zip\";s:3:\"uid\";s:32:\"4bad1c4a765cef7d93d3c7e2a0e76b83\";s:3:\"img\";s:21:\"services-3/slide1.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v3/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v3\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-09-07 15:50:03\";s:7:\"package\";s:25:\"Smart Living One Pager V3\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"50\";s:9:\"installed\";b:0;}i:594;a:27:{s:2:\"id\";s:3:\"594\";s:5:\"title\";s:10:\"Projects 3\";s:5:\"alias\";s:10:\"projects-3\";s:3:\"zip\";s:20:\"packs/projects-3.zip\";s:3:\"uid\";s:32:\"e3337a84122e580679474dea8d7bf37c\";s:3:\"img\";s:21:\"projects-3/slide1.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v3/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v3\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-09-07 15:51:31\";s:7:\"package\";s:25:\"Smart Living One Pager V3\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"50\";s:9:\"installed\";b:0;}i:595;a:27:{s:2:\"id\";s:3:\"595\";s:5:\"title\";s:8:\"Footer 3\";s:5:\"alias\";s:8:\"footer-3\";s:3:\"zip\";s:18:\"packs/footer-3.zip\";s:3:\"uid\";s:32:\"524f4445a5565bf3ef1dcd7b2f0228cc\";s:3:\"img\";s:19:\"footer-3/slide1.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v3/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v3\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-09-07 15:53:03\";s:7:\"package\";s:25:\"Smart Living One Pager V3\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"50\";s:9:\"installed\";b:0;}i:596;a:27:{s:2:\"id\";s:3:\"596\";s:5:\"title\";s:24:\"Explainer Block 3 Part 1\";s:5:\"alias\";s:23:\"explainer-block-3-part1\";s:3:\"zip\";s:33:\"packs/explainer-block-3-part1.zip\";s:3:\"uid\";s:32:\"b1469a955fecb4e1d645a604804716de\";s:3:\"img\";s:34:\"explainer-block-3-part1/slide1.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v3/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v3\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-09-07 15:54:20\";s:7:\"package\";s:25:\"Smart Living One Pager V3\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"50\";s:9:\"installed\";b:0;}i:597;a:27:{s:2:\"id\";s:3:\"597\";s:5:\"title\";s:24:\"Explainer Block 3 Part 2\";s:5:\"alias\";s:23:\"explainer-block-3-part2\";s:3:\"zip\";s:33:\"packs/explainer-block-3-part2.zip\";s:3:\"uid\";s:32:\"3faa6f1dc248ef2ba3d50cc60db557b1\";s:3:\"img\";s:34:\"explainer-block-3-part2/slide1.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v3/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v3\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_space\"></span>\";s:3:\"cat\";s:14:\"Slider Package\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2021-09-07 15:55:33\";s:7:\"package\";s:25:\"Smart Living One Pager V3\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"50\";s:9:\"installed\";b:0;}i:598;a:27:{s:2:\"id\";s:3:\"598\";s:5:\"title\";s:16:\"Projects Modal 3\";s:5:\"alias\";s:16:\"projects-modal-3\";s:3:\"zip\";s:26:\"packs/projects-modal-3.zip\";s:3:\"uid\";s:32:\"b22bb57c30e75bf7d7ba7d240a21b3fe\";s:3:\"img\";s:27:\"projects-modal-3/slide1.jpg\";s:7:\"preview\";s:207:\"https://www.sliderrevolution.com/templates/smart-living-one-page-template-for-wordpress-v3/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=smart-living-one-page-template-for-wordpress-v3\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.5.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:350:\"<span class=\"ttm_content\">Never build a one pager from scratch again!<br>\r\nSlider Revolution for WordPress is a modular, fully visual content builder, that allows you to create pro-level one-pagers like this one in no time.<br>\r\n20 different \"Smart Living\" modules are included and come in 3 example page setups!</span><span class=\"ttm_spac