/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-09-07 18:40:07 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wpge_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3315 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=937 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=1849 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_ai1ic` (
  `ai1ic_key` varchar(190) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `ai1ic_secrets` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `ai1ic_time` int unsigned NOT NULL,
  PRIMARY KEY (`ai1ic_key`),
  KEY `ai1ic_time` (`ai1ic_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=298 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=80 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_datalist` (
  `url` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `content` longtext NOT NULL,
  `full_content` smallint NOT NULL,
  PRIMARY KEY (`url`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wpge_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_elfsight_yottie_widgets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `time_created` varchar(10) NOT NULL,
  `time_updated` varchar(10) NOT NULL,
  `active` int NOT NULL DEFAULT '1',
  `options` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wpge_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=187812 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=4276 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=2903 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_revslider_css` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `hover` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `params` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `advanced` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=MyISAM AUTO_INCREMENT=110 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_revslider_css_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `hover` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `params` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `advanced` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=MyISAM AUTO_INCREMENT=110 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_revslider_layer_animations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_revslider_layer_animations_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_revslider_navigations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `handle` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `css` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `markup` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_revslider_navigations_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `handle` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `css` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `markup` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_revslider_sliders` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `params` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_revslider_sliders_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `params` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_revslider_slides` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `slide_order` int NOT NULL,
  `params` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `layers` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_revslider_slides_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `slide_order` int NOT NULL,
  `params` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `layers` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_revslider_static_slides` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `params` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `layers` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_revslider_static_slides_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `params` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `layers` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `settings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=150 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=122 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=150 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=57 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_wc_admin_note_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actioned_text` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonce_action` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `nonce_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=91759 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_admin_notes` (
  `note_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'info',
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=185 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_category_lookup` (
  `category_tree_id` bigint unsigned NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_customer_lookup` (
  `customer_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `username` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_download_log` (
  `download_log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_wc_order_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `address_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `first_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `last_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `company` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `address_1` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `address_2` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `city` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `state` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `postcode` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `country` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `email` varchar(320) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `phone` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_order_coupon_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `coupon_id` bigint NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_order_operational_data` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `created_via` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `woocommerce_version` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_order_product_lookup` (
  `order_item_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_order_stats` (
  `order_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_order_tax_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_orders` (
  `id` bigint unsigned NOT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `currency` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `billing_email` varchar(320) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint unsigned DEFAULT NULL,
  `payment_method` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_method_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `transaction_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ip_address` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `customer_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_orders_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_product_attributes_lookup` (
  `product_id` bigint NOT NULL,
  `product_or_parent_id` bigint NOT NULL,
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `term_id` bigint NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_product_download_directories` (
  `url_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_product_meta_lookup` (
  `product_id` bigint NOT NULL,
  `sku` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint DEFAULT '0',
  `tax_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `global_unique_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_rate_limits` (
  `rate_limit_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `rate_limit_expiry` bigint unsigned NOT NULL,
  `rate_limit_remaining` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_reserved_stock` (
  `order_id` bigint NOT NULL,
  `product_id` bigint NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wpge_wc_webhooks` (
  `webhook_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `delivery_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `topic` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint NOT NULL,
  `failure_count` smallint NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_woocommerce_api_keys` (
  `key_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `description` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `permissions` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `consumer_key` char(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `consumer_secret` char(43) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nonces` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `truncated_key` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_label` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attribute_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_orderby` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute_public` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_email` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_woocommerce_log` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint NOT NULL,
  `source` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `context` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_woocommerce_order_itemmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_woocommerce_order_items` (
  `order_item_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `order_item_type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `order_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_woocommerce_payment_tokenmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_woocommerce_payment_tokens` (
  `token_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_woocommerce_sessions` (
  `session_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `session_expiry` bigint unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM AUTO_INCREMENT=69 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_woocommerce_shipping_zone_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint unsigned NOT NULL,
  `location_code` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `location_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20)),
  KEY `zone_id` (`zone_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_woocommerce_shipping_zone_methods` (
  `zone_id` bigint unsigned NOT NULL,
  `instance_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `method_order` bigint unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_woocommerce_shipping_zones` (
  `zone_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `zone_order` bigint unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_woocommerce_tax_rate_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `location_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wpge_woocommerce_tax_rates` (
  `tax_rate_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint unsigned NOT NULL,
  `tax_rate_compound` int NOT NULL DEFAULT '0',
  `tax_rate_shipping` int NOT NULL DEFAULT '1',
  `tax_rate_order` bigint unsigned NOT NULL,
  `tax_rate_class` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wpge_actionscheduler_actions */
INSERT INTO `wpge_actionscheduler_actions` VALUES("2905", "wc-admin_import_customers", "complete", "2025-08-29 03:39:03", "2025-08-29 03:39:03", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756438743;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756438743;}", "4", "1", "2025-08-29 03:40:15", "2025-08-29 03:40:15", "0", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2906", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-29 13:17:22", "2025-08-29 13:17:22", "[2648,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473442;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473442;}", "2", "1", "2025-08-29 13:18:24", "2025-08-29 13:18:24", "0", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2907", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-29 13:17:22", "2025-08-29 13:17:22", "[2646,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473442;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473442;}", "2", "1", "2025-08-29 13:18:24", "2025-08-29 13:18:24", "0", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2908", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-29 13:17:22", "2025-08-29 13:17:22", "[2644,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473442;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473442;}", "2", "1", "2025-08-29 13:18:24", "2025-08-29 13:18:24", "0", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2909", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-29 13:17:22", "2025-08-29 13:17:22", "[2642,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473442;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473442;}", "2", "1", "2025-08-29 13:18:24", "2025-08-29 13:18:24", "0", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2910", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-29 13:17:22", "2025-08-29 13:17:22", "[2637,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473442;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473442;}", "2", "1", "2025-08-29 13:18:25", "2025-08-29 13:18:25", "0", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2911", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-29 13:17:22", "2025-08-29 13:17:22", "[2635,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473442;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473442;}", "2", "1", "2025-08-29 13:18:25", "2025-08-29 13:18:25", "0", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2912", "wc_schedule_update_product_default_cat", "complete", "2025-08-29 13:17:48", "2025-08-29 13:17:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473468;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473468;}", "5", "1", "2025-08-29 13:18:25", "2025-08-29 13:18:25", "0", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2913", "wc_schedule_update_product_default_cat", "complete", "2025-08-29 13:17:48", "2025-08-29 13:17:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473468;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473468;}", "5", "1", "2025-08-29 13:18:25", "2025-08-29 13:18:25", "0", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2914", "wc_schedule_update_product_default_cat", "complete", "2025-08-29 13:17:48", "2025-08-29 13:17:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473468;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473468;}", "5", "1", "2025-08-29 13:18:25", "2025-08-29 13:18:25", "0", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2915", "wc_schedule_update_product_default_cat", "complete", "2025-08-29 13:17:48", "2025-08-29 13:17:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473468;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473468;}", "5", "1", "2025-08-29 13:18:25", "2025-08-29 13:18:25", "0", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2916", "wc_schedule_update_product_default_cat", "complete", "2025-08-29 13:17:48", "2025-08-29 13:17:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473468;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473468;}", "5", "1", "2025-08-29 13:18:25", "2025-08-29 13:18:25", "0", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2917", "wc_schedule_update_product_default_cat", "complete", "2025-08-29 13:17:48", "2025-08-29 13:17:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473468;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473468;}", "5", "1", "2025-08-29 13:18:25", "2025-08-29 13:18:25", "0", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2918", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:02", "2025-08-29 13:22:02", "{\"update_callback\":\"wc_update_600_migrate_rate_limit_options\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473722;}", "2", "1", "2025-08-29 13:22:06", "2025-08-29 13:22:06", "90100", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2919", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:03", "2025-08-29 13:22:03", "{\"update_callback\":\"wc_admin_update_270_delete_report_downloads\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473723;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473723;}", "2", "1", "2025-08-29 13:22:06", "2025-08-29 13:22:06", "90100", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2920", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:04", "2025-08-29 13:22:04", "{\"update_callback\":\"wc_admin_update_271_update_task_list_options\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473724;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473724;}", "2", "1", "2025-08-29 13:22:06", "2025-08-29 13:22:06", "90100", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2921", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:05", "2025-08-29 13:22:05", "{\"update_callback\":\"wc_admin_update_280_order_status\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473725;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473725;}", "2", "1", "2025-08-29 13:22:06", "2025-08-29 13:22:06", "90100", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2922", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:06", "2025-08-29 13:22:06", "{\"update_callback\":\"wc_admin_update_290_update_apperance_task_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473726;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473726;}", "2", "1", "2025-08-29 13:22:06", "2025-08-29 13:22:06", "90100", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2923", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:07", "2025-08-29 13:22:07", "{\"update_callback\":\"wc_admin_update_290_delete_default_homepage_layout_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473727;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473727;}", "2", "1", "2025-08-29 13:22:08", "2025-08-29 13:22:08", "90101", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2924", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:08", "2025-08-29 13:22:08", "{\"update_callback\":\"wc_update_600_db_version\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473728;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473728;}", "2", "1", "2025-08-29 13:22:08", "2025-08-29 13:22:08", "90101", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2925", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:09", "2025-08-29 13:22:09", "{\"update_callback\":\"wc_update_630_create_product_attributes_lookup_table\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473729;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473729;}", "2", "1", "2025-08-29 13:22:12", "2025-08-29 13:22:12", "90103", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2926", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:10", "2025-08-29 13:22:10", "{\"update_callback\":\"wc_admin_update_300_update_is_read_from_last_read\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473730;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473730;}", "2", "1", "2025-08-29 13:22:12", "2025-08-29 13:22:12", "90103", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2927", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:11", "2025-08-29 13:22:11", "{\"update_callback\":\"wc_update_630_db_version\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473731;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473731;}", "2", "1", "2025-08-29 13:22:12", "2025-08-29 13:22:12", "90103", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2928", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:12", "2025-08-29 13:22:12", "{\"update_callback\":\"wc_update_640_add_primary_key_to_product_attributes_lookup_table\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473732;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473732;}", "2", "1", "2025-08-29 13:22:12", "2025-08-29 13:22:12", "90103", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2929", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:13", "2025-08-29 13:22:13", "{\"update_callback\":\"wc_admin_update_340_remove_is_primary_from_note_action\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473733;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473733;}", "2", "1", "2025-08-29 13:22:17", "2025-08-29 13:22:17", "90105", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2930", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:14", "2025-08-29 13:22:14", "{\"update_callback\":\"wc_update_640_db_version\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473734;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473734;}", "2", "1", "2025-08-29 13:22:17", "2025-08-29 13:22:17", "90105", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2931", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:15", "2025-08-29 13:22:15", "{\"update_callback\":\"wc_update_650_approved_download_directories\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473735;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473735;}", "2", "1", "2025-08-29 13:22:17", "2025-08-29 13:22:17", "90105", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2932", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:16", "2025-08-29 13:22:16", "{\"update_callback\":\"wc_update_651_approved_download_directories\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473736;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473736;}", "2", "1", "2025-08-29 13:22:17", "2025-08-29 13:22:17", "90105", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2933", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:17", "2025-08-29 13:22:17", "{\"update_callback\":\"wc_update_670_purge_comments_count_cache\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473737;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473737;}", "2", "1", "2025-08-29 13:22:17", "2025-08-29 13:22:17", "90105", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2934", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:18", "2025-08-29 13:22:18", "{\"update_callback\":\"wc_update_670_delete_deprecated_remote_inbox_notifications_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473738;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473738;}", "2", "1", "2025-08-29 13:22:23", "2025-08-29 13:22:23", "90108", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2935", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:19", "2025-08-29 13:22:19", "{\"update_callback\":\"wc_update_700_remove_download_log_fk\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473739;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473739;}", "2", "1", "2025-08-29 13:22:23", "2025-08-29 13:22:23", "90108", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2936", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:20", "2025-08-29 13:22:20", "{\"update_callback\":\"wc_update_700_remove_recommended_marketing_plugins_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473740;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473740;}", "2", "1", "2025-08-29 13:22:23", "2025-08-29 13:22:23", "90108", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2937", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:21", "2025-08-29 13:22:21", "{\"update_callback\":\"wc_update_721_adjust_new_zealand_states\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473741;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473741;}", "2", "1", "2025-08-29 13:22:23", "2025-08-29 13:22:23", "90108", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2938", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:22", "2025-08-29 13:22:22", "{\"update_callback\":\"wc_update_721_adjust_ukraine_states\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473742;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473742;}", "2", "1", "2025-08-29 13:22:23", "2025-08-29 13:22:23", "90108", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2939", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:23", "2025-08-29 13:22:23", "{\"update_callback\":\"wc_update_722_adjust_new_zealand_states\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473743;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473743;}", "2", "1", "2025-08-29 13:22:23", "2025-08-29 13:22:23", "90108", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2940", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:24", "2025-08-29 13:22:24", "{\"update_callback\":\"wc_update_722_adjust_ukraine_states\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473744;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473744;}", "2", "1", "2025-08-29 13:22:28", "2025-08-29 13:22:28", "90110", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2941", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:25", "2025-08-29 13:22:25", "{\"update_callback\":\"wc_update_750_add_columns_to_order_stats_table\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473745;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473745;}", "2", "1", "2025-08-29 13:22:28", "2025-08-29 13:22:28", "90110", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2942", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:26", "2025-08-29 13:22:26", "{\"update_callback\":\"wc_update_750_disable_new_product_management_experience\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473746;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473746;}", "2", "1", "2025-08-29 13:22:28", "2025-08-29 13:22:28", "90110", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2943", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:27", "2025-08-29 13:22:27", "{\"update_callback\":\"wc_update_770_remove_multichannel_marketing_feature_options\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473747;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473747;}", "2", "1", "2025-08-29 13:22:28", "2025-08-29 13:22:28", "90110", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2944", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:28", "2025-08-29 13:22:28", "{\"update_callback\":\"wc_update_790_blockified_product_grid_block\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473748;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473748;}", "2", "1", "2025-08-29 13:22:28", "2025-08-29 13:22:28", "90110", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2945", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:29", "2025-08-29 13:22:29", "{\"update_callback\":\"wc_update_810_migrate_transactional_metadata_for_hpos\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473749;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473749;}", "2", "1", "2025-08-29 13:22:33", "2025-08-29 13:22:33", "90112", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2946", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:30", "2025-08-29 13:22:30", "{\"update_callback\":\"wc_update_830_rename_checkout_template\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473750;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473750;}", "2", "1", "2025-08-29 13:22:33", "2025-08-29 13:22:33", "90112", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2947", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:31", "2025-08-29 13:22:31", "{\"update_callback\":\"wc_update_830_rename_cart_template\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473751;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473751;}", "2", "1", "2025-08-29 13:22:33", "2025-08-29 13:22:33", "90112", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2948", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:32", "2025-08-29 13:22:32", "{\"update_callback\":\"wc_update_860_remove_recommended_marketing_plugins_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473752;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473752;}", "2", "1", "2025-08-29 13:22:33", "2025-08-29 13:22:33", "90112", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2949", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:33", "2025-08-29 13:22:33", "{\"update_callback\":\"wc_update_870_prevent_listing_of_transient_files_directory\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473753;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473753;}", "2", "1", "2025-08-29 13:22:33", "2025-08-29 13:22:33", "90112", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2950", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:34", "2025-08-29 13:22:34", "{\"update_callback\":\"wc_update_890_update_connect_to_woocommerce_note\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473754;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473754;}", "2", "1", "2025-08-29 13:22:39", "2025-08-29 13:22:39", "90114", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2951", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:35", "2025-08-29 13:22:35", "{\"update_callback\":\"wc_update_890_update_paypal_standard_load_eligibility\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473755;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473755;}", "2", "1", "2025-08-29 13:22:39", "2025-08-29 13:22:39", "90114", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2952", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:36", "2025-08-29 13:22:36", "{\"update_callback\":\"wc_update_891_create_plugin_autoinstall_history_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473756;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473756;}", "2", "1", "2025-08-29 13:22:39", "2025-08-29 13:22:39", "90114", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2953", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:37", "2025-08-29 13:22:37", "{\"update_callback\":\"wc_update_910_add_launch_your_store_tour_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473757;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473757;}", "2", "1", "2025-08-29 13:22:39", "2025-08-29 13:22:39", "90114", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2954", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:38", "2025-08-29 13:22:38", "{\"update_callback\":\"wc_update_910_remove_obsolete_user_meta\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473758;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473758;}", "2", "1", "2025-08-29 13:22:39", "2025-08-29 13:22:39", "90114", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2955", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:39", "2025-08-29 13:22:39", "{\"update_callback\":\"wc_update_920_add_wc_hooked_blocks_version_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473759;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473759;}", "2", "1", "2025-08-29 13:22:39", "2025-08-29 13:22:39", "90114", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2956", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:40", "2025-08-29 13:22:40", "{\"update_callback\":\"wc_update_930_add_woocommerce_coming_soon_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473760;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473760;}", "2", "1", "2025-08-29 13:22:44", "2025-08-29 13:22:44", "90116", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2957", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:41", "2025-08-29 13:22:41", "{\"update_callback\":\"wc_update_930_migrate_user_meta_for_launch_your_store_tour\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473761;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473761;}", "2", "1", "2025-08-29 13:22:44", "2025-08-29 13:22:44", "90116", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2958", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:42", "2025-08-29 13:22:42", "{\"update_callback\":\"wc_update_940_add_phone_to_order_address_fts_index\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473762;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473762;}", "2", "1", "2025-08-29 13:22:44", "2025-08-29 13:22:44", "90116", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2959", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:43", "2025-08-29 13:22:43", "{\"update_callback\":\"wc_update_940_remove_help_panel_highlight_shown\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473763;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473763;}", "2", "1", "2025-08-29 13:22:44", "2025-08-29 13:22:44", "90116", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2960", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:44", "2025-08-29 13:22:44", "{\"update_callback\":\"wc_update_950_tracking_option_autoload\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473764;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473764;}", "2", "1", "2025-08-29 13:22:44", "2025-08-29 13:22:44", "90116", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2961", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:45", "2025-08-29 13:22:45", "{\"update_callback\":\"wc_update_961_migrate_default_email_base_color\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473765;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473765;}", "2", "1", "2025-08-29 13:22:49", "2025-08-29 13:22:49", "90118", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2962", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:46", "2025-08-29 13:22:46", "{\"update_callback\":\"wc_update_980_remove_order_attribution_install_banner_dismissed_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473766;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473766;}", "2", "1", "2025-08-29 13:22:49", "2025-08-29 13:22:49", "90118", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2963", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:47", "2025-08-29 13:22:47", "{\"update_callback\":\"wc_update_985_enable_new_payments_settings_page_feature\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473767;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473767;}", "2", "1", "2025-08-29 13:22:49", "2025-08-29 13:22:49", "90118", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2964", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:48", "2025-08-29 13:22:48", "{\"update_callback\":\"wc_update_990_remove_wc_count_comments_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473768;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473768;}", "2", "1", "2025-08-29 13:22:49", "2025-08-29 13:22:49", "90118", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2965", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:49", "2025-08-29 13:22:49", "{\"update_callback\":\"wc_update_990_remove_email_notes\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473769;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473769;}", "2", "1", "2025-08-29 13:22:49", "2025-08-29 13:22:49", "90118", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2966", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:50", "2025-08-29 13:22:50", "{\"update_callback\":\"wc_update_1000_multisite_visibility_setting\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473770;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473770;}", "2", "1", "2025-08-29 13:22:50", "2025-08-29 13:22:50", "90119", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2967", "woocommerce_run_update_callback", "complete", "2025-08-29 13:22:51", "2025-08-29 13:22:51", "{\"update_callback\":\"wc_update_1000_remove_patterns_toolkit_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473771;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473771;}", "2", "1", "2025-08-29 13:22:55", "2025-08-29 13:22:55", "90121", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2968", "woocommerce_update_db_to_current_version", "complete", "2025-08-29 13:22:52", "2025-08-29 13:22:52", "{\"version\":\"10.1.2\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473772;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473772;}", "2", "1", "2025-08-29 13:22:55", "2025-08-29 13:22:55", "90121", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2969", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2025-08-29 13:22:06", "2025-08-29 13:22:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473726;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473726;}", "6", "1", "2025-08-29 13:22:08", "2025-08-29 13:22:08", "90100", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2970", "fetch_patterns", "complete", "2025-08-29 13:22:06", "2025-08-29 13:22:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473726;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473726;}", "7", "1", "2025-08-29 13:22:08", "2025-08-29 13:22:08", "90100", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2971", "woocommerce_cleanup_draft_orders", "complete", "2025-08-29 13:22:06", "2025-08-29 13:22:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756473726;s:18:\"\0*\0first_timestamp\";i:1756473726;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756473726;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-08-29 13:22:08", "2025-08-29 13:22:08", "90100", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2972", "woocommerce_cleanup_draft_orders", "complete", "2025-08-30 13:22:08", "2025-08-30 13:22:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756560128;s:18:\"\0*\0first_timestamp\";i:1756473726;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756560128;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-08-30 13:38:31", "2025-08-30 13:38:31", "90526", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2973", "woocommerce_download_dir_sync", "complete", "2025-08-29 13:22:17", "2025-08-29 13:22:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473737;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473737;}", "2", "1", "2025-08-29 13:22:17", "2025-08-29 13:22:17", "90106", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2974", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-08-29 13:25:48", "2025-08-29 13:25:48", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756473948;s:18:\"\0*\0first_timestamp\";i:1756473948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756473948;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-29 13:26:14", "2025-08-29 13:26:14", "90126", NULL, "20");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2975", "woocommerce_scheduled_sales", "complete", "2025-08-30 00:00:00", "2025-08-30 00:00:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756512000;s:18:\"\0*\0first_timestamp\";i:1756512000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756512000;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-08-30 00:00:13", "2025-08-30 00:00:13", "90373", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2976", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-29 14:26:14", "2025-08-29 14:26:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756477574;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756477574;}", "9", "1", "2025-08-29 14:26:30", "2025-08-29 14:26:30", "90187", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2977", "woocommerce_cleanup_personal_data", "complete", "2025-08-29 13:26:24", "2025-08-29 13:26:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756473984;s:18:\"\0*\0first_timestamp\";i:1756473984;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756473984;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-08-29 13:27:27", "2025-08-29 13:27:27", "90129", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2978", "woocommerce_cleanup_logs", "complete", "2025-08-29 16:26:14", "2025-08-29 16:26:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756484774;s:18:\"\0*\0first_timestamp\";i:1756484774;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756484774;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-08-29 16:26:48", "2025-08-29 16:26:48", "90283", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2979", "woocommerce_cleanup_sessions", "complete", "2025-08-29 19:26:14", "2025-08-29 19:26:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756495574;s:18:\"\0*\0first_timestamp\";i:1756495574;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756495574;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-08-29 19:53:55", "2025-08-29 19:53:55", "90317", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2980", "woocommerce_geoip_updater", "complete", "2025-08-29 13:27:14", "2025-08-29 13:27:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756474034;s:18:\"\0*\0first_timestamp\";i:1756474034;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756474034;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "9", "1", "2025-08-29 13:27:28", "2025-08-29 13:27:28", "90129", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2981", "woocommerce_tracker_send_event_wrapper", "complete", "2025-08-29 13:26:24", "2025-08-29 13:26:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756473984;s:18:\"\0*\0first_timestamp\";i:1756473984;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756473984;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-08-29 13:27:28", "2025-08-29 13:27:28", "90129", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2982", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-08-29 16:26:14", "2025-08-29 16:26:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756484774;s:18:\"\0*\0first_timestamp\";i:1756484774;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756484774;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-08-29 16:26:48", "2025-08-29 16:26:48", "90283", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2983", "wc_admin_daily_wrapper", "complete", "2025-08-29 13:26:14", "2025-08-29 13:26:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756473974;s:18:\"\0*\0first_timestamp\";i:1756473974;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756473974;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-08-29 13:26:16", "2025-08-29 13:26:16", "90127", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2984", "generate_category_lookup_table_wrapper", "complete", "2025-08-29 13:26:24", "2025-08-29 13:26:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756473984;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756473984;}", "9", "1", "2025-08-29 13:27:28", "2025-08-29 13:27:28", "90129", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2985", "woocommerce_refresh_order_count_cache", "complete", "2025-08-30 01:26:14", "2025-08-30 01:26:14", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756517174;s:18:\"\0*\0first_timestamp\";i:1756517174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756517174;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-08-30 01:38:18", "2025-08-30 01:38:18", "90388", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2986", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-08-30 13:26:14", "2025-08-30 13:26:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756560374;s:18:\"\0*\0first_timestamp\";i:1756473948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756560374;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-30 13:38:33", "2025-08-30 13:38:33", "90526", NULL, "20");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2987", "wc_admin_daily_wrapper", "complete", "2025-08-30 13:26:16", "2025-08-30 13:26:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756560376;s:18:\"\0*\0first_timestamp\";i:1756473974;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756560376;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-08-30 13:38:33", "2025-08-30 13:38:33", "90526", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2988", "woocommerce_cleanup_personal_data", "complete", "2025-08-30 13:27:27", "2025-08-30 13:27:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756560447;s:18:\"\0*\0first_timestamp\";i:1756473984;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756560447;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-08-30 13:38:33", "2025-08-30 13:38:33", "90526", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2989", "woocommerce_tracker_send_event_wrapper", "complete", "2025-08-30 13:27:28", "2025-08-30 13:27:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756560448;s:18:\"\0*\0first_timestamp\";i:1756473984;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756560448;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-08-30 13:38:33", "2025-08-30 13:38:33", "90526", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2990", "woocommerce_geoip_updater", "pending", "2025-09-13 13:27:28", "2025-09-13 13:27:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757770048;s:18:\"\0*\0first_timestamp\";i:1756474034;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757770048;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2991", "fetch_patterns", "complete", "2025-08-29 14:20:32", "2025-08-29 14:20:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756477232;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756477232;}", "7", "1", "2025-08-29 14:20:59", "2025-08-29 14:20:59", "90180", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2992", "action_scheduler/migration_hook", "complete", "2025-08-29 14:21:32", "2025-08-29 14:21:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756477292;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756477292;}", "1", "1", "2025-08-29 14:22:09", "2025-08-29 14:22:09", "90182", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2993", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-29 15:26:30", "2025-08-29 15:26:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756481190;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756481190;}", "9", "1", "2025-08-29 15:26:44", "2025-08-29 15:26:44", "90246", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2994", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-29 16:26:44", "2025-08-29 16:26:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756484804;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756484804;}", "9", "1", "2025-08-29 16:26:48", "2025-08-29 16:26:48", "90283", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2995", "woocommerce_cleanup_logs", "complete", "2025-08-30 16:26:48", "2025-08-30 16:26:48", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756571208;s:18:\"\0*\0first_timestamp\";i:1756484774;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756571208;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-08-30 16:32:41", "2025-08-30 16:32:41", "90546", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2996", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-08-30 16:26:48", "2025-08-30 16:26:48", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756571208;s:18:\"\0*\0first_timestamp\";i:1756484774;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756571208;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-08-30 16:32:41", "2025-08-30 16:32:41", "90546", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2997", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-29 17:26:48", "2025-08-29 17:26:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756488408;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756488408;}", "9", "1", "2025-08-29 17:28:40", "2025-08-29 17:28:40", "90301", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2998", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-29 18:28:40", "2025-08-29 18:28:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756492120;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756492120;}", "9", "1", "2025-08-29 18:33:09", "2025-08-29 18:33:09", "90314", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("2999", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-29 19:33:09", "2025-08-29 19:33:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756495989;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756495989;}", "9", "1", "2025-08-29 19:53:55", "2025-08-29 19:53:55", "90317", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3000", "woocommerce_cleanup_sessions", "complete", "2025-08-30 07:53:55", "2025-08-30 07:53:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756540435;s:18:\"\0*\0first_timestamp\";i:1756495574;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756540435;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-08-30 07:56:36", "2025-08-30 07:56:36", "90455", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3001", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-29 20:53:55", "2025-08-29 20:53:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756500835;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756500835;}", "9", "1", "2025-08-29 20:54:35", "2025-08-29 20:54:35", "90330", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3002", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-29 21:54:35", "2025-08-29 21:54:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756504475;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756504475;}", "9", "1", "2025-08-29 22:12:16", "2025-08-29 22:12:16", "90346", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3003", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-29 23:12:16", "2025-08-29 23:12:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756509136;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756509136;}", "9", "1", "2025-08-29 23:14:48", "2025-08-29 23:14:48", "90356", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3004", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-30 00:14:48", "2025-08-30 00:14:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756512888;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756512888;}", "9", "1", "2025-08-30 00:20:15", "2025-08-30 00:20:15", "90375", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3005", "woocommerce_scheduled_sales", "complete", "2025-08-31 00:00:13", "2025-08-31 00:00:13", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756598413;s:18:\"\0*\0first_timestamp\";i:1756512000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756598413;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-08-31 00:03:26", "2025-08-31 00:03:26", "90594", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3006", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-30 01:20:15", "2025-08-30 01:20:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756516815;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756516815;}", "9", "1", "2025-08-30 01:20:27", "2025-08-30 01:20:27", "90386", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3007", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-30 02:20:27", "2025-08-30 02:20:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756520427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756520427;}", "9", "1", "2025-08-30 02:30:34", "2025-08-30 02:30:34", "90403", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3008", "woocommerce_refresh_order_count_cache", "complete", "2025-08-30 13:38:18", "2025-08-30 13:38:18", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756561098;s:18:\"\0*\0first_timestamp\";i:1756517174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756561098;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-08-30 13:38:33", "2025-08-30 13:38:33", "90526", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3009", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-30 03:30:34", "2025-08-30 03:30:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756524634;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756524634;}", "9", "1", "2025-08-30 03:31:55", "2025-08-30 03:31:55", "90420", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3010", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-30 04:31:55", "2025-08-30 04:31:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756528315;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756528315;}", "9", "1", "2025-08-30 04:38:54", "2025-08-30 04:38:54", "90431", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3011", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-30 05:38:54", "2025-08-30 05:38:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756532334;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756532334;}", "9", "1", "2025-08-30 05:41:21", "2025-08-30 05:41:21", "90440", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3012", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-30 06:41:21", "2025-08-30 06:41:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756536081;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756536081;}", "9", "1", "2025-08-30 06:57:14", "2025-08-30 06:57:14", "90448", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3013", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-30 07:57:14", "2025-08-30 07:57:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756540634;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756540634;}", "9", "1", "2025-08-30 07:59:29", "2025-08-30 07:59:29", "90457", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3014", "woocommerce_cleanup_sessions", "complete", "2025-08-30 19:56:36", "2025-08-30 19:56:36", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756583796;s:18:\"\0*\0first_timestamp\";i:1756495574;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756583796;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-08-30 20:00:20", "2025-08-30 20:00:20", "90564", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3015", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-30 08:59:29", "2025-08-30 08:59:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756544369;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756544369;}", "9", "1", "2025-08-30 09:01:35", "2025-08-30 09:01:35", "90471", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3016", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-30 10:01:35", "2025-08-30 10:01:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756548095;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756548095;}", "9", "1", "2025-08-30 10:03:00", "2025-08-30 10:03:00", "90487", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3017", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-30 11:03:00", "2025-08-30 11:03:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756551780;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756551780;}", "9", "1", "2025-08-30 11:33:45", "2025-08-30 11:33:45", "90504", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3018", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-30 12:33:45", "2025-08-30 12:33:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756557225;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756557225;}", "9", "1", "2025-08-30 12:34:07", "2025-08-30 12:34:07", "90517", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3019", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-30 13:34:07", "2025-08-30 13:34:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756560847;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756560847;}", "9", "1", "2025-08-30 13:38:33", "2025-08-30 13:38:33", "90526", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3020", "woocommerce_cleanup_draft_orders", "complete", "2025-08-31 13:38:31", "2025-08-31 13:38:31", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756647511;s:18:\"\0*\0first_timestamp\";i:1756473726;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756647511;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-08-31 13:38:57", "2025-08-31 13:38:57", "90691", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3021", "wc_admin_daily_wrapper", "complete", "2025-08-31 13:38:33", "2025-08-31 13:38:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756647513;s:18:\"\0*\0first_timestamp\";i:1756473974;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756647513;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-08-31 13:38:59", "2025-08-31 13:38:59", "90691", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3022", "woocommerce_cleanup_personal_data", "complete", "2025-08-31 13:38:33", "2025-08-31 13:38:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756647513;s:18:\"\0*\0first_timestamp\";i:1756473984;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756647513;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-08-31 13:38:59", "2025-08-31 13:38:59", "90691", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3023", "woocommerce_tracker_send_event_wrapper", "complete", "2025-08-31 13:38:33", "2025-08-31 13:38:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756647513;s:18:\"\0*\0first_timestamp\";i:1756473984;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756647513;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-08-31 13:38:59", "2025-08-31 13:38:59", "90691", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3024", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-30 14:38:33", "2025-08-30 14:38:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756564713;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756564713;}", "9", "1", "2025-08-30 14:48:15", "2025-08-30 14:48:15", "90532", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3025", "woocommerce_refresh_order_count_cache", "complete", "2025-08-31 01:38:33", "2025-08-31 01:38:33", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756604313;s:18:\"\0*\0first_timestamp\";i:1756517174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756604313;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-08-31 01:41:50", "2025-08-31 01:41:50", "90613", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3026", "generate_category_lookup_table_wrapper", "complete", "2025-08-30 13:38:43", "2025-08-30 13:38:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756561123;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756561123;}", "9", "1", "2025-08-30 13:54:00", "2025-08-30 13:54:00", "90528", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3027", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-08-31 13:38:33", "2025-08-31 13:38:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756647513;s:18:\"\0*\0first_timestamp\";i:1756473948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756647513;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-08-31 13:38:59", "2025-08-31 13:38:59", "90691", NULL, "20");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3028", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-30 15:48:15", "2025-08-30 15:48:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756568895;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756568895;}", "9", "1", "2025-08-30 16:06:33", "2025-08-30 16:06:33", "90539", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3029", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-30 17:06:33", "2025-08-30 17:06:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756573593;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756573593;}", "9", "1", "2025-08-30 17:17:19", "2025-08-30 17:17:19", "90548", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3030", "woocommerce_cleanup_logs", "complete", "2025-08-31 16:32:41", "2025-08-31 16:32:41", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756657961;s:18:\"\0*\0first_timestamp\";i:1756484774;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756657961;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-08-31 16:36:22", "2025-08-31 16:36:22", "90718", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3031", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-08-31 16:32:41", "2025-08-31 16:32:41", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756657961;s:18:\"\0*\0first_timestamp\";i:1756484774;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756657961;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-08-31 16:36:22", "2025-08-31 16:36:22", "90718", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3032", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-30 18:17:19", "2025-08-30 18:17:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756577839;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756577839;}", "9", "1", "2025-08-30 18:28:15", "2025-08-30 18:28:15", "90551", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3033", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-30 19:28:15", "2025-08-30 19:28:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756582095;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756582095;}", "9", "1", "2025-08-30 19:28:55", "2025-08-30 19:28:55", "90561", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3034", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-30 20:28:55", "2025-08-30 20:28:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756585735;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756585735;}", "9", "1", "2025-08-30 20:30:02", "2025-08-30 20:30:02", "90568", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3035", "woocommerce_cleanup_sessions", "complete", "2025-08-31 08:00:20", "2025-08-31 08:00:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756627220;s:18:\"\0*\0first_timestamp\";i:1756495574;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756627220;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-08-31 08:10:18", "2025-08-31 08:10:18", "90658", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3036", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-30 21:30:02", "2025-08-30 21:30:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756589402;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756589402;}", "9", "1", "2025-08-30 21:50:29", "2025-08-30 21:50:29", "90573", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3037", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-30 22:50:29", "2025-08-30 22:50:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756594229;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756594229;}", "9", "1", "2025-08-30 22:51:00", "2025-08-30 22:51:00", "90585", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3038", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-30 23:51:00", "2025-08-30 23:51:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756597860;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756597860;}", "9", "1", "2025-08-30 23:51:24", "2025-08-30 23:51:24", "90589", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3039", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-31 00:51:24", "2025-08-31 00:51:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756601484;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756601484;}", "9", "1", "2025-08-31 01:00:34", "2025-08-31 01:00:34", "90608", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3040", "woocommerce_scheduled_sales", "complete", "2025-09-01 00:03:26", "2025-09-01 00:03:26", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756685006;s:18:\"\0*\0first_timestamp\";i:1756512000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756685006;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-01 00:05:21", "2025-09-01 00:05:21", "66", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3041", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-31 02:00:34", "2025-08-31 02:00:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756605634;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756605634;}", "9", "1", "2025-08-31 02:11:35", "2025-08-31 02:11:35", "90617", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3042", "woocommerce_refresh_order_count_cache", "complete", "2025-08-31 13:41:50", "2025-08-31 13:41:50", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756647710;s:18:\"\0*\0first_timestamp\";i:1756517174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756647710;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-08-31 13:45:36", "2025-08-31 13:45:36", "90693", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3043", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-31 03:11:35", "2025-08-31 03:11:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756609895;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756609895;}", "9", "1", "2025-08-31 03:17:58", "2025-08-31 03:17:58", "90626", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3044", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-31 04:17:58", "2025-08-31 04:17:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756613878;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756613878;}", "9", "1", "2025-08-31 04:20:01", "2025-08-31 04:20:01", "90634", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3045", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-31 05:20:01", "2025-08-31 05:20:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756617601;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756617601;}", "9", "1", "2025-08-31 05:55:51", "2025-08-31 05:55:51", "90639", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3046", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-31 06:55:51", "2025-08-31 06:55:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756623351;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756623351;}", "9", "1", "2025-08-31 06:56:10", "2025-08-31 06:56:10", "90648", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3047", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-31 07:56:10", "2025-08-31 07:56:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756626970;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756626970;}", "9", "1", "2025-08-31 07:59:52", "2025-08-31 07:59:52", "90656", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3048", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-31 08:59:51", "2025-08-31 08:59:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756630791;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756630791;}", "9", "1", "2025-08-31 09:04:01", "2025-08-31 09:04:01", "90662", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3049", "woocommerce_cleanup_sessions", "complete", "2025-08-31 20:10:18", "2025-08-31 20:10:18", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756671018;s:18:\"\0*\0first_timestamp\";i:1756495574;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756671018;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-08-31 20:11:07", "2025-08-31 20:11:07", "90814", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3050", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-31 10:04:01", "2025-08-31 10:04:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756634641;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756634641;}", "9", "1", "2025-08-31 10:10:17", "2025-08-31 10:10:17", "90674", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3051", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-31 11:10:17", "2025-08-31 11:10:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756638617;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756638617;}", "9", "1", "2025-08-31 11:24:47", "2025-08-31 11:24:47", "90678", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3052", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-31 12:24:47", "2025-08-31 12:24:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756643087;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756643087;}", "9", "1", "2025-08-31 12:25:59", "2025-08-31 12:25:59", "90682", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3053", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-31 13:25:59", "2025-08-31 13:25:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756646759;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756646759;}", "9", "1", "2025-08-31 13:29:23", "2025-08-31 13:29:23", "90689", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3054", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-31 14:29:23", "2025-08-31 14:29:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756650563;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756650563;}", "9", "1", "2025-08-31 14:47:02", "2025-08-31 14:47:02", "90704", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3055", "woocommerce_cleanup_draft_orders", "complete", "2025-09-01 13:38:57", "2025-09-01 13:38:57", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756733937;s:18:\"\0*\0first_timestamp\";i:1756473726;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756733937;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-09-01 13:56:53", "2025-09-01 13:56:53", "477", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3056", "wc_admin_daily_wrapper", "complete", "2025-09-01 13:38:59", "2025-09-01 13:38:59", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756733939;s:18:\"\0*\0first_timestamp\";i:1756473974;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756733939;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-01 13:56:59", "2025-09-01 13:56:59", "477", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3057", "woocommerce_cleanup_personal_data", "complete", "2025-09-01 13:38:59", "2025-09-01 13:38:59", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756733939;s:18:\"\0*\0first_timestamp\";i:1756473984;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756733939;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-01 13:57:00", "2025-09-01 13:57:00", "477", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3058", "woocommerce_tracker_send_event_wrapper", "complete", "2025-09-01 13:38:59", "2025-09-01 13:38:59", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756733939;s:18:\"\0*\0first_timestamp\";i:1756473984;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756733939;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-01 13:57:00", "2025-09-01 13:57:00", "477", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3059", "generate_category_lookup_table_wrapper", "complete", "2025-08-31 13:39:09", "2025-08-31 13:39:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756647549;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756647549;}", "9", "1", "2025-08-31 13:45:36", "2025-08-31 13:45:36", "90693", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3060", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-01 13:38:59", "2025-09-01 13:38:59", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756733939;s:18:\"\0*\0first_timestamp\";i:1756473948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756733939;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-09-01 13:57:00", "2025-09-01 13:57:00", "477", NULL, "20");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3061", "woocommerce_refresh_order_count_cache", "complete", "2025-09-01 01:45:36", "2025-09-01 01:45:36", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756691136;s:18:\"\0*\0first_timestamp\";i:1756517174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756691136;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-09-01 01:47:01", "2025-09-01 01:47:01", "139", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3062", "woocommerce_update_marketplace_suggestions", "complete", "2025-08-31 13:48:28", "2025-08-31 13:48:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756648108;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756648108;}", "7", "1", "2025-08-31 13:53:47", "2025-08-31 13:53:47", "90696", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3063", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-31 15:47:02", "2025-08-31 15:47:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756655222;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756655222;}", "9", "1", "2025-08-31 15:48:03", "2025-08-31 15:48:03", "90710", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3064", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-31 16:48:03", "2025-08-31 16:48:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756658883;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756658883;}", "9", "1", "2025-08-31 16:53:48", "2025-08-31 16:53:48", "90724", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3065", "woocommerce_cleanup_logs", "complete", "2025-09-01 16:36:22", "2025-09-01 16:36:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756744582;s:18:\"\0*\0first_timestamp\";i:1756484774;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756744582;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-01 16:42:34", "2025-09-01 16:42:34", "569", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3066", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-09-01 16:36:22", "2025-09-01 16:36:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756744582;s:18:\"\0*\0first_timestamp\";i:1756484774;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756744582;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-01 16:42:34", "2025-09-01 16:42:34", "569", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3067", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-31 17:53:48", "2025-08-31 17:53:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756662828;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756662828;}", "9", "1", "2025-08-31 18:08:43", "2025-08-31 18:08:43", "90729", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3068", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-31 19:08:43", "2025-08-31 19:08:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756667323;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756667323;}", "9", "1", "2025-08-31 19:09:56", "2025-08-31 19:09:56", "90770", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3069", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-31 20:09:56", "2025-08-31 20:09:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756670996;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756670996;}", "9", "1", "2025-08-31 20:10:11", "2025-08-31 20:10:11", "90812", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3070", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-31 21:10:11", "2025-08-31 21:10:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756674611;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756674611;}", "9", "1", "2025-08-31 21:10:58", "2025-08-31 21:10:58", "90852", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3071", "woocommerce_cleanup_sessions", "complete", "2025-09-01 08:11:07", "2025-09-01 08:11:07", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756714267;s:18:\"\0*\0first_timestamp\";i:1756495574;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756714267;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-01 08:13:08", "2025-09-01 08:13:08", "443", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3072", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-31 22:10:58", "2025-08-31 22:10:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756678258;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756678258;}", "9", "1", "2025-08-31 22:11:37", "2025-08-31 22:11:37", "90904", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3073", "fetch_patterns", "complete", "2025-08-31 21:43:58", "2025-08-31 21:43:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756676638;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756676638;}", "7", "1", "2025-08-31 21:43:59", "2025-08-31 21:43:59", "90882", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3074", "action_scheduler/migration_hook", "complete", "2025-08-31 21:45:00", "2025-08-31 21:45:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756676700;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756676700;}", "1", "1", "2025-08-31 21:45:20", "2025-08-31 21:45:20", "90884", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3075", "fetch_patterns", "complete", "2025-08-31 21:47:23", "2025-08-31 21:47:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756676843;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756676843;}", "7", "1", "2025-08-31 21:47:30", "2025-08-31 21:47:30", "90889", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3076", "action_scheduler/migration_hook", "complete", "2025-08-31 21:48:23", "2025-08-31 21:48:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756676903;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756676903;}", "1", "1", "2025-08-31 21:48:51", "2025-08-31 21:48:51", "90892", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3077", "fetch_patterns", "complete", "2025-08-31 22:09:33", "2025-08-31 22:09:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756678173;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756678173;}", "7", "1", "2025-08-31 22:10:37", "2025-08-31 22:10:37", "90902", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3078", "action_scheduler/migration_hook", "complete", "2025-08-31 22:10:34", "2025-08-31 22:10:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756678234;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756678234;}", "1", "1", "2025-08-31 22:10:37", "2025-08-31 22:10:37", "90902", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3079", "woocommerce_cancel_unpaid_orders", "complete", "2025-08-31 23:11:37", "2025-08-31 23:11:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756681897;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756681897;}", "9", "1", "2025-08-31 23:11:38", "2025-08-31 23:11:38", "29", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3080", "fetch_patterns", "complete", "2025-08-31 22:17:09", "2025-08-31 22:17:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756678629;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756678629;}", "7", "1", "2025-08-31 22:17:16", "2025-08-31 22:17:16", "90911", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3081", "action_scheduler/migration_hook", "complete", "2025-08-31 22:18:10", "2025-08-31 22:18:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756678690;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756678690;}", "1", "1", "2025-08-31 22:18:11", "2025-08-31 22:18:11", "90913", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3082", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-08-31 22:49:19", "2025-08-31 22:49:19", "[40,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756680559;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756680559;}", "2", "1", "2025-08-31 22:49:19", "2025-08-31 22:49:19", "3", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3083", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-01 00:11:38", "2025-09-01 00:11:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756685498;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756685498;}", "9", "1", "2025-09-01 00:25:52", "2025-09-01 00:25:52", "71", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3084", "woocommerce_scheduled_sales", "complete", "2025-09-02 00:05:21", "2025-09-02 00:05:21", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756771521;s:18:\"\0*\0first_timestamp\";i:1756512000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756771521;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-02 00:14:36", "2025-09-02 00:14:36", "55", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3085", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-01 01:25:51", "2025-09-01 01:25:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756689951;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756689951;}", "9", "1", "2025-09-01 01:26:13", "2025-09-01 01:26:13", "128", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3086", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-09-01 00:25:55", "2025-09-01 00:25:55", "[83,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756686355;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756686355;}", "2", "1", "2025-09-01 00:25:57", "2025-09-01 00:25:57", "74", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3087", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-09-01 00:25:55", "2025-09-01 00:25:55", "[87,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756686355;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756686355;}", "2", "1", "2025-09-01 00:25:57", "2025-09-01 00:25:57", "74", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3088", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-09-01 00:25:55", "2025-09-01 00:25:55", "[90,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756686355;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756686355;}", "2", "1", "2025-09-01 00:25:57", "2025-09-01 00:25:57", "74", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3089", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-01 02:26:13", "2025-09-01 02:26:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756693573;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756693573;}", "9", "1", "2025-09-01 02:26:59", "2025-09-01 02:26:59", "157", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3090", "woocommerce_refresh_order_count_cache", "complete", "2025-09-01 13:47:01", "2025-09-01 13:47:01", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756734421;s:18:\"\0*\0first_timestamp\";i:1756517174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756734421;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-09-01 13:57:00", "2025-09-01 13:57:00", "477", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3091", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-01 03:26:59", "2025-09-01 03:26:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756697219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756697219;}", "9", "1", "2025-09-01 03:27:42", "2025-09-01 03:27:42", "214", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3092", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-01 04:27:42", "2025-09-01 04:27:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756700862;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756700862;}", "9", "1", "2025-09-01 04:28:24", "2025-09-01 04:28:24", "274", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3093", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-01 05:28:24", "2025-09-01 05:28:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756704504;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756704504;}", "9", "1", "2025-09-01 05:28:32", "2025-09-01 05:28:32", "336", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3094", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-01 06:28:32", "2025-09-01 06:28:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756708112;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756708112;}", "9", "1", "2025-09-01 06:29:51", "2025-09-01 06:29:51", "397", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3095", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-01 07:29:51", "2025-09-01 07:29:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756711791;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756711791;}", "9", "1", "2025-09-01 07:31:32", "2025-09-01 07:31:32", "429", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3096", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-01 08:31:32", "2025-09-01 08:31:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756715492;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756715492;}", "9", "1", "2025-09-01 08:48:07", "2025-09-01 08:48:07", "449", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3097", "woocommerce_cleanup_sessions", "complete", "2025-09-01 20:13:08", "2025-09-01 20:13:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756757588;s:18:\"\0*\0first_timestamp\";i:1756495574;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756757588;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-01 20:41:47", "2025-09-01 20:41:47", "758", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3098", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-01 09:48:07", "2025-09-01 09:48:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756720087;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756720087;}", "9", "1", "2025-09-01 10:20:45", "2025-09-01 10:20:45", "462", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3099", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-01 11:20:45", "2025-09-01 11:20:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756725645;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756725645;}", "9", "1", "2025-09-01 11:23:36", "2025-09-01 11:23:36", "466", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3100", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-01 12:23:36", "2025-09-01 12:23:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756729416;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756729416;}", "9", "1", "2025-09-01 12:28:46", "2025-09-01 12:28:46", "473", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3101", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-01 13:28:46", "2025-09-01 13:28:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756733326;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756733326;}", "9", "1", "2025-09-01 13:56:52", "2025-09-01 13:56:52", "477", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3102", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-01 14:56:52", "2025-09-01 14:56:52", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756738612;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756738612;}", "9", "1", "2025-09-01 14:57:15", "2025-09-01 14:57:15", "495", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3103", "woocommerce_cleanup_draft_orders", "complete", "2025-09-02 13:56:53", "2025-09-02 13:56:53", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756821413;s:18:\"\0*\0first_timestamp\";i:1756473726;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756821413;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-09-02 14:18:28", "2025-09-02 14:18:28", "188", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3104", "wc_admin_daily_wrapper", "complete", "2025-09-02 13:56:59", "2025-09-02 13:56:59", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756821419;s:18:\"\0*\0first_timestamp\";i:1756473974;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756821419;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-02 14:18:32", "2025-09-02 14:18:32", "188", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3105", "woocommerce_cleanup_personal_data", "complete", "2025-09-02 13:57:00", "2025-09-02 13:57:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756821420;s:18:\"\0*\0first_timestamp\";i:1756473984;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756821420;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-02 14:18:33", "2025-09-02 14:18:33", "188", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3106", "woocommerce_tracker_send_event_wrapper", "complete", "2025-09-02 13:57:00", "2025-09-02 13:57:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756821420;s:18:\"\0*\0first_timestamp\";i:1756473984;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756821420;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-02 14:18:33", "2025-09-02 14:18:33", "188", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3107", "woocommerce_refresh_order_count_cache", "complete", "2025-09-02 01:57:00", "2025-09-02 01:57:00", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756778220;s:18:\"\0*\0first_timestamp\";i:1756517174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756778220;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-09-02 02:08:34", "2025-09-02 02:08:34", "66", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3108", "generate_category_lookup_table_wrapper", "complete", "2025-09-01 13:57:10", "2025-09-01 13:57:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756735030;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756735030;}", "9", "1", "2025-09-01 13:57:15", "2025-09-01 13:57:15", "479", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3109", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-02 13:57:00", "2025-09-02 13:57:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756821420;s:18:\"\0*\0first_timestamp\";i:1756473948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756821420;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-09-02 14:18:34", "2025-09-02 14:18:34", "188", NULL, "20");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3110", "fetch_patterns", "complete", "2025-09-01 14:49:39", "2025-09-01 14:49:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756738179;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756738179;}", "7", "1", "2025-09-01 14:50:35", "2025-09-01 14:50:35", "486", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3111", "action_scheduler/migration_hook", "complete", "2025-09-01 14:50:39", "2025-09-01 14:50:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756738239;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756738239;}", "1", "1", "2025-09-01 14:51:22", "2025-09-01 14:51:22", "488", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3112", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-01 15:57:15", "2025-09-01 15:57:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756742235;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756742235;}", "9", "1", "2025-09-01 16:02:18", "2025-09-01 16:02:18", "554", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3113", "fetch_patterns", "complete", "2025-09-01 15:06:47", "2025-09-01 15:06:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756739207;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756739207;}", "7", "1", "2025-09-01 15:07:57", "2025-09-01 15:07:57", "506", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3114", "action_scheduler/migration_hook", "complete", "2025-09-01 15:07:47", "2025-09-01 15:07:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756739267;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756739267;}", "1", "1", "2025-09-01 15:07:57", "2025-09-01 15:07:57", "506", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3115", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-01 17:02:18", "2025-09-01 17:02:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756746138;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756746138;}", "9", "1", "2025-09-01 17:02:31", "2025-09-01 17:02:31", "590", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3116", "woocommerce_cleanup_logs", "complete", "2025-09-02 16:42:34", "2025-09-02 16:42:34", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756831354;s:18:\"\0*\0first_timestamp\";i:1756484774;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756831354;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-02 17:14:55", "2025-09-02 17:14:55", "212", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3117", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-09-02 16:42:34", "2025-09-02 16:42:34", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756831354;s:18:\"\0*\0first_timestamp\";i:1756484774;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756831354;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-02 17:14:55", "2025-09-02 17:14:55", "212", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3118", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-01 18:02:31", "2025-09-01 18:02:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756749751;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756749751;}", "9", "1", "2025-09-01 18:03:02", "2025-09-01 18:03:02", "648", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3119", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-01 19:03:02", "2025-09-01 19:03:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756753382;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756753382;}", "9", "1", "2025-09-01 19:03:17", "2025-09-01 19:03:17", "709", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3120", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-01 20:03:17", "2025-09-01 20:03:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756756997;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756756997;}", "9", "1", "2025-09-01 20:41:47", "2025-09-01 20:41:47", "758", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3121", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-01 21:41:47", "2025-09-01 21:41:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756762907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756762907;}", "9", "1", "2025-09-01 21:41:55", "2025-09-01 21:41:55", "794", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3122", "woocommerce_cleanup_sessions", "complete", "2025-09-02 08:41:47", "2025-09-02 08:41:47", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756802507;s:18:\"\0*\0first_timestamp\";i:1756495574;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756802507;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-02 08:49:36", "2025-09-02 08:49:36", "138", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3123", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-01 22:41:55", "2025-09-01 22:41:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756766515;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756766515;}", "9", "1", "2025-09-01 22:43:03", "2025-09-01 22:43:03", "25", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3124", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-01 23:43:03", "2025-09-01 23:43:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756770183;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756770183;}", "9", "1", "2025-09-01 23:45:18", "2025-09-01 23:45:18", "51", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3125", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-02 00:45:17", "2025-09-02 00:45:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756773917;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756773917;}", "9", "1", "2025-09-02 00:57:17", "2025-09-02 00:57:17", "59", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3126", "woocommerce_scheduled_sales", "complete", "2025-09-03 00:14:36", "2025-09-03 00:14:36", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756858476;s:18:\"\0*\0first_timestamp\";i:1756512000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756858476;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-03 00:18:54", "2025-09-03 00:18:54", "258", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3127", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-02 01:57:17", "2025-09-02 01:57:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756778237;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756778237;}", "9", "1", "2025-09-02 02:08:34", "2025-09-02 02:08:34", "66", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3128", "woocommerce_refresh_order_count_cache", "complete", "2025-09-02 14:08:34", "2025-09-02 14:08:34", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756822114;s:18:\"\0*\0first_timestamp\";i:1756517174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756822114;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-09-02 14:18:33", "2025-09-02 14:18:33", "188", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3129", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-02 03:08:34", "2025-09-02 03:08:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756782514;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756782514;}", "9", "1", "2025-09-02 03:29:31", "2025-09-02 03:29:31", "77", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3130", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-02 04:29:31", "2025-09-02 04:29:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756787371;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756787371;}", "9", "1", "2025-09-02 04:42:28", "2025-09-02 04:42:28", "88", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3131", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-02 05:42:28", "2025-09-02 05:42:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756791748;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756791748;}", "9", "1", "2025-09-02 05:43:10", "2025-09-02 05:43:10", "98", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3132", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-02 06:43:10", "2025-09-02 06:43:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756795390;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756795390;}", "9", "1", "2025-09-02 06:48:58", "2025-09-02 06:48:58", "115", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3133", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-02 07:48:58", "2025-09-02 07:48:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756799338;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756799338;}", "9", "1", "2025-09-02 07:53:40", "2025-09-02 07:53:40", "124", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3134", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-02 08:53:40", "2025-09-02 08:53:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756803220;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756803220;}", "9", "1", "2025-09-02 09:12:47", "2025-09-02 09:12:47", "142", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3135", "woocommerce_cleanup_sessions", "complete", "2025-09-02 20:49:36", "2025-09-02 20:49:36", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756846176;s:18:\"\0*\0first_timestamp\";i:1756495574;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756846176;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-02 21:01:01", "2025-09-02 21:01:01", "239", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3136", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-02 10:12:47", "2025-09-02 10:12:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756807967;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756807967;}", "9", "1", "2025-09-02 11:00:07", "2025-09-02 11:00:07", "149", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3137", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-02 12:00:07", "2025-09-02 12:00:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756814407;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756814407;}", "9", "1", "2025-09-02 12:00:10", "2025-09-02 12:00:10", "164", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3138", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-02 13:00:10", "2025-09-02 13:00:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756818010;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756818010;}", "9", "1", "2025-09-02 13:03:01", "2025-09-02 13:03:01", "184", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3139", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-02 14:03:01", "2025-09-02 14:03:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756821781;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756821781;}", "9", "1", "2025-09-02 14:18:33", "2025-09-02 14:18:33", "188", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3140", "woocommerce_cleanup_draft_orders", "complete", "2025-09-03 14:18:28", "2025-09-03 14:18:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756909108;s:18:\"\0*\0first_timestamp\";i:1756473726;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756909108;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-09-03 15:08:19", "2025-09-03 15:08:19", "363", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3141", "wc_admin_daily_wrapper", "complete", "2025-09-03 14:18:32", "2025-09-03 14:18:32", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756909112;s:18:\"\0*\0first_timestamp\";i:1756473974;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756909112;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-03 15:08:21", "2025-09-03 15:08:21", "363", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3142", "woocommerce_cleanup_personal_data", "complete", "2025-09-03 14:18:33", "2025-09-03 14:18:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756909113;s:18:\"\0*\0first_timestamp\";i:1756473984;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756909113;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-03 15:08:22", "2025-09-03 15:08:22", "363", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3143", "woocommerce_tracker_send_event_wrapper", "complete", "2025-09-03 14:18:33", "2025-09-03 14:18:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756909113;s:18:\"\0*\0first_timestamp\";i:1756473984;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756909113;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-03 15:08:22", "2025-09-03 15:08:22", "363", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3144", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-02 15:18:33", "2025-09-02 15:18:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756826313;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756826313;}", "9", "1", "2025-09-02 15:35:05", "2025-09-02 15:35:05", "197", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3145", "woocommerce_refresh_order_count_cache", "complete", "2025-09-03 02:18:33", "2025-09-03 02:18:33", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756865913;s:18:\"\0*\0first_timestamp\";i:1756517174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756865913;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-09-03 03:17:32", "2025-09-03 03:17:32", "277", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3146", "generate_category_lookup_table_wrapper", "complete", "2025-09-02 14:18:43", "2025-09-02 14:18:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756822723;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756822723;}", "9", "1", "2025-09-02 14:20:29", "2025-09-02 14:20:29", "190", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3147", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-03 14:18:34", "2025-09-03 14:18:34", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756909114;s:18:\"\0*\0first_timestamp\";i:1756473948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756909114;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-09-03 15:08:22", "2025-09-03 15:08:22", "363", NULL, "20");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3148", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-02 16:35:05", "2025-09-02 16:35:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756830905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756830905;}", "9", "1", "2025-09-02 16:35:07", "2025-09-02 16:35:07", "209", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3149", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-02 17:35:07", "2025-09-02 17:35:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756834507;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756834507;}", "9", "1", "2025-09-02 17:36:27", "2025-09-02 17:36:27", "219", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3150", "woocommerce_cleanup_logs", "complete", "2025-09-03 17:14:55", "2025-09-03 17:14:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756919695;s:18:\"\0*\0first_timestamp\";i:1756484774;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756919695;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-03 17:44:43", "2025-09-03 17:44:43", "380", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3151", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-09-03 17:14:55", "2025-09-03 17:14:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756919695;s:18:\"\0*\0first_timestamp\";i:1756484774;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756919695;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-03 17:44:43", "2025-09-03 17:44:43", "380", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3152", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-02 18:36:27", "2025-09-02 18:36:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756838187;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756838187;}", "9", "1", "2025-09-02 18:41:49", "2025-09-02 18:41:49", "226", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3153", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-02 19:41:48", "2025-09-02 19:41:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756842108;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756842108;}", "9", "1", "2025-09-02 19:58:38", "2025-09-02 19:58:38", "233", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3154", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-02 20:58:38", "2025-09-02 20:58:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756846718;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756846718;}", "9", "1", "2025-09-02 21:01:01", "2025-09-02 21:01:01", "239", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3155", "woocommerce_cleanup_sessions", "complete", "2025-09-03 09:01:01", "2025-09-03 09:01:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756890061;s:18:\"\0*\0first_timestamp\";i:1756495574;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756890061;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-03 09:16:17", "2025-09-03 09:16:17", "321", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3156", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-02 22:01:01", "2025-09-02 22:01:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756850461;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756850461;}", "9", "1", "2025-09-02 22:07:18", "2025-09-02 22:07:18", "244", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3157", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-02 23:07:18", "2025-09-02 23:07:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756854438;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756854438;}", "9", "1", "2025-09-02 23:23:15", "2025-09-02 23:23:15", "251", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3158", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-03 00:23:15", "2025-09-03 00:23:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756858995;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756858995;}", "9", "1", "2025-09-03 00:38:56", "2025-09-03 00:38:56", "261", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3159", "woocommerce_scheduled_sales", "complete", "2025-09-04 00:18:54", "2025-09-04 00:18:54", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756945134;s:18:\"\0*\0first_timestamp\";i:1756512000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756945134;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-04 00:30:42", "2025-09-04 00:30:42", "434", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3160", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-03 01:38:56", "2025-09-03 01:38:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756863536;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756863536;}", "9", "1", "2025-09-03 01:45:13", "2025-09-03 01:45:13", "273", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3161", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-03 02:45:13", "2025-09-03 02:45:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756867513;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756867513;}", "9", "1", "2025-09-03 03:17:32", "2025-09-03 03:17:32", "277", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3162", "woocommerce_refresh_order_count_cache", "complete", "2025-09-03 15:17:32", "2025-09-03 15:17:32", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756912652;s:18:\"\0*\0first_timestamp\";i:1756517174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756912652;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-09-03 15:20:40", "2025-09-03 15:20:40", "365", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3163", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-03 04:17:32", "2025-09-03 04:17:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756873052;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756873052;}", "9", "1", "2025-09-03 04:26:07", "2025-09-03 04:26:07", "286", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3164", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-03 05:26:07", "2025-09-03 05:26:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756877167;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756877167;}", "9", "1", "2025-09-03 05:33:11", "2025-09-03 05:33:11", "294", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3165", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-03 06:33:11", "2025-09-03 06:33:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756881191;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756881191;}", "9", "1", "2025-09-03 06:35:44", "2025-09-03 06:35:44", "303", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3166", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-03 07:35:44", "2025-09-03 07:35:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756884944;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756884944;}", "9", "1", "2025-09-03 07:36:22", "2025-09-03 07:36:22", "309", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3167", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-03 08:36:22", "2025-09-03 08:36:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756888582;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756888582;}", "9", "1", "2025-09-03 08:37:26", "2025-09-03 08:37:26", "317", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3168", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-03 09:37:26", "2025-09-03 09:37:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756892246;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756892246;}", "9", "1", "2025-09-03 09:43:12", "2025-09-03 09:43:12", "326", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3169", "woocommerce_cleanup_sessions", "complete", "2025-09-03 21:16:17", "2025-09-03 21:16:17", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756934177;s:18:\"\0*\0first_timestamp\";i:1756495574;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756934177;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-03 21:23:33", "2025-09-03 21:23:33", "415", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3170", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-03 10:43:12", "2025-09-03 10:43:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756896192;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756896192;}", "9", "1", "2025-09-03 10:45:43", "2025-09-03 10:45:43", "331", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3171", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-03 11:45:43", "2025-09-03 11:45:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756899943;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756899943;}", "9", "1", "2025-09-03 11:58:44", "2025-09-03 11:58:44", "348", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3172", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-03 12:58:44", "2025-09-03 12:58:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756904324;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756904324;}", "9", "1", "2025-09-03 13:07:37", "2025-09-03 13:07:37", "356", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3173", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-03 14:07:37", "2025-09-03 14:07:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756908457;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756908457;}", "9", "1", "2025-09-03 15:08:19", "2025-09-03 15:08:19", "363", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3174", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-03 16:08:19", "2025-09-03 16:08:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756915699;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756915699;}", "9", "1", "2025-09-03 16:24:34", "2025-09-03 16:24:34", "369", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3175", "woocommerce_cleanup_draft_orders", "complete", "2025-09-04 15:08:19", "2025-09-04 15:08:19", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756998499;s:18:\"\0*\0first_timestamp\";i:1756473726;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756998499;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-09-04 15:09:21", "2025-09-04 15:09:21", "526", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3176", "wc_admin_daily_wrapper", "complete", "2025-09-04 15:08:21", "2025-09-04 15:08:21", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756998501;s:18:\"\0*\0first_timestamp\";i:1756473974;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756998501;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-04 15:09:25", "2025-09-04 15:09:25", "526", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3177", "woocommerce_cleanup_personal_data", "complete", "2025-09-04 15:08:22", "2025-09-04 15:08:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756998502;s:18:\"\0*\0first_timestamp\";i:1756473984;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756998502;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-04 15:09:26", "2025-09-04 15:09:26", "526", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3178", "woocommerce_tracker_send_event_wrapper", "complete", "2025-09-04 15:08:22", "2025-09-04 15:08:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756998502;s:18:\"\0*\0first_timestamp\";i:1756473984;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756998502;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-04 15:09:26", "2025-09-04 15:09:26", "526", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3179", "generate_category_lookup_table_wrapper", "complete", "2025-09-03 15:08:32", "2025-09-03 15:08:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756912112;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756912112;}", "9", "1", "2025-09-03 15:20:39", "2025-09-03 15:20:39", "365", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3180", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-04 15:08:22", "2025-09-04 15:08:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756998502;s:18:\"\0*\0first_timestamp\";i:1756473948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756998502;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-09-04 15:09:26", "2025-09-04 15:09:26", "526", NULL, "20");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3181", "woocommerce_refresh_order_count_cache", "complete", "2025-09-04 03:20:40", "2025-09-04 03:20:40", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756956040;s:18:\"\0*\0first_timestamp\";i:1756517174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756956040;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-09-04 04:10:24", "2025-09-04 04:10:24", "457", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3182", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-03 17:24:34", "2025-09-03 17:24:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756920274;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756920274;}", "9", "1", "2025-09-03 17:44:43", "2025-09-03 17:44:43", "380", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3183", "woocommerce_cleanup_logs", "complete", "2025-09-04 17:44:43", "2025-09-04 17:44:43", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757007883;s:18:\"\0*\0first_timestamp\";i:1756484774;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757007883;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-04 17:47:27", "2025-09-04 17:47:27", "556", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3184", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-09-04 17:44:43", "2025-09-04 17:44:43", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757007883;s:18:\"\0*\0first_timestamp\";i:1756484774;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757007883;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-04 17:47:28", "2025-09-04 17:47:28", "556", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3185", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-03 18:44:43", "2025-09-03 18:44:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756925083;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756925083;}", "9", "1", "2025-09-03 18:48:14", "2025-09-03 18:48:14", "390", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3186", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-03 19:48:14", "2025-09-03 19:48:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756928894;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756928894;}", "9", "1", "2025-09-03 19:50:29", "2025-09-03 19:50:29", "401", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3187", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-03 20:50:29", "2025-09-03 20:50:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756932629;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756932629;}", "9", "1", "2025-09-03 21:23:33", "2025-09-03 21:23:33", "415", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3188", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-03 22:23:33", "2025-09-03 22:23:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756938213;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756938213;}", "9", "1", "2025-09-03 22:29:25", "2025-09-03 22:29:25", "421", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3189", "woocommerce_cleanup_sessions", "complete", "2025-09-04 09:23:33", "2025-09-04 09:23:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756977813;s:18:\"\0*\0first_timestamp\";i:1756495574;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756977813;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-04 09:31:42", "2025-09-04 09:31:42", "490", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3190", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-03 23:29:25", "2025-09-03 23:29:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756942165;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756942165;}", "9", "1", "2025-09-03 23:47:29", "2025-09-03 23:47:29", "427", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3191", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-04 00:47:28", "2025-09-04 00:47:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756946848;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756946848;}", "9", "1", "2025-09-04 00:49:00", "2025-09-04 00:49:00", "437", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3192", "woocommerce_scheduled_sales", "complete", "2025-09-05 00:30:42", "2025-09-05 00:30:42", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757032242;s:18:\"\0*\0first_timestamp\";i:1756512000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757032242;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-05 00:47:21", "2025-09-05 00:47:21", "615", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3193", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-04 01:49:00", "2025-09-04 01:49:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756950540;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756950540;}", "9", "1", "2025-09-04 01:50:29", "2025-09-04 01:50:29", "440", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3194", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-04 02:50:29", "2025-09-04 02:50:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756954229;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756954229;}", "9", "1", "2025-09-04 03:02:14", "2025-09-04 03:02:14", "454", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3195", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-04 04:02:14", "2025-09-04 04:02:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756958534;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756958534;}", "9", "1", "2025-09-04 04:10:24", "2025-09-04 04:10:24", "457", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3196", "woocommerce_refresh_order_count_cache", "complete", "2025-09-04 16:10:24", "2025-09-04 16:10:24", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757002224;s:18:\"\0*\0first_timestamp\";i:1756517174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757002224;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-09-04 16:18:21", "2025-09-04 16:18:21", "537", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3197", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-04 05:10:24", "2025-09-04 05:10:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756962624;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756962624;}", "9", "1", "2025-09-04 05:11:03", "2025-09-04 05:11:03", "465", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3198", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-04 06:11:03", "2025-09-04 06:11:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756966263;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756966263;}", "9", "1", "2025-09-04 07:18:22", "2025-09-04 07:18:22", "475", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3199", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-04 08:18:22", "2025-09-04 08:18:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756973902;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756973902;}", "9", "1", "2025-09-04 08:36:18", "2025-09-04 08:36:18", "484", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3200", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-04 09:36:18", "2025-09-04 09:36:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756978578;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756978578;}", "9", "1", "2025-09-04 09:46:27", "2025-09-04 09:46:27", "492", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3201", "woocommerce_cleanup_sessions", "complete", "2025-09-04 21:31:42", "2025-09-04 21:31:42", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757021502;s:18:\"\0*\0first_timestamp\";i:1756495574;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757021502;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-04 21:32:21", "2025-09-04 21:32:21", "590", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3202", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-04 10:46:27", "2025-09-04 10:46:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756982787;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756982787;}", "9", "1", "2025-09-04 10:54:05", "2025-09-04 10:54:05", "499", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3203", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-04 11:54:05", "2025-09-04 11:54:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756986845;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756986845;}", "9", "1", "2025-09-04 11:55:57", "2025-09-04 11:55:57", "505", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3204", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-04 12:55:57", "2025-09-04 12:55:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756990557;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756990557;}", "9", "1", "2025-09-04 13:03:05", "2025-09-04 13:03:05", "511", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3205", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-04 14:03:05", "2025-09-04 14:03:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756994585;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756994585;}", "9", "1", "2025-09-04 14:07:48", "2025-09-04 14:07:48", "518", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3206", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-04 15:07:48", "2025-09-04 15:07:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756998468;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756998468;}", "9", "1", "2025-09-04 15:09:21", "2025-09-04 15:09:21", "526", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3207", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-04 16:09:21", "2025-09-04 16:09:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757002161;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757002161;}", "9", "1", "2025-09-04 16:18:21", "2025-09-04 16:18:21", "537", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3208", "woocommerce_cleanup_draft_orders", "complete", "2025-09-05 15:09:21", "2025-09-05 15:09:21", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757084961;s:18:\"\0*\0first_timestamp\";i:1756473726;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757084961;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-09-05 15:17:32", "2025-09-05 15:17:32", "705", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3209", "wc_admin_daily_wrapper", "complete", "2025-09-05 15:09:25", "2025-09-05 15:09:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757084965;s:18:\"\0*\0first_timestamp\";i:1756473974;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757084965;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-05 15:17:35", "2025-09-05 15:17:35", "705", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3210", "woocommerce_cleanup_personal_data", "complete", "2025-09-05 15:09:26", "2025-09-05 15:09:26", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757084966;s:18:\"\0*\0first_timestamp\";i:1756473984;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757084966;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-05 15:17:35", "2025-09-05 15:17:35", "705", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3211", "woocommerce_tracker_send_event_wrapper", "complete", "2025-09-05 15:09:26", "2025-09-05 15:09:26", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757084966;s:18:\"\0*\0first_timestamp\";i:1756473984;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757084966;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-05 15:17:36", "2025-09-05 15:17:36", "705", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3212", "generate_category_lookup_table_wrapper", "complete", "2025-09-04 15:09:36", "2025-09-04 15:09:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1756998576;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1756998576;}", "9", "1", "2025-09-04 15:10:11", "2025-09-04 15:10:11", "528", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3213", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-05 15:09:26", "2025-09-05 15:09:26", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757084966;s:18:\"\0*\0first_timestamp\";i:1756473948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757084966;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-09-05 15:17:36", "2025-09-05 15:17:36", "705", NULL, "20");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3214", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-04 17:18:21", "2025-09-04 17:18:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757006301;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757006301;}", "9", "1", "2025-09-04 17:44:15", "2025-09-04 17:44:15", "553", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3215", "woocommerce_refresh_order_count_cache", "complete", "2025-09-05 04:18:21", "2025-09-05 04:18:21", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757045901;s:18:\"\0*\0first_timestamp\";i:1756517174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757045901;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-09-05 05:10:15", "2025-09-05 05:10:15", "656", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3216", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-04 18:44:15", "2025-09-04 18:44:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757011455;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757011455;}", "9", "1", "2025-09-04 18:53:51", "2025-09-04 18:53:51", "566", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3217", "woocommerce_cleanup_logs", "complete", "2025-09-05 17:47:27", "2025-09-05 17:47:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757094447;s:18:\"\0*\0first_timestamp\";i:1756484774;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757094447;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-05 18:03:16", "2025-09-05 18:03:16", "723", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3218", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-09-05 17:47:28", "2025-09-05 17:47:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757094448;s:18:\"\0*\0first_timestamp\";i:1756484774;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757094448;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-05 18:03:17", "2025-09-05 18:03:17", "723", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3219", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-04 19:53:51", "2025-09-04 19:53:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757015631;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757015631;}", "9", "1", "2025-09-04 19:54:12", "2025-09-04 19:54:12", "578", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3220", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-04 20:54:12", "2025-09-04 20:54:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757019252;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757019252;}", "9", "1", "2025-09-04 21:11:10", "2025-09-04 21:11:10", "586", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3221", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-04 22:11:09", "2025-09-04 22:11:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757023869;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757023869;}", "9", "1", "2025-09-04 22:16:33", "2025-09-04 22:16:33", "598", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3222", "woocommerce_cleanup_sessions", "complete", "2025-09-05 09:32:21", "2025-09-05 09:32:21", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757064741;s:18:\"\0*\0first_timestamp\";i:1756495574;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757064741;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-05 09:33:26", "2025-09-05 09:33:26", "669", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3223", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-04 23:16:33", "2025-09-04 23:16:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757027793;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757027793;}", "9", "1", "2025-09-04 23:19:25", "2025-09-04 23:19:25", "606", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3224", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-05 00:19:25", "2025-09-05 00:19:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757031565;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757031565;}", "9", "1", "2025-09-05 00:23:26", "2025-09-05 00:23:26", "613", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3225", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-05 01:23:26", "2025-09-05 01:23:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757035406;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757035406;}", "9", "1", "2025-09-05 01:28:11", "2025-09-05 01:28:11", "621", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3226", "woocommerce_scheduled_sales", "complete", "2025-09-06 00:47:21", "2025-09-06 00:47:21", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757119641;s:18:\"\0*\0first_timestamp\";i:1756512000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757119641;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-06 01:44:16", "2025-09-06 01:44:16", "747", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3227", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-05 02:28:10", "2025-09-05 02:28:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757039290;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757039290;}", "9", "1", "2025-09-05 02:29:39", "2025-09-05 02:29:39", "629", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3228", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-05 03:29:39", "2025-09-05 03:29:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757042979;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757042979;}", "9", "1", "2025-09-05 03:44:36", "2025-09-05 03:44:36", "645", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3229", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-05 04:44:36", "2025-09-05 04:44:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757047476;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757047476;}", "9", "1", "2025-09-05 05:10:15", "2025-09-05 05:10:15", "656", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3230", "woocommerce_refresh_order_count_cache", "complete", "2025-09-05 17:10:15", "2025-09-05 17:10:15", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757092215;s:18:\"\0*\0first_timestamp\";i:1756517174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757092215;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-09-05 18:03:16", "2025-09-05 18:03:16", "723", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3231", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-05 06:10:15", "2025-09-05 06:10:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757052615;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757052615;}", "9", "1", "2025-09-05 06:23:47", "2025-09-05 06:23:47", "659", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3232", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-05 07:23:47", "2025-09-05 07:23:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757057027;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757057027;}", "9", "1", "2025-09-05 07:42:07", "2025-09-05 07:42:07", "662", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3233", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-05 08:42:07", "2025-09-05 08:42:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757061727;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757061727;}", "9", "1", "2025-09-05 08:48:31", "2025-09-05 08:48:31", "666", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3234", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-05 09:48:31", "2025-09-05 09:48:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757065711;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757065711;}", "9", "1", "2025-09-05 09:49:00", "2025-09-05 09:49:00", "671", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3235", "woocommerce_cleanup_sessions", "complete", "2025-09-05 21:33:26", "2025-09-05 21:33:26", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757108006;s:18:\"\0*\0first_timestamp\";i:1756495574;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757108006;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-05 23:21:37", "2025-09-05 23:21:37", "741", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3236", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-05 10:49:00", "2025-09-05 10:49:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757069340;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757069340;}", "9", "1", "2025-09-05 11:04:31", "2025-09-05 11:04:31", "676", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3237", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-05 12:04:30", "2025-09-05 12:04:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757073870;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757073870;}", "9", "1", "2025-09-05 12:13:03", "2025-09-05 12:13:03", "684", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3238", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-05 13:13:03", "2025-09-05 13:13:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757077983;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757077983;}", "9", "1", "2025-09-05 13:20:10", "2025-09-05 13:20:10", "691", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3239", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-05 14:20:09", "2025-09-05 14:20:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757082009;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757082009;}", "9", "1", "2025-09-05 14:21:16", "2025-09-05 14:21:16", "700", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3240", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-05 15:21:16", "2025-09-05 15:21:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757085676;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757085676;}", "9", "1", "2025-09-05 15:22:04", "2025-09-05 15:22:04", "713", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3241", "woocommerce_cleanup_draft_orders", "complete", "2025-09-06 15:17:32", "2025-09-06 15:17:32", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757171852;s:18:\"\0*\0first_timestamp\";i:1756473726;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757171852;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-09-06 15:33:20", "2025-09-06 15:33:20", "808", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3242", "wc_admin_daily_wrapper", "complete", "2025-09-06 15:17:35", "2025-09-06 15:17:35", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757171855;s:18:\"\0*\0first_timestamp\";i:1756473974;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757171855;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-06 15:33:21", "2025-09-06 15:33:21", "808", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3243", "woocommerce_cleanup_personal_data", "complete", "2025-09-06 15:17:35", "2025-09-06 15:17:35", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757171855;s:18:\"\0*\0first_timestamp\";i:1756473984;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757171855;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-06 15:33:22", "2025-09-06 15:33:22", "808", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3244", "woocommerce_tracker_send_event_wrapper", "complete", "2025-09-06 15:17:36", "2025-09-06 15:17:36", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757171856;s:18:\"\0*\0first_timestamp\";i:1756473984;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757171856;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-06 15:33:22", "2025-09-06 15:33:22", "808", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3245", "generate_category_lookup_table_wrapper", "complete", "2025-09-05 15:17:46", "2025-09-05 15:17:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757085466;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757085466;}", "9", "1", "2025-09-05 15:18:47", "2025-09-05 15:18:47", "707", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3246", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-06 15:17:36", "2025-09-06 15:17:36", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757171856;s:18:\"\0*\0first_timestamp\";i:1756473948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757171856;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-09-06 15:33:22", "2025-09-06 15:33:22", "808", NULL, "20");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3247", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-05 16:22:04", "2025-09-05 16:22:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757089324;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757089324;}", "9", "1", "2025-09-05 16:28:25", "2025-09-05 16:28:25", "719", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3248", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-05 17:28:25", "2025-09-05 17:28:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757093305;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757093305;}", "9", "1", "2025-09-05 18:03:16", "2025-09-05 18:03:16", "723", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3249", "woocommerce_refresh_order_count_cache", "complete", "2025-09-06 06:03:16", "2025-09-06 06:03:16", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757138596;s:18:\"\0*\0first_timestamp\";i:1756517174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757138596;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-09-06 07:33:24", "2025-09-06 07:33:24", "769", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3250", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-05 19:03:16", "2025-09-05 19:03:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757098996;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757098996;}", "9", "1", "2025-09-05 19:07:34", "2025-09-05 19:07:34", "729", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3251", "woocommerce_cleanup_logs", "complete", "2025-09-06 18:03:16", "2025-09-06 18:03:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757181796;s:18:\"\0*\0first_timestamp\";i:1756484774;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757181796;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-06 18:04:03", "2025-09-06 18:04:03", "823", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3252", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-09-06 18:03:17", "2025-09-06 18:03:17", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757181797;s:18:\"\0*\0first_timestamp\";i:1756484774;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757181797;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-06 18:04:03", "2025-09-06 18:04:03", "823", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3253", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-05 20:07:34", "2025-09-05 20:07:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757102854;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757102854;}", "9", "1", "2025-09-05 20:12:32", "2025-09-05 20:12:32", "734", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3254", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-05 21:12:31", "2025-09-05 21:12:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757106751;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757106751;}", "9", "1", "2025-09-05 21:19:15", "2025-09-05 21:19:15", "739", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3255", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-05 22:19:15", "2025-09-05 22:19:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757110755;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757110755;}", "9", "1", "2025-09-05 23:21:37", "2025-09-05 23:21:37", "741", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3256", "woocommerce_cleanup_sessions", "complete", "2025-09-06 11:21:37", "2025-09-06 11:21:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757157697;s:18:\"\0*\0first_timestamp\";i:1756495574;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757157697;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-06 11:28:04", "2025-09-06 11:28:04", "790", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3257", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-06 00:21:37", "2025-09-06 00:21:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757118097;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757118097;}", "9", "1", "2025-09-06 00:22:11", "2025-09-06 00:22:11", "744", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3258", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-06 01:22:11", "2025-09-06 01:22:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757121731;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757121731;}", "9", "1", "2025-09-06 01:44:17", "2025-09-06 01:44:17", "747", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3259", "woocommerce_scheduled_sales", "complete", "2025-09-07 01:44:16", "2025-09-07 01:44:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757209456;s:18:\"\0*\0first_timestamp\";i:1756512000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757209456;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-07 02:04:13", "2025-09-07 02:04:13", "850", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3260", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-06 02:44:16", "2025-09-06 02:44:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757126656;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757126656;}", "9", "1", "2025-09-06 03:01:10", "2025-09-06 03:01:10", "751", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3261", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-06 04:01:10", "2025-09-06 04:01:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757131270;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757131270;}", "9", "1", "2025-09-06 04:02:05", "2025-09-06 04:02:05", "757", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3262", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-06 05:02:05", "2025-09-06 05:02:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757134925;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757134925;}", "9", "1", "2025-09-06 05:21:22", "2025-09-06 05:21:22", "765", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3263", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-06 06:21:22", "2025-09-06 06:21:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757139682;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757139682;}", "9", "1", "2025-09-06 07:33:24", "2025-09-06 07:33:24", "769", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3264", "woocommerce_refresh_order_count_cache", "complete", "2025-09-06 19:33:24", "2025-09-06 19:33:24", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757187204;s:18:\"\0*\0first_timestamp\";i:1756517174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757187204;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-09-06 19:48:45", "2025-09-06 19:48:45", "831", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3265", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-06 08:33:24", "2025-09-06 08:33:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757147604;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757147604;}", "9", "1", "2025-09-06 08:40:31", "2025-09-06 08:40:31", "774", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3266", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-06 09:40:31", "2025-09-06 09:40:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757151631;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757151631;}", "9", "1", "2025-09-06 09:53:41", "2025-09-06 09:53:41", "779", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3267", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-06 10:53:41", "2025-09-06 10:53:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757156021;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757156021;}", "9", "1", "2025-09-06 10:58:12", "2025-09-06 10:58:12", "787", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3268", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-06 11:58:12", "2025-09-06 11:58:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757159892;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757159892;}", "9", "1", "2025-09-06 12:10:02", "2025-09-06 12:10:02", "793", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3269", "woocommerce_cleanup_sessions", "complete", "2025-09-06 23:28:04", "2025-09-06 23:28:04", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757201284;s:18:\"\0*\0first_timestamp\";i:1756495574;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757201284;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-07 00:41:28", "2025-09-07 00:41:28", "844", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3270", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-06 13:10:02", "2025-09-06 13:10:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757164202;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757164202;}", "9", "1", "2025-09-06 13:39:39", "2025-09-06 13:39:39", "797", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3271", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-06 14:39:39", "2025-09-06 14:39:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757169579;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757169579;}", "9", "1", "2025-09-06 14:39:48", "2025-09-06 14:39:48", "804", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3272", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-06 15:39:48", "2025-09-06 15:39:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757173188;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757173188;}", "9", "1", "2025-09-06 15:45:53", "2025-09-06 15:45:53", "810", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3273", "woocommerce_cleanup_draft_orders", "complete", "2025-09-07 15:33:20", "2025-09-07 15:33:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757259200;s:18:\"\0*\0first_timestamp\";i:1756473726;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757259200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-09-07 15:36:08", "2025-09-07 15:36:08", "906", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3274", "wc_admin_daily_wrapper", "complete", "2025-09-07 15:33:21", "2025-09-07 15:33:21", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757259201;s:18:\"\0*\0first_timestamp\";i:1756473974;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757259201;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-07 15:36:10", "2025-09-07 15:36:10", "906", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3275", "woocommerce_cleanup_personal_data", "complete", "2025-09-07 15:33:22", "2025-09-07 15:33:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757259202;s:18:\"\0*\0first_timestamp\";i:1756473984;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757259202;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-07 15:36:11", "2025-09-07 15:36:11", "906", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3276", "woocommerce_tracker_send_event_wrapper", "complete", "2025-09-07 15:33:22", "2025-09-07 15:33:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757259202;s:18:\"\0*\0first_timestamp\";i:1756473984;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757259202;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-07 15:36:11", "2025-09-07 15:36:11", "906", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3277", "generate_category_lookup_table_wrapper", "complete", "2025-09-06 15:33:32", "2025-09-06 15:33:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757172812;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757172812;}", "9", "1", "2025-09-06 15:45:53", "2025-09-06 15:45:53", "810", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3278", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-07 15:33:22", "2025-09-07 15:33:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757259202;s:18:\"\0*\0first_timestamp\";i:1756473948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757259202;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2025-09-07 15:36:11", "2025-09-07 15:36:11", "906", NULL, "20");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3279", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-06 16:45:53", "2025-09-06 16:45:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757177153;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757177153;}", "9", "1", "2025-09-06 17:00:38", "2025-09-06 17:00:38", "817", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3280", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-06 18:00:38", "2025-09-06 18:00:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757181638;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757181638;}", "9", "1", "2025-09-06 18:04:03", "2025-09-06 18:04:03", "823", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3281", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-06 19:04:03", "2025-09-06 19:04:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757185443;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757185443;}", "9", "1", "2025-09-06 19:32:35", "2025-09-06 19:32:35", "829", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3282", "woocommerce_cleanup_logs", "complete", "2025-09-07 18:04:03", "2025-09-07 18:04:03", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757268243;s:18:\"\0*\0first_timestamp\";i:1756484774;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757268243;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-07 18:17:26", "2025-09-07 18:17:26", "927", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3283", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-09-07 18:04:03", "2025-09-07 18:04:03", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757268243;s:18:\"\0*\0first_timestamp\";i:1756484774;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757268243;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "1", "2025-09-07 18:17:27", "2025-09-07 18:17:27", "927", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3284", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-06 20:32:35", "2025-09-06 20:32:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757190755;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757190755;}", "9", "1", "2025-09-06 21:03:08", "2025-09-06 21:03:08", "838", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3285", "woocommerce_refresh_order_count_cache", "complete", "2025-09-07 07:48:45", "2025-09-07 07:48:45", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757231325;s:18:\"\0*\0first_timestamp\";i:1756517174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757231325;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "1", "2025-09-07 08:00:25", "2025-09-07 08:00:25", "871", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3286", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-06 22:03:08", "2025-09-06 22:03:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757196188;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757196188;}", "9", "1", "2025-09-06 22:07:41", "2025-09-06 22:07:41", "840", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3287", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-06 23:07:41", "2025-09-06 23:07:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757200061;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757200061;}", "9", "1", "2025-09-07 00:41:27", "2025-09-07 00:41:27", "844", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3288", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-07 01:41:27", "2025-09-07 01:41:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757209287;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757209287;}", "9", "1", "2025-09-07 01:41:29", "2025-09-07 01:41:29", "848", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3289", "woocommerce_cleanup_sessions", "complete", "2025-09-07 12:41:28", "2025-09-07 12:41:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757248888;s:18:\"\0*\0first_timestamp\";i:1756495574;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757248888;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-07 12:47:55", "2025-09-07 12:47:55", "888", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3290", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-07 02:41:29", "2025-09-07 02:41:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757212889;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757212889;}", "9", "1", "2025-09-07 03:22:27", "2025-09-07 03:22:27", "855", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3291", "woocommerce_scheduled_sales", "pending", "2025-09-08 02:04:13", "2025-09-08 02:04:13", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757297053;s:18:\"\0*\0first_timestamp\";i:1756512000;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757297053;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3292", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-07 04:22:27", "2025-09-07 04:22:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757218947;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757218947;}", "9", "1", "2025-09-07 04:41:34", "2025-09-07 04:41:34", "859", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3293", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-07 05:41:34", "2025-09-07 05:41:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757223694;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757223694;}", "9", "1", "2025-09-07 05:42:59", "2025-09-07 05:42:59", "864", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3294", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-07 06:42:59", "2025-09-07 06:42:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757227379;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757227379;}", "9", "1", "2025-09-07 06:49:34", "2025-09-07 06:49:34", "868", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3295", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-07 07:49:34", "2025-09-07 07:49:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757231374;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757231374;}", "9", "1", "2025-09-07 08:00:25", "2025-09-07 08:00:25", "871", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3296", "woocommerce_refresh_order_count_cache", "pending", "2025-09-07 20:00:25", "2025-09-07 20:00:25", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757275225;s:18:\"\0*\0first_timestamp\";i:1756517174;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757275225;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "10", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3297", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-07 09:00:25", "2025-09-07 09:00:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757235625;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757235625;}", "9", "1", "2025-09-07 09:57:41", "2025-09-07 09:57:41", "875", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3298", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-07 10:57:41", "2025-09-07 10:57:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757242661;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757242661;}", "9", "1", "2025-09-07 11:15:17", "2025-09-07 11:15:17", "879", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3299", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-07 12:15:17", "2025-09-07 12:15:17", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757247317;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757247317;}", "9", "1", "2025-09-07 12:25:06", "2025-09-07 12:25:06", "884", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3300", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-07 13:25:06", "2025-09-07 13:25:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757251506;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757251506;}", "9", "1", "2025-09-07 13:46:49", "2025-09-07 13:46:49", "893", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3301", "woocommerce_cleanup_sessions", "pending", "2025-09-08 00:47:55", "2025-09-08 00:47:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757292475;s:18:\"\0*\0first_timestamp\";i:1756495574;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757292475;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3302", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-07 14:46:49", "2025-09-07 14:46:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757256409;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757256409;}", "9", "1", "2025-09-07 14:53:41", "2025-09-07 14:53:41", "899", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3303", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-07 15:53:41", "2025-09-07 15:53:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757260421;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757260421;}", "9", "1", "2025-09-07 15:57:24", "2025-09-07 15:57:24", "914", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3304", "woocommerce_cleanup_draft_orders", "pending", "2025-09-08 15:36:08", "2025-09-08 15:36:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757345768;s:18:\"\0*\0first_timestamp\";i:1756473726;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757345768;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3305", "wc_admin_daily_wrapper", "pending", "2025-09-08 15:36:10", "2025-09-08 15:36:10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757345770;s:18:\"\0*\0first_timestamp\";i:1756473974;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757345770;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3306", "woocommerce_cleanup_personal_data", "pending", "2025-09-08 15:36:11", "2025-09-08 15:36:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757345771;s:18:\"\0*\0first_timestamp\";i:1756473984;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757345771;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3307", "woocommerce_tracker_send_event_wrapper", "pending", "2025-09-08 15:36:11", "2025-09-08 15:36:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757345771;s:18:\"\0*\0first_timestamp\";i:1756473984;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757345771;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3308", "generate_category_lookup_table_wrapper", "complete", "2025-09-07 15:36:21", "2025-09-07 15:36:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757259381;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757259381;}", "9", "1", "2025-09-07 15:39:16", "2025-09-07 15:39:16", "908", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3309", "action_scheduler_run_recurring_actions_schedule_hook", "pending", "2025-09-08 15:36:11", "2025-09-08 15:36:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757345771;s:18:\"\0*\0first_timestamp\";i:1756473948;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757345771;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "20");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3310", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-07 16:57:24", "2025-09-07 16:57:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757264244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757264244;}", "9", "1", "2025-09-07 17:20:05", "2025-09-07 17:20:05", "924", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3311", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-07 18:20:05", "2025-09-07 18:20:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757269205;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757269205;}", "9", "1", "2025-09-07 18:34:55", "2025-09-07 18:34:55", "929", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3312", "woocommerce_cleanup_logs", "pending", "2025-09-08 18:17:26", "2025-09-08 18:17:26", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757355446;s:18:\"\0*\0first_timestamp\";i:1756484774;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757355446;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3313", "woocommerce_cleanup_rate_limits_wrapper", "pending", "2025-09-08 18:17:27", "2025-09-08 18:17:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757355447;s:18:\"\0*\0first_timestamp\";i:1756484774;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757355447;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wpge_actionscheduler_actions` VALUES("3314", "woocommerce_cancel_unpaid_orders", "pending", "2025-09-07 19:34:55", "2025-09-07 19:34:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757273695;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757273695;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");

/* INSERT TABLE DATA: wpge_actionscheduler_groups */
INSERT INTO `wpge_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wpge_actionscheduler_groups` VALUES("2", "woocommerce-db-updates");
INSERT INTO `wpge_actionscheduler_groups` VALUES("3", "wc_update_product_lookup_tables");
INSERT INTO `wpge_actionscheduler_groups` VALUES("4", "wc-admin-data");
INSERT INTO `wpge_actionscheduler_groups` VALUES("5", "wc_update_product_default_cat");
INSERT INTO `wpge_actionscheduler_groups` VALUES("6", "woocommerce-remote-inbox-engine");
INSERT INTO `wpge_actionscheduler_groups` VALUES("7", "");
INSERT INTO `wpge_actionscheduler_groups` VALUES("8", "ActionScheduler");
INSERT INTO `wpge_actionscheduler_groups` VALUES("9", "woocommerce");
INSERT INTO `wpge_actionscheduler_groups` VALUES("10", "count");

/* INSERT TABLE DATA: wpge_actionscheduler_logs */
INSERT INTO `wpge_actionscheduler_logs` VALUES("601", "2905", "acción creada", "2025-08-29 03:38:58", "2025-08-29 03:38:58");
INSERT INTO `wpge_actionscheduler_logs` VALUES("602", "2905", "acción empezada vía WP Cron", "2025-08-29 03:40:15", "2025-08-29 03:40:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("603", "2905", "acción completa vía WP Cron", "2025-08-29 03:40:15", "2025-08-29 03:40:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("604", "2906", "action created", "2025-08-29 13:17:21", "2025-08-29 13:17:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("605", "2907", "action created", "2025-08-29 13:17:21", "2025-08-29 13:17:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("606", "2908", "action created", "2025-08-29 13:17:21", "2025-08-29 13:17:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("607", "2909", "action created", "2025-08-29 13:17:21", "2025-08-29 13:17:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("608", "2910", "action created", "2025-08-29 13:17:21", "2025-08-29 13:17:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("609", "2911", "action created", "2025-08-29 13:17:21", "2025-08-29 13:17:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("610", "2912", "action created", "2025-08-29 13:17:48", "2025-08-29 13:17:48");
INSERT INTO `wpge_actionscheduler_logs` VALUES("611", "2913", "action created", "2025-08-29 13:17:48", "2025-08-29 13:17:48");
INSERT INTO `wpge_actionscheduler_logs` VALUES("612", "2914", "action created", "2025-08-29 13:17:48", "2025-08-29 13:17:48");
INSERT INTO `wpge_actionscheduler_logs` VALUES("613", "2915", "action created", "2025-08-29 13:17:48", "2025-08-29 13:17:48");
INSERT INTO `wpge_actionscheduler_logs` VALUES("614", "2916", "action created", "2025-08-29 13:17:48", "2025-08-29 13:17:48");
INSERT INTO `wpge_actionscheduler_logs` VALUES("615", "2917", "action created", "2025-08-29 13:17:48", "2025-08-29 13:17:48");
INSERT INTO `wpge_actionscheduler_logs` VALUES("616", "2906", "action started via WP Cron", "2025-08-29 13:18:24", "2025-08-29 13:18:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("617", "2906", "action complete via WP Cron", "2025-08-29 13:18:24", "2025-08-29 13:18:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("618", "2907", "action started via WP Cron", "2025-08-29 13:18:24", "2025-08-29 13:18:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("619", "2907", "action complete via WP Cron", "2025-08-29 13:18:24", "2025-08-29 13:18:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("620", "2908", "action started via WP Cron", "2025-08-29 13:18:24", "2025-08-29 13:18:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("621", "2908", "action complete via WP Cron", "2025-08-29 13:18:24", "2025-08-29 13:18:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("622", "2909", "action started via WP Cron", "2025-08-29 13:18:24", "2025-08-29 13:18:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("623", "2909", "action complete via WP Cron", "2025-08-29 13:18:24", "2025-08-29 13:18:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("624", "2910", "action started via WP Cron", "2025-08-29 13:18:24", "2025-08-29 13:18:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("625", "2910", "action complete via WP Cron", "2025-08-29 13:18:25", "2025-08-29 13:18:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("626", "2911", "action started via WP Cron", "2025-08-29 13:18:25", "2025-08-29 13:18:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("627", "2911", "action complete via WP Cron", "2025-08-29 13:18:25", "2025-08-29 13:18:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("628", "2912", "action started via WP Cron", "2025-08-29 13:18:25", "2025-08-29 13:18:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("629", "2912", "action complete via WP Cron", "2025-08-29 13:18:25", "2025-08-29 13:18:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("630", "2913", "action started via WP Cron", "2025-08-29 13:18:25", "2025-08-29 13:18:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("631", "2913", "action complete via WP Cron", "2025-08-29 13:18:25", "2025-08-29 13:18:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("632", "2914", "action started via WP Cron", "2025-08-29 13:18:25", "2025-08-29 13:18:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("633", "2914", "action complete via WP Cron", "2025-08-29 13:18:25", "2025-08-29 13:18:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("634", "2915", "action started via WP Cron", "2025-08-29 13:18:25", "2025-08-29 13:18:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("635", "2915", "action complete via WP Cron", "2025-08-29 13:18:25", "2025-08-29 13:18:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("636", "2916", "action started via WP Cron", "2025-08-29 13:18:25", "2025-08-29 13:18:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("637", "2916", "action complete via WP Cron", "2025-08-29 13:18:25", "2025-08-29 13:18:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("638", "2917", "action started via WP Cron", "2025-08-29 13:18:25", "2025-08-29 13:18:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("639", "2917", "action complete via WP Cron", "2025-08-29 13:18:25", "2025-08-29 13:18:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("640", "2918", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("641", "2919", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("642", "2920", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("643", "2921", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("644", "2922", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("645", "2923", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("646", "2924", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("647", "2925", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("648", "2926", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("649", "2927", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("650", "2928", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("651", "2929", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("652", "2930", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("653", "2931", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("654", "2932", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("655", "2933", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("656", "2934", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("657", "2935", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("658", "2936", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("659", "2937", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("660", "2938", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("661", "2939", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("662", "2940", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("663", "2941", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("664", "2942", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("665", "2943", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("666", "2944", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("667", "2945", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("668", "2946", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("669", "2947", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("670", "2948", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("671", "2949", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("672", "2950", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("673", "2951", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("674", "2952", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("675", "2953", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("676", "2954", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("677", "2955", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("678", "2956", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("679", "2957", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("680", "2958", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("681", "2959", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("682", "2960", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("683", "2961", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("684", "2962", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("685", "2963", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("686", "2964", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("687", "2965", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("688", "2966", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("689", "2967", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("690", "2968", "acción creada", "2025-08-29 13:22:03", "2025-08-29 13:22:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("691", "2969", "acción creada", "2025-08-29 13:22:06", "2025-08-29 13:22:06");
INSERT INTO `wpge_actionscheduler_logs` VALUES("692", "2970", "acción creada", "2025-08-29 13:22:06", "2025-08-29 13:22:06");
INSERT INTO `wpge_actionscheduler_logs` VALUES("693", "2971", "acción creada", "2025-08-29 13:22:06", "2025-08-29 13:22:06");
INSERT INTO `wpge_actionscheduler_logs` VALUES("694", "2918", "acción empezada vía WP Cron", "2025-08-29 13:22:06", "2025-08-29 13:22:06");
INSERT INTO `wpge_actionscheduler_logs` VALUES("695", "2918", "acción completa vía WP Cron", "2025-08-29 13:22:06", "2025-08-29 13:22:06");
INSERT INTO `wpge_actionscheduler_logs` VALUES("696", "2919", "acción empezada vía WP Cron", "2025-08-29 13:22:06", "2025-08-29 13:22:06");
INSERT INTO `wpge_actionscheduler_logs` VALUES("697", "2919", "acción completa vía WP Cron", "2025-08-29 13:22:06", "2025-08-29 13:22:06");
INSERT INTO `wpge_actionscheduler_logs` VALUES("698", "2920", "acción empezada vía WP Cron", "2025-08-29 13:22:06", "2025-08-29 13:22:06");
INSERT INTO `wpge_actionscheduler_logs` VALUES("699", "2920", "acción completa vía WP Cron", "2025-08-29 13:22:06", "2025-08-29 13:22:06");
INSERT INTO `wpge_actionscheduler_logs` VALUES("700", "2921", "acción empezada vía WP Cron", "2025-08-29 13:22:06", "2025-08-29 13:22:06");
INSERT INTO `wpge_actionscheduler_logs` VALUES("701", "2921", "acción completa vía WP Cron", "2025-08-29 13:22:06", "2025-08-29 13:22:06");
INSERT INTO `wpge_actionscheduler_logs` VALUES("702", "2922", "acción empezada vía WP Cron", "2025-08-29 13:22:06", "2025-08-29 13:22:06");
INSERT INTO `wpge_actionscheduler_logs` VALUES("703", "2922", "acción completa vía WP Cron", "2025-08-29 13:22:06", "2025-08-29 13:22:06");
INSERT INTO `wpge_actionscheduler_logs` VALUES("704", "2969", "acción empezada vía WP Cron", "2025-08-29 13:22:06", "2025-08-29 13:22:06");
INSERT INTO `wpge_actionscheduler_logs` VALUES("705", "2969", "acción completa vía WP Cron", "2025-08-29 13:22:08", "2025-08-29 13:22:08");
INSERT INTO `wpge_actionscheduler_logs` VALUES("706", "2970", "acción empezada vía WP Cron", "2025-08-29 13:22:08", "2025-08-29 13:22:08");
INSERT INTO `wpge_actionscheduler_logs` VALUES("707", "2970", "acción completa vía WP Cron", "2025-08-29 13:22:08", "2025-08-29 13:22:08");
INSERT INTO `wpge_actionscheduler_logs` VALUES("708", "2971", "acción empezada vía WP Cron", "2025-08-29 13:22:08", "2025-08-29 13:22:08");
INSERT INTO `wpge_actionscheduler_logs` VALUES("709", "2971", "acción completa vía WP Cron", "2025-08-29 13:22:08", "2025-08-29 13:22:08");
INSERT INTO `wpge_actionscheduler_logs` VALUES("710", "2972", "acción creada", "2025-08-29 13:22:08", "2025-08-29 13:22:08");
INSERT INTO `wpge_actionscheduler_logs` VALUES("711", "2923", "acción empezada vía WP Cron", "2025-08-29 13:22:08", "2025-08-29 13:22:08");
INSERT INTO `wpge_actionscheduler_logs` VALUES("712", "2923", "acción completa vía WP Cron", "2025-08-29 13:22:08", "2025-08-29 13:22:08");
INSERT INTO `wpge_actionscheduler_logs` VALUES("713", "2924", "acción empezada vía WP Cron", "2025-08-29 13:22:08", "2025-08-29 13:22:08");
INSERT INTO `wpge_actionscheduler_logs` VALUES("714", "2924", "acción completa vía WP Cron", "2025-08-29 13:22:08", "2025-08-29 13:22:08");
INSERT INTO `wpge_actionscheduler_logs` VALUES("715", "2925", "acción empezada vía Async Request", "2025-08-29 13:22:12", "2025-08-29 13:22:12");
INSERT INTO `wpge_actionscheduler_logs` VALUES("716", "2925", "acción completa vía Async Request", "2025-08-29 13:22:12", "2025-08-29 13:22:12");
INSERT INTO `wpge_actionscheduler_logs` VALUES("717", "2926", "acción empezada vía Async Request", "2025-08-29 13:22:12", "2025-08-29 13:22:12");
INSERT INTO `wpge_actionscheduler_logs` VALUES("718", "2926", "acción completa vía Async Request", "2025-08-29 13:22:12", "2025-08-29 13:22:12");
INSERT INTO `wpge_actionscheduler_logs` VALUES("719", "2927", "acción empezada vía Async Request", "2025-08-29 13:22:12", "2025-08-29 13:22:12");
INSERT INTO `wpge_actionscheduler_logs` VALUES("720", "2927", "acción completa vía Async Request", "2025-08-29 13:22:12", "2025-08-29 13:22:12");
INSERT INTO `wpge_actionscheduler_logs` VALUES("721", "2928", "acción empezada vía Async Request", "2025-08-29 13:22:12", "2025-08-29 13:22:12");
INSERT INTO `wpge_actionscheduler_logs` VALUES("722", "2928", "acción completa vía Async Request", "2025-08-29 13:22:12", "2025-08-29 13:22:12");
INSERT INTO `wpge_actionscheduler_logs` VALUES("723", "2929", "acción empezada vía Async Request", "2025-08-29 13:22:17", "2025-08-29 13:22:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("724", "2929", "acción completa vía Async Request", "2025-08-29 13:22:17", "2025-08-29 13:22:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("725", "2930", "acción empezada vía Async Request", "2025-08-29 13:22:17", "2025-08-29 13:22:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("726", "2930", "acción completa vía Async Request", "2025-08-29 13:22:17", "2025-08-29 13:22:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("727", "2931", "acción empezada vía Async Request", "2025-08-29 13:22:17", "2025-08-29 13:22:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("728", "2973", "acción creada", "2025-08-29 13:22:17", "2025-08-29 13:22:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("729", "2931", "acción completa vía Async Request", "2025-08-29 13:22:17", "2025-08-29 13:22:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("730", "2932", "acción empezada vía Async Request", "2025-08-29 13:22:17", "2025-08-29 13:22:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("731", "2932", "acción completa vía Async Request", "2025-08-29 13:22:17", "2025-08-29 13:22:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("732", "2933", "acción empezada vía Async Request", "2025-08-29 13:22:17", "2025-08-29 13:22:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("733", "2933", "acción completa vía Async Request", "2025-08-29 13:22:17", "2025-08-29 13:22:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("734", "2973", "acción empezada vía Async Request", "2025-08-29 13:22:17", "2025-08-29 13:22:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("735", "2973", "acción completa vía Async Request", "2025-08-29 13:22:17", "2025-08-29 13:22:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("736", "2934", "acción empezada vía Async Request", "2025-08-29 13:22:23", "2025-08-29 13:22:23");
INSERT INTO `wpge_actionscheduler_logs` VALUES("737", "2934", "acción completa vía Async Request", "2025-08-29 13:22:23", "2025-08-29 13:22:23");
INSERT INTO `wpge_actionscheduler_logs` VALUES("738", "2935", "acción empezada vía Async Request", "2025-08-29 13:22:23", "2025-08-29 13:22:23");
INSERT INTO `wpge_actionscheduler_logs` VALUES("739", "2935", "acción completa vía Async Request", "2025-08-29 13:22:23", "2025-08-29 13:22:23");
INSERT INTO `wpge_actionscheduler_logs` VALUES("740", "2936", "acción empezada vía Async Request", "2025-08-29 13:22:23", "2025-08-29 13:22:23");
INSERT INTO `wpge_actionscheduler_logs` VALUES("741", "2936", "acción completa vía Async Request", "2025-08-29 13:22:23", "2025-08-29 13:22:23");
INSERT INTO `wpge_actionscheduler_logs` VALUES("742", "2937", "acción empezada vía Async Request", "2025-08-29 13:22:23", "2025-08-29 13:22:23");
INSERT INTO `wpge_actionscheduler_logs` VALUES("743", "2937", "acción completa vía Async Request", "2025-08-29 13:22:23", "2025-08-29 13:22:23");
INSERT INTO `wpge_actionscheduler_logs` VALUES("744", "2938", "acción empezada vía Async Request", "2025-08-29 13:22:23", "2025-08-29 13:22:23");
INSERT INTO `wpge_actionscheduler_logs` VALUES("745", "2938", "acción completa vía Async Request", "2025-08-29 13:22:23", "2025-08-29 13:22:23");
INSERT INTO `wpge_actionscheduler_logs` VALUES("746", "2939", "acción empezada vía Async Request", "2025-08-29 13:22:23", "2025-08-29 13:22:23");
INSERT INTO `wpge_actionscheduler_logs` VALUES("747", "2939", "acción completa vía Async Request", "2025-08-29 13:22:23", "2025-08-29 13:22:23");
INSERT INTO `wpge_actionscheduler_logs` VALUES("748", "2940", "acción empezada vía Async Request", "2025-08-29 13:22:28", "2025-08-29 13:22:28");
INSERT INTO `wpge_actionscheduler_logs` VALUES("749", "2940", "acción completa vía Async Request", "2025-08-29 13:22:28", "2025-08-29 13:22:28");
INSERT INTO `wpge_actionscheduler_logs` VALUES("750", "2941", "acción empezada vía Async Request", "2025-08-29 13:22:28", "2025-08-29 13:22:28");
INSERT INTO `wpge_actionscheduler_logs` VALUES("751", "2941", "acción completa vía Async Request", "2025-08-29 13:22:28", "2025-08-29 13:22:28");
INSERT INTO `wpge_actionscheduler_logs` VALUES("752", "2942", "acción empezada vía Async Request", "2025-08-29 13:22:28", "2025-08-29 13:22:28");
INSERT INTO `wpge_actionscheduler_logs` VALUES("753", "2942", "acción completa vía Async Request", "2025-08-29 13:22:28", "2025-08-29 13:22:28");
INSERT INTO `wpge_actionscheduler_logs` VALUES("754", "2943", "acción empezada vía Async Request", "2025-08-29 13:22:28", "2025-08-29 13:22:28");
INSERT INTO `wpge_actionscheduler_logs` VALUES("755", "2943", "acción completa vía Async Request", "2025-08-29 13:22:28", "2025-08-29 13:22:28");
INSERT INTO `wpge_actionscheduler_logs` VALUES("756", "2944", "acción empezada vía Async Request", "2025-08-29 13:22:28", "2025-08-29 13:22:28");
INSERT INTO `wpge_actionscheduler_logs` VALUES("757", "2944", "acción completa vía Async Request", "2025-08-29 13:22:28", "2025-08-29 13:22:28");
INSERT INTO `wpge_actionscheduler_logs` VALUES("758", "2945", "acción empezada vía Async Request", "2025-08-29 13:22:33", "2025-08-29 13:22:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("759", "2945", "acción completa vía Async Request", "2025-08-29 13:22:33", "2025-08-29 13:22:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("760", "2946", "acción empezada vía Async Request", "2025-08-29 13:22:33", "2025-08-29 13:22:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("761", "2946", "acción completa vía Async Request", "2025-08-29 13:22:33", "2025-08-29 13:22:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("762", "2947", "acción empezada vía Async Request", "2025-08-29 13:22:33", "2025-08-29 13:22:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("763", "2947", "acción completa vía Async Request", "2025-08-29 13:22:33", "2025-08-29 13:22:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("764", "2948", "acción empezada vía Async Request", "2025-08-29 13:22:33", "2025-08-29 13:22:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("765", "2948", "acción completa vía Async Request", "2025-08-29 13:22:33", "2025-08-29 13:22:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("766", "2949", "acción empezada vía Async Request", "2025-08-29 13:22:33", "2025-08-29 13:22:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("767", "2949", "acción completa vía Async Request", "2025-08-29 13:22:33", "2025-08-29 13:22:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("768", "2950", "acción empezada vía Async Request", "2025-08-29 13:22:39", "2025-08-29 13:22:39");
INSERT INTO `wpge_actionscheduler_logs` VALUES("769", "2950", "acción completa vía Async Request", "2025-08-29 13:22:39", "2025-08-29 13:22:39");
INSERT INTO `wpge_actionscheduler_logs` VALUES("770", "2951", "acción empezada vía Async Request", "2025-08-29 13:22:39", "2025-08-29 13:22:39");
INSERT INTO `wpge_actionscheduler_logs` VALUES("771", "2951", "acción completa vía Async Request", "2025-08-29 13:22:39", "2025-08-29 13:22:39");
INSERT INTO `wpge_actionscheduler_logs` VALUES("772", "2952", "acción empezada vía Async Request", "2025-08-29 13:22:39", "2025-08-29 13:22:39");
INSERT INTO `wpge_actionscheduler_logs` VALUES("773", "2952", "acción completa vía Async Request", "2025-08-29 13:22:39", "2025-08-29 13:22:39");
INSERT INTO `wpge_actionscheduler_logs` VALUES("774", "2953", "acción empezada vía Async Request", "2025-08-29 13:22:39", "2025-08-29 13:22:39");
INSERT INTO `wpge_actionscheduler_logs` VALUES("775", "2953", "acción completa vía Async Request", "2025-08-29 13:22:39", "2025-08-29 13:22:39");
INSERT INTO `wpge_actionscheduler_logs` VALUES("776", "2954", "acción empezada vía Async Request", "2025-08-29 13:22:39", "2025-08-29 13:22:39");
INSERT INTO `wpge_actionscheduler_logs` VALUES("777", "2954", "acción completa vía Async Request", "2025-08-29 13:22:39", "2025-08-29 13:22:39");
INSERT INTO `wpge_actionscheduler_logs` VALUES("778", "2955", "acción empezada vía Async Request", "2025-08-29 13:22:39", "2025-08-29 13:22:39");
INSERT INTO `wpge_actionscheduler_logs` VALUES("779", "2955", "acción completa vía Async Request", "2025-08-29 13:22:39", "2025-08-29 13:22:39");
INSERT INTO `wpge_actionscheduler_logs` VALUES("780", "2956", "acción empezada vía Async Request", "2025-08-29 13:22:44", "2025-08-29 13:22:44");
INSERT INTO `wpge_actionscheduler_logs` VALUES("781", "2956", "acción completa vía Async Request", "2025-08-29 13:22:44", "2025-08-29 13:22:44");
INSERT INTO `wpge_actionscheduler_logs` VALUES("782", "2957", "acción empezada vía Async Request", "2025-08-29 13:22:44", "2025-08-29 13:22:44");
INSERT INTO `wpge_actionscheduler_logs` VALUES("783", "2957", "acción completa vía Async Request", "2025-08-29 13:22:44", "2025-08-29 13:22:44");
INSERT INTO `wpge_actionscheduler_logs` VALUES("784", "2958", "acción empezada vía Async Request", "2025-08-29 13:22:44", "2025-08-29 13:22:44");
INSERT INTO `wpge_actionscheduler_logs` VALUES("785", "2958", "acción completa vía Async Request", "2025-08-29 13:22:44", "2025-08-29 13:22:44");
INSERT INTO `wpge_actionscheduler_logs` VALUES("786", "2959", "acción empezada vía Async Request", "2025-08-29 13:22:44", "2025-08-29 13:22:44");
INSERT INTO `wpge_actionscheduler_logs` VALUES("787", "2959", "acción completa vía Async Request", "2025-08-29 13:22:44", "2025-08-29 13:22:44");
INSERT INTO `wpge_actionscheduler_logs` VALUES("788", "2960", "acción empezada vía Async Request", "2025-08-29 13:22:44", "2025-08-29 13:22:44");
INSERT INTO `wpge_actionscheduler_logs` VALUES("789", "2960", "acción completa vía Async Request", "2025-08-29 13:22:44", "2025-08-29 13:22:44");
INSERT INTO `wpge_actionscheduler_logs` VALUES("790", "2961", "acción empezada vía Async Request", "2025-08-29 13:22:49", "2025-08-29 13:22:49");
INSERT INTO `wpge_actionscheduler_logs` VALUES("791", "2961", "acción completa vía Async Request", "2025-08-29 13:22:49", "2025-08-29 13:22:49");
INSERT INTO `wpge_actionscheduler_logs` VALUES("792", "2962", "acción empezada vía Async Request", "2025-08-29 13:22:49", "2025-08-29 13:22:49");
INSERT INTO `wpge_actionscheduler_logs` VALUES("793", "2962", "acción completa vía Async Request", "2025-08-29 13:22:49", "2025-08-29 13:22:49");
INSERT INTO `wpge_actionscheduler_logs` VALUES("794", "2963", "acción empezada vía Async Request", "2025-08-29 13:22:49", "2025-08-29 13:22:49");
INSERT INTO `wpge_actionscheduler_logs` VALUES("795", "2963", "acción completa vía Async Request", "2025-08-29 13:22:49", "2025-08-29 13:22:49");
INSERT INTO `wpge_actionscheduler_logs` VALUES("796", "2964", "acción empezada vía Async Request", "2025-08-29 13:22:49", "2025-08-29 13:22:49");
INSERT INTO `wpge_actionscheduler_logs` VALUES("797", "2964", "acción completa vía Async Request", "2025-08-29 13:22:49", "2025-08-29 13:22:49");
INSERT INTO `wpge_actionscheduler_logs` VALUES("798", "2965", "acción empezada vía Async Request", "2025-08-29 13:22:49", "2025-08-29 13:22:49");
INSERT INTO `wpge_actionscheduler_logs` VALUES("799", "2965", "acción completa vía Async Request", "2025-08-29 13:22:49", "2025-08-29 13:22:49");
INSERT INTO `wpge_actionscheduler_logs` VALUES("800", "2966", "acción empezada vía Async Request", "2025-08-29 13:22:50", "2025-08-29 13:22:50");
INSERT INTO `wpge_actionscheduler_logs` VALUES("801", "2966", "acción completa vía Async Request", "2025-08-29 13:22:50", "2025-08-29 13:22:50");
INSERT INTO `wpge_actionscheduler_logs` VALUES("802", "2967", "acción empezada vía Async Request", "2025-08-29 13:22:55", "2025-08-29 13:22:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("803", "2967", "acción completa vía Async Request", "2025-08-29 13:22:55", "2025-08-29 13:22:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("804", "2968", "acción empezada vía Async Request", "2025-08-29 13:22:55", "2025-08-29 13:22:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("805", "2968", "acción completa vía Async Request", "2025-08-29 13:22:55", "2025-08-29 13:22:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("806", "2974", "acción creada", "2025-08-29 13:25:48", "2025-08-29 13:25:48");
INSERT INTO `wpge_actionscheduler_logs` VALUES("807", "2974", "acción empezada vía WP Cron", "2025-08-29 13:26:14", "2025-08-29 13:26:14");
INSERT INTO `wpge_actionscheduler_logs` VALUES("808", "2975", "acción creada", "2025-08-29 13:26:14", "2025-08-29 13:26:14");
INSERT INTO `wpge_actionscheduler_logs` VALUES("809", "2976", "acción creada", "2025-08-29 13:26:14", "2025-08-29 13:26:14");
INSERT INTO `wpge_actionscheduler_logs` VALUES("810", "2977", "acción creada", "2025-08-29 13:26:14", "2025-08-29 13:26:14");
INSERT INTO `wpge_actionscheduler_logs` VALUES("811", "2978", "acción creada", "2025-08-29 13:26:14", "2025-08-29 13:26:14");
INSERT INTO `wpge_actionscheduler_logs` VALUES("812", "2979", "acción creada", "2025-08-29 13:26:14", "2025-08-29 13:26:14");
INSERT INTO `wpge_actionscheduler_logs` VALUES("813", "2980", "acción creada", "2025-08-29 13:26:14", "2025-08-29 13:26:14");
INSERT INTO `wpge_actionscheduler_logs` VALUES("814", "2981", "acción creada", "2025-08-29 13:26:14", "2025-08-29 13:26:14");
INSERT INTO `wpge_actionscheduler_logs` VALUES("815", "2982", "acción creada", "2025-08-29 13:26:14", "2025-08-29 13:26:14");
INSERT INTO `wpge_actionscheduler_logs` VALUES("816", "2983", "acción creada", "2025-08-29 13:26:14", "2025-08-29 13:26:14");
INSERT INTO `wpge_actionscheduler_logs` VALUES("817", "2984", "acción creada", "2025-08-29 13:26:14", "2025-08-29 13:26:14");
INSERT INTO `wpge_actionscheduler_logs` VALUES("818", "2985", "acción creada", "2025-08-29 13:26:14", "2025-08-29 13:26:14");
INSERT INTO `wpge_actionscheduler_logs` VALUES("819", "2974", "acción completa vía WP Cron", "2025-08-29 13:26:14", "2025-08-29 13:26:14");
INSERT INTO `wpge_actionscheduler_logs` VALUES("820", "2986", "acción creada", "2025-08-29 13:26:14", "2025-08-29 13:26:14");
INSERT INTO `wpge_actionscheduler_logs` VALUES("821", "2983", "acción empezada vía WP Cron", "2025-08-29 13:26:14", "2025-08-29 13:26:14");
INSERT INTO `wpge_actionscheduler_logs` VALUES("822", "2983", "acción completa vía WP Cron", "2025-08-29 13:26:16", "2025-08-29 13:26:16");
INSERT INTO `wpge_actionscheduler_logs` VALUES("823", "2987", "acción creada", "2025-08-29 13:26:16", "2025-08-29 13:26:16");
INSERT INTO `wpge_actionscheduler_logs` VALUES("824", "2977", "acción empezada vía WP Cron", "2025-08-29 13:27:27", "2025-08-29 13:27:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("825", "2977", "acción completa vía WP Cron", "2025-08-29 13:27:27", "2025-08-29 13:27:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("826", "2988", "acción creada", "2025-08-29 13:27:27", "2025-08-29 13:27:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("827", "2981", "acción empezada vía WP Cron", "2025-08-29 13:27:27", "2025-08-29 13:27:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("828", "2981", "acción completa vía WP Cron", "2025-08-29 13:27:28", "2025-08-29 13:27:28");
INSERT INTO `wpge_actionscheduler_logs` VALUES("829", "2989", "acción creada", "2025-08-29 13:27:28", "2025-08-29 13:27:28");
INSERT INTO `wpge_actionscheduler_logs` VALUES("830", "2984", "acción empezada vía WP Cron", "2025-08-29 13:27:28", "2025-08-29 13:27:28");
INSERT INTO `wpge_actionscheduler_logs` VALUES("831", "2984", "acción completa vía WP Cron", "2025-08-29 13:27:28", "2025-08-29 13:27:28");
INSERT INTO `wpge_actionscheduler_logs` VALUES("832", "2980", "acción empezada vía WP Cron", "2025-08-29 13:27:28", "2025-08-29 13:27:28");
INSERT INTO `wpge_actionscheduler_logs` VALUES("833", "2980", "acción completa vía WP Cron", "2025-08-29 13:27:28", "2025-08-29 13:27:28");
INSERT INTO `wpge_actionscheduler_logs` VALUES("834", "2990", "acción creada", "2025-08-29 13:27:28", "2025-08-29 13:27:28");
INSERT INTO `wpge_actionscheduler_logs` VALUES("835", "2991", "action created", "2025-08-29 14:20:32", "2025-08-29 14:20:32");
INSERT INTO `wpge_actionscheduler_logs` VALUES("836", "2992", "action created", "2025-08-29 14:20:32", "2025-08-29 14:20:32");
INSERT INTO `wpge_actionscheduler_logs` VALUES("837", "2991", "action started via WP Cron", "2025-08-29 14:20:59", "2025-08-29 14:20:59");
INSERT INTO `wpge_actionscheduler_logs` VALUES("838", "2991", "action complete via WP Cron", "2025-08-29 14:20:59", "2025-08-29 14:20:59");
INSERT INTO `wpge_actionscheduler_logs` VALUES("839", "2992", "action started via WP Cron", "2025-08-29 14:22:09", "2025-08-29 14:22:09");
INSERT INTO `wpge_actionscheduler_logs` VALUES("840", "2992", "action complete via WP Cron", "2025-08-29 14:22:09", "2025-08-29 14:22:09");
INSERT INTO `wpge_actionscheduler_logs` VALUES("841", "2976", "action started via Async Request", "2025-08-29 14:26:30", "2025-08-29 14:26:30");
INSERT INTO `wpge_actionscheduler_logs` VALUES("842", "2993", "action created", "2025-08-29 14:26:30", "2025-08-29 14:26:30");
INSERT INTO `wpge_actionscheduler_logs` VALUES("843", "2976", "action complete via Async Request", "2025-08-29 14:26:30", "2025-08-29 14:26:30");
INSERT INTO `wpge_actionscheduler_logs` VALUES("844", "2993", "action started via WP Cron", "2025-08-29 15:26:44", "2025-08-29 15:26:44");
INSERT INTO `wpge_actionscheduler_logs` VALUES("845", "2994", "action created", "2025-08-29 15:26:44", "2025-08-29 15:26:44");
INSERT INTO `wpge_actionscheduler_logs` VALUES("846", "2993", "action complete via WP Cron", "2025-08-29 15:26:44", "2025-08-29 15:26:44");
INSERT INTO `wpge_actionscheduler_logs` VALUES("847", "2978", "action started via WP Cron", "2025-08-29 16:26:48", "2025-08-29 16:26:48");
INSERT INTO `wpge_actionscheduler_logs` VALUES("848", "2978", "action complete via WP Cron", "2025-08-29 16:26:48", "2025-08-29 16:26:48");
INSERT INTO `wpge_actionscheduler_logs` VALUES("849", "2995", "action created", "2025-08-29 16:26:48", "2025-08-29 16:26:48");
INSERT INTO `wpge_actionscheduler_logs` VALUES("850", "2982", "action started via WP Cron", "2025-08-29 16:26:48", "2025-08-29 16:26:48");
INSERT INTO `wpge_actionscheduler_logs` VALUES("851", "2982", "action complete via WP Cron", "2025-08-29 16:26:48", "2025-08-29 16:26:48");
INSERT INTO `wpge_actionscheduler_logs` VALUES("852", "2996", "action created", "2025-08-29 16:26:48", "2025-08-29 16:26:48");
INSERT INTO `wpge_actionscheduler_logs` VALUES("853", "2994", "action started via WP Cron", "2025-08-29 16:26:48", "2025-08-29 16:26:48");
INSERT INTO `wpge_actionscheduler_logs` VALUES("854", "2997", "action created", "2025-08-29 16:26:48", "2025-08-29 16:26:48");
INSERT INTO `wpge_actionscheduler_logs` VALUES("855", "2994", "action complete via WP Cron", "2025-08-29 16:26:48", "2025-08-29 16:26:48");
INSERT INTO `wpge_actionscheduler_logs` VALUES("856", "2997", "action started via WP Cron", "2025-08-29 17:28:40", "2025-08-29 17:28:40");
INSERT INTO `wpge_actionscheduler_logs` VALUES("857", "2998", "action created", "2025-08-29 17:28:40", "2025-08-29 17:28:40");
INSERT INTO `wpge_actionscheduler_logs` VALUES("858", "2997", "action complete via WP Cron", "2025-08-29 17:28:40", "2025-08-29 17:28:40");
INSERT INTO `wpge_actionscheduler_logs` VALUES("859", "2998", "action started via WP Cron", "2025-08-29 18:33:09", "2025-08-29 18:33:09");
INSERT INTO `wpge_actionscheduler_logs` VALUES("860", "2999", "action created", "2025-08-29 18:33:09", "2025-08-29 18:33:09");
INSERT INTO `wpge_actionscheduler_logs` VALUES("861", "2998", "action complete via WP Cron", "2025-08-29 18:33:09", "2025-08-29 18:33:09");
INSERT INTO `wpge_actionscheduler_logs` VALUES("862", "2979", "action started via WP Cron", "2025-08-29 19:53:55", "2025-08-29 19:53:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("863", "2979", "action complete via WP Cron", "2025-08-29 19:53:55", "2025-08-29 19:53:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("864", "3000", "action created", "2025-08-29 19:53:55", "2025-08-29 19:53:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("865", "2999", "action started via WP Cron", "2025-08-29 19:53:55", "2025-08-29 19:53:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("866", "3001", "action created", "2025-08-29 19:53:55", "2025-08-29 19:53:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("867", "2999", "action complete via WP Cron", "2025-08-29 19:53:55", "2025-08-29 19:53:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("868", "3001", "action started via WP Cron", "2025-08-29 20:54:35", "2025-08-29 20:54:35");
INSERT INTO `wpge_actionscheduler_logs` VALUES("869", "3002", "action created", "2025-08-29 20:54:35", "2025-08-29 20:54:35");
INSERT INTO `wpge_actionscheduler_logs` VALUES("870", "3001", "action complete via WP Cron", "2025-08-29 20:54:35", "2025-08-29 20:54:35");
INSERT INTO `wpge_actionscheduler_logs` VALUES("871", "3002", "action started via WP Cron", "2025-08-29 22:12:16", "2025-08-29 22:12:16");
INSERT INTO `wpge_actionscheduler_logs` VALUES("872", "3003", "action created", "2025-08-29 22:12:16", "2025-08-29 22:12:16");
INSERT INTO `wpge_actionscheduler_logs` VALUES("873", "3002", "action complete via WP Cron", "2025-08-29 22:12:16", "2025-08-29 22:12:16");
INSERT INTO `wpge_actionscheduler_logs` VALUES("874", "3003", "action started via WP Cron", "2025-08-29 23:14:48", "2025-08-29 23:14:48");
INSERT INTO `wpge_actionscheduler_logs` VALUES("875", "3004", "action created", "2025-08-29 23:14:48", "2025-08-29 23:14:48");
INSERT INTO `wpge_actionscheduler_logs` VALUES("876", "3003", "action complete via WP Cron", "2025-08-29 23:14:48", "2025-08-29 23:14:48");
INSERT INTO `wpge_actionscheduler_logs` VALUES("877", "2975", "action started via WP Cron", "2025-08-30 00:00:13", "2025-08-30 00:00:13");
INSERT INTO `wpge_actionscheduler_logs` VALUES("878", "2975", "action complete via WP Cron", "2025-08-30 00:00:13", "2025-08-30 00:00:13");
INSERT INTO `wpge_actionscheduler_logs` VALUES("879", "3005", "action created", "2025-08-30 00:00:13", "2025-08-30 00:00:13");
INSERT INTO `wpge_actionscheduler_logs` VALUES("880", "3004", "action started via WP Cron", "2025-08-30 00:20:15", "2025-08-30 00:20:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("881", "3006", "action created", "2025-08-30 00:20:15", "2025-08-30 00:20:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("882", "3004", "action complete via WP Cron", "2025-08-30 00:20:15", "2025-08-30 00:20:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("883", "3006", "action started via WP Cron", "2025-08-30 01:20:27", "2025-08-30 01:20:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("884", "3007", "action created", "2025-08-30 01:20:27", "2025-08-30 01:20:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("885", "3006", "action complete via WP Cron", "2025-08-30 01:20:27", "2025-08-30 01:20:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("886", "2985", "action started via WP Cron", "2025-08-30 01:38:18", "2025-08-30 01:38:18");
INSERT INTO `wpge_actionscheduler_logs` VALUES("887", "2985", "action complete via WP Cron", "2025-08-30 01:38:18", "2025-08-30 01:38:18");
INSERT INTO `wpge_actionscheduler_logs` VALUES("888", "3008", "action created", "2025-08-30 01:38:18", "2025-08-30 01:38:18");
INSERT INTO `wpge_actionscheduler_logs` VALUES("889", "3007", "action started via WP Cron", "2025-08-30 02:30:34", "2025-08-30 02:30:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("890", "3009", "action created", "2025-08-30 02:30:34", "2025-08-30 02:30:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("891", "3007", "action complete via WP Cron", "2025-08-30 02:30:34", "2025-08-30 02:30:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("892", "3009", "action started via WP Cron", "2025-08-30 03:31:55", "2025-08-30 03:31:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("893", "3010", "action created", "2025-08-30 03:31:55", "2025-08-30 03:31:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("894", "3009", "action complete via WP Cron", "2025-08-30 03:31:55", "2025-08-30 03:31:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("895", "3010", "action started via WP Cron", "2025-08-30 04:38:54", "2025-08-30 04:38:54");
INSERT INTO `wpge_actionscheduler_logs` VALUES("896", "3011", "action created", "2025-08-30 04:38:54", "2025-08-30 04:38:54");
INSERT INTO `wpge_actionscheduler_logs` VALUES("897", "3010", "action complete via WP Cron", "2025-08-30 04:38:54", "2025-08-30 04:38:54");
INSERT INTO `wpge_actionscheduler_logs` VALUES("898", "3011", "action started via WP Cron", "2025-08-30 05:41:21", "2025-08-30 05:41:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("899", "3012", "action created", "2025-08-30 05:41:21", "2025-08-30 05:41:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("900", "3011", "action complete via WP Cron", "2025-08-30 05:41:21", "2025-08-30 05:41:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("901", "3012", "action started via WP Cron", "2025-08-30 06:57:14", "2025-08-30 06:57:14");
INSERT INTO `wpge_actionscheduler_logs` VALUES("902", "3013", "action created", "2025-08-30 06:57:14", "2025-08-30 06:57:14");
INSERT INTO `wpge_actionscheduler_logs` VALUES("903", "3012", "action complete via WP Cron", "2025-08-30 06:57:14", "2025-08-30 06:57:14");
INSERT INTO `wpge_actionscheduler_logs` VALUES("904", "3000", "action started via WP Cron", "2025-08-30 07:56:36", "2025-08-30 07:56:36");
INSERT INTO `wpge_actionscheduler_logs` VALUES("905", "3000", "action complete via WP Cron", "2025-08-30 07:56:36", "2025-08-30 07:56:36");
INSERT INTO `wpge_actionscheduler_logs` VALUES("906", "3014", "action created", "2025-08-30 07:56:36", "2025-08-30 07:56:36");
INSERT INTO `wpge_actionscheduler_logs` VALUES("907", "3013", "action started via WP Cron", "2025-08-30 07:59:29", "2025-08-30 07:59:29");
INSERT INTO `wpge_actionscheduler_logs` VALUES("908", "3015", "action created", "2025-08-30 07:59:29", "2025-08-30 07:59:29");
INSERT INTO `wpge_actionscheduler_logs` VALUES("909", "3013", "action complete via WP Cron", "2025-08-30 07:59:29", "2025-08-30 07:59:29");
INSERT INTO `wpge_actionscheduler_logs` VALUES("910", "3015", "action started via WP Cron", "2025-08-30 09:01:35", "2025-08-30 09:01:35");
INSERT INTO `wpge_actionscheduler_logs` VALUES("911", "3016", "action created", "2025-08-30 09:01:35", "2025-08-30 09:01:35");
INSERT INTO `wpge_actionscheduler_logs` VALUES("912", "3015", "action complete via WP Cron", "2025-08-30 09:01:35", "2025-08-30 09:01:35");
INSERT INTO `wpge_actionscheduler_logs` VALUES("913", "3016", "action started via WP Cron", "2025-08-30 10:03:00", "2025-08-30 10:03:00");
INSERT INTO `wpge_actionscheduler_logs` VALUES("914", "3017", "action created", "2025-08-30 10:03:00", "2025-08-30 10:03:00");
INSERT INTO `wpge_actionscheduler_logs` VALUES("915", "3016", "action complete via WP Cron", "2025-08-30 10:03:00", "2025-08-30 10:03:00");
INSERT INTO `wpge_actionscheduler_logs` VALUES("916", "3017", "action started via WP Cron", "2025-08-30 11:33:45", "2025-08-30 11:33:45");
INSERT INTO `wpge_actionscheduler_logs` VALUES("917", "3018", "action created", "2025-08-30 11:33:45", "2025-08-30 11:33:45");
INSERT INTO `wpge_actionscheduler_logs` VALUES("918", "3017", "action complete via WP Cron", "2025-08-30 11:33:45", "2025-08-30 11:33:45");
INSERT INTO `wpge_actionscheduler_logs` VALUES("919", "3018", "action started via WP Cron", "2025-08-30 12:34:06", "2025-08-30 12:34:06");
INSERT INTO `wpge_actionscheduler_logs` VALUES("920", "3019", "action created", "2025-08-30 12:34:07", "2025-08-30 12:34:07");
INSERT INTO `wpge_actionscheduler_logs` VALUES("921", "3018", "action complete via WP Cron", "2025-08-30 12:34:07", "2025-08-30 12:34:07");
INSERT INTO `wpge_actionscheduler_logs` VALUES("922", "2972", "action started via WP Cron", "2025-08-30 13:38:31", "2025-08-30 13:38:31");
INSERT INTO `wpge_actionscheduler_logs` VALUES("923", "2972", "action complete via WP Cron", "2025-08-30 13:38:31", "2025-08-30 13:38:31");
INSERT INTO `wpge_actionscheduler_logs` VALUES("924", "3020", "action created", "2025-08-30 13:38:31", "2025-08-30 13:38:31");
INSERT INTO `wpge_actionscheduler_logs` VALUES("925", "2987", "action started via WP Cron", "2025-08-30 13:38:31", "2025-08-30 13:38:31");
INSERT INTO `wpge_actionscheduler_logs` VALUES("926", "2987", "action complete via WP Cron", "2025-08-30 13:38:33", "2025-08-30 13:38:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("927", "3021", "action created", "2025-08-30 13:38:33", "2025-08-30 13:38:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("928", "2988", "action started via WP Cron", "2025-08-30 13:38:33", "2025-08-30 13:38:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("929", "2988", "action complete via WP Cron", "2025-08-30 13:38:33", "2025-08-30 13:38:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("930", "3022", "action created", "2025-08-30 13:38:33", "2025-08-30 13:38:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("931", "2989", "action started via WP Cron", "2025-08-30 13:38:33", "2025-08-30 13:38:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("932", "2989", "action complete via WP Cron", "2025-08-30 13:38:33", "2025-08-30 13:38:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("933", "3023", "action created", "2025-08-30 13:38:33", "2025-08-30 13:38:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("934", "3019", "action started via WP Cron", "2025-08-30 13:38:33", "2025-08-30 13:38:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("935", "3024", "action created", "2025-08-30 13:38:33", "2025-08-30 13:38:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("936", "3019", "action complete via WP Cron", "2025-08-30 13:38:33", "2025-08-30 13:38:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("937", "3008", "action started via WP Cron", "2025-08-30 13:38:33", "2025-08-30 13:38:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("938", "3008", "action complete via WP Cron", "2025-08-30 13:38:33", "2025-08-30 13:38:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("939", "3025", "action created", "2025-08-30 13:38:33", "2025-08-30 13:38:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("940", "2986", "action started via WP Cron", "2025-08-30 13:38:33", "2025-08-30 13:38:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("941", "3026", "action created", "2025-08-30 13:38:33", "2025-08-30 13:38:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("942", "2986", "action complete via WP Cron", "2025-08-30 13:38:33", "2025-08-30 13:38:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("943", "3027", "action created", "2025-08-30 13:38:33", "2025-08-30 13:38:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("944", "3026", "action started via WP Cron", "2025-08-30 13:53:59", "2025-08-30 13:53:59");
INSERT INTO `wpge_actionscheduler_logs` VALUES("945", "3026", "action complete via WP Cron", "2025-08-30 13:54:00", "2025-08-30 13:54:00");
INSERT INTO `wpge_actionscheduler_logs` VALUES("946", "3024", "action started via WP Cron", "2025-08-30 14:48:15", "2025-08-30 14:48:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("947", "3028", "action created", "2025-08-30 14:48:15", "2025-08-30 14:48:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("948", "3024", "action complete via WP Cron", "2025-08-30 14:48:15", "2025-08-30 14:48:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("949", "3028", "action started via WP Cron", "2025-08-30 16:06:33", "2025-08-30 16:06:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("950", "3029", "action created", "2025-08-30 16:06:33", "2025-08-30 16:06:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("951", "3028", "action complete via WP Cron", "2025-08-30 16:06:33", "2025-08-30 16:06:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("952", "2995", "action started via WP Cron", "2025-08-30 16:32:41", "2025-08-30 16:32:41");
INSERT INTO `wpge_actionscheduler_logs` VALUES("953", "2995", "action complete via WP Cron", "2025-08-30 16:32:41", "2025-08-30 16:32:41");
INSERT INTO `wpge_actionscheduler_logs` VALUES("954", "3030", "action created", "2025-08-30 16:32:41", "2025-08-30 16:32:41");
INSERT INTO `wpge_actionscheduler_logs` VALUES("955", "2996", "action started via WP Cron", "2025-08-30 16:32:41", "2025-08-30 16:32:41");
INSERT INTO `wpge_actionscheduler_logs` VALUES("956", "2996", "action complete via WP Cron", "2025-08-30 16:32:41", "2025-08-30 16:32:41");
INSERT INTO `wpge_actionscheduler_logs` VALUES("957", "3031", "action created", "2025-08-30 16:32:41", "2025-08-30 16:32:41");
INSERT INTO `wpge_actionscheduler_logs` VALUES("958", "3029", "action started via WP Cron", "2025-08-30 17:17:19", "2025-08-30 17:17:19");
INSERT INTO `wpge_actionscheduler_logs` VALUES("959", "3032", "action created", "2025-08-30 17:17:19", "2025-08-30 17:17:19");
INSERT INTO `wpge_actionscheduler_logs` VALUES("960", "3029", "action complete via WP Cron", "2025-08-30 17:17:19", "2025-08-30 17:17:19");
INSERT INTO `wpge_actionscheduler_logs` VALUES("961", "3032", "action started via WP Cron", "2025-08-30 18:28:15", "2025-08-30 18:28:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("962", "3033", "action created", "2025-08-30 18:28:15", "2025-08-30 18:28:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("963", "3032", "action complete via WP Cron", "2025-08-30 18:28:15", "2025-08-30 18:28:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("964", "3033", "action started via WP Cron", "2025-08-30 19:28:55", "2025-08-30 19:28:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("965", "3034", "action created", "2025-08-30 19:28:55", "2025-08-30 19:28:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("966", "3033", "action complete via WP Cron", "2025-08-30 19:28:55", "2025-08-30 19:28:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("967", "3014", "action started via WP Cron", "2025-08-30 20:00:20", "2025-08-30 20:00:20");
INSERT INTO `wpge_actionscheduler_logs` VALUES("968", "3014", "action complete via WP Cron", "2025-08-30 20:00:20", "2025-08-30 20:00:20");
INSERT INTO `wpge_actionscheduler_logs` VALUES("969", "3035", "action created", "2025-08-30 20:00:20", "2025-08-30 20:00:20");
INSERT INTO `wpge_actionscheduler_logs` VALUES("970", "3034", "action started via WP Cron", "2025-08-30 20:30:01", "2025-08-30 20:30:01");
INSERT INTO `wpge_actionscheduler_logs` VALUES("971", "3036", "action created", "2025-08-30 20:30:02", "2025-08-30 20:30:02");
INSERT INTO `wpge_actionscheduler_logs` VALUES("972", "3034", "action complete via WP Cron", "2025-08-30 20:30:02", "2025-08-30 20:30:02");
INSERT INTO `wpge_actionscheduler_logs` VALUES("973", "3036", "action started via WP Cron", "2025-08-30 21:50:29", "2025-08-30 21:50:29");
INSERT INTO `wpge_actionscheduler_logs` VALUES("974", "3037", "action created", "2025-08-30 21:50:29", "2025-08-30 21:50:29");
INSERT INTO `wpge_actionscheduler_logs` VALUES("975", "3036", "action complete via WP Cron", "2025-08-30 21:50:29", "2025-08-30 21:50:29");
INSERT INTO `wpge_actionscheduler_logs` VALUES("976", "3037", "action started via WP Cron", "2025-08-30 22:51:00", "2025-08-30 22:51:00");
INSERT INTO `wpge_actionscheduler_logs` VALUES("977", "3038", "action created", "2025-08-30 22:51:00", "2025-08-30 22:51:00");
INSERT INTO `wpge_actionscheduler_logs` VALUES("978", "3037", "action complete via WP Cron", "2025-08-30 22:51:00", "2025-08-30 22:51:00");
INSERT INTO `wpge_actionscheduler_logs` VALUES("979", "3038", "action started via WP Cron", "2025-08-30 23:51:24", "2025-08-30 23:51:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("980", "3039", "action created", "2025-08-30 23:51:24", "2025-08-30 23:51:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("981", "3038", "action complete via WP Cron", "2025-08-30 23:51:24", "2025-08-30 23:51:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("982", "3005", "action started via WP Cron", "2025-08-31 00:03:26", "2025-08-31 00:03:26");
INSERT INTO `wpge_actionscheduler_logs` VALUES("983", "3005", "action complete via WP Cron", "2025-08-31 00:03:26", "2025-08-31 00:03:26");
INSERT INTO `wpge_actionscheduler_logs` VALUES("984", "3040", "action created", "2025-08-31 00:03:26", "2025-08-31 00:03:26");
INSERT INTO `wpge_actionscheduler_logs` VALUES("985", "3039", "action started via WP Cron", "2025-08-31 01:00:34", "2025-08-31 01:00:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("986", "3041", "action created", "2025-08-31 01:00:34", "2025-08-31 01:00:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("987", "3039", "action complete via WP Cron", "2025-08-31 01:00:34", "2025-08-31 01:00:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("988", "3025", "action started via WP Cron", "2025-08-31 01:41:50", "2025-08-31 01:41:50");
INSERT INTO `wpge_actionscheduler_logs` VALUES("989", "3025", "action complete via WP Cron", "2025-08-31 01:41:50", "2025-08-31 01:41:50");
INSERT INTO `wpge_actionscheduler_logs` VALUES("990", "3042", "action created", "2025-08-31 01:41:50", "2025-08-31 01:41:50");
INSERT INTO `wpge_actionscheduler_logs` VALUES("991", "3041", "action started via WP Cron", "2025-08-31 02:11:35", "2025-08-31 02:11:35");
INSERT INTO `wpge_actionscheduler_logs` VALUES("992", "3043", "action created", "2025-08-31 02:11:35", "2025-08-31 02:11:35");
INSERT INTO `wpge_actionscheduler_logs` VALUES("993", "3041", "action complete via WP Cron", "2025-08-31 02:11:35", "2025-08-31 02:11:35");
INSERT INTO `wpge_actionscheduler_logs` VALUES("994", "3043", "action started via WP Cron", "2025-08-31 03:17:58", "2025-08-31 03:17:58");
INSERT INTO `wpge_actionscheduler_logs` VALUES("995", "3044", "action created", "2025-08-31 03:17:58", "2025-08-31 03:17:58");
INSERT INTO `wpge_actionscheduler_logs` VALUES("996", "3043", "action complete via WP Cron", "2025-08-31 03:17:58", "2025-08-31 03:17:58");
INSERT INTO `wpge_actionscheduler_logs` VALUES("997", "3044", "action started via WP Cron", "2025-08-31 04:20:01", "2025-08-31 04:20:01");
INSERT INTO `wpge_actionscheduler_logs` VALUES("998", "3045", "action created", "2025-08-31 04:20:01", "2025-08-31 04:20:01");
INSERT INTO `wpge_actionscheduler_logs` VALUES("999", "3044", "action complete via WP Cron", "2025-08-31 04:20:01", "2025-08-31 04:20:01");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1000", "3045", "action started via WP Cron", "2025-08-31 05:55:51", "2025-08-31 05:55:51");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1001", "3046", "action created", "2025-08-31 05:55:51", "2025-08-31 05:55:51");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1002", "3045", "action complete via WP Cron", "2025-08-31 05:55:51", "2025-08-31 05:55:51");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1003", "3046", "action started via WP Cron", "2025-08-31 06:56:10", "2025-08-31 06:56:10");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1004", "3047", "action created", "2025-08-31 06:56:10", "2025-08-31 06:56:10");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1005", "3046", "action complete via WP Cron", "2025-08-31 06:56:10", "2025-08-31 06:56:10");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1006", "3047", "action started via WP Cron", "2025-08-31 07:59:51", "2025-08-31 07:59:51");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1007", "3048", "action created", "2025-08-31 07:59:52", "2025-08-31 07:59:52");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1008", "3047", "action complete via WP Cron", "2025-08-31 07:59:52", "2025-08-31 07:59:52");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1009", "3035", "action started via WP Cron", "2025-08-31 08:10:18", "2025-08-31 08:10:18");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1010", "3035", "action complete via WP Cron", "2025-08-31 08:10:18", "2025-08-31 08:10:18");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1011", "3049", "action created", "2025-08-31 08:10:18", "2025-08-31 08:10:18");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1012", "3048", "action started via WP Cron", "2025-08-31 09:04:01", "2025-08-31 09:04:01");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1013", "3050", "action created", "2025-08-31 09:04:01", "2025-08-31 09:04:01");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1014", "3048", "action complete via WP Cron", "2025-08-31 09:04:01", "2025-08-31 09:04:01");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1015", "3050", "action started via WP Cron", "2025-08-31 10:10:17", "2025-08-31 10:10:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1016", "3051", "action created", "2025-08-31 10:10:17", "2025-08-31 10:10:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1017", "3050", "action complete via WP Cron", "2025-08-31 10:10:17", "2025-08-31 10:10:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1018", "3051", "action started via WP Cron", "2025-08-31 11:24:47", "2025-08-31 11:24:47");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1019", "3052", "action created", "2025-08-31 11:24:47", "2025-08-31 11:24:47");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1020", "3051", "action complete via WP Cron", "2025-08-31 11:24:47", "2025-08-31 11:24:47");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1021", "3052", "action started via WP Cron", "2025-08-31 12:25:59", "2025-08-31 12:25:59");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1022", "3053", "action created", "2025-08-31 12:25:59", "2025-08-31 12:25:59");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1023", "3052", "action complete via WP Cron", "2025-08-31 12:25:59", "2025-08-31 12:25:59");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1024", "3053", "action started via WP Cron", "2025-08-31 13:29:23", "2025-08-31 13:29:23");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1025", "3054", "action created", "2025-08-31 13:29:23", "2025-08-31 13:29:23");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1026", "3053", "action complete via WP Cron", "2025-08-31 13:29:23", "2025-08-31 13:29:23");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1027", "3020", "action started via WP Cron", "2025-08-31 13:38:57", "2025-08-31 13:38:57");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1028", "3020", "action complete via WP Cron", "2025-08-31 13:38:57", "2025-08-31 13:38:57");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1029", "3055", "action created", "2025-08-31 13:38:57", "2025-08-31 13:38:57");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1030", "3021", "action started via WP Cron", "2025-08-31 13:38:57", "2025-08-31 13:38:57");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1031", "3021", "action complete via WP Cron", "2025-08-31 13:38:59", "2025-08-31 13:38:59");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1032", "3056", "action created", "2025-08-31 13:38:59", "2025-08-31 13:38:59");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1033", "3022", "action started via WP Cron", "2025-08-31 13:38:59", "2025-08-31 13:38:59");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1034", "3022", "action complete via WP Cron", "2025-08-31 13:38:59", "2025-08-31 13:38:59");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1035", "3057", "action created", "2025-08-31 13:38:59", "2025-08-31 13:38:59");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1036", "3023", "action started via WP Cron", "2025-08-31 13:38:59", "2025-08-31 13:38:59");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1037", "3023", "action complete via WP Cron", "2025-08-31 13:38:59", "2025-08-31 13:38:59");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1038", "3058", "action created", "2025-08-31 13:38:59", "2025-08-31 13:38:59");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1039", "3027", "action started via WP Cron", "2025-08-31 13:38:59", "2025-08-31 13:38:59");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1040", "3059", "action created", "2025-08-31 13:38:59", "2025-08-31 13:38:59");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1041", "3027", "action complete via WP Cron", "2025-08-31 13:38:59", "2025-08-31 13:38:59");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1042", "3060", "action created", "2025-08-31 13:38:59", "2025-08-31 13:38:59");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1043", "3059", "action started via WP Cron", "2025-08-31 13:45:36", "2025-08-31 13:45:36");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1044", "3059", "action complete via WP Cron", "2025-08-31 13:45:36", "2025-08-31 13:45:36");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1045", "3042", "action started via WP Cron", "2025-08-31 13:45:36", "2025-08-31 13:45:36");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1046", "3042", "action complete via WP Cron", "2025-08-31 13:45:36", "2025-08-31 13:45:36");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1047", "3061", "action created", "2025-08-31 13:45:36", "2025-08-31 13:45:36");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1048", "3062", "action created", "2025-08-31 13:48:28", "2025-08-31 13:48:28");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1049", "3062", "action started via WP Cron", "2025-08-31 13:53:47", "2025-08-31 13:53:47");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1050", "3062", "action complete via WP Cron", "2025-08-31 13:53:47", "2025-08-31 13:53:47");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1051", "3054", "action started via WP Cron", "2025-08-31 14:47:02", "2025-08-31 14:47:02");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1052", "3063", "action created", "2025-08-31 14:47:02", "2025-08-31 14:47:02");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1053", "3054", "action complete via WP Cron", "2025-08-31 14:47:02", "2025-08-31 14:47:02");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1054", "3063", "action started via WP Cron", "2025-08-31 15:48:03", "2025-08-31 15:48:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1055", "3064", "action created", "2025-08-31 15:48:03", "2025-08-31 15:48:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1056", "3063", "action complete via WP Cron", "2025-08-31 15:48:03", "2025-08-31 15:48:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1057", "3030", "action started via WP Cron", "2025-08-31 16:36:22", "2025-08-31 16:36:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1058", "3030", "action complete via WP Cron", "2025-08-31 16:36:22", "2025-08-31 16:36:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1059", "3065", "action created", "2025-08-31 16:36:22", "2025-08-31 16:36:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1060", "3031", "action started via WP Cron", "2025-08-31 16:36:22", "2025-08-31 16:36:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1061", "3031", "action complete via WP Cron", "2025-08-31 16:36:22", "2025-08-31 16:36:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1062", "3066", "action created", "2025-08-31 16:36:22", "2025-08-31 16:36:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1063", "3064", "action started via WP Cron", "2025-08-31 16:53:48", "2025-08-31 16:53:48");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1064", "3067", "action created", "2025-08-31 16:53:48", "2025-08-31 16:53:48");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1065", "3064", "action complete via WP Cron", "2025-08-31 16:53:48", "2025-08-31 16:53:48");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1066", "3067", "action started via WP Cron", "2025-08-31 18:08:43", "2025-08-31 18:08:43");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1067", "3068", "action created", "2025-08-31 18:08:43", "2025-08-31 18:08:43");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1068", "3067", "action complete via WP Cron", "2025-08-31 18:08:43", "2025-08-31 18:08:43");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1069", "3068", "action started via WP Cron", "2025-08-31 19:09:56", "2025-08-31 19:09:56");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1070", "3069", "action created", "2025-08-31 19:09:56", "2025-08-31 19:09:56");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1071", "3068", "action complete via WP Cron", "2025-08-31 19:09:56", "2025-08-31 19:09:56");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1072", "3069", "action started via WP Cron", "2025-08-31 20:10:11", "2025-08-31 20:10:11");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1073", "3070", "action created", "2025-08-31 20:10:11", "2025-08-31 20:10:11");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1074", "3069", "action complete via WP Cron", "2025-08-31 20:10:11", "2025-08-31 20:10:11");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1075", "3049", "action started via WP Cron", "2025-08-31 20:11:07", "2025-08-31 20:11:07");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1076", "3049", "action complete via WP Cron", "2025-08-31 20:11:07", "2025-08-31 20:11:07");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1077", "3071", "action created", "2025-08-31 20:11:07", "2025-08-31 20:11:07");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1078", "3070", "action started via WP Cron", "2025-08-31 21:10:58", "2025-08-31 21:10:58");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1079", "3072", "action created", "2025-08-31 21:10:58", "2025-08-31 21:10:58");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1080", "3070", "action complete via WP Cron", "2025-08-31 21:10:58", "2025-08-31 21:10:58");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1081", "3073", "action created", "2025-08-31 21:43:58", "2025-08-31 21:43:58");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1082", "3073", "action started via WP Cron", "2025-08-31 21:43:58", "2025-08-31 21:43:58");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1083", "3073", "action complete via WP Cron", "2025-08-31 21:43:59", "2025-08-31 21:43:59");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1084", "3074", "action created", "2025-08-31 21:44:00", "2025-08-31 21:44:00");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1085", "3074", "action started via Async Request", "2025-08-31 21:45:20", "2025-08-31 21:45:20");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1086", "3074", "action complete via Async Request", "2025-08-31 21:45:20", "2025-08-31 21:45:20");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1087", "3075", "action created", "2025-08-31 21:47:23", "2025-08-31 21:47:23");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1088", "3076", "action created", "2025-08-31 21:47:23", "2025-08-31 21:47:23");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1089", "3075", "action started via Async Request", "2025-08-31 21:47:30", "2025-08-31 21:47:30");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1090", "3075", "action complete via Async Request", "2025-08-31 21:47:30", "2025-08-31 21:47:30");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1091", "3076", "action started via Async Request", "2025-08-31 21:48:51", "2025-08-31 21:48:51");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1092", "3076", "action complete via Async Request", "2025-08-31 21:48:51", "2025-08-31 21:48:51");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1093", "3077", "action created", "2025-08-31 22:09:33", "2025-08-31 22:09:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1094", "3078", "action created", "2025-08-31 22:09:34", "2025-08-31 22:09:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1095", "3077", "action started via WP Cron", "2025-08-31 22:10:37", "2025-08-31 22:10:37");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1096", "3077", "action complete via WP Cron", "2025-08-31 22:10:37", "2025-08-31 22:10:37");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1097", "3078", "action started via WP Cron", "2025-08-31 22:10:37", "2025-08-31 22:10:37");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1098", "3078", "action complete via WP Cron", "2025-08-31 22:10:37", "2025-08-31 22:10:37");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1099", "3072", "action started via WP Cron", "2025-08-31 22:11:37", "2025-08-31 22:11:37");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1100", "3079", "action created", "2025-08-31 22:11:37", "2025-08-31 22:11:37");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1101", "3072", "action complete via WP Cron", "2025-08-31 22:11:37", "2025-08-31 22:11:37");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1102", "3080", "action created", "2025-08-31 22:17:09", "2025-08-31 22:17:09");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1103", "3081", "action created", "2025-08-31 22:17:10", "2025-08-31 22:17:10");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1104", "3080", "action started via Async Request", "2025-08-31 22:17:16", "2025-08-31 22:17:16");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1105", "3080", "action complete via Async Request", "2025-08-31 22:17:16", "2025-08-31 22:17:16");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1106", "3081", "action started via WP Cron", "2025-08-31 22:18:11", "2025-08-31 22:18:11");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1107", "3081", "action complete via WP Cron", "2025-08-31 22:18:11", "2025-08-31 22:18:11");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1108", "3082", "action created", "2025-08-31 22:49:18", "2025-08-31 22:49:18");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1109", "3082", "action started via Async Request", "2025-08-31 22:49:19", "2025-08-31 22:49:19");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1110", "3082", "action complete via Async Request", "2025-08-31 22:49:19", "2025-08-31 22:49:19");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1111", "3079", "action started via Async Request", "2025-08-31 23:11:38", "2025-08-31 23:11:38");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1112", "3083", "action created", "2025-08-31 23:11:38", "2025-08-31 23:11:38");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1113", "3079", "action complete via Async Request", "2025-08-31 23:11:38", "2025-08-31 23:11:38");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1114", "3040", "action started via WP Cron", "2025-09-01 00:05:21", "2025-09-01 00:05:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1115", "3040", "action complete via WP Cron", "2025-09-01 00:05:21", "2025-09-01 00:05:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1116", "3084", "action created", "2025-09-01 00:05:21", "2025-09-01 00:05:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1117", "3083", "action started via WP Cron", "2025-09-01 00:25:51", "2025-09-01 00:25:51");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1118", "3085", "action created", "2025-09-01 00:25:51", "2025-09-01 00:25:51");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1119", "3083", "action complete via WP Cron", "2025-09-01 00:25:52", "2025-09-01 00:25:52");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1120", "3086", "action created", "2025-09-01 00:25:54", "2025-09-01 00:25:54");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1121", "3087", "action created", "2025-09-01 00:25:54", "2025-09-01 00:25:54");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1122", "3088", "action created", "2025-09-01 00:25:54", "2025-09-01 00:25:54");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1123", "3086", "action started via Async Request", "2025-09-01 00:25:57", "2025-09-01 00:25:57");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1124", "3086", "action complete via Async Request", "2025-09-01 00:25:57", "2025-09-01 00:25:57");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1125", "3087", "action started via Async Request", "2025-09-01 00:25:57", "2025-09-01 00:25:57");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1126", "3087", "action complete via Async Request", "2025-09-01 00:25:57", "2025-09-01 00:25:57");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1127", "3088", "action started via Async Request", "2025-09-01 00:25:57", "2025-09-01 00:25:57");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1128", "3088", "action complete via Async Request", "2025-09-01 00:25:57", "2025-09-01 00:25:57");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1129", "3085", "action started via WP Cron", "2025-09-01 01:26:13", "2025-09-01 01:26:13");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1130", "3089", "action created", "2025-09-01 01:26:13", "2025-09-01 01:26:13");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1131", "3085", "action complete via WP Cron", "2025-09-01 01:26:13", "2025-09-01 01:26:13");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1132", "3061", "action started via WP Cron", "2025-09-01 01:47:00", "2025-09-01 01:47:00");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1133", "3061", "action complete via WP Cron", "2025-09-01 01:47:01", "2025-09-01 01:47:01");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1134", "3090", "action created", "2025-09-01 01:47:01", "2025-09-01 01:47:01");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1135", "3089", "action started via WP Cron", "2025-09-01 02:26:59", "2025-09-01 02:26:59");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1136", "3091", "action created", "2025-09-01 02:26:59", "2025-09-01 02:26:59");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1137", "3089", "action complete via WP Cron", "2025-09-01 02:26:59", "2025-09-01 02:26:59");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1138", "3091", "action started via WP Cron", "2025-09-01 03:27:42", "2025-09-01 03:27:42");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1139", "3092", "action created", "2025-09-01 03:27:42", "2025-09-01 03:27:42");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1140", "3091", "action complete via WP Cron", "2025-09-01 03:27:42", "2025-09-01 03:27:42");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1141", "3092", "action started via WP Cron", "2025-09-01 04:28:24", "2025-09-01 04:28:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1142", "3093", "action created", "2025-09-01 04:28:24", "2025-09-01 04:28:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1143", "3092", "action complete via WP Cron", "2025-09-01 04:28:24", "2025-09-01 04:28:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1144", "3093", "action started via Async Request", "2025-09-01 05:28:32", "2025-09-01 05:28:32");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1145", "3094", "action created", "2025-09-01 05:28:32", "2025-09-01 05:28:32");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1146", "3093", "action complete via Async Request", "2025-09-01 05:28:32", "2025-09-01 05:28:32");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1147", "3094", "action started via WP Cron", "2025-09-01 06:29:51", "2025-09-01 06:29:51");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1148", "3095", "action created", "2025-09-01 06:29:51", "2025-09-01 06:29:51");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1149", "3094", "action complete via WP Cron", "2025-09-01 06:29:51", "2025-09-01 06:29:51");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1150", "3095", "action started via WP Cron", "2025-09-01 07:31:32", "2025-09-01 07:31:32");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1151", "3096", "action created", "2025-09-01 07:31:32", "2025-09-01 07:31:32");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1152", "3095", "action complete via WP Cron", "2025-09-01 07:31:32", "2025-09-01 07:31:32");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1153", "3071", "action started via WP Cron", "2025-09-01 08:13:08", "2025-09-01 08:13:08");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1154", "3071", "action complete via WP Cron", "2025-09-01 08:13:08", "2025-09-01 08:13:08");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1155", "3097", "action created", "2025-09-01 08:13:08", "2025-09-01 08:13:08");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1156", "3096", "action started via WP Cron", "2025-09-01 08:48:07", "2025-09-01 08:48:07");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1157", "3098", "action created", "2025-09-01 08:48:07", "2025-09-01 08:48:07");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1158", "3096", "action complete via WP Cron", "2025-09-01 08:48:07", "2025-09-01 08:48:07");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1159", "3098", "action started via WP Cron", "2025-09-01 10:20:45", "2025-09-01 10:20:45");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1160", "3099", "action created", "2025-09-01 10:20:45", "2025-09-01 10:20:45");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1161", "3098", "action complete via WP Cron", "2025-09-01 10:20:45", "2025-09-01 10:20:45");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1162", "3099", "action started via WP Cron", "2025-09-01 11:23:36", "2025-09-01 11:23:36");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1163", "3100", "action created", "2025-09-01 11:23:36", "2025-09-01 11:23:36");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1164", "3099", "action complete via WP Cron", "2025-09-01 11:23:36", "2025-09-01 11:23:36");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1165", "3100", "action started via WP Cron", "2025-09-01 12:28:46", "2025-09-01 12:28:46");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1166", "3101", "action created", "2025-09-01 12:28:46", "2025-09-01 12:28:46");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1167", "3100", "action complete via WP Cron", "2025-09-01 12:28:46", "2025-09-01 12:28:46");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1168", "3101", "action started via WP Cron", "2025-09-01 13:56:52", "2025-09-01 13:56:52");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1169", "3102", "action created", "2025-09-01 13:56:52", "2025-09-01 13:56:52");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1170", "3101", "action complete via WP Cron", "2025-09-01 13:56:52", "2025-09-01 13:56:52");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1171", "3055", "action started via WP Cron", "2025-09-01 13:56:53", "2025-09-01 13:56:53");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1172", "3055", "action complete via WP Cron", "2025-09-01 13:56:53", "2025-09-01 13:56:53");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1173", "3103", "action created", "2025-09-01 13:56:53", "2025-09-01 13:56:53");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1174", "3056", "action started via WP Cron", "2025-09-01 13:56:53", "2025-09-01 13:56:53");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1175", "3056", "action complete via WP Cron", "2025-09-01 13:56:58", "2025-09-01 13:56:58");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1176", "3104", "action created", "2025-09-01 13:56:59", "2025-09-01 13:56:59");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1177", "3057", "action started via WP Cron", "2025-09-01 13:56:59", "2025-09-01 13:56:59");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1178", "3057", "action complete via WP Cron", "2025-09-01 13:57:00", "2025-09-01 13:57:00");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1179", "3105", "action created", "2025-09-01 13:57:00", "2025-09-01 13:57:00");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1180", "3058", "action started via WP Cron", "2025-09-01 13:57:00", "2025-09-01 13:57:00");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1181", "3058", "action complete via WP Cron", "2025-09-01 13:57:00", "2025-09-01 13:57:00");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1182", "3106", "action created", "2025-09-01 13:57:00", "2025-09-01 13:57:00");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1183", "3090", "action started via WP Cron", "2025-09-01 13:57:00", "2025-09-01 13:57:00");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1184", "3090", "action complete via WP Cron", "2025-09-01 13:57:00", "2025-09-01 13:57:00");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1185", "3107", "action created", "2025-09-01 13:57:00", "2025-09-01 13:57:00");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1186", "3060", "action started via WP Cron", "2025-09-01 13:57:00", "2025-09-01 13:57:00");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1187", "3108", "action created", "2025-09-01 13:57:00", "2025-09-01 13:57:00");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1188", "3060", "action complete via WP Cron", "2025-09-01 13:57:00", "2025-09-01 13:57:00");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1189", "3109", "action created", "2025-09-01 13:57:00", "2025-09-01 13:57:00");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1190", "3108", "action started via WP Cron", "2025-09-01 13:57:15", "2025-09-01 13:57:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1191", "3108", "action complete via WP Cron", "2025-09-01 13:57:15", "2025-09-01 13:57:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1192", "3110", "action created", "2025-09-01 14:49:39", "2025-09-01 14:49:39");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1193", "3111", "action created", "2025-09-01 14:49:39", "2025-09-01 14:49:39");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1194", "3110", "action started via WP Cron", "2025-09-01 14:50:34", "2025-09-01 14:50:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1195", "3110", "action complete via WP Cron", "2025-09-01 14:50:35", "2025-09-01 14:50:35");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1196", "3111", "action started via WP Cron", "2025-09-01 14:51:22", "2025-09-01 14:51:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1197", "3111", "action complete via WP Cron", "2025-09-01 14:51:22", "2025-09-01 14:51:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1198", "3102", "action started via WP Cron", "2025-09-01 14:57:15", "2025-09-01 14:57:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1199", "3112", "action created", "2025-09-01 14:57:15", "2025-09-01 14:57:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1200", "3102", "action complete via WP Cron", "2025-09-01 14:57:15", "2025-09-01 14:57:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1201", "3113", "action created", "2025-09-01 15:06:47", "2025-09-01 15:06:47");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1202", "3114", "action created", "2025-09-01 15:06:47", "2025-09-01 15:06:47");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1203", "3113", "action started via WP Cron", "2025-09-01 15:07:56", "2025-09-01 15:07:56");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1204", "3113", "action complete via WP Cron", "2025-09-01 15:07:57", "2025-09-01 15:07:57");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1205", "3114", "action started via WP Cron", "2025-09-01 15:07:57", "2025-09-01 15:07:57");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1206", "3114", "action complete via WP Cron", "2025-09-01 15:07:57", "2025-09-01 15:07:57");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1207", "3112", "action started via WP Cron", "2025-09-01 16:02:18", "2025-09-01 16:02:18");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1208", "3115", "action created", "2025-09-01 16:02:18", "2025-09-01 16:02:18");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1209", "3112", "action complete via WP Cron", "2025-09-01 16:02:18", "2025-09-01 16:02:18");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1210", "3065", "action started via WP Cron", "2025-09-01 16:42:33", "2025-09-01 16:42:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1211", "3065", "action complete via WP Cron", "2025-09-01 16:42:34", "2025-09-01 16:42:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1212", "3116", "action created", "2025-09-01 16:42:34", "2025-09-01 16:42:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1213", "3066", "action started via WP Cron", "2025-09-01 16:42:34", "2025-09-01 16:42:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1214", "3066", "action complete via WP Cron", "2025-09-01 16:42:34", "2025-09-01 16:42:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1215", "3117", "action created", "2025-09-01 16:42:34", "2025-09-01 16:42:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1216", "3115", "action started via Async Request", "2025-09-01 17:02:31", "2025-09-01 17:02:31");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1217", "3118", "action created", "2025-09-01 17:02:31", "2025-09-01 17:02:31");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1218", "3115", "action complete via Async Request", "2025-09-01 17:02:31", "2025-09-01 17:02:31");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1219", "3118", "action started via WP Cron", "2025-09-01 18:03:02", "2025-09-01 18:03:02");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1220", "3119", "action created", "2025-09-01 18:03:02", "2025-09-01 18:03:02");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1221", "3118", "action complete via WP Cron", "2025-09-01 18:03:02", "2025-09-01 18:03:02");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1222", "3119", "action started via WP Cron", "2025-09-01 19:03:17", "2025-09-01 19:03:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1223", "3120", "action created", "2025-09-01 19:03:17", "2025-09-01 19:03:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1224", "3119", "action complete via WP Cron", "2025-09-01 19:03:17", "2025-09-01 19:03:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1225", "3120", "action started via WP Cron", "2025-09-01 20:41:47", "2025-09-01 20:41:47");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1226", "3121", "action created", "2025-09-01 20:41:47", "2025-09-01 20:41:47");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1227", "3120", "action complete via WP Cron", "2025-09-01 20:41:47", "2025-09-01 20:41:47");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1228", "3097", "action started via WP Cron", "2025-09-01 20:41:47", "2025-09-01 20:41:47");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1229", "3097", "action complete via WP Cron", "2025-09-01 20:41:47", "2025-09-01 20:41:47");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1230", "3122", "action created", "2025-09-01 20:41:47", "2025-09-01 20:41:47");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1231", "3121", "action started via WP Cron", "2025-09-01 21:41:55", "2025-09-01 21:41:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1232", "3123", "action created", "2025-09-01 21:41:55", "2025-09-01 21:41:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1233", "3121", "action complete via WP Cron", "2025-09-01 21:41:55", "2025-09-01 21:41:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1234", "3082", "action ignored via WP Cron", "2025-09-01 21:48:03", "2025-09-01 21:48:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1235", "3123", "action started via WP Cron", "2025-09-01 22:43:03", "2025-09-01 22:43:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1236", "3124", "action created", "2025-09-01 22:43:03", "2025-09-01 22:43:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1237", "3123", "action complete via WP Cron", "2025-09-01 22:43:03", "2025-09-01 22:43:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1238", "3079", "action ignored via WP Cron", "2025-09-01 22:50:01", "2025-09-01 22:50:01");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1239", "3124", "action started via WP Cron", "2025-09-01 23:45:17", "2025-09-01 23:45:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1240", "3125", "action created", "2025-09-01 23:45:17", "2025-09-01 23:45:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1241", "3124", "action complete via WP Cron", "2025-09-01 23:45:17", "2025-09-01 23:45:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1242", "3084", "action started via WP Cron", "2025-09-02 00:14:36", "2025-09-02 00:14:36");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1243", "3084", "action complete via WP Cron", "2025-09-02 00:14:36", "2025-09-02 00:14:36");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1244", "3126", "action created", "2025-09-02 00:14:36", "2025-09-02 00:14:36");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1245", "3125", "action started via WP Cron", "2025-09-02 00:57:17", "2025-09-02 00:57:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1246", "3127", "action created", "2025-09-02 00:57:17", "2025-09-02 00:57:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1247", "3125", "action complete via WP Cron", "2025-09-02 00:57:17", "2025-09-02 00:57:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1248", "3107", "action started via WP Cron", "2025-09-02 02:08:34", "2025-09-02 02:08:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1249", "3107", "action complete via WP Cron", "2025-09-02 02:08:34", "2025-09-02 02:08:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1250", "3128", "action created", "2025-09-02 02:08:34", "2025-09-02 02:08:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1251", "3127", "action started via WP Cron", "2025-09-02 02:08:34", "2025-09-02 02:08:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1252", "3129", "action created", "2025-09-02 02:08:34", "2025-09-02 02:08:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1253", "3127", "action complete via WP Cron", "2025-09-02 02:08:34", "2025-09-02 02:08:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1254", "3040", "action ignored via WP Cron", "2025-09-02 02:08:34", "2025-09-02 02:08:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1255", "3083", "action ignored via WP Cron", "2025-09-02 02:30:20", "2025-09-02 02:30:20");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1256", "3086", "action ignored via WP Cron", "2025-09-02 02:38:27", "2025-09-02 02:38:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1257", "3087", "action ignored via WP Cron", "2025-09-02 02:38:27", "2025-09-02 02:38:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1258", "3088", "action ignored via WP Cron", "2025-09-02 02:38:27", "2025-09-02 02:38:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1259", "3129", "action started via WP Cron", "2025-09-02 03:29:31", "2025-09-02 03:29:31");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1260", "3130", "action created", "2025-09-02 03:29:31", "2025-09-02 03:29:31");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1261", "3129", "action complete via WP Cron", "2025-09-02 03:29:31", "2025-09-02 03:29:31");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1262", "3130", "action started via WP Cron", "2025-09-02 04:42:28", "2025-09-02 04:42:28");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1263", "3131", "action created", "2025-09-02 04:42:28", "2025-09-02 04:42:28");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1264", "3130", "action complete via WP Cron", "2025-09-02 04:42:28", "2025-09-02 04:42:28");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1265", "3131", "action started via WP Cron", "2025-09-02 05:43:10", "2025-09-02 05:43:10");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1266", "3132", "action created", "2025-09-02 05:43:10", "2025-09-02 05:43:10");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1267", "3131", "action complete via WP Cron", "2025-09-02 05:43:10", "2025-09-02 05:43:10");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1268", "3132", "action started via WP Cron", "2025-09-02 06:48:58", "2025-09-02 06:48:58");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1269", "3133", "action created", "2025-09-02 06:48:58", "2025-09-02 06:48:58");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1270", "3132", "action complete via WP Cron", "2025-09-02 06:48:58", "2025-09-02 06:48:58");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1271", "3133", "action started via WP Cron", "2025-09-02 07:53:40", "2025-09-02 07:53:40");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1272", "3134", "action created", "2025-09-02 07:53:40", "2025-09-02 07:53:40");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1273", "3133", "action complete via WP Cron", "2025-09-02 07:53:40", "2025-09-02 07:53:40");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1274", "3085", "action ignored via WP Cron", "2025-09-02 08:07:05", "2025-09-02 08:07:05");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1275", "3122", "action started via WP Cron", "2025-09-02 08:49:36", "2025-09-02 08:49:36");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1276", "3122", "action complete via WP Cron", "2025-09-02 08:49:36", "2025-09-02 08:49:36");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1277", "3135", "action created", "2025-09-02 08:49:36", "2025-09-02 08:49:36");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1278", "3061", "action ignored via WP Cron", "2025-09-02 08:49:36", "2025-09-02 08:49:36");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1279", "3134", "action started via WP Cron", "2025-09-02 09:12:47", "2025-09-02 09:12:47");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1280", "3136", "action created", "2025-09-02 09:12:47", "2025-09-02 09:12:47");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1281", "3134", "action complete via WP Cron", "2025-09-02 09:12:47", "2025-09-02 09:12:47");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1282", "3136", "action started via WP Cron", "2025-09-02 11:00:06", "2025-09-02 11:00:06");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1283", "3137", "action created", "2025-09-02 11:00:07", "2025-09-02 11:00:07");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1284", "3136", "action complete via WP Cron", "2025-09-02 11:00:07", "2025-09-02 11:00:07");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1285", "3089", "action ignored via WP Cron", "2025-09-02 11:24:06", "2025-09-02 11:24:06");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1286", "3137", "action started via WP Cron", "2025-09-02 12:00:10", "2025-09-02 12:00:10");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1287", "3138", "action created", "2025-09-02 12:00:10", "2025-09-02 12:00:10");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1288", "3137", "action complete via WP Cron", "2025-09-02 12:00:10", "2025-09-02 12:00:10");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1289", "3138", "action started via WP Cron", "2025-09-02 13:03:01", "2025-09-02 13:03:01");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1290", "3139", "action created", "2025-09-02 13:03:01", "2025-09-02 13:03:01");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1291", "3138", "action complete via WP Cron", "2025-09-02 13:03:01", "2025-09-02 13:03:01");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1292", "3103", "action started via WP Cron", "2025-09-02 14:18:27", "2025-09-02 14:18:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1293", "3103", "action complete via WP Cron", "2025-09-02 14:18:27", "2025-09-02 14:18:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1294", "3140", "action created", "2025-09-02 14:18:28", "2025-09-02 14:18:28");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1295", "3104", "action started via WP Cron", "2025-09-02 14:18:28", "2025-09-02 14:18:28");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1296", "3104", "action complete via WP Cron", "2025-09-02 14:18:32", "2025-09-02 14:18:32");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1297", "3141", "action created", "2025-09-02 14:18:32", "2025-09-02 14:18:32");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1298", "3105", "action started via WP Cron", "2025-09-02 14:18:32", "2025-09-02 14:18:32");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1299", "3105", "action complete via WP Cron", "2025-09-02 14:18:33", "2025-09-02 14:18:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1300", "3142", "action created", "2025-09-02 14:18:33", "2025-09-02 14:18:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1301", "3106", "action started via WP Cron", "2025-09-02 14:18:33", "2025-09-02 14:18:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1302", "3106", "action complete via WP Cron", "2025-09-02 14:18:33", "2025-09-02 14:18:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1303", "3143", "action created", "2025-09-02 14:18:33", "2025-09-02 14:18:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1304", "3139", "action started via WP Cron", "2025-09-02 14:18:33", "2025-09-02 14:18:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1305", "3144", "action created", "2025-09-02 14:18:33", "2025-09-02 14:18:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1306", "3139", "action complete via WP Cron", "2025-09-02 14:18:33", "2025-09-02 14:18:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1307", "3128", "action started via WP Cron", "2025-09-02 14:18:33", "2025-09-02 14:18:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1308", "3128", "action complete via WP Cron", "2025-09-02 14:18:33", "2025-09-02 14:18:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1309", "3145", "action created", "2025-09-02 14:18:33", "2025-09-02 14:18:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1310", "3109", "action started via WP Cron", "2025-09-02 14:18:33", "2025-09-02 14:18:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1311", "3146", "action created", "2025-09-02 14:18:33", "2025-09-02 14:18:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1312", "3109", "action complete via WP Cron", "2025-09-02 14:18:33", "2025-09-02 14:18:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1313", "3147", "action created", "2025-09-02 14:18:34", "2025-09-02 14:18:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1314", "3146", "action started via WP Cron", "2025-09-02 14:20:29", "2025-09-02 14:20:29");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1315", "3146", "action complete via WP Cron", "2025-09-02 14:20:29", "2025-09-02 14:20:29");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1316", "3144", "action started via WP Cron", "2025-09-02 15:35:05", "2025-09-02 15:35:05");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1317", "3148", "action created", "2025-09-02 15:35:05", "2025-09-02 15:35:05");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1318", "3144", "action complete via WP Cron", "2025-09-02 15:35:05", "2025-09-02 15:35:05");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1319", "3148", "action started via WP Cron", "2025-09-02 16:35:07", "2025-09-02 16:35:07");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1320", "3149", "action created", "2025-09-02 16:35:07", "2025-09-02 16:35:07");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1321", "3148", "action complete via WP Cron", "2025-09-02 16:35:07", "2025-09-02 16:35:07");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1322", "3116", "action started via WP Cron", "2025-09-02 17:14:55", "2025-09-02 17:14:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1323", "3116", "action complete via WP Cron", "2025-09-02 17:14:55", "2025-09-02 17:14:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1324", "3150", "action created", "2025-09-02 17:14:55", "2025-09-02 17:14:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1325", "3117", "action started via WP Cron", "2025-09-02 17:14:55", "2025-09-02 17:14:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1326", "3117", "action complete via WP Cron", "2025-09-02 17:14:55", "2025-09-02 17:14:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1327", "3151", "action created", "2025-09-02 17:14:55", "2025-09-02 17:14:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1328", "3091", "action ignored via WP Cron", "2025-09-02 17:14:58", "2025-09-02 17:14:58");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1329", "3149", "action started via WP Cron", "2025-09-02 17:36:27", "2025-09-02 17:36:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1330", "3152", "action created", "2025-09-02 17:36:27", "2025-09-02 17:36:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1331", "3149", "action complete via WP Cron", "2025-09-02 17:36:27", "2025-09-02 17:36:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1332", "3152", "action started via WP Cron", "2025-09-02 18:41:48", "2025-09-02 18:41:48");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1333", "3153", "action created", "2025-09-02 18:41:49", "2025-09-02 18:41:49");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1334", "3152", "action complete via WP Cron", "2025-09-02 18:41:49", "2025-09-02 18:41:49");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1335", "3153", "action started via WP Cron", "2025-09-02 19:58:38", "2025-09-02 19:58:38");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1336", "3154", "action created", "2025-09-02 19:58:38", "2025-09-02 19:58:38");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1337", "3153", "action complete via WP Cron", "2025-09-02 19:58:38", "2025-09-02 19:58:38");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1338", "3135", "action started via WP Cron", "2025-09-02 21:01:01", "2025-09-02 21:01:01");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1339", "3135", "action complete via WP Cron", "2025-09-02 21:01:01", "2025-09-02 21:01:01");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1340", "3155", "action created", "2025-09-02 21:01:01", "2025-09-02 21:01:01");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1341", "3154", "action started via WP Cron", "2025-09-02 21:01:01", "2025-09-02 21:01:01");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1342", "3156", "action created", "2025-09-02 21:01:01", "2025-09-02 21:01:01");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1343", "3154", "action complete via WP Cron", "2025-09-02 21:01:01", "2025-09-02 21:01:01");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1344", "3156", "action started via WP Cron", "2025-09-02 22:07:18", "2025-09-02 22:07:18");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1345", "3157", "action created", "2025-09-02 22:07:18", "2025-09-02 22:07:18");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1346", "3156", "action complete via WP Cron", "2025-09-02 22:07:18", "2025-09-02 22:07:18");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1347", "3157", "action started via WP Cron", "2025-09-02 23:23:15", "2025-09-02 23:23:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1348", "3158", "action created", "2025-09-02 23:23:15", "2025-09-02 23:23:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1349", "3157", "action complete via WP Cron", "2025-09-02 23:23:15", "2025-09-02 23:23:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1350", "3126", "action started via WP Cron", "2025-09-03 00:18:54", "2025-09-03 00:18:54");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1351", "3126", "action complete via WP Cron", "2025-09-03 00:18:54", "2025-09-03 00:18:54");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1352", "3159", "action created", "2025-09-03 00:18:54", "2025-09-03 00:18:54");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1353", "3158", "action started via WP Cron", "2025-09-03 00:38:56", "2025-09-03 00:38:56");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1354", "3160", "action created", "2025-09-03 00:38:56", "2025-09-03 00:38:56");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1355", "3158", "action complete via WP Cron", "2025-09-03 00:38:56", "2025-09-03 00:38:56");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1356", "3160", "action started via WP Cron", "2025-09-03 01:45:13", "2025-09-03 01:45:13");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1357", "3161", "action created", "2025-09-03 01:45:13", "2025-09-03 01:45:13");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1358", "3160", "action complete via WP Cron", "2025-09-03 01:45:13", "2025-09-03 01:45:13");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1359", "3092", "action ignored via WP Cron", "2025-09-03 01:45:13", "2025-09-03 01:45:13");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1360", "3145", "action started via WP Cron", "2025-09-03 03:17:32", "2025-09-03 03:17:32");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1361", "3145", "action complete via WP Cron", "2025-09-03 03:17:32", "2025-09-03 03:17:32");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1362", "3162", "action created", "2025-09-03 03:17:32", "2025-09-03 03:17:32");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1363", "3161", "action started via WP Cron", "2025-09-03 03:17:32", "2025-09-03 03:17:32");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1364", "3163", "action created", "2025-09-03 03:17:32", "2025-09-03 03:17:32");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1365", "3161", "action complete via WP Cron", "2025-09-03 03:17:32", "2025-09-03 03:17:32");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1366", "3163", "action started via WP Cron", "2025-09-03 04:26:07", "2025-09-03 04:26:07");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1367", "3164", "action created", "2025-09-03 04:26:07", "2025-09-03 04:26:07");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1368", "3163", "action complete via WP Cron", "2025-09-03 04:26:07", "2025-09-03 04:26:07");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1369", "3164", "action started via WP Cron", "2025-09-03 05:33:11", "2025-09-03 05:33:11");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1370", "3165", "action created", "2025-09-03 05:33:11", "2025-09-03 05:33:11");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1371", "3164", "action complete via WP Cron", "2025-09-03 05:33:11", "2025-09-03 05:33:11");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1372", "3165", "action started via WP Cron", "2025-09-03 06:35:44", "2025-09-03 06:35:44");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1373", "3166", "action created", "2025-09-03 06:35:44", "2025-09-03 06:35:44");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1374", "3165", "action complete via WP Cron", "2025-09-03 06:35:44", "2025-09-03 06:35:44");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1375", "3166", "action started via WP Cron", "2025-09-03 07:36:22", "2025-09-03 07:36:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1376", "3167", "action created", "2025-09-03 07:36:22", "2025-09-03 07:36:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1377", "3166", "action complete via WP Cron", "2025-09-03 07:36:22", "2025-09-03 07:36:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1378", "3167", "action started via WP Cron", "2025-09-03 08:37:26", "2025-09-03 08:37:26");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1379", "3168", "action created", "2025-09-03 08:37:26", "2025-09-03 08:37:26");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1380", "3167", "action complete via WP Cron", "2025-09-03 08:37:26", "2025-09-03 08:37:26");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1381", "3155", "action started via WP Cron", "2025-09-03 09:16:17", "2025-09-03 09:16:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1382", "3155", "action complete via WP Cron", "2025-09-03 09:16:17", "2025-09-03 09:16:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1383", "3169", "action created", "2025-09-03 09:16:17", "2025-09-03 09:16:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1384", "3168", "action started via WP Cron", "2025-09-03 09:43:12", "2025-09-03 09:43:12");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1385", "3170", "action created", "2025-09-03 09:43:12", "2025-09-03 09:43:12");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1386", "3168", "action complete via WP Cron", "2025-09-03 09:43:12", "2025-09-03 09:43:12");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1387", "3170", "action started via WP Cron", "2025-09-03 10:45:43", "2025-09-03 10:45:43");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1388", "3171", "action created", "2025-09-03 10:45:43", "2025-09-03 10:45:43");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1389", "3170", "action complete via WP Cron", "2025-09-03 10:45:43", "2025-09-03 10:45:43");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1390", "3093", "action ignored via WP Cron", "2025-09-03 11:16:23", "2025-09-03 11:16:23");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1391", "3171", "action started via WP Cron", "2025-09-03 11:58:44", "2025-09-03 11:58:44");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1392", "3172", "action created", "2025-09-03 11:58:44", "2025-09-03 11:58:44");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1393", "3171", "action complete via WP Cron", "2025-09-03 11:58:44", "2025-09-03 11:58:44");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1394", "3172", "action started via WP Cron", "2025-09-03 13:07:37", "2025-09-03 13:07:37");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1395", "3173", "action created", "2025-09-03 13:07:37", "2025-09-03 13:07:37");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1396", "3172", "action complete via WP Cron", "2025-09-03 13:07:37", "2025-09-03 13:07:37");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1397", "3173", "action started via WP Cron", "2025-09-03 15:08:19", "2025-09-03 15:08:19");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1398", "3174", "action created", "2025-09-03 15:08:19", "2025-09-03 15:08:19");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1399", "3173", "action complete via WP Cron", "2025-09-03 15:08:19", "2025-09-03 15:08:19");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1400", "3140", "action started via WP Cron", "2025-09-03 15:08:19", "2025-09-03 15:08:19");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1401", "3140", "action complete via WP Cron", "2025-09-03 15:08:19", "2025-09-03 15:08:19");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1402", "3175", "action created", "2025-09-03 15:08:19", "2025-09-03 15:08:19");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1403", "3141", "action started via WP Cron", "2025-09-03 15:08:19", "2025-09-03 15:08:19");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1404", "3141", "action complete via WP Cron", "2025-09-03 15:08:21", "2025-09-03 15:08:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1405", "3176", "action created", "2025-09-03 15:08:21", "2025-09-03 15:08:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1406", "3142", "action started via WP Cron", "2025-09-03 15:08:21", "2025-09-03 15:08:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1407", "3142", "action complete via WP Cron", "2025-09-03 15:08:22", "2025-09-03 15:08:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1408", "3177", "action created", "2025-09-03 15:08:22", "2025-09-03 15:08:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1409", "3143", "action started via WP Cron", "2025-09-03 15:08:22", "2025-09-03 15:08:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1410", "3143", "action complete via WP Cron", "2025-09-03 15:08:22", "2025-09-03 15:08:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1411", "3178", "action created", "2025-09-03 15:08:22", "2025-09-03 15:08:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1412", "3147", "action started via WP Cron", "2025-09-03 15:08:22", "2025-09-03 15:08:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1413", "3179", "action created", "2025-09-03 15:08:22", "2025-09-03 15:08:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1414", "3147", "action complete via WP Cron", "2025-09-03 15:08:22", "2025-09-03 15:08:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1415", "3180", "action created", "2025-09-03 15:08:22", "2025-09-03 15:08:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1416", "3179", "action started via WP Cron", "2025-09-03 15:20:39", "2025-09-03 15:20:39");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1417", "3179", "action complete via WP Cron", "2025-09-03 15:20:39", "2025-09-03 15:20:39");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1418", "3162", "action started via WP Cron", "2025-09-03 15:20:39", "2025-09-03 15:20:39");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1419", "3162", "action complete via WP Cron", "2025-09-03 15:20:40", "2025-09-03 15:20:40");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1420", "3181", "action created", "2025-09-03 15:20:40", "2025-09-03 15:20:40");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1421", "3174", "action started via WP Cron", "2025-09-03 16:24:33", "2025-09-03 16:24:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1422", "3182", "action created", "2025-09-03 16:24:34", "2025-09-03 16:24:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1423", "3174", "action complete via WP Cron", "2025-09-03 16:24:34", "2025-09-03 16:24:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1424", "3150", "action started via WP Cron", "2025-09-03 17:44:43", "2025-09-03 17:44:43");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1425", "3150", "action complete via WP Cron", "2025-09-03 17:44:43", "2025-09-03 17:44:43");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1426", "3183", "action created", "2025-09-03 17:44:43", "2025-09-03 17:44:43");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1427", "3151", "action started via WP Cron", "2025-09-03 17:44:43", "2025-09-03 17:44:43");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1428", "3151", "action complete via WP Cron", "2025-09-03 17:44:43", "2025-09-03 17:44:43");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1429", "3184", "action created", "2025-09-03 17:44:43", "2025-09-03 17:44:43");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1430", "3182", "action started via WP Cron", "2025-09-03 17:44:43", "2025-09-03 17:44:43");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1431", "3185", "action created", "2025-09-03 17:44:43", "2025-09-03 17:44:43");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1432", "3182", "action complete via WP Cron", "2025-09-03 17:44:43", "2025-09-03 17:44:43");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1433", "3185", "action started via WP Cron", "2025-09-03 18:48:14", "2025-09-03 18:48:14");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1434", "3186", "action created", "2025-09-03 18:48:14", "2025-09-03 18:48:14");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1435", "3185", "action complete via WP Cron", "2025-09-03 18:48:14", "2025-09-03 18:48:14");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1436", "3094", "action ignored via WP Cron", "2025-09-03 19:11:57", "2025-09-03 19:11:57");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1437", "3186", "action started via WP Cron", "2025-09-03 19:50:29", "2025-09-03 19:50:29");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1438", "3187", "action created", "2025-09-03 19:50:29", "2025-09-03 19:50:29");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1439", "3186", "action complete via WP Cron", "2025-09-03 19:50:29", "2025-09-03 19:50:29");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1440", "3187", "action started via WP Cron", "2025-09-03 21:23:33", "2025-09-03 21:23:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1441", "3188", "action created", "2025-09-03 21:23:33", "2025-09-03 21:23:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1442", "3187", "action complete via WP Cron", "2025-09-03 21:23:33", "2025-09-03 21:23:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1443", "3169", "action started via WP Cron", "2025-09-03 21:23:33", "2025-09-03 21:23:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1444", "3169", "action complete via WP Cron", "2025-09-03 21:23:33", "2025-09-03 21:23:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1445", "3189", "action created", "2025-09-03 21:23:33", "2025-09-03 21:23:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1446", "3188", "action started via WP Cron", "2025-09-03 22:29:25", "2025-09-03 22:29:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1447", "3190", "action created", "2025-09-03 22:29:25", "2025-09-03 22:29:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1448", "3188", "action complete via WP Cron", "2025-09-03 22:29:25", "2025-09-03 22:29:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1449", "3190", "action started via WP Cron", "2025-09-03 23:47:28", "2025-09-03 23:47:28");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1450", "3191", "action created", "2025-09-03 23:47:28", "2025-09-03 23:47:28");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1451", "3190", "action complete via WP Cron", "2025-09-03 23:47:29", "2025-09-03 23:47:29");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1452", "3095", "action ignored via WP Cron", "2025-09-03 23:48:25", "2025-09-03 23:48:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1453", "3159", "action started via WP Cron", "2025-09-04 00:30:42", "2025-09-04 00:30:42");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1454", "3159", "action complete via WP Cron", "2025-09-04 00:30:42", "2025-09-04 00:30:42");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1455", "3192", "action created", "2025-09-04 00:30:42", "2025-09-04 00:30:42");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1456", "3191", "action started via WP Cron", "2025-09-04 00:49:00", "2025-09-04 00:49:00");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1457", "3193", "action created", "2025-09-04 00:49:00", "2025-09-04 00:49:00");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1458", "3191", "action complete via WP Cron", "2025-09-04 00:49:00", "2025-09-04 00:49:00");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1459", "3193", "action started via WP Cron", "2025-09-04 01:50:29", "2025-09-04 01:50:29");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1460", "3194", "action created", "2025-09-04 01:50:29", "2025-09-04 01:50:29");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1461", "3193", "action complete via WP Cron", "2025-09-04 01:50:29", "2025-09-04 01:50:29");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1462", "3071", "action ignored via WP Cron", "2025-09-04 01:52:58", "2025-09-04 01:52:58");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1463", "3096", "action ignored via WP Cron", "2025-09-04 02:30:58", "2025-09-04 02:30:58");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1464", "3194", "action started via WP Cron", "2025-09-04 03:02:14", "2025-09-04 03:02:14");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1465", "3195", "action created", "2025-09-04 03:02:14", "2025-09-04 03:02:14");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1466", "3194", "action complete via WP Cron", "2025-09-04 03:02:14", "2025-09-04 03:02:14");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1467", "3181", "action started via WP Cron", "2025-09-04 04:10:24", "2025-09-04 04:10:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1468", "3181", "action complete via WP Cron", "2025-09-04 04:10:24", "2025-09-04 04:10:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1469", "3196", "action created", "2025-09-04 04:10:24", "2025-09-04 04:10:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1470", "3195", "action started via WP Cron", "2025-09-04 04:10:24", "2025-09-04 04:10:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1471", "3197", "action created", "2025-09-04 04:10:24", "2025-09-04 04:10:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1472", "3195", "action complete via WP Cron", "2025-09-04 04:10:24", "2025-09-04 04:10:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1473", "3098", "action ignored via WP Cron", "2025-09-04 04:47:07", "2025-09-04 04:47:07");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1474", "3197", "action started via WP Cron", "2025-09-04 05:11:03", "2025-09-04 05:11:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1475", "3198", "action created", "2025-09-04 05:11:03", "2025-09-04 05:11:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1476", "3197", "action complete via WP Cron", "2025-09-04 05:11:03", "2025-09-04 05:11:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1477", "3099", "action ignored via WP Cron", "2025-09-04 05:11:03", "2025-09-04 05:11:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1478", "3100", "action ignored via WP Cron", "2025-09-04 06:02:08", "2025-09-04 06:02:08");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1479", "3198", "action started via WP Cron", "2025-09-04 07:18:22", "2025-09-04 07:18:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1480", "3199", "action created", "2025-09-04 07:18:22", "2025-09-04 07:18:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1481", "3198", "action complete via WP Cron", "2025-09-04 07:18:22", "2025-09-04 07:18:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1482", "3101", "action ignored via WP Cron", "2025-09-04 07:53:27", "2025-09-04 07:53:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1483", "3055", "action ignored via WP Cron", "2025-09-04 07:53:27", "2025-09-04 07:53:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1484", "3056", "action ignored via WP Cron", "2025-09-04 07:53:27", "2025-09-04 07:53:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1485", "3057", "action ignored via WP Cron", "2025-09-04 07:53:27", "2025-09-04 07:53:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1486", "3058", "action ignored via WP Cron", "2025-09-04 07:53:27", "2025-09-04 07:53:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1487", "3090", "action ignored via WP Cron", "2025-09-04 07:53:27", "2025-09-04 07:53:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1488", "3060", "action ignored via WP Cron", "2025-09-04 07:53:27", "2025-09-04 07:53:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1489", "3108", "action ignored via WP Cron", "2025-09-04 07:54:38", "2025-09-04 07:54:38");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1490", "3199", "action started via WP Cron", "2025-09-04 08:36:18", "2025-09-04 08:36:18");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1491", "3200", "action created", "2025-09-04 08:36:18", "2025-09-04 08:36:18");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1492", "3199", "action complete via WP Cron", "2025-09-04 08:36:18", "2025-09-04 08:36:18");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1493", "3110", "action ignored via WP Cron", "2025-09-04 08:38:49", "2025-09-04 08:38:49");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1494", "3111", "action ignored via WP Cron", "2025-09-04 08:39:16", "2025-09-04 08:39:16");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1495", "3189", "action started via WP Cron", "2025-09-04 09:31:42", "2025-09-04 09:31:42");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1496", "3189", "action complete via WP Cron", "2025-09-04 09:31:42", "2025-09-04 09:31:42");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1497", "3201", "action created", "2025-09-04 09:31:42", "2025-09-04 09:31:42");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1498", "3200", "action started via WP Cron", "2025-09-04 09:46:27", "2025-09-04 09:46:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1499", "3202", "action created", "2025-09-04 09:46:27", "2025-09-04 09:46:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1500", "3200", "action complete via WP Cron", "2025-09-04 09:46:27", "2025-09-04 09:46:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1501", "3102", "action ignored via WP Cron", "2025-09-04 10:11:10", "2025-09-04 10:11:10");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1502", "3202", "action started via WP Cron", "2025-09-04 10:54:05", "2025-09-04 10:54:05");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1503", "3203", "action created", "2025-09-04 10:54:05", "2025-09-04 10:54:05");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1504", "3202", "action complete via WP Cron", "2025-09-04 10:54:05", "2025-09-04 10:54:05");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1505", "3203", "action started via WP Cron", "2025-09-04 11:55:57", "2025-09-04 11:55:57");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1506", "3204", "action created", "2025-09-04 11:55:57", "2025-09-04 11:55:57");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1507", "3203", "action complete via WP Cron", "2025-09-04 11:55:57", "2025-09-04 11:55:57");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1508", "3113", "action ignored via WP Cron", "2025-09-04 11:55:57", "2025-09-04 11:55:57");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1509", "3114", "action ignored via WP Cron", "2025-09-04 11:55:57", "2025-09-04 11:55:57");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1510", "3204", "action started via WP Cron", "2025-09-04 13:03:05", "2025-09-04 13:03:05");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1511", "3205", "action created", "2025-09-04 13:03:05", "2025-09-04 13:03:05");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1512", "3204", "action complete via WP Cron", "2025-09-04 13:03:05", "2025-09-04 13:03:05");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1513", "3205", "action started via WP Cron", "2025-09-04 14:07:48", "2025-09-04 14:07:48");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1514", "3206", "action created", "2025-09-04 14:07:48", "2025-09-04 14:07:48");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1515", "3205", "action complete via WP Cron", "2025-09-04 14:07:48", "2025-09-04 14:07:48");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1516", "3206", "action started via WP Cron", "2025-09-04 15:09:21", "2025-09-04 15:09:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1517", "3207", "action created", "2025-09-04 15:09:21", "2025-09-04 15:09:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1518", "3206", "action complete via WP Cron", "2025-09-04 15:09:21", "2025-09-04 15:09:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1519", "3175", "action started via WP Cron", "2025-09-04 15:09:21", "2025-09-04 15:09:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1520", "3175", "action complete via WP Cron", "2025-09-04 15:09:21", "2025-09-04 15:09:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1521", "3208", "action created", "2025-09-04 15:09:21", "2025-09-04 15:09:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1522", "3176", "action started via WP Cron", "2025-09-04 15:09:21", "2025-09-04 15:09:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1523", "3176", "action complete via WP Cron", "2025-09-04 15:09:25", "2025-09-04 15:09:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1524", "3209", "action created", "2025-09-04 15:09:25", "2025-09-04 15:09:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1525", "3177", "action started via WP Cron", "2025-09-04 15:09:25", "2025-09-04 15:09:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1526", "3177", "action complete via WP Cron", "2025-09-04 15:09:26", "2025-09-04 15:09:26");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1527", "3210", "action created", "2025-09-04 15:09:26", "2025-09-04 15:09:26");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1528", "3178", "action started via WP Cron", "2025-09-04 15:09:26", "2025-09-04 15:09:26");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1529", "3178", "action complete via WP Cron", "2025-09-04 15:09:26", "2025-09-04 15:09:26");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1530", "3211", "action created", "2025-09-04 15:09:26", "2025-09-04 15:09:26");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1531", "3180", "action started via WP Cron", "2025-09-04 15:09:26", "2025-09-04 15:09:26");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1532", "3212", "action created", "2025-09-04 15:09:26", "2025-09-04 15:09:26");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1533", "3180", "action complete via WP Cron", "2025-09-04 15:09:26", "2025-09-04 15:09:26");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1534", "3213", "action created", "2025-09-04 15:09:26", "2025-09-04 15:09:26");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1535", "3212", "action started via WP Cron", "2025-09-04 15:10:10", "2025-09-04 15:10:10");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1536", "3212", "action complete via WP Cron", "2025-09-04 15:10:11", "2025-09-04 15:10:11");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1537", "3207", "action started via WP Cron", "2025-09-04 16:18:21", "2025-09-04 16:18:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1538", "3214", "action created", "2025-09-04 16:18:21", "2025-09-04 16:18:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1539", "3207", "action complete via WP Cron", "2025-09-04 16:18:21", "2025-09-04 16:18:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1540", "3196", "action started via WP Cron", "2025-09-04 16:18:21", "2025-09-04 16:18:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1541", "3196", "action complete via WP Cron", "2025-09-04 16:18:21", "2025-09-04 16:18:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1542", "3215", "action created", "2025-09-04 16:18:21", "2025-09-04 16:18:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1543", "3214", "action started via WP Cron", "2025-09-04 17:44:15", "2025-09-04 17:44:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1544", "3216", "action created", "2025-09-04 17:44:15", "2025-09-04 17:44:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1545", "3214", "action complete via WP Cron", "2025-09-04 17:44:15", "2025-09-04 17:44:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1546", "3112", "action ignored via WP Cron", "2025-09-04 17:44:15", "2025-09-04 17:44:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1547", "3183", "action started via WP Cron", "2025-09-04 17:47:27", "2025-09-04 17:47:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1548", "3183", "action complete via WP Cron", "2025-09-04 17:47:27", "2025-09-04 17:47:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1549", "3217", "action created", "2025-09-04 17:47:27", "2025-09-04 17:47:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1550", "3184", "action started via WP Cron", "2025-09-04 17:47:27", "2025-09-04 17:47:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1551", "3184", "action complete via WP Cron", "2025-09-04 17:47:28", "2025-09-04 17:47:28");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1552", "3218", "action created", "2025-09-04 17:47:28", "2025-09-04 17:47:28");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1553", "3216", "action started via WP Cron", "2025-09-04 18:53:51", "2025-09-04 18:53:51");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1554", "3219", "action created", "2025-09-04 18:53:51", "2025-09-04 18:53:51");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1555", "3216", "action complete via WP Cron", "2025-09-04 18:53:51", "2025-09-04 18:53:51");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1556", "3065", "action ignored via WP Cron", "2025-09-04 18:56:45", "2025-09-04 18:56:45");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1557", "3066", "action ignored via WP Cron", "2025-09-04 18:56:45", "2025-09-04 18:56:45");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1558", "3219", "action started via WP Cron", "2025-09-04 19:54:12", "2025-09-04 19:54:12");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1559", "3220", "action created", "2025-09-04 19:54:12", "2025-09-04 19:54:12");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1560", "3219", "action complete via WP Cron", "2025-09-04 19:54:12", "2025-09-04 19:54:12");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1561", "3220", "action started via WP Cron", "2025-09-04 21:11:09", "2025-09-04 21:11:09");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1562", "3221", "action created", "2025-09-04 21:11:10", "2025-09-04 21:11:10");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1563", "3220", "action complete via WP Cron", "2025-09-04 21:11:10", "2025-09-04 21:11:10");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1564", "3201", "action started via WP Cron", "2025-09-04 21:32:21", "2025-09-04 21:32:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1565", "3201", "action complete via WP Cron", "2025-09-04 21:32:21", "2025-09-04 21:32:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1566", "3222", "action created", "2025-09-04 21:32:21", "2025-09-04 21:32:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1567", "3115", "action ignored via WP Cron", "2025-09-04 21:32:21", "2025-09-04 21:32:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1568", "3221", "action started via WP Cron", "2025-09-04 22:16:33", "2025-09-04 22:16:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1569", "3223", "action created", "2025-09-04 22:16:33", "2025-09-04 22:16:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1570", "3221", "action complete via WP Cron", "2025-09-04 22:16:33", "2025-09-04 22:16:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1571", "3223", "action started via WP Cron", "2025-09-04 23:19:25", "2025-09-04 23:19:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1572", "3224", "action created", "2025-09-04 23:19:25", "2025-09-04 23:19:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1573", "3223", "action complete via WP Cron", "2025-09-04 23:19:25", "2025-09-04 23:19:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1574", "3224", "action started via WP Cron", "2025-09-05 00:23:26", "2025-09-05 00:23:26");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1575", "3225", "action created", "2025-09-05 00:23:26", "2025-09-05 00:23:26");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1576", "3224", "action complete via WP Cron", "2025-09-05 00:23:26", "2025-09-05 00:23:26");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1577", "3192", "action started via WP Cron", "2025-09-05 00:47:21", "2025-09-05 00:47:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1578", "3192", "action complete via WP Cron", "2025-09-05 00:47:21", "2025-09-05 00:47:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1579", "3226", "action created", "2025-09-05 00:47:21", "2025-09-05 00:47:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1580", "3225", "action started via WP Cron", "2025-09-05 01:28:10", "2025-09-05 01:28:10");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1581", "3227", "action created", "2025-09-05 01:28:10", "2025-09-05 01:28:10");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1582", "3225", "action complete via WP Cron", "2025-09-05 01:28:10", "2025-09-05 01:28:10");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1583", "3227", "action started via WP Cron", "2025-09-05 02:29:39", "2025-09-05 02:29:39");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1584", "3228", "action created", "2025-09-05 02:29:39", "2025-09-05 02:29:39");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1585", "3227", "action complete via WP Cron", "2025-09-05 02:29:39", "2025-09-05 02:29:39");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1586", "3228", "action started via WP Cron", "2025-09-05 03:44:36", "2025-09-05 03:44:36");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1587", "3229", "action created", "2025-09-05 03:44:36", "2025-09-05 03:44:36");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1588", "3228", "action complete via WP Cron", "2025-09-05 03:44:36", "2025-09-05 03:44:36");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1589", "3118", "action ignored via WP Cron", "2025-09-05 03:47:35", "2025-09-05 03:47:35");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1590", "3215", "action started via WP Cron", "2025-09-05 05:10:15", "2025-09-05 05:10:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1591", "3215", "action complete via WP Cron", "2025-09-05 05:10:15", "2025-09-05 05:10:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1592", "3230", "action created", "2025-09-05 05:10:15", "2025-09-05 05:10:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1593", "3229", "action started via WP Cron", "2025-09-05 05:10:15", "2025-09-05 05:10:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1594", "3231", "action created", "2025-09-05 05:10:15", "2025-09-05 05:10:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1595", "3229", "action complete via WP Cron", "2025-09-05 05:10:15", "2025-09-05 05:10:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1596", "3231", "action started via WP Cron", "2025-09-05 06:23:47", "2025-09-05 06:23:47");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1597", "3232", "action created", "2025-09-05 06:23:47", "2025-09-05 06:23:47");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1598", "3231", "action complete via WP Cron", "2025-09-05 06:23:47", "2025-09-05 06:23:47");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1599", "3232", "action started via WP Cron", "2025-09-05 07:42:07", "2025-09-05 07:42:07");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1600", "3233", "action created", "2025-09-05 07:42:07", "2025-09-05 07:42:07");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1601", "3232", "action complete via WP Cron", "2025-09-05 07:42:07", "2025-09-05 07:42:07");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1602", "3233", "action started via WP Cron", "2025-09-05 08:48:31", "2025-09-05 08:48:31");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1603", "3234", "action created", "2025-09-05 08:48:31", "2025-09-05 08:48:31");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1604", "3233", "action complete via WP Cron", "2025-09-05 08:48:31", "2025-09-05 08:48:31");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1605", "3222", "action started via WP Cron", "2025-09-05 09:33:25", "2025-09-05 09:33:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1606", "3222", "action complete via WP Cron", "2025-09-05 09:33:26", "2025-09-05 09:33:26");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1607", "3235", "action created", "2025-09-05 09:33:26", "2025-09-05 09:33:26");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1608", "3234", "action started via WP Cron", "2025-09-05 09:49:00", "2025-09-05 09:49:00");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1609", "3236", "action created", "2025-09-05 09:49:00", "2025-09-05 09:49:00");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1610", "3234", "action complete via WP Cron", "2025-09-05 09:49:00", "2025-09-05 09:49:00");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1611", "3236", "action started via WP Cron", "2025-09-05 11:04:30", "2025-09-05 11:04:30");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1612", "3237", "action created", "2025-09-05 11:04:31", "2025-09-05 11:04:31");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1613", "3236", "action complete via WP Cron", "2025-09-05 11:04:31", "2025-09-05 11:04:31");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1614", "3237", "action started via WP Cron", "2025-09-05 12:13:03", "2025-09-05 12:13:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1615", "3238", "action created", "2025-09-05 12:13:03", "2025-09-05 12:13:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1616", "3237", "action complete via WP Cron", "2025-09-05 12:13:03", "2025-09-05 12:13:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1617", "3238", "action started via WP Cron", "2025-09-05 13:20:09", "2025-09-05 13:20:09");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1618", "3239", "action created", "2025-09-05 13:20:09", "2025-09-05 13:20:09");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1619", "3238", "action complete via WP Cron", "2025-09-05 13:20:09", "2025-09-05 13:20:09");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1620", "3239", "action started via WP Cron", "2025-09-05 14:21:16", "2025-09-05 14:21:16");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1621", "3240", "action created", "2025-09-05 14:21:16", "2025-09-05 14:21:16");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1622", "3239", "action complete via WP Cron", "2025-09-05 14:21:16", "2025-09-05 14:21:16");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1623", "3208", "action started via WP Cron", "2025-09-05 15:17:32", "2025-09-05 15:17:32");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1624", "3208", "action complete via WP Cron", "2025-09-05 15:17:32", "2025-09-05 15:17:32");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1625", "3241", "action created", "2025-09-05 15:17:32", "2025-09-05 15:17:32");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1626", "3209", "action started via WP Cron", "2025-09-05 15:17:33", "2025-09-05 15:17:33");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1627", "3209", "action complete via WP Cron", "2025-09-05 15:17:35", "2025-09-05 15:17:35");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1628", "3242", "action created", "2025-09-05 15:17:35", "2025-09-05 15:17:35");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1629", "3210", "action started via WP Cron", "2025-09-05 15:17:35", "2025-09-05 15:17:35");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1630", "3210", "action complete via WP Cron", "2025-09-05 15:17:35", "2025-09-05 15:17:35");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1631", "3243", "action created", "2025-09-05 15:17:35", "2025-09-05 15:17:35");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1632", "3211", "action started via WP Cron", "2025-09-05 15:17:35", "2025-09-05 15:17:35");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1633", "3211", "action complete via WP Cron", "2025-09-05 15:17:36", "2025-09-05 15:17:36");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1634", "3244", "action created", "2025-09-05 15:17:36", "2025-09-05 15:17:36");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1635", "3213", "action started via WP Cron", "2025-09-05 15:17:36", "2025-09-05 15:17:36");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1636", "3245", "action created", "2025-09-05 15:17:36", "2025-09-05 15:17:36");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1637", "3213", "action complete via WP Cron", "2025-09-05 15:17:36", "2025-09-05 15:17:36");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1638", "3246", "action created", "2025-09-05 15:17:36", "2025-09-05 15:17:36");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1639", "3245", "action started via WP Cron", "2025-09-05 15:18:47", "2025-09-05 15:18:47");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1640", "3245", "action complete via WP Cron", "2025-09-05 15:18:47", "2025-09-05 15:18:47");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1641", "3119", "action ignored via WP Cron", "2025-09-05 15:19:06", "2025-09-05 15:19:06");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1642", "3240", "action started via WP Cron", "2025-09-05 15:22:04", "2025-09-05 15:22:04");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1643", "3247", "action created", "2025-09-05 15:22:04", "2025-09-05 15:22:04");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1644", "3240", "action complete via WP Cron", "2025-09-05 15:22:04", "2025-09-05 15:22:04");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1645", "3247", "action started via WP Cron", "2025-09-05 16:28:25", "2025-09-05 16:28:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1646", "3248", "action created", "2025-09-05 16:28:25", "2025-09-05 16:28:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1647", "3247", "action complete via WP Cron", "2025-09-05 16:28:25", "2025-09-05 16:28:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1648", "3230", "action started via WP Cron", "2025-09-05 18:03:16", "2025-09-05 18:03:16");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1649", "3230", "action complete via WP Cron", "2025-09-05 18:03:16", "2025-09-05 18:03:16");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1650", "3249", "action created", "2025-09-05 18:03:16", "2025-09-05 18:03:16");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1651", "3248", "action started via WP Cron", "2025-09-05 18:03:16", "2025-09-05 18:03:16");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1652", "3250", "action created", "2025-09-05 18:03:16", "2025-09-05 18:03:16");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1653", "3248", "action complete via WP Cron", "2025-09-05 18:03:16", "2025-09-05 18:03:16");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1654", "3217", "action started via WP Cron", "2025-09-05 18:03:16", "2025-09-05 18:03:16");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1655", "3217", "action complete via WP Cron", "2025-09-05 18:03:16", "2025-09-05 18:03:16");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1656", "3251", "action created", "2025-09-05 18:03:16", "2025-09-05 18:03:16");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1657", "3218", "action started via WP Cron", "2025-09-05 18:03:16", "2025-09-05 18:03:16");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1658", "3218", "action complete via WP Cron", "2025-09-05 18:03:17", "2025-09-05 18:03:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1659", "3252", "action created", "2025-09-05 18:03:17", "2025-09-05 18:03:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1660", "3250", "action started via WP Cron", "2025-09-05 19:07:34", "2025-09-05 19:07:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1661", "3253", "action created", "2025-09-05 19:07:34", "2025-09-05 19:07:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1662", "3250", "action complete via WP Cron", "2025-09-05 19:07:34", "2025-09-05 19:07:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1663", "3253", "action started via WP Cron", "2025-09-05 20:12:31", "2025-09-05 20:12:31");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1664", "3254", "action created", "2025-09-05 20:12:32", "2025-09-05 20:12:32");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1665", "3253", "action complete via WP Cron", "2025-09-05 20:12:32", "2025-09-05 20:12:32");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1666", "3254", "action started via WP Cron", "2025-09-05 21:19:15", "2025-09-05 21:19:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1667", "3255", "action created", "2025-09-05 21:19:15", "2025-09-05 21:19:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1668", "3254", "action complete via WP Cron", "2025-09-05 21:19:15", "2025-09-05 21:19:15");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1669", "3235", "action started via WP Cron", "2025-09-05 23:21:37", "2025-09-05 23:21:37");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1670", "3235", "action complete via WP Cron", "2025-09-05 23:21:37", "2025-09-05 23:21:37");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1671", "3256", "action created", "2025-09-05 23:21:37", "2025-09-05 23:21:37");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1672", "3255", "action started via WP Cron", "2025-09-05 23:21:37", "2025-09-05 23:21:37");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1673", "3257", "action created", "2025-09-05 23:21:37", "2025-09-05 23:21:37");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1674", "3255", "action complete via WP Cron", "2025-09-05 23:21:37", "2025-09-05 23:21:37");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1675", "3257", "action started via WP Cron", "2025-09-06 00:22:11", "2025-09-06 00:22:11");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1676", "3258", "action created", "2025-09-06 00:22:11", "2025-09-06 00:22:11");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1677", "3257", "action complete via WP Cron", "2025-09-06 00:22:11", "2025-09-06 00:22:11");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1678", "3226", "action started via WP Cron", "2025-09-06 01:44:16", "2025-09-06 01:44:16");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1679", "3226", "action complete via WP Cron", "2025-09-06 01:44:16", "2025-09-06 01:44:16");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1680", "3259", "action created", "2025-09-06 01:44:16", "2025-09-06 01:44:16");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1681", "3258", "action started via WP Cron", "2025-09-06 01:44:16", "2025-09-06 01:44:16");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1682", "3260", "action created", "2025-09-06 01:44:16", "2025-09-06 01:44:16");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1683", "3258", "action complete via WP Cron", "2025-09-06 01:44:17", "2025-09-06 01:44:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1684", "3260", "action started via WP Cron", "2025-09-06 03:01:09", "2025-09-06 03:01:09");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1685", "3261", "action created", "2025-09-06 03:01:10", "2025-09-06 03:01:10");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1686", "3260", "action complete via WP Cron", "2025-09-06 03:01:10", "2025-09-06 03:01:10");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1687", "3261", "action started via WP Cron", "2025-09-06 04:02:05", "2025-09-06 04:02:05");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1688", "3262", "action created", "2025-09-06 04:02:05", "2025-09-06 04:02:05");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1689", "3261", "action complete via WP Cron", "2025-09-06 04:02:05", "2025-09-06 04:02:05");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1690", "3120", "action ignored via WP Cron", "2025-09-06 04:02:05", "2025-09-06 04:02:05");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1691", "3097", "action ignored via WP Cron", "2025-09-06 04:02:05", "2025-09-06 04:02:05");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1692", "3262", "action started via WP Cron", "2025-09-06 05:21:22", "2025-09-06 05:21:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1693", "3263", "action created", "2025-09-06 05:21:22", "2025-09-06 05:21:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1694", "3262", "action complete via WP Cron", "2025-09-06 05:21:22", "2025-09-06 05:21:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1695", "3249", "action started via WP Cron", "2025-09-06 07:33:24", "2025-09-06 07:33:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1696", "3249", "action complete via WP Cron", "2025-09-06 07:33:24", "2025-09-06 07:33:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1697", "3264", "action created", "2025-09-06 07:33:24", "2025-09-06 07:33:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1698", "3263", "action started via WP Cron", "2025-09-06 07:33:24", "2025-09-06 07:33:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1699", "3265", "action created", "2025-09-06 07:33:24", "2025-09-06 07:33:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1700", "3263", "action complete via WP Cron", "2025-09-06 07:33:24", "2025-09-06 07:33:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1701", "3265", "action started via WP Cron", "2025-09-06 08:40:31", "2025-09-06 08:40:31");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1702", "3266", "action created", "2025-09-06 08:40:31", "2025-09-06 08:40:31");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1703", "3265", "action complete via WP Cron", "2025-09-06 08:40:31", "2025-09-06 08:40:31");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1704", "3266", "action started via WP Cron", "2025-09-06 09:53:41", "2025-09-06 09:53:41");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1705", "3267", "action created", "2025-09-06 09:53:41", "2025-09-06 09:53:41");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1706", "3266", "action complete via WP Cron", "2025-09-06 09:53:41", "2025-09-06 09:53:41");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1707", "3267", "action started via WP Cron", "2025-09-06 10:58:12", "2025-09-06 10:58:12");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1708", "3268", "action created", "2025-09-06 10:58:12", "2025-09-06 10:58:12");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1709", "3267", "action complete via WP Cron", "2025-09-06 10:58:12", "2025-09-06 10:58:12");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1710", "3256", "action started via WP Cron", "2025-09-06 11:28:04", "2025-09-06 11:28:04");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1711", "3256", "action complete via WP Cron", "2025-09-06 11:28:04", "2025-09-06 11:28:04");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1712", "3269", "action created", "2025-09-06 11:28:04", "2025-09-06 11:28:04");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1713", "3268", "action started via WP Cron", "2025-09-06 12:10:02", "2025-09-06 12:10:02");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1714", "3270", "action created", "2025-09-06 12:10:02", "2025-09-06 12:10:02");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1715", "3268", "action complete via WP Cron", "2025-09-06 12:10:02", "2025-09-06 12:10:02");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1716", "3121", "action ignored via WP Cron", "2025-09-06 12:10:02", "2025-09-06 12:10:02");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1717", "3270", "action started via WP Cron", "2025-09-06 13:39:39", "2025-09-06 13:39:39");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1718", "3271", "action created", "2025-09-06 13:39:39", "2025-09-06 13:39:39");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1719", "3270", "action complete via WP Cron", "2025-09-06 13:39:39", "2025-09-06 13:39:39");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1720", "3271", "action started via WP Cron", "2025-09-06 14:39:48", "2025-09-06 14:39:48");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1721", "3272", "action created", "2025-09-06 14:39:48", "2025-09-06 14:39:48");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1722", "3271", "action complete via WP Cron", "2025-09-06 14:39:48", "2025-09-06 14:39:48");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1723", "3241", "action started via WP Cron", "2025-09-06 15:33:20", "2025-09-06 15:33:20");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1724", "3241", "action complete via WP Cron", "2025-09-06 15:33:20", "2025-09-06 15:33:20");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1725", "3273", "action created", "2025-09-06 15:33:20", "2025-09-06 15:33:20");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1726", "3242", "action started via WP Cron", "2025-09-06 15:33:20", "2025-09-06 15:33:20");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1727", "3242", "action complete via WP Cron", "2025-09-06 15:33:21", "2025-09-06 15:33:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1728", "3274", "action created", "2025-09-06 15:33:21", "2025-09-06 15:33:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1729", "3243", "action started via WP Cron", "2025-09-06 15:33:21", "2025-09-06 15:33:21");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1730", "3243", "action complete via WP Cron", "2025-09-06 15:33:22", "2025-09-06 15:33:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1731", "3275", "action created", "2025-09-06 15:33:22", "2025-09-06 15:33:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1732", "3244", "action started via WP Cron", "2025-09-06 15:33:22", "2025-09-06 15:33:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1733", "3244", "action complete via WP Cron", "2025-09-06 15:33:22", "2025-09-06 15:33:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1734", "3276", "action created", "2025-09-06 15:33:22", "2025-09-06 15:33:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1735", "3246", "action started via WP Cron", "2025-09-06 15:33:22", "2025-09-06 15:33:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1736", "3277", "action created", "2025-09-06 15:33:22", "2025-09-06 15:33:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1737", "3246", "action complete via WP Cron", "2025-09-06 15:33:22", "2025-09-06 15:33:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1738", "3278", "action created", "2025-09-06 15:33:22", "2025-09-06 15:33:22");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1739", "3277", "action started via WP Cron", "2025-09-06 15:45:53", "2025-09-06 15:45:53");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1740", "3277", "action complete via WP Cron", "2025-09-06 15:45:53", "2025-09-06 15:45:53");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1741", "3272", "action started via WP Cron", "2025-09-06 15:45:53", "2025-09-06 15:45:53");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1742", "3279", "action created", "2025-09-06 15:45:53", "2025-09-06 15:45:53");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1743", "3272", "action complete via WP Cron", "2025-09-06 15:45:53", "2025-09-06 15:45:53");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1744", "3279", "action started via WP Cron", "2025-09-06 17:00:38", "2025-09-06 17:00:38");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1745", "3280", "action created", "2025-09-06 17:00:38", "2025-09-06 17:00:38");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1746", "3279", "action complete via WP Cron", "2025-09-06 17:00:38", "2025-09-06 17:00:38");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1747", "3280", "action started via WP Cron", "2025-09-06 18:04:03", "2025-09-06 18:04:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1748", "3281", "action created", "2025-09-06 18:04:03", "2025-09-06 18:04:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1749", "3280", "action complete via WP Cron", "2025-09-06 18:04:03", "2025-09-06 18:04:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1750", "3251", "action started via WP Cron", "2025-09-06 18:04:03", "2025-09-06 18:04:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1751", "3251", "action complete via WP Cron", "2025-09-06 18:04:03", "2025-09-06 18:04:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1752", "3282", "action created", "2025-09-06 18:04:03", "2025-09-06 18:04:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1753", "3252", "action started via WP Cron", "2025-09-06 18:04:03", "2025-09-06 18:04:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1754", "3252", "action complete via WP Cron", "2025-09-06 18:04:03", "2025-09-06 18:04:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1755", "3283", "action created", "2025-09-06 18:04:03", "2025-09-06 18:04:03");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1756", "3281", "action started via WP Cron", "2025-09-06 19:32:35", "2025-09-06 19:32:35");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1757", "3284", "action created", "2025-09-06 19:32:35", "2025-09-06 19:32:35");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1758", "3281", "action complete via WP Cron", "2025-09-06 19:32:35", "2025-09-06 19:32:35");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1759", "3264", "action started via WP Cron", "2025-09-06 19:48:45", "2025-09-06 19:48:45");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1760", "3264", "action complete via WP Cron", "2025-09-06 19:48:45", "2025-09-06 19:48:45");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1761", "3285", "action created", "2025-09-06 19:48:45", "2025-09-06 19:48:45");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1762", "3284", "action started via WP Cron", "2025-09-06 21:03:08", "2025-09-06 21:03:08");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1763", "3286", "action created", "2025-09-06 21:03:08", "2025-09-06 21:03:08");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1764", "3284", "action complete via WP Cron", "2025-09-06 21:03:08", "2025-09-06 21:03:08");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1765", "3286", "action started via WP Cron", "2025-09-06 22:07:41", "2025-09-06 22:07:41");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1766", "3287", "action created", "2025-09-06 22:07:41", "2025-09-06 22:07:41");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1767", "3286", "action complete via WP Cron", "2025-09-06 22:07:41", "2025-09-06 22:07:41");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1768", "3287", "action started via WP Cron", "2025-09-07 00:41:27", "2025-09-07 00:41:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1769", "3288", "action created", "2025-09-07 00:41:27", "2025-09-07 00:41:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1770", "3287", "action complete via WP Cron", "2025-09-07 00:41:27", "2025-09-07 00:41:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1771", "3269", "action started via WP Cron", "2025-09-07 00:41:27", "2025-09-07 00:41:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1772", "3269", "action complete via WP Cron", "2025-09-07 00:41:28", "2025-09-07 00:41:28");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1773", "3289", "action created", "2025-09-07 00:41:28", "2025-09-07 00:41:28");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1774", "3288", "action started via WP Cron", "2025-09-07 01:41:29", "2025-09-07 01:41:29");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1775", "3290", "action created", "2025-09-07 01:41:29", "2025-09-07 01:41:29");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1776", "3288", "action complete via WP Cron", "2025-09-07 01:41:29", "2025-09-07 01:41:29");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1777", "3259", "action started via WP Cron", "2025-09-07 02:04:13", "2025-09-07 02:04:13");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1778", "3259", "action complete via WP Cron", "2025-09-07 02:04:13", "2025-09-07 02:04:13");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1779", "3291", "action created", "2025-09-07 02:04:13", "2025-09-07 02:04:13");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1780", "3290", "action started via WP Cron", "2025-09-07 03:22:27", "2025-09-07 03:22:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1781", "3292", "action created", "2025-09-07 03:22:27", "2025-09-07 03:22:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1782", "3290", "action complete via WP Cron", "2025-09-07 03:22:27", "2025-09-07 03:22:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1783", "3292", "action started via WP Cron", "2025-09-07 04:41:34", "2025-09-07 04:41:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1784", "3293", "action created", "2025-09-07 04:41:34", "2025-09-07 04:41:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1785", "3292", "action complete via WP Cron", "2025-09-07 04:41:34", "2025-09-07 04:41:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1786", "3293", "action started via WP Cron", "2025-09-07 05:42:59", "2025-09-07 05:42:59");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1787", "3294", "action created", "2025-09-07 05:42:59", "2025-09-07 05:42:59");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1788", "3293", "action complete via WP Cron", "2025-09-07 05:42:59", "2025-09-07 05:42:59");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1789", "3294", "action started via WP Cron", "2025-09-07 06:49:34", "2025-09-07 06:49:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1790", "3295", "action created", "2025-09-07 06:49:34", "2025-09-07 06:49:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1791", "3294", "action complete via WP Cron", "2025-09-07 06:49:34", "2025-09-07 06:49:34");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1792", "3285", "action started via WP Cron", "2025-09-07 08:00:25", "2025-09-07 08:00:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1793", "3285", "action complete via WP Cron", "2025-09-07 08:00:25", "2025-09-07 08:00:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1794", "3296", "action created", "2025-09-07 08:00:25", "2025-09-07 08:00:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1795", "3295", "action started via WP Cron", "2025-09-07 08:00:25", "2025-09-07 08:00:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1796", "3297", "action created", "2025-09-07 08:00:25", "2025-09-07 08:00:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1797", "3295", "action complete via WP Cron", "2025-09-07 08:00:25", "2025-09-07 08:00:25");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1798", "3297", "action started via WP Cron", "2025-09-07 09:57:41", "2025-09-07 09:57:41");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1799", "3298", "action created", "2025-09-07 09:57:41", "2025-09-07 09:57:41");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1800", "3297", "action complete via WP Cron", "2025-09-07 09:57:41", "2025-09-07 09:57:41");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1801", "3298", "action started via WP Cron", "2025-09-07 11:15:17", "2025-09-07 11:15:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1802", "3299", "action created", "2025-09-07 11:15:17", "2025-09-07 11:15:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1803", "3298", "action complete via WP Cron", "2025-09-07 11:15:17", "2025-09-07 11:15:17");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1804", "3299", "action started via WP Cron", "2025-09-07 12:25:06", "2025-09-07 12:25:06");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1805", "3300", "action created", "2025-09-07 12:25:06", "2025-09-07 12:25:06");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1806", "3299", "action complete via WP Cron", "2025-09-07 12:25:06", "2025-09-07 12:25:06");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1807", "3289", "action started via WP Cron", "2025-09-07 12:47:55", "2025-09-07 12:47:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1808", "3289", "action complete via WP Cron", "2025-09-07 12:47:55", "2025-09-07 12:47:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1809", "3301", "action created", "2025-09-07 12:47:55", "2025-09-07 12:47:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1810", "3300", "action started via WP Cron", "2025-09-07 13:46:49", "2025-09-07 13:46:49");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1811", "3302", "action created", "2025-09-07 13:46:49", "2025-09-07 13:46:49");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1812", "3300", "action complete via WP Cron", "2025-09-07 13:46:49", "2025-09-07 13:46:49");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1813", "3302", "action started via WP Cron", "2025-09-07 14:53:41", "2025-09-07 14:53:41");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1814", "3303", "action created", "2025-09-07 14:53:41", "2025-09-07 14:53:41");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1815", "3302", "action complete via WP Cron", "2025-09-07 14:53:41", "2025-09-07 14:53:41");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1816", "3273", "action started via WP Cron", "2025-09-07 15:36:08", "2025-09-07 15:36:08");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1817", "3273", "action complete via WP Cron", "2025-09-07 15:36:08", "2025-09-07 15:36:08");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1818", "3304", "action created", "2025-09-07 15:36:08", "2025-09-07 15:36:08");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1819", "3274", "action started via WP Cron", "2025-09-07 15:36:08", "2025-09-07 15:36:08");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1820", "3274", "action complete via WP Cron", "2025-09-07 15:36:10", "2025-09-07 15:36:10");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1821", "3305", "action created", "2025-09-07 15:36:10", "2025-09-07 15:36:10");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1822", "3275", "action started via WP Cron", "2025-09-07 15:36:10", "2025-09-07 15:36:10");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1823", "3275", "action complete via WP Cron", "2025-09-07 15:36:11", "2025-09-07 15:36:11");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1824", "3306", "action created", "2025-09-07 15:36:11", "2025-09-07 15:36:11");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1825", "3276", "action started via WP Cron", "2025-09-07 15:36:11", "2025-09-07 15:36:11");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1826", "3276", "action complete via WP Cron", "2025-09-07 15:36:11", "2025-09-07 15:36:11");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1827", "3307", "action created", "2025-09-07 15:36:11", "2025-09-07 15:36:11");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1828", "3278", "action started via WP Cron", "2025-09-07 15:36:11", "2025-09-07 15:36:11");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1829", "3308", "action created", "2025-09-07 15:36:11", "2025-09-07 15:36:11");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1830", "3278", "action complete via WP Cron", "2025-09-07 15:36:11", "2025-09-07 15:36:11");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1831", "3309", "action created", "2025-09-07 15:36:11", "2025-09-07 15:36:11");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1832", "3308", "action started via WP Cron", "2025-09-07 15:39:16", "2025-09-07 15:39:16");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1833", "3308", "action complete via WP Cron", "2025-09-07 15:39:16", "2025-09-07 15:39:16");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1834", "3303", "action started via WP Cron", "2025-09-07 15:57:24", "2025-09-07 15:57:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1835", "3310", "action created", "2025-09-07 15:57:24", "2025-09-07 15:57:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1836", "3303", "action complete via WP Cron", "2025-09-07 15:57:24", "2025-09-07 15:57:24");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1837", "3310", "action started via WP Cron", "2025-09-07 17:20:05", "2025-09-07 17:20:05");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1838", "3311", "action created", "2025-09-07 17:20:05", "2025-09-07 17:20:05");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1839", "3310", "action complete via WP Cron", "2025-09-07 17:20:05", "2025-09-07 17:20:05");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1840", "3282", "action started via WP Cron", "2025-09-07 18:17:26", "2025-09-07 18:17:26");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1841", "3282", "action complete via WP Cron", "2025-09-07 18:17:26", "2025-09-07 18:17:26");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1842", "3312", "action created", "2025-09-07 18:17:26", "2025-09-07 18:17:26");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1843", "3283", "action started via WP Cron", "2025-09-07 18:17:26", "2025-09-07 18:17:26");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1844", "3283", "action complete via WP Cron", "2025-09-07 18:17:27", "2025-09-07 18:17:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1845", "3313", "action created", "2025-09-07 18:17:27", "2025-09-07 18:17:27");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1846", "3311", "action started via WP Cron", "2025-09-07 18:34:55", "2025-09-07 18:34:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1847", "3314", "action created", "2025-09-07 18:34:55", "2025-09-07 18:34:55");
INSERT INTO `wpge_actionscheduler_logs` VALUES("1848", "3311", "action complete via WP Cron", "2025-09-07 18:34:55", "2025-09-07 18:34:55");

/* INSERT TABLE DATA: wpge_commentmeta */
INSERT INTO `wpge_commentmeta` VALUES("155", "47", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("154", "47", "rating", "3");
INSERT INTO `wpge_commentmeta` VALUES("153", "46", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("152", "46", "rating", "1");
INSERT INTO `wpge_commentmeta` VALUES("151", "45", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("150", "45", "rating", "1");
INSERT INTO `wpge_commentmeta` VALUES("149", "44", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("148", "44", "rating", "4");
INSERT INTO `wpge_commentmeta` VALUES("147", "43", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("146", "43", "rating", "2");
INSERT INTO `wpge_commentmeta` VALUES("145", "42", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("144", "42", "rating", "4");
INSERT INTO `wpge_commentmeta` VALUES("156", "48", "akismet_error", "1370606225");
INSERT INTO `wpge_commentmeta` VALUES("157", "48", "akismet_history", "a:4:{s:4:\"time\";d:1370606225.6765859127044677734375;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}");
INSERT INTO `wpge_commentmeta` VALUES("158", "48", "akismet_as_submitted", "a:67:{s:15:\"comment_post_ID\";i:15;s:14:\"comment_author\";s:12:\"Cobus Bester\";s:20:\"comment_author_email\";s:18:\"bester.c@gmail.com\";s:18:\"comment_author_url\";N;s:15:\"comment_content\";s:49:\"Simple and effective design. One of my favorites.\";s:12:\"comment_type\";s:0:\"\";s:14:\"comment_parent\";i:0;s:7:\"user_ID\";i:0;s:7:\"user_ip\";s:13:\"196.215.9.147\";s:10:\"user_agent\";s:119:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_3) AppleWebKit/537.31 (KHTML, like Gecko) Chrome/26.0.1410.65 Safari/537.31\";s:8:\"referrer\";s:56:\"http://demo2.woothemes.com/woocommerce/product/woo-logo/\";s:4:\"blog\";s:38:\"http://demo2.woothemes.com/woocommerce\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:56:\"http://demo2.woothemes.com/woocommerce/product/woo-logo/\";s:21:\"akismet_comment_nonce\";s:6:\"passed\";s:11:\"POST_author\";s:12:\"Cobus Bester\";s:10:\"POST_email\";s:18:\"bester.c@gmail.com\";s:11:\"POST_rating\";s:1:\"4\";s:12:\"POST_comment\";s:49:\"Simple and effective design. One of my favorites.\";s:7:\"POST__n\";s:10:\"a80bd2f042\";s:21:\"POST__wp_http_referer\";s:30:\"/woocommerce/product/woo-logo/\";s:11:\"POST_submit\";s:13:\"Submit Review\";s:20:\"POST_comment_post_ID\";s:2:\"15\";s:19:\"POST_comment_parent\";s:1:\"0\";s:26:\"POST_akismet_comment_nonce\";s:10:\"bbd941e9bf\";s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:33:\"/woocommerce/wp-comments-post.php\";s:15:\"REDIRECT_IS_WPE\";s:1:\"1\";s:27:\"REDIRECT_WPE_CAN_WRITE_DISK\";s:1:\"0\";s:15:\"REDIRECT_STATUS\";s:3:\"200\";s:6:\"IS_WPE\";s:1:\"1\";s:18:\"WPE_CAN_WRITE_DISK\";s:1:\"0\";s:9:\"HTTP_HOST\";s:19:\"demo2.woothemes.com\";s:13:\"HTTP_X_LB_KEY\";s:8:\"woodemo2\";s:13:\"HTTP_X_IS_BOT\";s:1:\"0\";s:15:\"HTTP_USER_AGENT\";s:119:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_3) AppleWebKit/537.31 (KHTML, like Gecko) Chrome/26.0.1410.65 Safari/537.31\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"CONTENT_LENGTH\";s:3:\"273\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:11:\"HTTP_ORIGIN\";s:26:\"http://demo2.woothemes.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:12:\"HTTP_REFERER\";s:56:\"http://demo2.woothemes.com/woocommerce/product/woo-logo/\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip,deflate,sdch\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.8\";s:19:\"HTTP_ACCEPT_CHARSET\";s:30:\"ISO-8859-1,utf-8;q=0.7,*;q=0.3\";s:11:\"HTTP_COOKIE\";s:0:\"\";s:4:\"PATH\";s:28:\"/usr/local/bin:/usr/bin:/bin\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:11:\"SERVER_NAME\";s:19:\"demo2.woothemes.com\";s:11:\"SERVER_ADDR\";s:9:\"127.0.0.1\";s:11:\"SERVER_PORT\";s:2:\"80\";s:11:\"REMOTE_ADDR\";s:13:\"196.215.9.147\";s:13:\"DOCUMENT_ROOT\";s:26:\"/nas/wp/www/sites/woodemo2\";s:12:\"SERVER_ADMIN\";s:18:\"[no address given]\";s:15:\"SCRIPT_FILENAME\";s:47:\"/nas/wp/www/sites/woodemo2/wp-comments-post.php\";s:11:\"REMOTE_PORT\";s:5:\"57596\";s:12:\"REDIRECT_URL\";s:33:\"/woocommerce/wp-comments-post.php\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:12:\"QUERY_STRING\";s:0:\"\";s:11:\"SCRIPT_NAME\";s:21:\"/wp-comments-post.php\";s:8:\"PHP_SELF\";s:21:\"/wp-comments-post.php\";s:12:\"REQUEST_TIME\";s:10:\"1370606225\";s:25:\"comment_post_modified_gmt\";s:19:\"2013-06-07 11:15:25\";}");
INSERT INTO `wpge_commentmeta` VALUES("159", "48", "rating", "4");
INSERT INTO `wpge_commentmeta` VALUES("160", "48", "akismet_history", "a:4:{s:4:\"time\";d:1370607940.89634990692138671875;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}");
INSERT INTO `wpge_commentmeta` VALUES("161", "49", "akismet_error", "1370610085");
INSERT INTO `wpge_commentmeta` VALUES("162", "49", "akismet_history", "a:4:{s:4:\"time\";d:1370610085.324596881866455078125;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}");
INSERT INTO `wpge_commentmeta` VALUES("163", "49", "akismet_as_submitted", "a:64:{s:15:\"comment_post_ID\";i:37;s:14:\"comment_author\";s:6:\"Stuart\";s:20:\"comment_author_email\";s:20:\"stuart@woothemes.com\";s:18:\"comment_author_url\";N;s:15:\"comment_content\";s:65:\"This will go great with my Hoodie that I ordered a few weeks ago.\";s:12:\"comment_type\";s:0:\"\";s:14:\"comment_parent\";i:0;s:7:\"user_ID\";i:0;s:7:\"user_ip\";s:13:\"82.32.109.140\";s:10:\"user_agent\";s:72:\"Mozilla/5.0 (Windows NT 6.1; WOW64; rv:21.0) Gecko/20100101 Firefox/21.0\";s:8:\"referrer\";s:59:\"http://demo2.woothemes.com/woocommerce/product/happy-ninja/\";s:4:\"blog\";s:38:\"http://demo2.woothemes.com/woocommerce\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:59:\"http://demo2.woothemes.com/woocommerce/product/happy-ninja/\";s:21:\"akismet_comment_nonce\";s:6:\"passed\";s:11:\"POST_author\";s:6:\"Stuart\";s:10:\"POST_email\";s:20:\"stuart@woothemes.com\";s:11:\"POST_rating\";s:1:\"5\";s:12:\"POST_comment\";s:65:\"This will go great with my Hoodie that I ordered a few weeks ago.\";s:7:\"POST__n\";s:10:\"2145d644a3\";s:21:\"POST__wp_http_referer\";s:33:\"/woocommerce/product/happy-ninja/\";s:11:\"POST_submit\";s:13:\"Submit Review\";s:20:\"POST_comment_post_ID\";s:2:\"37\";s:19:\"POST_comment_parent\";s:1:\"0\";s:26:\"POST_akismet_comment_nonce\";s:10:\"7da2a7b2b2\";s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:33:\"/woocommerce/wp-comments-post.php\";s:15:\"REDIRECT_IS_WPE\";s:1:\"1\";s:27:\"REDIRECT_WPE_CAN_WRITE_DISK\";s:1:\"0\";s:15:\"REDIRECT_STATUS\";s:3:\"200\";s:6:\"IS_WPE\";s:1:\"1\";s:18:\"WPE_CAN_WRITE_DISK\";s:1:\"0\";s:9:\"HTTP_HOST\";s:19:\"demo2.woothemes.com\";s:13:\"HTTP_X_LB_KEY\";s:8:\"woodemo2\";s:13:\"HTTP_X_IS_BOT\";s:1:\"0\";s:15:\"HTTP_USER_AGENT\";s:72:\"Mozilla/5.0 (Windows NT 6.1; WOW64; rv:21.0) Gecko/20100101 Firefox/21.0\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.5\";s:20:\"HTTP_ACCEPT_ENCODING\";s:13:\"gzip, deflate\";s:12:\"HTTP_REFERER\";s:59:\"http://demo2.woothemes.com/woocommerce/product/happy-ninja/\";s:11:\"HTTP_COOKIE\";s:0:\"\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"288\";s:4:\"PATH\";s:28:\"/usr/local/bin:/usr/bin:/bin\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:11:\"SERVER_NAME\";s:19:\"demo2.woothemes.com\";s:11:\"SERVER_ADDR\";s:9:\"127.0.0.1\";s:11:\"SERVER_PORT\";s:2:\"80\";s:11:\"REMOTE_ADDR\";s:13:\"82.32.109.140\";s:13:\"DOCUMENT_ROOT\";s:26:\"/nas/wp/www/sites/woodemo2\";s:12:\"SERVER_ADMIN\";s:18:\"[no address given]\";s:15:\"SCRIPT_FILENAME\";s:47:\"/nas/wp/www/sites/woodemo2/wp-comments-post.php\";s:11:\"REMOTE_PORT\";s:5:\"40272\";s:12:\"REDIRECT_URL\";s:33:\"/woocommerce/wp-comments-post.php\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:12:\"QUERY_STRING\";s:0:\"\";s:11:\"SCRIPT_NAME\";s:21:\"/wp-comments-post.php\";s:8:\"PHP_SELF\";s:21:\"/wp-comments-post.php\";s:12:\"REQUEST_TIME\";s:10:\"1370610085\";s:25:\"comment_post_modified_gmt\";s:19:\"2013-06-07 11:14:15\";}");
INSERT INTO `wpge_commentmeta` VALUES("164", "49", "rating", "5");
INSERT INTO `wpge_commentmeta` VALUES("165", "49", "akismet_history", "a:4:{s:4:\"time\";d:1370611525.10484409332275390625;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}");
INSERT INTO `wpge_commentmeta` VALUES("166", "50", "akismet_error", "1370620193");
INSERT INTO `wpge_commentmeta` VALUES("167", "50", "akismet_history", "a:4:{s:4:\"time\";d:1370620193.9864521026611328125;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}");
INSERT INTO `wpge_commentmeta` VALUES("168", "50", "akismet_as_submitted", "a:66:{s:15:\"comment_post_ID\";i:37;s:14:\"comment_author\";s:5:\"Maria\";s:20:\"comment_author_email\";s:19:\"maria@woothemes.com\";s:18:\"comment_author_url\";N;s:15:\"comment_content\";s:56:\"Love this shirt! The ninja near and dear to my heart. <3\";s:12:\"comment_type\";s:0:\"\";s:14:\"comment_parent\";i:0;s:7:\"user_ID\";i:0;s:7:\"user_ip\";s:13:\"24.225.103.32\";s:10:\"user_agent\";s:120:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/27.0.1453.110 Safari/537.36\";s:8:\"referrer\";s:59:\"http://demo2.woothemes.com/woocommerce/product/happy-ninja/\";s:4:\"blog\";s:38:\"http://demo2.woothemes.com/woocommerce\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:59:\"http://demo2.woothemes.com/woocommerce/product/happy-ninja/\";s:21:\"akismet_comment_nonce\";s:6:\"passed\";s:11:\"POST_author\";s:5:\"Maria\";s:10:\"POST_email\";s:19:\"maria@woothemes.com\";s:11:\"POST_rating\";s:1:\"5\";s:12:\"POST_comment\";s:56:\"Love this shirt! The ninja near and dear to my heart. <3\";s:7:\"POST__n\";s:10:\"2145d644a3\";s:21:\"POST__wp_http_referer\";s:33:\"/woocommerce/product/happy-ninja/\";s:11:\"POST_submit\";s:13:\"Submit Review\";s:20:\"POST_comment_post_ID\";s:2:\"37\";s:19:\"POST_comment_parent\";s:1:\"0\";s:26:\"POST_akismet_comment_nonce\";s:10:\"7da2a7b2b2\";s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:33:\"/woocommerce/wp-comments-post.php\";s:15:\"REDIRECT_IS_WPE\";s:1:\"1\";s:27:\"REDIRECT_WPE_CAN_WRITE_DISK\";s:1:\"0\";s:15:\"REDIRECT_STATUS\";s:3:\"200\";s:6:\"IS_WPE\";s:1:\"1\";s:18:\"WPE_CAN_WRITE_DISK\";s:1:\"0\";s:9:\"HTTP_HOST\";s:19:\"demo2.woothemes.com\";s:13:\"HTTP_X_LB_KEY\";s:8:\"woodemo2\";s:13:\"HTTP_X_IS_BOT\";s:1:\"0\";s:15:\"HTTP_USER_AGENT\";s:120:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/27.0.1453.110 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"CONTENT_LENGTH\";s:3:\"281\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:11:\"HTTP_ORIGIN\";s:26:\"http://demo2.woothemes.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:12:\"HTTP_REFERER\";s:59:\"http://demo2.woothemes.com/woocommerce/product/happy-ninja/\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip,deflate,sdch\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.8\";s:11:\"HTTP_COOKIE\";s:0:\"\";s:4:\"PATH\";s:28:\"/usr/local/bin:/usr/bin:/bin\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:11:\"SERVER_NAME\";s:19:\"demo2.woothemes.com\";s:11:\"SERVER_ADDR\";s:9:\"127.0.0.1\";s:11:\"SERVER_PORT\";s:2:\"80\";s:11:\"REMOTE_ADDR\";s:13:\"24.225.103.32\";s:13:\"DOCUMENT_ROOT\";s:26:\"/nas/wp/www/sites/woodemo2\";s:12:\"SERVER_ADMIN\";s:18:\"[no address given]\";s:15:\"SCRIPT_FILENAME\";s:47:\"/nas/wp/www/sites/woodemo2/wp-comments-post.php\";s:11:\"REMOTE_PORT\";s:5:\"24107\";s:12:\"REDIRECT_URL\";s:33:\"/woocommerce/wp-comments-post.php\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:12:\"QUERY_STRING\";s:0:\"\";s:11:\"SCRIPT_NAME\";s:21:\"/wp-comments-post.php\";s:8:\"PHP_SELF\";s:21:\"/wp-comments-post.php\";s:12:\"REQUEST_TIME\";s:10:\"1370620193\";s:25:\"comment_post_modified_gmt\";s:19:\"2013-06-07 11:14:15\";}");
INSERT INTO `wpge_commentmeta` VALUES("169", "50", "rating", "5");
INSERT INTO `wpge_commentmeta` VALUES("170", "50", "akismet_history", "a:4:{s:4:\"time\";d:1370620633.9563140869140625;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}");
INSERT INTO `wpge_commentmeta` VALUES("171", "51", "akismet_error", "1370610209");
INSERT INTO `wpge_commentmeta` VALUES("172", "51", "akismet_history", "a:4:{s:4:\"time\";d:1370610209.978949069976806640625;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}");
INSERT INTO `wpge_commentmeta` VALUES("173", "51", "akismet_as_submitted", "a:64:{s:15:\"comment_post_ID\";i:40;s:14:\"comment_author\";s:6:\"Stuart\";s:20:\"comment_author_email\";s:20:\"stuart@woothemes.com\";s:18:\"comment_author_url\";N;s:15:\"comment_content\";s:108:\"Another great quality product that anyone who see\'s me wearing has asked where to purchase one of their own.\";s:12:\"comment_type\";s:0:\"\";s:14:\"comment_parent\";i:0;s:7:\"user_ID\";i:0;s:7:\"user_ip\";s:13:\"82.32.109.140\";s:10:\"user_agent\";s:72:\"Mozilla/5.0 (Windows NT 6.1; WOW64; rv:21.0) Gecko/20100101 Firefox/21.0\";s:8:\"referrer\";s:64:\"http://demo2.woothemes.com/woocommerce/product/ship-your-idea-2/\";s:4:\"blog\";s:38:\"http://demo2.woothemes.com/woocommerce\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:64:\"http://demo2.woothemes.com/woocommerce/product/ship-your-idea-2/\";s:21:\"akismet_comment_nonce\";s:6:\"passed\";s:11:\"POST_author\";s:6:\"Stuart\";s:10:\"POST_email\";s:20:\"stuart@woothemes.com\";s:11:\"POST_rating\";s:1:\"4\";s:12:\"POST_comment\";s:108:\"Another great quality product that anyone who see\'s me wearing has asked where to purchase one of their own.\";s:7:\"POST__n\";s:10:\"2145d644a3\";s:21:\"POST__wp_http_referer\";s:38:\"/woocommerce/product/ship-your-idea-2/\";s:11:\"POST_submit\";s:13:\"Submit Review\";s:20:\"POST_comment_post_ID\";s:2:\"40\";s:19:\"POST_comment_parent\";s:1:\"0\";s:26:\"POST_akismet_comment_nonce\";s:10:\"3493e6658d\";s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:33:\"/woocommerce/wp-comments-post.php\";s:15:\"REDIRECT_IS_WPE\";s:1:\"1\";s:27:\"REDIRECT_WPE_CAN_WRITE_DISK\";s:1:\"0\";s:15:\"REDIRECT_STATUS\";s:3:\"200\";s:6:\"IS_WPE\";s:1:\"1\";s:18:\"WPE_CAN_WRITE_DISK\";s:1:\"0\";s:9:\"HTTP_HOST\";s:19:\"demo2.woothemes.com\";s:13:\"HTTP_X_LB_KEY\";s:8:\"woodemo2\";s:13:\"HTTP_X_IS_BOT\";s:1:\"0\";s:15:\"HTTP_USER_AGENT\";s:72:\"Mozilla/5.0 (Windows NT 6.1; WOW64; rv:21.0) Gecko/20100101 Firefox/21.0\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.5\";s:20:\"HTTP_ACCEPT_ENCODING\";s:13:\"gzip, deflate\";s:12:\"HTTP_REFERER\";s:64:\"http://demo2.woothemes.com/woocommerce/product/ship-your-idea-2/\";s:11:\"HTTP_COOKIE\";s:0:\"\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"338\";s:4:\"PATH\";s:28:\"/usr/local/bin:/usr/bin:/bin\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:11:\"SERVER_NAME\";s:19:\"demo2.woothemes.com\";s:11:\"SERVER_ADDR\";s:9:\"127.0.0.1\";s:11:\"SERVER_PORT\";s:2:\"80\";s:11:\"REMOTE_ADDR\";s:13:\"82.32.109.140\";s:13:\"DOCUMENT_ROOT\";s:26:\"/nas/wp/www/sites/woodemo2\";s:12:\"SERVER_ADMIN\";s:18:\"[no address given]\";s:15:\"SCRIPT_FILENAME\";s:47:\"/nas/wp/www/sites/woodemo2/wp-comments-post.php\";s:11:\"REMOTE_PORT\";s:5:\"41743\";s:12:\"REDIRECT_URL\";s:33:\"/woocommerce/wp-comments-post.php\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:12:\"QUERY_STRING\";s:0:\"\";s:11:\"SCRIPT_NAME\";s:21:\"/wp-comments-post.php\";s:8:\"PHP_SELF\";s:21:\"/wp-comments-post.php\";s:12:\"REQUEST_TIME\";s:10:\"1370610209\";s:25:\"comment_post_modified_gmt\";s:19:\"2013-06-07 11:18:57\";}");
INSERT INTO `wpge_commentmeta` VALUES("174", "51", "rating", "4");
INSERT INTO `wpge_commentmeta` VALUES("175", "51", "akismet_history", "a:4:{s:4:\"time\";d:1370611527.7993829250335693359375;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}");
INSERT INTO `wpge_commentmeta` VALUES("176", "52", "akismet_error", "1370611492");
INSERT INTO `wpge_commentmeta` VALUES("177", "52", "akismet_history", "a:4:{s:4:\"time\";d:1370611492.6543419361114501953125;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}");
INSERT INTO `wpge_commentmeta` VALUES("178", "52", "akismet_as_submitted", "a:66:{s:15:\"comment_post_ID\";i:40;s:14:\"comment_author\";s:4:\"Ryan\";s:20:\"comment_author_email\";s:18:\"ryan@woothemes.com\";s:18:\"comment_author_url\";N;s:15:\"comment_content\";s:168:\"This hoodie gets me lots of looks while out in public, I got the blue one and it\'s awesome. Not sure if people are looking at my hoodie only, or also at my rocking bod.\";s:12:\"comment_type\";s:0:\"\";s:14:\"comment_parent\";i:0;s:7:\"user_ID\";i:0;s:7:\"user_ip\";s:14:\"99.153.225.252\";s:10:\"user_agent\";s:120:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/27.0.1453.110 Safari/537.36\";s:8:\"referrer\";s:64:\"http://demo2.woothemes.com/woocommerce/product/ship-your-idea-2/\";s:4:\"blog\";s:38:\"http://demo2.woothemes.com/woocommerce\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:64:\"http://demo2.woothemes.com/woocommerce/product/ship-your-idea-2/\";s:21:\"akismet_comment_nonce\";s:6:\"passed\";s:11:\"POST_author\";s:4:\"Ryan\";s:10:\"POST_email\";s:18:\"ryan@woothemes.com\";s:11:\"POST_rating\";s:1:\"5\";s:12:\"POST_comment\";s:168:\"This hoodie gets me lots of looks while out in public, I got the blue one and it\'s awesome. Not sure if people are looking at my hoodie only, or also at my rocking bod.\";s:7:\"POST__n\";s:10:\"2145d644a3\";s:21:\"POST__wp_http_referer\";s:38:\"/woocommerce/product/ship-your-idea-2/\";s:11:\"POST_submit\";s:13:\"Submit Review\";s:20:\"POST_comment_post_ID\";s:2:\"40\";s:19:\"POST_comment_parent\";s:1:\"0\";s:26:\"POST_akismet_comment_nonce\";s:10:\"3493e6658d\";s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:33:\"/woocommerce/wp-comments-post.php\";s:15:\"REDIRECT_IS_WPE\";s:1:\"1\";s:27:\"REDIRECT_WPE_CAN_WRITE_DISK\";s:1:\"0\";s:15:\"REDIRECT_STATUS\";s:3:\"200\";s:6:\"IS_WPE\";s:1:\"1\";s:18:\"WPE_CAN_WRITE_DISK\";s:1:\"0\";s:9:\"HTTP_HOST\";s:19:\"demo2.woothemes.com\";s:13:\"HTTP_X_LB_KEY\";s:8:\"woodemo2\";s:13:\"HTTP_X_IS_BOT\";s:1:\"0\";s:15:\"HTTP_USER_AGENT\";s:120:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/27.0.1453.110 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"CONTENT_LENGTH\";s:3:\"398\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:11:\"HTTP_ORIGIN\";s:26:\"http://demo2.woothemes.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:12:\"HTTP_REFERER\";s:64:\"http://demo2.woothemes.com/woocommerce/product/ship-your-idea-2/\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip,deflate,sdch\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.8\";s:11:\"HTTP_COOKIE\";s:0:\"\";s:4:\"PATH\";s:28:\"/usr/local/bin:/usr/bin:/bin\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:11:\"SERVER_NAME\";s:19:\"demo2.woothemes.com\";s:11:\"SERVER_ADDR\";s:9:\"127.0.0.1\";s:11:\"SERVER_PORT\";s:2:\"80\";s:11:\"REMOTE_ADDR\";s:14:\"99.153.225.252\";s:13:\"DOCUMENT_ROOT\";s:26:\"/nas/wp/www/sites/woodemo2\";s:12:\"SERVER_ADMIN\";s:18:\"[no address given]\";s:15:\"SCRIPT_FILENAME\";s:47:\"/nas/wp/www/sites/woodemo2/wp-comments-post.php\";s:11:\"REMOTE_PORT\";s:5:\"54935\";s:12:\"REDIRECT_URL\";s:33:\"/woocommerce/wp-comments-post.php\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:12:\"QUERY_STRING\";s:0:\"\";s:11:\"SCRIPT_NAME\";s:21:\"/wp-comments-post.php\";s:8:\"PHP_SELF\";s:21:\"/wp-comments-post.php\";s:12:\"REQUEST_TIME\";s:10:\"1370611492\";s:25:\"comment_post_modified_gmt\";s:19:\"2013-06-07 11:18:57\";}");
INSERT INTO `wpge_commentmeta` VALUES("179", "52", "rating", "5");
INSERT INTO `wpge_commentmeta` VALUES("180", "52", "akismet_history", "a:4:{s:4:\"time\";d:1370611529.7720489501953125;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}");
INSERT INTO `wpge_commentmeta` VALUES("181", "53", "akismet_error", "1370620411");
INSERT INTO `wpge_commentmeta` VALUES("182", "53", "akismet_history", "a:4:{s:4:\"time\";d:1370620411.1445829868316650390625;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}");
INSERT INTO `wpge_commentmeta` VALUES("183", "53", "akismet_as_submitted", "a:66:{s:15:\"comment_post_ID\";i:40;s:14:\"comment_author\";s:5:\"Maria\";s:20:\"comment_author_email\";s:19:\"maria@woothemes.com\";s:18:\"comment_author_url\";N;s:15:\"comment_content\";s:8:\"Ship it!\";s:12:\"comment_type\";s:0:\"\";s:14:\"comment_parent\";i:0;s:7:\"user_ID\";i:0;s:7:\"user_ip\";s:13:\"24.225.103.32\";s:10:\"user_agent\";s:120:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/27.0.1453.110 Safari/537.36\";s:8:\"referrer\";s:64:\"http://demo2.woothemes.com/woocommerce/product/ship-your-idea-2/\";s:4:\"blog\";s:38:\"http://demo2.woothemes.com/woocommerce\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:64:\"http://demo2.woothemes.com/woocommerce/product/ship-your-idea-2/\";s:21:\"akismet_comment_nonce\";s:6:\"passed\";s:11:\"POST_author\";s:5:\"Maria\";s:10:\"POST_email\";s:19:\"maria@woothemes.com\";s:11:\"POST_rating\";s:1:\"3\";s:12:\"POST_comment\";s:8:\"Ship it!\";s:7:\"POST__n\";s:10:\"2145d644a3\";s:21:\"POST__wp_http_referer\";s:38:\"/woocommerce/product/ship-your-idea-2/\";s:11:\"POST_submit\";s:13:\"Submit Review\";s:20:\"POST_comment_post_ID\";s:2:\"40\";s:19:\"POST_comment_parent\";s:1:\"0\";s:26:\"POST_akismet_comment_nonce\";s:10:\"3493e6658d\";s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:33:\"/woocommerce/wp-comments-post.php\";s:15:\"REDIRECT_IS_WPE\";s:1:\"1\";s:27:\"REDIRECT_WPE_CAN_WRITE_DISK\";s:1:\"0\";s:15:\"REDIRECT_STATUS\";s:3:\"200\";s:6:\"IS_WPE\";s:1:\"1\";s:18:\"WPE_CAN_WRITE_DISK\";s:1:\"0\";s:9:\"HTTP_HOST\";s:19:\"demo2.woothemes.com\";s:13:\"HTTP_X_LB_KEY\";s:8:\"woodemo2\";s:13:\"HTTP_X_IS_BOT\";s:1:\"0\";s:15:\"HTTP_USER_AGENT\";s:120:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/27.0.1453.110 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"CONTENT_LENGTH\";s:3:\"236\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:11:\"HTTP_ORIGIN\";s:26:\"http://demo2.woothemes.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:12:\"HTTP_REFERER\";s:64:\"http://demo2.woothemes.com/woocommerce/product/ship-your-idea-2/\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip,deflate,sdch\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.8\";s:11:\"HTTP_COOKIE\";s:0:\"\";s:4:\"PATH\";s:28:\"/usr/local/bin:/usr/bin:/bin\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:11:\"SERVER_NAME\";s:19:\"demo2.woothemes.com\";s:11:\"SERVER_ADDR\";s:9:\"127.0.0.1\";s:11:\"SERVER_PORT\";s:2:\"80\";s:11:\"REMOTE_ADDR\";s:13:\"24.225.103.32\";s:13:\"DOCUMENT_ROOT\";s:26:\"/nas/wp/www/sites/woodemo2\";s:12:\"SERVER_ADMIN\";s:18:\"[no address given]\";s:15:\"SCRIPT_FILENAME\";s:47:\"/nas/wp/www/sites/woodemo2/wp-comments-post.php\";s:11:\"REMOTE_PORT\";s:5:\"27030\";s:12:\"REDIRECT_URL\";s:33:\"/woocommerce/wp-comments-post.php\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:12:\"QUERY_STRING\";s:0:\"\";s:11:\"SCRIPT_NAME\";s:21:\"/wp-comments-post.php\";s:8:\"PHP_SELF\";s:21:\"/wp-comments-post.php\";s:12:\"REQUEST_TIME\";s:10:\"1370620411\";s:25:\"comment_post_modified_gmt\";s:19:\"2013-06-07 11:18:57\";}");
INSERT INTO `wpge_commentmeta` VALUES("184", "53", "rating", "3");
INSERT INTO `wpge_commentmeta` VALUES("185", "53", "akismet_history", "a:4:{s:4:\"time\";d:1370620633.9381520748138427734375;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}");
INSERT INTO `wpge_commentmeta` VALUES("186", "54", "akismet_error", "1370605612");
INSERT INTO `wpge_commentmeta` VALUES("187", "54", "akismet_history", "a:4:{s:4:\"time\";d:1370605612.873900890350341796875;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}");
INSERT INTO `wpge_commentmeta` VALUES("188", "54", "akismet_as_submitted", "a:66:{s:15:\"comment_post_ID\";i:50;s:14:\"comment_author\";s:12:\"James Koster\";s:20:\"comment_author_email\";s:23:\"james@jameskoster.co.uk\";s:18:\"comment_author_url\";N;s:15:\"comment_content\";s:103:\"Perfect when you\'re waiting for the next batch of Woo Goodies to be released. Patient Ninja is Patient.\";s:12:\"comment_type\";s:0:\"\";s:14:\"comment_parent\";i:0;s:7:\"user_ID\";i:0;s:7:\"user_ip\";s:13:\"86.146.141.82\";s:10:\"user_agent\";s:120:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/27.0.1453.110 Safari/537.36\";s:8:\"referrer\";s:61:\"http://demo2.woothemes.com/woocommerce/product/patient-ninja/\";s:4:\"blog\";s:38:\"http://demo2.woothemes.com/woocommerce\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:61:\"http://demo2.woothemes.com/woocommerce/product/patient-ninja/\";s:21:\"akismet_comment_nonce\";s:6:\"passed\";s:11:\"POST_author\";s:12:\"James Koster\";s:10:\"POST_email\";s:23:\"james@jameskoster.co.uk\";s:11:\"POST_rating\";s:1:\"4\";s:12:\"POST_comment\";s:103:\"Perfect when you\'re waiting for the next batch of Woo Goodies to be released. Patient Ninja is Patient.\";s:7:\"POST__n\";s:10:\"a80bd2f042\";s:21:\"POST__wp_http_referer\";s:35:\"/woocommerce/product/patient-ninja/\";s:11:\"POST_submit\";s:13:\"Submit Review\";s:20:\"POST_comment_post_ID\";s:2:\"50\";s:19:\"POST_comment_parent\";s:1:\"0\";s:26:\"POST_akismet_comment_nonce\";s:10:\"ad4e7e1f00\";s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:33:\"/woocommerce/wp-comments-post.php\";s:15:\"REDIRECT_IS_WPE\";s:1:\"1\";s:27:\"REDIRECT_WPE_CAN_WRITE_DISK\";s:1:\"0\";s:15:\"REDIRECT_STATUS\";s:3:\"200\";s:6:\"IS_WPE\";s:1:\"1\";s:18:\"WPE_CAN_WRITE_DISK\";s:1:\"0\";s:9:\"HTTP_HOST\";s:19:\"demo2.woothemes.com\";s:13:\"HTTP_X_LB_KEY\";s:8:\"woodemo2\";s:13:\"HTTP_X_IS_BOT\";s:1:\"0\";s:15:\"HTTP_USER_AGENT\";s:120:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/27.0.1453.110 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"CONTENT_LENGTH\";s:3:\"339\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:11:\"HTTP_ORIGIN\";s:26:\"http://demo2.woothemes.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:12:\"HTTP_REFERER\";s:61:\"http://demo2.woothemes.com/woocommerce/product/patient-ninja/\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip,deflate,sdch\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.8\";s:11:\"HTTP_COOKIE\";s:0:\"\";s:4:\"PATH\";s:28:\"/usr/local/bin:/usr/bin:/bin\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:11:\"SERVER_NAME\";s:19:\"demo2.woothemes.com\";s:11:\"SERVER_ADDR\";s:9:\"127.0.0.1\";s:11:\"SERVER_PORT\";s:2:\"80\";s:11:\"REMOTE_ADDR\";s:13:\"86.146.141.82\";s:13:\"DOCUMENT_ROOT\";s:26:\"/nas/wp/www/sites/woodemo2\";s:12:\"SERVER_ADMIN\";s:18:\"[no address given]\";s:15:\"SCRIPT_FILENAME\";s:47:\"/nas/wp/www/sites/woodemo2/wp-comments-post.php\";s:11:\"REMOTE_PORT\";s:5:\"49636\";s:12:\"REDIRECT_URL\";s:33:\"/woocommerce/wp-comments-post.php\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:12:\"QUERY_STRING\";s:0:\"\";s:11:\"SCRIPT_NAME\";s:21:\"/wp-comments-post.php\";s:8:\"PHP_SELF\";s:21:\"/wp-comments-post.php\";s:12:\"REQUEST_TIME\";s:10:\"1370605612\";s:25:\"comment_post_modified_gmt\";s:19:\"2013-06-07 11:17:10\";}");
INSERT INTO `wpge_commentmeta` VALUES("189", "54", "rating", "4");
INSERT INTO `wpge_commentmeta` VALUES("190", "54", "akismet_history", "a:4:{s:4:\"time\";d:1370605643.71494293212890625;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}");
INSERT INTO `wpge_commentmeta` VALUES("191", "55", "akismet_error", "1370605993");
INSERT INTO `wpge_commentmeta` VALUES("192", "55", "akismet_history", "a:4:{s:4:\"time\";d:1370605993.45998096466064453125;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}");
INSERT INTO `wpge_commentmeta` VALUES("193", "55", "akismet_as_submitted", "a:67:{s:15:\"comment_post_ID\";i:50;s:14:\"comment_author\";s:12:\"Cobus Bester\";s:20:\"comment_author_email\";s:18:\"bester.c@gmail.com\";s:18:\"comment_author_url\";N;s:15:\"comment_content\";s:46:\"The most comfortable hoodie I have ever owned!\";s:12:\"comment_type\";s:0:\"\";s:14:\"comment_parent\";i:0;s:7:\"user_ID\";i:0;s:7:\"user_ip\";s:13:\"196.215.9.147\";s:10:\"user_agent\";s:119:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_3) AppleWebKit/537.31 (KHTML, like Gecko) Chrome/26.0.1410.65 Safari/537.31\";s:8:\"referrer\";s:61:\"http://demo2.woothemes.com/woocommerce/product/patient-ninja/\";s:4:\"blog\";s:38:\"http://demo2.woothemes.com/woocommerce\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:61:\"http://demo2.woothemes.com/woocommerce/product/patient-ninja/\";s:21:\"akismet_comment_nonce\";s:6:\"passed\";s:11:\"POST_author\";s:12:\"Cobus Bester\";s:10:\"POST_email\";s:18:\"bester.c@gmail.com\";s:11:\"POST_rating\";s:1:\"5\";s:12:\"POST_comment\";s:46:\"The most comfortable hoodie I have ever owned!\";s:7:\"POST__n\";s:10:\"a80bd2f042\";s:21:\"POST__wp_http_referer\";s:35:\"/woocommerce/product/patient-ninja/\";s:11:\"POST_submit\";s:13:\"Submit Review\";s:20:\"POST_comment_post_ID\";s:2:\"50\";s:19:\"POST_comment_parent\";s:1:\"0\";s:26:\"POST_akismet_comment_nonce\";s:10:\"ad4e7e1f00\";s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:33:\"/woocommerce/wp-comments-post.php\";s:15:\"REDIRECT_IS_WPE\";s:1:\"1\";s:27:\"REDIRECT_WPE_CAN_WRITE_DISK\";s:1:\"0\";s:15:\"REDIRECT_STATUS\";s:3:\"200\";s:6:\"IS_WPE\";s:1:\"1\";s:18:\"WPE_CAN_WRITE_DISK\";s:1:\"0\";s:9:\"HTTP_HOST\";s:19:\"demo2.woothemes.com\";s:13:\"HTTP_X_LB_KEY\";s:8:\"woodemo2\";s:13:\"HTTP_X_IS_BOT\";s:1:\"0\";s:15:\"HTTP_USER_AGENT\";s:119:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_3) AppleWebKit/537.31 (KHTML, like Gecko) Chrome/26.0.1410.65 Safari/537.31\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"CONTENT_LENGTH\";s:3:\"277\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:11:\"HTTP_ORIGIN\";s:26:\"http://demo2.woothemes.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:12:\"HTTP_REFERER\";s:61:\"http://demo2.woothemes.com/woocommerce/product/patient-ninja/\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip,deflate,sdch\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.8\";s:19:\"HTTP_ACCEPT_CHARSET\";s:30:\"ISO-8859-1,utf-8;q=0.7,*;q=0.3\";s:11:\"HTTP_COOKIE\";s:0:\"\";s:4:\"PATH\";s:28:\"/usr/local/bin:/usr/bin:/bin\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:11:\"SERVER_NAME\";s:19:\"demo2.woothemes.com\";s:11:\"SERVER_ADDR\";s:9:\"127.0.0.1\";s:11:\"SERVER_PORT\";s:2:\"80\";s:11:\"REMOTE_ADDR\";s:13:\"196.215.9.147\";s:13:\"DOCUMENT_ROOT\";s:26:\"/nas/wp/www/sites/woodemo2\";s:12:\"SERVER_ADMIN\";s:18:\"[no address given]\";s:15:\"SCRIPT_FILENAME\";s:47:\"/nas/wp/www/sites/woodemo2/wp-comments-post.php\";s:11:\"REMOTE_PORT\";s:5:\"54451\";s:12:\"REDIRECT_URL\";s:33:\"/woocommerce/wp-comments-post.php\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:12:\"QUERY_STRING\";s:0:\"\";s:11:\"SCRIPT_NAME\";s:21:\"/wp-comments-post.php\";s:8:\"PHP_SELF\";s:21:\"/wp-comments-post.php\";s:12:\"REQUEST_TIME\";s:10:\"1370605993\";s:25:\"comment_post_modified_gmt\";s:19:\"2013-06-07 11:17:10\";}");
INSERT INTO `wpge_commentmeta` VALUES("194", "55", "rating", "5");
INSERT INTO `wpge_commentmeta` VALUES("195", "55", "akismet_history", "a:4:{s:4:\"time\";d:1370607929.392714977264404296875;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}");
INSERT INTO `wpge_commentmeta` VALUES("196", "56", "akismet_error", "1370606643");
INSERT INTO `wpge_commentmeta` VALUES("197", "56", "akismet_history", "a:4:{s:4:\"time\";d:1370606643.435740947723388671875;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}");
INSERT INTO `wpge_commentmeta` VALUES("198", "56", "akismet_as_submitted", "");
INSERT INTO `wpge_commentmeta` VALUES("199", "56", "rating", "5");
INSERT INTO `wpge_commentmeta` VALUES("200", "56", "akismet_history", "a:4:{s:4:\"time\";d:1370607947.308474063873291015625;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}");
INSERT INTO `wpge_commentmeta` VALUES("201", "57", "akismet_error", "1370606091");
INSERT INTO `wpge_commentmeta` VALUES("202", "57", "akismet_history", "a:4:{s:4:\"time\";d:1370606091.7579820156097412109375;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}");
INSERT INTO `wpge_commentmeta` VALUES("203", "57", "akismet_as_submitted", "a:64:{s:15:\"comment_post_ID\";i:53;s:14:\"comment_author\";s:6:\"Andrew\";s:20:\"comment_author_email\";s:25:\"andrew@chromeorange.co.uk\";s:18:\"comment_author_url\";N;s:15:\"comment_content\";s:149:\"I bought this thinking it was a nice green colour, apparently it GREY! I\'m colour blind so I don\'t care but my girlfriend says grey makes me look fat\";s:12:\"comment_type\";s:0:\"\";s:14:\"comment_parent\";i:0;s:7:\"user_ID\";i:0;s:7:\"user_ip\";s:13:\"86.19.152.140\";s:10:\"user_agent\";s:81:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:21.0) Gecko/20100101 Firefox/21.0\";s:8:\"referrer\";s:61:\"http://demo2.woothemes.com/woocommerce/product/happy-ninja-2/\";s:4:\"blog\";s:38:\"http://demo2.woothemes.com/woocommerce\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:61:\"http://demo2.woothemes.com/woocommerce/product/happy-ninja-2/\";s:21:\"akismet_comment_nonce\";s:6:\"passed\";s:11:\"POST_author\";s:6:\"Andrew\";s:10:\"POST_email\";s:25:\"andrew@chromeorange.co.uk\";s:11:\"POST_rating\";s:1:\"1\";s:12:\"POST_comment\";s:149:\"I bought this thinking it was a nice green colour, apparently it GREY! I\'m colour blind so I don\'t care but my girlfriend says grey makes me look fat\";s:7:\"POST__n\";s:10:\"a80bd2f042\";s:21:\"POST__wp_http_referer\";s:35:\"/woocommerce/product/happy-ninja-2/\";s:11:\"POST_submit\";s:13:\"Submit Review\";s:20:\"POST_comment_post_ID\";s:2:\"53\";s:19:\"POST_comment_parent\";s:1:\"0\";s:26:\"POST_akismet_comment_nonce\";s:10:\"d96b507062\";s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:33:\"/woocommerce/wp-comments-post.php\";s:15:\"REDIRECT_IS_WPE\";s:1:\"1\";s:27:\"REDIRECT_WPE_CAN_WRITE_DISK\";s:1:\"0\";s:15:\"REDIRECT_STATUS\";s:3:\"200\";s:6:\"IS_WPE\";s:1:\"1\";s:18:\"WPE_CAN_WRITE_DISK\";s:1:\"0\";s:9:\"HTTP_HOST\";s:19:\"demo2.woothemes.com\";s:13:\"HTTP_X_LB_KEY\";s:8:\"woodemo2\";s:13:\"HTTP_X_IS_BOT\";s:1:\"0\";s:15:\"HTTP_USER_AGENT\";s:81:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:21.0) Gecko/20100101 Firefox/21.0\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.5\";s:20:\"HTTP_ACCEPT_ENCODING\";s:13:\"gzip, deflate\";s:12:\"HTTP_REFERER\";s:61:\"http://demo2.woothemes.com/woocommerce/product/happy-ninja-2/\";s:11:\"HTTP_COOKIE\";s:0:\"\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"387\";s:4:\"PATH\";s:28:\"/usr/local/bin:/usr/bin:/bin\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:11:\"SERVER_NAME\";s:19:\"demo2.woothemes.com\";s:11:\"SERVER_ADDR\";s:9:\"127.0.0.1\";s:11:\"SERVER_PORT\";s:2:\"80\";s:11:\"REMOTE_ADDR\";s:13:\"86.19.152.140\";s:13:\"DOCUMENT_ROOT\";s:26:\"/nas/wp/www/sites/woodemo2\";s:12:\"SERVER_ADMIN\";s:18:\"[no address given]\";s:15:\"SCRIPT_FILENAME\";s:47:\"/nas/wp/www/sites/woodemo2/wp-comments-post.php\";s:11:\"REMOTE_PORT\";s:5:\"55431\";s:12:\"REDIRECT_URL\";s:33:\"/woocommerce/wp-comments-post.php\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:12:\"QUERY_STRING\";s:0:\"\";s:11:\"SCRIPT_NAME\";s:21:\"/wp-comments-post.php\";s:8:\"PHP_SELF\";s:21:\"/wp-comments-post.php\";s:12:\"REQUEST_TIME\";s:10:\"1370606091\";s:25:\"comment_post_modified_gmt\";s:19:\"2013-06-07 11:17:38\";}");
INSERT INTO `wpge_commentmeta` VALUES("204", "57", "rating", "1");
INSERT INTO `wpge_commentmeta` VALUES("205", "57", "akismet_history", "a:4:{s:4:\"time\";d:1370607932.6080811023712158203125;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}");
INSERT INTO `wpge_commentmeta` VALUES("206", "58", "akismet_error", "1370620222");
INSERT INTO `wpge_commentmeta` VALUES("207", "58", "akismet_history", "a:4:{s:4:\"time\";d:1370620222.19242095947265625;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}");
INSERT INTO `wpge_commentmeta` VALUES("208", "58", "akismet_as_submitted", "a:66:{s:15:\"comment_post_ID\";i:53;s:14:\"comment_author\";s:5:\"Maria\";s:20:\"comment_author_email\";s:19:\"maria@woothemes.com\";s:18:\"comment_author_url\";N;s:15:\"comment_content\";s:122:\"I love grey hoodies! This is perfect with my grey Ninja shirt, when I get cold I throw this on and I can still be a Ninja.\";s:12:\"comment_type\";s:0:\"\";s:14:\"comment_parent\";i:0;s:7:\"user_ID\";i:0;s:7:\"user_ip\";s:13:\"24.225.103.32\";s:10:\"user_agent\";s:120:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/27.0.1453.110 Safari/537.36\";s:8:\"referrer\";s:61:\"http://demo2.woothemes.com/woocommerce/product/happy-ninja-2/\";s:4:\"blog\";s:38:\"http://demo2.woothemes.com/woocommerce\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:61:\"http://demo2.woothemes.com/woocommerce/product/happy-ninja-2/\";s:21:\"akismet_comment_nonce\";s:6:\"passed\";s:11:\"POST_author\";s:5:\"Maria\";s:10:\"POST_email\";s:19:\"maria@woothemes.com\";s:11:\"POST_rating\";s:1:\"5\";s:12:\"POST_comment\";s:123:\"I love grey hoodies! This is perfect with my grey Ninja shirt, when I get cold I throw this on and I can still be a Ninja. \";s:7:\"POST__n\";s:10:\"2145d644a3\";s:21:\"POST__wp_http_referer\";s:35:\"/woocommerce/product/happy-ninja-2/\";s:11:\"POST_submit\";s:13:\"Submit Review\";s:20:\"POST_comment_post_ID\";s:2:\"53\";s:19:\"POST_comment_parent\";s:1:\"0\";s:26:\"POST_akismet_comment_nonce\";s:10:\"7c862b3966\";s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:33:\"/woocommerce/wp-comments-post.php\";s:15:\"REDIRECT_IS_WPE\";s:1:\"1\";s:27:\"REDIRECT_WPE_CAN_WRITE_DISK\";s:1:\"0\";s:15:\"REDIRECT_STATUS\";s:3:\"200\";s:6:\"IS_WPE\";s:1:\"1\";s:18:\"WPE_CAN_WRITE_DISK\";s:1:\"0\";s:9:\"HTTP_HOST\";s:19:\"demo2.woothemes.com\";s:13:\"HTTP_X_LB_KEY\";s:8:\"woodemo2\";s:13:\"HTTP_X_IS_BOT\";s:1:\"0\";s:15:\"HTTP_USER_AGENT\";s:120:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/27.0.1453.110 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"CONTENT_LENGTH\";s:3:\"350\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:11:\"HTTP_ORIGIN\";s:26:\"http://demo2.woothemes.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:12:\"HTTP_REFERER\";s:61:\"http://demo2.woothemes.com/woocommerce/product/happy-ninja-2/\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip,deflate,sdch\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.8\";s:11:\"HTTP_COOKIE\";s:0:\"\";s:4:\"PATH\";s:28:\"/usr/local/bin:/usr/bin:/bin\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:11:\"SERVER_NAME\";s:19:\"demo2.woothemes.com\";s:11:\"SERVER_ADDR\";s:9:\"127.0.0.1\";s:11:\"SERVER_PORT\";s:2:\"80\";s:11:\"REMOTE_ADDR\";s:13:\"24.225.103.32\";s:13:\"DOCUMENT_ROOT\";s:26:\"/nas/wp/www/sites/woodemo2\";s:12:\"SERVER_ADMIN\";s:18:\"[no address given]\";s:15:\"SCRIPT_FILENAME\";s:47:\"/nas/wp/www/sites/woodemo2/wp-comments-post.php\";s:11:\"REMOTE_PORT\";s:5:\"24514\";s:12:\"REDIRECT_URL\";s:33:\"/woocommerce/wp-comments-post.php\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:12:\"QUERY_STRING\";s:0:\"\";s:11:\"SCRIPT_NAME\";s:21:\"/wp-comments-post.php\";s:8:\"PHP_SELF\";s:21:\"/wp-comments-post.php\";s:12:\"REQUEST_TIME\";s:10:\"1370620222\";s:25:\"comment_post_modified_gmt\";s:19:\"2013-06-07 11:17:38\";}");
INSERT INTO `wpge_commentmeta` VALUES("209", "58", "rating", "5");
INSERT INTO `wpge_commentmeta` VALUES("210", "58", "akismet_history", "a:4:{s:4:\"time\";d:1370620633.951541900634765625;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}");
INSERT INTO `wpge_commentmeta` VALUES("211", "59", "akismet_error", "1370606673");
INSERT INTO `wpge_commentmeta` VALUES("212", "59", "akismet_history", "a:4:{s:4:\"time\";d:1370606673.5934140682220458984375;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}");
INSERT INTO `wpge_commentmeta` VALUES("213", "59", "akismet_as_submitted", "a:66:{s:15:\"comment_post_ID\";i:60;s:14:\"comment_author\";s:6:\"Magnus\";s:20:\"comment_author_email\";s:20:\"magnus@woothemes.com\";s:18:\"comment_author_url\";N;s:15:\"comment_content\";s:34:\"I like the logo but not the color.\";s:12:\"comment_type\";s:0:\"\";s:14:\"comment_parent\";i:0;s:7:\"user_ID\";i:0;s:7:\"user_ip\";s:13:\"79.161.106.35\";s:10:\"user_agent\";s:119:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/27.0.1453.93 Safari/537.36\";s:8:\"referrer\";s:58:\"http://demo2.woothemes.com/woocommerce/product/woo-logo-2/\";s:4:\"blog\";s:38:\"http://demo2.woothemes.com/woocommerce\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:58:\"http://demo2.woothemes.com/woocommerce/product/woo-logo-2/\";s:21:\"akismet_comment_nonce\";s:6:\"passed\";s:11:\"POST_author\";s:6:\"Magnus\";s:10:\"POST_email\";s:20:\"magnus@woothemes.com\";s:11:\"POST_rating\";s:1:\"3\";s:12:\"POST_comment\";s:35:\"I like the logo but not the color. \";s:7:\"POST__n\";s:10:\"2145d644a3\";s:21:\"POST__wp_http_referer\";s:32:\"/woocommerce/product/woo-logo-2/\";s:11:\"POST_submit\";s:13:\"Submit Review\";s:20:\"POST_comment_post_ID\";s:2:\"60\";s:19:\"POST_comment_parent\";s:1:\"0\";s:26:\"POST_akismet_comment_nonce\";s:10:\"71dc771f00\";s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:33:\"/woocommerce/wp-comments-post.php\";s:15:\"REDIRECT_IS_WPE\";s:1:\"1\";s:27:\"REDIRECT_WPE_CAN_WRITE_DISK\";s:1:\"0\";s:15:\"REDIRECT_STATUS\";s:3:\"200\";s:6:\"IS_WPE\";s:1:\"1\";s:18:\"WPE_CAN_WRITE_DISK\";s:1:\"0\";s:9:\"HTTP_HOST\";s:19:\"demo2.woothemes.com\";s:13:\"HTTP_X_LB_KEY\";s:8:\"woodemo2\";s:13:\"HTTP_X_IS_BOT\";s:1:\"0\";s:15:\"HTTP_USER_AGENT\";s:119:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/27.0.1453.93 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"CONTENT_LENGTH\";s:3:\"257\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:11:\"HTTP_ORIGIN\";s:26:\"http://demo2.woothemes.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:12:\"HTTP_REFERER\";s:58:\"http://demo2.woothemes.com/woocommerce/product/woo-logo-2/\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip,deflate,sdch\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.8\";s:11:\"HTTP_COOKIE\";s:0:\"\";s:4:\"PATH\";s:28:\"/usr/local/bin:/usr/bin:/bin\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:11:\"SERVER_NAME\";s:19:\"demo2.woothemes.com\";s:11:\"SERVER_ADDR\";s:9:\"127.0.0.1\";s:11:\"SERVER_PORT\";s:2:\"80\";s:11:\"REMOTE_ADDR\";s:13:\"79.161.106.35\";s:13:\"DOCUMENT_ROOT\";s:26:\"/nas/wp/www/sites/woodemo2\";s:12:\"SERVER_ADMIN\";s:18:\"[no address given]\";s:15:\"SCRIPT_FILENAME\";s:47:\"/nas/wp/www/sites/woodemo2/wp-comments-post.php\";s:11:\"REMOTE_PORT\";s:5:\"62521\";s:12:\"REDIRECT_URL\";s:33:\"/woocommerce/wp-comments-post.php\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:12:\"QUERY_STRING\";s:0:\"\";s:11:\"SCRIPT_NAME\";s:21:\"/wp-comments-post.php\";s:8:\"PHP_SELF\";s:21:\"/wp-comments-post.php\";s:12:\"REQUEST_TIME\";s:10:\"1370606673\";s:25:\"comment_post_modified_gmt\";s:19:\"2013-06-07 11:18:08\";}");
INSERT INTO `wpge_commentmeta` VALUES("214", "59", "rating", "3");
INSERT INTO `wpge_commentmeta` VALUES("215", "59", "akismet_history", "a:4:{s:4:\"time\";d:1370607949.19136905670166015625;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}");
INSERT INTO `wpge_commentmeta` VALUES("216", "60", "akismet_error", "1370620465");
INSERT INTO `wpge_commentmeta` VALUES("217", "60", "akismet_history", "a:4:{s:4:\"time\";d:1370620465.89346790313720703125;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}");
INSERT INTO `wpge_commentmeta` VALUES("218", "60", "akismet_as_submitted", "a:66:{s:15:\"comment_post_ID\";i:60;s:14:\"comment_author\";s:5:\"Maria\";s:20:\"comment_author_email\";s:19:\"maria@woothemes.com\";s:18:\"comment_author_url\";N;s:15:\"comment_content\";s:29:\"Three letters, one word: WOO!\";s:12:\"comment_type\";s:0:\"\";s:14:\"comment_parent\";i:0;s:7:\"user_ID\";i:0;s:7:\"user_ip\";s:13:\"24.225.103.32\";s:10:\"user_agent\";s:120:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/27.0.1453.110 Safari/537.36\";s:8:\"referrer\";s:58:\"http://demo2.woothemes.com/woocommerce/product/woo-logo-2/\";s:4:\"blog\";s:38:\"http://demo2.woothemes.com/woocommerce\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:58:\"http://demo2.woothemes.com/woocommerce/product/woo-logo-2/\";s:21:\"akismet_comment_nonce\";s:6:\"passed\";s:11:\"POST_author\";s:5:\"Maria\";s:10:\"POST_email\";s:19:\"maria@woothemes.com\";s:11:\"POST_rating\";s:1:\"5\";s:12:\"POST_comment\";s:29:\"Three letters, one word: WOO!\";s:7:\"POST__n\";s:10:\"2145d644a3\";s:21:\"POST__wp_http_referer\";s:32:\"/woocommerce/product/woo-logo-2/\";s:11:\"POST_submit\";s:13:\"Submit Review\";s:20:\"POST_comment_post_ID\";s:2:\"60\";s:19:\"POST_comment_parent\";s:1:\"0\";s:26:\"POST_akismet_comment_nonce\";s:10:\"71dc771f00\";s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:33:\"/woocommerce/wp-comments-post.php\";s:15:\"REDIRECT_IS_WPE\";s:1:\"1\";s:27:\"REDIRECT_WPE_CAN_WRITE_DISK\";s:1:\"0\";s:15:\"REDIRECT_STATUS\";s:3:\"200\";s:6:\"IS_WPE\";s:1:\"1\";s:18:\"WPE_CAN_WRITE_DISK\";s:1:\"0\";s:9:\"HTTP_HOST\";s:19:\"demo2.woothemes.com\";s:13:\"HTTP_X_LB_KEY\";s:8:\"woodemo2\";s:13:\"HTTP_X_IS_BOT\";s:1:\"0\";s:15:\"HTTP_USER_AGENT\";s:120:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/27.0.1453.110 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"CONTENT_LENGTH\";s:3:\"255\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:11:\"HTTP_ORIGIN\";s:26:\"http://demo2.woothemes.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:12:\"HTTP_REFERER\";s:58:\"http://demo2.woothemes.com/woocommerce/product/woo-logo-2/\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip,deflate,sdch\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.8\";s:11:\"HTTP_COOKIE\";s:0:\"\";s:4:\"PATH\";s:28:\"/usr/local/bin:/usr/bin:/bin\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:11:\"SERVER_NAME\";s:19:\"demo2.woothemes.com\";s:11:\"SERVER_ADDR\";s:9:\"127.0.0.1\";s:11:\"SERVER_PORT\";s:2:\"80\";s:11:\"REMOTE_ADDR\";s:13:\"24.225.103.32\";s:13:\"DOCUMENT_ROOT\";s:26:\"/nas/wp/www/sites/woodemo2\";s:12:\"SERVER_ADMIN\";s:18:\"[no address given]\";s:15:\"SCRIPT_FILENAME\";s:47:\"/nas/wp/www/sites/woodemo2/wp-comments-post.php\";s:11:\"REMOTE_PORT\";s:5:\"27597\";s:12:\"REDIRECT_URL\";s:33:\"/woocommerce/wp-comments-post.php\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:12:\"QUERY_STRING\";s:0:\"\";s:11:\"SCRIPT_NAME\";s:21:\"/wp-comments-post.php\";s:8:\"PHP_SELF\";s:21:\"/wp-comments-post.php\";s:12:\"REQUEST_TIME\";s:10:\"1370620465\";s:25:\"comment_post_modified_gmt\";s:19:\"2013-06-07 11:18:08\";}");
INSERT INTO `wpge_commentmeta` VALUES("219", "60", "rating", "5");
INSERT INTO `wpge_commentmeta` VALUES("220", "60", "akismet_history", "a:4:{s:4:\"time\";d:1370620633.92792606353759765625;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}");
INSERT INTO `wpge_commentmeta` VALUES("221", "61", "akismet_error", "1370605945");
INSERT INTO `wpge_commentmeta` VALUES("222", "61", "akismet_history", "a:4:{s:4:\"time\";d:1370605945.8927509784698486328125;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}");
INSERT INTO `wpge_commentmeta` VALUES("223", "61", "akismet_as_submitted", "a:67:{s:15:\"comment_post_ID\";i:70;s:14:\"comment_author\";s:12:\"Cobus Bester\";s:20:\"comment_author_email\";s:18:\"bester.c@gmail.com\";s:18:\"comment_author_url\";N;s:15:\"comment_content\";s:86:\"Really happy with this print. The colors are great, and the paper quality is good too.\";s:12:\"comment_type\";s:0:\"\";s:14:\"comment_parent\";i:0;s:7:\"user_ID\";i:0;s:7:\"user_ip\";s:13:\"196.215.9.147\";s:10:\"user_agent\";s:119:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_3) AppleWebKit/537.31 (KHTML, like Gecko) Chrome/26.0.1410.65 Safari/537.31\";s:8:\"referrer\";s:60:\"http://demo2.woothemes.com/woocommerce/product/flying-ninja/\";s:4:\"blog\";s:38:\"http://demo2.woothemes.com/woocommerce\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:60:\"http://demo2.woothemes.com/woocommerce/product/flying-ninja/\";s:21:\"akismet_comment_nonce\";s:6:\"passed\";s:11:\"POST_author\";s:12:\"Cobus Bester\";s:10:\"POST_email\";s:18:\"bester.c@gmail.com\";s:11:\"POST_rating\";s:1:\"4\";s:12:\"POST_comment\";s:86:\"Really happy with this print. The colors are great, and the paper quality is good too.\";s:7:\"POST__n\";s:10:\"a80bd2f042\";s:21:\"POST__wp_http_referer\";s:34:\"/woocommerce/product/flying-ninja/\";s:11:\"POST_submit\";s:13:\"Submit Review\";s:20:\"POST_comment_post_ID\";s:2:\"70\";s:19:\"POST_comment_parent\";s:1:\"0\";s:26:\"POST_akismet_comment_nonce\";s:10:\"09a0ca91cf\";s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:33:\"/woocommerce/wp-comments-post.php\";s:15:\"REDIRECT_IS_WPE\";s:1:\"1\";s:27:\"REDIRECT_WPE_CAN_WRITE_DISK\";s:1:\"0\";s:15:\"REDIRECT_STATUS\";s:3:\"200\";s:6:\"IS_WPE\";s:1:\"1\";s:18:\"WPE_CAN_WRITE_DISK\";s:1:\"0\";s:9:\"HTTP_HOST\";s:19:\"demo2.woothemes.com\";s:13:\"HTTP_X_LB_KEY\";s:8:\"woodemo2\";s:13:\"HTTP_X_IS_BOT\";s:1:\"0\";s:15:\"HTTP_USER_AGENT\";s:119:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_3) AppleWebKit/537.31 (KHTML, like Gecko) Chrome/26.0.1410.65 Safari/537.31\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"CONTENT_LENGTH\";s:3:\"316\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:11:\"HTTP_ORIGIN\";s:26:\"http://demo2.woothemes.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:12:\"HTTP_REFERER\";s:60:\"http://demo2.woothemes.com/woocommerce/product/flying-ninja/\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip,deflate,sdch\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.8\";s:19:\"HTTP_ACCEPT_CHARSET\";s:30:\"ISO-8859-1,utf-8;q=0.7,*;q=0.3\";s:11:\"HTTP_COOKIE\";s:0:\"\";s:4:\"PATH\";s:28:\"/usr/local/bin:/usr/bin:/bin\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:11:\"SERVER_NAME\";s:19:\"demo2.woothemes.com\";s:11:\"SERVER_ADDR\";s:9:\"127.0.0.1\";s:11:\"SERVER_PORT\";s:2:\"80\";s:11:\"REMOTE_ADDR\";s:13:\"196.215.9.147\";s:13:\"DOCUMENT_ROOT\";s:26:\"/nas/wp/www/sites/woodemo2\";s:12:\"SERVER_ADMIN\";s:18:\"[no address given]\";s:15:\"SCRIPT_FILENAME\";s:47:\"/nas/wp/www/sites/woodemo2/wp-comments-post.php\";s:11:\"REMOTE_PORT\";s:5:\"53744\";s:12:\"REDIRECT_URL\";s:33:\"/woocommerce/wp-comments-post.php\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:12:\"QUERY_STRING\";s:0:\"\";s:11:\"SCRIPT_NAME\";s:21:\"/wp-comments-post.php\";s:8:\"PHP_SELF\";s:21:\"/wp-comments-post.php\";s:12:\"REQUEST_TIME\";s:10:\"1370605945\";s:25:\"comment_post_modified_gmt\";s:19:\"2013-06-07 11:25:12\";}");
INSERT INTO `wpge_commentmeta` VALUES("224", "61", "rating", "4");
INSERT INTO `wpge_commentmeta` VALUES("225", "61", "akismet_history", "a:4:{s:4:\"time\";d:1370607928.4240779876708984375;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}");
INSERT INTO `wpge_commentmeta` VALUES("226", "62", "akismet_error", "1370606196");
INSERT INTO `wpge_commentmeta` VALUES("227", "62", "akismet_history", "a:4:{s:4:\"time\";d:1370606196.096724987030029296875;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}");
INSERT INTO `wpge_commentmeta` VALUES("228", "62", "akismet_as_submitted", "a:64:{s:15:\"comment_post_ID\";i:70;s:14:\"comment_author\";s:6:\"Andrew\";s:20:\"comment_author_email\";s:25:\"andrew@chromeorange.co.uk\";s:18:\"comment_author_url\";N;s:15:\"comment_content\";s:136:\"You only get the picture, not the person holding it, something they don\'t mention in the description, now I\'ve got to find my own person\";s:12:\"comment_type\";s:0:\"\";s:14:\"comment_parent\";i:0;s:7:\"user_ID\";i:0;s:7:\"user_ip\";s:13:\"86.19.152.140\";s:10:\"user_agent\";s:81:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:21.0) Gecko/20100101 Firefox/21.0\";s:8:\"referrer\";s:60:\"http://demo2.woothemes.com/woocommerce/product/flying-ninja/\";s:4:\"blog\";s:38:\"http://demo2.woothemes.com/woocommerce\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:60:\"http://demo2.woothemes.com/woocommerce/product/flying-ninja/\";s:21:\"akismet_comment_nonce\";s:6:\"passed\";s:11:\"POST_author\";s:6:\"Andrew\";s:10:\"POST_email\";s:25:\"andrew@chromeorange.co.uk\";s:11:\"POST_rating\";s:1:\"3\";s:12:\"POST_comment\";s:136:\"You only get the picture, not the person holding it, something they don\'t mention in the description, now I\'ve got to find my own person\";s:7:\"POST__n\";s:10:\"a80bd2f042\";s:21:\"POST__wp_http_referer\";s:34:\"/woocommerce/product/flying-ninja/\";s:11:\"POST_submit\";s:13:\"Submit Review\";s:20:\"POST_comment_post_ID\";s:2:\"70\";s:19:\"POST_comment_parent\";s:1:\"0\";s:26:\"POST_akismet_comment_nonce\";s:10:\"09a0ca91cf\";s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:33:\"/woocommerce/wp-comments-post.php\";s:15:\"REDIRECT_IS_WPE\";s:1:\"1\";s:27:\"REDIRECT_WPE_CAN_WRITE_DISK\";s:1:\"0\";s:15:\"REDIRECT_STATUS\";s:3:\"200\";s:6:\"IS_WPE\";s:1:\"1\";s:18:\"WPE_CAN_WRITE_DISK\";s:1:\"0\";s:9:\"HTTP_HOST\";s:19:\"demo2.woothemes.com\";s:13:\"HTTP_X_LB_KEY\";s:8:\"woodemo2\";s:13:\"HTTP_X_IS_BOT\";s:1:\"0\";s:15:\"HTTP_USER_AGENT\";s:81:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:21.0) Gecko/20100101 Firefox/21.0\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.5\";s:20:\"HTTP_ACCEPT_ENCODING\";s:13:\"gzip, deflate\";s:12:\"HTTP_REFERER\";s:60:\"http://demo2.woothemes.com/woocommerce/product/flying-ninja/\";s:11:\"HTTP_COOKIE\";s:0:\"\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"375\";s:4:\"PATH\";s:28:\"/usr/local/bin:/usr/bin:/bin\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:11:\"SERVER_NAME\";s:19:\"demo2.woothemes.com\";s:11:\"SERVER_ADDR\";s:9:\"127.0.0.1\";s:11:\"SERVER_PORT\";s:2:\"80\";s:11:\"REMOTE_ADDR\";s:13:\"86.19.152.140\";s:13:\"DOCUMENT_ROOT\";s:26:\"/nas/wp/www/sites/woodemo2\";s:12:\"SERVER_ADMIN\";s:18:\"[no address given]\";s:15:\"SCRIPT_FILENAME\";s:47:\"/nas/wp/www/sites/woodemo2/wp-comments-post.php\";s:11:\"REMOTE_PORT\";s:5:\"56980\";s:12:\"REDIRECT_URL\";s:33:\"/woocommerce/wp-comments-post.php\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:12:\"QUERY_STRING\";s:0:\"\";s:11:\"SCRIPT_NAME\";s:21:\"/wp-comments-post.php\";s:8:\"PHP_SELF\";s:21:\"/wp-comments-post.php\";s:12:\"REQUEST_TIME\";s:10:\"1370606196\";s:25:\"comment_post_modified_gmt\";s:19:\"2013-06-07 11:25:12\";}");
INSERT INTO `wpge_commentmeta` VALUES("229", "62", "rating", "3");
INSERT INTO `wpge_commentmeta` VALUES("230", "62", "akismet_history", "a:4:{s:4:\"time\";d:1370607938.78227710723876953125;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}");
INSERT INTO `wpge_commentmeta` VALUES("231", "63", "akismet_error", "1370607565");
INSERT INTO `wpge_commentmeta` VALUES("232", "63", "akismet_history", "a:4:{s:4:\"time\";d:1370607565.8578360080718994140625;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}");
INSERT INTO `wpge_commentmeta` VALUES("233", "63", "akismet_as_submitted", "a:66:{s:15:\"comment_post_ID\";i:70;s:14:\"comment_author\";s:11:\"Coen Jacobs\";s:20:\"comment_author_email\";s:18:\"coen@woothemes.com\";s:18:\"comment_author_url\";N;s:15:\"comment_content\";s:60:\"This is my favorite poster. In fact, I\'ve ordered 5 of them!\";s:12:\"comment_type\";s:0:\"\";s:14:\"comment_parent\";i:0;s:7:\"user_ID\";i:0;s:7:\"user_ip\";s:12:\"84.39.28.254\";s:10:\"user_agent\";s:120:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/27.0.1453.110 Safari/537.36\";s:8:\"referrer\";s:60:\"http://demo2.woothemes.com/woocommerce/product/flying-ninja/\";s:4:\"blog\";s:38:\"http://demo2.woothemes.com/woocommerce\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:60:\"http://demo2.woothemes.com/woocommerce/product/flying-ninja/\";s:21:\"akismet_comment_nonce\";s:6:\"passed\";s:11:\"POST_author\";s:11:\"Coen Jacobs\";s:10:\"POST_email\";s:18:\"coen@woothemes.com\";s:11:\"POST_rating\";s:1:\"5\";s:12:\"POST_comment\";s:60:\"This is my favorite poster. In fact, I\'ve ordered 5 of them!\";s:7:\"POST__n\";s:10:\"2145d644a3\";s:21:\"POST__wp_http_referer\";s:34:\"/woocommerce/product/flying-ninja/\";s:11:\"POST_submit\";s:13:\"Submit Review\";s:20:\"POST_comment_post_ID\";s:2:\"70\";s:19:\"POST_comment_parent\";s:1:\"0\";s:26:\"POST_akismet_comment_nonce\";s:10:\"a0ccbdfa0d\";s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:33:\"/woocommerce/wp-comments-post.php\";s:15:\"REDIRECT_IS_WPE\";s:1:\"1\";s:27:\"REDIRECT_WPE_CAN_WRITE_DISK\";s:1:\"0\";s:15:\"REDIRECT_STATUS\";s:3:\"200\";s:6:\"IS_WPE\";s:1:\"1\";s:18:\"WPE_CAN_WRITE_DISK\";s:1:\"0\";s:9:\"HTTP_HOST\";s:19:\"demo2.woothemes.com\";s:13:\"HTTP_X_LB_KEY\";s:8:\"woodemo2\";s:13:\"HTTP_X_IS_BOT\";s:1:\"0\";s:15:\"HTTP_USER_AGENT\";s:120:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/27.0.1453.110 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"CONTENT_LENGTH\";s:3:\"293\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:11:\"HTTP_ORIGIN\";s:26:\"http://demo2.woothemes.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:12:\"HTTP_REFERER\";s:60:\"http://demo2.woothemes.com/woocommerce/product/flying-ninja/\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip,deflate,sdch\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:23:\"en-US,en;q=0.8,nl;q=0.6\";s:11:\"HTTP_COOKIE\";s:0:\"\";s:4:\"PATH\";s:28:\"/usr/local/bin:/usr/bin:/bin\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:11:\"SERVER_NAME\";s:19:\"demo2.woothemes.com\";s:11:\"SERVER_ADDR\";s:9:\"127.0.0.1\";s:11:\"SERVER_PORT\";s:2:\"80\";s:11:\"REMOTE_ADDR\";s:12:\"84.39.28.254\";s:13:\"DOCUMENT_ROOT\";s:26:\"/nas/wp/www/sites/woodemo2\";s:12:\"SERVER_ADMIN\";s:18:\"[no address given]\";s:15:\"SCRIPT_FILENAME\";s:47:\"/nas/wp/www/sites/woodemo2/wp-comments-post.php\";s:11:\"REMOTE_PORT\";s:4:\"8391\";s:12:\"REDIRECT_URL\";s:33:\"/woocommerce/wp-comments-post.php\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:12:\"QUERY_STRING\";s:0:\"\";s:11:\"SCRIPT_NAME\";s:21:\"/wp-comments-post.php\";s:8:\"PHP_SELF\";s:21:\"/wp-comments-post.php\";s:12:\"REQUEST_TIME\";s:10:\"1370607565\";s:25:\"comment_post_modified_gmt\";s:19:\"2013-06-07 11:25:12\";}");
INSERT INTO `wpge_commentmeta` VALUES("234", "63", "rating", "5");
INSERT INTO `wpge_commentmeta` VALUES("235", "63", "akismet_history", "a:4:{s:4:\"time\";d:1370607952.2542870044708251953125;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}");
INSERT INTO `wpge_commentmeta` VALUES("236", "64", "akismet_error", "1370609989");
INSERT INTO `wpge_commentmeta` VALUES("237", "64", "akismet_history", "a:4:{s:4:\"time\";d:1370609989.9351150989532470703125;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}");
INSERT INTO `wpge_commentmeta` VALUES("238", "64", "akismet_as_submitted", "a:64:{s:15:\"comment_post_ID\";i:70;s:14:\"comment_author\";s:6:\"Stuart\";s:20:\"comment_author_email\";s:20:\"stuart@woothemes.com\";s:18:\"comment_author_url\";N;s:15:\"comment_content\";s:79:\"This is a fantastic quality print and is happily hanging framed on my wall now.\";s:12:\"comment_type\";s:0:\"\";s:14:\"comment_parent\";i:0;s:7:\"user_ID\";i:0;s:7:\"user_ip\";s:13:\"82.32.109.140\";s:10:\"user_agent\";s:72:\"Mozilla/5.0 (Windows NT 6.1; WOW64; rv:21.0) Gecko/20100101 Firefox/21.0\";s:8:\"referrer\";s:60:\"http://demo2.woothemes.com/woocommerce/product/flying-ninja/\";s:4:\"blog\";s:38:\"http://demo2.woothemes.com/woocommerce\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:60:\"http://demo2.woothemes.com/woocommerce/product/flying-ninja/\";s:21:\"akismet_comment_nonce\";s:6:\"passed\";s:11:\"POST_author\";s:6:\"Stuart\";s:10:\"POST_email\";s:20:\"stuart@woothemes.com\";s:11:\"POST_rating\";s:1:\"4\";s:12:\"POST_comment\";s:79:\"This is a fantastic quality print and is happily hanging framed on my wall now.\";s:7:\"POST__n\";s:10:\"2145d644a3\";s:21:\"POST__wp_http_referer\";s:34:\"/woocommerce/product/flying-ninja/\";s:11:\"POST_submit\";s:13:\"Submit Review\";s:20:\"POST_comment_post_ID\";s:2:\"70\";s:19:\"POST_comment_parent\";s:1:\"0\";s:26:\"POST_akismet_comment_nonce\";s:10:\"a0ccbdfa0d\";s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:33:\"/woocommerce/wp-comments-post.php\";s:15:\"REDIRECT_IS_WPE\";s:1:\"1\";s:27:\"REDIRECT_WPE_CAN_WRITE_DISK\";s:1:\"0\";s:15:\"REDIRECT_STATUS\";s:3:\"200\";s:6:\"IS_WPE\";s:1:\"1\";s:18:\"WPE_CAN_WRITE_DISK\";s:1:\"0\";s:9:\"HTTP_HOST\";s:19:\"demo2.woothemes.com\";s:13:\"HTTP_X_LB_KEY\";s:8:\"woodemo2\";s:13:\"HTTP_X_IS_BOT\";s:1:\"0\";s:15:\"HTTP_USER_AGENT\";s:72:\"Mozilla/5.0 (Windows NT 6.1; WOW64; rv:21.0) Gecko/20100101 Firefox/21.0\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.5\";s:20:\"HTTP_ACCEPT_ENCODING\";s:13:\"gzip, deflate\";s:12:\"HTTP_REFERER\";s:60:\"http://demo2.woothemes.com/woocommerce/product/flying-ninja/\";s:11:\"HTTP_COOKIE\";s:0:\"\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:14:\"CONTENT_LENGTH\";s:3:\"303\";s:4:\"PATH\";s:28:\"/usr/local/bin:/usr/bin:/bin\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:11:\"SERVER_NAME\";s:19:\"demo2.woothemes.com\";s:11:\"SERVER_ADDR\";s:9:\"127.0.0.1\";s:11:\"SERVER_PORT\";s:2:\"80\";s:11:\"REMOTE_ADDR\";s:13:\"82.32.109.140\";s:13:\"DOCUMENT_ROOT\";s:26:\"/nas/wp/www/sites/woodemo2\";s:12:\"SERVER_ADMIN\";s:18:\"[no address given]\";s:15:\"SCRIPT_FILENAME\";s:47:\"/nas/wp/www/sites/woodemo2/wp-comments-post.php\";s:11:\"REMOTE_PORT\";s:5:\"39257\";s:12:\"REDIRECT_URL\";s:33:\"/woocommerce/wp-comments-post.php\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:12:\"QUERY_STRING\";s:0:\"\";s:11:\"SCRIPT_NAME\";s:21:\"/wp-comments-post.php\";s:8:\"PHP_SELF\";s:21:\"/wp-comments-post.php\";s:12:\"REQUEST_TIME\";s:10:\"1370609989\";s:25:\"comment_post_modified_gmt\";s:19:\"2013-06-07 11:25:12\";}");
INSERT INTO `wpge_commentmeta` VALUES("239", "64", "rating", "4");
INSERT INTO `wpge_commentmeta` VALUES("240", "64", "akismet_history", "a:4:{s:4:\"time\";d:1370611523.6167409420013427734375;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}");
INSERT INTO `wpge_commentmeta` VALUES("241", "65", "akismet_error", "1370608744");
INSERT INTO `wpge_commentmeta` VALUES("242", "65", "akismet_history", "a:4:{s:4:\"time\";d:1370608744.324286937713623046875;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}");
INSERT INTO `wpge_commentmeta` VALUES("243", "65", "akismet_as_submitted", "a:66:{s:15:\"comment_post_ID\";i:73;s:14:\"comment_author\";s:3:\"Dan\";s:20:\"comment_author_email\";s:17:\"dan@woothemes.com\";s:18:\"comment_author_url\";N;s:15:\"comment_content\";s:135:\"I thought I was buying a man holding a poster, but when it arrived it was just the poster. Cool poster though, so I\'ll give it 3 stars!\";s:12:\"comment_type\";s:0:\"\";s:14:\"comment_parent\";i:0;s:7:\"user_ID\";i:0;s:7:\"user_ip\";s:13:\"188.221.1.167\";s:10:\"user_agent\";s:120:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/27.0.1453.110 Safari/537.36\";s:8:\"referrer\";s:65:\"http://demo2.woothemes.com/woocommerce/product/premium-quality-2/\";s:4:\"blog\";s:38:\"http://demo2.woothemes.com/woocommerce\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:65:\"http://demo2.woothemes.com/woocommerce/product/premium-quality-2/\";s:21:\"akismet_comment_nonce\";s:6:\"passed\";s:11:\"POST_author\";s:3:\"Dan\";s:10:\"POST_email\";s:17:\"dan@woothemes.com\";s:11:\"POST_rating\";s:1:\"3\";s:12:\"POST_comment\";s:135:\"I thought I was buying a man holding a poster, but when it arrived it was just the poster. Cool poster though, so I\'ll give it 3 stars!\";s:7:\"POST__n\";s:10:\"2145d644a3\";s:21:\"POST__wp_http_referer\";s:39:\"/woocommerce/product/premium-quality-2/\";s:11:\"POST_submit\";s:13:\"Submit Review\";s:20:\"POST_comment_post_ID\";s:2:\"73\";s:19:\"POST_comment_parent\";s:1:\"0\";s:26:\"POST_akismet_comment_nonce\";s:10:\"441b7bcdc8\";s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:33:\"/woocommerce/wp-comments-post.php\";s:15:\"REDIRECT_IS_WPE\";s:1:\"1\";s:27:\"REDIRECT_WPE_CAN_WRITE_DISK\";s:1:\"0\";s:15:\"REDIRECT_STATUS\";s:3:\"200\";s:6:\"IS_WPE\";s:1:\"1\";s:18:\"WPE_CAN_WRITE_DISK\";s:1:\"0\";s:9:\"HTTP_HOST\";s:19:\"demo2.woothemes.com\";s:13:\"HTTP_X_LB_KEY\";s:8:\"woodemo2\";s:13:\"HTTP_X_IS_BOT\";s:1:\"0\";s:15:\"HTTP_USER_AGENT\";s:120:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/27.0.1453.110 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"CONTENT_LENGTH\";s:3:\"366\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:11:\"HTTP_ORIGIN\";s:26:\"http://demo2.woothemes.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:12:\"HTTP_REFERER\";s:65:\"http://demo2.woothemes.com/woocommerce/product/premium-quality-2/\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip,deflate,sdch\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.8\";s:11:\"HTTP_COOKIE\";s:0:\"\";s:4:\"PATH\";s:28:\"/usr/local/bin:/usr/bin:/bin\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:11:\"SERVER_NAME\";s:19:\"demo2.woothemes.com\";s:11:\"SERVER_ADDR\";s:9:\"127.0.0.1\";s:11:\"SERVER_PORT\";s:2:\"80\";s:11:\"REMOTE_ADDR\";s:13:\"188.221.1.167\";s:13:\"DOCUMENT_ROOT\";s:26:\"/nas/wp/www/sites/woodemo2\";s:12:\"SERVER_ADMIN\";s:18:\"[no address given]\";s:15:\"SCRIPT_FILENAME\";s:47:\"/nas/wp/www/sites/woodemo2/wp-comments-post.php\";s:11:\"REMOTE_PORT\";s:5:\"22513\";s:12:\"REDIRECT_URL\";s:33:\"/woocommerce/wp-comments-post.php\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:12:\"QUERY_STRING\";s:0:\"\";s:11:\"SCRIPT_NAME\";s:21:\"/wp-comments-post.php\";s:8:\"PHP_SELF\";s:21:\"/wp-comments-post.php\";s:12:\"REQUEST_TIME\";s:10:\"1370608744\";s:25:\"comment_post_modified_gmt\";s:19:\"2013-06-07 11:27:38\";}");
INSERT INTO `wpge_commentmeta` VALUES("244", "65", "rating", "3");
INSERT INTO `wpge_commentmeta` VALUES("245", "65", "akismet_history", "a:4:{s:4:\"time\";d:1370609036.19725894927978515625;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}");
INSERT INTO `wpge_commentmeta` VALUES("246", "66", "akismet_error", "1370620529");
INSERT INTO `wpge_commentmeta` VALUES("247", "66", "akismet_history", "a:4:{s:4:\"time\";d:1370620529.737782001495361328125;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}");
INSERT INTO `wpge_commentmeta` VALUES("248", "66", "akismet_as_submitted", "");
INSERT INTO `wpge_commentmeta` VALUES("249", "66", "rating", "1");
INSERT INTO `wpge_commentmeta` VALUES("250", "66", "akismet_history", "a:4:{s:4:\"time\";d:1370620633.7349870204925537109375;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}");
INSERT INTO `wpge_commentmeta` VALUES("251", "67", "akismet_error", "1370620584");
INSERT INTO `wpge_commentmeta` VALUES("252", "67", "akismet_history", "a:4:{s:4:\"time\";d:1370620584.252111911773681640625;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}");
INSERT INTO `wpge_commentmeta` VALUES("253", "67", "akismet_as_submitted", "a:66:{s:15:\"comment_post_ID\";i:76;s:14:\"comment_author\";s:5:\"Maria\";s:20:\"comment_author_email\";s:19:\"maria@woothemes.com\";s:18:\"comment_author_url\";N;s:15:\"comment_content\";s:44:\"He really is the cutest little man. Swoooon!\";s:12:\"comment_type\";s:0:\"\";s:14:\"comment_parent\";i:0;s:7:\"user_ID\";i:0;s:7:\"user_ip\";s:13:\"24.225.103.32\";s:10:\"user_agent\";s:120:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/27.0.1453.110 Safari/537.36\";s:8:\"referrer\";s:59:\"http://demo2.woothemes.com/woocommerce/product/woo-ninja-3/\";s:4:\"blog\";s:38:\"http://demo2.woothemes.com/woocommerce\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:59:\"http://demo2.woothemes.com/woocommerce/product/woo-ninja-3/\";s:21:\"akismet_comment_nonce\";s:6:\"passed\";s:11:\"POST_author\";s:5:\"Maria\";s:10:\"POST_email\";s:19:\"maria@woothemes.com\";s:11:\"POST_rating\";s:1:\"4\";s:12:\"POST_comment\";s:45:\"He really is the cutest little man. Swoooon! \";s:7:\"POST__n\";s:10:\"2145d644a3\";s:21:\"POST__wp_http_referer\";s:33:\"/woocommerce/product/woo-ninja-3/\";s:11:\"POST_submit\";s:13:\"Submit Review\";s:20:\"POST_comment_post_ID\";s:2:\"76\";s:19:\"POST_comment_parent\";s:1:\"0\";s:26:\"POST_akismet_comment_nonce\";s:10:\"29cab5ecf2\";s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:33:\"/woocommerce/wp-comments-post.php\";s:15:\"REDIRECT_IS_WPE\";s:1:\"1\";s:27:\"REDIRECT_WPE_CAN_WRITE_DISK\";s:1:\"0\";s:15:\"REDIRECT_STATUS\";s:3:\"200\";s:6:\"IS_WPE\";s:1:\"1\";s:18:\"WPE_CAN_WRITE_DISK\";s:1:\"0\";s:9:\"HTTP_HOST\";s:19:\"demo2.woothemes.com\";s:13:\"HTTP_X_LB_KEY\";s:8:\"woodemo2\";s:13:\"HTTP_X_IS_BOT\";s:1:\"0\";s:15:\"HTTP_USER_AGENT\";s:120:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/27.0.1453.110 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"CONTENT_LENGTH\";s:3:\"268\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:11:\"HTTP_ORIGIN\";s:26:\"http://demo2.woothemes.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:12:\"HTTP_REFERER\";s:59:\"http://demo2.woothemes.com/woocommerce/product/woo-ninja-3/\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip,deflate,sdch\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.8\";s:11:\"HTTP_COOKIE\";s:0:\"\";s:4:\"PATH\";s:28:\"/usr/local/bin:/usr/bin:/bin\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:11:\"SERVER_NAME\";s:19:\"demo2.woothemes.com\";s:11:\"SERVER_ADDR\";s:9:\"127.0.0.1\";s:11:\"SERVER_PORT\";s:2:\"80\";s:11:\"REMOTE_ADDR\";s:13:\"24.225.103.32\";s:13:\"DOCUMENT_ROOT\";s:26:\"/nas/wp/www/sites/woodemo2\";s:12:\"SERVER_ADMIN\";s:18:\"[no address given]\";s:15:\"SCRIPT_FILENAME\";s:47:\"/nas/wp/www/sites/woodemo2/wp-comments-post.php\";s:11:\"REMOTE_PORT\";s:5:\"28885\";s:12:\"REDIRECT_URL\";s:33:\"/woocommerce/wp-comments-post.php\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:12:\"QUERY_STRING\";s:0:\"\";s:11:\"SCRIPT_NAME\";s:21:\"/wp-comments-post.php\";s:8:\"PHP_SELF\";s:21:\"/wp-comments-post.php\";s:12:\"REQUEST_TIME\";s:10:\"1370620584\";s:25:\"comment_post_modified_gmt\";s:19:\"2013-06-07 11:28:45\";}");
INSERT INTO `wpge_commentmeta` VALUES("254", "67", "rating", "4");
INSERT INTO `wpge_commentmeta` VALUES("255", "67", "akismet_history", "a:4:{s:4:\"time\";d:1370620633.352140903472900390625;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}");
INSERT INTO `wpge_commentmeta` VALUES("266", "78", "akismet_error", "1370606279");
INSERT INTO `wpge_commentmeta` VALUES("267", "78", "akismet_history", "a:4:{s:4:\"time\";d:1370606279.836287975311279296875;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}");
INSERT INTO `wpge_commentmeta` VALUES("268", "78", "akismet_as_submitted", "a:67:{s:15:\"comment_post_ID\";i:47;s:14:\"comment_author\";s:12:\"Cobus Bester\";s:20:\"comment_author_email\";s:18:\"bester.c@gmail.com\";s:18:\"comment_author_url\";N;s:15:\"comment_content\";s:71:\"This hoodie is great for those chilly winter days. I love the WooNinja!\";s:12:\"comment_type\";s:0:\"\";s:14:\"comment_parent\";i:0;s:7:\"user_ID\";i:0;s:7:\"user_ip\";s:13:\"196.215.9.147\";s:10:\"user_agent\";s:119:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_3) AppleWebKit/537.31 (KHTML, like Gecko) Chrome/26.0.1410.65 Safari/537.31\";s:8:\"referrer\";s:59:\"http://demo2.woothemes.com/woocommerce/product/woo-ninja-2/\";s:4:\"blog\";s:38:\"http://demo2.woothemes.com/woocommerce\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:59:\"http://demo2.woothemes.com/woocommerce/product/woo-ninja-2/\";s:21:\"akismet_comment_nonce\";s:6:\"passed\";s:11:\"POST_author\";s:12:\"Cobus Bester\";s:10:\"POST_email\";s:18:\"bester.c@gmail.com\";s:11:\"POST_rating\";s:1:\"5\";s:12:\"POST_comment\";s:71:\"This hoodie is great for those chilly winter days. I love the WooNinja!\";s:7:\"POST__n\";s:10:\"a80bd2f042\";s:21:\"POST__wp_http_referer\";s:33:\"/woocommerce/product/woo-ninja-2/\";s:11:\"POST_submit\";s:13:\"Submit Review\";s:20:\"POST_comment_post_ID\";s:2:\"47\";s:19:\"POST_comment_parent\";s:1:\"0\";s:26:\"POST_akismet_comment_nonce\";s:10:\"38d66a284b\";s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:33:\"/woocommerce/wp-comments-post.php\";s:15:\"REDIRECT_IS_WPE\";s:1:\"1\";s:27:\"REDIRECT_WPE_CAN_WRITE_DISK\";s:1:\"0\";s:15:\"REDIRECT_STATUS\";s:3:\"200\";s:6:\"IS_WPE\";s:1:\"1\";s:18:\"WPE_CAN_WRITE_DISK\";s:1:\"0\";s:9:\"HTTP_HOST\";s:19:\"demo2.woothemes.com\";s:13:\"HTTP_X_LB_KEY\";s:8:\"woodemo2\";s:13:\"HTTP_X_IS_BOT\";s:1:\"0\";s:15:\"HTTP_USER_AGENT\";s:119:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_3) AppleWebKit/537.31 (KHTML, like Gecko) Chrome/26.0.1410.65 Safari/537.31\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"CONTENT_LENGTH\";s:3:\"300\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:11:\"HTTP_ORIGIN\";s:26:\"http://demo2.woothemes.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:12:\"HTTP_REFERER\";s:59:\"http://demo2.woothemes.com/woocommerce/product/woo-ninja-2/\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip,deflate,sdch\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.8\";s:19:\"HTTP_ACCEPT_CHARSET\";s:30:\"ISO-8859-1,utf-8;q=0.7,*;q=0.3\";s:11:\"HTTP_COOKIE\";s:0:\"\";s:4:\"PATH\";s:28:\"/usr/local/bin:/usr/bin:/bin\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:11:\"SERVER_NAME\";s:19:\"demo2.woothemes.com\";s:11:\"SERVER_ADDR\";s:9:\"127.0.0.1\";s:11:\"SERVER_PORT\";s:2:\"80\";s:11:\"REMOTE_ADDR\";s:13:\"196.215.9.147\";s:13:\"DOCUMENT_ROOT\";s:26:\"/nas/wp/www/sites/woodemo2\";s:12:\"SERVER_ADMIN\";s:18:\"[no address given]\";s:15:\"SCRIPT_FILENAME\";s:47:\"/nas/wp/www/sites/woodemo2/wp-comments-post.php\";s:11:\"REMOTE_PORT\";s:5:\"58209\";s:12:\"REDIRECT_URL\";s:33:\"/woocommerce/wp-comments-post.php\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:12:\"QUERY_STRING\";s:0:\"\";s:11:\"SCRIPT_NAME\";s:21:\"/wp-comments-post.php\";s:8:\"PHP_SELF\";s:21:\"/wp-comments-post.php\";s:12:\"REQUEST_TIME\";s:10:\"1370606279\";s:25:\"comment_post_modified_gmt\";s:19:\"2013-06-07 11:18:45\";}");
INSERT INTO `wpge_commentmeta` VALUES("269", "78", "rating", "5");
INSERT INTO `wpge_commentmeta` VALUES("270", "78", "akismet_history", "a:4:{s:4:\"time\";d:1370607944.7811119556427001953125;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}");
INSERT INTO `wpge_commentmeta` VALUES("271", "79", "akismet_error", "1370620393");
INSERT INTO `wpge_commentmeta` VALUES("272", "79", "akismet_history", "a:4:{s:4:\"time\";d:1370620393.6741259098052978515625;s:7:\"message\";s:92:\"Akismet was unable to check this comment (response: ), will automatically retry again later.\";s:5:\"event\";s:11:\"check-error\";s:4:\"user\";s:0:\"\";}");
INSERT INTO `wpge_commentmeta` VALUES("273", "79", "akismet_as_submitted", "a:66:{s:15:\"comment_post_ID\";i:47;s:14:\"comment_author\";s:5:\"Maria\";s:20:\"comment_author_email\";s:19:\"maria@woothemes.com\";s:18:\"comment_author_url\";N;s:15:\"comment_content\";s:40:\"Perfect for the lady Ninja in your life!\";s:12:\"comment_type\";s:0:\"\";s:14:\"comment_parent\";i:0;s:7:\"user_ID\";i:0;s:7:\"user_ip\";s:13:\"24.225.103.32\";s:10:\"user_agent\";s:120:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/27.0.1453.110 Safari/537.36\";s:8:\"referrer\";s:59:\"http://demo2.woothemes.com/woocommerce/product/woo-ninja-2/\";s:4:\"blog\";s:38:\"http://demo2.woothemes.com/woocommerce\";s:9:\"blog_lang\";s:5:\"en_US\";s:12:\"blog_charset\";s:5:\"UTF-8\";s:9:\"permalink\";s:59:\"http://demo2.woothemes.com/woocommerce/product/woo-ninja-2/\";s:21:\"akismet_comment_nonce\";s:6:\"passed\";s:11:\"POST_author\";s:5:\"Maria\";s:10:\"POST_email\";s:19:\"maria@woothemes.com\";s:11:\"POST_rating\";s:1:\"4\";s:12:\"POST_comment\";s:40:\"Perfect for the lady Ninja in your life!\";s:7:\"POST__n\";s:10:\"2145d644a3\";s:21:\"POST__wp_http_referer\";s:33:\"/woocommerce/product/woo-ninja-2/\";s:11:\"POST_submit\";s:13:\"Submit Review\";s:20:\"POST_comment_post_ID\";s:2:\"47\";s:19:\"POST_comment_parent\";s:1:\"0\";s:26:\"POST_akismet_comment_nonce\";s:10:\"ade950552e\";s:15:\"SERVER_SOFTWARE\";s:6:\"Apache\";s:11:\"REQUEST_URI\";s:33:\"/woocommerce/wp-comments-post.php\";s:15:\"REDIRECT_IS_WPE\";s:1:\"1\";s:27:\"REDIRECT_WPE_CAN_WRITE_DISK\";s:1:\"0\";s:15:\"REDIRECT_STATUS\";s:3:\"200\";s:6:\"IS_WPE\";s:1:\"1\";s:18:\"WPE_CAN_WRITE_DISK\";s:1:\"0\";s:9:\"HTTP_HOST\";s:19:\"demo2.woothemes.com\";s:13:\"HTTP_X_LB_KEY\";s:8:\"woodemo2\";s:13:\"HTTP_X_IS_BOT\";s:1:\"0\";s:15:\"HTTP_USER_AGENT\";s:120:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/27.0.1453.110 Safari/537.36\";s:15:\"HTTP_CONNECTION\";s:5:\"close\";s:14:\"CONTENT_LENGTH\";s:3:\"263\";s:18:\"HTTP_CACHE_CONTROL\";s:9:\"max-age=0\";s:11:\"HTTP_ACCEPT\";s:63:\"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\";s:11:\"HTTP_ORIGIN\";s:26:\"http://demo2.woothemes.com\";s:12:\"CONTENT_TYPE\";s:33:\"application/x-www-form-urlencoded\";s:12:\"HTTP_REFERER\";s:59:\"http://demo2.woothemes.com/woocommerce/product/woo-ninja-2/\";s:20:\"HTTP_ACCEPT_ENCODING\";s:17:\"gzip,deflate,sdch\";s:20:\"HTTP_ACCEPT_LANGUAGE\";s:14:\"en-US,en;q=0.8\";s:11:\"HTTP_COOKIE\";s:0:\"\";s:4:\"PATH\";s:28:\"/usr/local/bin:/usr/bin:/bin\";s:16:\"SERVER_SIGNATURE\";s:0:\"\";s:11:\"SERVER_NAME\";s:19:\"demo2.woothemes.com\";s:11:\"SERVER_ADDR\";s:9:\"127.0.0.1\";s:11:\"SERVER_PORT\";s:2:\"80\";s:11:\"REMOTE_ADDR\";s:13:\"24.225.103.32\";s:13:\"DOCUMENT_ROOT\";s:26:\"/nas/wp/www/sites/woodemo2\";s:12:\"SERVER_ADMIN\";s:18:\"[no address given]\";s:15:\"SCRIPT_FILENAME\";s:47:\"/nas/wp/www/sites/woodemo2/wp-comments-post.php\";s:11:\"REMOTE_PORT\";s:5:\"26829\";s:12:\"REDIRECT_URL\";s:33:\"/woocommerce/wp-comments-post.php\";s:17:\"GATEWAY_INTERFACE\";s:7:\"CGI/1.1\";s:15:\"SERVER_PROTOCOL\";s:8:\"HTTP/1.0\";s:14:\"REQUEST_METHOD\";s:4:\"POST\";s:12:\"QUERY_STRING\";s:0:\"\";s:11:\"SCRIPT_NAME\";s:21:\"/wp-comments-post.php\";s:8:\"PHP_SELF\";s:21:\"/wp-comments-post.php\";s:12:\"REQUEST_TIME\";s:10:\"1370620393\";s:25:\"comment_post_modified_gmt\";s:19:\"2013-06-07 11:18:45\";}");
INSERT INTO `wpge_commentmeta` VALUES("274", "79", "rating", "4");
INSERT INTO `wpge_commentmeta` VALUES("275", "79", "akismet_history", "a:4:{s:4:\"time\";d:1370620633.94254302978515625;s:7:\"message\";s:46:\"wooteam changed the comment status to approved\";s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:7:\"wooteam\";}");
INSERT INTO `wpge_commentmeta` VALUES("276", "78", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("277", "79", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("278", "65", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("279", "66", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("280", "49", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("281", "50", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("282", "54", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("283", "55", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("284", "56", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("285", "67", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("286", "51", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("287", "52", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("288", "53", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("289", "57", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("290", "58", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("291", "59", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("292", "60", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("293", "61", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("294", "62", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("295", "63", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("296", "64", "verified", "0");
INSERT INTO `wpge_commentmeta` VALUES("297", "48", "verified", "0");

/* INSERT TABLE DATA: wpge_comments */
INSERT INTO `wpge_comments` VALUES("46", "2635", "* * * Apple iPhone 15 Free: https://www.personalportnoy.com/upload/169kg5.php * * * hs=ef42d1c37602849486c5689ad8a22cb5*", "okebepu@merepost.com", "", "185.220.101.54", "2024-08-02 14:22:40", "2024-08-02 14:22:40", "3wdy60", "0", "post-trashed", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36", "review", "0", "0");
INSERT INTO `wpge_comments` VALUES("47", "2646", "apesiat", "BruiliGal@mailport.lat", "", "37.139.53.191", "2024-08-07 22:31:17", "2024-08-07 22:31:17", "Complete occlusion of the aortopulmonary septal defect with an Amplatzer Duct Occluder <a href=\"https://cialis.lat/discover-the-best-prices-for-cialis\" rel=\"nofollow ugc\">buy generic cialis online cheap</a> Among these SERMs, raloxifene may be the most attractive agent based on the evidence from five recent large trials Multiple Outcomes of Raloxifene Evaluation MORE, Continuing Outcomes Relevant to Evista CORE, Raloxifene Use for the Heart RUTH, Study of Tamoxifen and Raloxifene STAR, and Evista Versus Alendronate EVA", "0", "post-trashed", "Mozilla/5.0 (Windows NT 10.0.0; Win64; x64; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.6367.78 Chrome/124.0.6367.78 Not-A.Brand/99  Safari/537.36", "review", "0", "0");
INSERT INTO `wpge_comments` VALUES("45", "2648", "* * * Apple iPhone 15 Free: https://www.bonjourlesenfants.net/upload/04oytb.php * * * hs=b8222f75fa06958802ec8b01e874e7c1*", "okebepu@merepost.com", "", "87.118.116.90", "2024-08-02 14:22:23", "2024-08-02 14:22:23", "kdb2fl", "0", "post-trashed", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36", "review", "0", "0");
INSERT INTO `wpge_comments` VALUES("43", "2642", "PreelaLat", "BeareeFuh@newonlinemail.xyz", "", "46.161.11.4", "2022-05-18 10:21:10", "2022-05-18 10:21:10", "Buy Diflucan Without No Perscription Sywhrh https://newfasttadalafil.com/ - generic cialis 20mg Cytotec Vaginal <a href=\"https://newfasttadalafil.com/\" / rel=\"nofollow ugc\">canadian pharmacy cialis</a> Ompiet Cialis Sicuro Online Amoxicillin Mexico https://newfasttadalafil.com/ - cialis prescription online", "0", "post-trashed", "Mozilla/5.0 (Windows NT 6.2; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36", "review", "0", "0");
INSERT INTO `wpge_comments` VALUES("44", "2646", "Leasiabig", "Leasiabig@maill1.xyz", "", "46.161.11.144", "2022-06-02 22:46:22", "2022-06-02 22:46:22", "https://newfasttadalafil.com/ - Cialis cialis canadian generic <a href=\"https://newfasttadalafil.com/\" / rel=\"nofollow ugc\">cialis on sale in usa</a> Doxycycline Malaria Buy Online how long after cialis exercise https://newfasttadalafil.com/ - generic cialis no prescription", "0", "post-trashed", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36 Edg/90.0.818.42", "review", "0", "0");
INSERT INTO `wpge_comments` VALUES("42", "2635", "PreelaLat", "BeareeFuh@newonlinemail.xyz", "", "46.161.11.4", "2022-05-17 13:59:46", "2022-05-17 13:59:46", "https://newfasttadalafil.com/ - discount cialis Priligy 30 Mg Presentacion Lzjsuv <a href=\"https://newfasttadalafil.com/\" / rel=\"nofollow ugc\">Cialis</a> Amoxicillin Dosage For Dog Viplgr Viagra 100mg Filmtabletten Gunstig https://newfasttadalafil.com/ - Cialis Comprar Cialis Online Opiniones", "0", "post-trashed", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.72 Safari/537.36", "review", "0", "0");
INSERT INTO `wpge_comments` VALUES("48", "15", "Cobus Bester", "bester.c@gmail.com", "", "196.215.9.147", "2013-06-07 11:57:05", "2013-06-07 11:57:05", "Simple and effective design. One of my favorites.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wpge_comments` VALUES("49", "37", "Stuart", "stuart@woothemes.com", "", "82.32.109.140", "2013-06-07 13:01:25", "2013-06-07 13:01:25", "This will go great with my Hoodie that I ordered a few weeks ago.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wpge_comments` VALUES("50", "37", "Maria", "maria@woothemes.com", "", "24.225.103.32", "2013-06-07 15:49:53", "2013-06-07 15:49:53", "Love this shirt! The ninja near and dear to my heart. &lt;3", "0", "1", "", "comment", "0", "0");
INSERT INTO `wpge_comments` VALUES("51", "40", "Stuart", "stuart@woothemes.com", "", "82.32.109.140", "2013-06-07 13:03:29", "2013-06-07 13:03:29", "Another great quality product that anyone who see\'s me wearing has asked where to purchase one of their own.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wpge_comments` VALUES("52", "40", "Ryan", "ryan@woothemes.com", "", "99.153.225.252", "2013-06-07 13:24:52", "2013-06-07 13:24:52", "This hoodie gets me lots of looks while out in public, I got the blue one and it\'s awesome. Not sure if people are looking at my hoodie only, or also at my rocking bod.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wpge_comments` VALUES("53", "40", "Maria", "maria@woothemes.com", "", "24.225.103.32", "2013-06-07 15:53:31", "2013-06-07 15:53:31", "Ship it!", "0", "1", "", "comment", "0", "0");
INSERT INTO `wpge_comments` VALUES("54", "50", "James Koster", "james@jameskoster.co.uk", "", "86.146.141.82", "2013-06-07 11:46:52", "2013-06-07 11:46:52", "Perfect when you\'re sat at your computer, waiting for the next batch of Woo Goodies to be released. The Patient Ninja is Patient.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wpge_comments` VALUES("55", "50", "Cobus Bester", "bester.c@gmail.com", "", "196.215.9.147", "2013-06-07 11:53:13", "2013-06-07 11:53:13", "The most comfortable hoodie I have ever owned!", "0", "1", "", "comment", "0", "0");
INSERT INTO `wpge_comments` VALUES("56", "50", "Magnus", "magnus@woothemes.com", "", "79.161.106.35", "2013-06-07 12:04:03", "2013-06-07 12:04:03", "This is my favorite hoodie!\n\nIf only it came in red as well!", "0", "1", "", "comment", "0", "0");
INSERT INTO `wpge_comments` VALUES("57", "53", "Andrew", "andrew@chromeorange.co.uk", "", "86.19.152.140", "2013-06-07 11:54:51", "2013-06-07 11:54:51", "I bought this thinking it was a nice green colour, apparently it GREY! I\'m colour blind so I don\'t care but my girlfriend says grey makes me look fat", "0", "1", "", "comment", "0", "0");
INSERT INTO `wpge_comments` VALUES("58", "53", "Maria", "maria@woothemes.com", "", "24.225.103.32", "2013-06-07 15:50:22", "2013-06-07 15:50:22", "I love grey hoodies! This is perfect with my grey Ninja shirt, when I get cold I throw this on and I can still be a Ninja.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wpge_comments` VALUES("59", "60", "Magnus", "magnus@woothemes.com", "", "79.161.106.35", "2013-06-07 12:04:33", "2013-06-07 12:04:33", "I like the logo but not the color.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wpge_comments` VALUES("60", "60", "Maria", "maria@woothemes.com", "", "24.225.103.32", "2013-06-07 15:54:25", "2013-06-07 15:54:25", "Three letters, one word: WOO!", "0", "1", "", "comment", "0", "0");
INSERT INTO `wpge_comments` VALUES("61", "70", "Cobus Bester", "bester.c@gmail.com", "", "196.215.9.147", "2013-06-07 11:52:25", "2013-06-07 11:52:25", "Really happy with this print. The colors are great, and the paper quality is good too.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wpge_comments` VALUES("62", "70", "Andrew", "andrew@chromeorange.co.uk", "", "86.19.152.140", "2013-06-07 11:56:36", "2013-06-07 11:56:36", "You only get the picture, not the person holding it, something they don\'t mention in the description, now I\'ve got to find my own person", "0", "1", "", "comment", "0", "0");
INSERT INTO `wpge_comments` VALUES("63", "70", "Coen Jacobs", "coen@woothemes.com", "", "84.39.28.254", "2013-06-07 12:19:25", "2013-06-07 12:19:25", "This is my favorite poster. In fact, I\'ve ordered 5 of them!", "0", "1", "", "comment", "0", "0");
INSERT INTO `wpge_comments` VALUES("64", "70", "Stuart", "stuart@woothemes.com", "", "82.32.109.140", "2013-06-07 12:59:49", "2013-06-07 12:59:49", "This is a fantastic quality print and is happily hanging framed on my wall now.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wpge_comments` VALUES("65", "73", "Dan", "dan@woothemes.com", "", "188.221.1.167", "2013-06-07 12:39:04", "2013-06-07 12:39:04", "I thought I was buying a man holding a poster, but when it arrived it was just the poster. Cool poster though, so I\'ll give it 3 stars!", "0", "1", "", "comment", "0", "0");
INSERT INTO `wpge_comments` VALUES("66", "73", "Maria", "maria@woothemes.com", "", "24.225.103.32", "2013-06-07 15:55:29", "2013-06-07 15:55:29", "I didn\'t expect this poster to arrive folded. Now there are lines on the poster and one sad Ninja.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wpge_comments` VALUES("67", "76", "Maria", "maria@woothemes.com", "", "24.225.103.32", "2013-06-07 15:56:24", "2013-06-07 15:56:24", "He really is the cutest little man. Swoooon!", "0", "1", "", "comment", "0", "0");
INSERT INTO `wpge_comments` VALUES("70", "269", "admin", "admin@admin.com", "", "127.0.0.1", "2012-03-01 02:58:12", "2012-03-01 02:58:12", "Duis scelerisque malesuada dui, euismod sodales libero ullamcorper sed. Curabitur eleifend mattis velit, gravida posuere mauris dapibus non. Curabitur molestie molestie quam.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wpge_comments` VALUES("71", "269", "Transparent", "admin@admin.com", "", "127.0.0.1", "2012-03-01 02:58:25", "2012-03-01 02:58:25", "Duis scelerisque malesuada dui, euismod sodales libero ullamcorper sed. Curabitur eleifend mattis velit, gravida posuere mauris dapibus non. Curabitur molestie molestie quam.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wpge_comments` VALUES("72", "269", "Dan Mikhael", "admin@admin.com", "", "127.0.0.1", "2012-03-01 02:58:47", "2012-03-01 02:58:47", "Duis scelerisque malesuada dui, euismod sodales libero ullamcorper sed. Curabitur eleifend mattis velit, gravida posuere mauris dapibus non. Curabitur molestie molestie quam.", "0", "1", "", "comment", "70", "0");
INSERT INTO `wpge_comments` VALUES("73", "269", "Adam", "admin@admin.com", "", "127.0.0.1", "2012-03-01 03:01:27", "2012-03-01 03:01:27", "Duis scelerisque malesuada dui, euismod sodales libero ullamcorper sed. Curabitur eleifend mattis velit, gravida posuere mauris dapibus non. Curabitur molestie molestie quam.", "0", "1", "", "comment", "70", "0");
INSERT INTO `wpge_comments` VALUES("74", "269", "Gabby", "admin@admin.com", "", "127.0.0.1", "2012-03-01 03:01:45", "2012-03-01 03:01:45", "Duis scelerisque malesuada dui, euismod sodales libero ullamcorper sed. Curabitur eleifend mattis velit, gravida posuere mauris dapibus non. Curabitur molestie molestie quam.", "0", "1", "", "comment", "70", "0");
INSERT INTO `wpge_comments` VALUES("75", "269", "sante mutuelle", "admin@admin.com", "", "127.0.0.1", "2012-03-01 03:02:23", "2012-03-01 03:02:23", "Duis scelerisque malesuada dui, euismod sodales libero ullamcorper sed. Curabitur eleifend mattis velit, gravida posuere mauris dapibus non. Curabitur molestie molestie quam.", "0", "1", "", "comment", "73", "0");
INSERT INTO `wpge_comments` VALUES("76", "269", "Sharon thomas", "admin@admin.com", "", "127.0.0.1", "2012-03-01 03:02:34", "2012-03-01 03:02:34", "Duis scelerisque malesuada dui, euismod sodales libero ullamcorper sed. Curabitur eleifend mattis velit, gravida posuere mauris dapibus non. Curabitur molestie molestie quam.", "0", "1", "", "comment", "75", "0");
INSERT INTO `wpge_comments` VALUES("77", "269", "Andrew Benton", "admin@admin.com", "", "127.0.0.1", "2012-03-01 03:02:42", "2012-03-01 03:02:42", "Duis scelerisque malesuada dui, euismod sodales libero ullamcorper sed. Curabitur eleifend mattis velit, gravida posuere mauris dapibus non. Curabitur molestie molestie quam.", "0", "1", "", "comment", "76", "0");
INSERT INTO `wpge_comments` VALUES("78", "2189", "Cobus Bester", "bester.c@gmail.com", "", "196.215.9.147", "2013-06-07 11:57:59", "2013-06-07 11:57:59", "This hoodie is great for those chilly winter days. I love the WooNinja!", "0", "1", "", "comment", "0", "0");
INSERT INTO `wpge_comments` VALUES("79", "2189", "Maria", "maria@woothemes.com", "", "24.225.103.32", "2013-06-07 15:53:13", "2013-06-07 15:53:13", "Perfect for the lady Ninja in your life!", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: wpge_duplicator_packages */
INSERT INTO `wpge_duplicator_packages` VALUES("4", "20250829_josh", "419994340bc08b8e7027_20250907183939", "21", "2025-09-07 18:40:07", "admin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-09-07 18:39:39\";s:7:\"Version\";s:8:\"1.5.13.1\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:5:\"8.4.6\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:4;s:4:\"Name\";s:13:\"20250829_josh\";s:4:\"Hash\";s:35:\"419994340bc08b8e7027_20250907183939\";s:8:\"NameHash\";s:49:\"20250829_josh_419994340bc08b8e7027_20250907183939\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:59:\"20250829_josh_419994340bc08b8e7027_20250907183939_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.2\";s:6:\"WPUser\";s:5:\"admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:1;s:4:\"File\";s:61:\"20250829_josh_419994340bc08b8e7027_20250907183939_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:52:\"/home/hipercom/joshconstructions.hipercomhosting.com\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:0;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:0;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-09-07 18:39:39\";s:7:\"Version\";s:8:\"1.5.13.1\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:5:\"8.4.6\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:13:\"20250829_josh\";s:4:\"Hash\";s:35:\"419994340bc08b8e7027_20250907183939\";s:8:\"NameHash\";s:49:\"20250829_josh_419994340bc08b8e7027_20250907183939\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:67:\"20250829_josh_419994340bc08b8e7027_20250907183939_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:66:\"/home/hipercom/joshconstructions.hipercomhosting.com/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:62:\"20250829_josh_419994340bc08b8e7027_20250907183939_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:147:\"/home/hipercom/joshconstructions.hipercomhosting.com/wp-content/backups-dup-lite/tmp/20250829_josh_419994340bc08b8e7027_20250907183939_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:61:\"/home/hipercom/joshconstructions.hipercomhosting.com/wp-admin\";i:1;s:64:\"/home/hipercom/joshconstructions.hipercomhosting.com/wp-includes\";i:2;s:73:\"/home/hipercom/joshconstructions.hipercomhosting.com/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:52:\"/home/hipercom/joshconstructions.hipercomhosting.com\";i:1;s:52:\"/home/hipercom/joshconstructions.hipercomhosting.com\";i:2;s:63:\"/home/hipercom/joshconstructions.hipercomhosting.com/wp-content\";i:3;s:71:\"/home/hipercom/joshconstructions.hipercomhosting.com/wp-content/uploads\";i:4;s:71:\"/home/hipercom/joshconstructions.hipercomhosting.com/wp-content/plugins\";i:5;s:74:\"/home/hipercom/joshconstructions.hipercomhosting.com/wp-content/mu-plugins\";i:6;s:70:\"/home/hipercom/joshconstructions.hipercomhosting.com/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:84:\"/home/hipercom/joshconstructions.hipercomhosting.com/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wpge_elfsight_yottie_widgets */
INSERT INTO `wpge_elfsight_yottie_widgets` VALUES("1", "Projects", "1756666388", "1756674614", "1", "{\"channel\":\"https://www.youtube.com/@JoshConstructions\",\"sourceGroups\":\"\",\"order\":\"\",\"cacheTime\":\"3600\",\"width\":\"auto\",\"lang\":\"en\",\"headerVisible\":true,\"headerLayout\":\"classic\",\"headerInfo\":[\"logo\",\"banner\",\"channelName\",\"channelDescription\",\"videosCounter\",\"subscribersCounter\",\"viewsCounter\",\"subscribeButton\"],\"headerChannelName\":\"\",\"headerChannelDescription\":\"\",\"headerChannelLogo\":\"\",\"headerChannelBanner\":\"\",\"groupsVisible\":true,\"contentColumns\":\"3\",\"contentRows\":\"1\",\"contentGutter\":\"20\",\"contentArrowsControl\":true,\"contentScrollControl\":false,\"contentDragControl\":true,\"contentPaginationControl\":true,\"contentSearch\":true,\"contentDirection\":\"horizontal\",\"contentFreeMode\":false,\"contentScrollbar\":false,\"contentTransitionEffect\":\"slide\",\"contentTransitionSpeed\":\"600\",\"contentAuto\":\"0\",\"contentAutoPauseOnHover\":false,\"contentResponsive\":\"\",\"videoLayout\":\"classic\",\"videoInfo\":[\"playIcon\",\"duration\",\"title\",\"date\",\"description\",\"viewsCounter\",\"likesCounter\",\"commentsCounter\"],\"videoPlayMode\":\"popup\",\"popupInfo\":[\"title\",\"channelLogo\",\"channelName\",\"subscribeButton\",\"viewsCounter\",\"likesCounter\",\"dislikesCounter\",\"likesRatio\",\"share\",\"date\",\"description\",\"descriptionMoreButton\",\"comments\"],\"popupAutoplay\":true,\"colorScheme\":\"default\",\"colorHeaderBg\":\"rgb(255, 255, 255)\",\"colorHeaderBannerOverlay\":\"rgba(255, 255, 255, 0.81)\",\"colorHeaderChannelName\":\"rgb(34, 34, 34)\",\"colorHeaderChannelNameHover\":\"rgb(47, 165, 255)\",\"colorHeaderChannelDescription\":\"rgb(34, 34, 34)\",\"colorHeaderAnchor\":\"rgb(47, 165, 255)\",\"colorHeaderAnchorHover\":\"rgb(34, 34, 34)\",\"colorHeaderCounters\":\"rgb(102, 102, 102)\",\"colorGroupsBg\":\"rgb(255, 255, 255)\",\"colorGroupsLink\":\"rgb(79, 79, 79)\",\"colorGroupsLinkHover\":\"rgb(79, 79, 79)\",\"colorGroupsLinkActive\":\"rgb(0, 0, 0)\",\"colorGroupsHighlight\":\"rgb(235, 235, 235)\",\"colorGroupsHighlightHover\":\"rgb(255, 0, 0)\",\"colorGroupsHighlightActive\":\"rgb(255, 0, 0)\",\"colorContentBg\":\"rgb(255, 255, 255)\",\"colorContentArrows\":\"rgb(255, 255, 255)\",\"colorContentArrowsHover\":\"rgb(255, 0, 0)\",\"colorContentArrowsBg\":\"rgba(0, 0, 0, 0.4)\",\"colorContentArrowsBgHover\":\"rgba(0, 0, 0, 0.8)\",\"colorContentScrollbarBg\":\"rgb(204, 204, 204)\",\"colorContentScrollbarSliderBg\":\"rgba(0, 0, 0, 0.4)\",\"colorVideoBg\":\"rgb(243, 243, 243)\",\"colorVideoOverlay\":\"rgba(255, 255, 255, 0.9)\",\"colorVideoPlayIcon\":\"rgba(255, 255, 255, 0.4)\",\"colorVideoPlayIconHover\":\"rgba(255, 255, 255, 0.8)\",\"colorVideoDuration\":\"rgb(255, 255, 255)\",\"colorVideoDurationBg\":\"rgba(34, 34, 34, 0.81)\",\"colorVideoTitle\":\"rgb(26, 137, 222)\",\"colorVideoTitleHover\":\"rgb(47, 165, 255)\",\"colorVideoDate\":\"rgb(140, 140, 140)\",\"colorVideoDescription\":\"rgb(34, 34, 34)\",\"colorVideoAnchor\":\"rgb(26, 137, 222)\",\"colorVideoAnchorHover\":\"rgb(47, 165, 255)\",\"colorVideoCounters\":\"rgb(149, 149, 149)\",\"colorPopupBg\":\"rgb(255, 255, 255)\",\"colorPopupOverlay\":\"rgba(0, 0, 0, 0.7)\",\"colorPopupTitle\":\"rgb(34, 34, 34)\",\"colorPopupChannelName\":\"rgb(34, 34, 34)\",\"colorPopupChannelNameHover\":\"rgb(47, 165, 255)\",\"colorPopupViewsCounter\":\"rgb(85, 85, 85)\",\"colorPopupLikesRatio\":\"rgb(47, 165, 255)\",\"colorPopupDislikesRatio\":\"rgb(207, 207, 207)\",\"colorPopupLikesCounter\":\"rgb(144, 144, 144)\",\"colorPopupDislikesCounter\":\"rgb(144, 144, 144)\",\"colorPopupDate\":\"rgb(34, 34, 34)\",\"colorPopupDescription\":\"rgb(34, 34, 34)\",\"colorPopupAnchor\":\"rgb(26, 137, 222)\",\"colorPopupAnchorHover\":\"rgb(47, 165, 255)\",\"colorPopupDescriptionMoreButton\":\"rgb(102, 102, 102)\",\"colorPopupDescriptionMoreButtonHover\":\"rgb(34, 34, 34)\",\"colorPopupCommentsUsername\":\"rgb(34, 34, 34)\",\"colorPopupCommentsUsernameHover\":\"rgb(47, 165, 255)\",\"colorPopupCommentsPassedTime\":\"rgb(115, 115, 115)\",\"colorPopupCommentsText\":\"rgb(34, 34, 34)\",\"colorPopupCommentsLikes\":\"rgb(180, 180, 180)\",\"colorPopupControls\":\"rgb(160, 160, 160)\",\"colorPopupControlsHover\":\"rgb(220, 220, 220)\",\"colorPopupControlsMobile\":\"rgb(220, 220, 220)\",\"colorPopupControlsMobileBg\":\"rgba(255, 255, 255, 0)\",\"adsClient\":\"\",\"adsSlotsContent\":\"\",\"adsSlotsPopup\":\"\"}");

/* INSERT TABLE DATA: wpge_options */
INSERT INTO `wpge_options` VALUES("1", "siteurl", "https://joshconstructions.hipercomhosting.com/", "yes");
INSERT INTO `wpge_options` VALUES("2", "home", "https://joshconstructions.hipercomhosting.com/", "yes");
INSERT INTO `wpge_options` VALUES("3", "blogname", "JOSH CONSTRUCTIONS", "yes");
INSERT INTO `wpge_options` VALUES("4", "blogdescription", "Expert builders for homes and commercial projects.", "yes");
INSERT INTO `wpge_options` VALUES("183006", "new_admin_email", "admin@imertec.com.ec", "auto");
INSERT INTO `wpge_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wpge_options` VALUES("6", "admin_email", "admin@imertec.com.ec", "yes");
INSERT INTO `wpge_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wpge_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wpge_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wpge_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wpge_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wpge_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wpge_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wpge_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wpge_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wpge_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wpge_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wpge_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wpge_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wpge_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wpge_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wpge_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wpge_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wpge_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wpge_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wpge_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wpge_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wpge_options` VALUES("28", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO `wpge_options` VALUES("29", "rewrite_rules", "a:372:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:12:\"productos/?$\";s:27:\"index.php?post_type=product\";s:42:\"productos/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:37:\"productos/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:29:\"productos/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:15:\"^checkout-link$\";s:28:\"index.php?checkout-link=true\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:44:\"brand/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:39:\"brand/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:20:\"brand/(.+?)/embed/?$\";s:46:\"index.php?product_brand=$matches[1]&embed=true\";s:32:\"brand/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?product_brand=$matches[1]&paged=$matches[2]\";s:14:\"brand/(.+?)/?$\";s:35:\"index.php?product_brand=$matches[1]\";s:57:\"categoria-producto/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:52:\"categoria-producto/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:33:\"categoria-producto/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:45:\"categoria-producto/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:27:\"categoria-producto/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:58:\"etiqueta-producto/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:53:\"etiqueta-producto/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:34:\"etiqueta-producto/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:46:\"etiqueta-producto/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:28:\"etiqueta-producto/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:36:\"producto/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"producto/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"producto/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"producto/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"producto/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"producto/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:25:\"producto/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:29:\"producto/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:49:\"producto/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:44:\"producto/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:37:\"producto/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:44:\"producto/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:34:\"producto/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:45:\"producto/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:40:\"producto/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:51:\"producto/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:51:\"producto/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:62:\"producto/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:33:\"producto/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:25:\"producto/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"producto/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"producto/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"producto/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"producto/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"producto/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"vc_grid_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"vc_grid_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"vc_grid_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"vc_grid_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"vc_grid_item/([^/]+)/embed/?$\";s:45:\"index.php?vc_grid_item=$matches[1]&embed=true\";s:33:\"vc_grid_item/([^/]+)/trackback/?$\";s:39:\"index.php?vc_grid_item=$matches[1]&tb=1\";s:41:\"vc_grid_item/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&paged=$matches[2]\";s:48:\"vc_grid_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&cpage=$matches[2]\";s:38:\"vc_grid_item/([^/]+)/wc-api(/(.*))?/?$\";s:53:\"index.php?vc_grid_item=$matches[1]&wc-api=$matches[3]\";s:49:\"vc_grid_item/([^/]+)/wc/file/transient(/(.*))?/?$\";s:64:\"index.php?vc_grid_item=$matches[1]&wc/file/transient=$matches[3]\";s:44:\"vc_grid_item/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"vc_grid_item/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"vc_grid_item/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:66:\"vc_grid_item/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:37:\"vc_grid_item/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?vc_grid_item=$matches[1]&page=$matches[2]\";s:29:\"vc_grid_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"vc_grid_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"vc_grid_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"vc_grid_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"portfolio/([^/]+)/embed/?$\";s:45:\"index.php?st_portfolio=$matches[1]&embed=true\";s:30:\"portfolio/([^/]+)/trackback/?$\";s:39:\"index.php?st_portfolio=$matches[1]&tb=1\";s:38:\"portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?st_portfolio=$matches[1]&paged=$matches[2]\";s:45:\"portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?st_portfolio=$matches[1]&cpage=$matches[2]\";s:35:\"portfolio/([^/]+)/wc-api(/(.*))?/?$\";s:53:\"index.php?st_portfolio=$matches[1]&wc-api=$matches[3]\";s:46:\"portfolio/([^/]+)/wc/file/transient(/(.*))?/?$\";s:64:\"index.php?st_portfolio=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"portfolio/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:52:\"portfolio/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:52:\"portfolio/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:63:\"portfolio/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:34:\"portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?st_portfolio=$matches[1]&page=$matches[2]\";s:26:\"portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"portfolio-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?taxonomy=st_portfolio_cat&term=$matches[1]&feed=$matches[2]\";s:54:\"portfolio-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?taxonomy=st_portfolio_cat&term=$matches[1]&feed=$matches[2]\";s:35:\"portfolio-category/([^/]+)/embed/?$\";s:63:\"index.php?taxonomy=st_portfolio_cat&term=$matches[1]&embed=true\";s:47:\"portfolio-category/([^/]+)/page/?([0-9]{1,})/?$\";s:70:\"index.php?taxonomy=st_portfolio_cat&term=$matches[1]&paged=$matches[2]\";s:29:\"portfolio-category/([^/]+)/?$\";s:52:\"index.php?taxonomy=st_portfolio_cat&term=$matches[1]\";s:35:\"service/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"service/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"service/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"service/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"service/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"service/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"service/([^/]+)/embed/?$\";s:43:\"index.php?st_service=$matches[1]&embed=true\";s:28:\"service/([^/]+)/trackback/?$\";s:37:\"index.php?st_service=$matches[1]&tb=1\";s:36:\"service/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?st_service=$matches[1]&paged=$matches[2]\";s:43:\"service/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?st_service=$matches[1]&cpage=$matches[2]\";s:33:\"service/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?st_service=$matches[1]&wc-api=$matches[3]\";s:44:\"service/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?st_service=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"service/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"service/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"service/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"service/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"service/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?st_service=$matches[1]&page=$matches[2]\";s:24:\"service/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"service/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"service/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"service/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"service/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"service/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:57:\"service-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?taxonomy=st_service_cat&term=$matches[1]&feed=$matches[2]\";s:52:\"service-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?taxonomy=st_service_cat&term=$matches[1]&feed=$matches[2]\";s:33:\"service-category/([^/]+)/embed/?$\";s:61:\"index.php?taxonomy=st_service_cat&term=$matches[1]&embed=true\";s:45:\"service-category/([^/]+)/page/?([0-9]{1,})/?$\";s:68:\"index.php?taxonomy=st_service_cat&term=$matches[1]&paged=$matches[2]\";s:27:\"service-category/([^/]+)/?$\";s:50:\"index.php?taxonomy=st_service_cat&term=$matches[1]\";s:32:\"team/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"team/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"team/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"team/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"team/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"team/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"team/([^/]+)/embed/?$\";s:40:\"index.php?st_team=$matches[1]&embed=true\";s:25:\"team/([^/]+)/trackback/?$\";s:34:\"index.php?st_team=$matches[1]&tb=1\";s:33:\"team/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?st_team=$matches[1]&paged=$matches[2]\";s:40:\"team/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?st_team=$matches[1]&cpage=$matches[2]\";s:30:\"team/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?st_team=$matches[1]&wc-api=$matches[3]\";s:41:\"team/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?st_team=$matches[1]&wc/file/transient=$matches[3]\";s:36:\"team/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:47:\"team/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:47:\"team/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:58:\"team/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"team/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?st_team=$matches[1]&page=$matches[2]\";s:21:\"team/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:31:\"team/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:51:\"team/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"team/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"team/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:27:\"team/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:54:\"team-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?taxonomy=st_team_cat&term=$matches[1]&feed=$matches[2]\";s:49:\"team-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?taxonomy=st_team_cat&term=$matches[1]&feed=$matches[2]\";s:30:\"team-category/([^/]+)/embed/?$\";s:58:\"index.php?taxonomy=st_team_cat&term=$matches[1]&embed=true\";s:42:\"team-category/([^/]+)/page/?([0-9]{1,})/?$\";s:65:\"index.php?taxonomy=st_team_cat&term=$matches[1]&paged=$matches[2]\";s:24:\"team-category/([^/]+)/?$\";s:47:\"index.php?taxonomy=st_team_cat&term=$matches[1]\";s:39:\"testimonial/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"testimonial/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"testimonial/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"testimonial/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"testimonial/([^/]+)/embed/?$\";s:47:\"index.php?st_testimonial=$matches[1]&embed=true\";s:32:\"testimonial/([^/]+)/trackback/?$\";s:41:\"index.php?st_testimonial=$matches[1]&tb=1\";s:40:\"testimonial/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?st_testimonial=$matches[1]&paged=$matches[2]\";s:47:\"testimonial/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?st_testimonial=$matches[1]&cpage=$matches[2]\";s:37:\"testimonial/([^/]+)/wc-api(/(.*))?/?$\";s:55:\"index.php?st_testimonial=$matches[1]&wc-api=$matches[3]\";s:48:\"testimonial/([^/]+)/wc/file/transient(/(.*))?/?$\";s:66:\"index.php?st_testimonial=$matches[1]&wc/file/transient=$matches[3]\";s:43:\"testimonial/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:54:\"testimonial/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:54:\"testimonial/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:65:\"testimonial/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:36:\"testimonial/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?st_testimonial=$matches[1]&page=$matches[2]\";s:28:\"testimonial/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"testimonial/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"testimonial/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"testimonial/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:61:\"testimonial-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:71:\"index.php?taxonomy=st_testimonial_cat&term=$matches[1]&feed=$matches[2]\";s:56:\"testimonial-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:71:\"index.php?taxonomy=st_testimonial_cat&term=$matches[1]&feed=$matches[2]\";s:37:\"testimonial-category/([^/]+)/embed/?$\";s:65:\"index.php?taxonomy=st_testimonial_cat&term=$matches[1]&embed=true\";s:49:\"testimonial-category/([^/]+)/page/?([0-9]{1,})/?$\";s:72:\"index.php?taxonomy=st_testimonial_cat&term=$matches[1]&paged=$matches[2]\";s:31:\"testimonial-category/([^/]+)/?$\";s:54:\"index.php?taxonomy=st_testimonial_cat&term=$matches[1]\";s:34:\"client/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"client/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"client/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"client/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"client/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"client/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"client/([^/]+)/embed/?$\";s:42:\"index.php?st_client=$matches[1]&embed=true\";s:27:\"client/([^/]+)/trackback/?$\";s:36:\"index.php?st_client=$matches[1]&tb=1\";s:35:\"client/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?st_client=$matches[1]&paged=$matches[2]\";s:42:\"client/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?st_client=$matches[1]&cpage=$matches[2]\";s:32:\"client/([^/]+)/wc-api(/(.*))?/?$\";s:50:\"index.php?st_client=$matches[1]&wc-api=$matches[3]\";s:43:\"client/([^/]+)/wc/file/transient(/(.*))?/?$\";s:61:\"index.php?st_client=$matches[1]&wc/file/transient=$matches[3]\";s:38:\"client/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:49:\"client/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:49:\"client/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:60:\"client/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"client/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?st_client=$matches[1]&page=$matches[2]\";s:23:\"client/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"client/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"client/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"client/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"client/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"client/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"mc4wp-form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"mc4wp-form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"mc4wp-form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"mc4wp-form/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"mc4wp-form/([^/]+)/embed/?$\";s:43:\"index.php?mc4wp-form=$matches[1]&embed=true\";s:31:\"mc4wp-form/([^/]+)/trackback/?$\";s:37:\"index.php?mc4wp-form=$matches[1]&tb=1\";s:39:\"mc4wp-form/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&paged=$matches[2]\";s:46:\"mc4wp-form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&cpage=$matches[2]\";s:36:\"mc4wp-form/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?mc4wp-form=$matches[1]&wc-api=$matches[3]\";s:47:\"mc4wp-form/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?mc4wp-form=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"mc4wp-form/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:53:\"mc4wp-form/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:53:\"mc4wp-form/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:64:\"mc4wp-form/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:35:\"mc4wp-form/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?mc4wp-form=$matches[1]&page=$matches[2]\";s:27:\"mc4wp-form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"mc4wp-form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"mc4wp-form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"mc4wp-form/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=2758&cpage=$matches[1]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:62:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/wc-api(/(.*))?/?$\";s:99:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&wc-api=$matches[6]\";s:73:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/wc/file/transient(/(.*))?/?$\";s:110:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&wc/file/transient=$matches[6]\";s:62:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:73:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:73:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:84:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "yes");
INSERT INTO `wpge_options` VALUES("54555", "woocommerce_clear_ces_tracks_queue_for_page", "", "yes");
INSERT INTO `wpge_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wpge_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wpge_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wpge_options` VALUES("33", "active_plugins", "a:15:{i:0;s:35:\"redux-framework/redux-framework.php\";i:1;s:33:\"classic-editor/classic-editor.php\";i:2;s:50:\"contact-form-7-image-captcha/cf7-image-captcha.php\";i:3;s:36:\"contact-form-7/wp-contact-form-7.php\";i:4;s:31:\"creame-whatsapp-me/joinchat.php\";i:5;s:25:\"duplicator/duplicator.php\";i:6;s:43:\"emotional_haversack/emotional_haversack.php\";i:7;s:25:\"gtranslate/gtranslate.php\";i:8;s:27:\"js_composer/js_composer.php\";i:9;s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";i:10;s:23:\"revslider/revslider.php\";i:11;s:31:\"st_builtpress/st_builtpress.php\";i:12;s:34:\"woo-product-images-slider/wpis.php\";i:13;s:59:\"woocommerce-legacy-rest-api/woocommerce-legacy-rest-api.php\";i:14;s:27:\"woocommerce/woocommerce.php\";}", "yes");
INSERT INTO `wpge_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wpge_options` VALUES("35", "ping_sites", "https://rpc.pingomatic.com/", "yes");
INSERT INTO `wpge_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wpge_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `wpge_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wpge_options` VALUES("39", "recently_edited", "a:2:{i:0;s:65:\"/home/imertecc/public_html/wp-content/themes/builtpress/style.css\";i:1;s:0:\"\";}", "no");
INSERT INTO `wpge_options` VALUES("40", "template", "builtpress", "yes");
INSERT INTO `wpge_options` VALUES("41", "stylesheet", "builtpress", "yes");
INSERT INTO `wpge_options` VALUES("38104", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wpge_options` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `wpge_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wpge_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wpge_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `wpge_options` VALUES("48", "db_version", "60421", "yes");
INSERT INTO `wpge_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wpge_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wpge_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `wpge_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `wpge_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `wpge_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `wpge_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `wpge_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wpge_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wpge_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wpge_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wpge_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wpge_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wpge_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wpge_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `wpge_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wpge_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wpge_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `wpge_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wpge_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wpge_options` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wpge_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wpge_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wpge_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wpge_options` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `wpge_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wpge_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wpge_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wpge_options` VALUES("77", "sticky_posts", "a:1:{i:0;i:269;}", "yes");
INSERT INTO `wpge_options` VALUES("78", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("79", "widget_text", "a:2:{i:3;a:4:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:267:\"<img class=\"alignnone size-medium wp-image-2765\" src=\"https://joshconstructions.hipercomhosting.com/wp-content/uploads/2025/08/logo12-e1756680921752-300x98.png\" alt=\"\" width=\"300\" height=\"98\" />\n\nSubscribe to Our Newsletter to be updated. We promice not to spam You !\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;}s:12:\"_multiwidget\";i:1;}", "on");
INSERT INTO `wpge_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("81", "uninstall_plugins", "a:1:{s:59:\"woocommerce-legacy-rest-api/woocommerce-legacy-rest-api.php\";s:48:\"WC_Legacy_REST_API_Plugin::on_plugin_deactivated\";}", "no");
INSERT INTO `wpge_options` VALUES("82", "timezone_string", "", "yes");
INSERT INTO `wpge_options` VALUES("83", "page_for_posts", "2557", "yes");
INSERT INTO `wpge_options` VALUES("84", "page_on_front", "2758", "yes");
INSERT INTO `wpge_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wpge_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wpge_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wpge_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `wpge_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wpge_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wpge_options` VALUES("91", "initial_db_version", "38590", "yes");
INSERT INTO `wpge_options` VALUES("92", "wpge_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:132:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"edit_shop_webhook\";b:1;s:17:\"read_shop_webhook\";b:1;s:19:\"delete_shop_webhook\";b:1;s:18:\"edit_shop_webhooks\";b:1;s:25:\"edit_others_shop_webhooks\";b:1;s:21:\"publish_shop_webhooks\";b:1;s:26:\"read_private_shop_webhooks\";b:1;s:20:\"delete_shop_webhooks\";b:1;s:28:\"delete_private_shop_webhooks\";b:1;s:30:\"delete_published_shop_webhooks\";b:1;s:27:\"delete_others_shop_webhooks\";b:1;s:26:\"edit_private_shop_webhooks\";b:1;s:28:\"edit_published_shop_webhooks\";b:1;s:25:\"manage_shop_webhook_terms\";b:1;s:23:\"edit_shop_webhook_terms\";b:1;s:25:\"delete_shop_webhook_terms\";b:1;s:25:\"assign_shop_webhook_terms\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:16:\"create_customers\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:93:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:16:\"create_customers\";b:1;}}}", "yes");
INSERT INTO `wpge_options` VALUES("38378", "revslider_server_refresh", "1757243203", "yes");
INSERT INTO `wpge_options` VALUES("38379", "revslider-update-hash", "5f9042577cd17027ef5f7c3ddce71d60", "yes");
INSERT INTO `wpge_options` VALUES("93", "fresh_site", "0", "off");
INSERT INTO `wpge_options` VALUES("94", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("95", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("96", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("97", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("98", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("99", "sidebars_widgets", "a:10:{s:19:\"wp_inactive_widgets\";a:0:{}s:7:\"sidebar\";a:5:{i:0;s:13:\"st-blog-wgt-2\";i:1;s:12:\"categories-2\";i:2;s:10:\"archives-2\";i:3;s:8:\"search-2\";i:4;s:11:\"tag_cloud-2\";}s:12:\"page_sidebar\";a:1:{i:0;s:7:\"pages-2\";}s:12:\"shop_sidebar\";a:5:{i:0;s:28:\"woocommerce_product_search-2\";i:1;s:26:\"woocommerce_price_filter-2\";i:2;s:32:\"woocommerce_product_categories-2\";i:3;s:22:\"woocommerce_products-2\";i:4;s:32:\"woocommerce_top_rated_products-2\";}s:15:\"footer_column_1\";a:3:{i:0;s:6:\"text-3\";i:1;s:19:\"mc4wp_form_widget-2\";i:2;s:15:\"st-social-wgt-3\";}s:15:\"footer_column_2\";a:1:{i:0;s:10:\"nav_menu-2\";}s:15:\"footer_column_3\";a:1:{i:0;s:17:\"st-services-wgt-3\";}s:15:\"footer_column_4\";a:1:{i:0;s:16:\"st-contact-wgt-2\";}s:11:\"st_services\";a:2:{i:0;s:17:\"st-services-wgt-5\";i:1;s:16:\"st-contact-wgt-3\";}s:13:\"array_version\";i:2;}", "yes");
INSERT INTO `wpge_options` VALUES("100", "widget_pages", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:6:\"sortby\";s:10:\"post_title\";s:7:\"exclude\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("101", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("102", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("103", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("104", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("105", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("106", "widget_tag_cloud", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:8:\"taxonomy\";s:8:\"post_tag\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("107", "widget_nav_menu", "a:2:{i:2;a:2:{s:5:\"title\";s:16:\"Explore Our Site\";s:8:\"nav_menu\";i:82;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("108", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("109", "cron", "a:22:{i:1757270457;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1757271192;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1757271434;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1757271913;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1757272920;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1757291077;a:2:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1757291096;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757294068;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1757294304;a:1:{s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1757294749;a:1:{s:45:\"woocommerce_marketplace_cron_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1757295816;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757302731;a:1:{s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757309040;a:1:{s:29:\"mc4wp_refresh_mailchimp_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757311377;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1757337720;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757340000;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1757342984;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757355751;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757683109;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1757702012;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1757852766;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wpge_options` VALUES("185351", "_transient_wc_report_orders_stats_d6b8ee31eb619f2c17ba6c604df4d2b4", "a:2:{s:7:\"version\";s:10:\"1647614982\";s:5:\"value\";O:8:\"stdClass\":5:{s:6:\"totals\";O:8:\"stdClass\":15:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"products\";i:0;s:8:\"segments\";a:0:{}}s:9:\"intervals\";a:1:{i:0;a:6:{s:8:\"interval\";s:7:\"2025-36\";s:10:\"date_start\";s:19:\"2025-09-01 00:00:00\";s:14:\"date_start_gmt\";s:19:\"2025-09-01 00:00:00\";s:8:\"date_end\";s:19:\"2025-09-01 23:59:59\";s:12:\"date_end_gmt\";s:19:\"2025-09-01 23:59:59\";s:9:\"subtotals\";O:8:\"stdClass\":14:{s:12:\"orders_count\";i:0;s:14:\"num_items_sold\";i:0;s:11:\"gross_sales\";d:0;s:11:\"total_sales\";d:0;s:7:\"coupons\";d:0;s:13:\"coupons_count\";i:0;s:7:\"refunds\";d:0;s:5:\"taxes\";d:0;s:8:\"shipping\";d:0;s:11:\"net_revenue\";d:0;s:19:\"avg_items_per_order\";d:0;s:15:\"avg_order_value\";d:0;s:15:\"total_customers\";i:0;s:8:\"segments\";a:0:{}}}}s:5:\"total\";i:1;s:5:\"pages\";i:1;s:7:\"page_no\";i:1;}}", "off");
INSERT INTO `wpge_options` VALUES("114", "theme_mods_twentyseventeen", "a:3:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1756678938;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:4:{i:0;s:6:\"meta-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"nav_menu-2\";}s:9:\"sidebar-1\";a:7:{i:0;s:12:\"categories-2\";i:1;s:10:\"archives-2\";i:2;s:8:\"search-2\";i:3;s:11:\"tag_cloud-2\";i:4;s:7:\"pages-2\";i:5;s:6:\"text-3\";i:6;s:19:\"mc4wp_form_widget-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:5:{i:0;s:28:\"woocommerce_product_search-2\";i:1;s:26:\"woocommerce_price_filter-2\";i:2;s:32:\"woocommerce_product_categories-2\";i:3;s:22:\"woocommerce_products-2\";i:4;s:32:\"woocommerce_top_rated_products-2\";}}}s:18:\"nav_menu_locations\";a:1:{s:3:\"top\";i:50;}}", "off");
INSERT INTO `wpge_options` VALUES("116", "WPLANG", "", "yes");
INSERT INTO `wpge_options` VALUES("176", "woocommerce_store_address", "Av. Galo Plaza n55-22 y Urquiola", "yes");
INSERT INTO `wpge_options` VALUES("177", "woocommerce_store_address_2", "", "yes");
INSERT INTO `wpge_options` VALUES("178", "woocommerce_store_city", "Quito", "yes");
INSERT INTO `wpge_options` VALUES("179", "woocommerce_default_country", "EC:EC-P", "yes");
INSERT INTO `wpge_options` VALUES("180", "woocommerce_store_postcode", "ec000000", "yes");
INSERT INTO `wpge_options` VALUES("181", "woocommerce_allowed_countries", "all", "yes");
INSERT INTO `wpge_options` VALUES("182", "woocommerce_all_except_countries", "a:0:{}", "yes");
INSERT INTO `wpge_options` VALUES("183", "woocommerce_specific_allowed_countries", "a:0:{}", "yes");
INSERT INTO `wpge_options` VALUES("184", "woocommerce_ship_to_countries", "", "yes");
INSERT INTO `wpge_options` VALUES("185", "woocommerce_specific_ship_to_countries", "a:0:{}", "yes");
INSERT INTO `wpge_options` VALUES("186", "woocommerce_default_customer_address", "base", "yes");
INSERT INTO `wpge_options` VALUES("187", "woocommerce_calc_taxes", "no", "yes");
INSERT INTO `wpge_options` VALUES("188", "woocommerce_demo_store", "no", "yes");
INSERT INTO `wpge_options` VALUES("189", "woocommerce_demo_store_notice", "Esta es una tienda de demostración para realizar pruebas &mdash; no se completará ningún pedido.", "no");
INSERT INTO `wpge_options` VALUES("190", "woocommerce_currency", "USD", "yes");
INSERT INTO `wpge_options` VALUES("191", "woocommerce_currency_pos", "left", "yes");
INSERT INTO `wpge_options` VALUES("192", "woocommerce_price_thousand_sep", ",", "yes");
INSERT INTO `wpge_options` VALUES("193", "woocommerce_price_decimal_sep", ".", "yes");
INSERT INTO `wpge_options` VALUES("194", "woocommerce_price_num_decimals", "2", "yes");
INSERT INTO `wpge_options` VALUES("195", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `wpge_options` VALUES("498", "revslider-connection", "1", "yes");
INSERT INTO `wpge_options` VALUES("499", "revslider-latest-version", "6.7.37", "yes");
INSERT INTO `wpge_options` VALUES("500", "revslider-stable-version", "4.2.0", "yes");
INSERT INTO `wpge_options` VALUES("501", "revslider-notices", "a:2:{i:0;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:964:\"<div style=\"display: block; background: #1b0e41;text-align: center; height:300px;\"><noscript><img src=\"//updates.themepunch-ext-c.tools//banners/rs60/cyberweek.jpg\" usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\"></noscript><img usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\" src=\"//updates.themepunch-ext-c.tools//banners/rs60/cyberweek.jpg\"></div>\n<map name=\"srbannermap\">\n    <area target=\"_blank\" alt=\"Slider Revolution\" title=\"Slider Revolution\" href=\"https://www.sliderrevolution.com/black-friday-and-cyber-monday-sale/?utm_source=admin&amp;utm_medium=banner&amp;utm_campaign=srusers&amp;utm_content=cyberweeks22\" coords=\"569,135,890,196\" shape=\"rect\">\n    <area target=\"_blank\" alt=\"Essential Grid\" title=\"Essential Grid\" href=\"https://www.essential-grid.com/?utm_source=admin&utm_medium=banner&utm_campaign=esgusers&utm_content=cyberweeks22\" coords=\"570,200,889,260\" shape=\"rect\">\n</map>\";s:4:\"code\";s:9:\"TPSRCW111\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:1;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:956:\"<div style=\"display: block; background: #1c0950;text-align: center; height:300px;\"><noscript><img src=\"//updates.themepunch-ext-c.tools//banners/blackfriday2024-admin2.jpg\" usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\"></noscript><img usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\" src=\"//updates.themepunch-ext-c.tools//banners/blackfriday2024-admin2.jpg\"></div><map name=\"srbannermap\"><area target=\"_blank\" alt=\"Slider Revolution\" title=\"Slider Revolution\" href=\"https://www.sliderrevolution.com/black-friday-and-cyber-monday-sale/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=cyberweeks24\" coords=\"569,135,890,196\" shape=\"rect\"><area target=\"_blank\" alt=\"Essential Grid\" title=\"Essential Grid\" href=\"https://www.essential-grid.com/?utm_source=admin&utm_medium=banner&utm_campaign=esgusers&utm_content=cyberweeks24\" coords=\"570,200,889,260\" shape=\"rect\"></map>\";s:4:\"code\";s:8:\"TPSRBF24\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}}", "yes");
INSERT INTO `wpge_options` VALUES("502", "revslider-dashboard", "a:0:{}", "yes");
INSERT INTO `wpge_options` VALUES("503", "revslider-addons", "O:8:\"stdClass\":32:{s:25:\"revslider-particles-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"424\";s:9:\"releaseid\";s:1:\"7\";s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"3.3.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:2:\"10\";s:11:\"last_update\";s:10:\"2023-07-28\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_particles.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_particles.jpg\";s:7:\"img_md5\";s:32:\"b668a4015ddc6a532b43bb558967a062\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"405\";s:9:\"releaseid\";s:2:\"20\";s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"20\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_bubblemorph.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_bubblemorph.jpg\";s:7:\"img_md5\";s:32:\"22d03d5de3034069c6db1fdeafd467cd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-transitionpack-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"369\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:30:\"revslider-transitionpack-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Advanced Transitions\";s:6:\"line_1\";s:43:\"Add never-before-seen slide transitions to \";s:6:\"line_2\";s:42:\"Slider Revolution with the power of WEBGL.\";s:9:\"available\";s:5:\"1.0.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"30\";s:11:\"last_update\";s:10:\"2023-02-23\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_transition.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_transition.jpg\";s:7:\"img_md5\";s:32:\"fe0f1c539053620039a0ad96c4ac27e6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"AT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"404\";s:9:\"releaseid\";s:2:\"15\";s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"3.1.0\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"40\";s:11:\"last_update\";s:10:\"2023-05-20\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_beforeafter.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_beforeafter.jpg\";s:7:\"img_md5\";s:32:\"5a34f20417a7874e1b95693ef37a0758\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"418\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:2:\"50\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_typewriter.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_typewriter.jpg\";s:7:\"img_md5\";s:32:\"727b604f6fd3fc55894ba50eb566efed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-mousetrap-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"410\";s:9:\"releaseid\";s:2:\"24\";s:4:\"slug\";s:25:\"revslider-mousetrap-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Mousetrap\";s:6:\"line_1\";s:31:\"Create all kinds of interesting\";s:6:\"line_2\";s:19:\" mouse interactions\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"60\";s:11:\"last_update\";s:10:\"2021-10-20\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_mousetrap.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_mousetrap.jpg\";s:7:\"img_md5\";s:32:\"2329053c3b1d19bdaee131c3dc258d3a\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"409\";s:9:\"releaseid\";s:2:\"21\";s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"70\";s:11:\"last_update\";s:10:\"2021-10-20\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_distortion.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_distortion.jpg\";s:7:\"img_md5\";s:32:\"c26c52a563008b7dc907a288c1e4bb8e\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-lottie-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"420\";s:9:\"releaseid\";s:2:\"25\";s:4:\"slug\";s:22:\"revslider-lottie-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Lottie\";s:6:\"line_1\";s:53:\"Adds support for the popular Lottie Animation format,\";s:6:\"line_2\";s:70:\" including animation control, style customization and a local library.\";s:9:\"available\";s:5:\"3.1.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"80\";s:11:\"last_update\";s:10:\"2023-06-26\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_lottie.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_lottie.jpg\";s:7:\"img_md5\";s:32:\"4aa677a45bb13732e4f10bcb632afcce\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"411\";s:9:\"releaseid\";s:2:\"23\";s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"90\";s:11:\"last_update\";s:10:\"2023-08-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_paintbrush.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_paintbrush.jpg\";s:7:\"img_md5\";s:32:\"308a56289b9a29d1916c2acfc141b699\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-charts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"383\";s:9:\"releaseid\";s:2:\"27\";s:4:\"slug\";s:22:\"revslider-charts-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Charts\";s:6:\"line_1\";s:93:\"The Charts addon allows you to create visually impressive line or bar graphs from .csv data, \";s:6:\"line_2\";s:56:\"with tons of options to take full control of the design.\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:3:\"100\";s:11:\"last_update\";s:10:\"2021-07-08\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_charts.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_charts.jpg\";s:7:\"img_md5\";s:32:\"d2c184371a575faade425c0377c1fdbd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"CH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"417\";s:9:\"releaseid\";s:2:\"13\";s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"110\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_slicey.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_slicey.jpg\";s:7:\"img_md5\";s:32:\"28afd29b7738a452194f0a0bc1d21cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"422\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"125\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_filmstrip.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_filmstrip.jpg\";s:7:\"img_md5\";s:32:\"dac40ee57d2be9aaf01faacf51ccb412\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"421\";s:9:\"releaseid\";s:1:\"4\";s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"3.0.0\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"127\";s:11:\"last_update\";s:10:\"2023-07-17\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:84:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_underconstruction.jpg\";s:8:\"img_file\";s:51:\"revslider/addons/images/addon_underconstruction.jpg\";s:7:\"img_md5\";s:32:\"17f8cba84931541c065cfb1943edafb2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"416\";s:9:\"releaseid\";s:2:\"19\";s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"3.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"130\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_reveal.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reveal.jpg\";s:7:\"img_md5\";s:32:\"a7ce4bf5eb6fdc1497ed6276ca623046\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"423\";s:9:\"releaseid\";s:2:\"17\";s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:5:\"6.5.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:28:\"Display images in 360 degree\";s:9:\"available\";s:5:\"3.0.9\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"135\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_panorama.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_panorama.jpg\";s:7:\"img_md5\";s:32:\"210953d59903bed91688138cb60777d2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-scrollvideo-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"396\";s:9:\"releaseid\";s:2:\"26\";s:4:\"slug\";s:27:\"revslider-scrollvideo-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Scroll Video\";s:6:\"line_1\";s:114:\"This addon allows you to generate a sequence of images from any html5 video and play them with scroll interaction.\";s:6:\"line_2\";s:49:\"Quality options are included for optimal results!\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:15:\"background_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:14:\"background_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"140\";s:11:\"last_update\";s:10:\"2021-12-23\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:7:\"img_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"407\";s:9:\"releaseid\";s:2:\"22\";s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"150\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_exploding.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_exploding.jpg\";s:7:\"img_md5\";s:32:\"44d60b83cdf5b29033d41feb516b47e1\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"397\";s:9:\"releaseid\";s:1:\"5\";s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"165\";s:11:\"last_update\";s:10:\"2023-07-08\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:80:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_socialsharing.jpg\";s:8:\"img_file\";s:47:\"revslider/addons/images/addon_socialsharing.jpg\";s:7:\"img_md5\";s:32:\"6b074630853c4f95d5337bc85e496cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"419\";s:9:\"releaseid\";s:1:\"1\";s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:81:\"//updates.themepunch-ext-c.tools/revslider/addons/images/whiteboard_widget_bg.jpg\";s:15:\"background_file\";s:48:\"revslider/addons/images/whiteboard_widget_bg.jpg\";s:14:\"background_md5\";s:32:\"cc69160eb95469dc033e0cc094a24847\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"170\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_whiteboard.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_whiteboard.jpg\";s:7:\"img_md5\";s:32:\"b0bb636fb30ffc3d112ba4c563395ee6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"414\";s:9:\"releaseid\";s:2:\"14\";s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"3.0.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"180\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_polyfold.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_polyfold.jpg\";s:7:\"img_md5\";s:32:\"02c6af89e4208f0da5920c6c3e6bb744\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:29:\"revslider-domain-switch-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"78\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:29:\"revslider-domain-switch-addon\";s:12:\"version_from\";s:5:\"6.0.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Domain Switch\";s:6:\"line_1\";s:17:\"Switch Image URLs\";s:6:\"line_2\";s:37:\"in sliders from one domain to another\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"300\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:79:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_domainswitch.jpg\";s:8:\"img_file\";s:46:\"revslider/addons/images/addon_domainswitch.jpg\";s:7:\"img_md5\";s:32:\"f2036924e7993f94bd5c9876fa0bf09b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"DS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"415\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"3.0.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"330\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_reload.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reload.jpg\";s:7:\"img_md5\";s:32:\"d1d34d204e627168f4cc4e7422a6d40c\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"55\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"340\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wprelated.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wprelated.jpg\";s:7:\"img_md5\";s:32:\"e2e7d6c3a428a55442ba90131556c930\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"399\";s:9:\"releaseid\";s:1:\"6\";s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"380\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:71:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_snow.jpg\";s:8:\"img_file\";s:38:\"revslider/addons/images/addon_snow.jpg\";s:7:\"img_md5\";s:32:\"d6bac718866b0070198a4340041bc60b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"378\";s:9:\"releaseid\";s:1:\"2\";s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"2.0.7\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"430\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wpgallery.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wpgallery.jpg\";s:7:\"img_md5\";s:32:\"74392a04b741d83c51e55059dbb388ef\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-backup-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"53\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"2.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"500\";s:11:\"last_update\";s:10:\"2024-11-20\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_backup.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_backup.jpg\";s:7:\"img_md5\";s:32:\"104797323a0293cd3f200b0172db1186\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"62\";s:9:\"releaseid\";s:1:\"8\";s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"620\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:70:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_404.jpg\";s:8:\"img_file\";s:37:\"revslider/addons/images/addon_404.jpg\";s:7:\"img_md5\";s:32:\"217b0d118a107dc50979740dd61228df\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"63\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"630\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wpadjacent.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpadjacent.jpg\";s:7:\"img_md5\";s:32:\"cb1feb1257e55d0f42c29dfde2d809ed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"388\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"650\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:72:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_login.jpg\";s:8:\"img_file\";s:39:\"revslider/addons/images/addon_login.jpg\";s:7:\"img_md5\";s:32:\"f0f2edffb4e155acf67799692428644d\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"379\";s:9:\"releaseid\";s:2:\"12\";s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"2.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"660\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_wpfeatured.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpfeatured.jpg\";s:7:\"img_md5\";s:32:\"bcc840e68194f3eb05795e1353954bda\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"402\";s:9:\"releaseid\";s:2:\"16\";s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"3.0.1\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"690\";s:11:\"last_update\";s:10:\"2023-05-31\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_weather.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_weather.jpg\";s:7:\"img_md5\";s:32:\"c69d1c9a69c2dec43ca0578ac35792bd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"406\";s:9:\"releaseid\";s:2:\"18\";s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"3.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"710\";s:11:\"last_update\";s:10:\"2023-01-09\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-c.tools/revslider/addons/images/addon_duotone.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_duotone.jpg\";s:7:\"img_md5\";s:32:\"fb666e487e7ac28e6a2a157eed1fb682\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}}", "yes");
INSERT INTO `wpge_options` VALUES("532", "_transient_product-transient-version", "1756680559", "yes");
INSERT INTO `wpge_options` VALUES("765", "xoo-qv-button-text", "Vista rápida", "yes");
INSERT INTO `wpge_options` VALUES("766", "xoo-qv-button-fsize", "14", "yes");
INSERT INTO `wpge_options` VALUES("767", "xoo-qv-button-position", "woocommerce_before_shop_loop_item_title", "yes");
INSERT INTO `wpge_options` VALUES("768", "xoo-qv-btn-bgc", "inherit", "yes");
INSERT INTO `wpge_options` VALUES("769", "xoo-qv-button-color", "inherit", "yes");
INSERT INTO `wpge_options` VALUES("770", "xoo-qv-btn-ps", "6px 8px", "yes");
INSERT INTO `wpge_options` VALUES("771", "xoo-qv-btn-bs", "1", "yes");
INSERT INTO `wpge_options` VALUES("772", "xoo-qv-btn-bc", "#000000", "yes");
INSERT INTO `wpge_options` VALUES("773", "xoo-qv-btn-icon", "true", "yes");
INSERT INTO `wpge_options` VALUES("774", "xoo-qv-btn-iconc", "#000000", "yes");
INSERT INTO `wpge_options` VALUES("775", "xoo-qv-gl-mobile", "true", "yes");
INSERT INTO `wpge_options` VALUES("776", "xoo-qv-gl-anim", "linear", "yes");
INSERT INTO `wpge_options` VALUES("777", "xoo-qv-gl-pbutton", "true", "yes");
INSERT INTO `wpge_options` VALUES("778", "xoo-qv-gl-pbutton-text", "Detalles del producto", "yes");
INSERT INTO `wpge_options` VALUES("779", "xoo-qv-lb-img-area", "40", "yes");
INSERT INTO `wpge_options` VALUES("780", "xoo-qv-lb-img-width", "100", "yes");
INSERT INTO `wpge_options` VALUES("781", "xoo-qv-lb-en-gallery", "true", "yes");
INSERT INTO `wpge_options` VALUES("782", "xoo-qv-lb-enable", "true", "yes");
INSERT INTO `wpge_options` VALUES("783", "xoo-qv-lb-title", "true", "yes");
INSERT INTO `wpge_options` VALUES("801", "wpis_options", "a:5:{s:5:\"arrow\";s:4:\"true\";s:6:\"carrow\";s:5:\"false\";s:4:\"zoom\";s:4:\"true\";s:5:\"popup\";s:4:\"true\";s:8:\"autoplay\";s:4:\"true\";}", "yes");
INSERT INTO `wpge_options` VALUES("792", "fs_active_plugins", "O:8:\"stdClass\":3:{s:7:\"plugins\";a:1:{s:30:\"foobox-image-lightbox/freemius\";O:8:\"stdClass\":4:{s:7:\"version\";s:8:\"1.2.2.10\";s:4:\"type\";s:6:\"plugin\";s:9:\"timestamp\";i:1519421315;s:11:\"plugin_path\";s:37:\"foobox-image-lightbox/foobox-free.php\";}}s:7:\"abspath\";s:27:\"/home/imertecc/public_html/\";s:6:\"newest\";O:8:\"stdClass\":5:{s:11:\"plugin_path\";s:37:\"foobox-image-lightbox/foobox-free.php\";s:8:\"sdk_path\";s:30:\"foobox-image-lightbox/freemius\";s:7:\"version\";s:8:\"1.2.2.10\";s:13:\"in_activation\";b:1;s:9:\"timestamp\";i:1519421315;}}", "yes");
INSERT INTO `wpge_options` VALUES("793", "fs_debug_mode", "", "yes");
INSERT INTO `wpge_options` VALUES("794", "fs_accounts", "a:6:{s:21:\"id_slug_type_path_map\";a:1:{i:374;a:3:{s:4:\"slug\";s:21:\"foobox-image-lightbox\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:83:\"/home/imertecc/public_html/wp-content/plugins/foobox-image-lightbox/foobox-free.php\";}}s:11:\"plugin_data\";a:1:{s:21:\"foobox-image-lightbox\";a:15:{s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:83:\"/home/imertecc/public_html/wp-content/plugins/foobox-image-lightbox/foobox-free.php\";}s:17:\"install_timestamp\";i:1519421212;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:0;s:16:\"sdk_last_version\";N;s:11:\"sdk_version\";s:8:\"1.2.2.10\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";N;s:14:\"plugin_version\";s:5:\"2.5.1\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";b:1;s:4:\"host\";s:18:\"www.imertec.com.ec\";s:9:\"server_ip\";s:15:\"190.152.177.154\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1519421212;s:7:\"version\";s:5:\"2.5.1\";}s:15:\"prev_is_premium\";b:0;s:12:\"is_anonymous\";a:3:{s:2:\"is\";b:1;s:9:\"timestamp\";i:1519421224;s:7:\"version\";s:5:\"2.5.1\";}}}s:13:\"file_slug_map\";a:1:{s:37:\"foobox-image-lightbox/foobox-free.php\";s:21:\"foobox-image-lightbox\";}s:7:\"plugins\";a:1:{s:21:\"foobox-image-lightbox\";O:9:\"FS_Plugin\":17:{s:16:\"parent_plugin_id\";N;s:5:\"title\";s:21:\"FooBox Image Lightbox\";s:4:\"slug\";s:21:\"foobox-image-lightbox\";s:4:\"type\";s:6:\"plugin\";s:4:\"file\";s:37:\"foobox-image-lightbox/foobox-free.php\";s:7:\"version\";s:5:\"2.5.1\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:7:\"is_live\";b:1;s:20:\"affiliate_moderation\";b:0;s:10:\"public_key\";s:32:\"pk_7a17ec700c89fe71a25605589e0b9\";s:10:\"secret_key\";N;s:2:\"id\";s:3:\"374\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:0;}}s:9:\"unique_id\";s:32:\"0eee88df144c8e2e19d7c20cf3b10244\";s:13:\"admin_notices\";a:1:{s:21:\"foobox-image-lightbox\";a:0:{}}}", "yes");
INSERT INTO `wpge_options` VALUES("795", "fs_api_cache", "a:0:{}", "yes");
INSERT INTO `wpge_options` VALUES("144", "current_theme", "BuiltPress", "yes");
INSERT INTO `wpge_options` VALUES("145", "theme_mods_builtpress", "a:5:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:7:\"primary\";i:50;s:6:\"footer\";i:49;}s:18:\"custom_css_post_id\";i:-1;s:16:\"theme_st_options\";a:17:{s:9:\"site_logo\";a:5:{s:3:\"url\";s:98:\"https://joshconstructions.hipercomhosting.com/wp-content/uploads/2025/08/logo11-e1756441439202.png\";s:2:\"id\";s:4:\"2722\";s:6:\"height\";s:2:\"77\";s:5:\"width\";s:3:\"300\";s:9:\"thumbnail\";s:0:\"\";}s:18:\"header_transparent\";s:1:\"1\";s:21:\"site_logo_transparent\";a:5:{s:3:\"url\";s:98:\"https://joshconstructions.hipercomhosting.com/wp-content/uploads/2025/08/logo12-e1756680921752.png\";s:2:\"id\";s:4:\"2765\";s:6:\"height\";s:3:\"242\";s:5:\"width\";s:3:\"743\";s:9:\"thumbnail\";s:0:\"\";}s:11:\"topbar_info\";a:4:{s:7:\"label_1\";s:27:\"<i class=\"fa  fa-home\"></i>\";s:7:\"value_1\";s:56:\"Av. 6 de Diciembre N56-151 y Fresnos Local 3 Planta baja\";s:7:\"label_2\";s:30:\"<i class=\"fa  fa-clock-o\"></i>\";s:7:\"value_2\";s:29:\"Lunes - Sábado: 9:00 - 18:00\";}s:11:\"header_info\";a:4:{s:7:\"label_1\";s:27:\"<i class=\"fa fa-phone\"></i>\";s:7:\"value_1\";s:12:\"352 812 7847\";s:7:\"label_2\";s:32:\"<i class=\"fa fa-envelope-o\"></i>\";s:7:\"value_2\";s:27:\"info@joshconstructionfl.com\";}s:10:\"social_url\";a:13:{s:8:\"facebook\";s:32:\"https://www.facebook.com/IMERTEC\";s:6:\"google\";s:1:\"#\";s:7:\"twitter\";s:1:\"#\";s:8:\"linkedin\";s:1:\"#\";s:8:\"dribbble\";s:1:\"#\";s:9:\"instagram\";s:1:\"#\";s:9:\"pinterest\";s:1:\"#\";s:10:\"foursquare\";s:1:\"#\";s:6:\"tumblr\";s:1:\"#\";s:7:\"youtube\";s:1:\"#\";s:5:\"vimeo\";s:1:\"#\";s:6:\"flickr\";s:1:\"#\";s:3:\"rss\";s:1:\"#\";}s:18:\"topbar_social_show\";a:13:{s:8:\"facebook\";s:1:\"1\";s:6:\"google\";s:0:\"\";s:7:\"twitter\";s:1:\"1\";s:8:\"linkedin\";s:1:\"1\";s:8:\"dribbble\";s:0:\"\";s:9:\"instagram\";s:0:\"\";s:9:\"pinterest\";s:0:\"\";s:10:\"foursquare\";s:0:\"\";s:6:\"tumblr\";s:0:\"\";s:7:\"youtube\";s:1:\"1\";s:5:\"vimeo\";s:0:\"\";s:6:\"flickr\";s:0:\"\";s:3:\"rss\";s:0:\"\";}s:19:\"header_button_value\";s:11:\"get a quote\";s:14:\"style_bg_title\";a:7:{s:16:\"background-color\";s:11:\"transparent\";s:17:\"background-repeat\";s:9:\"no-repeat\";s:15:\"background-size\";s:5:\"cover\";s:21:\"background-attachment\";s:6:\"scroll\";s:19:\"background-position\";s:13:\"center center\";s:16:\"background-image\";s:95:\"https://joshconstructions.hipercomhosting.com/wp-content/uploads/2016/01/demo-builtpress-03.jpg\";s:5:\"media\";a:4:{s:2:\"id\";s:4:\"2552\";s:6:\"height\";s:4:\"1280\";s:5:\"width\";s:4:\"1920\";s:9:\"thumbnail\";s:103:\"https://joshconstructions.hipercomhosting.com/wp-content/uploads/2016/01/demo-builtpress-03-150x150.jpg\";}}s:15:\"style_bg_header\";s:11:\"transparent\";s:19:\"color_header_border\";s:11:\"transparent\";s:18:\"style_skin_primary\";s:7:\"#ffb300\";s:13:\"style_bg_body\";a:7:{s:16:\"background-color\";s:0:\"\";s:17:\"background-repeat\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:19:\"background-position\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:5:\"media\";a:4:{s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:15:\"style_bg_topbar\";s:11:\"transparent\";s:13:\"topbar_enable\";s:1:\"1\";s:16:\"title_breadcrumb\";s:1:\"1\";s:11:\"site_layout\";s:4:\"wide\";}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1756678771;s:4:\"data\";a:8:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:6:\"meta-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:17:\"st-services-wgt-5\";i:4;s:16:\"st-contact-wgt-3\";}s:7:\"sidebar\";a:5:{i:0;s:13:\"st-blog-wgt-2\";i:1;s:12:\"categories-2\";i:2;s:10:\"archives-2\";i:3;s:8:\"search-2\";i:4;s:11:\"tag_cloud-2\";}s:12:\"page_sidebar\";a:1:{i:0;s:7:\"pages-2\";}s:12:\"shop_sidebar\";a:5:{i:0;s:28:\"woocommerce_product_search-2\";i:1;s:26:\"woocommerce_price_filter-2\";i:2;s:32:\"woocommerce_product_categories-2\";i:3;s:22:\"woocommerce_products-2\";i:4;s:32:\"woocommerce_top_rated_products-2\";}s:15:\"footer_column_1\";a:3:{i:0;s:6:\"text-3\";i:1;s:19:\"mc4wp_form_widget-2\";i:2;s:15:\"st-social-wgt-3\";}s:15:\"footer_column_2\";a:1:{i:0;s:10:\"nav_menu-2\";}s:15:\"footer_column_3\";a:1:{i:0;s:17:\"st-services-wgt-3\";}s:15:\"footer_column_4\";a:1:{i:0;s:16:\"st-contact-wgt-2\";}}}}", "on");
INSERT INTO `wpge_options` VALUES("146", "theme_switched", "", "yes");
INSERT INTO `wpge_options` VALUES("147", "widget_st-blog-wgt", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:1:\"0\";s:5:\"count\";s:1:\"5\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("148", "widget_st-social-wgt", "a:2:{i:3;a:2:{s:5:\"title\";s:0:\"\";s:11:\"social_show\";a:13:{s:7:\"twitter\";i:1;s:8:\"linkedin\";i:1;s:9:\"instagram\";i:1;s:6:\"tumblr\";i:1;s:8:\"facebook\";i:0;s:6:\"google\";i:0;s:8:\"dribbble\";i:0;s:9:\"pinterest\";i:0;s:10:\"foursquare\";i:0;s:7:\"youtube\";i:0;s:5:\"vimeo\";i:0;s:6:\"flickr\";i:0;s:3:\"rss\";i:0;}}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("149", "widget_st-contact-wgt", "a:3:{i:2;a:5:{s:5:\"title\";s:14:\"Office Address\";s:7:\"address\";s:52:\"5001 E. Colorado Blvd. Suite 820, Pasadena, CA 91106\";s:5:\"phone\";s:14:\"(626) 935-8115\";s:3:\"fax\";s:14:\"(626) 935-3026\";s:5:\"email\";s:19:\"info@builtpress.com\";}i:3;a:5:{s:5:\"title\";s:14:\"Office Address\";s:7:\"address\";s:51:\"705 Eglinton Ave. W- Suite 969, Toronto, ON M7N 3D3\";s:5:\"phone\";s:14:\"(614) 395-2455\";s:3:\"fax\";s:14:\"(614) 395-7696\";s:5:\"email\";s:18:\"info@builtpress.ca\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("150", "widget_st-services-wgt", "a:3:{i:3;a:2:{s:5:\"title\";s:12:\"Our Services\";s:8:\"category\";s:2:\"28\";}i:5;a:2:{s:5:\"title\";s:12:\"Our Services\";s:8:\"category\";s:1:\"0\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("163", "mc4wp_version", "4.10.6", "yes");
INSERT INTO `wpge_options` VALUES("164", "theme_st_options", "a:67:{s:8:\"last_tab\";s:0:\"\";s:12:\"site_favicon\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:9:\"site_logo\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:21:\"site_logo_transparent\";a:5:{s:3:\"url\";s:96:\"https://joshconstructions.hipercomhosting.com/wp-content/uploads/2025/09/logo-e1756687084990.png\";s:2:\"id\";s:4:\"2786\";s:6:\"height\";s:2:\"76\";s:5:\"width\";s:3:\"200\";s:9:\"thumbnail\";s:104:\"https://joshconstructions.hipercomhosting.com/wp-content/uploads/2025/09/logo-e1756686874126-150x150.png\";}s:11:\"site_layout\";s:4:\"wide\";s:12:\"header_style\";s:2:\"v1\";s:18:\"header_transparent\";s:1:\"1\";s:13:\"header_sticky\";s:1:\"1\";s:11:\"header_info\";a:4:{s:7:\"label_1\";s:28:\"<i class=\"fa fa-phone\"></i> \";s:7:\"value_1\";s:15:\"+1 352 812 7847\";s:7:\"label_2\";s:33:\"<i class=\"fa fa-envelope-o\"></i> \";s:7:\"value_2\";s:28:\"info@joshconstructionsfl.com\";}s:18:\"header_button_link\";s:4:\"2272\";s:19:\"header_button_value\";s:11:\"Get A Quote\";s:13:\"header_search\";s:1:\"1\";s:13:\"topbar_enable\";s:1:\"1\";s:11:\"topbar_info\";a:4:{s:7:\"label_1\";s:27:\"<i class=\"fa  fa-home\"></i>\";s:7:\"value_1\";s:9:\"OCALA FL.\";s:7:\"label_2\";s:30:\"<i class=\"fa  fa-clock-o\"></i>\";s:7:\"value_2\";s:43:\"Mon - Fri: 9:00 - 17:00     Sat-Sun: Closed\";}s:13:\"topbar_social\";s:1:\"1\";s:18:\"topbar_social_show\";a:13:{s:8:\"facebook\";s:1:\"1\";s:6:\"google\";s:0:\"\";s:7:\"twitter\";s:1:\"1\";s:8:\"linkedin\";s:0:\"\";s:8:\"dribbble\";s:0:\"\";s:9:\"instagram\";s:1:\"1\";s:9:\"pinterest\";s:0:\"\";s:10:\"foursquare\";s:0:\"\";s:6:\"tumblr\";s:0:\"\";s:7:\"youtube\";s:1:\"1\";s:5:\"vimeo\";s:0:\"\";s:6:\"flickr\";s:0:\"\";s:3:\"rss\";s:0:\"\";}s:17:\"title_padding_top\";s:2:\"80\";s:20:\"title_padding_bottom\";s:2:\"80\";s:11:\"title_align\";s:4:\"left\";s:16:\"title_breadcrumb\";s:1:\"1\";s:13:\"footer_widget\";s:1:\"1\";s:20:\"footer_widget_column\";s:1:\"1\";s:19:\"footer_widget_class\";a:4:{s:7:\"class_1\";s:21:\"col-md-12 text-center\";s:7:\"class_2\";s:0:\"\";s:7:\"class_3\";s:0:\"\";s:7:\"class_4\";s:0:\"\";}s:16:\"footer_copyright\";s:1:\"1\";s:21:\"footer_copyright_menu\";s:1:\"1\";s:21:\"footer_copyright_text\";s:99:\"Diseñado por: Ing. Alvaro Salguero Hipercom 2025. Derechos reservados para JOSH CONSTRUCTIONS INC.\";s:18:\"style_skin_primary\";s:7:\"#ffb300\";s:13:\"style_bg_body\";a:7:{s:16:\"background-color\";s:0:\"\";s:17:\"background-repeat\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:19:\"background-position\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:5:\"media\";a:4:{s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:13:\"style_bg_page\";s:0:\"\";s:15:\"style_bg_header\";s:7:\"#494949\";s:19:\"color_header_border\";s:11:\"transparent\";s:17:\"color_header_text\";s:0:\"\";s:15:\"style_bg_topbar\";s:11:\"transparent\";s:19:\"color_topbar_border\";s:0:\"\";s:17:\"color_topbar_text\";s:7:\"#000000\";s:17:\"color_topbar_link\";s:0:\"\";s:23:\"color_topbar_link_hover\";s:0:\"\";s:14:\"style_bg_title\";a:7:{s:16:\"background-color\";s:11:\"transparent\";s:17:\"background-repeat\";s:9:\"no-repeat\";s:15:\"background-size\";s:5:\"cover\";s:21:\"background-attachment\";s:6:\"scroll\";s:19:\"background-position\";s:13:\"center center\";s:16:\"background-image\";s:95:\"https://joshconstructions.hipercomhosting.com/wp-content/uploads/2016/01/demo-builtpress-03.jpg\";s:5:\"media\";a:4:{s:2:\"id\";s:4:\"2552\";s:6:\"height\";s:4:\"1280\";s:5:\"width\";s:4:\"1920\";s:9:\"thumbnail\";s:103:\"https://joshconstructions.hipercomhosting.com/wp-content/uploads/2016/01/demo-builtpress-03-150x150.jpg\";}}s:23:\"style_bg_title_parallax\";s:1:\"0\";s:11:\"color_title\";s:0:\"\";s:14:\"color_subtitle\";s:0:\"\";s:16:\"color_breadcrumb\";s:0:\"\";s:15:\"style_bg_footer\";a:7:{s:16:\"background-color\";s:11:\"transparent\";s:17:\"background-repeat\";s:0:\"\";s:15:\"background-size\";s:0:\"\";s:21:\"background-attachment\";s:0:\"\";s:19:\"background-position\";s:13:\"center center\";s:16:\"background-image\";s:95:\"https://joshconstructions.hipercomhosting.com/wp-content/uploads/2016/01/demo-builtpress-05.jpg\";s:5:\"media\";a:4:{s:2:\"id\";s:4:\"2546\";s:6:\"height\";s:4:\"1080\";s:5:\"width\";s:4:\"1920\";s:9:\"thumbnail\";s:103:\"https://joshconstructions.hipercomhosting.com/wp-content/uploads/2016/01/demo-builtpress-05-150x150.jpg\";}}s:20:\"color_footer_heading\";s:0:\"\";s:17:\"color_footer_text\";s:0:\"\";s:17:\"color_footer_link\";s:0:\"\";s:23:\"color_footer_link_hover\";s:0:\"\";s:18:\"style_bg_copyright\";s:0:\"\";s:20:\"color_copyright_text\";s:0:\"\";s:26:\"color_copyright_link_hover\";s:0:\"\";s:9:\"font_body\";a:7:{s:11:\"font-family\";s:6:\"Roboto\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:7:\"subsets\";s:5:\"latin\";s:10:\"text-align\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:5:\"color\";s:0:\"\";}s:9:\"font_menu\";a:8:{s:11:\"font-family\";s:10:\"Montserrat\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:5:\"latin\";s:10:\"text-align\";s:0:\"\";s:5:\"color\";s:0:\"\";}s:12:\"font_heading\";a:6:{s:11:\"font-family\";s:10:\"Montserrat\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:7:\"subsets\";s:5:\"latin\";s:10:\"text-align\";s:0:\"\";s:5:\"color\";s:0:\"\";}s:11:\"post_layout\";s:2:\"rb\";s:15:\"post_page_title\";s:15:\"Blog Page Title\";s:9:\"post_tags\";s:1:\"1\";s:11:\"post_author\";s:1:\"1\";s:14:\"page_portfolio\";s:0:\"\";s:12:\"page_service\";s:0:\"\";s:10:\"woo_layout\";s:2:\"rb\";s:9:\"woo_count\";s:1:\"1\";s:10:\"social_url\";a:13:{s:8:\"facebook\";s:1:\"#\";s:6:\"google\";s:1:\"#\";s:7:\"twitter\";s:1:\"#\";s:8:\"linkedin\";s:1:\"#\";s:8:\"dribbble\";s:1:\"#\";s:9:\"instagram\";s:1:\"#\";s:9:\"pinterest\";s:1:\"#\";s:10:\"foursquare\";s:1:\"#\";s:6:\"tumblr\";s:1:\"#\";s:7:\"youtube\";s:1:\"#\";s:5:\"vimeo\";s:1:\"#\";s:6:\"flickr\";s:1:\"#\";s:3:\"rss\";s:1:\"#\";}s:9:\"custom_js\";s:0:\"\";s:10:\"custom_css\";s:0:\"\";s:14:\"sidebar_widget\";a:1:{i:0;s:8:\"Services\";}s:15:\"envato_username\";s:0:\"\";s:10:\"envato_api\";s:0:\"\";}", "yes");
INSERT INTO `wpge_options` VALUES("156", "recently_activated", "a:2:{s:57:\"google-language-translator/google-language-translator.php\";i:1756739207;s:35:\"elfsight-yottie/elfsight-yottie.php\";i:1756738179;}", "off");
INSERT INTO `wpge_options` VALUES("157", "redux_version_upgraded_from", "3.6.7.7", "yes");
INSERT INTO `wpge_options` VALUES("160", "widget_mc4wp_form_widget", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("161", "vc_version", "5.5.2", "yes");
INSERT INTO `wpge_options` VALUES("196", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `wpge_options` VALUES("197", "woocommerce_enable_reviews", "yes", "yes");
INSERT INTO `wpge_options` VALUES("198", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `wpge_options` VALUES("199", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `wpge_options` VALUES("200", "woocommerce_enable_review_rating", "yes", "yes");
INSERT INTO `wpge_options` VALUES("201", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `wpge_options` VALUES("202", "woocommerce_shop_page_id", "6", "yes");
INSERT INTO `wpge_options` VALUES("203", "woocommerce_shop_page_display", "", "yes");
INSERT INTO `wpge_options` VALUES("204", "woocommerce_category_archive_display", "", "yes");
INSERT INTO `wpge_options` VALUES("205", "woocommerce_default_catalog_orderby", "menu_order", "yes");
INSERT INTO `wpge_options` VALUES("206", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `wpge_options` VALUES("207", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `wpge_options` VALUES("208", "shop_catalog_image_size", "a:3:{s:5:\"width\";i:600;s:6:\"height\";i:750;s:4:\"crop\";b:1;}", "yes");
INSERT INTO `wpge_options` VALUES("209", "shop_single_image_size", "a:3:{s:5:\"width\";i:600;s:6:\"height\";i:750;s:4:\"crop\";b:1;}", "yes");
INSERT INTO `wpge_options` VALUES("210", "shop_thumbnail_image_size", "a:3:{s:5:\"width\";i:90;s:6:\"height\";i:90;s:4:\"crop\";b:1;}", "yes");
INSERT INTO `wpge_options` VALUES("211", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `wpge_options` VALUES("212", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `wpge_options` VALUES("213", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `wpge_options` VALUES("214", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `wpge_options` VALUES("215", "woocommerce_stock_email_recipient", "admin@imertec.com.ec", "no");
INSERT INTO `wpge_options` VALUES("216", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `wpge_options` VALUES("217", "woocommerce_notify_no_stock_amount", "0", "yes");
INSERT INTO `wpge_options` VALUES("218", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `wpge_options` VALUES("219", "woocommerce_stock_format", "", "yes");
INSERT INTO `wpge_options` VALUES("220", "woocommerce_file_download_method", "force", "no");
INSERT INTO `wpge_options` VALUES("221", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `wpge_options` VALUES("222", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `wpge_options` VALUES("223", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `wpge_options` VALUES("224", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `wpge_options` VALUES("225", "woocommerce_shipping_tax_class", "inherit", "yes");
INSERT INTO `wpge_options` VALUES("226", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `wpge_options` VALUES("38354", "woocommerce_refund_returns_page_id", "2705", "yes");
INSERT INTO `wpge_options` VALUES("228", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `wpge_options` VALUES("229", "woocommerce_tax_display_cart", "excl", "no");
INSERT INTO `wpge_options` VALUES("230", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `wpge_options` VALUES("152", "wpcf7", "a:2:{s:7:\"version\";s:5:\"6.1.1\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1639526860;s:7:\"version\";s:5:\"5.5.3\";s:11:\"count_valid\";i:3;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO `wpge_options` VALUES("231", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `wpge_options` VALUES("232", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `wpge_options` VALUES("233", "woocommerce_shipping_cost_requires_address", "no", "no");
INSERT INTO `wpge_options` VALUES("234", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `wpge_options` VALUES("235", "woocommerce_shipping_debug_mode", "no", "no");
INSERT INTO `wpge_options` VALUES("236", "woocommerce_enable_coupons", "yes", "yes");
INSERT INTO `wpge_options` VALUES("237", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `wpge_options` VALUES("238", "woocommerce_enable_guest_checkout", "yes", "no");
INSERT INTO `wpge_options` VALUES("239", "woocommerce_force_ssl_checkout", "no", "yes");
INSERT INTO `wpge_options` VALUES("240", "woocommerce_unforce_ssl_checkout", "no", "yes");
INSERT INTO `wpge_options` VALUES("241", "woocommerce_cart_page_id", "7", "yes");
INSERT INTO `wpge_options` VALUES("242", "woocommerce_checkout_page_id", "8", "yes");
INSERT INTO `wpge_options` VALUES("243", "woocommerce_terms_page_id", "", "no");
INSERT INTO `wpge_options` VALUES("244", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `wpge_options` VALUES("245", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `wpge_options` VALUES("246", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `wpge_options` VALUES("165", "theme_st_options-transients", "a:4:{s:14:\"changed_values\";a:0:{}s:9:\"last_save\";i:1756756148;s:13:\"last_compiler\";i:1756756148;s:11:\"last_import\";i:1756756148;}", "yes");
INSERT INTO `wpge_options` VALUES("183104", "revslider_update_revision_current", "6.4.10", "auto");
INSERT INTO `wpge_options` VALUES("166", "wpb_js_composer_license_activation_notified", "yes", "yes");
INSERT INTO `wpge_options` VALUES("167", "mc4wp_flash_messages", "a:0:{}", "no");
INSERT INTO `wpge_options` VALUES("743", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:8:\"producto\";s:13:\"category_base\";s:18:\"categoria-producto\";s:8:\"tag_base\";s:17:\"etiqueta-producto\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "yes");
INSERT INTO `wpge_options` VALUES("744", "current_theme_supports_woocommerce", "yes", "yes");
INSERT INTO `wpge_options` VALUES("745", "woocommerce_queue_flush_rewrite_rules", "no", "yes");
INSERT INTO `wpge_options` VALUES("749", "default_product_cat", "95", "yes");
INSERT INTO `wpge_options` VALUES("247", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `wpge_options` VALUES("248", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `wpge_options` VALUES("249", "woocommerce_myaccount_page_id", "9", "yes");
INSERT INTO `wpge_options` VALUES("250", "woocommerce_enable_signup_and_login_from_checkout", "yes", "no");
INSERT INTO `wpge_options` VALUES("251", "woocommerce_enable_myaccount_registration", "no", "no");
INSERT INTO `wpge_options` VALUES("252", "woocommerce_enable_checkout_login_reminder", "yes", "no");
INSERT INTO `wpge_options` VALUES("253", "woocommerce_registration_generate_username", "yes", "no");
INSERT INTO `wpge_options` VALUES("254", "woocommerce_registration_generate_password", "no", "no");
INSERT INTO `wpge_options` VALUES("255", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `wpge_options` VALUES("256", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `wpge_options` VALUES("257", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `wpge_options` VALUES("258", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `wpge_options` VALUES("259", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `wpge_options` VALUES("260", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `wpge_options` VALUES("261", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `wpge_options` VALUES("262", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `wpge_options` VALUES("263", "woocommerce_email_from_name", "IMERTEC", "no");
INSERT INTO `wpge_options` VALUES("264", "woocommerce_email_from_address", "admin@imertec.com.ec", "no");
INSERT INTO `wpge_options` VALUES("265", "woocommerce_email_header_image", "", "no");
INSERT INTO `wpge_options` VALUES("266", "woocommerce_email_footer_text", "IMERTEC", "no");
INSERT INTO `wpge_options` VALUES("267", "woocommerce_email_base_color", "#96588a", "no");
INSERT INTO `wpge_options` VALUES("268", "woocommerce_email_background_color", "#f7f7f7", "no");
INSERT INTO `wpge_options` VALUES("269", "woocommerce_email_body_background_color", "#ffffff", "no");
INSERT INTO `wpge_options` VALUES("270", "woocommerce_email_text_color", "#3c3c3c", "no");
INSERT INTO `wpge_options` VALUES("271", "woocommerce_api_enabled", "yes", "yes");
INSERT INTO `wpge_options` VALUES("38198", "woocommerce_schema_version", "920", "yes");
INSERT INTO `wpge_options` VALUES("293", "woocommerce_meta_box_errors", "a:0:{}", "yes");
INSERT INTO `wpge_options` VALUES("33787", "woocommerce_version", "10.1.2", "yes");
INSERT INTO `wpge_options` VALUES("38165", "woocommerce_db_version", "10.1.2", "yes");
INSERT INTO `wpge_options` VALUES("277", "woocommerce_admin_notices", "a:3:{i:0;s:44:\"woocommerce_legacy_rest_api_plugin_activated\";i:1;s:34:\"download_directories_sync_complete\";i:2;s:14:\"template_files\";}", "yes");
INSERT INTO `wpge_options` VALUES("278", "_transient_woocommerce_webhook_ids", "a:0:{}", "yes");
INSERT INTO `wpge_options` VALUES("279", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("280", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("281", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("282", "widget_woocommerce_price_filter", "a:2:{i:2;a:1:{s:5:\"title\";s:15:\"Filter by price\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("283", "widget_woocommerce_product_categories", "a:2:{i:2;a:6:{s:5:\"title\";s:18:\"Product Categories\";s:7:\"orderby\";s:4:\"name\";s:8:\"dropdown\";i:0;s:5:\"count\";i:0;s:12:\"hierarchical\";s:1:\"1\";s:18:\"show_children_only\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("284", "widget_woocommerce_product_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("285", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("286", "widget_woocommerce_products", "a:2:{i:2;a:7:{s:5:\"title\";s:8:\"Products\";s:6:\"number\";s:1:\"3\";s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("287", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("288", "widget_woocommerce_top_rated_products", "a:2:{i:2;a:2:{s:5:\"title\";s:18:\"Top Rated Products\";s:6:\"number\";s:1:\"3\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("289", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("290", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("184675", "category_children", "a:0:{}", "auto");
INSERT INTO `wpge_options` VALUES("184677", "product_cat_children", "a:0:{}", "auto");
INSERT INTO `wpge_options` VALUES("294", "woocommerce_product_type", "both", "yes");
INSERT INTO `wpge_options` VALUES("295", "woocommerce_allow_tracking", "yes", "on");
INSERT INTO `wpge_options` VALUES("296", "woocommerce_tracker_last_send", "1757085455", "yes");
INSERT INTO `wpge_options` VALUES("297", "woocommerce_ppec_paypal_settings", "a:1:{s:7:\"enabled\";s:2:\"no\";}", "yes");
INSERT INTO `wpge_options` VALUES("298", "woocommerce_paypal_settings", "a:10:{s:7:\"enabled\";s:2:\"no\";s:5:\"email\";b:0;s:5:\"title\";s:6:\"PayPal\";s:11:\"description\";s:100:\"Paga a través de PayPal; puedes pagar con tu tarjeta de crédito si no tienes una cuenta de PayPal.\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:14:\"receiver_email\";b:0;s:14:\"identity_token\";s:0:\"\";s:12:\"_should_load\";s:2:\"no\";s:12:\"api_username\";s:0:\"\";}", "on");
INSERT INTO `wpge_options` VALUES("299", "_transient_shipping-transient-version", "1517190160", "yes");
INSERT INTO `wpge_options` VALUES("300", "woocommerce_flat_rate_1_settings", "a:3:{s:5:\"title\";s:11:\"Precio fijo\";s:10:\"tax_status\";s:7:\"taxable\";s:4:\"cost\";s:2:\"20\";}", "yes");
INSERT INTO `wpge_options` VALUES("301", "woocommerce_flat_rate_2_settings", "a:3:{s:5:\"title\";s:11:\"Precio fijo\";s:10:\"tax_status\";s:7:\"taxable\";s:4:\"cost\";s:2:\"20\";}", "yes");
INSERT INTO `wpge_options` VALUES("302", "_transient_product_query-transient-version", "1757270097", "yes");
INSERT INTO `wpge_options` VALUES("413", "_transient_orders-transient-version", "1517238531", "yes");
INSERT INTO `wpge_options` VALUES("326", "revslider-update-check-short", "1757172801", "yes");
INSERT INTO `wpge_options` VALUES("327", "revslider-templates-check", "1756953067", "yes");
INSERT INTO `wpge_options` VALUES("334", "revslider-global-settings", "{\"version\":\"6.2.0\",\"permission\":\"admin\",\"includeids\":\"\",\"script\":{\"footer\":true,\"defer\":true,\"full\":false},\"fonturl\":\"\",\"size\":{\"desktop\":1240,\"notebook\":1024,\"tablet\":778,\"mobile\":480}}", "yes");
INSERT INTO `wpge_options` VALUES("335", "revslider_update_version", "6.4.10", "yes");
INSERT INTO `wpge_options` VALUES("336", "widget_rev-slider-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wpge_options` VALUES("402", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "off");
INSERT INTO `wpge_options` VALUES("422", "woocommerce_tracker_ua", "a:16:{i:0;s:129:\"mozilla/5.0 (windows nt 10.0; win64; x64) applewebkit/537.36 (khtml, like gecko) chrome/58.0.3029.110 safari/537.36 edge/16.16299\";i:1;s:128:\"mozilla/5.0 (windows nt 10.0; win64; x64) applewebkit/537.36 (khtml, like gecko) chrome/51.0.2704.79 safari/537.36 edge/14.14393\";i:2;s:76:\"mozilla/5.0 (windows nt 10.0; wow64; trident/7.0; touch; rv:11.0) like gecko\";i:3;s:69:\"mozilla/5.0 (windows nt 10.0; wow64; trident/7.0; rv:11.0) like gecko\";i:4;s:129:\"mozilla/5.0 (windows nt 10.0; win64; x64) applewebkit/537.36 (khtml, like gecko) chrome/64.0.3282.140 safari/537.36 edge/18.17763\";i:5;s:115:\"mozilla/5.0 (windows nt 10.0; win64; x64) applewebkit/537.36 (khtml, like gecko) chrome/74.0.3729.108 safari/537.36\";i:6;s:117:\"mozilla/5.0 (macintosh; intel mac os x 10_10_5) applewebkit/603.3.8 (khtml, like gecko) version/10.1.2 safari/603.3.8\";i:7;s:113:\"Mozilla/5.0 (Linux; Android 10; SM-T295) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/96.0.4664.92 Safari/537.36\";i:8;s:131:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/96.0.4664.93 Safari/537.36 Edg/96.0.1054.53\";i:9;s:131:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.71 Safari/537.36 Edg/97.0.1072.62\";i:10;s:131:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.99 Safari/537.36 Edg/97.0.1072.76\";i:11;s:131:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/99.0.4844.51 Safari/537.36 Edg/99.0.1150.39\";i:12;s:116:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.6367.207 Safari/537.36\";i:13;s:130:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/115.0.0.0 Safari/537.36 Edg/115.0.1901.203\";i:14;s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36\";i:15;s:78:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:55.0) Gecko/20100101 Firefox/55.0\";}", "off");
INSERT INTO `wpge_options` VALUES("582", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:20:\"admin@imertec.com.ec\";s:7:\"version\";s:6:\"5.8.11\";s:9:\"timestamp\";i:1754461018;}", "no");
INSERT INTO `wpge_options` VALUES("38161", "woocommerce_thumbnail_image_width", "300", "yes");
INSERT INTO `wpge_options` VALUES("38162", "woocommerce_thumbnail_cropping", "1:1", "yes");
INSERT INTO `wpge_options` VALUES("38163", "woocommerce_single_image_width", "600", "yes");
INSERT INTO `wpge_options` VALUES("38105", "db_upgraded", "", "on");
INSERT INTO `wpge_options` VALUES("9804", "woocommerce_maybe_regenerate_images_hash", "991b1ca641921cf0f5baf7a2fe85861b", "yes");
INSERT INTO `wpge_options` VALUES("13999", "mc4wp", "a:4:{s:7:\"api_key\";s:0:\"\";s:20:\"allow_usage_tracking\";i:0;s:15:\"debug_log_level\";s:7:\"warning\";s:18:\"first_activated_on\";i:1567440363;}", "yes");
INSERT INTO `wpge_options` VALUES("21015", "rs-templates-new", "", "off");
INSERT INTO `wpge_options` VALUES("21016", "rs-templates", "a:2:{s:6:\"slider\";a:801:{i:0;a:24:{s:2:\"id\";s:1:\"1\";s:5:\"title\";s:16:\"Classic Carousel\";s:5:\"alias\";s:16:\"classic-carousel\";s:3:\"zip\";s:20:\"classic-carousel.zip\";s:3:\"uid\";s:32:\"146a01dd380c0cdee85c4456ee68cd84\";s:3:\"img\";s:27:\"classic-carousel/slider.jpg\";s:7:\"preview\";s:147:\"http://revolution.themepunch.com/carousel-slider-plugin/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=carousel-slider-plugin\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:141:\"<span class=\"ttm_content\">Our classic, full-width carousel example. Drag, swipe or click to navigate!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-22 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:1;a:24:{s:2:\"id\";s:1:\"2\";s:5:\"title\";s:14:\"Classic Slider\";s:5:\"alias\";s:13:\"classicslider\";s:3:\"zip\";s:17:\"classicslider.zip\";s:3:\"uid\";s:32:\"a0d6a9248c9066b404ba0f1cdadc5cf2\";s:3:\"img\";s:24:\"classicslider/slider.jpg\";s:7:\"preview\";s:157:\"http://revolution.themepunch.com/wordpress-slideshow-gallery/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-slideshow-gallery\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:136:\" <span class=\"ttm_content\">A classic slideshow example with timer, bullets and arrow navigation.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:2;a:24:{s:2:\"id\";s:1:\"3\";s:5:\"title\";s:12:\"Content Tabs\";s:5:\"alias\";s:11:\"contenttabs\";s:3:\"zip\";s:15:\"contenttabs.zip\";s:3:\"uid\";s:32:\"e02e91604b690123a3d07a65582c4fd0\";s:3:\"img\";s:22:\"contenttabs/slider.jpg\";s:7:\"preview\";s:161:\"http://revolution.themepunch.com/wordpress-content-tabs-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-content-tabs-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:170:\" <span class=\"ttm_content\">An auto-size slider with a cool split-text animation effect. Navigate with vertical bullets and thumbs.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:3;a:25:{s:2:\"id\";s:1:\"4\";s:5:\"title\";s:13:\"Facebook Feed\";s:5:\"alias\";s:13:\"facebook-feed\";s:3:\"zip\";s:17:\"facebook-feed.zip\";s:3:\"uid\";s:32:\"5506431d5b1babcb25dcf52c508d42e3\";s:3:\"img\";s:24:\"facebook-feed/slider.jpg\";s:7:\"preview\";s:149:\"http://revolution.themepunch.com/wordpress-facebook-feed/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-facebook-feed\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:174:\"<span class=\"ttm_content\"> This slider is automatically populated by a Facebook stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Facebook Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:4;a:24:{s:2:\"id\";s:1:\"5\";s:5:\"title\";s:7:\"Fashion\";s:5:\"alias\";s:7:\"fashion\";s:3:\"zip\";s:11:\"fashion.zip\";s:3:\"uid\";s:32:\"4f4b914d6db35e19101ff003c4e7ea3a\";s:3:\"img\";s:18:\"fashion/slider.jpg\";s:7:\"preview\";s:165:\"http://revolution.themepunch.com/wordpress-one-page-slider-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-one-page-slider-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:183:\"  <span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:5;a:24:{s:2:\"id\";s:1:\"6\";s:5:\"title\";s:14:\"Flickr Gallery\";s:5:\"alias\";s:14:\"flickr-gallery\";s:3:\"zip\";s:18:\"flickr-gallery.zip\";s:3:\"uid\";s:32:\"ad85cfac7acfa678e6a1b8febfee51ed\";s:3:\"img\";s:25:\"flickr-gallery/slider.jpg\";s:7:\"preview\";s:149:\"http://revolution.themepunch.com/wordpress-flickr-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-flickr-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:173:\" <span class=\"ttm_content\"> This slider is automatically populated by a Flickr stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:6;a:26:{s:2:\"id\";s:1:\"7\";s:5:\"title\";s:3:\"Gym\";s:5:\"alias\";s:3:\"gym\";s:3:\"zip\";s:7:\"gym.zip\";s:3:\"uid\";s:32:\"e4d81f13f96fb9bc905f4ad89615032b\";s:3:\"img\";s:14:\"gym/slider.jpg\";s:7:\"preview\";s:153:\"http://revolution.themepunch.com/one-page-wordpress-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=one-page-wordpress-slider\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:189:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the slider menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:7;a:24:{s:2:\"id\";s:1:\"8\";s:5:\"title\";s:18:\"Highlight Carousel\";s:5:\"alias\";s:18:\"highlight-carousel\";s:3:\"zip\";s:22:\"highlight-carousel.zip\";s:3:\"uid\";s:32:\"ada52163f723a942f782351fa0396b3d\";s:3:\"img\";s:29:\"highlight-carousel/slider.jpg\";s:7:\"preview\";s:147:\"http://revolution.themepunch.com/wordpress-swipe-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-swipe-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:138:\"  <span class=\"ttm_content\">A swipe-controlled carousel with an additional tab-based navigation.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:8;a:24:{s:2:\"id\";s:1:\"9\";s:5:\"title\";s:18:\"Highlight Showcase\";s:5:\"alias\";s:18:\"highlight-showcase\";s:3:\"zip\";s:22:\"highlight-showcase.zip\";s:3:\"uid\";s:32:\"2bfe0bd410fb48fec9d942eab1e21530\";s:3:\"img\";s:29:\"highlight-showcase/slider.jpg\";s:7:\"preview\";s:159:\"http://revolution.themepunch.com/wordpress-parallax-slideshow/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-slideshow\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">A tab-based navigation, a slideshow timer and cool animations make this slider interesting!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:9;a:24:{s:2:\"id\";s:2:\"10\";s:5:\"title\";s:10:\"Image Hero\";s:5:\"alias\";s:10:\"image-hero\";s:3:\"zip\";s:13:\"imagehero.zip\";s:3:\"uid\";s:32:\"7db18781d44f2adc28c962440894aac1\";s:3:\"img\";s:20:\"imagehero/slider.jpg\";s:7:\"preview\";s:143:\"http://revolution.themepunch.com/wordpress-hero-image/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-hero-image\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:121:\"<span class=\"ttm_content\">A commonly used full-width image hero block with texts.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:10;a:26:{s:2:\"id\";s:2:\"11\";s:5:\"title\";s:17:\"Instagram Gallery\";s:5:\"alias\";s:13:\"insta-gallery\";s:3:\"zip\";s:17:\"insta-gallery.zip\";s:3:\"uid\";s:32:\"711732b0d42ec2b57818a2b9b1d86cba\";s:3:\"img\";s:24:\"insta-gallery/slider.jpg\";s:7:\"preview\";s:157:\"http://revolution.themepunch.com/wordpress-instagram-gallery/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-instagram-gallery\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"640\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:174:\"<span class=\"ttm_content\">This slider is automatically populated by a Instagram stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:416:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Instagram Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:11;a:26:{s:2:\"id\";s:2:\"12\";s:5:\"title\";s:21:\"Levano Restaurant Bar\";s:5:\"alias\";s:19:\"levanorestaurantbar\";s:3:\"zip\";s:23:\"levanorestaurantbar.zip\";s:3:\"uid\";s:32:\"4178f837db67d1b2eb6cb5840bbd0b42\";s:3:\"img\";s:30:\"levanorestaurantbar/slider.jpg\";s:7:\"preview\";s:161:\"http://revolution.themepunch.com/wordpress-front-page-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-front-page-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:181:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:12;a:25:{s:2:\"id\";s:2:\"13\";s:5:\"title\";s:19:\"Main Feature Slider\";s:5:\"alias\";s:11:\"mainfeature\";s:3:\"zip\";s:15:\"mainfeature.zip\";s:3:\"uid\";s:32:\"1e002a3230ab00095bedc6f60393ee7f\";s:3:\"img\";s:22:\"mainfeature/slider.jpg\";s:7:\"preview\";s:127:\"http://revolution.themepunch.com/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=revolution.themepunch.com\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"750\";s:11:\"description\";s:127:\" <span class=\"ttm_content\">A slightly stripped down version of the main preview slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:13;a:26:{s:2:\"id\";s:2:\"14\";s:5:\"title\";s:17:\"Media Gallery Two\";s:5:\"alias\";s:17:\"media-gallery-two\";s:3:\"zip\";s:21:\"media-gallery-two.zip\";s:3:\"uid\";s:32:\"d002f1b1b55805f9322c264c5504ba5a\";s:3:\"img\";s:28:\"media-gallery-two/slider.jpg\";s:7:\"preview\";s:163:\"http://revolution.themepunch.com/wordpress-media-gallery-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-media-gallery-slider\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:6:\"6.2.22\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"692\";s:11:\"description\";s:127:\"<span class=\"ttm_content\">A media gallery example with Vimeo, HTML5 and Youtube videos.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change media and titles.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:14;a:25:{s:2:\"id\";s:2:\"15\";s:5:\"title\";s:23:\"Media Carousel Autoplay\";s:5:\"alias\";s:23:\"media-carousel-autoplay\";s:3:\"zip\";s:27:\"media-carousel-autoplay.zip\";s:3:\"uid\";s:32:\"393d7875b1cc9d933378b35e4f645d76\";s:3:\"img\";s:34:\"media-carousel-autoplay/slider.jpg\";s:7:\"preview\";s:149:\"http://revolution.themepunch.com/wordpress-media-gallery/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-media-gallery\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"720\";s:6:\"height\";s:3:\"405\";s:11:\"description\";s:153:\"<span class=\"ttm_content\">A media carousel with \"autoplay\" activated. Swipe or click tabs to navigate the slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change media and caption texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:15;a:25:{s:2:\"id\";s:2:\"16\";s:5:\"title\";s:21:\"News Background Video\";s:5:\"alias\";s:21:\"news-background-video\";s:3:\"zip\";s:17:\"news-bg-video.zip\";s:3:\"uid\";s:32:\"a0efe44ac3af0f958b3f84c816a08272\";s:3:\"img\";s:24:\"news-bg-video/slider.jpg\";s:7:\"preview\";s:151:\"http://revolution.themepunch.com/wordpress-content-blocks/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-content-blocks\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A hero block with HTML5 background video that plays when entering the screen.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:16;a:25:{s:2:\"id\";s:2:\"17\";s:5:\"title\";s:12:\"News Gallery\";s:5:\"alias\";s:12:\"news-gallery\";s:3:\"zip\";s:16:\"news-gallery.zip\";s:3:\"uid\";s:32:\"3a069c3b286dbb9ee435563f747e3300\";s:3:\"img\";s:23:\"news-gallery/slider.jpg\";s:7:\"preview\";s:147:\"http://revolution.themepunch.com/wordpress-news-rotator/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-news-rotator\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:131:\"<span class=\"ttm_content\">A news gallery slideshow with tab navigation. Great for any blog!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:17;a:25:{s:2:\"id\";s:2:\"18\";s:5:\"title\";s:23:\"News Gallery Post Based\";s:5:\"alias\";s:23:\"news-gallery-post-based\";s:3:\"zip\";s:27:\"news-gallery-post-based.zip\";s:3:\"uid\";s:32:\"32fe05b1039c29ab9420bfd15aec5488\";s:3:\"img\";s:34:\"news-gallery-post-based/slider.jpg\";s:7:\"preview\";s:145:\"http://revolution.themepunch.com/wordpress-post-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-post-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:125:\"<span class=\"ttm_content\"> This slider is automatically populated by WordPress posts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:423:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Post-Based Slider\"</a>. Make sure to select the post type you want to display in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:18;a:25:{s:2:\"id\";s:2:\"19\";s:5:\"title\";s:9:\"News Hero\";s:5:\"alias\";s:9:\"news-hero\";s:3:\"zip\";s:13:\"news-hero.zip\";s:3:\"uid\";s:32:\"96a0385538a17c8c81ed8175740f70ea\";s:3:\"img\";s:20:\"news-hero/slider.jpg\";s:7:\"preview\";s:151:\"http://revolution.themepunch.com/wordpress-content-blocks/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-content-blocks\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:107:\"<span class=\"ttm_content\">A image hero block with ken burns effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:19;a:25:{s:2:\"id\";s:2:\"20\";s:5:\"title\";s:10:\"News Video\";s:5:\"alias\";s:10:\"news-video\";s:3:\"zip\";s:14:\"news-video.zip\";s:3:\"uid\";s:32:\"f901e9e16e0363248156c2209eb584e9\";s:3:\"img\";s:21:\"news-video/slider.jpg\";s:7:\"preview\";s:151:\"http://revolution.themepunch.com/wordpress-content-blocks/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-content-blocks\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:128:\"<span class=\"ttm_content\">A Vimeo background video hero block with play / pause buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the video and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:20;a:26:{s:2:\"id\";s:2:\"21\";s:5:\"title\";s:15:\"Newsletter Hero\";s:5:\"alias\";s:15:\"newsletter-hero\";s:3:\"zip\";s:19:\"newsletter-hero.zip\";s:3:\"uid\";s:32:\"6290a9864d8c4c6311784586ed1cc5fe\";s:3:\"img\";s:26:\"newsletter-hero/slider.jpg\";s:7:\"preview\";s:157:\"http://revolution.themepunch.com/wordpress-newsletter-signup/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-newsletter-signup\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:137:\"<span class=\"ttm_content\">This hero block uses a custom styled Mailchimp newsletter signup field.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:435:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image, texts, and <a href=\"https://www.themepunch.com/faq/how-to-setup-mailchimp-for-the-newsletter-hero-template/\" target=\"_blank\">Mailchimp code</a>.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:21;a:25:{s:2:\"id\";s:2:\"22\";s:5:\"title\";s:11:\"Not Generic\";s:5:\"alias\";s:10:\"notgeneric\";s:3:\"zip\";s:14:\"notgeneric.zip\";s:3:\"uid\";s:32:\"9d87ba95e02210a9f82387add2ceadf9\";s:3:\"img\";s:21:\"notgeneric/slider.jpg\";s:7:\"preview\";s:157:\"http://revolution.themepunch.com/wordpress-fullscreen-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-fullscreen-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">A full-screen slider with a layer based navigation and sleek content elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:22;a:26:{s:2:\"id\";s:2:\"23\";s:5:\"title\";s:11:\"Photography\";s:5:\"alias\";s:11:\"photography\";s:3:\"zip\";s:15:\"photography.zip\";s:3:\"uid\";s:32:\"1b2072547afb75e49f33b016751ed360\";s:3:\"img\";s:22:\"photography/slider.jpg\";s:7:\"preview\";s:159:\"http://revolution.themepunch.com/wordpress-photography-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-photography-slider\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:23;a:25:{s:2:\"id\";s:2:\"24\";s:5:\"title\";s:20:\"Photography Carousel\";s:5:\"alias\";s:20:\"photography-carousel\";s:3:\"zip\";s:24:\"photography-carousel.zip\";s:3:\"uid\";s:32:\"9a84b859ba23dc49ba8784e3a86545fa\";s:3:\"img\";s:31:\"photography-carousel/slider.jpg\";s:7:\"preview\";s:149:\"http://revolution.themepunch.com/wordpress-photo-gallery/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-photo-gallery\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">A front-page carousel that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:24;a:26:{s:2:\"id\";s:2:\"25\";s:5:\"title\";s:16:\"Search Form Hero\";s:5:\"alias\";s:16:\"search-form-hero\";s:3:\"zip\";s:20:\"search-form-hero.zip\";s:3:\"uid\";s:32:\"e09eb1bd0f22b3a2b02a1aa251dd1f3e\";s:3:\"img\";s:27:\"search-form-hero/slider.jpg\";s:7:\"preview\";s:155:\"http://revolution.themepunch.com/wordpress-search-form-hero/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-search-form-hero\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This hero block uses a custom styled input field to show search results on a WordPress site.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:320:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image, texts, and search field code.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:25;a:25:{s:2:\"id\";s:2:\"26\";s:5:\"title\";s:17:\"Showcase Carousel\";s:5:\"alias\";s:16:\"showcasecarousel\";s:3:\"zip\";s:20:\"showcasecarousel.zip\";s:3:\"uid\";s:32:\"c5ca218398331bd2c064efc2f62eae56\";s:3:\"img\";s:27:\"showcasecarousel/slider.jpg\";s:7:\"preview\";s:159:\"http://revolution.themepunch.com/wordpress-cover-flow-gallery/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-cover-flow-gallery\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:129:\"<span class=\"ttm_content\">A fancy carousel that rotates, fades and scales slider items.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:284:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:26;a:25:{s:2:\"id\";s:2:\"27\";s:5:\"title\";s:11:\"Sports Hero\";s:5:\"alias\";s:11:\"sports-hero\";s:3:\"zip\";s:14:\"sportshero.zip\";s:3:\"uid\";s:32:\"8de7a145f32a362d618d2595ffa2f724\";s:3:\"img\";s:21:\"sportshero/slider.jpg\";s:7:\"preview\";s:143:\"http://revolution.themepunch.com/wordpress-image-hero/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-image-hero\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:113:\"<span class=\"ttm_content\">An sports themed image hero block with buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:28;a:25:{s:2:\"id\";s:2:\"29\";s:5:\"title\";s:13:\"Vimeo Gallery\";s:5:\"alias\";s:13:\"vimeo-gallery\";s:3:\"zip\";s:17:\"vimeo-gallery.zip\";s:3:\"uid\";s:32:\"fa824ce1ff3942ec268fc9eda60df539\";s:3:\"img\";s:24:\"vimeo-gallery/slider.jpg\";s:7:\"preview\";s:149:\"http://revolution.themepunch.com/wordpress-vimeo-gallery/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-vimeo-gallery\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"692\";s:11:\"description\";s:170:\"<span class=\"ttm_content\">This slider is automatically populated by a Vimeo stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:412:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Vimeo Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:29;a:25:{s:2:\"id\";s:2:\"30\";s:5:\"title\";s:10:\"Vimeo Hero\";s:5:\"alias\";s:9:\"vimeohero\";s:3:\"zip\";s:13:\"vimeohero.zip\";s:3:\"uid\";s:32:\"c575575f96173d88589cddcb06120b77\";s:3:\"img\";s:20:\"vimeohero/slider.jpg\";s:7:\"preview\";s:143:\"http://revolution.themepunch.com/wordpress-hero-vimeo/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-hero-vimeo\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:116:\"<span class=\"ttm_content\">A commonly used Vimeo video background hero block.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:30;a:25:{s:2:\"id\";s:2:\"31\";s:5:\"title\";s:16:\"Web Product Dark\";s:5:\"alias\";s:16:\"web-product-dark\";s:3:\"zip\";s:20:\"web-product-dark.zip\";s:3:\"uid\";s:32:\"39b872cf0608e63c3a503e58374dc30a\";s:3:\"img\";s:27:\"web-product-dark/slider.jpg\";s:7:\"preview\";s:155:\"http://revolution.themepunch.com/wordpress-frontpage-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-frontpage-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:31;a:25:{s:2:\"id\";s:2:\"32\";s:5:\"title\";s:21:\"Web Product Dark Hero\";s:5:\"alias\";s:21:\"web-product-dark-hero\";s:3:\"zip\";s:25:\"web-product-dark-hero.zip\";s:3:\"uid\";s:32:\"b6784e8925221f36677217979d26e6f0\";s:3:\"img\";s:32:\"web-product-dark-hero/slider.jpg\";s:7:\"preview\";s:147:\"http://revolution.themepunch.com/wordpress-header-image/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-header-image\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:162:\"<span class=\"ttm_content\">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:32;a:25:{s:2:\"id\";s:2:\"33\";s:5:\"title\";s:22:\"Web Product Light Hero\";s:5:\"alias\";s:22:\"web-product-light-hero\";s:3:\"zip\";s:26:\"web-product-light-hero.zip\";s:3:\"uid\";s:32:\"428e65d6aaa6ef775429989d50516492\";s:3:\"img\";s:33:\"web-product-light-hero/slider.jpg\";s:7:\"preview\";s:143:\"http://revolution.themepunch.com/hero-image-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=hero-image-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:162:\"<span class=\"ttm_content\">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:33;a:25:{s:2:\"id\";s:2:\"34\";s:5:\"title\";s:17:\"Web Product Light\";s:5:\"alias\";s:15:\"webproductlight\";s:3:\"zip\";s:19:\"webproductlight.zip\";s:3:\"uid\";s:32:\"fa23dab5bf1139c6393828647a9de4e0\";s:3:\"img\";s:26:\"webproductlight/slider.jpg\";s:7:\"preview\";s:143:\"http://revolution.themepunch.com/wordpress-cover-page/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-cover-page\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:34;a:25:{s:2:\"id\";s:2:\"35\";s:5:\"title\";s:15:\"Youtube Gallery\";s:5:\"alias\";s:15:\"youtube-gallery\";s:3:\"zip\";s:19:\"youtube-gallery.zip\";s:3:\"uid\";s:32:\"ee9e4928ac74f5f0c0b697ce708f5aa7\";s:3:\"img\";s:26:\"youtube-gallery/slider.jpg\";s:7:\"preview\";s:153:\"http://revolution.themepunch.com/wordpress-youtube-gallery/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-youtube-gallery\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:173:\"<span class=\"ttm_content\"> This slider is automatically populated by a YouTube stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:414:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"YouTube Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:35;a:26:{s:2:\"id\";s:2:\"36\";s:5:\"title\";s:12:\"Youtube Hero\";s:5:\"alias\";s:11:\"youtubehero\";s:3:\"zip\";s:15:\"youtubehero.zip\";s:3:\"uid\";s:32:\"e0b2c12a45841bdf21cb96305f2c85bf\";s:3:\"img\";s:22:\"youtubehero/slider.jpg\";s:7:\"preview\";s:151:\"http://revolution.themepunch.com/wordpress-youtube-header/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-youtube-header\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:104:\"<span class=\"ttm_content\">A YouTube video background hero block.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:633:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/enable-sound-for-the-youtube-hero-template/\" target=\"_blank\">enable sound for the background video</a><br /><br />\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:36;a:25:{s:2:\"id\";s:2:\"37\";s:5:\"title\";s:13:\"Scroll Effect\";s:5:\"alias\";s:13:\"scroll-effect\";s:3:\"zip\";s:17:\"scroll-effect.zip\";s:3:\"uid\";s:32:\"417f59e9db87aa7e47c8509eb88d4af6\";s:3:\"img\";s:23:\"scrolleffect/slide1.jpg\";s:7:\"preview\";s:155:\"http://revolution.themepunch.com/big-bold-fullscreen-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=big-bold-fullscreen-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:134:\"<span class=\"ttm_content\">A full-screen slider with a unique scroll effect and big, bold text.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:485:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:37;a:25:{s:2:\"id\";s:2:\"38\";s:5:\"title\";s:12:\"Content Zoom\";s:5:\"alias\";s:12:\"content-zoom\";s:3:\"zip\";s:16:\"content-zoom.zip\";s:3:\"uid\";s:32:\"42ef8cdb70d42ec6ff6fa3b69a027b5f\";s:3:\"img\";s:22:\"contentzoom/slide1.jpg\";s:7:\"preview\";s:141:\"http://revolution.themepunch.com/content-zoom-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=content-zoom-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:243:\"<span class=\"ttm_content\">A very unique full-width slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:38;a:25:{s:2:\"id\";s:2:\"39\";s:5:\"title\";s:13:\"Food Carousel\";s:5:\"alias\";s:13:\"food-carousel\";s:3:\"zip\";s:17:\"food-carousel.zip\";s:3:\"uid\";s:32:\"a7bf54527b6658a0a308c70c729779fe\";s:3:\"img\";s:29:\"foodcarousel/slider_cover.jpg\";s:7:\"preview\";s:143:\"http://revolution.themepunch.com/food-carousel-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=food-carousel-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:267:\"<span class=\"ttm_content\">A fancy carousel with detail content on each slide. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to show and hide layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:40;a:25:{s:2:\"id\";s:2:\"41\";s:5:\"title\";s:22:\"Travel Static Captions\";s:5:\"alias\";s:22:\"travel-static-captions\";s:3:\"zip\";s:26:\"travel-static-captions.zip\";s:3:\"uid\";s:32:\"bbe7d61c7c741ebc7aa1ce1082b0cb71\";s:3:\"img\";s:33:\"travel-static-captions/slide1.jpg\";s:7:\"preview\";s:135:\"http://revolution.themepunch.com/travel-slideshow/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=travel-slideshow\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:148:\"<span class=\"ttm_content\">A slideshow example with static captions layers above a rotating image background.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:41;a:25:{s:2:\"id\";s:2:\"42\";s:5:\"title\";s:7:\"Concept\";s:5:\"alias\";s:7:\"concept\";s:3:\"zip\";s:11:\"concept.zip\";s:3:\"uid\";s:32:\"47cb06083e87503762f6746725117a3c\";s:3:\"img\";s:18:\"concept/slide1.jpg\";s:7:\"preview\";s:157:\"http://revolution.themepunch.com/fullscreen-wordpress-plugin/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=fullscreen-wordpress-plugin\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">A full-screen slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:42;a:25:{s:2:\"id\";s:2:\"43\";s:5:\"title\";s:15:\"True Fullscreen\";s:5:\"alias\";s:17:\"fullscreen-button\";s:3:\"zip\";s:21:\"fullscreen-button.zip\";s:3:\"uid\";s:32:\"618a43bdf89333b555531f6d6ecde359\";s:3:\"img\";s:28:\"fullscreen-button/slide1.jpg\";s:7:\"preview\";s:157:\"http://revolution.themepunch.com/wordpress-sidebar-slideshow/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-sidebar-slideshow\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:246:\"<span class=\"ttm_content\">A slider with a full-screen button that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:297:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change the background images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:43;a:25:{s:2:\"id\";s:2:\"44\";s:5:\"title\";s:16:\"Creative Freedom\";s:5:\"alias\";s:15:\"creativefreedom\";s:3:\"zip\";s:19:\"creativefreedom.zip\";s:3:\"uid\";s:32:\"8902bf6c93126c2c6323626b9e872621\";s:3:\"img\";s:26:\"creativefreedom/slide1.jpg\";s:7:\"preview\";s:147:\"http://revolution.themepunch.com/wordpress-touch-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-touch-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A full-screen slider with a unique vertical navigation and 3D-parallax effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:290:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images, videos and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:44;a:25:{s:2:\"id\";s:2:\"45\";s:5:\"title\";s:17:\"3D Parallax Scene\";s:5:\"alias\";s:13:\"parallaxscene\";s:3:\"zip\";s:17:\"parallaxscene.zip\";s:3:\"uid\";s:32:\"51566f1ce649708e97a0f5dfaf05ea19\";s:3:\"img\";s:24:\"parallaxscene/slide1.jpg\";s:7:\"preview\";s:145:\"http://revolution.themepunch.com/wordpress-3d-parallax/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-3d-parallax\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:328:\"<span class=\"ttm_content\">A 3D-parallax hero scene with mouse-controlled effects. Smart image arrangement creates a convincing 3D effect. Tooltips are shown using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:45;a:25:{s:2:\"id\";s:2:\"46\";s:5:\"title\";s:10:\"Wow Factor\";s:5:\"alias\";s:15:\"slidingoverlays\";s:3:\"zip\";s:19:\"slidingoverlays.zip\";s:3:\"uid\";s:32:\"18002d17e8bc7ca61b0951f5305a759e\";s:3:\"img\";s:26:\"slidingoverlays/slide1.jpg\";s:7:\"preview\";s:157:\"http://revolution.themepunch.com/responsive-wordpress-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=responsive-wordpress-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:106:\"<span class=\"ttm_content\">A 3D-parallax effect full-screen slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:46;a:25:{s:2:\"id\";s:2:\"47\";s:5:\"title\";s:14:\"3D Web Product\";s:5:\"alias\";s:25:\"web-product-light-hero-3d\";s:3:\"zip\";s:29:\"web-product-light-hero-3d.zip\";s:3:\"uid\";s:32:\"efd345c5da805414093e46066cefd751\";s:3:\"img\";s:36:\"web-product-light-hero-3d/slide1.jpg\";s:7:\"preview\";s:139:\"http://revolution.themepunch.com/wordpress-3d-scene/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-3d-scene\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"668\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">A 3D-parallax hero scene slider with a convincing depth-effect and animated clouds.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:47;a:25:{s:2:\"id\";s:2:\"48\";s:5:\"title\";s:15:\"WooCommerce Big\";s:5:\"alias\";s:6:\"woobig\";s:3:\"zip\";s:10:\"woobig.zip\";s:3:\"uid\";s:32:\"bfb09a39656c7c80e86b468fc5b3403c\";s:3:\"img\";s:17:\"woobig/slide1.jpg\";s:7:\"preview\";s:139:\"http://revolution.themepunch.com/woocommerce-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=woocommerce-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:173:\"<span class=\"ttm_content\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"WooCommerce Slider\"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";i:2;s:11:\"woocommerce\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:48;a:25:{s:2:\"id\";s:2:\"49\";s:5:\"title\";s:17:\"WooCommerce Small\";s:5:\"alias\";s:16:\"woocommercesmall\";s:3:\"zip\";s:20:\"woocommercesmall.zip\";s:3:\"uid\";s:32:\"b17c2adcc5c4c4b68a7ac6fee32fa030\";s:3:\"img\";s:27:\"woocommercesmall/slide1.jpg\";s:7:\"preview\";s:139:\"http://revolution.themepunch.com/woocommerce-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=woocommerce-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:3:\"400\";s:6:\"height\";s:3:\"266\";s:11:\"description\";s:174:\" <span class=\"ttm_content\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"WooCommerce Slider\"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";i:2;s:11:\"woocommerce\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:49;a:25:{s:2:\"id\";s:2:\"50\";s:5:\"title\";s:17:\"Restaurant Header\";s:5:\"alias\";s:10:\"finedining\";s:3:\"zip\";s:14:\"finedining.zip\";s:3:\"uid\";s:32:\"03481a9e258501fbe3888b48830ea845\";s:3:\"img\";s:21:\"finedining/slide1.jpg\";s:7:\"preview\";s:147:\"http://revolution.themepunch.com/restaurant-hero-header/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=restaurant-hero-header\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:275:\"<span class=\"ttm_content\">A full-screen hero block slider that shows different background layers on button hover using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:50;a:25:{s:2:\"id\";s:2:\"51\";s:5:\"title\";s:21:\"Agency Website Header\";s:5:\"alias\";s:12:\"agency-intro\";s:3:\"zip\";s:16:\"agency-intro.zip\";s:3:\"uid\";s:32:\"e9be2afdd55a0c8d0d8d0cc12ba4c82f\";s:3:\"img\";s:23:\"agency-intro/slide1.jpg\";s:7:\"preview\";s:155:\"http://revolution.themepunch.com/agency-website-hero-header/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=agency-website-hero-header\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:302:\" <span class=\"ttm_content\">A full-screen hero block slider with ken burns effect and video modal on button click. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:51;a:25:{s:2:\"id\";s:2:\"52\";s:5:\"title\";s:11:\"Team Slider\";s:5:\"alias\";s:7:\"ourteam\";s:3:\"zip\";s:11:\"ourteam.zip\";s:3:\"uid\";s:32:\"d8eb1fec07a79202d1118bb17f70c233\";s:3:\"img\";s:18:\"ourteam/slide1.jpg\";s:7:\"preview\";s:183:\"http://revolution.themepunch.com/thumbnail-hover-slider-revolution-plugin/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=thumbnail-hover-slider-revolution-plugin\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:303:\"<span class=\"ttm_content\">A team slider that changes slides and displays additional information on thumbnail hover. It uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:657:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/\" target=\"_blank\">modify the thumbnails</a><br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:52;a:25:{s:2:\"id\";s:2:\"53\";s:5:\"title\";s:13:\"Team Carousel\";s:5:\"alias\";s:17:\"our-team-carousel\";s:3:\"zip\";s:21:\"our-team-carousel.zip\";s:3:\"uid\";s:32:\"37656d5dcab1f265c025cb2a3d669809\";s:3:\"img\";s:26:\"ourteamcarousel/slide1.jpg\";s:7:\"preview\";s:201:\"http://revolution.themepunch.com/thumbnail-hover-carousel-slider-revolution-plugin/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=thumbnail-hover-carousel-slider-revolution-plugin\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:306:\" <span class=\"ttm_content\">A team carousel that changes slides and displays additional information on thumbnail hover. It uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:659:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/\" target=\"_blank\">modify the thumbnails</a><br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:53;a:26:{s:2:\"id\";s:2:\"54\";s:5:\"title\";s:17:\"4K Youtube Slider\";s:5:\"alias\";s:13:\"betteryoutube\";s:3:\"zip\";s:17:\"betteryoutube.zip\";s:3:\"uid\";s:32:\"d7c5fef9f257037d7a148038aa2a1857\";s:3:\"img\";s:24:\"betteryoutube/slide1.jpg\";s:7:\"preview\";s:223:\"http://revolution.themepunch.com/fullscreen-4k-youtube-video-gallery-slider-revolution-plugin/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=fullscreen-4k-youtube-video-gallery-slider-revolution-plugin\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"675\";s:11:\"description\";s:293:\" <span class=\"ttm_content\">A full-screen youtube gallery with 4K videos as an example. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to breathe life into navigation elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:535:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change videos and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:54;a:25:{s:2:\"id\";s:2:\"55\";s:5:\"title\";s:21:\"Agency Website Header\";s:5:\"alias\";s:19:\"agencywebsiteheader\";s:3:\"zip\";s:23:\"agencywebsiteheader.zip\";s:3:\"uid\";s:32:\"c11d272c87277a7a38d9e7fd13e27947\";s:3:\"img\";s:30:\"agencywebsiteheader/slide1.jpg\";s:7:\"preview\";s:147:\"http://revolution.themepunch.com/fullscreen-hero-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=fullscreen-hero-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:245:\" <span class=\"ttm_content\">A very unique full-screen slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:509:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:55;a:25:{s:2:\"id\";s:2:\"56\";s:5:\"title\";s:11:\"Coming Soon\";s:5:\"alias\";s:10:\"comingsoon\";s:3:\"zip\";s:14:\"comingsoon.zip\";s:3:\"uid\";s:32:\"0f89edf995512e6d6e864a2ee7221829\";s:3:\"img\";s:21:\"comingsoon/slide1.jpg\";s:7:\"preview\";s:193:\"http://revolution.themepunch.com/coming-soon-wordpress-under-construction-site/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coming-soon-wordpress-under-construction-site\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:299:\"<span class=\"ttm_content\">A full-screen slider that can be used as a \"Coming Soon\" page. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to achieve various interaction possibilities.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:638:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\nInstructions for <a href=\"https://www.themepunch.com/faq/change-date-for-coming-soon-template/\" target=\"_blank\">how to change the date.</a><br /><br />\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:56;a:25:{s:2:\"id\";s:2:\"57\";s:5:\"title\";s:20:\"Christmas Snow Scene\";s:5:\"alias\";s:9:\"snowscene\";s:3:\"zip\";s:13:\"snowscene.zip\";s:3:\"uid\";s:32:\"a747bf0837caff86c62419a746690209\";s:3:\"img\";s:20:\"snowscene/slide1.jpg\";s:7:\"preview\";s:143:\"http://revolution.themepunch.com/christmas-snow-scene/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=christmas-snow-scene\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:141:\"<span class=\"ttm_content\">A slider with multiple christmas themed slides and a neat snow fall effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:485:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:153:\"[{\"path\":\"revslider-snow-addon\\/revslider-snow-addon.php\",\"name\":\"Snow AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:57;a:25:{s:2:\"id\";s:2:\"58\";s:5:\"title\";s:15:\"Rock Band Music\";s:5:\"alias\";s:8:\"rockband\";s:3:\"zip\";s:12:\"rockband.zip\";s:3:\"uid\";s:32:\"5f557a5fad2fd6ca982a6ae6e9619637\";s:3:\"img\";s:19:\"rockband/slide1.jpg\";s:7:\"preview\";s:195:\"http://revolution.themepunch.com/rock-band-music-theme-slider-revolution-plugin/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=rock-band-music-theme-slider-revolution-plugin\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:140:\" <span class=\"ttm_content\">A rock band themed hero block slider with an embedded SoundCloud element.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:58;a:25:{s:2:\"id\";s:2:\"59\";s:5:\"title\";s:18:\"Sleek Landing Page\";s:5:\"alias\";s:16:\"sleeklandingpage\";s:3:\"zip\";s:20:\"sleeklandingpage.zip\";s:3:\"uid\";s:32:\"07f7f2608936a8ae226213b7d99eee3f\";s:3:\"img\";s:27:\"sleeklandingpage/slide1.jpg\";s:7:\"preview\";s:175:\"http://revolution.themepunch.com/landing-page-free-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=landing-page-free-wordpress-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:191:\"<span class=\"ttm_content\">A full-screen slider that can be used as an App-Landing-Page. The object layers and custom animations create a unique effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-22 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:59;a:25:{s:2:\"id\";s:2:\"60\";s:5:\"title\";s:16:\"App Landing Page\";s:5:\"alias\";s:14:\"applandingpage\";s:3:\"zip\";s:18:\"applandingpage.zip\";s:3:\"uid\";s:32:\"38eb600893c1484ab8fd2a3dce3678d7\";s:3:\"img\";s:25:\"applandingpage/slide1.jpg\";s:7:\"preview\";s:163:\"http://revolution.themepunch.com/app-landing-page-free-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=app-landing-page-free-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:263:\"<span class=\"ttm_content\">A full-screen hero block that can be used as an app landing page. The detail view is build using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:60;a:25:{s:2:\"id\";s:2:\"61\";s:5:\"title\";s:10:\"Desk Scene\";s:5:\"alias\";s:9:\"deskscene\";s:3:\"zip\";s:13:\"deskscene.zip\";s:3:\"uid\";s:32:\"172a1a89a3e3b333cb4dbeb238f534c5\";s:3:\"img\";s:20:\"deskscene/slide1.jpg\";s:7:\"preview\";s:133:\"http://revolution.themepunch.com/hero-desk-scene/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=hero-desk-scene\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:135:\"<span class=\"ttm_content\">A beautiful desk scene with a cool reveal effect when scrolling down.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:61;a:25:{s:2:\"id\";s:2:\"62\";s:5:\"title\";s:17:\"Clean News Slider\";s:5:\"alias\";s:15:\"cleannewsslider\";s:3:\"zip\";s:19:\"cleannewsslider.zip\";s:3:\"uid\";s:32:\"82c3f521fe31b80984be0f19e1a9899e\";s:3:\"img\";s:26:\"cleannewsslider/slide1.jpg\";s:7:\"preview\";s:145:\"http://revolution.themepunch.com/wordpress-news-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-news-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:132:\"<span class=\"ttm_content\">A slideshow example with clean content and thumbnail navigation.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:62;a:25:{s:2:\"id\";s:2:\"63\";s:5:\"title\";s:13:\"Image Gallery\";s:5:\"alias\";s:12:\"imagegallery\";s:3:\"zip\";s:16:\"imagegallery.zip\";s:3:\"uid\";s:32:\"cef1d75357df2cb53b990c74a214813e\";s:3:\"img\";s:23:\"imagegallery/slide1.jpg\";s:7:\"preview\";s:163:\"http://revolution.themepunch.com/wordpress-photo-gallery-plugin/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-photo-gallery-plugin\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"667\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">A photo gallery suitable to display your images using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:63;a:25:{s:2:\"id\";s:2:\"64\";s:5:\"title\";s:19:\"Standard WP Gallery\";s:5:\"alias\";s:19:\"standard-wp-gallery\";s:3:\"zip\";s:23:\"standard-wp-gallery.zip\";s:3:\"uid\";s:32:\"632035b8a27652d8081dbdfa343dc93d\";s:3:\"img\";s:30:\"standard-wp-gallery/slide1.jpg\";s:7:\"preview\";s:163:\"http://revolution.themepunch.com/wordpress-photo-gallery-plugin/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-photo-gallery-plugin\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"667\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A photo gallery that uses the \"Standard WP Gallery\" add-on to display images.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:407:\"<span class=\"ttm_content\">Please follow the setup guide on the \"Standard WP Gallery\" add-on page.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";s:166:\"[{\"path\":\"revslider-gallery-addon\\/revslider-gallery-addon.php\",\"name\":\"WP Gallery AddOn\",\"url\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-photo-gallery-plugin\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:64;a:25:{s:2:\"id\";s:2:\"65\";s:5:\"title\";s:21:\"Clean News Post Based\";s:5:\"alias\";s:21:\"clean-news-post-based\";s:3:\"zip\";s:25:\"clean-news-post-based.zip\";s:3:\"uid\";s:32:\"f4cf5bbe51afa5a361754bb081cbabf2\";s:3:\"img\";s:32:\"clean-news-post-based/slide1.jpg\";s:7:\"preview\";s:145:\"http://revolution.themepunch.com/wordpress-news-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-news-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:125:\"<span class=\"ttm_content\"> This slider is automatically populated by WordPress posts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:423:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Post-Based Slider\"</a>. Make sure to select the post type you want to display in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:65;a:25:{s:2:\"id\";s:2:\"66\";s:5:\"title\";s:22:\"Interactive Whiteboard\";s:5:\"alias\";s:21:\"interactivewhiteboard\";s:3:\"zip\";s:25:\"interactivewhiteboard.zip\";s:3:\"uid\";s:32:\"058b4af535d6c6c7bcec5225845e3eb4\";s:3:\"img\";s:32:\"interactivewhiteboard/slide1.jpg\";s:7:\"preview\";s:189:\"http://revolution.themepunch.com/interactive-whiteboard-animation-free-addon/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=interactive-whiteboard-animation-free-addon\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:269:\"<span class=\"ttm_content\">This is the example slider from the Whiteboard add-on preview.<br/><a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used to achieve certain effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:541:\"<span class=\"ttm_content\">This slider template requires the <a href=\"https://www.themepunch.com/slider-revolution/whiteboard-addon/\" target=\"_blank\">Whiteboard add-on</a> to be installed. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:185:\"[{\"path\":\"revslider-whiteboard-addon\\/revslider-whiteboard-addon.php\",\"name\":\"Whiteboard AddOn\",\"url\":\"http:\\/\\/revolution.themepunch.com\\/interactive-whiteboard-animation-free-addon\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:66;a:25:{s:2:\"id\";s:2:\"68\";s:5:\"title\";s:17:\"Innovation Slider\";s:5:\"alias\";s:10:\"innovation\";s:3:\"zip\";s:14:\"innovation.zip\";s:3:\"uid\";s:32:\"d3440b69126d9c186fddc713b18b0002\";s:3:\"img\";s:21:\"innovation/slide1.jpg\";s:7:\"preview\";s:170:\"https://revolution.themepunch.com/best-wordpress-slider-plugin-2016/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=best-wordpress-slider-plugin-2016\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:7:\"5.2.3.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:258:\"<span class=\"ttm_content\">A full-screen slider with an elegant fade-out parallax effect. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:493:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images, videos and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-03-29 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:67;a:28:{s:2:\"id\";s:2:\"69\";s:5:\"title\";s:25:\"Dark Content Block - Menu\";s:5:\"alias\";s:24:\"dark-fullsite-block-menu\";s:3:\"zip\";s:34:\"packs/dark-fullsite-block-menu.zip\";s:3:\"uid\";s:32:\"bf4bd226719d3c3d3146592976e31ca1\";s:3:\"img\";s:35:\"dark-fullsite-block-menu/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:68;a:28:{s:2:\"id\";s:2:\"70\";s:5:\"title\";s:25:\"Dark Content Block - Hero\";s:5:\"alias\";s:21:\"dark-fullsite-block-1\";s:3:\"zip\";s:31:\"packs/dark-fullsite-block-1.zip\";s:3:\"uid\";s:32:\"d8859245fe600288ca932dc29aca751f\";s:3:\"img\";s:32:\"dark-fullsite-block-1/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:69;a:28:{s:2:\"id\";s:2:\"71\";s:5:\"title\";s:26:\"Dark Content Block - About\";s:5:\"alias\";s:27:\"dark-fullsite-block-2-about\";s:3:\"zip\";s:37:\"packs/dark-fullsite-block-2-about.zip\";s:3:\"uid\";s:32:\"298401901521a197a8294c1b4f73df3e\";s:3:\"img\";s:38:\"dark-fullsite-block-2-about/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:70;a:28:{s:2:\"id\";s:2:\"72\";s:5:\"title\";s:29:\"Dark Content Block - Services\";s:5:\"alias\";s:30:\"dark-fullsite-block-3-services\";s:3:\"zip\";s:40:\"packs/dark-fullsite-block-3-services.zip\";s:3:\"uid\";s:32:\"8da3ed605472ed6a26c745fb52f85f82\";s:3:\"img\";s:41:\"dark-fullsite-block-3-services/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:71;a:28:{s:2:\"id\";s:2:\"73\";s:5:\"title\";s:29:\"Dark Content Block - Products\";s:5:\"alias\";s:30:\"dark-fullsite-block-4-products\";s:3:\"zip\";s:40:\"packs/dark-fullsite-block-4-products.zip\";s:3:\"uid\";s:32:\"99e4f40399d20261a6131043d0e50b0c\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:422:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\r\n\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:72;a:28:{s:2:\"id\";s:2:\"74\";s:5:\"title\";s:33:\"Dark Content Block - Testimonials\";s:5:\"alias\";s:34:\"dark-fullsite-block-5-testimonials\";s:3:\"zip\";s:44:\"packs/dark-fullsite-block-5-testimonials.zip\";s:3:\"uid\";s:32:\"2f9121e0eedd51afe85e233d0743acab\";s:3:\"img\";s:45:\"dark-fullsite-block-5-testimonials/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:73;a:28:{s:2:\"id\";s:2:\"75\";s:5:\"title\";s:28:\"Dark Content Block - Callout\";s:5:\"alias\";s:29:\"dark-fullsite-block-6-callout\";s:3:\"zip\";s:39:\"packs/dark-fullsite-block-6-callout.zip\";s:3:\"uid\";s:32:\"55fbecb113ff21f050be7adc08637329\";s:3:\"img\";s:40:\"dark-fullsite-block-6-callout/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:74;a:28:{s:2:\"id\";s:2:\"76\";s:5:\"title\";s:27:\"Dark Content Block - Footer\";s:5:\"alias\";s:28:\"dark-fullsite-block-7-footer\";s:3:\"zip\";s:38:\"packs/dark-fullsite-block-7-footer.zip\";s:3:\"uid\";s:32:\"2ff517f5c7c54e3e0c2dd733cfd3400e\";s:3:\"img\";s:39:\"dark-fullsite-block-7-footer/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=dark-wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:75;a:28:{s:2:\"id\";s:2:\"77\";s:5:\"title\";s:26:\"Light Content Block - Menu\";s:5:\"alias\";s:19:\"fullsite-block-menu\";s:3:\"zip\";s:29:\"packs/fullsite-block-menu.zip\";s:3:\"uid\";s:32:\"8010971f34387d5f94a1f4e577ef382a\";s:3:\"img\";s:30:\"fullsite-block-menu/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:76;a:28:{s:2:\"id\";s:2:\"78\";s:5:\"title\";s:26:\"Light Content Block - Hero\";s:5:\"alias\";s:15:\"fullsite-block1\";s:3:\"zip\";s:25:\"packs/fullsite-block1.zip\";s:3:\"uid\";s:32:\"45bf7179843e01ce112e8ec754b0455c\";s:3:\"img\";s:26:\"fullsite-block1/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:77;a:28:{s:2:\"id\";s:2:\"79\";s:5:\"title\";s:27:\"Light Content Block - About\";s:5:\"alias\";s:22:\"fullsite-block-2-about\";s:3:\"zip\";s:32:\"packs/fullsite-block-2-about.zip\";s:3:\"uid\";s:32:\"8402b460638a746d36433cb161440b7d\";s:3:\"img\";s:33:\"fullsite-block-2-about/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:78;a:28:{s:2:\"id\";s:2:\"80\";s:5:\"title\";s:30:\"Light Content Block - Services\";s:5:\"alias\";s:25:\"fullsite-block-3-services\";s:3:\"zip\";s:35:\"packs/fullsite-block-3-services.zip\";s:3:\"uid\";s:32:\"7b8cea27f4d6ae17c5e1eae12457bd06\";s:3:\"img\";s:36:\"fullsite-block-3-services/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:79;a:28:{s:2:\"id\";s:2:\"81\";s:5:\"title\";s:30:\"Light Content Block - Products\";s:5:\"alias\";s:25:\"fullsite-block-4-products\";s:3:\"zip\";s:35:\"packs/fullsite-block-4-products.zip\";s:3:\"uid\";s:32:\"d148935362d7122636cda0635eae4be7\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:80;a:28:{s:2:\"id\";s:2:\"82\";s:5:\"title\";s:34:\"Light Content Block - Testimonials\";s:5:\"alias\";s:29:\"fullsite-block-5-testimonials\";s:3:\"zip\";s:39:\"packs/fullsite-block-5-testimonials.zip\";s:3:\"uid\";s:32:\"06255bfd421e40f71fa8197b839dbf03\";s:3:\"img\";s:40:\"fullsite-block-5-testimonials/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:81;a:28:{s:2:\"id\";s:2:\"83\";s:5:\"title\";s:29:\"Light Content Block - Callout\";s:5:\"alias\";s:24:\"fullsite-block-6-callout\";s:3:\"zip\";s:34:\"packs/fullsite-block-6-callout.zip\";s:3:\"uid\";s:32:\"8a88c3447676b613ec5db2fe5d63315c\";s:3:\"img\";s:35:\"fullsite-block-6-callout/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:82;a:28:{s:2:\"id\";s:2:\"84\";s:5:\"title\";s:28:\"Light Content Block - Footer\";s:5:\"alias\";s:23:\"fullsite-block-7-footer\";s:3:\"zip\";s:33:\"packs/fullsite-block-7-footer.zip\";s:3:\"uid\";s:32:\"34300b4407a2093eb2e1e08868fa8319\";s:3:\"img\";s:34:\"fullsite-block-7-footer/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:83;a:25:{s:2:\"id\";s:2:\"85\";s:5:\"title\";s:12:\"Tech Journal\";s:5:\"alias\";s:11:\"techjournal\";s:3:\"zip\";s:15:\"techjournal.zip\";s:3:\"uid\";s:32:\"7f92d70d1c108378f915b18c2ceb71d6\";s:3:\"img\";s:22:\"techjournal/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/wordpress-parallax-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-parallax-theme\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.1\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:130:\"<span class=\"ttm_content\">A full-width slider with navigation direction-based transitions.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:84;a:25:{s:2:\"id\";s:2:\"86\";s:5:\"title\";s:14:\"Car Dealership\";s:5:\"alias\";s:13:\"cardealership\";s:3:\"zip\";s:17:\"cardealership.zip\";s:3:\"uid\";s:32:\"bb010838855a8ae4d1dd68e139bf169e\";s:3:\"img\";s:24:\"cardealership/slide1.jpg\";s:7:\"preview\";s:146:\"https://revolution.themepunch.com/car-dealership-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=car-dealership-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"650\";s:11:\"description\";s:130:\"<span class=\"ttm_content\">A full-width slider with navigation direction-based transitions.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:85;a:25:{s:2:\"id\";s:2:\"87\";s:5:\"title\";s:22:\"FullScreen Menu Slider\";s:5:\"alias\";s:14:\"fullscreenmenu\";s:3:\"zip\";s:18:\"fullscreenmenu.zip\";s:3:\"uid\";s:32:\"6de81d74c4bf193e2e274d43038adc85\";s:3:\"img\";s:25:\"fullscreenmenu/slide1.jpg\";s:7:\"preview\";s:154:\"https://revolution.themepunch.com/wordpress-fullscreen-menu/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-fullscreen-menu\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:131:\"<span class=\"ttm_content\">A full-screen slider that contains a menu with slide blur effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:86;a:25:{s:2:\"id\";s:2:\"88\";s:5:\"title\";s:18:\"Creative Frontpage\";s:5:\"alias\";s:17:\"creativefrontpage\";s:3:\"zip\";s:21:\"creativefrontpage.zip\";s:3:\"uid\";s:32:\"0636cb368af3bcaa2f68eb0ebefe6439\";s:3:\"img\";s:28:\"creativefrontpage/slide1.jpg\";s:7:\"preview\";s:146:\"https://revolution.themepunch.com/best-wordpress-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=best-wordpress-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:246:\"<span class=\"ttm_content\">A full-screen slider with hidden slides that are triggered via  <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:95;a:25:{s:2:\"id\";s:2:\"97\";s:5:\"title\";s:21:\"Focus Parallax Effect\";s:5:\"alias\";s:13:\"focusparallax\";s:3:\"zip\";s:17:\"focusparallax.zip\";s:3:\"uid\";s:32:\"13bd15fb3ddf8b9841cb55b89389cc73\";s:3:\"img\";s:24:\"focusparallax/slide1.jpg\";s:7:\"preview\";s:169:\" https://revolution.themepunch.com/parallax-effect-wordpress-plugin/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=parallax-effect-wordpress-plugin\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:256:\"<span class=\"ttm_content\">A full-screen slider with mouse controlled parallax effects. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:96;a:25:{s:2:\"id\";s:2:\"98\";s:5:\"title\";s:14:\"Duotone Slider\";s:5:\"alias\";s:7:\"duotone\";s:3:\"zip\";s:11:\"duotone.zip\";s:3:\"uid\";s:32:\"494862ceb6cb7c6658ad7cd36848cccd\";s:3:\"img\";s:18:\"duotone/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/wordpress-header-image-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-header-image-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.4\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:252:\"<span class=\"ttm_content\">A full-screen slider with unique parallax scroll effect. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:97;a:28:{s:2:\"id\";s:2:\"99\";s:5:\"title\";s:12:\"Minimal Menu\";s:5:\"alias\";s:6:\"r_menu\";s:3:\"zip\";s:16:\"packs/r_menu.zip\";s:3:\"uid\";s:32:\"30d6a6895db1a5f29b1679061551c9f0\";s:3:\"img\";s:17:\"r_menu/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/minimal-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-website-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"110\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:98;a:28:{s:2:\"id\";s:3:\"100\";s:5:\"title\";s:12:\"Minimal Hero\";s:5:\"alias\";s:5:\"rhero\";s:3:\"zip\";s:16:\"packs/r_hero.zip\";s:3:\"uid\";s:32:\"b8b46186956f6e66ad0c08e4532bbbde\";s:3:\"img\";s:17:\"r_hero/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/minimal-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:99;a:28:{s:2:\"id\";s:3:\"101\";s:5:\"title\";s:13:\"Minimal About\";s:5:\"alias\";s:7:\"r_about\";s:3:\"zip\";s:17:\"packs/r_about.zip\";s:3:\"uid\";s:32:\"343010c4b4c03f92888c3e9e95bc2bb1\";s:3:\"img\";s:18:\"r_about/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/minimal-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:100;a:28:{s:2:\"id\";s:3:\"102\";s:5:\"title\";s:16:\"Minimal Products\";s:5:\"alias\";s:10:\"r_products\";s:3:\"zip\";s:20:\"packs/r_products.zip\";s:3:\"uid\";s:32:\"dda93e85c6a4456d132040147f087f39\";s:3:\"img\";s:21:\"r_products/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/minimal-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1100\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:101;a:28:{s:2:\"id\";s:3:\"103\";s:5:\"title\";s:12:\"Minimal Info\";s:5:\"alias\";s:6:\"r_info\";s:3:\"zip\";s:16:\"packs/r_info.zip\";s:3:\"uid\";s:32:\"d6e368e8fd4862174af6c980389ae530\";s:3:\"img\";s:17:\"r_info/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/minimal-website-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-website-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:102;a:25:{s:2:\"id\";s:3:\"104\";s:5:\"title\";s:18:\"Inspiration Header\";s:5:\"alias\";s:17:\"inspirationheader\";s:3:\"zip\";s:21:\"inspirationheader.zip\";s:3:\"uid\";s:32:\"69f04b2be0b618fa7e184af83b86b7e7\";s:3:\"img\";s:28:\"inspirationheader/slide1.jpg\";s:7:\"preview\";s:148:\"https://revolution.themepunch.com/wordpress-theme-header/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme-header\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:159:\"<span class=\"ttm_content\">This full-screen hero slider features sequentially animated texts and cool parallax elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:103;a:25:{s:2:\"id\";s:3:\"105\";s:5:\"title\";s:15:\"Magazine Slider\";s:5:\"alias\";s:13:\"magazineposts\";s:3:\"zip\";s:17:\"magazineposts.zip\";s:3:\"uid\";s:32:\"c562f3457e4edbd030959f7c5e6e0f7c\";s:3:\"img\";s:24:\"magazineposts/slide1.jpg\";s:7:\"preview\";s:154:\"https://revolution.themepunch.com/wordpress-magazine-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-magazine-slider\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">A full-width slider with a mouse-controlled 3D-Parallax effect. Enjoy! <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:104;a:25:{s:2:\"id\";s:3:\"106\";s:5:\"title\";s:11:\"News Header\";s:5:\"alias\";s:17:\"explorationheader\";s:3:\"zip\";s:21:\"explorationheader.zip\";s:3:\"uid\";s:32:\"8f20d5a868c90ded08b835fb9e8307d7\";s:3:\"img\";s:28:\"explorationheader/slide1.jpg\";s:7:\"preview\";s:146:\"https://revolution.themepunch.com/wordpress-news-header/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-news-header\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:288:\"<span class=\"ttm_content\">A full-screen slider that is a perfect fit for displaying news on your websites header! Check out <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> to add links to buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:109;a:25:{s:2:\"id\";s:3:\"111\";s:5:\"title\";s:17:\"Typewriter Effect\";s:5:\"alias\";s:16:\"typewritereffect\";s:3:\"zip\";s:20:\"typewritereffect.zip\";s:3:\"uid\";s:32:\"d6f8bae06cc4a7b158d680c01e59ddc2\";s:3:\"img\";s:27:\"typewritereffect/slide1.jpg\";s:7:\"preview\";s:158:\"https://revolution.themepunch.com/wordpress-typewriter-effect/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-typewriter-effect\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:263:\"<span class=\"ttm_content\">This is the example slider from the Typewriter add-on preview.<br/><a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:403:\"<span class=\"ttm_content\">This slider template requires the <a href=\"https://www.themepunch.com/slider-revolution/typewriter-addon/\" target=\"_blank\">Typewriter add-on</a> to be installed. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:173:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:110;a:26:{s:2:\"id\";s:3:\"112\";s:5:\"title\";s:17:\"Blend Mode Header\";s:5:\"alias\";s:15:\"blendmodeheader\";s:3:\"zip\";s:19:\"blendmodeheader.zip\";s:3:\"uid\";s:32:\"2e44e976596d757aab40ffa28086dcf9\";s:3:\"img\";s:26:\"blendmodeheader/slide1.jpg\";s:7:\"preview\";s:148:\"https://revolution.themepunch.com/blend-mode-hero-header/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=blend-mode-hero-header\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:6:\"6.7.34\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">This full-screen hero header with HMTL5 background video, utilizes the new 5.3 blend mode effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:111;a:29:{s:2:\"id\";s:3:\"113\";s:5:\"title\";s:17:\"Themeplicity Menu\";s:5:\"alias\";s:17:\"themeplicity_menu\";s:3:\"zip\";s:27:\"packs/themeplicity_menu.zip\";s:3:\"uid\";s:32:\"7d5c1e75eaafa63683895a32a62f4ce0\";s:3:\"img\";s:28:\"themeplicity_menu/slide1.jpg\";s:7:\"preview\";s:134:\"https://revolution.themepunch.com/wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"90\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:112;a:29:{s:2:\"id\";s:3:\"114\";s:5:\"title\";s:19:\"Themeplicity Header\";s:5:\"alias\";s:19:\"themeplicity_header\";s:3:\"zip\";s:29:\"packs/themeplicity_header.zip\";s:3:\"uid\";s:32:\"907091e4d58acc7d12f802de2f280b7d\";s:3:\"img\";s:30:\"themeplicity_header/slide1.jpg\";s:7:\"preview\";s:134:\"https://revolution.themepunch.com/wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:113;a:29:{s:2:\"id\";s:3:\"115\";s:5:\"title\";s:18:\"Themeplicity Offer\";s:5:\"alias\";s:18:\"themeplicity_offer\";s:3:\"zip\";s:28:\"packs/themeplicity_offer.zip\";s:3:\"uid\";s:32:\"1bd8f9aa2f3e340449664c65ba17fb51\";s:3:\"img\";s:29:\"themeplicity_offer/slide1.jpg\";s:7:\"preview\";s:134:\"https://revolution.themepunch.com/wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"330\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:114;a:29:{s:2:\"id\";s:3:\"116\";s:5:\"title\";s:23:\"Themeplicity What We Do\";s:5:\"alias\";s:21:\"themeplicity_whatwedo\";s:3:\"zip\";s:31:\"packs/themeplicity_whatwedo.zip\";s:3:\"uid\";s:32:\"aa800a44b5a3eab30414dde1f32bfed7\";s:3:\"img\";s:32:\"themeplicity_whatwedo/slide1.jpg\";s:7:\"preview\";s:134:\"https://revolution.themepunch.com/wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"813\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:115;a:29:{s:2:\"id\";s:3:\"117\";s:5:\"title\";s:21:\"Themeplicity Projects\";s:5:\"alias\";s:21:\"themeplicity_projects\";s:3:\"zip\";s:31:\"packs/themeplicity_projects.zip\";s:3:\"uid\";s:32:\"5f61b3a13033ba6a51a18270163e0a50\";s:3:\"img\";s:32:\"themeplicity_projects/slide1.jpg\";s:7:\"preview\";s:134:\"https://revolution.themepunch.com/wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"813\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:116;a:29:{s:2:\"id\";s:3:\"118\";s:5:\"title\";s:24:\"Themeplicity Whats Great\";s:5:\"alias\";s:23:\"themeplicity_whatsgreat\";s:3:\"zip\";s:33:\"packs/themeplicity_whatsgreat.zip\";s:3:\"uid\";s:32:\"ce9faf8c55ed2e33e091b23667e7173b\";s:3:\"img\";s:34:\"themeplicity_whatsgreat/slide1.jpg\";s:7:\"preview\";s:134:\"https://revolution.themepunch.com/wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:117;a:29:{s:2:\"id\";s:3:\"119\";s:5:\"title\";s:19:\"Themeplicity Tables\";s:5:\"alias\";s:19:\"themeplicity_tables\";s:3:\"zip\";s:29:\"packs/themeplicity_tables.zip\";s:3:\"uid\";s:32:\"f28bb4cd20ec1f29a1de7da5ad09c293\";s:3:\"img\";s:30:\"themeplicity_tables/slide1.jpg\";s:7:\"preview\";s:134:\"https://revolution.themepunch.com/wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1059\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:118;a:29:{s:2:\"id\";s:3:\"120\";s:5:\"title\";s:24:\"Themeplicity Contactform\";s:5:\"alias\";s:24:\"themeplicity_contactform\";s:3:\"zip\";s:34:\"packs/themeplicity_contactform.zip\";s:3:\"uid\";s:32:\"3e59da970f534490774fa8e053f5b5ed\";s:3:\"img\";s:35:\"themeplicity_contactform/slide1.jpg\";s:7:\"preview\";s:134:\"https://revolution.themepunch.com/wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1067\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:119;a:29:{s:2:\"id\";s:3:\"121\";s:5:\"title\";s:19:\"Themeplicity Footer\";s:5:\"alias\";s:19:\"themeplicity_footer\";s:3:\"zip\";s:29:\"packs/themeplicity_footer.zip\";s:3:\"uid\";s:32:\"89eeb0b4b852c5f743e1bd76e3e8f2ef\";s:3:\"img\";s:30:\"themeplicity_footer/slide1.jpg\";s:7:\"preview\";s:134:\"https://revolution.themepunch.com/wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"780\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:121;a:29:{s:2:\"id\";s:3:\"123\";s:5:\"title\";s:19:\"Nice And Clean Menu\";s:5:\"alias\";s:17:\"NiceAndClean_Menu\";s:3:\"zip\";s:27:\"packs/NiceAndClean_Menu.zip\";s:3:\"uid\";s:32:\"3f8c01e26c7446428e045c4b1180776d\";s:3:\"img\";s:28:\"NiceAndClean_Menu/slide1.jpg\";s:7:\"preview\";s:178:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"90\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:122;a:29:{s:2:\"id\";s:3:\"124\";s:5:\"title\";s:21:\"Nice And Clean Header\";s:5:\"alias\";s:19:\"NiceAndClean_Header\";s:3:\"zip\";s:29:\"packs/NiceAndClean_Header.zip\";s:3:\"uid\";s:32:\"76931033addb20a62557c2845a4d6a11\";s:3:\"img\";s:30:\"NiceAndClean_Header/slide1.jpg\";s:7:\"preview\";s:178:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:123;a:29:{s:2:\"id\";s:3:\"125\";s:5:\"title\";s:23:\"Nice And Clean Services\";s:5:\"alias\";s:21:\"NiceAndClean_Services\";s:3:\"zip\";s:31:\"packs/NiceAndClean_Services.zip\";s:3:\"uid\";s:32:\"02f72ec606800c8215bcadea09624e87\";s:3:\"img\";s:32:\"NiceAndClean_Services/slide1.jpg\";s:7:\"preview\";s:178:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"360\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:124;a:29:{s:2:\"id\";s:3:\"126\";s:5:\"title\";s:20:\"Nice And Clean About\";s:5:\"alias\";s:18:\"NiceAndClean_About\";s:3:\"zip\";s:28:\"packs/NiceAndClean_About.zip\";s:3:\"uid\";s:32:\"9510f6fdbb8e9473e8c22f692a6bc89f\";s:3:\"img\";s:29:\"NiceAndClean_About/slide1.jpg\";s:7:\"preview\";s:178:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:125;a:29:{s:2:\"id\";s:3:\"127\";s:5:\"title\";s:20:\"Nice And Clean Video\";s:5:\"alias\";s:18:\"niceandclean_video\";s:3:\"zip\";s:28:\"packs/niceandclean_video.zip\";s:3:\"uid\";s:32:\"2bb9e1ad329435cc500542d0c7025e15\";s:3:\"img\";s:29:\"niceandclean_video/slide1.jpg\";s:7:\"preview\";s:178:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:126;a:29:{s:2:\"id\";s:3:\"128\";s:5:\"title\";s:25:\"Nice And Clean Highlights\";s:5:\"alias\";s:23:\"niceandclean_highlights\";s:3:\"zip\";s:33:\"packs/niceandclean_highlights.zip\";s:3:\"uid\";s:32:\"ff396af163a79d2d5b35db17c1ea7aa6\";s:3:\"img\";s:34:\"niceandclean_highlights/slide1.jpg\";s:7:\"preview\";s:178:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:127;a:29:{s:2:\"id\";s:3:\"129\";s:5:\"title\";s:23:\"Nice And Clean Projects\";s:5:\"alias\";s:21:\"NiceAndClean_Projects\";s:3:\"zip\";s:31:\"packs/NiceAndClean_Projects.zip\";s:3:\"uid\";s:32:\"1e6695959ef83f8975b52289c08a4d44\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide1.jpg\";s:7:\"preview\";s:178:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:128;a:29:{s:2:\"id\";s:3:\"130\";s:5:\"title\";s:25:\"Nice And Clean TextBlocks\";s:5:\"alias\";s:23:\"niceandclean_textblocks\";s:3:\"zip\";s:33:\"packs/niceandclean_textblocks.zip\";s:3:\"uid\";s:32:\"1f33eb839c96ea3225faff1c8d382b05\";s:3:\"img\";s:34:\"niceandclean_textblocks/slide1.jpg\";s:7:\"preview\";s:178:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:129;a:29:{s:2:\"id\";s:3:\"131\";s:5:\"title\";s:22:\"Nice And Clean CallOut\";s:5:\"alias\";s:20:\"niceandclean_callout\";s:3:\"zip\";s:30:\"packs/niceandclean_callout.zip\";s:3:\"uid\";s:32:\"54d4d9bcf79d357de0e614700e909863\";s:3:\"img\";s:31:\"niceandclean_callout/slide1.jpg\";s:7:\"preview\";s:178:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:130;a:29:{s:2:\"id\";s:3:\"132\";s:5:\"title\";s:21:\"Nice And Clean Footer\";s:5:\"alias\";s:19:\"niceandclean_footer\";s:3:\"zip\";s:29:\"packs/niceandclean_footer.zip\";s:3:\"uid\";s:32:\"5492d7f72b3771a4e754f91bda063b15\";s:3:\"img\";s:30:\"niceandclean_footer/slide1.jpg\";s:7:\"preview\";s:178:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=nice-clean-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"400\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:542:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">For using the social sharing buttons, please install the social sharing add-on.<br><br></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:131;a:25:{s:2:\"id\";s:3:\"134\";s:5:\"title\";s:15:\"80s Style Intro\";s:5:\"alias\";s:3:\"80s\";s:3:\"zip\";s:7:\"80s.zip\";s:3:\"uid\";s:32:\"98881ab51f71b2fbdb220752d321b15a\";s:3:\"img\";s:14:\"80s/slide1.jpg\";s:7:\"preview\";s:134:\"https://revolution.themepunch.com/80s-style-intro/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=80s-style-intro\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:139:\"<span class=\"ttm_content\">This intro hero block takes you back to the 80\'s with some funky effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:317:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and text.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:132;a:25:{s:2:\"id\";s:3:\"135\";s:5:\"title\";s:18:\"Blur Effect Slider\";s:5:\"alias\";s:10:\"blurslider\";s:3:\"zip\";s:14:\"blurslider.zip\";s:3:\"uid\";s:32:\"83bd6e1ccef83f03c944fa05b0a2d879\";s:3:\"img\";s:21:\"blurslider/slide1.jpg\";s:7:\"preview\";s:140:\"https://revolution.themepunch.com/blur-effect-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=blur-effect-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:147:\"<span class=\"ttm_content\">This slider makes use of the brand new blur effects available with version 5.3.1.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:315:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change the background images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:133;a:24:{s:2:\"id\";s:3:\"136\";s:5:\"title\";s:18:\"Coming Soon Add-On\";s:5:\"alias\";s:15:\"ComingSoonAddon\";s:3:\"zip\";s:19:\"ComingSoonAddon.zip\";s:3:\"uid\";s:32:\"51258492055b940099eb96ba52901fa9\";s:3:\"img\";s:26:\"ComingSoonAddon/slide1.jpg\";s:7:\"preview\";s:140:\"https://revolution.themepunch.com/coming-soon-add-on/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=coming-soon-add-on\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:133:\"<span class=\"ttm_content\">This slider template makes use of the brand new Coming Soon Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:197:\"[{\"path\":\"revslider-maintenance-addon\\/revslider-maintenance-addon.php\",\"name\":\"Coming Soon & Maintenance AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/add-coming-soon-maintenance\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:135;a:24:{s:2:\"id\";s:3:\"138\";s:5:\"title\";s:18:\"Snow Effect Add-On\";s:5:\"alias\";s:9:\"snowaddon\";s:3:\"zip\";s:13:\"snowaddon.zip\";s:3:\"uid\";s:32:\"7408d8567b8af5716eaabd390422e51b\";s:3:\"img\";s:20:\"snowaddon/slide1.jpg\";s:7:\"preview\";s:140:\"https://revolution.themepunch.com/snow-effect-add-on/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=snow-effect-add-on\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:183:\"<span class=\"ttm_content\">Add a pleasant Snow Effect to your website with this slider template. Make sure to install the \"Holiday Snow\" Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:153:\"[{\"path\":\"revslider-snow-addon\\/revslider-snow-addon.php\",\"name\":\"Snow AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:136;a:25:{s:2:\"id\";s:3:\"139\";s:5:\"title\";s:19:\"Particle Effect One\";s:5:\"alias\";s:19:\"particle-effect-one\";s:3:\"zip\";s:23:\"particle-effect-one.zip\";s:3:\"uid\";s:32:\"a4611c906e35ca60f617da86217b5299\";s:3:\"img\";s:30:\"particle-effect-one/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/particle-effect-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=particle-effect-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:442:\"<span class=\"ttm_content\">The blend mode effect is achieved through a layer image with CSS blend mode. If you want to customize this effect, select the \"BLEND MODE IMAGE\" layer and go to \"advanced style -> filters -> blend mode\".</span>\r\n<span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:74:\"How to Increase Engagement with Particle Effects and Blend Mode [Tutorial]\";s:9:\"guide_url\";s:107:\"https://www.sliderrevolution.com/tutorials/how-to-increase-engagement-with-particle-effects-and-blend-mode/\";s:9:\"guide_img\";s:32:\"tutorial/particle-effect-one.png\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:137;a:24:{s:2:\"id\";s:3:\"140\";s:5:\"title\";s:19:\"Particle Effect Two\";s:5:\"alias\";s:19:\"particle-effect-two\";s:3:\"zip\";s:23:\"particle-effect-two.zip\";s:3:\"uid\";s:32:\"b8ecbf43374a69e4ab329ea834862ef8\";s:3:\"img\";s:30:\"particle-effect-two/slide1.jpg\";s:7:\"preview\";s:146:\"https://revolution.themepunch.com/particle-effect-intro/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=particle-effect-intro\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:138;a:25:{s:2:\"id\";s:3:\"141\";s:5:\"title\";s:21:\"Particle Effect Three\";s:5:\"alias\";s:21:\"particle-effect-three\";s:3:\"zip\";s:25:\"particle-effect-three.zip\";s:3:\"uid\";s:32:\"b33bc2c5655d8d51cd17c3740f72e748\";s:3:\"img\";s:32:\"particle-effect-three/slide1.jpg\";s:7:\"preview\";s:156:\"https://revolution.themepunch.com/particle-background-effect/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=particle-background-effect\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:437:\"<span class=\"ttm_content\">The blend mode effect is achieved through a layer image with CSS blend mode. If you want to customize this effect, select the \"BLEND IMAGE\" layer and go to \"advanced style -> filters -> blend mode\".</span>\r\n<span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:139;a:26:{s:2:\"id\";s:3:\"142\";s:5:\"title\";s:16:\"Portfolio Viewer\";s:5:\"alias\";s:15:\"portfolioviewer\";s:3:\"zip\";s:19:\"portfolioviewer.zip\";s:3:\"uid\";s:32:\"9ac7230ff5b880fb6c8f28fbbc123b3b\";s:3:\"img\";s:26:\"portfolioviewer/slide1.jpg\";s:7:\"preview\";s:156:\"https://revolution.themepunch.com/wordpress-portfolio-plugin/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-portfolio-plugin\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:207:\"<span class=\"ttm_content\">This slider template can be used to display your portfolio highlights in a stunning way, utilising out free particles add-on and blend modes.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:387:\"<span class=\"ttm_content\">The navigation for the slides is found in the <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">Static Layers</a>.</span><span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:140;a:24:{s:2:\"id\";s:3:\"143\";s:5:\"title\";s:12:\"App Showcase\";s:5:\"alias\";s:11:\"appshowcase\";s:3:\"zip\";s:15:\"appshowcase.zip\";s:3:\"uid\";s:32:\"082aef931b0369080bc30c3a2a0c331f\";s:3:\"img\";s:22:\"appshowcase/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/app-showcase-wordpress-plugin/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=app-showcase-wordpress-plugin\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">This template shows off our new \"Polyfold Effects\" Add-On in form of an App product showcase module. Get started now and illustrate your Apps key features in a striking way!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:179:\"[{\"path\":\"revslider-polyfold-addon\\/revslider-polyfold-addon.php\",\"name\":\"Polyfold Scroll Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:141;a:25:{s:2:\"id\";s:3:\"144\";s:5:\"title\";s:19:\"Gravity Design Hero\";s:5:\"alias\";s:13:\"gravitydesign\";s:3:\"zip\";s:17:\"gravitydesign.zip\";s:3:\"uid\";s:32:\"7bdbe73a6e5bf290cb4412708ac4134d\";s:3:\"img\";s:24:\"gravitydesign/slide1.jpg\";s:7:\"preview\";s:170:\"https://revolution.themepunch.com/best-wordpress-slider-plugin-2017/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=best-wordpress-slider-plugin-2017\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:205:\"<span class=\"ttm_content\">This hero template shows a striking mouse-parallax scene and cool particle effects. Requires our \"Particle Effects\" Add-on to be installed.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:68:\"How to Create an Exciting Action Shot for Your Hero Image [Tutorial]\";s:9:\"guide_url\";s:101:\"https://www.sliderrevolution.com/tutorials/how-to-create-an-exciting-action-shot-for-your-hero-image/\";s:9:\"guide_img\";s:26:\"tutorial/gravitydesign.png\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:142;a:25:{s:2:\"id\";s:3:\"145\";s:5:\"title\";s:14:\"404 Error Page\";s:5:\"alias\";s:12:\"404errorpage\";s:3:\"zip\";s:16:\"404errorpage.zip\";s:3:\"uid\";s:32:\"2dc62d802b42b73088651cac17d0c486\";s:3:\"img\";s:23:\"404errorpage/slide1.jpg\";s:7:\"preview\";s:150:\"https://revolution.themepunch.com/404-error-page-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=404-error-page-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:227:\"<span class=\"ttm_content\">This template can be used as a custom error page on your website with our new 404 page Add-On. Of course you can also use this template as a regular hero header.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:179:\"{\"1\":{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}}\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:143;a:24:{s:2:\"id\";s:3:\"146\";s:5:\"title\";s:16:\"Carousel Gallery\";s:5:\"alias\";s:15:\"carouselgallery\";s:3:\"zip\";s:19:\"carouselgallery.zip\";s:3:\"uid\";s:32:\"041838fd32923c40e15c998f0ea19526\";s:3:\"img\";s:26:\"carouselgallery/slide1.jpg\";s:7:\"preview\";s:156:\"https://revolution.themepunch.com/wordpress-carousel-gallery/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-carousel-gallery\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:159:\"<span class=\"ttm_content\">This carousel gallery features a subtle parallax effect, html5 video and a fullscreen button.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:144;a:25:{s:2:\"id\";s:3:\"147\";s:5:\"title\";s:16:\"Filmstrip Effect\";s:5:\"alias\";s:9:\"filmstrip\";s:3:\"zip\";s:13:\"filmstrip.zip\";s:3:\"uid\";s:32:\"7bd142f272cc15d86998a79520e9e581\";s:3:\"img\";s:20:\"filmstrip/slide1.jpg\";s:7:\"preview\";s:129:\"https://revolution.themepunch.com/filmstrip-add-on-slider/ ?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content= \";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">This template uses our Filmstrip Add-On to display a continuous scrolling set of images per slide.\r\n There is lots of customization options like animation speed and direction.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:179:\"[{\"path\":\"revslider-filmstrip-addon\\/revslider-filmstrip-addon.php\",\"name\":\"Background FilmStrip AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:145;a:24:{s:2:\"id\";s:3:\"148\";s:5:\"title\";s:11:\"Space Opera\";s:5:\"alias\";s:10:\"spaceopera\";s:3:\"zip\";s:14:\"spaceopera.zip\";s:3:\"uid\";s:32:\"a2c8bffcb138a86c0f373adebb6de046\";s:3:\"img\";s:21:\"spaceopera/slide1.jpg\";s:7:\"preview\";s:152:\"https://revolution.themepunch.com/space-opera-presentation/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=space-opera-presentation\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:201:\"<span class=\"ttm_content\">The Space Opera template can be enjoyed as a slow paced, full-screen slider experience and is great to show your most prominent photos.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:146;a:24:{s:2:\"id\";s:3:\"149\";s:5:\"title\";s:13:\"Website Intro\";s:5:\"alias\";s:12:\"websiteintro\";s:3:\"zip\";s:16:\"websiteintro.zip\";s:3:\"uid\";s:32:\"348df76d999456aa19be58c9df56ae20\";s:3:\"img\";s:23:\"websiteintro/slide1.jpg\";s:7:\"preview\";s:164:\"https://revolution.themepunch.com/website-intro-wordpress-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=website-intro-wordpress-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:274:\"<span class=\"ttm_content\">Making use of our new Slicey Add-On, this slider show a really cool effect you just have to experience yourself! Just change the slides background images and the existing slices will automatically be applied.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:170:\"[{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:79:\"How to Create a Slider Animation Effect Your Visitors Won’t Forget [Tutorial]\";s:9:\"guide_url\";s:83:\"https://www.sliderrevolution.com/tutorials/how-to-create-a-slider-animation-effect/\";s:9:\"guide_img\";s:25:\"tutorial/websiteintro.png\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:147;a:24:{s:2:\"id\";s:3:\"150\";s:5:\"title\";s:13:\"Mask Showcase\";s:5:\"alias\";s:12:\"maskshowcase\";s:3:\"zip\";s:16:\"maskshowcase.zip\";s:3:\"uid\";s:32:\"fc943c31e2da9c63b252aeabf554d128\";s:3:\"img\";s:23:\"maskshowcase/slide1.jpg\";s:7:\"preview\";s:146:\"https://revolution.themepunch.com/minimal-mask-showcase/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=minimal-mask-showcase\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Mask Showcase template uses gradients and the amazing block layer animations. A minimal slider treat for any website!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:148;a:24:{s:2:\"id\";s:3:\"151\";s:5:\"title\";s:20:\"Parallax Zoom Slices\";s:5:\"alias\";s:18:\"parallaxzoomslices\";s:3:\"zip\";s:22:\"parallaxzoomslices.zip\";s:3:\"uid\";s:32:\"83537cae05709ddb9bcb7375470a5894\";s:3:\"img\";s:29:\"parallaxzoomslices/slide1.jpg\";s:7:\"preview\";s:178:\"https://revolution.themepunch.com/parallax-zoom-slices-wordpress-plugin/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=parallax-zoom-slices-wordpress-plugin\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:249:\"<span class=\"ttm_content\">This template uses the Slicey Add-On to add a unique effect to slide background images. You can simple change the background images and the slice effect will automatically be applied.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:170:\"[{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:149;a:25:{s:2:\"id\";s:3:\"152\";s:5:\"title\";s:22:\"Double Exposure Effect\";s:5:\"alias\";s:20:\"doubleexposureeffect\";s:3:\"zip\";s:24:\"doubleexposureeffect.zip\";s:3:\"uid\";s:32:\"8d9229b5cbcf5bda5fbdc6a8e01a2b8c\";s:3:\"img\";s:31:\"doubleexposureeffect/slide1.jpg\";s:7:\"preview\";s:168:\"https://revolution.themepunch.com/wordpress-double-exposure-effect/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-double-exposure-effect\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.4.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">Make any website special with the double exposure effect slider. Use as a header module or anywhere you want!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:150;a:24:{s:2:\"id\";s:3:\"153\";s:5:\"title\";s:24:\"Mountain Parallax Header\";s:5:\"alias\";s:22:\"mountainparallaxheader\";s:3:\"zip\";s:26:\"mountainparallaxheader.zip\";s:3:\"uid\";s:32:\"8dc64663f317a2abdf179bbe341d016e\";s:3:\"img\";s:33:\"mountainparallaxheader/slide1.jpg\";s:7:\"preview\";s:172:\"https://revolution.themepunch.com/mountain-wordpress-parallax-header/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=mountain-wordpress-parallax-header\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:192:\"<span class=\"ttm_content\">This template is a cool intro for any page, featuring a striking parallax effect. Just change texts and links and you\'re done!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:62:\"How to Place Text Behind Objects in Your Hero Image [Tutorial]\";s:9:\"guide_url\";s:69:\"https://www.sliderrevolution.com/tutorials/place-text-behind-objects/\";s:9:\"guide_img\";s:35:\"tutorial/mountainparallaxheader.png\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:152;a:29:{s:2:\"id\";s:3:\"155\";s:5:\"title\";s:13:\"GoodNews Menu\";s:5:\"alias\";s:12:\"goodnewsmenu\";s:3:\"zip\";s:22:\"packs/goodnewsmenu.zip\";s:3:\"uid\";s:32:\"4cbc82501ff340fcdc0acf7eb3ba2640\";s:3:\"img\";s:23:\"goodnewsmenu/slide1.jpg\";s:7:\"preview\";s:174:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:153;a:29:{s:2:\"id\";s:3:\"156\";s:5:\"title\";s:15:\"GoodNews Header\";s:5:\"alias\";s:14:\"goodnewsheader\";s:3:\"zip\";s:24:\"packs/goodnewsheader.zip\";s:3:\"uid\";s:32:\"c6660b6bdbf596f38466f569596f5259\";s:3:\"img\";s:25:\"goodnewsheader/slide1.jpg\";s:7:\"preview\";s:174:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:154;a:29:{s:2:\"id\";s:3:\"157\";s:5:\"title\";s:18:\"GoodNews Whats Hot\";s:5:\"alias\";s:16:\"goodnewswhatshot\";s:3:\"zip\";s:26:\"packs/goodnewswhatshot.zip\";s:3:\"uid\";s:32:\"cb841ce64a99a6644adab049cf5405cd\";s:3:\"img\";s:27:\"goodnewswhatshot/slide1.jpg\";s:7:\"preview\";s:174:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:155;a:29:{s:2:\"id\";s:3:\"158\";s:5:\"title\";s:17:\"GoodNews Featured\";s:5:\"alias\";s:16:\"goodnewsfeatured\";s:3:\"zip\";s:26:\"packs/goodnewsfeatured.zip\";s:3:\"uid\";s:32:\"00bde4b09e3700da7183999eaf137ccc\";s:3:\"img\";s:27:\"goodnewsfeatured/slide1.jpg\";s:7:\"preview\";s:174:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"6.4.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:156;a:29:{s:2:\"id\";s:3:\"159\";s:5:\"title\";s:18:\"GoodNews Spotlight\";s:5:\"alias\";s:17:\"goodnewsspotlight\";s:3:\"zip\";s:27:\"packs/goodnewsspotlight.zip\";s:3:\"uid\";s:32:\"138076241a828e1c5764379944755f2b\";s:3:\"img\";s:28:\"goodnewsspotlight/slide1.jpg\";s:7:\"preview\";s:174:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.4\";s:8:\"required\";s:5:\"6.4.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:157;a:29:{s:2:\"id\";s:3:\"160\";s:5:\"title\";s:17:\"GoodNews Carousel\";s:5:\"alias\";s:16:\"goodnewscarousel\";s:3:\"zip\";s:26:\"packs/goodnewscarousel.zip\";s:3:\"uid\";s:32:\"d29d4460a6015e30d08d2714232d3768\";s:3:\"img\";s:27:\"goodnewscarousel/slide1.jpg\";s:7:\"preview\";s:174:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:8:\"carousel\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:158;a:29:{s:2:\"id\";s:3:\"161\";s:5:\"title\";s:16:\"GoodNews Callout\";s:5:\"alias\";s:15:\"goodnewscallout\";s:3:\"zip\";s:25:\"packs/goodnewscallout.zip\";s:3:\"uid\";s:32:\"d9568b3193e96577fae630b3a6728785\";s:3:\"img\";s:26:\"goodnewscallout/slide1.jpg\";s:7:\"preview\";s:174:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:159;a:29:{s:2:\"id\";s:3:\"162\";s:5:\"title\";s:15:\"GoodNews Footer\";s:5:\"alias\";s:14:\"goodnewsfooter\";s:3:\"zip\";s:24:\"packs/goodnewsfooter.zip\";s:3:\"uid\";s:32:\"34f43f891cb8d55375149dc4bbc38298\";s:3:\"img\";s:25:\"goodnewsfooter/slide1.jpg\";s:7:\"preview\";s:174:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:161;a:29:{s:2:\"id\";s:3:\"164\";s:5:\"title\";s:18:\"GoodNews Menu Back\";s:5:\"alias\";s:16:\"goodnewsmenuback\";s:3:\"zip\";s:26:\"packs/goodnewsmenuback.zip\";s:3:\"uid\";s:32:\"1340d1aeefba497a7d404d12a1fceed4\";s:3:\"img\";s:27:\"goodnewsmenuback/slide1.jpg\";s:7:\"preview\";s:190:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme-content\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:162;a:29:{s:2:\"id\";s:3:\"165\";s:5:\"title\";s:20:\"GoodNews Blog Header\";s:5:\"alias\";s:18:\"goodnewsblogheader\";s:3:\"zip\";s:28:\"packs/goodnewsblogheader.zip\";s:3:\"uid\";s:32:\"abc4d7c1e48475c6def05f1f6d8bf564\";s:3:\"img\";s:29:\"goodnewsblogheader/slide1.jpg\";s:7:\"preview\";s:190:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme-content\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:163;a:29:{s:2:\"id\";s:3:\"166\";s:5:\"title\";s:21:\"GoodNews Blog Content\";s:5:\"alias\";s:19:\"goodnewsblogcontent\";s:3:\"zip\";s:29:\"packs/goodnewsblogcontent.zip\";s:3:\"uid\";s:32:\"bbf34563da6db2779c29599b503b07e9\";s:3:\"img\";s:30:\"goodnewsblogcontent/slide1.jpg\";s:7:\"preview\";s:190:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme-content\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:164;a:29:{s:2:\"id\";s:3:\"167\";s:5:\"title\";s:21:\"GoodNews Testimonials\";s:5:\"alias\";s:20:\"goodnewstestimonials\";s:3:\"zip\";s:30:\"packs/goodnewstestimonials.zip\";s:3:\"uid\";s:32:\"606b7336e86f69c567542d3f43712b56\";s:3:\"img\";s:31:\"goodnewstestimonials/slide1.jpg\";s:7:\"preview\";s:190:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme-content\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:165;a:29:{s:2:\"id\";s:3:\"168\";s:5:\"title\";s:20:\"GoodNews Blog Footer\";s:5:\"alias\";s:18:\"goodnewsblogfooter\";s:3:\"zip\";s:28:\"packs/goodnewsblogfooter.zip\";s:3:\"uid\";s:32:\"1fb88aecfb116fde67ce8d52bd3b5f05\";s:3:\"img\";s:29:\"goodnewsblogfooter/slide1.jpg\";s:7:\"preview\";s:190:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=goodnews-responsive-wordpress-theme-content\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:166;a:26:{s:2:\"id\";s:3:\"169\";s:5:\"title\";s:19:\"Before After Slider\";s:5:\"alias\";s:17:\"beforeafterslider\";s:3:\"zip\";s:21:\"beforeafterslider.zip\";s:3:\"uid\";s:32:\"6e615091a1fc3037c24b985ce5136fb2\";s:3:\"img\";s:28:\"beforeafterslider/slide1.jpg\";s:7:\"preview\";s:142:\"https://revolution.themepunch.com/before-after-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=before-after-slider\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.4.3.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:201:\"<span class=\"ttm_content\">This is the example slider for our Before / After Add-On that allows you to create unique presentations with a comparing functionality.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:320:\"<span class=\"ttm_content\">How to install <a href=\"https://www.themepunch.com/slider-revolution/install-addons/\" target=\"_blank\">Add-Ons</a>.</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-beforeafter-addon\\/revslider-beforeafter-addon.php\",\"name\":\"Before After AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:167;a:24:{s:2:\"id\";s:3:\"170\";s:5:\"title\";s:16:\"Product Showcase\";s:5:\"alias\";s:15:\"productshowcase\";s:3:\"zip\";s:19:\"productshowcase.zip\";s:3:\"uid\";s:32:\"a43447670260aaa7e8ff66cedfddb57a\";s:3:\"img\";s:26:\"productshowcase/slide1.jpg\";s:7:\"preview\";s:170:\"https://revolution.themepunch.com/wordpress-product-showcase-slider/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-product-showcase-slider\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:165:\"<span class=\"ttm_content\">Looking to sell products effectively? Our product showcase slider is just what you are looking for!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:168;a:25:{s:2:\"id\";s:3:\"171\";s:5:\"title\";s:23:\"Overexposure Transition\";s:5:\"alias\";s:22:\"overexposuretransition\";s:3:\"zip\";s:26:\"overexposuretransition.zip\";s:3:\"uid\";s:32:\"13f16bbe6c6d646c7d0cb817a0d3d181\";s:3:\"img\";s:33:\"overexposuretransition/slide1.jpg\";s:7:\"preview\";s:164:\"https://revolution.themepunch.com/overexposure-transition-effect/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=overexposure-transition-effect\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:155:\"<span class=\"ttm_content\">Subtle overexposure transitions and smooth color fade effects make this slider stand out.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:320:\"<span class=\"ttm_content\">How to install <a href=\"https://www.themepunch.com/slider-revolution/install-addons/\" target=\"_blank\">Add-Ons</a>.</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:169;a:24:{s:2:\"id\";s:3:\"172\";s:5:\"title\";s:15:\"Parallax Scroll\";s:5:\"alias\";s:14:\"parallaxscroll\";s:3:\"zip\";s:18:\"parallaxscroll.zip\";s:3:\"uid\";s:32:\"82546ee2f6af6c6682852f495109b3c3\";s:3:\"img\";s:25:\"parallaxscroll/slide1.jpg\";s:7:\"preview\";s:134:\"https://revolution.themepunch.com/parallax-scroll/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=parallax-scroll\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:148:\"<span class=\"ttm_content\">A strikingly colourful header for your website with super smooth parallax effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:171;a:29:{s:2:\"id\";s:3:\"174\";s:5:\"title\";s:11:\"TechCo Menu\";s:5:\"alias\";s:11:\"techco-menu\";s:3:\"zip\";s:21:\"packs/techco-menu.zip\";s:3:\"uid\";s:32:\"55e5efee828cdf1ff7e2d3b90a301ea9\";s:3:\"img\";s:22:\"techco-menu/slide1.jpg\";s:7:\"preview\";s:166:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:172;a:29:{s:2:\"id\";s:3:\"175\";s:5:\"title\";s:13:\"TechCo Header\";s:5:\"alias\";s:13:\"techco-header\";s:3:\"zip\";s:23:\"packs/techco-header.zip\";s:3:\"uid\";s:32:\"fb574d1376de9b1e408c91f51e6497d7\";s:3:\"img\";s:24:\"techco-header/slide1.jpg\";s:7:\"preview\";s:166:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:173;a:29:{s:2:\"id\";s:3:\"176\";s:5:\"title\";s:12:\"TechCo About\";s:5:\"alias\";s:12:\"techco-about\";s:3:\"zip\";s:22:\"packs/techco-about.zip\";s:3:\"uid\";s:32:\"ba216da8231e55118d87e37d2358812c\";s:3:\"img\";s:23:\"techco-about/slide1.jpg\";s:7:\"preview\";s:166:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:174;a:29:{s:2:\"id\";s:3:\"177\";s:5:\"title\";s:15:\"TechCo Services\";s:5:\"alias\";s:15:\"techco-services\";s:3:\"zip\";s:25:\"packs/techco-services.zip\";s:3:\"uid\";s:32:\"ef4a8ddbb5e1136133f7bc1227248e22\";s:3:\"img\";s:26:\"techco-services/slide1.jpg\";s:7:\"preview\";s:166:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:175;a:29:{s:2:\"id\";s:3:\"178\";s:5:\"title\";s:12:\"TechCo Video\";s:5:\"alias\";s:12:\"techco-video\";s:3:\"zip\";s:22:\"packs/techco-video.zip\";s:3:\"uid\";s:32:\"d7bb92281d05f39f9bc9eca71f90e402\";s:3:\"img\";s:23:\"techco-video/slide1.jpg\";s:7:\"preview\";s:166:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:176;a:29:{s:2:\"id\";s:3:\"179\";s:5:\"title\";s:13:\"TechCo Prices\";s:5:\"alias\";s:13:\"techco-prices\";s:3:\"zip\";s:23:\"packs/techco-prices.zip\";s:3:\"uid\";s:32:\"6291f404efbea12bb181352aba71ef11\";s:3:\"img\";s:24:\"techco-prices/slide1.jpg\";s:7:\"preview\";s:166:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:177;a:29:{s:2:\"id\";s:3:\"180\";s:5:\"title\";s:19:\"TechCo Testimonials\";s:5:\"alias\";s:19:\"techco-testimonials\";s:3:\"zip\";s:29:\"packs/techco-testimonials.zip\";s:3:\"uid\";s:32:\"3460bd51f6b80599266fecb7fbb918be\";s:3:\"img\";s:30:\"techco-testimonials/slide1.jpg\";s:7:\"preview\";s:166:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:178;a:29:{s:2:\"id\";s:3:\"181\";s:5:\"title\";s:13:\"TechCo Footer\";s:5:\"alias\";s:13:\"techco-footer\";s:3:\"zip\";s:23:\"packs/techco-footer.zip\";s:3:\"uid\";s:32:\"640abcd549137520461a4a71ff758a3b\";s:3:\"img\";s:24:\"techco-footer/slide1.jpg\";s:7:\"preview\";s:166:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=techco-one-page-wordpress-theme\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:179;a:24:{s:2:\"id\";s:3:\"182\";s:5:\"title\";s:12:\"Live Weather\";s:5:\"alias\";s:7:\"weather\";s:3:\"zip\";s:11:\"weather.zip\";s:3:\"uid\";s:32:\"aab92e69374e4c7b8c6741fe02e574b9\";s:3:\"img\";s:18:\"weather/slide1.jpg\";s:7:\"preview\";s:162:\"https://revolution.themepunch.com/wordpress-live-weather-add-on/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-live-weather-add-on\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:173:\"<span class=\"ttm_content\">Showcasing our weather add-on, this slider show a different cities temperatures and forecast on each slide.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:167:\"[{\"path\":\"revslider-weather-addon\\/revslider-weather-addon.php\",\"name\":\"Live Weather AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:180;a:24:{s:2:\"id\";s:3:\"183\";s:5:\"title\";s:17:\"360 Panorama Tour\";s:5:\"alias\";s:11:\"360panorama\";s:3:\"zip\";s:15:\"360panorama.zip\";s:3:\"uid\";s:32:\"332720fdacdbb38f65e8327a2a96c52d\";s:3:\"img\";s:22:\"360panorama/slide1.jpg\";s:7:\"preview\";s:174:\"https://revolution.themepunch.com/360-degree-real-estate-virtual-tour/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=360-degree-real-estate-virtual-tour\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:155:\"<span class=\"ttm_content\">An example template for our Panorama 360 tour add-on, created for the real estate market.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:165:\"[{\"path\":\"revslider-panorama-addon\\/revslider-panorama-addon.php\",\"name\":\"Panorama AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:181;a:24:{s:2:\"id\";s:3:\"184\";s:5:\"title\";s:14:\"Duotone Add-on\";s:5:\"alias\";s:14:\"duotone-add-on\";s:3:\"zip\";s:18:\"duotone-add-on.zip\";s:3:\"uid\";s:32:\"a428c6f363b3146e96d20a6f44958922\";s:3:\"img\";s:25:\"duotone-add-on/slide1.jpg\";s:7:\"preview\";s:166:\"https://revolution.themepunch.com/wordpress-duotone-effect-add-on/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-duotone-effect-add-on\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:168:\"<span class=\"ttm_content\">This example template showcases 3 of the 30 Duotone filters available in our brand new Duotone Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:350:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"},{\"path\":\"revslider-duotonefilters-addon\\/revslider-duotonefilters-addon.php\",\"name\":\"Duotone AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:182;a:24:{s:2:\"id\";s:3:\"185\";s:5:\"title\";s:13:\"Reveal Add-on\";s:5:\"alias\";s:13:\"reveal-add-on\";s:3:\"zip\";s:17:\"reveal-add-on.zip\";s:3:\"uid\";s:32:\"7fa7525d8ff7fa7365cb98a437e88e32\";s:3:\"img\";s:24:\"reveal-add-on/slide1.jpg\";s:7:\"preview\";s:166:\"https://revolution.themepunch.com/wordpress-content-reveal-effect/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wordpress-content-reveal-effect\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:204:\"<span class=\"ttm_content\">An example template that uses our Reveal Add-On, which adds 14 new preloaders combined with reveal loading effects for any slider or hero.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:337:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"},{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:203;a:28:{s:2:\"id\";s:3:\"212\";s:5:\"title\";s:16:\"Immersion Header\";s:5:\"alias\";s:16:\"immersion_header\";s:3:\"zip\";s:26:\"packs/immersion_header.zip\";s:3:\"uid\";s:32:\"853da51256308b341ecd030bd4883229\";s:3:\"img\";s:27:\"immersion_header/slide1.jpg\";s:7:\"preview\";s:182:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=immersion-wordpress-one-page-theme-2018\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:173:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:204;a:28:{s:2:\"id\";s:3:\"213\";s:5:\"title\";s:19:\"Immersion Mountains\";s:5:\"alias\";s:19:\"immersion-mountains\";s:3:\"zip\";s:29:\"packs/immersion-mountains.zip\";s:3:\"uid\";s:32:\"817167eb3fe22b7e065ba210cbe6d53c\";s:3:\"img\";s:30:\"immersion-mountains/slide1.jpg\";s:7:\"preview\";s:182:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=immersion-wordpress-one-page-theme-2018\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:170:\"[{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:205;a:28:{s:2:\"id\";s:3:\"214\";s:5:\"title\";s:17:\"Immersion Product\";s:5:\"alias\";s:17:\"immersion-product\";s:3:\"zip\";s:27:\"packs/immersion-product.zip\";s:3:\"uid\";s:32:\"64134f263484d2bbcd7ef088ffbbfb4b\";s:3:\"img\";s:28:\"immersion-product/slide1.jpg\";s:7:\"preview\";s:182:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=immersion-wordpress-one-page-theme-2018\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:206;a:28:{s:2:\"id\";s:3:\"215\";s:5:\"title\";s:16:\"Immersion Design\";s:5:\"alias\";s:16:\"immersion-design\";s:3:\"zip\";s:26:\"packs/immersion-design.zip\";s:3:\"uid\";s:32:\"91e1d77c1a2826438763804f4d02bc26\";s:3:\"img\";s:27:\"immersion-design/slide1.jpg\";s:7:\"preview\";s:182:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=immersion-wordpress-one-page-theme-2018\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:207;a:28:{s:2:\"id\";s:3:\"216\";s:5:\"title\";s:22:\"Immersion Phototgraphy\";s:5:\"alias\";s:21:\"immersion-photography\";s:3:\"zip\";s:31:\"packs/immersion-photography.zip\";s:3:\"uid\";s:32:\"e3ddf0c577b09740f5cbf2e38ffd684d\";s:3:\"img\";s:32:\"immersion-photography/slide1.jpg\";s:7:\"preview\";s:182:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=immersion-wordpress-one-page-theme-2018\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:208;a:28:{s:2:\"id\";s:3:\"217\";s:5:\"title\";s:14:\"Immersion Grid\";s:5:\"alias\";s:14:\"immersion-grid\";s:3:\"zip\";s:24:\"packs/immersion-grid.zip\";s:3:\"uid\";s:32:\"b6903868189bb83b2c7a852fde3a7dc3\";s:3:\"img\";s:25:\"immersion-grid/slide1.jpg\";s:7:\"preview\";s:182:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=immersion-wordpress-one-page-theme-2018\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:209;a:26:{s:2:\"id\";s:3:\"218\";s:5:\"title\";s:18:\"Funky Intro Slider\";s:5:\"alias\";s:11:\"funkyslider\";s:3:\"zip\";s:15:\"funkyslider.zip\";s:3:\"uid\";s:32:\"2d4187e3fdad19b976be335253c8925d\";s:3:\"img\";s:22:\"funkyslider/slide1.jpg\";s:7:\"preview\";s:174:\"https://revolution.themepunch.com/funky-intro-slider-wordpress-plugin/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=funky-intro-slider-wordpress-plugin\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:200:\"<span class=\"ttm_content\">This funky intro slider fits just right if you need a striking introduction to your website! Sleek, beautiful and easily customizable!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:335:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"},{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:211;a:29:{s:2:\"id\";s:3:\"220\";s:5:\"title\";s:15:\"Clear View Menu\";s:5:\"alias\";s:14:\"clearview_menu\";s:3:\"zip\";s:24:\"packs/clearview_menu.zip\";s:3:\"uid\";s:32:\"eaecee5fa5f3c3a7f4d2a96c4616a353\";s:3:\"img\";s:25:\"clearview_menu/slide1.jpg\";s:7:\"preview\";s:196:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:212;a:29:{s:2:\"id\";s:3:\"221\";s:5:\"title\";s:17:\"Clear View Header\";s:5:\"alias\";s:16:\"clearview_header\";s:3:\"zip\";s:26:\"packs/clearview_header.zip\";s:3:\"uid\";s:32:\"25e3dd80ad130875d7438a07952cb0cd\";s:3:\"img\";s:27:\"clearview_header/slide1.jpg\";s:7:\"preview\";s:196:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:213;a:29:{s:2:\"id\";s:3:\"222\";s:5:\"title\";s:18:\"Clear View Mission\";s:5:\"alias\";s:17:\"clearview_mission\";s:3:\"zip\";s:27:\"packs/clearview_mission.zip\";s:3:\"uid\";s:32:\"35b2092a49fd2beb549342e69097eb5b\";s:3:\"img\";s:28:\"clearview_mission/slide1.jpg\";s:7:\"preview\";s:196:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:214;a:29:{s:2:\"id\";s:3:\"223\";s:5:\"title\";s:17:\"Clear View Slider\";s:5:\"alias\";s:17:\"clear-view-slider\";s:3:\"zip\";s:27:\"packs/clear-view-slider.zip\";s:3:\"uid\";s:32:\"d2e17edffce16ed78c54b0ef23fd7e05\";s:3:\"img\";s:28:\"clear-view-slider/slide1.jpg\";s:7:\"preview\";s:196:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:215;a:29:{s:2:\"id\";s:3:\"224\";s:5:\"title\";s:15:\"Clear View News\";s:5:\"alias\";s:15:\"clear-view-news\";s:3:\"zip\";s:25:\"packs/clear-view-news.zip\";s:3:\"uid\";s:32:\"5698d3131ba141e9afcfd2906739dd00\";s:3:\"img\";s:26:\"clear-view-news/slide1.jpg\";s:7:\"preview\";s:196:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:216;a:29:{s:2:\"id\";s:3:\"225\";s:5:\"title\";s:18:\"Clear View Clients\";s:5:\"alias\";s:18:\"clear-view-clients\";s:3:\"zip\";s:28:\"packs/clear-view-clients.zip\";s:3:\"uid\";s:32:\"b95616a94832e22bdfac5ce60232be1b\";s:3:\"img\";s:29:\"clear-view-clients/slide1.jpg\";s:7:\"preview\";s:196:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:217;a:29:{s:2:\"id\";s:3:\"226\";s:5:\"title\";s:18:\"Clear View Contact\";s:5:\"alias\";s:18:\"clear-view-contact\";s:3:\"zip\";s:28:\"packs/clear-view-contact.zip\";s:3:\"uid\";s:32:\"0e0cc1d8f6f6500e5f8a2b091fa3b4cb\";s:3:\"img\";s:29:\"clear-view-contact/slide1.jpg\";s:7:\"preview\";s:196:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-minimal-magazine-wordpress-template\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:219;a:29:{s:2:\"id\";s:3:\"228\";s:5:\"title\";s:22:\"Clear View Single Menu\";s:5:\"alias\";s:22:\"clear-view-single-menu\";s:3:\"zip\";s:32:\"packs/clear-view-single-menu.zip\";s:3:\"uid\";s:32:\"1e80f81982f8a4ea763482d4fa99d321\";s:3:\"img\";s:33:\"clear-view-single-menu/slide1.jpg\";s:7:\"preview\";s:196:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-single-post-page-wordpress-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:220;a:29:{s:2:\"id\";s:3:\"229\";s:5:\"title\";s:24:\"Clear View Single Header\";s:5:\"alias\";s:24:\"clear-view-single-header\";s:3:\"zip\";s:34:\"packs/clear-view-single-header.zip\";s:3:\"uid\";s:32:\"c8d717627be6cd5e70922ab609694dbf\";s:3:\"img\";s:35:\"clear-view-single-header/slide1.jpg\";s:7:\"preview\";s:196:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-single-post-page-wordpress-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:221;a:29:{s:2:\"id\";s:3:\"230\";s:5:\"title\";s:23:\"Clear View Single Media\";s:5:\"alias\";s:23:\"clear-view-single-media\";s:3:\"zip\";s:33:\"packs/clear-view-single-media.zip\";s:3:\"uid\";s:32:\"c480368ded2a64f0cdd44f1674213814\";s:3:\"img\";s:34:\"clear-view-single-media/slide1.jpg\";s:7:\"preview\";s:196:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-single-post-page-wordpress-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:222;a:29:{s:2:\"id\";s:3:\"231\";s:5:\"title\";s:22:\"Clear View Single More\";s:5:\"alias\";s:22:\"clear-view-single-more\";s:3:\"zip\";s:32:\"packs/clear-view-single-more.zip\";s:3:\"uid\";s:32:\"9c693190df26218366d1f77e10cf550a\";s:3:\"img\";s:33:\"clear-view-single-more/slide1.jpg\";s:7:\"preview\";s:196:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-single-post-page-wordpress-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:223;a:29:{s:2:\"id\";s:3:\"232\";s:5:\"title\";s:25:\"Clear View Single Contact\";s:5:\"alias\";s:25:\"clear-view-single-contact\";s:3:\"zip\";s:35:\"packs/clear-view-single-contact.zip\";s:3:\"uid\";s:32:\"73c0a889f2b654a87b5aba1ff76fbc5c\";s:3:\"img\";s:36:\"clear-view-single-contact/slide1.jpg\";s:7:\"preview\";s:196:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-view-single-post-page-wordpress-template\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.1.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:224;a:25:{s:2:\"id\";s:3:\"233\";s:5:\"title\";s:18:\"Clean Landing Page\";s:5:\"alias\";s:16:\"cleanlandingpage\";s:3:\"zip\";s:20:\"cleanlandingpage.zip\";s:3:\"uid\";s:32:\"727a3680d312f22c6a5998ebdb9afe52\";s:3:\"img\";s:27:\"cleanlandingpage/slide1.jpg\";s:7:\"preview\";s:168:\"https://revolution.themepunch.com/clean-landing-page-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clean-landing-page-for-wordpress\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:203:\"<span class=\"ttm_content\">The Clean Landing Page is a fullscreen Intro Module that is a striking introduction to any minimal website, with no unnecessary elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:173:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:225;a:25:{s:2:\"id\";s:3:\"234\";s:5:\"title\";s:9:\"Clear Cut\";s:5:\"alias\";s:8:\"clearcut\";s:3:\"zip\";s:12:\"clearcut.zip\";s:3:\"uid\";s:32:\"07f43c00e9b4d3057a03cdb3385ad2b7\";s:3:\"img\";s:19:\"clearcut/slide1.jpg\";s:7:\"preview\";s:186:\"https://revolution.themepunch.com/clear-cut-portfolio-website-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=clear-cut-portfolio-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:240:\"<span class=\"ttm_content\">The Clear Cut Template is an All-In-One Portfolio Website solution that works best for smaller portfolios. Highlight your best work in a striking and mobile friendly fashion!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:227;a:28:{s:2:\"id\";s:3:\"236\";s:5:\"title\";s:17:\"Wonderstruck Menu\";s:5:\"alias\";s:17:\"wonderstruck_menu\";s:3:\"zip\";s:27:\"packs/wonderstruck_menu.zip\";s:3:\"uid\";s:32:\"0a976e9aaae59c4f795b38f59f5a08d8\";s:3:\"img\";s:28:\"wonderstruck_menu/slide1.jpg\";s:7:\"preview\";s:189:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:228;a:28:{s:2:\"id\";s:3:\"237\";s:5:\"title\";s:19:\"Wonderstruck Header\";s:5:\"alias\";s:19:\"wonderstruck_header\";s:3:\"zip\";s:29:\"packs/wonderstruck_header.zip\";s:3:\"uid\";s:32:\"e1379f77a902960a0ce12d44d85a9e0a\";s:3:\"img\";s:30:\"wonderstruck_header/slide1.jpg\";s:7:\"preview\";s:189:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:229;a:28:{s:2:\"id\";s:3:\"238\";s:5:\"title\";s:18:\"Wonderstruck About\";s:5:\"alias\";s:18:\"wonderstruck_about\";s:3:\"zip\";s:28:\"packs/wonderstruck_about.zip\";s:3:\"uid\";s:32:\"d207fb140fd328acc3038300ea52082a\";s:3:\"img\";s:29:\"wonderstruck_about/slide1.jpg\";s:7:\"preview\";s:189:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:230;a:28:{s:2:\"id\";s:3:\"239\";s:5:\"title\";s:18:\"Wonderstruck Works\";s:5:\"alias\";s:18:\"wonderstruck-works\";s:3:\"zip\";s:28:\"packs/wonderstruck-works.zip\";s:3:\"uid\";s:32:\"4476935097e27d92454b0011b7700c1d\";s:3:\"img\";s:29:\"wonderstruck-works/slide1.jpg\";s:7:\"preview\";s:189:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:231;a:28:{s:2:\"id\";s:3:\"240\";s:5:\"title\";s:20:\"Wonderstruck Contact\";s:5:\"alias\";s:20:\"wonderstruck-contact\";s:3:\"zip\";s:30:\"packs/wonderstruck-contact.zip\";s:3:\"uid\";s:32:\"9e4911521f77bce2b8efa40f4c2adc22\";s:3:\"img\";s:31:\"wonderstruck-contact/slide1.jpg\";s:7:\"preview\";s:189:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:232;a:24:{s:2:\"id\";s:3:\"241\";s:5:\"title\";s:12:\"Bubble Morph\";s:5:\"alias\";s:11:\"bubblemorph\";s:3:\"zip\";s:15:\"bubblemorph.zip\";s:3:\"uid\";s:32:\"1102d6f5460ab82cb612cbe9f1d9514b\";s:3:\"img\";s:22:\"bubblemorph/slide1.jpg\";s:7:\"preview\";s:184:\"https://revolution.themepunch.com/bubble-morph-effect-add-on-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=bubble-morph-effect-add-on-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:188:\"<span class=\"ttm_content\">The Bubble Morph Add-On allows you to create interesting Lava-Lamp style effects on any of your Slider Revolution content.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:233;a:24:{s:2:\"id\";s:3:\"242\";s:5:\"title\";s:16:\"Distortion AddOn\";s:5:\"alias\";s:15:\"distortionaddon\";s:3:\"zip\";s:19:\"distortionaddon.zip\";s:3:\"uid\";s:32:\"0ad46c9929bb2fa6316f1e6ced301aaf\";s:3:\"img\";s:26:\"distortionaddon/slide1.jpg\";s:7:\"preview\";s:180:\"https://revolution.themepunch.com/distortion-effect-add-on-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=distortion-effect-add-on-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Distortion Add-On allows you to create interesting Distortion style effects on any of your Slider Revolution content.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:182:\"[{\"path\":\"revslider-liquideffect-addon\\/revslider-liquideffect-addon.php\",\"name\":\"Distortion Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:234;a:24:{s:2:\"id\";s:3:\"243\";s:5:\"title\";s:10:\"Club Flyer\";s:5:\"alias\";s:9:\"clubflyer\";s:3:\"zip\";s:13:\"clubflyer.zip\";s:3:\"uid\";s:32:\"dab73b9904d0e643a35b0475980998bd\";s:3:\"img\";s:20:\"clubflyer/slide1.jpg\";s:7:\"preview\";s:196:\"https://revolution.themepunch.com/club-flyer-landing-page-template-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=club-flyer-landing-page-template-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:227:\"<span class=\"ttm_content\">This Club Fyler Template for Slider Revolution uses the brand new Exploding Layers Add-On to create a captivating effect. Tap into unlimited creative potential. </span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:187:\"[{\"path\":\"revslider-explodinglayers-addon\\/revslider-explodinglayers-addon.php\",\"name\":\"Exploding Layers AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:235;a:25:{s:2:\"id\";s:3:\"244\";s:5:\"title\";s:16:\"Paintbrush AddOn\";s:5:\"alias\";s:15:\"paintbrushaddon\";s:3:\"zip\";s:19:\"paintbrushaddon.zip\";s:3:\"uid\";s:32:\"c85c48a6742b4bf72a2590cc1b50f6a0\";s:3:\"img\";s:26:\"paintbrushaddon/slide1.jpg\";s:7:\"preview\";s:180:\"https://revolution.themepunch.com/paintbrush-effect-add-on-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=paintbrush-effect-add-on-for-wordpress\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"6.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">The Paintbrush Add-On for WordPress allows you to add cool mouse interaction effects to your Slider Revolution content. Examples: Blur Reveal, Color Reveal, Scratch Me Free.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:171:\"[{\"path\":\"revslider-paintbrush-addon\\/revslider-paintbrush-addon.php\",\"name\":\"Paintbrush AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:87:\"How to Add a Unique Paintbrush Effect to Your Website with Slider Revolution [Tutorial]\";s:9:\"guide_url\";s:68:\"https://www.sliderrevolution.com/tutorials/unique-paintbrush-effect/\";s:9:\"guide_img\";s:28:\"tutorial/paintbrushaddon.png\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:237;a:28:{s:2:\"id\";s:3:\"246\";s:5:\"title\";s:15:\"Parallax Header\";s:5:\"alias\";s:15:\"parallax_header\";s:3:\"zip\";s:25:\"packs/parallax_header.zip\";s:3:\"uid\";s:32:\"32bf4a0f5136853bd6bd366275a7a60b\";s:3:\"img\";s:26:\"parallax_header/slide1.jpg\";s:7:\"preview\";s:176:\"https://revolution.themepunch.com/parallax-one-page-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=parallax-one-page-wordpress-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:230:\"<span class=\"ttm_content\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Parallax One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"14\";s:9:\"installed\";b:0;}i:238;a:28:{s:2:\"id\";s:3:\"247\";s:5:\"title\";s:16:\"Parallax Content\";s:5:\"alias\";s:16:\"parallax_content\";s:3:\"zip\";s:26:\"packs/parallax_content.zip\";s:3:\"uid\";s:32:\"a25c5fb8f74757476ab4dc038e56f90d\";s:3:\"img\";s:27:\"parallax_content/slide1.jpg\";s:7:\"preview\";s:176:\"https://revolution.themepunch.com/parallax-one-page-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=parallax-one-page-wordpress-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:230:\"<span class=\"ttm_content\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Parallax One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"14\";s:9:\"installed\";b:0;}i:239;a:28:{s:2:\"id\";s:3:\"248\";s:5:\"title\";s:15:\"Parallax Footer\";s:5:\"alias\";s:15:\"parallax_footer\";s:3:\"zip\";s:25:\"packs/parallax_footer.zip\";s:3:\"uid\";s:32:\"665dff9ea6eaf162a2a1f160f51a9ddb\";s:3:\"img\";s:26:\"parallax_footer/slide1.jpg\";s:7:\"preview\";s:176:\"https://revolution.themepunch.com/parallax-one-page-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=parallax-one-page-wordpress-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:230:\"<span class=\"ttm_content\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Parallax One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"14\";s:9:\"installed\";b:0;}i:241;a:28:{s:2:\"id\";s:3:\"250\";s:5:\"title\";s:12:\"Le Chef Menu\";s:5:\"alias\";s:12:\"le-chef-menu\";s:3:\"zip\";s:22:\"packs/le-chef-menu.zip\";s:3:\"uid\";s:32:\"2f2a6a333431fefe4a7b3b6a982b2ff5\";s:3:\"img\";s:23:\"le-chef-menu/slide1.jpg\";s:7:\"preview\";s:194:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=le-chef-restaurant-website-wordpress-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:242;a:28:{s:2:\"id\";s:3:\"251\";s:5:\"title\";s:14:\"Le Chef Header\";s:5:\"alias\";s:14:\"le-chef-header\";s:3:\"zip\";s:24:\"packs/le-chef-header.zip\";s:3:\"uid\";s:32:\"06450ca3be5a4a8959f3752ab974e574\";s:3:\"img\";s:25:\"le-chef-header/slide1.jpg\";s:7:\"preview\";s:194:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=le-chef-restaurant-website-wordpress-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:243;a:28:{s:2:\"id\";s:3:\"252\";s:5:\"title\";s:18:\"Le Chef Philosophy\";s:5:\"alias\";s:18:\"le-chef-philosophy\";s:3:\"zip\";s:28:\"packs/le-chef-philosophy.zip\";s:3:\"uid\";s:32:\"a532fd029addeb18106e751409b8e20a\";s:3:\"img\";s:29:\"le-chef-philosophy/slide1.jpg\";s:7:\"preview\";s:194:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=le-chef-restaurant-website-wordpress-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:244;a:28:{s:2:\"id\";s:3:\"253\";s:5:\"title\";s:12:\"Le Chef Food\";s:5:\"alias\";s:12:\"le-chef-food\";s:3:\"zip\";s:22:\"packs/le-chef-food.zip\";s:3:\"uid\";s:32:\"cd4b6a2cb5de2dd20a0e8ba0c35451df\";s:3:\"img\";s:23:\"le-chef-food/slide1.jpg\";s:7:\"preview\";s:194:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=le-chef-restaurant-website-wordpress-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:245;a:28:{s:2:\"id\";s:3:\"254\";s:5:\"title\";s:16:\"Le Chef La Carte\";s:5:\"alias\";s:16:\"le-chef-la-carte\";s:3:\"zip\";s:26:\"packs/le-chef-la-carte.zip\";s:3:\"uid\";s:32:\"6f312749679c3ba52c41189a6b8bf729\";s:3:\"img\";s:27:\"le-chef-la-carte/slide1.jpg\";s:7:\"preview\";s:194:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=le-chef-restaurant-website-wordpress-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:246;a:28:{s:2:\"id\";s:3:\"255\";s:5:\"title\";s:14:\"Le Chef Footer\";s:5:\"alias\";s:14:\"le-chef-footer\";s:3:\"zip\";s:24:\"packs/le-chef-footer.zip\";s:3:\"uid\";s:32:\"12fc241e8e5b9e5df9758c43448e2907\";s:3:\"img\";s:25:\"le-chef-footer/slide1.jpg\";s:7:\"preview\";s:194:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=le-chef-restaurant-website-wordpress-template\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:247;a:25:{s:2:\"id\";s:3:\"256\";s:5:\"title\";s:20:\"News Magazine Slider\";s:5:\"alias\";s:20:\"news-magazine-slider\";s:3:\"zip\";s:24:\"news-magazine-slider.zip\";s:3:\"uid\";s:32:\"31f2c1506babb1fef459401f051d2d52\";s:3:\"img\";s:31:\"news-magazine-slider/slide1.jpg\";s:7:\"preview\";s:172:\"https://revolution.themepunch.com/news-magazine-slider-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=news-magazine-slider-for-wordpress\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:205:\"<span class=\"ttm_content\">The Magazine Slider offers various layouts that support static content images, HTML5 and Youtube video. Great for any blog or news website!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;s:6:\"is_new\";b:1;}i:248;a:24:{s:2:\"id\";s:3:\"257\";s:5:\"title\";s:18:\"Real Estate Slider\";s:5:\"alias\";s:18:\"real-estate-slider\";s:3:\"zip\";s:22:\"real-estate-slider.zip\";s:3:\"uid\";s:32:\"739ce6336e46815094387c9448e6c804\";s:3:\"img\";s:29:\"real-estate-slider/slide1.jpg\";s:7:\"preview\";s:168:\"https://revolution.themepunch.com/real-estate-slider-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=real-estate-slider-for-wordpress\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:204:\"<span class=\"ttm_content\">The Real Estate Slider allows to display real estate offers with a large ken burns background image and additional thumbnail hover images.</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:5:\"modal\";s:1:\"0\";s:9:\"additions\";s:0:\"\";s:11:\"guide_title\";s:0:\"\";s:9:\"guide_url\";s:0:\"\";s:9:\"guide_img\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:249;a:24:{s:2:\"id\";s:3:\"258\";s:5:\"title\";s:14:\"Fashion Header\";s:5:\"alias\";s:14:\"fashion-header\";s:3:\"zip\";s:18:\"fashion-header.zip\";s:3:\"uid\";s:32:\"24ece4e7f4d31cd90377c62abbd9e25a\";s:3:\"img\";s:25:\"fashion-header/slide1.jpg\";s:7:\"preview\";s:184:\"https://revolution.themepunch.com/fashion-shop-header-slider-for-wordpress/?utm_source=admin&utm_medium=button&utm_campaign=srusers&utm_content=fashion-shop-header-slider-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:254:\"<span class=\"ttm_content\">The Fashion Shop Header ist the ideal Slider to display as an intro to your shop website or as a separator in between content. Our unique \"Bubble Morph\" effect makes this module stand out!</span>\r\n<span class=\"ttm_space\"></span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/